#! /usr/bin/python

import sys
import os
import shutil
import zipfile

#############################################################
# ZIP support
#############################################################
def ZipDir(top, archive, dir) :
    entries = os.listdir(top)
    for entry in entries: 
        path = os.path.join(top, entry)
        if os.path.isdir(path):
            ZipDir(path, archive, os.path.join(dir, entry))
        else:
            zip_name = os.path.join(dir, entry)
            archive.write(path, zip_name)

def ZipIt(dir) :
    zip_filename = dir+'.zip'
   
    if os.path.exists(zip_filename):
        os.remove(zip_filename)

    archive = zipfile.ZipFile(zip_filename, "w", zipfile.ZIP_DEFLATED)
    ZipDir(dir, archive, dir)
    archive.close()
    
#############################################################
# Main
#############################################################
if not os.environ.has_key('BLUETUNE_KIT_HOME'):
    print 'ERROR: BLUETUNE_KIT_HOME not set'
    sys.exit(1)
BLUETUNE_KIT_HOME = os.environ['BLUETUNE_KIT_HOME']

REVISION = sys.argv[1]
print "Exporting Revision", REVISION

### compute settings
SOURCE_ROOT='BlueTune-SRC-1-2-0-'+REVISION

### export
cmd = 'svn export -r'+REVISION+' https://zebulon.bok.net/svn/BlueTuneKit/trunk '+SOURCE_ROOT
os.system(cmd)

### zip it
ZipIt(SOURCE_ROOT)

### move the output
shutil.move(SOURCE_ROOT+'.zip', BLUETUNE_KIT_HOME+'/..')
shutil.move(SOURCE_ROOT, BLUETUNE_KIT_HOME+'/../'+SOURCE_ROOT)
