/*****************************************************************
|
|   Fluo - Data Tables
|
|   (c) 2002-2006 Gilles Boccon-Gibod
|   Author: Gilles Boccon-Gibod (bok@bok.net)
|
 ****************************************************************/

/*----------------------------------------------------------------------
|   includes
+---------------------------------------------------------------------*/
#include "FloConfig.h"
#include "FloTypes.h"
#include "FloSyntax.h"
#include "FloTables.h"

/*----------------------------------------------------------------------
|   FLO_MpegBitrates
+---------------------------------------------------------------------*/
const unsigned short FLO_MpegBitrates[3][3][16] = {
    /* MPEG2 */
    {
        /* layer I */
        {  
              0,  32,  48,  56,  64,  80,  96, 112, 
            128, 144, 160, 176, 192, 224, 256,   0
        },

        /* layer II */
        {  
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        },

        /* layer III */
        {  
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        }
    },

    /* MPEG1 */
    {
        /* layer I */
        {
              0,  32,  64,  96, 128, 160, 192, 224, 
            256, 288, 320, 352, 384, 416, 448,   0
        },
        
        /* layer II */
        {
              0,  32,  48,  56,  64,  80,  96, 112, 
            128, 160, 192, 224, 256, 320, 384,   0
        },
        
        /* layer III */
        {
              0,  32,  40,  48,  56,  64,  80,  96, 
            112, 128, 160, 192, 224, 256, 320,   0
        },
    },

    /* MPEG2.5 */
    {
        /* layer I */
        {
              0,  32,  48,  56,  64,  80,  96, 112, 
            128, 144, 160, 176, 192, 224, 256,   0
        },

        /* layer II */
        {
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        },

        /* layer III */
        {
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        }
    }
};

/*----------------------------------------------------------------------
|   FLO_MpegSamplingFrequencies
+---------------------------------------------------------------------*/
const unsigned FLO_MpegSamplingFrequencies[3][4] = {
    {22050, 24000, 16000, 0}, /* MPEG2   */
    {44100, 48000, 32000, 0}, /* MPEG1   */
    {11025, 12000,  8000, 0}  /* MPEG2.5 */
};

