/*****************************************************************
|
|    Copyright 2004-2006 Axiomatic Systems LLC
|
|    This file is part of Melo (Melo AAC Decoder).
|
|    Unless you have obtained Melo under a difference license,
|    this version of Melo is Melo|GPL.
|    Melo|GPL is free software; you can redistribute it and/or modify
|    it under the terms of the GNU General Public License as published by
|    the Free Software Foundation; either version 2, or (at your option)
|    any later version.
|
|    Melo|GPL is distributed in the hope that it will be useful,
|    but WITHOUT ANY WARRANTY; without even the implied warranty of
|    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|    GNU General Public License for more details.
|
|    You should have received a copy of the GNU General Public License
|    along with Melo|GPL; see the file COPYING.  If not, write to the
|    Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
|    02111-1307, USA.
|
 ****************************************************************/

/*----------------------------------------------------------------------
|       Includes
+---------------------------------------------------------------------*/
#include "MloDebug.h"
#include "MloFilterBank.h"
#include "MloSampleBuffer.h"
#include "MloUtils.h"

/*----------------------------------------------------------------------
|       Function prototypes
+---------------------------------------------------------------------*/
static void MLO_FilterBank_ApplyWindow (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr);
static void MLO_FilterBank_ApplyWindowLong (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr, int part);
static void MLO_FilterBank_ApplyWindowShort (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr);
static void MLO_FilterBank_ApplyWindowStart (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr);
static void MLO_FilterBank_ApplyWindowStop (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr);
static void MLO_FilterBank_MixFrames (const MLO_FilterBank *fb_ptr, MLO_IndivChnStream *ics_ptr);

/*----------------------------------------------------------------------
|       Data
+---------------------------------------------------------------------*/
enum
{
   MLO_FILTER_BANK_BORDER =
      (MLO_DEFS_FRAME_LEN_LONG - MLO_DEFS_FRAME_LEN_SHORT) / 2
};

static const MLO_Float MloFilterBank_table_long [MLO_ICS_INFO_WINDOW_SHAPE_NBR_ELT] [MLO_DEFS_FRAME_LEN_LONG * 2] =
{
   {
      MLO_FLOAT_C (0.000766990319),
      MLO_FLOAT_C (0.00230096915),
      MLO_FLOAT_C (0.00383494257),
      MLO_FLOAT_C (0.00536890696),
      MLO_FLOAT_C (0.00690285872),
      MLO_FLOAT_C (0.00843679424),
      MLO_FLOAT_C (0.00997070991),
      MLO_FLOAT_C (0.0115046021),
      MLO_FLOAT_C (0.0130384672),
      MLO_FLOAT_C (0.0145723017),
      MLO_FLOAT_C (0.0161061019),
      MLO_FLOAT_C (0.0176398641),
      MLO_FLOAT_C (0.0191735849),
      MLO_FLOAT_C (0.0207072605),
      MLO_FLOAT_C (0.0222408874),
      MLO_FLOAT_C (0.023774462),
      MLO_FLOAT_C (0.0253079806),
      MLO_FLOAT_C (0.0268414397),
      MLO_FLOAT_C (0.0283748356),
      MLO_FLOAT_C (0.0299081648),
      MLO_FLOAT_C (0.0314414235),
      MLO_FLOAT_C (0.0329746083),
      MLO_FLOAT_C (0.0345077155),
      MLO_FLOAT_C (0.0360407415),
      MLO_FLOAT_C (0.0375736827),
      MLO_FLOAT_C (0.0391065355),
      MLO_FLOAT_C (0.0406392962),
      MLO_FLOAT_C (0.0421719614),
      MLO_FLOAT_C (0.0437045273),
      MLO_FLOAT_C (0.0452369903),
      MLO_FLOAT_C (0.0467693469),
      MLO_FLOAT_C (0.0483015934),
      MLO_FLOAT_C (0.0498337263),
      MLO_FLOAT_C (0.051365742),
      MLO_FLOAT_C (0.0528976367),
      MLO_FLOAT_C (0.054429407),
      MLO_FLOAT_C (0.0559610492),
      MLO_FLOAT_C (0.0574925597),
      MLO_FLOAT_C (0.059023935),
      MLO_FLOAT_C (0.0605551713),
      MLO_FLOAT_C (0.0620862652),
      MLO_FLOAT_C (0.063617213),
      MLO_FLOAT_C (0.065148011),
      MLO_FLOAT_C (0.0666786558),
      MLO_FLOAT_C (0.0682091437),
      MLO_FLOAT_C (0.069739471),
      MLO_FLOAT_C (0.0712696343),
      MLO_FLOAT_C (0.0727996298),
      MLO_FLOAT_C (0.0743294541),
      MLO_FLOAT_C (0.0758591034),
      MLO_FLOAT_C (0.0773885743),
      MLO_FLOAT_C (0.078917863),
      MLO_FLOAT_C (0.0804469661),
      MLO_FLOAT_C (0.0819758798),
      MLO_FLOAT_C (0.0835046006),
      MLO_FLOAT_C (0.085033125),
      MLO_FLOAT_C (0.0865614492),
      MLO_FLOAT_C (0.0880895698),
      MLO_FLOAT_C (0.0896174831),
      MLO_FLOAT_C (0.0911451855),
      MLO_FLOAT_C (0.0926726734),
      MLO_FLOAT_C (0.0941999433),
      MLO_FLOAT_C (0.0957269915),
      MLO_FLOAT_C (0.0972538144),
      MLO_FLOAT_C (0.0987804085),
      MLO_FLOAT_C (0.10030677),
      MLO_FLOAT_C (0.101832896),
      MLO_FLOAT_C (0.103358782),
      MLO_FLOAT_C (0.104884425),
      MLO_FLOAT_C (0.106409821),
      MLO_FLOAT_C (0.107934966),
      MLO_FLOAT_C (0.109459858),
      MLO_FLOAT_C (0.110984492),
      MLO_FLOAT_C (0.112508865),
      MLO_FLOAT_C (0.114032973),
      MLO_FLOAT_C (0.115556813),
      MLO_FLOAT_C (0.117080381),
      MLO_FLOAT_C (0.118603673),
      MLO_FLOAT_C (0.120126686),
      MLO_FLOAT_C (0.121649417),
      MLO_FLOAT_C (0.123171861),
      MLO_FLOAT_C (0.124694016),
      MLO_FLOAT_C (0.126215877),
      MLO_FLOAT_C (0.127737441),
      MLO_FLOAT_C (0.129258705),
      MLO_FLOAT_C (0.130779664),
      MLO_FLOAT_C (0.132300316),
      MLO_FLOAT_C (0.133820656),
      MLO_FLOAT_C (0.135340682),
      MLO_FLOAT_C (0.136860389),
      MLO_FLOAT_C (0.138379774),
      MLO_FLOAT_C (0.139898833),
      MLO_FLOAT_C (0.141417563),
      MLO_FLOAT_C (0.14293596),
      MLO_FLOAT_C (0.144454021),
      MLO_FLOAT_C (0.145971742),
      MLO_FLOAT_C (0.14748912),
      MLO_FLOAT_C (0.149006151),
      MLO_FLOAT_C (0.150522831),
      MLO_FLOAT_C (0.152039156),
      MLO_FLOAT_C (0.153555124),
      MLO_FLOAT_C (0.155070731),
      MLO_FLOAT_C (0.156585973),
      MLO_FLOAT_C (0.158100846),
      MLO_FLOAT_C (0.159615347),
      MLO_FLOAT_C (0.161129473),
      MLO_FLOAT_C (0.162643219),
      MLO_FLOAT_C (0.164156583),
      MLO_FLOAT_C (0.165669561),
      MLO_FLOAT_C (0.167182148),
      MLO_FLOAT_C (0.168694343),
      MLO_FLOAT_C (0.17020614),
      MLO_FLOAT_C (0.171717537),
      MLO_FLOAT_C (0.17322853),
      MLO_FLOAT_C (0.174739115),
      MLO_FLOAT_C (0.176249289),
      MLO_FLOAT_C (0.177759048),
      MLO_FLOAT_C (0.179268389),
      MLO_FLOAT_C (0.180777308),
      MLO_FLOAT_C (0.182285802),
      MLO_FLOAT_C (0.183793867),
      MLO_FLOAT_C (0.185301499),
      MLO_FLOAT_C (0.186808695),
      MLO_FLOAT_C (0.188315452),
      MLO_FLOAT_C (0.189821765),
      MLO_FLOAT_C (0.191327632),
      MLO_FLOAT_C (0.192833049),
      MLO_FLOAT_C (0.194338012),
      MLO_FLOAT_C (0.195842517),
      MLO_FLOAT_C (0.197346562),
      MLO_FLOAT_C (0.198850143),
      MLO_FLOAT_C (0.200353255),
      MLO_FLOAT_C (0.201855896),
      MLO_FLOAT_C (0.203358062),
      MLO_FLOAT_C (0.20485975),
      MLO_FLOAT_C (0.206360955),
      MLO_FLOAT_C (0.207861675),
      MLO_FLOAT_C (0.209361906),
      MLO_FLOAT_C (0.210861644),
      MLO_FLOAT_C (0.212360886),
      MLO_FLOAT_C (0.213859628),
      MLO_FLOAT_C (0.215357867),
      MLO_FLOAT_C (0.2168556),
      MLO_FLOAT_C (0.218352822),
      MLO_FLOAT_C (0.21984953),
      MLO_FLOAT_C (0.221345721),
      MLO_FLOAT_C (0.222841391),
      MLO_FLOAT_C (0.224336536),
      MLO_FLOAT_C (0.225831154),
      MLO_FLOAT_C (0.22732524),
      MLO_FLOAT_C (0.228818792),
      MLO_FLOAT_C (0.230311805),
      MLO_FLOAT_C (0.231804276),
      MLO_FLOAT_C (0.233296201),
      MLO_FLOAT_C (0.234787578),
      MLO_FLOAT_C (0.236278402),
      MLO_FLOAT_C (0.23776867),
      MLO_FLOAT_C (0.239258379),
      MLO_FLOAT_C (0.240747525),
      MLO_FLOAT_C (0.242236104),
      MLO_FLOAT_C (0.243724113),
      MLO_FLOAT_C (0.245211549),
      MLO_FLOAT_C (0.246698407),
      MLO_FLOAT_C (0.248184685),
      MLO_FLOAT_C (0.24967038),
      MLO_FLOAT_C (0.251155486),
      MLO_FLOAT_C (0.252640002),
      MLO_FLOAT_C (0.254123923),
      MLO_FLOAT_C (0.255607246),
      MLO_FLOAT_C (0.257089968),
      MLO_FLOAT_C (0.258572085),
      MLO_FLOAT_C (0.260053593),
      MLO_FLOAT_C (0.261534489),
      MLO_FLOAT_C (0.26301477),
      MLO_FLOAT_C (0.264494432),
      MLO_FLOAT_C (0.265973472),
      MLO_FLOAT_C (0.267451886),
      MLO_FLOAT_C (0.26892967),
      MLO_FLOAT_C (0.270406822),
      MLO_FLOAT_C (0.271883337),
      MLO_FLOAT_C (0.273359213),
      MLO_FLOAT_C (0.274834445),
      MLO_FLOAT_C (0.276309031),
      MLO_FLOAT_C (0.277782967),
      MLO_FLOAT_C (0.279256248),
      MLO_FLOAT_C (0.280728873),
      MLO_FLOAT_C (0.282200837),
      MLO_FLOAT_C (0.283672137),
      MLO_FLOAT_C (0.28514277),
      MLO_FLOAT_C (0.286612731),
      MLO_FLOAT_C (0.288082019),
      MLO_FLOAT_C (0.289550628),
      MLO_FLOAT_C (0.291018556),
      MLO_FLOAT_C (0.292485799),
      MLO_FLOAT_C (0.293952354),
      MLO_FLOAT_C (0.295418217),
      MLO_FLOAT_C (0.296883385),
      MLO_FLOAT_C (0.298347855),
      MLO_FLOAT_C (0.299811622),
      MLO_FLOAT_C (0.301274684),
      MLO_FLOAT_C (0.302737037),
      MLO_FLOAT_C (0.304198678),
      MLO_FLOAT_C (0.305659602),
      MLO_FLOAT_C (0.307119808),
      MLO_FLOAT_C (0.308579291),
      MLO_FLOAT_C (0.310038048),
      MLO_FLOAT_C (0.311496075),
      MLO_FLOAT_C (0.312953369),
      MLO_FLOAT_C (0.314409927),
      MLO_FLOAT_C (0.315865745),
      MLO_FLOAT_C (0.31732082),
      MLO_FLOAT_C (0.318775148),
      MLO_FLOAT_C (0.320228726),
      MLO_FLOAT_C (0.32168155),
      MLO_FLOAT_C (0.323133618),
      MLO_FLOAT_C (0.324584925),
      MLO_FLOAT_C (0.326035468),
      MLO_FLOAT_C (0.327485244),
      MLO_FLOAT_C (0.32893425),
      MLO_FLOAT_C (0.330382481),
      MLO_FLOAT_C (0.331829935),
      MLO_FLOAT_C (0.333276609),
      MLO_FLOAT_C (0.334722498),
      MLO_FLOAT_C (0.336167599),
      MLO_FLOAT_C (0.337611909),
      MLO_FLOAT_C (0.339055425),
      MLO_FLOAT_C (0.340498144),
      MLO_FLOAT_C (0.34194006),
      MLO_FLOAT_C (0.343381173),
      MLO_FLOAT_C (0.344821477),
      MLO_FLOAT_C (0.34626097),
      MLO_FLOAT_C (0.347699648),
      MLO_FLOAT_C (0.349137508),
      MLO_FLOAT_C (0.350574546),
      MLO_FLOAT_C (0.352010759),
      MLO_FLOAT_C (0.353446145),
      MLO_FLOAT_C (0.354880698),
      MLO_FLOAT_C (0.356314416),
      MLO_FLOAT_C (0.357747296),
      MLO_FLOAT_C (0.359179334),
      MLO_FLOAT_C (0.360610527),
      MLO_FLOAT_C (0.362040871),
      MLO_FLOAT_C (0.363470364),
      MLO_FLOAT_C (0.364899001),
      MLO_FLOAT_C (0.36632678),
      MLO_FLOAT_C (0.367753696),
      MLO_FLOAT_C (0.369179747),
      MLO_FLOAT_C (0.37060493),
      MLO_FLOAT_C (0.37202924),
      MLO_FLOAT_C (0.373452675),
      MLO_FLOAT_C (0.374875231),
      MLO_FLOAT_C (0.376296905),
      MLO_FLOAT_C (0.377717694),
      MLO_FLOAT_C (0.379137593),
      MLO_FLOAT_C (0.380556601),
      MLO_FLOAT_C (0.381974713),
      MLO_FLOAT_C (0.383391926),
      MLO_FLOAT_C (0.384808238),
      MLO_FLOAT_C (0.386223643),
      MLO_FLOAT_C (0.38763814),
      MLO_FLOAT_C (0.389051725),
      MLO_FLOAT_C (0.390464394),
      MLO_FLOAT_C (0.391876144),
      MLO_FLOAT_C (0.393286973),
      MLO_FLOAT_C (0.394696876),
      MLO_FLOAT_C (0.39610585),
      MLO_FLOAT_C (0.397513892),
      MLO_FLOAT_C (0.398920998),
      MLO_FLOAT_C (0.400327166),
      MLO_FLOAT_C (0.401732392),
      MLO_FLOAT_C (0.403136673),
      MLO_FLOAT_C (0.404540005),
      MLO_FLOAT_C (0.405942385),
      MLO_FLOAT_C (0.40734381),
      MLO_FLOAT_C (0.408744276),
      MLO_FLOAT_C (0.410143781),
      MLO_FLOAT_C (0.41154232),
      MLO_FLOAT_C (0.412939891),
      MLO_FLOAT_C (0.41433649),
      MLO_FLOAT_C (0.415732115),
      MLO_FLOAT_C (0.417126761),
      MLO_FLOAT_C (0.418520425),
      MLO_FLOAT_C (0.419913105),
      MLO_FLOAT_C (0.421304797),
      MLO_FLOAT_C (0.422695497),
      MLO_FLOAT_C (0.424085202),
      MLO_FLOAT_C (0.42547391),
      MLO_FLOAT_C (0.426861617),
      MLO_FLOAT_C (0.428248319),
      MLO_FLOAT_C (0.429634013),
      MLO_FLOAT_C (0.431018696),
      MLO_FLOAT_C (0.432402366),
      MLO_FLOAT_C (0.433785017),
      MLO_FLOAT_C (0.435166648),
      MLO_FLOAT_C (0.436547255),
      MLO_FLOAT_C (0.437926835),
      MLO_FLOAT_C (0.439305384),
      MLO_FLOAT_C (0.4406829),
      MLO_FLOAT_C (0.442059378),
      MLO_FLOAT_C (0.443434816),
      MLO_FLOAT_C (0.444809211),
      MLO_FLOAT_C (0.44618256),
      MLO_FLOAT_C (0.447554858),
      MLO_FLOAT_C (0.448926103),
      MLO_FLOAT_C (0.450296292),
      MLO_FLOAT_C (0.451665421),
      MLO_FLOAT_C (0.453033487),
      MLO_FLOAT_C (0.454400488),
      MLO_FLOAT_C (0.455766419),
      MLO_FLOAT_C (0.457131277),
      MLO_FLOAT_C (0.45849506),
      MLO_FLOAT_C (0.459857765),
      MLO_FLOAT_C (0.461219386),
      MLO_FLOAT_C (0.462579923),
      MLO_FLOAT_C (0.463939371),
      MLO_FLOAT_C (0.465297728),
      MLO_FLOAT_C (0.46665499),
      MLO_FLOAT_C (0.468011153),
      MLO_FLOAT_C (0.469366215),
      MLO_FLOAT_C (0.470720173),
      MLO_FLOAT_C (0.472073023),
      MLO_FLOAT_C (0.473424763),
      MLO_FLOAT_C (0.474775388),
      MLO_FLOAT_C (0.476124896),
      MLO_FLOAT_C (0.477473284),
      MLO_FLOAT_C (0.478820548),
      MLO_FLOAT_C (0.480166685),
      MLO_FLOAT_C (0.481511693),
      MLO_FLOAT_C (0.482855568),
      MLO_FLOAT_C (0.484198306),
      MLO_FLOAT_C (0.485539905),
      MLO_FLOAT_C (0.486880361),
      MLO_FLOAT_C (0.488219672),
      MLO_FLOAT_C (0.489557834),
      MLO_FLOAT_C (0.490894844),
      MLO_FLOAT_C (0.492230699),
      MLO_FLOAT_C (0.493565396),
      MLO_FLOAT_C (0.494898931),
      MLO_FLOAT_C (0.496231301),
      MLO_FLOAT_C (0.497562504),
      MLO_FLOAT_C (0.498892537),
      MLO_FLOAT_C (0.500221395),
      MLO_FLOAT_C (0.501549076),
      MLO_FLOAT_C (0.502875577),
      MLO_FLOAT_C (0.504200894),
      MLO_FLOAT_C (0.505525026),
      MLO_FLOAT_C (0.506847967),
      MLO_FLOAT_C (0.508169716),
      MLO_FLOAT_C (0.509490269),
      MLO_FLOAT_C (0.510809624),
      MLO_FLOAT_C (0.512127776),
      MLO_FLOAT_C (0.513444723),
      MLO_FLOAT_C (0.514760463),
      MLO_FLOAT_C (0.51607499),
      MLO_FLOAT_C (0.517388304),
      MLO_FLOAT_C (0.5187004),
      MLO_FLOAT_C (0.520011275),
      MLO_FLOAT_C (0.521320927),
      MLO_FLOAT_C (0.522629352),
      MLO_FLOAT_C (0.523936547),
      MLO_FLOAT_C (0.52524251),
      MLO_FLOAT_C (0.526547236),
      MLO_FLOAT_C (0.527850723),
      MLO_FLOAT_C (0.529152969),
      MLO_FLOAT_C (0.530453969),
      MLO_FLOAT_C (0.531753721),
      MLO_FLOAT_C (0.533052222),
      MLO_FLOAT_C (0.534349468),
      MLO_FLOAT_C (0.535645457),
      MLO_FLOAT_C (0.536940186),
      MLO_FLOAT_C (0.538233651),
      MLO_FLOAT_C (0.539525849),
      MLO_FLOAT_C (0.540816778),
      MLO_FLOAT_C (0.542106435),
      MLO_FLOAT_C (0.543394816),
      MLO_FLOAT_C (0.544681918),
      MLO_FLOAT_C (0.545967738),
      MLO_FLOAT_C (0.547252274),
      MLO_FLOAT_C (0.548535522),
      MLO_FLOAT_C (0.549817479),
      MLO_FLOAT_C (0.551098143),
      MLO_FLOAT_C (0.552377509),
      MLO_FLOAT_C (0.553655576),
      MLO_FLOAT_C (0.55493234),
      MLO_FLOAT_C (0.556207799),
      MLO_FLOAT_C (0.557481948),
      MLO_FLOAT_C (0.558754786),
      MLO_FLOAT_C (0.560026309),
      MLO_FLOAT_C (0.561296514),
      MLO_FLOAT_C (0.562565398),
      MLO_FLOAT_C (0.563832959),
      MLO_FLOAT_C (0.565099192),
      MLO_FLOAT_C (0.566364096),
      MLO_FLOAT_C (0.567627668),
      MLO_FLOAT_C (0.568889903),
      MLO_FLOAT_C (0.5701508),
      MLO_FLOAT_C (0.571410356),
      MLO_FLOAT_C (0.572668566),
      MLO_FLOAT_C (0.57392543),
      MLO_FLOAT_C (0.575180942),
      MLO_FLOAT_C (0.576435102),
      MLO_FLOAT_C (0.577687905),
      MLO_FLOAT_C (0.578939348),
      MLO_FLOAT_C (0.580189429),
      MLO_FLOAT_C (0.581438145),
      MLO_FLOAT_C (0.582685493),
      MLO_FLOAT_C (0.58393147),
      MLO_FLOAT_C (0.585176072),
      MLO_FLOAT_C (0.586419298),
      MLO_FLOAT_C (0.587661144),
      MLO_FLOAT_C (0.588901607),
      MLO_FLOAT_C (0.590140684),
      MLO_FLOAT_C (0.591378372),
      MLO_FLOAT_C (0.592614669),
      MLO_FLOAT_C (0.593849572),
      MLO_FLOAT_C (0.595083077),
      MLO_FLOAT_C (0.596315182),
      MLO_FLOAT_C (0.597545883),
      MLO_FLOAT_C (0.598775179),
      MLO_FLOAT_C (0.600003065),
      MLO_FLOAT_C (0.60122954),
      MLO_FLOAT_C (0.6024546),
      MLO_FLOAT_C (0.603678242),
      MLO_FLOAT_C (0.604900464),
      MLO_FLOAT_C (0.606121263),
      MLO_FLOAT_C (0.607340635),
      MLO_FLOAT_C (0.608558578),
      MLO_FLOAT_C (0.609775089),
      MLO_FLOAT_C (0.610990165),
      MLO_FLOAT_C (0.612203803),
      MLO_FLOAT_C (0.613416001),
      MLO_FLOAT_C (0.614626756),
      MLO_FLOAT_C (0.615836064),
      MLO_FLOAT_C (0.617043923),
      MLO_FLOAT_C (0.61825033),
      MLO_FLOAT_C (0.619455282),
      MLO_FLOAT_C (0.620658777),
      MLO_FLOAT_C (0.621860811),
      MLO_FLOAT_C (0.623061382),
      MLO_FLOAT_C (0.624260486),
      MLO_FLOAT_C (0.625458122),
      MLO_FLOAT_C (0.626654286),
      MLO_FLOAT_C (0.627848976),
      MLO_FLOAT_C (0.629042188),
      MLO_FLOAT_C (0.63023392),
      MLO_FLOAT_C (0.631424169),
      MLO_FLOAT_C (0.632612932),
      MLO_FLOAT_C (0.633800206),
      MLO_FLOAT_C (0.634985989),
      MLO_FLOAT_C (0.636170278),
      MLO_FLOAT_C (0.63735307),
      MLO_FLOAT_C (0.638534362),
      MLO_FLOAT_C (0.639714152),
      MLO_FLOAT_C (0.640892436),
      MLO_FLOAT_C (0.642069212),
      MLO_FLOAT_C (0.643244478),
      MLO_FLOAT_C (0.644418229),
      MLO_FLOAT_C (0.645590465),
      MLO_FLOAT_C (0.646761181),
      MLO_FLOAT_C (0.647930375),
      MLO_FLOAT_C (0.649098045),
      MLO_FLOAT_C (0.650264187),
      MLO_FLOAT_C (0.6514288),
      MLO_FLOAT_C (0.652591879),
      MLO_FLOAT_C (0.653753423),
      MLO_FLOAT_C (0.654913428),
      MLO_FLOAT_C (0.656071892),
      MLO_FLOAT_C (0.657228813),
      MLO_FLOAT_C (0.658384187),
      MLO_FLOAT_C (0.659538012),
      MLO_FLOAT_C (0.660690284),
      MLO_FLOAT_C (0.661841002),
      MLO_FLOAT_C (0.662990163),
      MLO_FLOAT_C (0.664137764),
      MLO_FLOAT_C (0.665283802),
      MLO_FLOAT_C (0.666428274),
      MLO_FLOAT_C (0.667571178),
      MLO_FLOAT_C (0.668712512),
      MLO_FLOAT_C (0.669852271),
      MLO_FLOAT_C (0.670990455),
      MLO_FLOAT_C (0.67212706),
      MLO_FLOAT_C (0.673262083),
      MLO_FLOAT_C (0.674395522),
      MLO_FLOAT_C (0.675527374),
      MLO_FLOAT_C (0.676657636),
      MLO_FLOAT_C (0.677786306),
      MLO_FLOAT_C (0.678913381),
      MLO_FLOAT_C (0.680038859),
      MLO_FLOAT_C (0.681162736),
      MLO_FLOAT_C (0.682285011),
      MLO_FLOAT_C (0.68340568),
      MLO_FLOAT_C (0.684524741),
      MLO_FLOAT_C (0.685642191),
      MLO_FLOAT_C (0.686758028),
      MLO_FLOAT_C (0.687872249),
      MLO_FLOAT_C (0.688984851),
      MLO_FLOAT_C (0.690095832),
      MLO_FLOAT_C (0.69120519),
      MLO_FLOAT_C (0.69231292),
      MLO_FLOAT_C (0.693419022),
      MLO_FLOAT_C (0.694523492),
      MLO_FLOAT_C (0.695626327),
      MLO_FLOAT_C (0.696727526),
      MLO_FLOAT_C (0.697827085),
      MLO_FLOAT_C (0.698925003),
      MLO_FLOAT_C (0.700021275),
      MLO_FLOAT_C (0.701115901),
      MLO_FLOAT_C (0.702208876),
      MLO_FLOAT_C (0.703300199),
      MLO_FLOAT_C (0.704389868),
      MLO_FLOAT_C (0.705477878),
      MLO_FLOAT_C (0.706564229),
      MLO_FLOAT_C (0.707648917),
      MLO_FLOAT_C (0.70873194),
      MLO_FLOAT_C (0.709813295),
      MLO_FLOAT_C (0.71089298),
      MLO_FLOAT_C (0.711970993),
      MLO_FLOAT_C (0.713047329),
      MLO_FLOAT_C (0.714121988),
      MLO_FLOAT_C (0.715194967),
      MLO_FLOAT_C (0.716266263),
      MLO_FLOAT_C (0.717335873),
      MLO_FLOAT_C (0.718403795),
      MLO_FLOAT_C (0.719470027),
      MLO_FLOAT_C (0.720534566),
      MLO_FLOAT_C (0.721597409),
      MLO_FLOAT_C (0.722658554),
      MLO_FLOAT_C (0.723717999),
      MLO_FLOAT_C (0.724775741),
      MLO_FLOAT_C (0.725831777),
      MLO_FLOAT_C (0.726886106),
      MLO_FLOAT_C (0.727938724),
      MLO_FLOAT_C (0.728989629),
      MLO_FLOAT_C (0.730038818),
      MLO_FLOAT_C (0.73108629),
      MLO_FLOAT_C (0.732132042),
      MLO_FLOAT_C (0.733176071),
      MLO_FLOAT_C (0.734218374),
      MLO_FLOAT_C (0.73525895),
      MLO_FLOAT_C (0.736297796),
      MLO_FLOAT_C (0.737334909),
      MLO_FLOAT_C (0.738370287),
      MLO_FLOAT_C (0.739403927),
      MLO_FLOAT_C (0.740435828),
      MLO_FLOAT_C (0.741465987),
      MLO_FLOAT_C (0.7424944),
      MLO_FLOAT_C (0.743521067),
      MLO_FLOAT_C (0.744545984),
      MLO_FLOAT_C (0.745569149),
      MLO_FLOAT_C (0.746590559),
      MLO_FLOAT_C (0.747610213),
      MLO_FLOAT_C (0.748628108),
      MLO_FLOAT_C (0.749644241),
      MLO_FLOAT_C (0.75065861),
      MLO_FLOAT_C (0.751671212),
      MLO_FLOAT_C (0.752682046),
      MLO_FLOAT_C (0.753691109),
      MLO_FLOAT_C (0.754698398),
      MLO_FLOAT_C (0.755703911),
      MLO_FLOAT_C (0.756707647),
      MLO_FLOAT_C (0.757709601),
      MLO_FLOAT_C (0.758709773),
      MLO_FLOAT_C (0.759708159),
      MLO_FLOAT_C (0.760704757),
      MLO_FLOAT_C (0.761699566),
      MLO_FLOAT_C (0.762692582),
      MLO_FLOAT_C (0.763683804),
      MLO_FLOAT_C (0.764673228),
      MLO_FLOAT_C (0.765660853),
      MLO_FLOAT_C (0.766646677),
      MLO_FLOAT_C (0.767630696),
      MLO_FLOAT_C (0.768612909),
      MLO_FLOAT_C (0.769593314),
      MLO_FLOAT_C (0.770571907),
      MLO_FLOAT_C (0.771548688),
      MLO_FLOAT_C (0.772523652),
      MLO_FLOAT_C (0.773496799),
      MLO_FLOAT_C (0.774468126),
      MLO_FLOAT_C (0.775437631),
      MLO_FLOAT_C (0.776405311),
      MLO_FLOAT_C (0.777371164),
      MLO_FLOAT_C (0.778335187),
      MLO_FLOAT_C (0.779297379),
      MLO_FLOAT_C (0.780257738),
      MLO_FLOAT_C (0.78121626),
      MLO_FLOAT_C (0.782172944),
      MLO_FLOAT_C (0.783127788),
      MLO_FLOAT_C (0.784080789),
      MLO_FLOAT_C (0.785031944),
      MLO_FLOAT_C (0.785981253),
      MLO_FLOAT_C (0.786928712),
      MLO_FLOAT_C (0.787874319),
      MLO_FLOAT_C (0.788818072),
      MLO_FLOAT_C (0.78975997),
      MLO_FLOAT_C (0.790700008),
      MLO_FLOAT_C (0.791638187),
      MLO_FLOAT_C (0.792574502),
      MLO_FLOAT_C (0.793508952),
      MLO_FLOAT_C (0.794441536),
      MLO_FLOAT_C (0.795372249),
      MLO_FLOAT_C (0.796301092),
      MLO_FLOAT_C (0.79722806),
      MLO_FLOAT_C (0.798153153),
      MLO_FLOAT_C (0.799076367),
      MLO_FLOAT_C (0.799997701),
      MLO_FLOAT_C (0.800917153),
      MLO_FLOAT_C (0.801834719),
      MLO_FLOAT_C (0.8027504),
      MLO_FLOAT_C (0.803664191),
      MLO_FLOAT_C (0.804576091),
      MLO_FLOAT_C (0.805486098),
      MLO_FLOAT_C (0.806394209),
      MLO_FLOAT_C (0.807300423),
      MLO_FLOAT_C (0.808204737),
      MLO_FLOAT_C (0.80910715),
      MLO_FLOAT_C (0.810007659),
      MLO_FLOAT_C (0.810906261),
      MLO_FLOAT_C (0.811802956),
      MLO_FLOAT_C (0.81269774),
      MLO_FLOAT_C (0.813590612),
      MLO_FLOAT_C (0.814481569),
      MLO_FLOAT_C (0.81537061),
      MLO_FLOAT_C (0.816257732),
      MLO_FLOAT_C (0.817142933),
      MLO_FLOAT_C (0.818026212),
      MLO_FLOAT_C (0.818907566),
      MLO_FLOAT_C (0.819786992),
      MLO_FLOAT_C (0.82066449),
      MLO_FLOAT_C (0.821540057),
      MLO_FLOAT_C (0.82241369),
      MLO_FLOAT_C (0.823285388),
      MLO_FLOAT_C (0.824155149),
      MLO_FLOAT_C (0.825022971),
      MLO_FLOAT_C (0.825888851),
      MLO_FLOAT_C (0.826752788),
      MLO_FLOAT_C (0.82761478),
      MLO_FLOAT_C (0.828474824),
      MLO_FLOAT_C (0.829332918),
      MLO_FLOAT_C (0.830189061),
      MLO_FLOAT_C (0.831043251),
      MLO_FLOAT_C (0.831895485),
      MLO_FLOAT_C (0.832745761),
      MLO_FLOAT_C (0.833594078),
      MLO_FLOAT_C (0.834440433),
      MLO_FLOAT_C (0.835284825),
      MLO_FLOAT_C (0.836127252),
      MLO_FLOAT_C (0.836967711),
      MLO_FLOAT_C (0.8378062),
      MLO_FLOAT_C (0.838642718),
      MLO_FLOAT_C (0.839477263),
      MLO_FLOAT_C (0.840309832),
      MLO_FLOAT_C (0.841140424),
      MLO_FLOAT_C (0.841969036),
      MLO_FLOAT_C (0.842795668),
      MLO_FLOAT_C (0.843620316),
      MLO_FLOAT_C (0.844442979),
      MLO_FLOAT_C (0.845263655),
      MLO_FLOAT_C (0.846082342),
      MLO_FLOAT_C (0.846899038),
      MLO_FLOAT_C (0.847713741),
      MLO_FLOAT_C (0.84852645),
      MLO_FLOAT_C (0.849337161),
      MLO_FLOAT_C (0.850145875),
      MLO_FLOAT_C (0.850952587),
      MLO_FLOAT_C (0.851757298),
      MLO_FLOAT_C (0.852560004),
      MLO_FLOAT_C (0.853360704),
      MLO_FLOAT_C (0.854159396),
      MLO_FLOAT_C (0.854956078),
      MLO_FLOAT_C (0.855750748),
      MLO_FLOAT_C (0.856543405),
      MLO_FLOAT_C (0.857334046),
      MLO_FLOAT_C (0.85812267),
      MLO_FLOAT_C (0.858909274),
      MLO_FLOAT_C (0.859693857),
      MLO_FLOAT_C (0.860476418),
      MLO_FLOAT_C (0.861256953),
      MLO_FLOAT_C (0.862035462),
      MLO_FLOAT_C (0.862811943),
      MLO_FLOAT_C (0.863586393),
      MLO_FLOAT_C (0.864358811),
      MLO_FLOAT_C (0.865129195),
      MLO_FLOAT_C (0.865897544),
      MLO_FLOAT_C (0.866663855),
      MLO_FLOAT_C (0.867428126),
      MLO_FLOAT_C (0.868190357),
      MLO_FLOAT_C (0.868950544),
      MLO_FLOAT_C (0.869708687),
      MLO_FLOAT_C (0.870464783),
      MLO_FLOAT_C (0.871218831),
      MLO_FLOAT_C (0.871970829),
      MLO_FLOAT_C (0.872720775),
      MLO_FLOAT_C (0.873468668),
      MLO_FLOAT_C (0.874214505),
      MLO_FLOAT_C (0.874958285),
      MLO_FLOAT_C (0.875700006),
      MLO_FLOAT_C (0.876439667),
      MLO_FLOAT_C (0.877177265),
      MLO_FLOAT_C (0.877912799),
      MLO_FLOAT_C (0.878646267),
      MLO_FLOAT_C (0.879377668),
      MLO_FLOAT_C (0.880107),
      MLO_FLOAT_C (0.88083426),
      MLO_FLOAT_C (0.881559448),
      MLO_FLOAT_C (0.882282562),
      MLO_FLOAT_C (0.883003599),
      MLO_FLOAT_C (0.883722559),
      MLO_FLOAT_C (0.884439439),
      MLO_FLOAT_C (0.885154238),
      MLO_FLOAT_C (0.885866954),
      MLO_FLOAT_C (0.886577585),
      MLO_FLOAT_C (0.887286131),
      MLO_FLOAT_C (0.887992588),
      MLO_FLOAT_C (0.888696956),
      MLO_FLOAT_C (0.889399233),
      MLO_FLOAT_C (0.890099417),
      MLO_FLOAT_C (0.890797506),
      MLO_FLOAT_C (0.891493499),
      MLO_FLOAT_C (0.892187395),
      MLO_FLOAT_C (0.892879191),
      MLO_FLOAT_C (0.893568886),
      MLO_FLOAT_C (0.894256478),
      MLO_FLOAT_C (0.894941967),
      MLO_FLOAT_C (0.895625349),
      MLO_FLOAT_C (0.896306624),
      MLO_FLOAT_C (0.896985789),
      MLO_FLOAT_C (0.897662844),
      MLO_FLOAT_C (0.898337787),
      MLO_FLOAT_C (0.899010616),
      MLO_FLOAT_C (0.899681329),
      MLO_FLOAT_C (0.900349925),
      MLO_FLOAT_C (0.901016403),
      MLO_FLOAT_C (0.901680761),
      MLO_FLOAT_C (0.902342996),
      MLO_FLOAT_C (0.903003109),
      MLO_FLOAT_C (0.903661097),
      MLO_FLOAT_C (0.904316958),
      MLO_FLOAT_C (0.904970691),
      MLO_FLOAT_C (0.905622295),
      MLO_FLOAT_C (0.906271768),
      MLO_FLOAT_C (0.906919108),
      MLO_FLOAT_C (0.907564314),
      MLO_FLOAT_C (0.908207385),
      MLO_FLOAT_C (0.908848318),
      MLO_FLOAT_C (0.909487113),
      MLO_FLOAT_C (0.910123768),
      MLO_FLOAT_C (0.910758281),
      MLO_FLOAT_C (0.911390651),
      MLO_FLOAT_C (0.912020877),
      MLO_FLOAT_C (0.912648956),
      MLO_FLOAT_C (0.913274888),
      MLO_FLOAT_C (0.913898671),
      MLO_FLOAT_C (0.914520303),
      MLO_FLOAT_C (0.915139783),
      MLO_FLOAT_C (0.91575711),
      MLO_FLOAT_C (0.916372282),
      MLO_FLOAT_C (0.916985298),
      MLO_FLOAT_C (0.917596156),
      MLO_FLOAT_C (0.918204855),
      MLO_FLOAT_C (0.918811393),
      MLO_FLOAT_C (0.919415769),
      MLO_FLOAT_C (0.920017982),
      MLO_FLOAT_C (0.92061803),
      MLO_FLOAT_C (0.921215911),
      MLO_FLOAT_C (0.921811625),
      MLO_FLOAT_C (0.92240517),
      MLO_FLOAT_C (0.922996544),
      MLO_FLOAT_C (0.923585746),
      MLO_FLOAT_C (0.924172775),
      MLO_FLOAT_C (0.92475763),
      MLO_FLOAT_C (0.925340308),
      MLO_FLOAT_C (0.925920809),
      MLO_FLOAT_C (0.926499131),
      MLO_FLOAT_C (0.927075273),
      MLO_FLOAT_C (0.927649233),
      MLO_FLOAT_C (0.928221011),
      MLO_FLOAT_C (0.928790604),
      MLO_FLOAT_C (0.929358012),
      MLO_FLOAT_C (0.929923233),
      MLO_FLOAT_C (0.930486266),
      MLO_FLOAT_C (0.931047109),
      MLO_FLOAT_C (0.931605761),
      MLO_FLOAT_C (0.932162222),
      MLO_FLOAT_C (0.932716488),
      MLO_FLOAT_C (0.93326856),
      MLO_FLOAT_C (0.933818436),
      MLO_FLOAT_C (0.934366115),
      MLO_FLOAT_C (0.934911595),
      MLO_FLOAT_C (0.935454875),
      MLO_FLOAT_C (0.935995954),
      MLO_FLOAT_C (0.93653483),
      MLO_FLOAT_C (0.937071502),
      MLO_FLOAT_C (0.93760597),
      MLO_FLOAT_C (0.938138231),
      MLO_FLOAT_C (0.938668285),
      MLO_FLOAT_C (0.93919613),
      MLO_FLOAT_C (0.939721765),
      MLO_FLOAT_C (0.940245188),
      MLO_FLOAT_C (0.9407664),
      MLO_FLOAT_C (0.941285397),
      MLO_FLOAT_C (0.941802179),
      MLO_FLOAT_C (0.942316746),
      MLO_FLOAT_C (0.942829095),
      MLO_FLOAT_C (0.943339225),
      MLO_FLOAT_C (0.943847136),
      MLO_FLOAT_C (0.944352826),
      MLO_FLOAT_C (0.944856293),
      MLO_FLOAT_C (0.945357537),
      MLO_FLOAT_C (0.945856557),
      MLO_FLOAT_C (0.946353351),
      MLO_FLOAT_C (0.946847918),
      MLO_FLOAT_C (0.947340257),
      MLO_FLOAT_C (0.947830367),
      MLO_FLOAT_C (0.948318247),
      MLO_FLOAT_C (0.948803895),
      MLO_FLOAT_C (0.94928731),
      MLO_FLOAT_C (0.949768492),
      MLO_FLOAT_C (0.950247439),
      MLO_FLOAT_C (0.95072415),
      MLO_FLOAT_C (0.951198623),
      MLO_FLOAT_C (0.951670859),
      MLO_FLOAT_C (0.952140855),
      MLO_FLOAT_C (0.95260861),
      MLO_FLOAT_C (0.953074124),
      MLO_FLOAT_C (0.953537396),
      MLO_FLOAT_C (0.953998423),
      MLO_FLOAT_C (0.954457206),
      MLO_FLOAT_C (0.954913742),
      MLO_FLOAT_C (0.955368032),
      MLO_FLOAT_C (0.955820074),
      MLO_FLOAT_C (0.956269866),
      MLO_FLOAT_C (0.956717409),
      MLO_FLOAT_C (0.9571627),
      MLO_FLOAT_C (0.957605739),
      MLO_FLOAT_C (0.958046524),
      MLO_FLOAT_C (0.958485055),
      MLO_FLOAT_C (0.958921331),
      MLO_FLOAT_C (0.95935535),
      MLO_FLOAT_C (0.959787112),
      MLO_FLOAT_C (0.960216615),
      MLO_FLOAT_C (0.960643859),
      MLO_FLOAT_C (0.961068842),
      MLO_FLOAT_C (0.961491564),
      MLO_FLOAT_C (0.961912023),
      MLO_FLOAT_C (0.962330219),
      MLO_FLOAT_C (0.962746151),
      MLO_FLOAT_C (0.963159817),
      MLO_FLOAT_C (0.963571216),
      MLO_FLOAT_C (0.963980348),
      MLO_FLOAT_C (0.964387212),
      MLO_FLOAT_C (0.964791807),
      MLO_FLOAT_C (0.965194131),
      MLO_FLOAT_C (0.965594184),
      MLO_FLOAT_C (0.965991965),
      MLO_FLOAT_C (0.966387473),
      MLO_FLOAT_C (0.966780707),
      MLO_FLOAT_C (0.967171666),
      MLO_FLOAT_C (0.967560349),
      MLO_FLOAT_C (0.967946756),
      MLO_FLOAT_C (0.968330884),
      MLO_FLOAT_C (0.968712734),
      MLO_FLOAT_C (0.969092305),
      MLO_FLOAT_C (0.969469595),
      MLO_FLOAT_C (0.969844604),
      MLO_FLOAT_C (0.970217331),
      MLO_FLOAT_C (0.970587775),
      MLO_FLOAT_C (0.970955935),
      MLO_FLOAT_C (0.97132181),
      MLO_FLOAT_C (0.9716854),
      MLO_FLOAT_C (0.972046703),
      MLO_FLOAT_C (0.972405719),
      MLO_FLOAT_C (0.972762447),
      MLO_FLOAT_C (0.973116885),
      MLO_FLOAT_C (0.973469034),
      MLO_FLOAT_C (0.973818892),
      MLO_FLOAT_C (0.974166459),
      MLO_FLOAT_C (0.974511733),
      MLO_FLOAT_C (0.974854715),
      MLO_FLOAT_C (0.975195402),
      MLO_FLOAT_C (0.975533795),
      MLO_FLOAT_C (0.975869892),
      MLO_FLOAT_C (0.976203692),
      MLO_FLOAT_C (0.976535196),
      MLO_FLOAT_C (0.976864402),
      MLO_FLOAT_C (0.977191309),
      MLO_FLOAT_C (0.977515917),
      MLO_FLOAT_C (0.977838224),
      MLO_FLOAT_C (0.978158231),
      MLO_FLOAT_C (0.978475935),
      MLO_FLOAT_C (0.978791338),
      MLO_FLOAT_C (0.979104437),
      MLO_FLOAT_C (0.979415232),
      MLO_FLOAT_C (0.979723723),
      MLO_FLOAT_C (0.980029908),
      MLO_FLOAT_C (0.980333787),
      MLO_FLOAT_C (0.98063536),
      MLO_FLOAT_C (0.980934624),
      MLO_FLOAT_C (0.981231581),
      MLO_FLOAT_C (0.981526228),
      MLO_FLOAT_C (0.981818566),
      MLO_FLOAT_C (0.982108594),
      MLO_FLOAT_C (0.982396311),
      MLO_FLOAT_C (0.982681716),
      MLO_FLOAT_C (0.982964808),
      MLO_FLOAT_C (0.983245588),
      MLO_FLOAT_C (0.983524054),
      MLO_FLOAT_C (0.983800206),
      MLO_FLOAT_C (0.984074042),
      MLO_FLOAT_C (0.984345563),
      MLO_FLOAT_C (0.984614768),
      MLO_FLOAT_C (0.984881656),
      MLO_FLOAT_C (0.985146226),
      MLO_FLOAT_C (0.985408479),
      MLO_FLOAT_C (0.985668412),
      MLO_FLOAT_C (0.985926026),
      MLO_FLOAT_C (0.98618132),
      MLO_FLOAT_C (0.986434294),
      MLO_FLOAT_C (0.986684946),
      MLO_FLOAT_C (0.986933277),
      MLO_FLOAT_C (0.987179285),
      MLO_FLOAT_C (0.98742297),
      MLO_FLOAT_C (0.987664332),
      MLO_FLOAT_C (0.98790337),
      MLO_FLOAT_C (0.988140083),
      MLO_FLOAT_C (0.988374471),
      MLO_FLOAT_C (0.988606533),
      MLO_FLOAT_C (0.988836269),
      MLO_FLOAT_C (0.989063678),
      MLO_FLOAT_C (0.98928876),
      MLO_FLOAT_C (0.989511514),
      MLO_FLOAT_C (0.989731939),
      MLO_FLOAT_C (0.989950036),
      MLO_FLOAT_C (0.990165803),
      MLO_FLOAT_C (0.99037924),
      MLO_FLOAT_C (0.990590346),
      MLO_FLOAT_C (0.990799122),
      MLO_FLOAT_C (0.991005566),
      MLO_FLOAT_C (0.991209678),
      MLO_FLOAT_C (0.991411458),
      MLO_FLOAT_C (0.991610905),
      MLO_FLOAT_C (0.991808019),
      MLO_FLOAT_C (0.992002799),
      MLO_FLOAT_C (0.992195244),
      MLO_FLOAT_C (0.992385355),
      MLO_FLOAT_C (0.99257313),
      MLO_FLOAT_C (0.99275857),
      MLO_FLOAT_C (0.992941674),
      MLO_FLOAT_C (0.993122442),
      MLO_FLOAT_C (0.993300872),
      MLO_FLOAT_C (0.993476966),
      MLO_FLOAT_C (0.993650721),
      MLO_FLOAT_C (0.993822138),
      MLO_FLOAT_C (0.993991217),
      MLO_FLOAT_C (0.994157957),
      MLO_FLOAT_C (0.994322357),
      MLO_FLOAT_C (0.994484418),
      MLO_FLOAT_C (0.994644138),
      MLO_FLOAT_C (0.994801519),
      MLO_FLOAT_C (0.994956558),
      MLO_FLOAT_C (0.995109256),
      MLO_FLOAT_C (0.995259612),
      MLO_FLOAT_C (0.995407627),
      MLO_FLOAT_C (0.995553299),
      MLO_FLOAT_C (0.995696628),
      MLO_FLOAT_C (0.995837615),
      MLO_FLOAT_C (0.995976258),
      MLO_FLOAT_C (0.996112558),
      MLO_FLOAT_C (0.996246513),
      MLO_FLOAT_C (0.996378125),
      MLO_FLOAT_C (0.996507392),
      MLO_FLOAT_C (0.996634314),
      MLO_FLOAT_C (0.99675889),
      MLO_FLOAT_C (0.996881122),
      MLO_FLOAT_C (0.997001007),
      MLO_FLOAT_C (0.997118547),
      MLO_FLOAT_C (0.99723374),
      MLO_FLOAT_C (0.997346587),
      MLO_FLOAT_C (0.997457086),
      MLO_FLOAT_C (0.997565239),
      MLO_FLOAT_C (0.997671044),
      MLO_FLOAT_C (0.997774502),
      MLO_FLOAT_C (0.997875612),
      MLO_FLOAT_C (0.997974374),
      MLO_FLOAT_C (0.998070787),
      MLO_FLOAT_C (0.998164852),
      MLO_FLOAT_C (0.998256568),
      MLO_FLOAT_C (0.998345935),
      MLO_FLOAT_C (0.998432953),
      MLO_FLOAT_C (0.998517621),
      MLO_FLOAT_C (0.99859994),
      MLO_FLOAT_C (0.998679909),
      MLO_FLOAT_C (0.998757528),
      MLO_FLOAT_C (0.998832797),
      MLO_FLOAT_C (0.998905715),
      MLO_FLOAT_C (0.998976283),
      MLO_FLOAT_C (0.999044501),
      MLO_FLOAT_C (0.999110367),
      MLO_FLOAT_C (0.999173883),
      MLO_FLOAT_C (0.999235047),
      MLO_FLOAT_C (0.99929386),
      MLO_FLOAT_C (0.999350321),
      MLO_FLOAT_C (0.999404431),
      MLO_FLOAT_C (0.99945619),
      MLO_FLOAT_C (0.999505596),
      MLO_FLOAT_C (0.999552651),
      MLO_FLOAT_C (0.999597353),
      MLO_FLOAT_C (0.999639704),
      MLO_FLOAT_C (0.999679702),
      MLO_FLOAT_C (0.999717348),
      MLO_FLOAT_C (0.999752641),
      MLO_FLOAT_C (0.999785582),
      MLO_FLOAT_C (0.99981617),
      MLO_FLOAT_C (0.999844405),
      MLO_FLOAT_C (0.999870288),
      MLO_FLOAT_C (0.999893818),
      MLO_FLOAT_C (0.999914996),
      MLO_FLOAT_C (0.99993382),
      MLO_FLOAT_C (0.999950291),
      MLO_FLOAT_C (0.99996441),
      MLO_FLOAT_C (0.999976175),
      MLO_FLOAT_C (0.999985587),
      MLO_FLOAT_C (0.999992647),
      MLO_FLOAT_C (0.999997353),
      MLO_FLOAT_C (0.999999706),
      MLO_FLOAT_C (0.999999706),
      MLO_FLOAT_C (0.999997353),
      MLO_FLOAT_C (0.999992647),
      MLO_FLOAT_C (0.999985587),
      MLO_FLOAT_C (0.999976175),
      MLO_FLOAT_C (0.99996441),
      MLO_FLOAT_C (0.999950291),
      MLO_FLOAT_C (0.99993382),
      MLO_FLOAT_C (0.999914996),
      MLO_FLOAT_C (0.999893818),
      MLO_FLOAT_C (0.999870288),
      MLO_FLOAT_C (0.999844405),
      MLO_FLOAT_C (0.99981617),
      MLO_FLOAT_C (0.999785582),
      MLO_FLOAT_C (0.999752641),
      MLO_FLOAT_C (0.999717348),
      MLO_FLOAT_C (0.999679702),
      MLO_FLOAT_C (0.999639704),
      MLO_FLOAT_C (0.999597353),
      MLO_FLOAT_C (0.999552651),
      MLO_FLOAT_C (0.999505596),
      MLO_FLOAT_C (0.99945619),
      MLO_FLOAT_C (0.999404431),
      MLO_FLOAT_C (0.999350321),
      MLO_FLOAT_C (0.99929386),
      MLO_FLOAT_C (0.999235047),
      MLO_FLOAT_C (0.999173883),
      MLO_FLOAT_C (0.999110367),
      MLO_FLOAT_C (0.999044501),
      MLO_FLOAT_C (0.998976283),
      MLO_FLOAT_C (0.998905715),
      MLO_FLOAT_C (0.998832797),
      MLO_FLOAT_C (0.998757528),
      MLO_FLOAT_C (0.998679909),
      MLO_FLOAT_C (0.99859994),
      MLO_FLOAT_C (0.998517621),
      MLO_FLOAT_C (0.998432953),
      MLO_FLOAT_C (0.998345935),
      MLO_FLOAT_C (0.998256568),
      MLO_FLOAT_C (0.998164852),
      MLO_FLOAT_C (0.998070787),
      MLO_FLOAT_C (0.997974374),
      MLO_FLOAT_C (0.997875612),
      MLO_FLOAT_C (0.997774502),
      MLO_FLOAT_C (0.997671044),
      MLO_FLOAT_C (0.997565239),
      MLO_FLOAT_C (0.997457086),
      MLO_FLOAT_C (0.997346587),
      MLO_FLOAT_C (0.99723374),
      MLO_FLOAT_C (0.997118547),
      MLO_FLOAT_C (0.997001007),
      MLO_FLOAT_C (0.996881122),
      MLO_FLOAT_C (0.99675889),
      MLO_FLOAT_C (0.996634314),
      MLO_FLOAT_C (0.996507392),
      MLO_FLOAT_C (0.996378125),
      MLO_FLOAT_C (0.996246513),
      MLO_FLOAT_C (0.996112558),
      MLO_FLOAT_C (0.995976258),
      MLO_FLOAT_C (0.995837615),
      MLO_FLOAT_C (0.995696628),
      MLO_FLOAT_C (0.995553299),
      MLO_FLOAT_C (0.995407627),
      MLO_FLOAT_C (0.995259612),
      MLO_FLOAT_C (0.995109256),
      MLO_FLOAT_C (0.994956558),
      MLO_FLOAT_C (0.994801519),
      MLO_FLOAT_C (0.994644138),
      MLO_FLOAT_C (0.994484418),
      MLO_FLOAT_C (0.994322357),
      MLO_FLOAT_C (0.994157957),
      MLO_FLOAT_C (0.993991217),
      MLO_FLOAT_C (0.993822138),
      MLO_FLOAT_C (0.993650721),
      MLO_FLOAT_C (0.993476966),
      MLO_FLOAT_C (0.993300872),
      MLO_FLOAT_C (0.993122442),
      MLO_FLOAT_C (0.992941674),
      MLO_FLOAT_C (0.99275857),
      MLO_FLOAT_C (0.99257313),
      MLO_FLOAT_C (0.992385355),
      MLO_FLOAT_C (0.992195244),
      MLO_FLOAT_C (0.992002799),
      MLO_FLOAT_C (0.991808019),
      MLO_FLOAT_C (0.991610905),
      MLO_FLOAT_C (0.991411458),
      MLO_FLOAT_C (0.991209678),
      MLO_FLOAT_C (0.991005566),
      MLO_FLOAT_C (0.990799122),
      MLO_FLOAT_C (0.990590346),
      MLO_FLOAT_C (0.99037924),
      MLO_FLOAT_C (0.990165803),
      MLO_FLOAT_C (0.989950036),
      MLO_FLOAT_C (0.989731939),
      MLO_FLOAT_C (0.989511514),
      MLO_FLOAT_C (0.98928876),
      MLO_FLOAT_C (0.989063678),
      MLO_FLOAT_C (0.988836269),
      MLO_FLOAT_C (0.988606533),
      MLO_FLOAT_C (0.988374471),
      MLO_FLOAT_C (0.988140083),
      MLO_FLOAT_C (0.98790337),
      MLO_FLOAT_C (0.987664332),
      MLO_FLOAT_C (0.98742297),
      MLO_FLOAT_C (0.987179285),
      MLO_FLOAT_C (0.986933277),
      MLO_FLOAT_C (0.986684946),
      MLO_FLOAT_C (0.986434294),
      MLO_FLOAT_C (0.98618132),
      MLO_FLOAT_C (0.985926026),
      MLO_FLOAT_C (0.985668412),
      MLO_FLOAT_C (0.985408479),
      MLO_FLOAT_C (0.985146226),
      MLO_FLOAT_C (0.984881656),
      MLO_FLOAT_C (0.984614768),
      MLO_FLOAT_C (0.984345563),
      MLO_FLOAT_C (0.984074042),
      MLO_FLOAT_C (0.983800206),
      MLO_FLOAT_C (0.983524054),
      MLO_FLOAT_C (0.983245588),
      MLO_FLOAT_C (0.982964808),
      MLO_FLOAT_C (0.982681716),
      MLO_FLOAT_C (0.982396311),
      MLO_FLOAT_C (0.982108594),
      MLO_FLOAT_C (0.981818566),
      MLO_FLOAT_C (0.981526228),
      MLO_FLOAT_C (0.981231581),
      MLO_FLOAT_C (0.980934624),
      MLO_FLOAT_C (0.98063536),
      MLO_FLOAT_C (0.980333787),
      MLO_FLOAT_C (0.980029908),
      MLO_FLOAT_C (0.979723723),
      MLO_FLOAT_C (0.979415232),
      MLO_FLOAT_C (0.979104437),
      MLO_FLOAT_C (0.978791338),
      MLO_FLOAT_C (0.978475935),
      MLO_FLOAT_C (0.978158231),
      MLO_FLOAT_C (0.977838224),
      MLO_FLOAT_C (0.977515917),
      MLO_FLOAT_C (0.977191309),
      MLO_FLOAT_C (0.976864402),
      MLO_FLOAT_C (0.976535196),
      MLO_FLOAT_C (0.976203692),
      MLO_FLOAT_C (0.975869892),
      MLO_FLOAT_C (0.975533795),
      MLO_FLOAT_C (0.975195402),
      MLO_FLOAT_C (0.974854715),
      MLO_FLOAT_C (0.974511733),
      MLO_FLOAT_C (0.974166459),
      MLO_FLOAT_C (0.973818892),
      MLO_FLOAT_C (0.973469034),
      MLO_FLOAT_C (0.973116885),
      MLO_FLOAT_C (0.972762447),
      MLO_FLOAT_C (0.972405719),
      MLO_FLOAT_C (0.972046703),
      MLO_FLOAT_C (0.9716854),
      MLO_FLOAT_C (0.97132181),
      MLO_FLOAT_C (0.970955935),
      MLO_FLOAT_C (0.970587775),
      MLO_FLOAT_C (0.970217331),
      MLO_FLOAT_C (0.969844604),
      MLO_FLOAT_C (0.969469595),
      MLO_FLOAT_C (0.969092305),
      MLO_FLOAT_C (0.968712734),
      MLO_FLOAT_C (0.968330884),
      MLO_FLOAT_C (0.967946756),
      MLO_FLOAT_C (0.967560349),
      MLO_FLOAT_C (0.967171666),
      MLO_FLOAT_C (0.966780707),
      MLO_FLOAT_C (0.966387473),
      MLO_FLOAT_C (0.965991965),
      MLO_FLOAT_C (0.965594184),
      MLO_FLOAT_C (0.965194131),
      MLO_FLOAT_C (0.964791807),
      MLO_FLOAT_C (0.964387212),
      MLO_FLOAT_C (0.963980348),
      MLO_FLOAT_C (0.963571216),
      MLO_FLOAT_C (0.963159817),
      MLO_FLOAT_C (0.962746151),
      MLO_FLOAT_C (0.962330219),
      MLO_FLOAT_C (0.961912023),
      MLO_FLOAT_C (0.961491564),
      MLO_FLOAT_C (0.961068842),
      MLO_FLOAT_C (0.960643859),
      MLO_FLOAT_C (0.960216615),
      MLO_FLOAT_C (0.959787112),
      MLO_FLOAT_C (0.95935535),
      MLO_FLOAT_C (0.958921331),
      MLO_FLOAT_C (0.958485055),
      MLO_FLOAT_C (0.958046524),
      MLO_FLOAT_C (0.957605739),
      MLO_FLOAT_C (0.9571627),
      MLO_FLOAT_C (0.956717409),
      MLO_FLOAT_C (0.956269866),
      MLO_FLOAT_C (0.955820074),
      MLO_FLOAT_C (0.955368032),
      MLO_FLOAT_C (0.954913742),
      MLO_FLOAT_C (0.954457206),
      MLO_FLOAT_C (0.953998423),
      MLO_FLOAT_C (0.953537396),
      MLO_FLOAT_C (0.953074124),
      MLO_FLOAT_C (0.95260861),
      MLO_FLOAT_C (0.952140855),
      MLO_FLOAT_C (0.951670859),
      MLO_FLOAT_C (0.951198623),
      MLO_FLOAT_C (0.95072415),
      MLO_FLOAT_C (0.950247439),
      MLO_FLOAT_C (0.949768492),
      MLO_FLOAT_C (0.94928731),
      MLO_FLOAT_C (0.948803895),
      MLO_FLOAT_C (0.948318247),
      MLO_FLOAT_C (0.947830367),
      MLO_FLOAT_C (0.947340257),
      MLO_FLOAT_C (0.946847918),
      MLO_FLOAT_C (0.946353351),
      MLO_FLOAT_C (0.945856557),
      MLO_FLOAT_C (0.945357537),
      MLO_FLOAT_C (0.944856293),
      MLO_FLOAT_C (0.944352826),
      MLO_FLOAT_C (0.943847136),
      MLO_FLOAT_C (0.943339225),
      MLO_FLOAT_C (0.942829095),
      MLO_FLOAT_C (0.942316746),
      MLO_FLOAT_C (0.941802179),
      MLO_FLOAT_C (0.941285397),
      MLO_FLOAT_C (0.9407664),
      MLO_FLOAT_C (0.940245188),
      MLO_FLOAT_C (0.939721765),
      MLO_FLOAT_C (0.93919613),
      MLO_FLOAT_C (0.938668285),
      MLO_FLOAT_C (0.938138231),
      MLO_FLOAT_C (0.93760597),
      MLO_FLOAT_C (0.937071502),
      MLO_FLOAT_C (0.93653483),
      MLO_FLOAT_C (0.935995954),
      MLO_FLOAT_C (0.935454875),
      MLO_FLOAT_C (0.934911595),
      MLO_FLOAT_C (0.934366115),
      MLO_FLOAT_C (0.933818436),
      MLO_FLOAT_C (0.93326856),
      MLO_FLOAT_C (0.932716488),
      MLO_FLOAT_C (0.932162222),
      MLO_FLOAT_C (0.931605761),
      MLO_FLOAT_C (0.931047109),
      MLO_FLOAT_C (0.930486266),
      MLO_FLOAT_C (0.929923233),
      MLO_FLOAT_C (0.929358012),
      MLO_FLOAT_C (0.928790604),
      MLO_FLOAT_C (0.928221011),
      MLO_FLOAT_C (0.927649233),
      MLO_FLOAT_C (0.927075273),
      MLO_FLOAT_C (0.926499131),
      MLO_FLOAT_C (0.925920809),
      MLO_FLOAT_C (0.925340308),
      MLO_FLOAT_C (0.92475763),
      MLO_FLOAT_C (0.924172775),
      MLO_FLOAT_C (0.923585746),
      MLO_FLOAT_C (0.922996544),
      MLO_FLOAT_C (0.92240517),
      MLO_FLOAT_C (0.921811625),
      MLO_FLOAT_C (0.921215911),
      MLO_FLOAT_C (0.92061803),
      MLO_FLOAT_C (0.920017982),
      MLO_FLOAT_C (0.919415769),
      MLO_FLOAT_C (0.918811393),
      MLO_FLOAT_C (0.918204855),
      MLO_FLOAT_C (0.917596156),
      MLO_FLOAT_C (0.916985298),
      MLO_FLOAT_C (0.916372282),
      MLO_FLOAT_C (0.91575711),
      MLO_FLOAT_C (0.915139783),
      MLO_FLOAT_C (0.914520303),
      MLO_FLOAT_C (0.913898671),
      MLO_FLOAT_C (0.913274888),
      MLO_FLOAT_C (0.912648956),
      MLO_FLOAT_C (0.912020877),
      MLO_FLOAT_C (0.911390651),
      MLO_FLOAT_C (0.910758281),
      MLO_FLOAT_C (0.910123768),
      MLO_FLOAT_C (0.909487113),
      MLO_FLOAT_C (0.908848318),
      MLO_FLOAT_C (0.908207385),
      MLO_FLOAT_C (0.907564314),
      MLO_FLOAT_C (0.906919108),
      MLO_FLOAT_C (0.906271768),
      MLO_FLOAT_C (0.905622295),
      MLO_FLOAT_C (0.904970691),
      MLO_FLOAT_C (0.904316958),
      MLO_FLOAT_C (0.903661097),
      MLO_FLOAT_C (0.903003109),
      MLO_FLOAT_C (0.902342996),
      MLO_FLOAT_C (0.901680761),
      MLO_FLOAT_C (0.901016403),
      MLO_FLOAT_C (0.900349925),
      MLO_FLOAT_C (0.899681329),
      MLO_FLOAT_C (0.899010616),
      MLO_FLOAT_C (0.898337787),
      MLO_FLOAT_C (0.897662844),
      MLO_FLOAT_C (0.896985789),
      MLO_FLOAT_C (0.896306624),
      MLO_FLOAT_C (0.895625349),
      MLO_FLOAT_C (0.894941967),
      MLO_FLOAT_C (0.894256478),
      MLO_FLOAT_C (0.893568886),
      MLO_FLOAT_C (0.892879191),
      MLO_FLOAT_C (0.892187395),
      MLO_FLOAT_C (0.891493499),
      MLO_FLOAT_C (0.890797506),
      MLO_FLOAT_C (0.890099417),
      MLO_FLOAT_C (0.889399233),
      MLO_FLOAT_C (0.888696956),
      MLO_FLOAT_C (0.887992588),
      MLO_FLOAT_C (0.887286131),
      MLO_FLOAT_C (0.886577585),
      MLO_FLOAT_C (0.885866954),
      MLO_FLOAT_C (0.885154238),
      MLO_FLOAT_C (0.884439439),
      MLO_FLOAT_C (0.883722559),
      MLO_FLOAT_C (0.883003599),
      MLO_FLOAT_C (0.882282562),
      MLO_FLOAT_C (0.881559448),
      MLO_FLOAT_C (0.88083426),
      MLO_FLOAT_C (0.880107),
      MLO_FLOAT_C (0.879377668),
      MLO_FLOAT_C (0.878646267),
      MLO_FLOAT_C (0.877912799),
      MLO_FLOAT_C (0.877177265),
      MLO_FLOAT_C (0.876439667),
      MLO_FLOAT_C (0.875700006),
      MLO_FLOAT_C (0.874958285),
      MLO_FLOAT_C (0.874214505),
      MLO_FLOAT_C (0.873468668),
      MLO_FLOAT_C (0.872720775),
      MLO_FLOAT_C (0.871970829),
      MLO_FLOAT_C (0.871218831),
      MLO_FLOAT_C (0.870464783),
      MLO_FLOAT_C (0.869708687),
      MLO_FLOAT_C (0.868950544),
      MLO_FLOAT_C (0.868190357),
      MLO_FLOAT_C (0.867428126),
      MLO_FLOAT_C (0.866663855),
      MLO_FLOAT_C (0.865897544),
      MLO_FLOAT_C (0.865129195),
      MLO_FLOAT_C (0.864358811),
      MLO_FLOAT_C (0.863586393),
      MLO_FLOAT_C (0.862811943),
      MLO_FLOAT_C (0.862035462),
      MLO_FLOAT_C (0.861256953),
      MLO_FLOAT_C (0.860476418),
      MLO_FLOAT_C (0.859693857),
      MLO_FLOAT_C (0.858909274),
      MLO_FLOAT_C (0.85812267),
      MLO_FLOAT_C (0.857334046),
      MLO_FLOAT_C (0.856543405),
      MLO_FLOAT_C (0.855750748),
      MLO_FLOAT_C (0.854956078),
      MLO_FLOAT_C (0.854159396),
      MLO_FLOAT_C (0.853360704),
      MLO_FLOAT_C (0.852560004),
      MLO_FLOAT_C (0.851757298),
      MLO_FLOAT_C (0.850952587),
      MLO_FLOAT_C (0.850145875),
      MLO_FLOAT_C (0.849337161),
      MLO_FLOAT_C (0.84852645),
      MLO_FLOAT_C (0.847713741),
      MLO_FLOAT_C (0.846899038),
      MLO_FLOAT_C (0.846082342),
      MLO_FLOAT_C (0.845263655),
      MLO_FLOAT_C (0.844442979),
      MLO_FLOAT_C (0.843620316),
      MLO_FLOAT_C (0.842795668),
      MLO_FLOAT_C (0.841969036),
      MLO_FLOAT_C (0.841140424),
      MLO_FLOAT_C (0.840309832),
      MLO_FLOAT_C (0.839477263),
      MLO_FLOAT_C (0.838642718),
      MLO_FLOAT_C (0.8378062),
      MLO_FLOAT_C (0.836967711),
      MLO_FLOAT_C (0.836127252),
      MLO_FLOAT_C (0.835284825),
      MLO_FLOAT_C (0.834440433),
      MLO_FLOAT_C (0.833594078),
      MLO_FLOAT_C (0.832745761),
      MLO_FLOAT_C (0.831895485),
      MLO_FLOAT_C (0.831043251),
      MLO_FLOAT_C (0.830189061),
      MLO_FLOAT_C (0.829332918),
      MLO_FLOAT_C (0.828474824),
      MLO_FLOAT_C (0.82761478),
      MLO_FLOAT_C (0.826752788),
      MLO_FLOAT_C (0.825888851),
      MLO_FLOAT_C (0.825022971),
      MLO_FLOAT_C (0.824155149),
      MLO_FLOAT_C (0.823285388),
      MLO_FLOAT_C (0.82241369),
      MLO_FLOAT_C (0.821540057),
      MLO_FLOAT_C (0.82066449),
      MLO_FLOAT_C (0.819786992),
      MLO_FLOAT_C (0.818907566),
      MLO_FLOAT_C (0.818026212),
      MLO_FLOAT_C (0.817142933),
      MLO_FLOAT_C (0.816257732),
      MLO_FLOAT_C (0.81537061),
      MLO_FLOAT_C (0.814481569),
      MLO_FLOAT_C (0.813590612),
      MLO_FLOAT_C (0.81269774),
      MLO_FLOAT_C (0.811802956),
      MLO_FLOAT_C (0.810906261),
      MLO_FLOAT_C (0.810007659),
      MLO_FLOAT_C (0.80910715),
      MLO_FLOAT_C (0.808204737),
      MLO_FLOAT_C (0.807300423),
      MLO_FLOAT_C (0.806394209),
      MLO_FLOAT_C (0.805486098),
      MLO_FLOAT_C (0.804576091),
      MLO_FLOAT_C (0.803664191),
      MLO_FLOAT_C (0.8027504),
      MLO_FLOAT_C (0.801834719),
      MLO_FLOAT_C (0.800917153),
      MLO_FLOAT_C (0.799997701),
      MLO_FLOAT_C (0.799076367),
      MLO_FLOAT_C (0.798153153),
      MLO_FLOAT_C (0.79722806),
      MLO_FLOAT_C (0.796301092),
      MLO_FLOAT_C (0.795372249),
      MLO_FLOAT_C (0.794441536),
      MLO_FLOAT_C (0.793508952),
      MLO_FLOAT_C (0.792574502),
      MLO_FLOAT_C (0.791638187),
      MLO_FLOAT_C (0.790700008),
      MLO_FLOAT_C (0.78975997),
      MLO_FLOAT_C (0.788818072),
      MLO_FLOAT_C (0.787874319),
      MLO_FLOAT_C (0.786928712),
      MLO_FLOAT_C (0.785981253),
      MLO_FLOAT_C (0.785031944),
      MLO_FLOAT_C (0.784080789),
      MLO_FLOAT_C (0.783127788),
      MLO_FLOAT_C (0.782172944),
      MLO_FLOAT_C (0.78121626),
      MLO_FLOAT_C (0.780257738),
      MLO_FLOAT_C (0.779297379),
      MLO_FLOAT_C (0.778335187),
      MLO_FLOAT_C (0.777371164),
      MLO_FLOAT_C (0.776405311),
      MLO_FLOAT_C (0.775437631),
      MLO_FLOAT_C (0.774468126),
      MLO_FLOAT_C (0.773496799),
      MLO_FLOAT_C (0.772523652),
      MLO_FLOAT_C (0.771548688),
      MLO_FLOAT_C (0.770571907),
      MLO_FLOAT_C (0.769593314),
      MLO_FLOAT_C (0.768612909),
      MLO_FLOAT_C (0.767630696),
      MLO_FLOAT_C (0.766646677),
      MLO_FLOAT_C (0.765660853),
      MLO_FLOAT_C (0.764673228),
      MLO_FLOAT_C (0.763683804),
      MLO_FLOAT_C (0.762692582),
      MLO_FLOAT_C (0.761699566),
      MLO_FLOAT_C (0.760704757),
      MLO_FLOAT_C (0.759708159),
      MLO_FLOAT_C (0.758709773),
      MLO_FLOAT_C (0.757709601),
      MLO_FLOAT_C (0.756707647),
      MLO_FLOAT_C (0.755703911),
      MLO_FLOAT_C (0.754698398),
      MLO_FLOAT_C (0.753691109),
      MLO_FLOAT_C (0.752682046),
      MLO_FLOAT_C (0.751671212),
      MLO_FLOAT_C (0.75065861),
      MLO_FLOAT_C (0.749644241),
      MLO_FLOAT_C (0.748628108),
      MLO_FLOAT_C (0.747610213),
      MLO_FLOAT_C (0.746590559),
      MLO_FLOAT_C (0.745569149),
      MLO_FLOAT_C (0.744545984),
      MLO_FLOAT_C (0.743521067),
      MLO_FLOAT_C (0.7424944),
      MLO_FLOAT_C (0.741465987),
      MLO_FLOAT_C (0.740435828),
      MLO_FLOAT_C (0.739403927),
      MLO_FLOAT_C (0.738370287),
      MLO_FLOAT_C (0.737334909),
      MLO_FLOAT_C (0.736297796),
      MLO_FLOAT_C (0.73525895),
      MLO_FLOAT_C (0.734218374),
      MLO_FLOAT_C (0.733176071),
      MLO_FLOAT_C (0.732132042),
      MLO_FLOAT_C (0.73108629),
      MLO_FLOAT_C (0.730038818),
      MLO_FLOAT_C (0.728989629),
      MLO_FLOAT_C (0.727938724),
      MLO_FLOAT_C (0.726886106),
      MLO_FLOAT_C (0.725831777),
      MLO_FLOAT_C (0.724775741),
      MLO_FLOAT_C (0.723717999),
      MLO_FLOAT_C (0.722658554),
      MLO_FLOAT_C (0.721597409),
      MLO_FLOAT_C (0.720534566),
      MLO_FLOAT_C (0.719470027),
      MLO_FLOAT_C (0.718403795),
      MLO_FLOAT_C (0.717335873),
      MLO_FLOAT_C (0.716266263),
      MLO_FLOAT_C (0.715194967),
      MLO_FLOAT_C (0.714121988),
      MLO_FLOAT_C (0.713047329),
      MLO_FLOAT_C (0.711970993),
      MLO_FLOAT_C (0.71089298),
      MLO_FLOAT_C (0.709813295),
      MLO_FLOAT_C (0.70873194),
      MLO_FLOAT_C (0.707648917),
      MLO_FLOAT_C (0.706564229),
      MLO_FLOAT_C (0.705477878),
      MLO_FLOAT_C (0.704389868),
      MLO_FLOAT_C (0.703300199),
      MLO_FLOAT_C (0.702208876),
      MLO_FLOAT_C (0.701115901),
      MLO_FLOAT_C (0.700021275),
      MLO_FLOAT_C (0.698925003),
      MLO_FLOAT_C (0.697827085),
      MLO_FLOAT_C (0.696727526),
      MLO_FLOAT_C (0.695626327),
      MLO_FLOAT_C (0.694523492),
      MLO_FLOAT_C (0.693419022),
      MLO_FLOAT_C (0.69231292),
      MLO_FLOAT_C (0.69120519),
      MLO_FLOAT_C (0.690095832),
      MLO_FLOAT_C (0.688984851),
      MLO_FLOAT_C (0.687872249),
      MLO_FLOAT_C (0.686758028),
      MLO_FLOAT_C (0.685642191),
      MLO_FLOAT_C (0.684524741),
      MLO_FLOAT_C (0.68340568),
      MLO_FLOAT_C (0.682285011),
      MLO_FLOAT_C (0.681162736),
      MLO_FLOAT_C (0.680038859),
      MLO_FLOAT_C (0.678913381),
      MLO_FLOAT_C (0.677786306),
      MLO_FLOAT_C (0.676657636),
      MLO_FLOAT_C (0.675527374),
      MLO_FLOAT_C (0.674395522),
      MLO_FLOAT_C (0.673262083),
      MLO_FLOAT_C (0.67212706),
      MLO_FLOAT_C (0.670990455),
      MLO_FLOAT_C (0.669852271),
      MLO_FLOAT_C (0.668712512),
      MLO_FLOAT_C (0.667571178),
      MLO_FLOAT_C (0.666428274),
      MLO_FLOAT_C (0.665283802),
      MLO_FLOAT_C (0.664137764),
      MLO_FLOAT_C (0.662990163),
      MLO_FLOAT_C (0.661841002),
      MLO_FLOAT_C (0.660690284),
      MLO_FLOAT_C (0.659538012),
      MLO_FLOAT_C (0.658384187),
      MLO_FLOAT_C (0.657228813),
      MLO_FLOAT_C (0.656071892),
      MLO_FLOAT_C (0.654913428),
      MLO_FLOAT_C (0.653753423),
      MLO_FLOAT_C (0.652591879),
      MLO_FLOAT_C (0.6514288),
      MLO_FLOAT_C (0.650264187),
      MLO_FLOAT_C (0.649098045),
      MLO_FLOAT_C (0.647930375),
      MLO_FLOAT_C (0.646761181),
      MLO_FLOAT_C (0.645590465),
      MLO_FLOAT_C (0.644418229),
      MLO_FLOAT_C (0.643244478),
      MLO_FLOAT_C (0.642069212),
      MLO_FLOAT_C (0.640892436),
      MLO_FLOAT_C (0.639714152),
      MLO_FLOAT_C (0.638534362),
      MLO_FLOAT_C (0.63735307),
      MLO_FLOAT_C (0.636170278),
      MLO_FLOAT_C (0.634985989),
      MLO_FLOAT_C (0.633800206),
      MLO_FLOAT_C (0.632612932),
      MLO_FLOAT_C (0.631424169),
      MLO_FLOAT_C (0.63023392),
      MLO_FLOAT_C (0.629042188),
      MLO_FLOAT_C (0.627848976),
      MLO_FLOAT_C (0.626654286),
      MLO_FLOAT_C (0.625458122),
      MLO_FLOAT_C (0.624260486),
      MLO_FLOAT_C (0.623061382),
      MLO_FLOAT_C (0.621860811),
      MLO_FLOAT_C (0.620658777),
      MLO_FLOAT_C (0.619455282),
      MLO_FLOAT_C (0.61825033),
      MLO_FLOAT_C (0.617043923),
      MLO_FLOAT_C (0.615836064),
      MLO_FLOAT_C (0.614626756),
      MLO_FLOAT_C (0.613416001),
      MLO_FLOAT_C (0.612203803),
      MLO_FLOAT_C (0.610990165),
      MLO_FLOAT_C (0.609775089),
      MLO_FLOAT_C (0.608558578),
      MLO_FLOAT_C (0.607340635),
      MLO_FLOAT_C (0.606121263),
      MLO_FLOAT_C (0.604900464),
      MLO_FLOAT_C (0.603678242),
      MLO_FLOAT_C (0.6024546),
      MLO_FLOAT_C (0.60122954),
      MLO_FLOAT_C (0.600003065),
      MLO_FLOAT_C (0.598775179),
      MLO_FLOAT_C (0.597545883),
      MLO_FLOAT_C (0.596315182),
      MLO_FLOAT_C (0.595083077),
      MLO_FLOAT_C (0.593849572),
      MLO_FLOAT_C (0.592614669),
      MLO_FLOAT_C (0.591378372),
      MLO_FLOAT_C (0.590140684),
      MLO_FLOAT_C (0.588901607),
      MLO_FLOAT_C (0.587661144),
      MLO_FLOAT_C (0.586419298),
      MLO_FLOAT_C (0.585176072),
      MLO_FLOAT_C (0.58393147),
      MLO_FLOAT_C (0.582685493),
      MLO_FLOAT_C (0.581438145),
      MLO_FLOAT_C (0.580189429),
      MLO_FLOAT_C (0.578939348),
      MLO_FLOAT_C (0.577687905),
      MLO_FLOAT_C (0.576435102),
      MLO_FLOAT_C (0.575180942),
      MLO_FLOAT_C (0.57392543),
      MLO_FLOAT_C (0.572668566),
      MLO_FLOAT_C (0.571410356),
      MLO_FLOAT_C (0.5701508),
      MLO_FLOAT_C (0.568889903),
      MLO_FLOAT_C (0.567627668),
      MLO_FLOAT_C (0.566364096),
      MLO_FLOAT_C (0.565099192),
      MLO_FLOAT_C (0.563832959),
      MLO_FLOAT_C (0.562565398),
      MLO_FLOAT_C (0.561296514),
      MLO_FLOAT_C (0.560026309),
      MLO_FLOAT_C (0.558754786),
      MLO_FLOAT_C (0.557481948),
      MLO_FLOAT_C (0.556207799),
      MLO_FLOAT_C (0.55493234),
      MLO_FLOAT_C (0.553655576),
      MLO_FLOAT_C (0.552377509),
      MLO_FLOAT_C (0.551098143),
      MLO_FLOAT_C (0.549817479),
      MLO_FLOAT_C (0.548535522),
      MLO_FLOAT_C (0.547252274),
      MLO_FLOAT_C (0.545967738),
      MLO_FLOAT_C (0.544681918),
      MLO_FLOAT_C (0.543394816),
      MLO_FLOAT_C (0.542106435),
      MLO_FLOAT_C (0.540816778),
      MLO_FLOAT_C (0.539525849),
      MLO_FLOAT_C (0.538233651),
      MLO_FLOAT_C (0.536940186),
      MLO_FLOAT_C (0.535645457),
      MLO_FLOAT_C (0.534349468),
      MLO_FLOAT_C (0.533052222),
      MLO_FLOAT_C (0.531753721),
      MLO_FLOAT_C (0.530453969),
      MLO_FLOAT_C (0.529152969),
      MLO_FLOAT_C (0.527850723),
      MLO_FLOAT_C (0.526547236),
      MLO_FLOAT_C (0.52524251),
      MLO_FLOAT_C (0.523936547),
      MLO_FLOAT_C (0.522629352),
      MLO_FLOAT_C (0.521320927),
      MLO_FLOAT_C (0.520011275),
      MLO_FLOAT_C (0.5187004),
      MLO_FLOAT_C (0.517388304),
      MLO_FLOAT_C (0.51607499),
      MLO_FLOAT_C (0.514760463),
      MLO_FLOAT_C (0.513444723),
      MLO_FLOAT_C (0.512127776),
      MLO_FLOAT_C (0.510809624),
      MLO_FLOAT_C (0.509490269),
      MLO_FLOAT_C (0.508169716),
      MLO_FLOAT_C (0.506847967),
      MLO_FLOAT_C (0.505525026),
      MLO_FLOAT_C (0.504200894),
      MLO_FLOAT_C (0.502875577),
      MLO_FLOAT_C (0.501549076),
      MLO_FLOAT_C (0.500221395),
      MLO_FLOAT_C (0.498892537),
      MLO_FLOAT_C (0.497562504),
      MLO_FLOAT_C (0.496231301),
      MLO_FLOAT_C (0.494898931),
      MLO_FLOAT_C (0.493565396),
      MLO_FLOAT_C (0.492230699),
      MLO_FLOAT_C (0.490894844),
      MLO_FLOAT_C (0.489557834),
      MLO_FLOAT_C (0.488219672),
      MLO_FLOAT_C (0.486880361),
      MLO_FLOAT_C (0.485539905),
      MLO_FLOAT_C (0.484198306),
      MLO_FLOAT_C (0.482855568),
      MLO_FLOAT_C (0.481511693),
      MLO_FLOAT_C (0.480166685),
      MLO_FLOAT_C (0.478820548),
      MLO_FLOAT_C (0.477473284),
      MLO_FLOAT_C (0.476124896),
      MLO_FLOAT_C (0.474775388),
      MLO_FLOAT_C (0.473424763),
      MLO_FLOAT_C (0.472073023),
      MLO_FLOAT_C (0.470720173),
      MLO_FLOAT_C (0.469366215),
      MLO_FLOAT_C (0.468011153),
      MLO_FLOAT_C (0.46665499),
      MLO_FLOAT_C (0.465297728),
      MLO_FLOAT_C (0.463939371),
      MLO_FLOAT_C (0.462579923),
      MLO_FLOAT_C (0.461219386),
      MLO_FLOAT_C (0.459857765),
      MLO_FLOAT_C (0.45849506),
      MLO_FLOAT_C (0.457131277),
      MLO_FLOAT_C (0.455766419),
      MLO_FLOAT_C (0.454400488),
      MLO_FLOAT_C (0.453033487),
      MLO_FLOAT_C (0.451665421),
      MLO_FLOAT_C (0.450296292),
      MLO_FLOAT_C (0.448926103),
      MLO_FLOAT_C (0.447554858),
      MLO_FLOAT_C (0.44618256),
      MLO_FLOAT_C (0.444809211),
      MLO_FLOAT_C (0.443434816),
      MLO_FLOAT_C (0.442059378),
      MLO_FLOAT_C (0.4406829),
      MLO_FLOAT_C (0.439305384),
      MLO_FLOAT_C (0.437926835),
      MLO_FLOAT_C (0.436547255),
      MLO_FLOAT_C (0.435166648),
      MLO_FLOAT_C (0.433785017),
      MLO_FLOAT_C (0.432402366),
      MLO_FLOAT_C (0.431018696),
      MLO_FLOAT_C (0.429634013),
      MLO_FLOAT_C (0.428248319),
      MLO_FLOAT_C (0.426861617),
      MLO_FLOAT_C (0.42547391),
      MLO_FLOAT_C (0.424085202),
      MLO_FLOAT_C (0.422695497),
      MLO_FLOAT_C (0.421304797),
      MLO_FLOAT_C (0.419913105),
      MLO_FLOAT_C (0.418520425),
      MLO_FLOAT_C (0.417126761),
      MLO_FLOAT_C (0.415732115),
      MLO_FLOAT_C (0.41433649),
      MLO_FLOAT_C (0.412939891),
      MLO_FLOAT_C (0.41154232),
      MLO_FLOAT_C (0.410143781),
      MLO_FLOAT_C (0.408744276),
      MLO_FLOAT_C (0.40734381),
      MLO_FLOAT_C (0.405942385),
      MLO_FLOAT_C (0.404540005),
      MLO_FLOAT_C (0.403136673),
      MLO_FLOAT_C (0.401732392),
      MLO_FLOAT_C (0.400327166),
      MLO_FLOAT_C (0.398920998),
      MLO_FLOAT_C (0.397513892),
      MLO_FLOAT_C (0.39610585),
      MLO_FLOAT_C (0.394696876),
      MLO_FLOAT_C (0.393286973),
      MLO_FLOAT_C (0.391876144),
      MLO_FLOAT_C (0.390464394),
      MLO_FLOAT_C (0.389051725),
      MLO_FLOAT_C (0.38763814),
      MLO_FLOAT_C (0.386223643),
      MLO_FLOAT_C (0.384808238),
      MLO_FLOAT_C (0.383391926),
      MLO_FLOAT_C (0.381974713),
      MLO_FLOAT_C (0.380556601),
      MLO_FLOAT_C (0.379137593),
      MLO_FLOAT_C (0.377717694),
      MLO_FLOAT_C (0.376296905),
      MLO_FLOAT_C (0.374875231),
      MLO_FLOAT_C (0.373452675),
      MLO_FLOAT_C (0.37202924),
      MLO_FLOAT_C (0.37060493),
      MLO_FLOAT_C (0.369179747),
      MLO_FLOAT_C (0.367753696),
      MLO_FLOAT_C (0.36632678),
      MLO_FLOAT_C (0.364899001),
      MLO_FLOAT_C (0.363470364),
      MLO_FLOAT_C (0.362040871),
      MLO_FLOAT_C (0.360610527),
      MLO_FLOAT_C (0.359179334),
      MLO_FLOAT_C (0.357747296),
      MLO_FLOAT_C (0.356314416),
      MLO_FLOAT_C (0.354880698),
      MLO_FLOAT_C (0.353446145),
      MLO_FLOAT_C (0.352010759),
      MLO_FLOAT_C (0.350574546),
      MLO_FLOAT_C (0.349137508),
      MLO_FLOAT_C (0.347699648),
      MLO_FLOAT_C (0.34626097),
      MLO_FLOAT_C (0.344821477),
      MLO_FLOAT_C (0.343381173),
      MLO_FLOAT_C (0.34194006),
      MLO_FLOAT_C (0.340498144),
      MLO_FLOAT_C (0.339055425),
      MLO_FLOAT_C (0.337611909),
      MLO_FLOAT_C (0.336167599),
      MLO_FLOAT_C (0.334722498),
      MLO_FLOAT_C (0.333276609),
      MLO_FLOAT_C (0.331829935),
      MLO_FLOAT_C (0.330382481),
      MLO_FLOAT_C (0.32893425),
      MLO_FLOAT_C (0.327485244),
      MLO_FLOAT_C (0.326035468),
      MLO_FLOAT_C (0.324584925),
      MLO_FLOAT_C (0.323133618),
      MLO_FLOAT_C (0.32168155),
      MLO_FLOAT_C (0.320228726),
      MLO_FLOAT_C (0.318775148),
      MLO_FLOAT_C (0.31732082),
      MLO_FLOAT_C (0.315865745),
      MLO_FLOAT_C (0.314409927),
      MLO_FLOAT_C (0.312953369),
      MLO_FLOAT_C (0.311496075),
      MLO_FLOAT_C (0.310038048),
      MLO_FLOAT_C (0.308579291),
      MLO_FLOAT_C (0.307119808),
      MLO_FLOAT_C (0.305659602),
      MLO_FLOAT_C (0.304198678),
      MLO_FLOAT_C (0.302737037),
      MLO_FLOAT_C (0.301274684),
      MLO_FLOAT_C (0.299811622),
      MLO_FLOAT_C (0.298347855),
      MLO_FLOAT_C (0.296883385),
      MLO_FLOAT_C (0.295418217),
      MLO_FLOAT_C (0.293952354),
      MLO_FLOAT_C (0.292485799),
      MLO_FLOAT_C (0.291018556),
      MLO_FLOAT_C (0.289550628),
      MLO_FLOAT_C (0.288082019),
      MLO_FLOAT_C (0.286612731),
      MLO_FLOAT_C (0.28514277),
      MLO_FLOAT_C (0.283672137),
      MLO_FLOAT_C (0.282200837),
      MLO_FLOAT_C (0.280728873),
      MLO_FLOAT_C (0.279256248),
      MLO_FLOAT_C (0.277782967),
      MLO_FLOAT_C (0.276309031),
      MLO_FLOAT_C (0.274834445),
      MLO_FLOAT_C (0.273359213),
      MLO_FLOAT_C (0.271883337),
      MLO_FLOAT_C (0.270406822),
      MLO_FLOAT_C (0.26892967),
      MLO_FLOAT_C (0.267451886),
      MLO_FLOAT_C (0.265973472),
      MLO_FLOAT_C (0.264494432),
      MLO_FLOAT_C (0.26301477),
      MLO_FLOAT_C (0.261534489),
      MLO_FLOAT_C (0.260053593),
      MLO_FLOAT_C (0.258572085),
      MLO_FLOAT_C (0.257089968),
      MLO_FLOAT_C (0.255607246),
      MLO_FLOAT_C (0.254123923),
      MLO_FLOAT_C (0.252640002),
      MLO_FLOAT_C (0.251155486),
      MLO_FLOAT_C (0.24967038),
      MLO_FLOAT_C (0.248184685),
      MLO_FLOAT_C (0.246698407),
      MLO_FLOAT_C (0.245211549),
      MLO_FLOAT_C (0.243724113),
      MLO_FLOAT_C (0.242236104),
      MLO_FLOAT_C (0.240747525),
      MLO_FLOAT_C (0.239258379),
      MLO_FLOAT_C (0.23776867),
      MLO_FLOAT_C (0.236278402),
      MLO_FLOAT_C (0.234787578),
      MLO_FLOAT_C (0.233296201),
      MLO_FLOAT_C (0.231804276),
      MLO_FLOAT_C (0.230311805),
      MLO_FLOAT_C (0.228818792),
      MLO_FLOAT_C (0.22732524),
      MLO_FLOAT_C (0.225831154),
      MLO_FLOAT_C (0.224336536),
      MLO_FLOAT_C (0.222841391),
      MLO_FLOAT_C (0.221345721),
      MLO_FLOAT_C (0.21984953),
      MLO_FLOAT_C (0.218352822),
      MLO_FLOAT_C (0.2168556),
      MLO_FLOAT_C (0.215357867),
      MLO_FLOAT_C (0.213859628),
      MLO_FLOAT_C (0.212360886),
      MLO_FLOAT_C (0.210861644),
      MLO_FLOAT_C (0.209361906),
      MLO_FLOAT_C (0.207861675),
      MLO_FLOAT_C (0.206360955),
      MLO_FLOAT_C (0.20485975),
      MLO_FLOAT_C (0.203358062),
      MLO_FLOAT_C (0.201855896),
      MLO_FLOAT_C (0.200353255),
      MLO_FLOAT_C (0.198850143),
      MLO_FLOAT_C (0.197346562),
      MLO_FLOAT_C (0.195842517),
      MLO_FLOAT_C (0.194338012),
      MLO_FLOAT_C (0.192833049),
      MLO_FLOAT_C (0.191327632),
      MLO_FLOAT_C (0.189821765),
      MLO_FLOAT_C (0.188315452),
      MLO_FLOAT_C (0.186808695),
      MLO_FLOAT_C (0.185301499),
      MLO_FLOAT_C (0.183793867),
      MLO_FLOAT_C (0.182285802),
      MLO_FLOAT_C (0.180777308),
      MLO_FLOAT_C (0.179268389),
      MLO_FLOAT_C (0.177759048),
      MLO_FLOAT_C (0.176249289),
      MLO_FLOAT_C (0.174739115),
      MLO_FLOAT_C (0.17322853),
      MLO_FLOAT_C (0.171717537),
      MLO_FLOAT_C (0.17020614),
      MLO_FLOAT_C (0.168694343),
      MLO_FLOAT_C (0.167182148),
      MLO_FLOAT_C (0.165669561),
      MLO_FLOAT_C (0.164156583),
      MLO_FLOAT_C (0.162643219),
      MLO_FLOAT_C (0.161129473),
      MLO_FLOAT_C (0.159615347),
      MLO_FLOAT_C (0.158100846),
      MLO_FLOAT_C (0.156585973),
      MLO_FLOAT_C (0.155070731),
      MLO_FLOAT_C (0.153555124),
      MLO_FLOAT_C (0.152039156),
      MLO_FLOAT_C (0.150522831),
      MLO_FLOAT_C (0.149006151),
      MLO_FLOAT_C (0.14748912),
      MLO_FLOAT_C (0.145971742),
      MLO_FLOAT_C (0.144454021),
      MLO_FLOAT_C (0.14293596),
      MLO_FLOAT_C (0.141417563),
      MLO_FLOAT_C (0.139898833),
      MLO_FLOAT_C (0.138379774),
      MLO_FLOAT_C (0.136860389),
      MLO_FLOAT_C (0.135340682),
      MLO_FLOAT_C (0.133820656),
      MLO_FLOAT_C (0.132300316),
      MLO_FLOAT_C (0.130779664),
      MLO_FLOAT_C (0.129258705),
      MLO_FLOAT_C (0.127737441),
      MLO_FLOAT_C (0.126215877),
      MLO_FLOAT_C (0.124694016),
      MLO_FLOAT_C (0.123171861),
      MLO_FLOAT_C (0.121649417),
      MLO_FLOAT_C (0.120126686),
      MLO_FLOAT_C (0.118603673),
      MLO_FLOAT_C (0.117080381),
      MLO_FLOAT_C (0.115556813),
      MLO_FLOAT_C (0.114032973),
      MLO_FLOAT_C (0.112508865),
      MLO_FLOAT_C (0.110984492),
      MLO_FLOAT_C (0.109459858),
      MLO_FLOAT_C (0.107934966),
      MLO_FLOAT_C (0.106409821),
      MLO_FLOAT_C (0.104884425),
      MLO_FLOAT_C (0.103358782),
      MLO_FLOAT_C (0.101832896),
      MLO_FLOAT_C (0.10030677),
      MLO_FLOAT_C (0.0987804085),
      MLO_FLOAT_C (0.0972538144),
      MLO_FLOAT_C (0.0957269915),
      MLO_FLOAT_C (0.0941999433),
      MLO_FLOAT_C (0.0926726734),
      MLO_FLOAT_C (0.0911451855),
      MLO_FLOAT_C (0.0896174831),
      MLO_FLOAT_C (0.0880895698),
      MLO_FLOAT_C (0.0865614492),
      MLO_FLOAT_C (0.085033125),
      MLO_FLOAT_C (0.0835046006),
      MLO_FLOAT_C (0.0819758798),
      MLO_FLOAT_C (0.0804469661),
      MLO_FLOAT_C (0.078917863),
      MLO_FLOAT_C (0.0773885743),
      MLO_FLOAT_C (0.0758591034),
      MLO_FLOAT_C (0.0743294541),
      MLO_FLOAT_C (0.0727996298),
      MLO_FLOAT_C (0.0712696343),
      MLO_FLOAT_C (0.069739471),
      MLO_FLOAT_C (0.0682091437),
      MLO_FLOAT_C (0.0666786558),
      MLO_FLOAT_C (0.065148011),
      MLO_FLOAT_C (0.063617213),
      MLO_FLOAT_C (0.0620862652),
      MLO_FLOAT_C (0.0605551713),
      MLO_FLOAT_C (0.059023935),
      MLO_FLOAT_C (0.0574925597),
      MLO_FLOAT_C (0.0559610492),
      MLO_FLOAT_C (0.054429407),
      MLO_FLOAT_C (0.0528976367),
      MLO_FLOAT_C (0.051365742),
      MLO_FLOAT_C (0.0498337263),
      MLO_FLOAT_C (0.0483015934),
      MLO_FLOAT_C (0.0467693469),
      MLO_FLOAT_C (0.0452369903),
      MLO_FLOAT_C (0.0437045273),
      MLO_FLOAT_C (0.0421719614),
      MLO_FLOAT_C (0.0406392962),
      MLO_FLOAT_C (0.0391065355),
      MLO_FLOAT_C (0.0375736827),
      MLO_FLOAT_C (0.0360407415),
      MLO_FLOAT_C (0.0345077155),
      MLO_FLOAT_C (0.0329746083),
      MLO_FLOAT_C (0.0314414235),
      MLO_FLOAT_C (0.0299081648),
      MLO_FLOAT_C (0.0283748356),
      MLO_FLOAT_C (0.0268414397),
      MLO_FLOAT_C (0.0253079806),
      MLO_FLOAT_C (0.023774462),
      MLO_FLOAT_C (0.0222408874),
      MLO_FLOAT_C (0.0207072605),
      MLO_FLOAT_C (0.0191735849),
      MLO_FLOAT_C (0.0176398641),
      MLO_FLOAT_C (0.0161061019),
      MLO_FLOAT_C (0.0145723017),
      MLO_FLOAT_C (0.0130384672),
      MLO_FLOAT_C (0.0115046021),
      MLO_FLOAT_C (0.00997070991),
      MLO_FLOAT_C (0.00843679424),
      MLO_FLOAT_C (0.00690285872),
      MLO_FLOAT_C (0.00536890696),
      MLO_FLOAT_C (0.00383494257),
      MLO_FLOAT_C (0.00230096915),
      MLO_FLOAT_C (0.000766990319)
   },
   {
      MLO_FLOAT_C (0.000292561535),
      MLO_FLOAT_C (0.000429985671),
      MLO_FLOAT_C (0.000546740743),
      MLO_FLOAT_C (0.000654823037),
      MLO_FLOAT_C (0.000758701942),
      MLO_FLOAT_C (0.000860593306),
      MLO_FLOAT_C (0.000961775402),
      MLO_FLOAT_C (0.00106306093),
      MLO_FLOAT_C (0.00116500361),
      MLO_FLOAT_C (0.0012680012),
      MLO_FLOAT_C (0.0013723517),
      MLO_FLOAT_C (0.00147828639),
      MLO_FLOAT_C (0.00158599017),
      MLO_FLOAT_C (0.0016956148),
      MLO_FLOAT_C (0.00180728766),
      MLO_FLOAT_C (0.00192111791),
      MLO_FLOAT_C (0.00203720076),
      MLO_FLOAT_C (0.00215562063),
      MLO_FLOAT_C (0.00227645343),
      MLO_FLOAT_C (0.00239976832),
      MLO_FLOAT_C (0.00252562903),
      MLO_FLOAT_C (0.00265409486),
      MLO_FLOAT_C (0.00278522149),
      MLO_FLOAT_C (0.00291906163),
      MLO_FLOAT_C (0.0030556655),
      MLO_FLOAT_C (0.00319508125),
      MLO_FLOAT_C (0.00333735527),
      MLO_FLOAT_C (0.0034825325),
      MLO_FLOAT_C (0.00363065661),
      MLO_FLOAT_C (0.00378177019),
      MLO_FLOAT_C (0.00393591495),
      MLO_FLOAT_C (0.00409313177),
      MLO_FLOAT_C (0.00425346088),
      MLO_FLOAT_C (0.00441694192),
      MLO_FLOAT_C (0.00458361403),
      MLO_FLOAT_C (0.00475351587),
      MLO_FLOAT_C (0.00492668576),
      MLO_FLOAT_C (0.00510316165),
      MLO_FLOAT_C (0.00528298122),
      MLO_FLOAT_C (0.00546618188),
      MLO_FLOAT_C (0.0056528008),
      MLO_FLOAT_C (0.00584287498),
      MLO_FLOAT_C (0.00603644121),
      MLO_FLOAT_C (0.00623353614),
      MLO_FLOAT_C (0.00643419629),
      MLO_FLOAT_C (0.00663845803),
      MLO_FLOAT_C (0.00684635764),
      MLO_FLOAT_C (0.0070579313),
      MLO_FLOAT_C (0.0072732151),
      MLO_FLOAT_C (0.00749224503),
      MLO_FLOAT_C (0.00771505704),
      MLO_FLOAT_C (0.00794168698),
      MLO_FLOAT_C (0.00817217067),
      MLO_FLOAT_C (0.00840654386),
      MLO_FLOAT_C (0.00864484224),
      MLO_FLOAT_C (0.00888710146),
      MLO_FLOAT_C (0.00913335712),
      MLO_FLOAT_C (0.00938364478),
      MLO_FLOAT_C (0.00963799995),
      MLO_FLOAT_C (0.00989645812),
      MLO_FLOAT_C (0.0101590547),
      MLO_FLOAT_C (0.0104258251),
      MLO_FLOAT_C (0.0106968047),
      MLO_FLOAT_C (0.0109720287),
      MLO_FLOAT_C (0.0112515326),
      MLO_FLOAT_C (0.0115353514),
      MLO_FLOAT_C (0.0118235204),
      MLO_FLOAT_C (0.0121160748),
      MLO_FLOAT_C (0.0124130496),
      MLO_FLOAT_C (0.01271448),
      MLO_FLOAT_C (0.0130204009),
      MLO_FLOAT_C (0.0133308473),
      MLO_FLOAT_C (0.0136458542),
      MLO_FLOAT_C (0.0139654565),
      MLO_FLOAT_C (0.0142896888),
      MLO_FLOAT_C (0.0146185862),
      MLO_FLOAT_C (0.0149521831),
      MLO_FLOAT_C (0.0152905144),
      MLO_FLOAT_C (0.0156336146),
      MLO_FLOAT_C (0.0159815183),
      MLO_FLOAT_C (0.0163342599),
      MLO_FLOAT_C (0.0166918738),
      MLO_FLOAT_C (0.0170543944),
      MLO_FLOAT_C (0.0174218559),
      MLO_FLOAT_C (0.0177942926),
      MLO_FLOAT_C (0.0181717386),
      MLO_FLOAT_C (0.0185542279),
      MLO_FLOAT_C (0.0189417944),
      MLO_FLOAT_C (0.019334472),
      MLO_FLOAT_C (0.0197322946),
      MLO_FLOAT_C (0.0201352958),
      MLO_FLOAT_C (0.0205435093),
      MLO_FLOAT_C (0.0209569685),
      MLO_FLOAT_C (0.0213757068),
      MLO_FLOAT_C (0.0217997577),
      MLO_FLOAT_C (0.0222291542),
      MLO_FLOAT_C (0.0226639296),
      MLO_FLOAT_C (0.0231041167),
      MLO_FLOAT_C (0.0235497485),
      MLO_FLOAT_C (0.0240008578),
      MLO_FLOAT_C (0.0244574771),
      MLO_FLOAT_C (0.0249196392),
      MLO_FLOAT_C (0.0253873762),
      MLO_FLOAT_C (0.0258607206),
      MLO_FLOAT_C (0.0263397045),
      MLO_FLOAT_C (0.0268243599),
      MLO_FLOAT_C (0.0273147188),
      MLO_FLOAT_C (0.0278108127),
      MLO_FLOAT_C (0.0283126734),
      MLO_FLOAT_C (0.0288203324),
      MLO_FLOAT_C (0.0293338209),
      MLO_FLOAT_C (0.02985317),
      MLO_FLOAT_C (0.030378411),
      MLO_FLOAT_C (0.0309095744),
      MLO_FLOAT_C (0.0314466912),
      MLO_FLOAT_C (0.0319897918),
      MLO_FLOAT_C (0.0325389065),
      MLO_FLOAT_C (0.0330940657),
      MLO_FLOAT_C (0.0336552992),
      MLO_FLOAT_C (0.034222637),
      MLO_FLOAT_C (0.0347961088),
      MLO_FLOAT_C (0.035375744),
      MLO_FLOAT_C (0.035961572),
      MLO_FLOAT_C (0.0365536219),
      MLO_FLOAT_C (0.0371519226),
      MLO_FLOAT_C (0.0377565029),
      MLO_FLOAT_C (0.0383673914),
      MLO_FLOAT_C (0.0389846163),
      MLO_FLOAT_C (0.0396082058),
      MLO_FLOAT_C (0.040238188),
      MLO_FLOAT_C (0.0408745904),
      MLO_FLOAT_C (0.0415174407),
      MLO_FLOAT_C (0.0421667661),
      MLO_FLOAT_C (0.0428225939),
      MLO_FLOAT_C (0.0434849507),
      MLO_FLOAT_C (0.0441538633),
      MLO_FLOAT_C (0.0448293582),
      MLO_FLOAT_C (0.0455114615),
      MLO_FLOAT_C (0.0462001991),
      MLO_FLOAT_C (0.0468955969),
      MLO_FLOAT_C (0.0475976803),
      MLO_FLOAT_C (0.0483064746),
      MLO_FLOAT_C (0.0490220048),
      MLO_FLOAT_C (0.0497442956),
      MLO_FLOAT_C (0.0504733717),
      MLO_FLOAT_C (0.0512092571),
      MLO_FLOAT_C (0.051951976),
      MLO_FLOAT_C (0.0527015522),
      MLO_FLOAT_C (0.053458009),
      MLO_FLOAT_C (0.0542213698),
      MLO_FLOAT_C (0.0549916574),
      MLO_FLOAT_C (0.0557688947),
      MLO_FLOAT_C (0.0565531039),
      MLO_FLOAT_C (0.0573443073),
      MLO_FLOAT_C (0.0581425268),
      MLO_FLOAT_C (0.0589477838),
      MLO_FLOAT_C (0.0597600998),
      MLO_FLOAT_C (0.0605794957),
      MLO_FLOAT_C (0.0614059923),
      MLO_FLOAT_C (0.06223961),
      MLO_FLOAT_C (0.063080369),
      MLO_FLOAT_C (0.063928289),
      MLO_FLOAT_C (0.0647833898),
      MLO_FLOAT_C (0.0656456904),
      MLO_FLOAT_C (0.0665152099),
      MLO_FLOAT_C (0.0673919669),
      MLO_FLOAT_C (0.0682759797),
      MLO_FLOAT_C (0.0691672663),
      MLO_FLOAT_C (0.0700658444),
      MLO_FLOAT_C (0.0709717315),
      MLO_FLOAT_C (0.0718849445),
      MLO_FLOAT_C (0.0728055003),
      MLO_FLOAT_C (0.0737334151),
      MLO_FLOAT_C (0.0746687052),
      MLO_FLOAT_C (0.0756113862),
      MLO_FLOAT_C (0.0765614737),
      MLO_FLOAT_C (0.0775189826),
      MLO_FLOAT_C (0.0784839277),
      MLO_FLOAT_C (0.0794563235),
      MLO_FLOAT_C (0.080436184),
      MLO_FLOAT_C (0.0814235229),
      MLO_FLOAT_C (0.0824183536),
      MLO_FLOAT_C (0.0834206892),
      MLO_FLOAT_C (0.0844305424),
      MLO_FLOAT_C (0.0854479253),
      MLO_FLOAT_C (0.0864728501),
      MLO_FLOAT_C (0.0875053284),
      MLO_FLOAT_C (0.0885453713),
      MLO_FLOAT_C (0.0895929898),
      MLO_FLOAT_C (0.0906481945),
      MLO_FLOAT_C (0.0917109954),
      MLO_FLOAT_C (0.0927814023),
      MLO_FLOAT_C (0.0938594248),
      MLO_FLOAT_C (0.0949450717),
      MLO_FLOAT_C (0.0960383519),
      MLO_FLOAT_C (0.0971392736),
      MLO_FLOAT_C (0.0982478447),
      MLO_FLOAT_C (0.0993640728),
      MLO_FLOAT_C (0.100487965),
      MLO_FLOAT_C (0.101619528),
      MLO_FLOAT_C (0.102758769),
      MLO_FLOAT_C (0.103905692),
      MLO_FLOAT_C (0.105060305),
      MLO_FLOAT_C (0.106222612),
      MLO_FLOAT_C (0.107392617),
      MLO_FLOAT_C (0.108570326),
      MLO_FLOAT_C (0.109755743),
      MLO_FLOAT_C (0.110948871),
      MLO_FLOAT_C (0.112149712),
      MLO_FLOAT_C (0.113358272),
      MLO_FLOAT_C (0.11457455),
      MLO_FLOAT_C (0.11579855),
      MLO_FLOAT_C (0.117030274),
      MLO_FLOAT_C (0.118269722),
      MLO_FLOAT_C (0.119516895),
      MLO_FLOAT_C (0.120771794),
      MLO_FLOAT_C (0.122034419),
      MLO_FLOAT_C (0.123304768),
      MLO_FLOAT_C (0.124582843),
      MLO_FLOAT_C (0.12586864),
      MLO_FLOAT_C (0.127162159),
      MLO_FLOAT_C (0.128463397),
      MLO_FLOAT_C (0.129772352),
      MLO_FLOAT_C (0.131089022),
      MLO_FLOAT_C (0.132413401),
      MLO_FLOAT_C (0.133745488),
      MLO_FLOAT_C (0.135085278),
      MLO_FLOAT_C (0.136432765),
      MLO_FLOAT_C (0.137787946),
      MLO_FLOAT_C (0.139150814),
      MLO_FLOAT_C (0.140521364),
      MLO_FLOAT_C (0.141899589),
      MLO_FLOAT_C (0.143285482),
      MLO_FLOAT_C (0.144679038),
      MLO_FLOAT_C (0.146080247),
      MLO_FLOAT_C (0.147489102),
      MLO_FLOAT_C (0.148905594),
      MLO_FLOAT_C (0.150329714),
      MLO_FLOAT_C (0.151761454),
      MLO_FLOAT_C (0.153200803),
      MLO_FLOAT_C (0.154647751),
      MLO_FLOAT_C (0.156102288),
      MLO_FLOAT_C (0.157564402),
      MLO_FLOAT_C (0.159034082),
      MLO_FLOAT_C (0.160511315),
      MLO_FLOAT_C (0.161996091),
      MLO_FLOAT_C (0.163488395),
      MLO_FLOAT_C (0.164988215),
      MLO_FLOAT_C (0.166495536),
      MLO_FLOAT_C (0.168010345),
      MLO_FLOAT_C (0.169532627),
      MLO_FLOAT_C (0.171062368),
      MLO_FLOAT_C (0.172599551),
      MLO_FLOAT_C (0.17414416),
      MLO_FLOAT_C (0.17569618),
      MLO_FLOAT_C (0.177255594),
      MLO_FLOAT_C (0.178822384),
      MLO_FLOAT_C (0.180396534),
      MLO_FLOAT_C (0.181978023),
      MLO_FLOAT_C (0.183566835),
      MLO_FLOAT_C (0.185162951),
      MLO_FLOAT_C (0.18676635),
      MLO_FLOAT_C (0.188377013),
      MLO_FLOAT_C (0.18999492),
      MLO_FLOAT_C (0.191620051),
      MLO_FLOAT_C (0.193252383),
      MLO_FLOAT_C (0.194891895),
      MLO_FLOAT_C (0.196538566),
      MLO_FLOAT_C (0.198192373),
      MLO_FLOAT_C (0.199853293),
      MLO_FLOAT_C (0.201521302),
      MLO_FLOAT_C (0.203196378),
      MLO_FLOAT_C (0.204878495),
      MLO_FLOAT_C (0.206567629),
      MLO_FLOAT_C (0.208263755),
      MLO_FLOAT_C (0.209966848),
      MLO_FLOAT_C (0.211676882),
      MLO_FLOAT_C (0.21339383),
      MLO_FLOAT_C (0.215117666),
      MLO_FLOAT_C (0.216848361),
      MLO_FLOAT_C (0.21858589),
      MLO_FLOAT_C (0.220330223),
      MLO_FLOAT_C (0.222081333),
      MLO_FLOAT_C (0.223839189),
      MLO_FLOAT_C (0.225603764),
      MLO_FLOAT_C (0.227375027),
      MLO_FLOAT_C (0.229152948),
      MLO_FLOAT_C (0.230937496),
      MLO_FLOAT_C (0.232728641),
      MLO_FLOAT_C (0.23452635),
      MLO_FLOAT_C (0.236330593),
      MLO_FLOAT_C (0.238141337),
      MLO_FLOAT_C (0.239958549),
      MLO_FLOAT_C (0.241782195),
      MLO_FLOAT_C (0.243612244),
      MLO_FLOAT_C (0.24544866),
      MLO_FLOAT_C (0.24729141),
      MLO_FLOAT_C (0.249140458),
      MLO_FLOAT_C (0.250995769),
      MLO_FLOAT_C (0.252857309),
      MLO_FLOAT_C (0.25472504),
      MLO_FLOAT_C (0.256598928),
      MLO_FLOAT_C (0.258478934),
      MLO_FLOAT_C (0.260365022),
      MLO_FLOAT_C (0.262257154),
      MLO_FLOAT_C (0.264155293),
      MLO_FLOAT_C (0.266059399),
      MLO_FLOAT_C (0.267969436),
      MLO_FLOAT_C (0.269885362),
      MLO_FLOAT_C (0.271807139),
      MLO_FLOAT_C (0.273734727),
      MLO_FLOAT_C (0.275668086),
      MLO_FLOAT_C (0.277607175),
      MLO_FLOAT_C (0.279551953),
      MLO_FLOAT_C (0.281502378),
      MLO_FLOAT_C (0.28345841),
      MLO_FLOAT_C (0.285420005),
      MLO_FLOAT_C (0.287387122),
      MLO_FLOAT_C (0.289359717),
      MLO_FLOAT_C (0.291337748),
      MLO_FLOAT_C (0.29332117),
      MLO_FLOAT_C (0.29530994),
      MLO_FLOAT_C (0.297304013),
      MLO_FLOAT_C (0.299303346),
      MLO_FLOAT_C (0.301307892),
      MLO_FLOAT_C (0.303317606),
      MLO_FLOAT_C (0.305332444),
      MLO_FLOAT_C (0.307352358),
      MLO_FLOAT_C (0.309377303),
      MLO_FLOAT_C (0.311407231),
      MLO_FLOAT_C (0.313442096),
      MLO_FLOAT_C (0.31548185),
      MLO_FLOAT_C (0.317526445),
      MLO_FLOAT_C (0.319575834),
      MLO_FLOAT_C (0.321629968),
      MLO_FLOAT_C (0.323688798),
      MLO_FLOAT_C (0.325752275),
      MLO_FLOAT_C (0.327820351),
      MLO_FLOAT_C (0.329892974),
      MLO_FLOAT_C (0.331970097),
      MLO_FLOAT_C (0.334051667),
      MLO_FLOAT_C (0.336137635),
      MLO_FLOAT_C (0.338227949),
      MLO_FLOAT_C (0.340322559),
      MLO_FLOAT_C (0.342421413),
      MLO_FLOAT_C (0.344524459),
      MLO_FLOAT_C (0.346631645),
      MLO_FLOAT_C (0.348742919),
      MLO_FLOAT_C (0.350858228),
      MLO_FLOAT_C (0.352977519),
      MLO_FLOAT_C (0.35510074),
      MLO_FLOAT_C (0.357227836),
      MLO_FLOAT_C (0.359358754),
      MLO_FLOAT_C (0.36149344),
      MLO_FLOAT_C (0.36363184),
      MLO_FLOAT_C (0.365773899),
      MLO_FLOAT_C (0.367919562),
      MLO_FLOAT_C (0.370068775),
      MLO_FLOAT_C (0.372221481),
      MLO_FLOAT_C (0.374377627),
      MLO_FLOAT_C (0.376537155),
      MLO_FLOAT_C (0.378700009),
      MLO_FLOAT_C (0.380866135),
      MLO_FLOAT_C (0.383035474),
      MLO_FLOAT_C (0.385207971),
      MLO_FLOAT_C (0.387383568),
      MLO_FLOAT_C (0.389562209),
      MLO_FLOAT_C (0.391743835),
      MLO_FLOAT_C (0.39392839),
      MLO_FLOAT_C (0.396115816),
      MLO_FLOAT_C (0.398306054),
      MLO_FLOAT_C (0.400499046),
      MLO_FLOAT_C (0.402694735),
      MLO_FLOAT_C (0.40489306),
      MLO_FLOAT_C (0.407093965),
      MLO_FLOAT_C (0.409297389),
      MLO_FLOAT_C (0.411503274),
      MLO_FLOAT_C (0.413711559),
      MLO_FLOAT_C (0.415922187),
      MLO_FLOAT_C (0.418135096),
      MLO_FLOAT_C (0.420350228),
      MLO_FLOAT_C (0.422567522),
      MLO_FLOAT_C (0.424786918),
      MLO_FLOAT_C (0.427008355),
      MLO_FLOAT_C (0.429231774),
      MLO_FLOAT_C (0.431457113),
      MLO_FLOAT_C (0.433684313),
      MLO_FLOAT_C (0.435913311),
      MLO_FLOAT_C (0.438144047),
      MLO_FLOAT_C (0.440376459),
      MLO_FLOAT_C (0.442610488),
      MLO_FLOAT_C (0.44484607),
      MLO_FLOAT_C (0.447083144),
      MLO_FLOAT_C (0.44932165),
      MLO_FLOAT_C (0.451561524),
      MLO_FLOAT_C (0.453802706),
      MLO_FLOAT_C (0.456045133),
      MLO_FLOAT_C (0.458288743),
      MLO_FLOAT_C (0.460533474),
      MLO_FLOAT_C (0.462779264),
      MLO_FLOAT_C (0.465026051),
      MLO_FLOAT_C (0.467273771),
      MLO_FLOAT_C (0.469522363),
      MLO_FLOAT_C (0.471771764),
      MLO_FLOAT_C (0.474021911),
      MLO_FLOAT_C (0.476272742),
      MLO_FLOAT_C (0.478524194),
      MLO_FLOAT_C (0.480776204),
      MLO_FLOAT_C (0.483028709),
      MLO_FLOAT_C (0.485281646),
      MLO_FLOAT_C (0.487534953),
      MLO_FLOAT_C (0.489788566),
      MLO_FLOAT_C (0.492042423),
      MLO_FLOAT_C (0.49429646),
      MLO_FLOAT_C (0.496550614),
      MLO_FLOAT_C (0.498804823),
      MLO_FLOAT_C (0.501059022),
      MLO_FLOAT_C (0.50331315),
      MLO_FLOAT_C (0.505567142),
      MLO_FLOAT_C (0.507820936),
      MLO_FLOAT_C (0.510074469),
      MLO_FLOAT_C (0.512327677),
      MLO_FLOAT_C (0.514580498),
      MLO_FLOAT_C (0.516832868),
      MLO_FLOAT_C (0.519084724),
      MLO_FLOAT_C (0.521336004),
      MLO_FLOAT_C (0.523586643),
      MLO_FLOAT_C (0.52583658),
      MLO_FLOAT_C (0.528085751),
      MLO_FLOAT_C (0.530334093),
      MLO_FLOAT_C (0.532581544),
      MLO_FLOAT_C (0.53482804),
      MLO_FLOAT_C (0.53707352),
      MLO_FLOAT_C (0.539317919),
      MLO_FLOAT_C (0.541561177),
      MLO_FLOAT_C (0.543803229),
      MLO_FLOAT_C (0.546044014),
      MLO_FLOAT_C (0.548283469),
      MLO_FLOAT_C (0.550521531),
      MLO_FLOAT_C (0.55275814),
      MLO_FLOAT_C (0.554993231),
      MLO_FLOAT_C (0.557226744),
      MLO_FLOAT_C (0.559458617),
      MLO_FLOAT_C (0.561688786),
      MLO_FLOAT_C (0.563917192),
      MLO_FLOAT_C (0.566143772),
      MLO_FLOAT_C (0.568368464),
      MLO_FLOAT_C (0.570591208),
      MLO_FLOAT_C (0.572811941),
      MLO_FLOAT_C (0.575030603),
      MLO_FLOAT_C (0.577247133),
      MLO_FLOAT_C (0.57946147),
      MLO_FLOAT_C (0.581673553),
      MLO_FLOAT_C (0.583883321),
      MLO_FLOAT_C (0.586090714),
      MLO_FLOAT_C (0.588295673),
      MLO_FLOAT_C (0.590498136),
      MLO_FLOAT_C (0.592698043),
      MLO_FLOAT_C (0.594895336),
      MLO_FLOAT_C (0.597089954),
      MLO_FLOAT_C (0.599281837),
      MLO_FLOAT_C (0.601470927),
      MLO_FLOAT_C (0.603657165),
      MLO_FLOAT_C (0.605840491),
      MLO_FLOAT_C (0.608020847),
      MLO_FLOAT_C (0.610198175),
      MLO_FLOAT_C (0.612372416),
      MLO_FLOAT_C (0.614543511),
      MLO_FLOAT_C (0.616711404),
      MLO_FLOAT_C (0.618876036),
      MLO_FLOAT_C (0.62103735),
      MLO_FLOAT_C (0.623195288),
      MLO_FLOAT_C (0.625349794),
      MLO_FLOAT_C (0.627500811),
      MLO_FLOAT_C (0.629648283),
      MLO_FLOAT_C (0.631792152),
      MLO_FLOAT_C (0.633932363),
      MLO_FLOAT_C (0.636068861),
      MLO_FLOAT_C (0.638201588),
      MLO_FLOAT_C (0.640330491),
      MLO_FLOAT_C (0.642455514),
      MLO_FLOAT_C (0.644576603),
      MLO_FLOAT_C (0.646693701),
      MLO_FLOAT_C (0.648806757),
      MLO_FLOAT_C (0.650915714),
      MLO_FLOAT_C (0.653020521),
      MLO_FLOAT_C (0.655121122),
      MLO_FLOAT_C (0.657217466),
      MLO_FLOAT_C (0.659309498),
      MLO_FLOAT_C (0.661397168),
      MLO_FLOAT_C (0.663480421),
      MLO_FLOAT_C (0.665559206),
      MLO_FLOAT_C (0.667633472),
      MLO_FLOAT_C (0.669703167),
      MLO_FLOAT_C (0.67176824),
      MLO_FLOAT_C (0.67382864),
      MLO_FLOAT_C (0.675884317),
      MLO_FLOAT_C (0.67793522),
      MLO_FLOAT_C (0.6799813),
      MLO_FLOAT_C (0.682022506),
      MLO_FLOAT_C (0.684058791),
      MLO_FLOAT_C (0.686090105),
      MLO_FLOAT_C (0.6881164),
      MLO_FLOAT_C (0.690137627),
      MLO_FLOAT_C (0.692153738),
      MLO_FLOAT_C (0.694164687),
      MLO_FLOAT_C (0.696170425),
      MLO_FLOAT_C (0.698170906),
      MLO_FLOAT_C (0.700166084),
      MLO_FLOAT_C (0.702155913),
      MLO_FLOAT_C (0.704140346),
      MLO_FLOAT_C (0.706119339),
      MLO_FLOAT_C (0.708092846),
      MLO_FLOAT_C (0.710060823),
      MLO_FLOAT_C (0.712023226),
      MLO_FLOAT_C (0.71398001),
      MLO_FLOAT_C (0.715931132),
      MLO_FLOAT_C (0.717876549),
      MLO_FLOAT_C (0.719816218),
      MLO_FLOAT_C (0.721750097),
      MLO_FLOAT_C (0.723678144),
      MLO_FLOAT_C (0.725600317),
      MLO_FLOAT_C (0.727516575),
      MLO_FLOAT_C (0.729426878),
      MLO_FLOAT_C (0.731331184),
      MLO_FLOAT_C (0.733229454),
      MLO_FLOAT_C (0.735121648),
      MLO_FLOAT_C (0.737007728),
      MLO_FLOAT_C (0.738887653),
      MLO_FLOAT_C (0.740761387),
      MLO_FLOAT_C (0.74262889),
      MLO_FLOAT_C (0.744490125),
      MLO_FLOAT_C (0.746345056),
      MLO_FLOAT_C (0.748193645),
      MLO_FLOAT_C (0.750035857),
      MLO_FLOAT_C (0.751871655),
      MLO_FLOAT_C (0.753701003),
      MLO_FLOAT_C (0.755523868),
      MLO_FLOAT_C (0.757340214),
      MLO_FLOAT_C (0.759150007),
      MLO_FLOAT_C (0.760953213),
      MLO_FLOAT_C (0.762749799),
      MLO_FLOAT_C (0.764539733),
      MLO_FLOAT_C (0.766322982),
      MLO_FLOAT_C (0.768099513),
      MLO_FLOAT_C (0.769869296),
      MLO_FLOAT_C (0.771632299),
      MLO_FLOAT_C (0.773388491),
      MLO_FLOAT_C (0.775137844),
      MLO_FLOAT_C (0.776880325),
      MLO_FLOAT_C (0.778615908),
      MLO_FLOAT_C (0.780344562),
      MLO_FLOAT_C (0.782066259),
      MLO_FLOAT_C (0.783780971),
      MLO_FLOAT_C (0.785488671),
      MLO_FLOAT_C (0.787189332),
      MLO_FLOAT_C (0.788882927),
      MLO_FLOAT_C (0.790569431),
      MLO_FLOAT_C (0.792248817),
      MLO_FLOAT_C (0.79392106),
      MLO_FLOAT_C (0.795586136),
      MLO_FLOAT_C (0.79724402),
      MLO_FLOAT_C (0.798894689),
      MLO_FLOAT_C (0.800538119),
      MLO_FLOAT_C (0.802174287),
      MLO_FLOAT_C (0.803803172),
      MLO_FLOAT_C (0.805424751),
      MLO_FLOAT_C (0.807039003),
      MLO_FLOAT_C (0.808645906),
      MLO_FLOAT_C (0.810245441),
      MLO_FLOAT_C (0.811837587),
      MLO_FLOAT_C (0.813422325),
      MLO_FLOAT_C (0.814999635),
      MLO_FLOAT_C (0.816569499),
      MLO_FLOAT_C (0.8181319),
      MLO_FLOAT_C (0.819686818),
      MLO_FLOAT_C (0.821234238),
      MLO_FLOAT_C (0.822774142),
      MLO_FLOAT_C (0.824306514),
      MLO_FLOAT_C (0.825831339),
      MLO_FLOAT_C (0.827348601),
      MLO_FLOAT_C (0.828858285),
      MLO_FLOAT_C (0.830360377),
      MLO_FLOAT_C (0.831854863),
      MLO_FLOAT_C (0.83334173),
      MLO_FLOAT_C (0.834820965),
      MLO_FLOAT_C (0.836292555),
      MLO_FLOAT_C (0.837756489),
      MLO_FLOAT_C (0.839212755),
      MLO_FLOAT_C (0.840661342),
      MLO_FLOAT_C (0.842102239),
      MLO_FLOAT_C (0.843535437),
      MLO_FLOAT_C (0.844960926),
      MLO_FLOAT_C (0.846378697),
      MLO_FLOAT_C (0.847788741),
      MLO_FLOAT_C (0.84919105),
      MLO_FLOAT_C (0.850585617),
      MLO_FLOAT_C (0.851972433),
      MLO_FLOAT_C (0.853351493),
      MLO_FLOAT_C (0.854722791),
      MLO_FLOAT_C (0.85608632),
      MLO_FLOAT_C (0.857442074),
      MLO_FLOAT_C (0.858790051),
      MLO_FLOAT_C (0.860130244),
      MLO_FLOAT_C (0.86146265),
      MLO_FLOAT_C (0.862787265),
      MLO_FLOAT_C (0.864104087),
      MLO_FLOAT_C (0.865413113),
      MLO_FLOAT_C (0.866714341),
      MLO_FLOAT_C (0.868007769),
      MLO_FLOAT_C (0.869293397),
      MLO_FLOAT_C (0.870571223),
      MLO_FLOAT_C (0.871841247),
      MLO_FLOAT_C (0.87310347),
      MLO_FLOAT_C (0.874357892),
      MLO_FLOAT_C (0.875604515),
      MLO_FLOAT_C (0.87684334),
      MLO_FLOAT_C (0.878074368),
      MLO_FLOAT_C (0.879297603),
      MLO_FLOAT_C (0.880513048),
      MLO_FLOAT_C (0.881720706),
      MLO_FLOAT_C (0.88292058),
      MLO_FLOAT_C (0.884112675),
      MLO_FLOAT_C (0.885296997),
      MLO_FLOAT_C (0.886473549),
      MLO_FLOAT_C (0.887642337),
      MLO_FLOAT_C (0.888803368),
      MLO_FLOAT_C (0.889956649),
      MLO_FLOAT_C (0.891102185),
      MLO_FLOAT_C (0.892239984),
      MLO_FLOAT_C (0.893370055),
      MLO_FLOAT_C (0.894492405),
      MLO_FLOAT_C (0.895607042),
      MLO_FLOAT_C (0.896713977),
      MLO_FLOAT_C (0.897813218),
      MLO_FLOAT_C (0.898904775),
      MLO_FLOAT_C (0.899988659),
      MLO_FLOAT_C (0.901064879),
      MLO_FLOAT_C (0.902133449),
      MLO_FLOAT_C (0.903194378),
      MLO_FLOAT_C (0.904247679),
      MLO_FLOAT_C (0.905293364),
      MLO_FLOAT_C (0.906331446),
      MLO_FLOAT_C (0.907361938),
      MLO_FLOAT_C (0.908384853),
      MLO_FLOAT_C (0.909400206),
      MLO_FLOAT_C (0.910408011),
      MLO_FLOAT_C (0.911408282),
      MLO_FLOAT_C (0.912401034),
      MLO_FLOAT_C (0.913386284),
      MLO_FLOAT_C (0.914364047),
      MLO_FLOAT_C (0.915334338),
      MLO_FLOAT_C (0.916297176),
      MLO_FLOAT_C (0.917252576),
      MLO_FLOAT_C (0.918200556),
      MLO_FLOAT_C (0.919141134),
      MLO_FLOAT_C (0.920074327),
      MLO_FLOAT_C (0.921000155),
      MLO_FLOAT_C (0.921918636),
      MLO_FLOAT_C (0.922829789),
      MLO_FLOAT_C (0.923733633),
      MLO_FLOAT_C (0.92463019),
      MLO_FLOAT_C (0.925519477),
      MLO_FLOAT_C (0.926401517),
      MLO_FLOAT_C (0.92727633),
      MLO_FLOAT_C (0.928143938),
      MLO_FLOAT_C (0.929004361),
      MLO_FLOAT_C (0.929857621),
      MLO_FLOAT_C (0.930703742),
      MLO_FLOAT_C (0.931542745),
      MLO_FLOAT_C (0.932374653),
      MLO_FLOAT_C (0.933199489),
      MLO_FLOAT_C (0.934017277),
      MLO_FLOAT_C (0.93482804),
      MLO_FLOAT_C (0.935631803),
      MLO_FLOAT_C (0.93642859),
      MLO_FLOAT_C (0.937218425),
      MLO_FLOAT_C (0.938001334),
      MLO_FLOAT_C (0.938777342),
      MLO_FLOAT_C (0.939546474),
      MLO_FLOAT_C (0.940308756),
      MLO_FLOAT_C (0.941064214),
      MLO_FLOAT_C (0.941812875),
      MLO_FLOAT_C (0.942554764),
      MLO_FLOAT_C (0.94328991),
      MLO_FLOAT_C (0.94401834),
      MLO_FLOAT_C (0.944740079),
      MLO_FLOAT_C (0.945455158),
      MLO_FLOAT_C (0.946163602),
      MLO_FLOAT_C (0.946865441),
      MLO_FLOAT_C (0.947560703),
      MLO_FLOAT_C (0.948249417),
      MLO_FLOAT_C (0.948931611),
      MLO_FLOAT_C (0.949607315),
      MLO_FLOAT_C (0.950276558),
      MLO_FLOAT_C (0.95093937),
      MLO_FLOAT_C (0.95159578),
      MLO_FLOAT_C (0.952245818),
      MLO_FLOAT_C (0.952889516),
      MLO_FLOAT_C (0.953526903),
      MLO_FLOAT_C (0.95415801),
      MLO_FLOAT_C (0.954782867),
      MLO_FLOAT_C (0.955401507),
      MLO_FLOAT_C (0.95601396),
      MLO_FLOAT_C (0.956620257),
      MLO_FLOAT_C (0.957220431),
      MLO_FLOAT_C (0.957814513),
      MLO_FLOAT_C (0.958402536),
      MLO_FLOAT_C (0.958984531),
      MLO_FLOAT_C (0.95956053),
      MLO_FLOAT_C (0.960130567),
      MLO_FLOAT_C (0.960694674),
      MLO_FLOAT_C (0.961252884),
      MLO_FLOAT_C (0.961805229),
      MLO_FLOAT_C (0.962351744),
      MLO_FLOAT_C (0.962892461),
      MLO_FLOAT_C (0.963427414),
      MLO_FLOAT_C (0.963956636),
      MLO_FLOAT_C (0.964480161),
      MLO_FLOAT_C (0.964998023),
      MLO_FLOAT_C (0.965510257),
      MLO_FLOAT_C (0.966016895),
      MLO_FLOAT_C (0.966517972),
      MLO_FLOAT_C (0.967013523),
      MLO_FLOAT_C (0.967503582),
      MLO_FLOAT_C (0.967988184),
      MLO_FLOAT_C (0.968467363),
      MLO_FLOAT_C (0.968941153),
      MLO_FLOAT_C (0.969409591),
      MLO_FLOAT_C (0.969872711),
      MLO_FLOAT_C (0.970330547),
      MLO_FLOAT_C (0.970783135),
      MLO_FLOAT_C (0.97123051),
      MLO_FLOAT_C (0.971672708),
      MLO_FLOAT_C (0.972109763),
      MLO_FLOAT_C (0.972541711),
      MLO_FLOAT_C (0.972968588),
      MLO_FLOAT_C (0.973390429),
      MLO_FLOAT_C (0.973807269),
      MLO_FLOAT_C (0.974219145),
      MLO_FLOAT_C (0.974626091),
      MLO_FLOAT_C (0.975028144),
      MLO_FLOAT_C (0.975425339),
      MLO_FLOAT_C (0.975817713),
      MLO_FLOAT_C (0.9762053),
      MLO_FLOAT_C (0.976588137),
      MLO_FLOAT_C (0.97696626),
      MLO_FLOAT_C (0.977339704),
      MLO_FLOAT_C (0.977708506),
      MLO_FLOAT_C (0.978072701),
      MLO_FLOAT_C (0.978432325),
      MLO_FLOAT_C (0.978787414),
      MLO_FLOAT_C (0.979138005),
      MLO_FLOAT_C (0.979484132),
      MLO_FLOAT_C (0.979825832),
      MLO_FLOAT_C (0.980163141),
      MLO_FLOAT_C (0.980496095),
      MLO_FLOAT_C (0.980824729),
      MLO_FLOAT_C (0.98114908),
      MLO_FLOAT_C (0.981469182),
      MLO_FLOAT_C (0.981785073),
      MLO_FLOAT_C (0.982096788),
      MLO_FLOAT_C (0.982404362),
      MLO_FLOAT_C (0.982707831),
      MLO_FLOAT_C (0.983007231),
      MLO_FLOAT_C (0.983302598),
      MLO_FLOAT_C (0.983593966),
      MLO_FLOAT_C (0.983881372),
      MLO_FLOAT_C (0.984164851),
      MLO_FLOAT_C (0.984444438),
      MLO_FLOAT_C (0.984720169),
      MLO_FLOAT_C (0.984992079),
      MLO_FLOAT_C (0.985260202),
      MLO_FLOAT_C (0.985524575),
      MLO_FLOAT_C (0.985785232),
      MLO_FLOAT_C (0.986042208),
      MLO_FLOAT_C (0.986295538),
      MLO_FLOAT_C (0.986545257),
      MLO_FLOAT_C (0.9867914),
      MLO_FLOAT_C (0.987034),
      MLO_FLOAT_C (0.987273093),
      MLO_FLOAT_C (0.987508714),
      MLO_FLOAT_C (0.987740895),
      MLO_FLOAT_C (0.987969672),
      MLO_FLOAT_C (0.988195079),
      MLO_FLOAT_C (0.988417149),
      MLO_FLOAT_C (0.988635917),
      MLO_FLOAT_C (0.988851417),
      MLO_FLOAT_C (0.989063681),
      MLO_FLOAT_C (0.989272744),
      MLO_FLOAT_C (0.989478638),
      MLO_FLOAT_C (0.989681398),
      MLO_FLOAT_C (0.989881057),
      MLO_FLOAT_C (0.990077647),
      MLO_FLOAT_C (0.990271201),
      MLO_FLOAT_C (0.990461752),
      MLO_FLOAT_C (0.990649333),
      MLO_FLOAT_C (0.990833976),
      MLO_FLOAT_C (0.991015713),
      MLO_FLOAT_C (0.991194578),
      MLO_FLOAT_C (0.991370601),
      MLO_FLOAT_C (0.991543815),
      MLO_FLOAT_C (0.991714251),
      MLO_FLOAT_C (0.991881941),
      MLO_FLOAT_C (0.992046917),
      MLO_FLOAT_C (0.992209209),
      MLO_FLOAT_C (0.99236885),
      MLO_FLOAT_C (0.992525869),
      MLO_FLOAT_C (0.992680298),
      MLO_FLOAT_C (0.992832167),
      MLO_FLOAT_C (0.992981507),
      MLO_FLOAT_C (0.993128348),
      MLO_FLOAT_C (0.99327272),
      MLO_FLOAT_C (0.993414653),
      MLO_FLOAT_C (0.993554177),
      MLO_FLOAT_C (0.993691321),
      MLO_FLOAT_C (0.993826116),
      MLO_FLOAT_C (0.993958589),
      MLO_FLOAT_C (0.994088771),
      MLO_FLOAT_C (0.99421669),
      MLO_FLOAT_C (0.994342374),
      MLO_FLOAT_C (0.994465853),
      MLO_FLOAT_C (0.994587154),
      MLO_FLOAT_C (0.994706306),
      MLO_FLOAT_C (0.994823337),
      MLO_FLOAT_C (0.994938274),
      MLO_FLOAT_C (0.995051145),
      MLO_FLOAT_C (0.995161977),
      MLO_FLOAT_C (0.995270798),
      MLO_FLOAT_C (0.995377634),
      MLO_FLOAT_C (0.995482513),
      MLO_FLOAT_C (0.99558546),
      MLO_FLOAT_C (0.995686503),
      MLO_FLOAT_C (0.995785666),
      MLO_FLOAT_C (0.995882977),
      MLO_FLOAT_C (0.995978462),
      MLO_FLOAT_C (0.996072145),
      MLO_FLOAT_C (0.996164052),
      MLO_FLOAT_C (0.996254208),
      MLO_FLOAT_C (0.996342638),
      MLO_FLOAT_C (0.996429367),
      MLO_FLOAT_C (0.99651442),
      MLO_FLOAT_C (0.99659782),
      MLO_FLOAT_C (0.996679592),
      MLO_FLOAT_C (0.996759761),
      MLO_FLOAT_C (0.996838348),
      MLO_FLOAT_C (0.996915379),
      MLO_FLOAT_C (0.996990876),
      MLO_FLOAT_C (0.997064863),
      MLO_FLOAT_C (0.997137362),
      MLO_FLOAT_C (0.997208396),
      MLO_FLOAT_C (0.997277987),
      MLO_FLOAT_C (0.997346158),
      MLO_FLOAT_C (0.997412931),
      MLO_FLOAT_C (0.997478327),
      MLO_FLOAT_C (0.997542369),
      MLO_FLOAT_C (0.997605077),
      MLO_FLOAT_C (0.997666473),
      MLO_FLOAT_C (0.997726577),
      MLO_FLOAT_C (0.997785411),
      MLO_FLOAT_C (0.997842995),
      MLO_FLOAT_C (0.99789935),
      MLO_FLOAT_C (0.997954495),
      MLO_FLOAT_C (0.99800845),
      MLO_FLOAT_C (0.998061236),
      MLO_FLOAT_C (0.998112871),
      MLO_FLOAT_C (0.998163376),
      MLO_FLOAT_C (0.998212768),
      MLO_FLOAT_C (0.998261067),
      MLO_FLOAT_C (0.998308292),
      MLO_FLOAT_C (0.998354461),
      MLO_FLOAT_C (0.998399593),
      MLO_FLOAT_C (0.998443704),
      MLO_FLOAT_C (0.998486814),
      MLO_FLOAT_C (0.99852894),
      MLO_FLOAT_C (0.998570098),
      MLO_FLOAT_C (0.998610308),
      MLO_FLOAT_C (0.998649584),
      MLO_FLOAT_C (0.998687945),
      MLO_FLOAT_C (0.998725407),
      MLO_FLOAT_C (0.998761986),
      MLO_FLOAT_C (0.998797699),
      MLO_FLOAT_C (0.998832561),
      MLO_FLOAT_C (0.998866588),
      MLO_FLOAT_C (0.998899796),
      MLO_FLOAT_C (0.998932201),
      MLO_FLOAT_C (0.998963817),
      MLO_FLOAT_C (0.998994659),
      MLO_FLOAT_C (0.999024743),
      MLO_FLOAT_C (0.999054082),
      MLO_FLOAT_C (0.999082692),
      MLO_FLOAT_C (0.999110586),
      MLO_FLOAT_C (0.999137779),
      MLO_FLOAT_C (0.999164285),
      MLO_FLOAT_C (0.999190116),
      MLO_FLOAT_C (0.999215287),
      MLO_FLOAT_C (0.999239811),
      MLO_FLOAT_C (0.999263701),
      MLO_FLOAT_C (0.999286969),
      MLO_FLOAT_C (0.999309629),
      MLO_FLOAT_C (0.999331693),
      MLO_FLOAT_C (0.999353173),
      MLO_FLOAT_C (0.999374082),
      MLO_FLOAT_C (0.999394432),
      MLO_FLOAT_C (0.999414234),
      MLO_FLOAT_C (0.9994335),
      MLO_FLOAT_C (0.999452241),
      MLO_FLOAT_C (0.99947047),
      MLO_FLOAT_C (0.999488196),
      MLO_FLOAT_C (0.999505431),
      MLO_FLOAT_C (0.999522185),
      MLO_FLOAT_C (0.99953847),
      MLO_FLOAT_C (0.999554295),
      MLO_FLOAT_C (0.999569671),
      MLO_FLOAT_C (0.999584608),
      MLO_FLOAT_C (0.999599116),
      MLO_FLOAT_C (0.999613205),
      MLO_FLOAT_C (0.999626883),
      MLO_FLOAT_C (0.999640162),
      MLO_FLOAT_C (0.99965305),
      MLO_FLOAT_C (0.999665556),
      MLO_FLOAT_C (0.999677689),
      MLO_FLOAT_C (0.999689458),
      MLO_FLOAT_C (0.999700871),
      MLO_FLOAT_C (0.999711938),
      MLO_FLOAT_C (0.999722666),
      MLO_FLOAT_C (0.999733064),
      MLO_FLOAT_C (0.99974314),
      MLO_FLOAT_C (0.999752902),
      MLO_FLOAT_C (0.999762357),
      MLO_FLOAT_C (0.999771513),
      MLO_FLOAT_C (0.999780379),
      MLO_FLOAT_C (0.99978896),
      MLO_FLOAT_C (0.999797264),
      MLO_FLOAT_C (0.999805299),
      MLO_FLOAT_C (0.999813072),
      MLO_FLOAT_C (0.999820588),
      MLO_FLOAT_C (0.999827855),
      MLO_FLOAT_C (0.99983488),
      MLO_FLOAT_C (0.999841669),
      MLO_FLOAT_C (0.999848228),
      MLO_FLOAT_C (0.999854563),
      MLO_FLOAT_C (0.999860681),
      MLO_FLOAT_C (0.999866587),
      MLO_FLOAT_C (0.999872287),
      MLO_FLOAT_C (0.999877788),
      MLO_FLOAT_C (0.999883093),
      MLO_FLOAT_C (0.99988821),
      MLO_FLOAT_C (0.999893143),
      MLO_FLOAT_C (0.999897897),
      MLO_FLOAT_C (0.999902478),
      MLO_FLOAT_C (0.999906891),
      MLO_FLOAT_C (0.99991114),
      MLO_FLOAT_C (0.999915231),
      MLO_FLOAT_C (0.999919168),
      MLO_FLOAT_C (0.999922955),
      MLO_FLOAT_C (0.999926598),
      MLO_FLOAT_C (0.9999301),
      MLO_FLOAT_C (0.999933466),
      MLO_FLOAT_C (0.9999367),
      MLO_FLOAT_C (0.999939805),
      MLO_FLOAT_C (0.999942788),
      MLO_FLOAT_C (0.99994565),
      MLO_FLOAT_C (0.999948395),
      MLO_FLOAT_C (0.999951029),
      MLO_FLOAT_C (0.999953553),
      MLO_FLOAT_C (0.999955973),
      MLO_FLOAT_C (0.99995829),
      MLO_FLOAT_C (0.999960509),
      MLO_FLOAT_C (0.999962633),
      MLO_FLOAT_C (0.999964664),
      MLO_FLOAT_C (0.999966607),
      MLO_FLOAT_C (0.999968464),
      MLO_FLOAT_C (0.999970239),
      MLO_FLOAT_C (0.999971933),
      MLO_FLOAT_C (0.99997355),
      MLO_FLOAT_C (0.999975092),
      MLO_FLOAT_C (0.999976563),
      MLO_FLOAT_C (0.999977965),
      MLO_FLOAT_C (0.9999793),
      MLO_FLOAT_C (0.999980571),
      MLO_FLOAT_C (0.999981781),
      MLO_FLOAT_C (0.99998293),
      MLO_FLOAT_C (0.999984023),
      MLO_FLOAT_C (0.99998506),
      MLO_FLOAT_C (0.999986045),
      MLO_FLOAT_C (0.999986979),
      MLO_FLOAT_C (0.999987864),
      MLO_FLOAT_C (0.999988702),
      MLO_FLOAT_C (0.999989495),
      MLO_FLOAT_C (0.999990245),
      MLO_FLOAT_C (0.999990954),
      MLO_FLOAT_C (0.999991623),
      MLO_FLOAT_C (0.999992254),
      MLO_FLOAT_C (0.999992849),
      MLO_FLOAT_C (0.999993409),
      MLO_FLOAT_C (0.999993936),
      MLO_FLOAT_C (0.999994431),
      MLO_FLOAT_C (0.999994896),
      MLO_FLOAT_C (0.999995331),
      MLO_FLOAT_C (0.99999574),
      MLO_FLOAT_C (0.999996121),
      MLO_FLOAT_C (0.999996478),
      MLO_FLOAT_C (0.999996811),
      MLO_FLOAT_C (0.999997121),
      MLO_FLOAT_C (0.999997409),
      MLO_FLOAT_C (0.999997677),
      MLO_FLOAT_C (0.999997925),
      MLO_FLOAT_C (0.999998155),
      MLO_FLOAT_C (0.999998367),
      MLO_FLOAT_C (0.999998562),
      MLO_FLOAT_C (0.999998742),
      MLO_FLOAT_C (0.999998907),
      MLO_FLOAT_C (0.999999058),
      MLO_FLOAT_C (0.999999196),
      MLO_FLOAT_C (0.999999321),
      MLO_FLOAT_C (0.999999435),
      MLO_FLOAT_C (0.999999537),
      MLO_FLOAT_C (0.99999963),
      MLO_FLOAT_C (0.999999712),
      MLO_FLOAT_C (0.999999786),
      MLO_FLOAT_C (0.999999851),
      MLO_FLOAT_C (0.999999908),
      MLO_FLOAT_C (0.999999957),
      MLO_FLOAT_C (0.999999957),
      MLO_FLOAT_C (0.999999908),
      MLO_FLOAT_C (0.999999851),
      MLO_FLOAT_C (0.999999786),
      MLO_FLOAT_C (0.999999712),
      MLO_FLOAT_C (0.99999963),
      MLO_FLOAT_C (0.999999537),
      MLO_FLOAT_C (0.999999435),
      MLO_FLOAT_C (0.999999321),
      MLO_FLOAT_C (0.999999196),
      MLO_FLOAT_C (0.999999058),
      MLO_FLOAT_C (0.999998907),
      MLO_FLOAT_C (0.999998742),
      MLO_FLOAT_C (0.999998562),
      MLO_FLOAT_C (0.999998367),
      MLO_FLOAT_C (0.999998155),
      MLO_FLOAT_C (0.999997925),
      MLO_FLOAT_C (0.999997677),
      MLO_FLOAT_C (0.999997409),
      MLO_FLOAT_C (0.999997121),
      MLO_FLOAT_C (0.999996811),
      MLO_FLOAT_C (0.999996478),
      MLO_FLOAT_C (0.999996121),
      MLO_FLOAT_C (0.99999574),
      MLO_FLOAT_C (0.999995331),
      MLO_FLOAT_C (0.999994896),
      MLO_FLOAT_C (0.999994431),
      MLO_FLOAT_C (0.999993936),
      MLO_FLOAT_C (0.999993409),
      MLO_FLOAT_C (0.999992849),
      MLO_FLOAT_C (0.999992254),
      MLO_FLOAT_C (0.999991623),
      MLO_FLOAT_C (0.999990954),
      MLO_FLOAT_C (0.999990245),
      MLO_FLOAT_C (0.999989495),
      MLO_FLOAT_C (0.999988702),
      MLO_FLOAT_C (0.999987864),
      MLO_FLOAT_C (0.999986979),
      MLO_FLOAT_C (0.999986045),
      MLO_FLOAT_C (0.99998506),
      MLO_FLOAT_C (0.999984023),
      MLO_FLOAT_C (0.99998293),
      MLO_FLOAT_C (0.999981781),
      MLO_FLOAT_C (0.999980571),
      MLO_FLOAT_C (0.9999793),
      MLO_FLOAT_C (0.999977965),
      MLO_FLOAT_C (0.999976563),
      MLO_FLOAT_C (0.999975092),
      MLO_FLOAT_C (0.99997355),
      MLO_FLOAT_C (0.999971933),
      MLO_FLOAT_C (0.999970239),
      MLO_FLOAT_C (0.999968464),
      MLO_FLOAT_C (0.999966607),
      MLO_FLOAT_C (0.999964664),
      MLO_FLOAT_C (0.999962633),
      MLO_FLOAT_C (0.999960509),
      MLO_FLOAT_C (0.99995829),
      MLO_FLOAT_C (0.999955973),
      MLO_FLOAT_C (0.999953553),
      MLO_FLOAT_C (0.999951029),
      MLO_FLOAT_C (0.999948395),
      MLO_FLOAT_C (0.99994565),
      MLO_FLOAT_C (0.999942788),
      MLO_FLOAT_C (0.999939805),
      MLO_FLOAT_C (0.9999367),
      MLO_FLOAT_C (0.999933466),
      MLO_FLOAT_C (0.9999301),
      MLO_FLOAT_C (0.999926598),
      MLO_FLOAT_C (0.999922955),
      MLO_FLOAT_C (0.999919168),
      MLO_FLOAT_C (0.999915231),
      MLO_FLOAT_C (0.99991114),
      MLO_FLOAT_C (0.999906891),
      MLO_FLOAT_C (0.999902478),
      MLO_FLOAT_C (0.999897897),
      MLO_FLOAT_C (0.999893143),
      MLO_FLOAT_C (0.99988821),
      MLO_FLOAT_C (0.999883093),
      MLO_FLOAT_C (0.999877788),
      MLO_FLOAT_C (0.999872287),
      MLO_FLOAT_C (0.999866587),
      MLO_FLOAT_C (0.999860681),
      MLO_FLOAT_C (0.999854563),
      MLO_FLOAT_C (0.999848228),
      MLO_FLOAT_C (0.999841669),
      MLO_FLOAT_C (0.99983488),
      MLO_FLOAT_C (0.999827855),
      MLO_FLOAT_C (0.999820588),
      MLO_FLOAT_C (0.999813072),
      MLO_FLOAT_C (0.999805299),
      MLO_FLOAT_C (0.999797264),
      MLO_FLOAT_C (0.99978896),
      MLO_FLOAT_C (0.999780379),
      MLO_FLOAT_C (0.999771513),
      MLO_FLOAT_C (0.999762357),
      MLO_FLOAT_C (0.999752902),
      MLO_FLOAT_C (0.99974314),
      MLO_FLOAT_C (0.999733064),
      MLO_FLOAT_C (0.999722666),
      MLO_FLOAT_C (0.999711938),
      MLO_FLOAT_C (0.999700871),
      MLO_FLOAT_C (0.999689458),
      MLO_FLOAT_C (0.999677689),
      MLO_FLOAT_C (0.999665556),
      MLO_FLOAT_C (0.99965305),
      MLO_FLOAT_C (0.999640162),
      MLO_FLOAT_C (0.999626883),
      MLO_FLOAT_C (0.999613205),
      MLO_FLOAT_C (0.999599116),
      MLO_FLOAT_C (0.999584608),
      MLO_FLOAT_C (0.999569671),
      MLO_FLOAT_C (0.999554295),
      MLO_FLOAT_C (0.99953847),
      MLO_FLOAT_C (0.999522185),
      MLO_FLOAT_C (0.999505431),
      MLO_FLOAT_C (0.999488196),
      MLO_FLOAT_C (0.99947047),
      MLO_FLOAT_C (0.999452241),
      MLO_FLOAT_C (0.9994335),
      MLO_FLOAT_C (0.999414234),
      MLO_FLOAT_C (0.999394432),
      MLO_FLOAT_C (0.999374082),
      MLO_FLOAT_C (0.999353173),
      MLO_FLOAT_C (0.999331693),
      MLO_FLOAT_C (0.999309629),
      MLO_FLOAT_C (0.999286969),
      MLO_FLOAT_C (0.999263701),
      MLO_FLOAT_C (0.999239811),
      MLO_FLOAT_C (0.999215287),
      MLO_FLOAT_C (0.999190116),
      MLO_FLOAT_C (0.999164285),
      MLO_FLOAT_C (0.999137779),
      MLO_FLOAT_C (0.999110586),
      MLO_FLOAT_C (0.999082692),
      MLO_FLOAT_C (0.999054082),
      MLO_FLOAT_C (0.999024743),
      MLO_FLOAT_C (0.998994659),
      MLO_FLOAT_C (0.998963817),
      MLO_FLOAT_C (0.998932201),
      MLO_FLOAT_C (0.998899796),
      MLO_FLOAT_C (0.998866588),
      MLO_FLOAT_C (0.998832561),
      MLO_FLOAT_C (0.998797699),
      MLO_FLOAT_C (0.998761986),
      MLO_FLOAT_C (0.998725407),
      MLO_FLOAT_C (0.998687945),
      MLO_FLOAT_C (0.998649584),
      MLO_FLOAT_C (0.998610308),
      MLO_FLOAT_C (0.998570098),
      MLO_FLOAT_C (0.99852894),
      MLO_FLOAT_C (0.998486814),
      MLO_FLOAT_C (0.998443704),
      MLO_FLOAT_C (0.998399593),
      MLO_FLOAT_C (0.998354461),
      MLO_FLOAT_C (0.998308292),
      MLO_FLOAT_C (0.998261067),
      MLO_FLOAT_C (0.998212768),
      MLO_FLOAT_C (0.998163376),
      MLO_FLOAT_C (0.998112871),
      MLO_FLOAT_C (0.998061236),
      MLO_FLOAT_C (0.99800845),
      MLO_FLOAT_C (0.997954495),
      MLO_FLOAT_C (0.99789935),
      MLO_FLOAT_C (0.997842995),
      MLO_FLOAT_C (0.997785411),
      MLO_FLOAT_C (0.997726577),
      MLO_FLOAT_C (0.997666473),
      MLO_FLOAT_C (0.997605077),
      MLO_FLOAT_C (0.997542369),
      MLO_FLOAT_C (0.997478327),
      MLO_FLOAT_C (0.997412931),
      MLO_FLOAT_C (0.997346158),
      MLO_FLOAT_C (0.997277987),
      MLO_FLOAT_C (0.997208396),
      MLO_FLOAT_C (0.997137362),
      MLO_FLOAT_C (0.997064863),
      MLO_FLOAT_C (0.996990876),
      MLO_FLOAT_C (0.996915379),
      MLO_FLOAT_C (0.996838348),
      MLO_FLOAT_C (0.996759761),
      MLO_FLOAT_C (0.996679592),
      MLO_FLOAT_C (0.99659782),
      MLO_FLOAT_C (0.99651442),
      MLO_FLOAT_C (0.996429367),
      MLO_FLOAT_C (0.996342638),
      MLO_FLOAT_C (0.996254208),
      MLO_FLOAT_C (0.996164052),
      MLO_FLOAT_C (0.996072145),
      MLO_FLOAT_C (0.995978462),
      MLO_FLOAT_C (0.995882977),
      MLO_FLOAT_C (0.995785666),
      MLO_FLOAT_C (0.995686503),
      MLO_FLOAT_C (0.99558546),
      MLO_FLOAT_C (0.995482513),
      MLO_FLOAT_C (0.995377634),
      MLO_FLOAT_C (0.995270798),
      MLO_FLOAT_C (0.995161977),
      MLO_FLOAT_C (0.995051145),
      MLO_FLOAT_C (0.994938274),
      MLO_FLOAT_C (0.994823337),
      MLO_FLOAT_C (0.994706306),
      MLO_FLOAT_C (0.994587154),
      MLO_FLOAT_C (0.994465853),
      MLO_FLOAT_C (0.994342374),
      MLO_FLOAT_C (0.99421669),
      MLO_FLOAT_C (0.994088771),
      MLO_FLOAT_C (0.993958589),
      MLO_FLOAT_C (0.993826116),
      MLO_FLOAT_C (0.993691321),
      MLO_FLOAT_C (0.993554177),
      MLO_FLOAT_C (0.993414653),
      MLO_FLOAT_C (0.99327272),
      MLO_FLOAT_C (0.993128348),
      MLO_FLOAT_C (0.992981507),
      MLO_FLOAT_C (0.992832167),
      MLO_FLOAT_C (0.992680298),
      MLO_FLOAT_C (0.992525869),
      MLO_FLOAT_C (0.99236885),
      MLO_FLOAT_C (0.992209209),
      MLO_FLOAT_C (0.992046917),
      MLO_FLOAT_C (0.991881941),
      MLO_FLOAT_C (0.991714251),
      MLO_FLOAT_C (0.991543815),
      MLO_FLOAT_C (0.991370601),
      MLO_FLOAT_C (0.991194578),
      MLO_FLOAT_C (0.991015713),
      MLO_FLOAT_C (0.990833976),
      MLO_FLOAT_C (0.990649333),
      MLO_FLOAT_C (0.990461752),
      MLO_FLOAT_C (0.990271201),
      MLO_FLOAT_C (0.990077647),
      MLO_FLOAT_C (0.989881057),
      MLO_FLOAT_C (0.989681398),
      MLO_FLOAT_C (0.989478638),
      MLO_FLOAT_C (0.989272744),
      MLO_FLOAT_C (0.989063681),
      MLO_FLOAT_C (0.988851417),
      MLO_FLOAT_C (0.988635917),
      MLO_FLOAT_C (0.988417149),
      MLO_FLOAT_C (0.988195079),
      MLO_FLOAT_C (0.987969672),
      MLO_FLOAT_C (0.987740895),
      MLO_FLOAT_C (0.987508714),
      MLO_FLOAT_C (0.987273093),
      MLO_FLOAT_C (0.987034),
      MLO_FLOAT_C (0.9867914),
      MLO_FLOAT_C (0.986545257),
      MLO_FLOAT_C (0.986295538),
      MLO_FLOAT_C (0.986042208),
      MLO_FLOAT_C (0.985785232),
      MLO_FLOAT_C (0.985524575),
      MLO_FLOAT_C (0.985260202),
      MLO_FLOAT_C (0.984992079),
      MLO_FLOAT_C (0.984720169),
      MLO_FLOAT_C (0.984444438),
      MLO_FLOAT_C (0.984164851),
      MLO_FLOAT_C (0.983881372),
      MLO_FLOAT_C (0.983593966),
      MLO_FLOAT_C (0.983302598),
      MLO_FLOAT_C (0.983007231),
      MLO_FLOAT_C (0.982707831),
      MLO_FLOAT_C (0.982404362),
      MLO_FLOAT_C (0.982096788),
      MLO_FLOAT_C (0.981785073),
      MLO_FLOAT_C (0.981469182),
      MLO_FLOAT_C (0.98114908),
      MLO_FLOAT_C (0.980824729),
      MLO_FLOAT_C (0.980496095),
      MLO_FLOAT_C (0.980163141),
      MLO_FLOAT_C (0.979825832),
      MLO_FLOAT_C (0.979484132),
      MLO_FLOAT_C (0.979138005),
      MLO_FLOAT_C (0.978787414),
      MLO_FLOAT_C (0.978432325),
      MLO_FLOAT_C (0.978072701),
      MLO_FLOAT_C (0.977708506),
      MLO_FLOAT_C (0.977339704),
      MLO_FLOAT_C (0.97696626),
      MLO_FLOAT_C (0.976588137),
      MLO_FLOAT_C (0.9762053),
      MLO_FLOAT_C (0.975817713),
      MLO_FLOAT_C (0.975425339),
      MLO_FLOAT_C (0.975028144),
      MLO_FLOAT_C (0.974626091),
      MLO_FLOAT_C (0.974219145),
      MLO_FLOAT_C (0.973807269),
      MLO_FLOAT_C (0.973390429),
      MLO_FLOAT_C (0.972968588),
      MLO_FLOAT_C (0.972541711),
      MLO_FLOAT_C (0.972109763),
      MLO_FLOAT_C (0.971672708),
      MLO_FLOAT_C (0.97123051),
      MLO_FLOAT_C (0.970783135),
      MLO_FLOAT_C (0.970330547),
      MLO_FLOAT_C (0.969872711),
      MLO_FLOAT_C (0.969409591),
      MLO_FLOAT_C (0.968941153),
      MLO_FLOAT_C (0.968467363),
      MLO_FLOAT_C (0.967988184),
      MLO_FLOAT_C (0.967503582),
      MLO_FLOAT_C (0.967013523),
      MLO_FLOAT_C (0.966517972),
      MLO_FLOAT_C (0.966016895),
      MLO_FLOAT_C (0.965510257),
      MLO_FLOAT_C (0.964998023),
      MLO_FLOAT_C (0.964480161),
      MLO_FLOAT_C (0.963956636),
      MLO_FLOAT_C (0.963427414),
      MLO_FLOAT_C (0.962892461),
      MLO_FLOAT_C (0.962351744),
      MLO_FLOAT_C (0.961805229),
      MLO_FLOAT_C (0.961252884),
      MLO_FLOAT_C (0.960694674),
      MLO_FLOAT_C (0.960130567),
      MLO_FLOAT_C (0.95956053),
      MLO_FLOAT_C (0.958984531),
      MLO_FLOAT_C (0.958402536),
      MLO_FLOAT_C (0.957814513),
      MLO_FLOAT_C (0.957220431),
      MLO_FLOAT_C (0.956620257),
      MLO_FLOAT_C (0.95601396),
      MLO_FLOAT_C (0.955401507),
      MLO_FLOAT_C (0.954782867),
      MLO_FLOAT_C (0.95415801),
      MLO_FLOAT_C (0.953526903),
      MLO_FLOAT_C (0.952889516),
      MLO_FLOAT_C (0.952245818),
      MLO_FLOAT_C (0.95159578),
      MLO_FLOAT_C (0.95093937),
      MLO_FLOAT_C (0.950276558),
      MLO_FLOAT_C (0.949607315),
      MLO_FLOAT_C (0.948931611),
      MLO_FLOAT_C (0.948249417),
      MLO_FLOAT_C (0.947560703),
      MLO_FLOAT_C (0.946865441),
      MLO_FLOAT_C (0.946163602),
      MLO_FLOAT_C (0.945455158),
      MLO_FLOAT_C (0.944740079),
      MLO_FLOAT_C (0.94401834),
      MLO_FLOAT_C (0.94328991),
      MLO_FLOAT_C (0.942554764),
      MLO_FLOAT_C (0.941812875),
      MLO_FLOAT_C (0.941064214),
      MLO_FLOAT_C (0.940308756),
      MLO_FLOAT_C (0.939546474),
      MLO_FLOAT_C (0.938777342),
      MLO_FLOAT_C (0.938001334),
      MLO_FLOAT_C (0.937218425),
      MLO_FLOAT_C (0.93642859),
      MLO_FLOAT_C (0.935631803),
      MLO_FLOAT_C (0.93482804),
      MLO_FLOAT_C (0.934017277),
      MLO_FLOAT_C (0.933199489),
      MLO_FLOAT_C (0.932374653),
      MLO_FLOAT_C (0.931542745),
      MLO_FLOAT_C (0.930703742),
      MLO_FLOAT_C (0.929857621),
      MLO_FLOAT_C (0.929004361),
      MLO_FLOAT_C (0.928143938),
      MLO_FLOAT_C (0.92727633),
      MLO_FLOAT_C (0.926401517),
      MLO_FLOAT_C (0.925519477),
      MLO_FLOAT_C (0.92463019),
      MLO_FLOAT_C (0.923733633),
      MLO_FLOAT_C (0.922829789),
      MLO_FLOAT_C (0.921918636),
      MLO_FLOAT_C (0.921000155),
      MLO_FLOAT_C (0.920074327),
      MLO_FLOAT_C (0.919141134),
      MLO_FLOAT_C (0.918200556),
      MLO_FLOAT_C (0.917252576),
      MLO_FLOAT_C (0.916297176),
      MLO_FLOAT_C (0.915334338),
      MLO_FLOAT_C (0.914364047),
      MLO_FLOAT_C (0.913386284),
      MLO_FLOAT_C (0.912401034),
      MLO_FLOAT_C (0.911408282),
      MLO_FLOAT_C (0.910408011),
      MLO_FLOAT_C (0.909400206),
      MLO_FLOAT_C (0.908384853),
      MLO_FLOAT_C (0.907361938),
      MLO_FLOAT_C (0.906331446),
      MLO_FLOAT_C (0.905293364),
      MLO_FLOAT_C (0.904247679),
      MLO_FLOAT_C (0.903194378),
      MLO_FLOAT_C (0.902133449),
      MLO_FLOAT_C (0.901064879),
      MLO_FLOAT_C (0.899988659),
      MLO_FLOAT_C (0.898904775),
      MLO_FLOAT_C (0.897813218),
      MLO_FLOAT_C (0.896713977),
      MLO_FLOAT_C (0.895607042),
      MLO_FLOAT_C (0.894492405),
      MLO_FLOAT_C (0.893370055),
      MLO_FLOAT_C (0.892239984),
      MLO_FLOAT_C (0.891102185),
      MLO_FLOAT_C (0.889956649),
      MLO_FLOAT_C (0.888803368),
      MLO_FLOAT_C (0.887642337),
      MLO_FLOAT_C (0.886473549),
      MLO_FLOAT_C (0.885296997),
      MLO_FLOAT_C (0.884112675),
      MLO_FLOAT_C (0.88292058),
      MLO_FLOAT_C (0.881720706),
      MLO_FLOAT_C (0.880513048),
      MLO_FLOAT_C (0.879297603),
      MLO_FLOAT_C (0.878074368),
      MLO_FLOAT_C (0.87684334),
      MLO_FLOAT_C (0.875604515),
      MLO_FLOAT_C (0.874357892),
      MLO_FLOAT_C (0.87310347),
      MLO_FLOAT_C (0.871841247),
      MLO_FLOAT_C (0.870571223),
      MLO_FLOAT_C (0.869293397),
      MLO_FLOAT_C (0.868007769),
      MLO_FLOAT_C (0.866714341),
      MLO_FLOAT_C (0.865413113),
      MLO_FLOAT_C (0.864104087),
      MLO_FLOAT_C (0.862787265),
      MLO_FLOAT_C (0.86146265),
      MLO_FLOAT_C (0.860130244),
      MLO_FLOAT_C (0.858790051),
      MLO_FLOAT_C (0.857442074),
      MLO_FLOAT_C (0.85608632),
      MLO_FLOAT_C (0.854722791),
      MLO_FLOAT_C (0.853351493),
      MLO_FLOAT_C (0.851972433),
      MLO_FLOAT_C (0.850585617),
      MLO_FLOAT_C (0.84919105),
      MLO_FLOAT_C (0.847788741),
      MLO_FLOAT_C (0.846378697),
      MLO_FLOAT_C (0.844960926),
      MLO_FLOAT_C (0.843535437),
      MLO_FLOAT_C (0.842102239),
      MLO_FLOAT_C (0.840661342),
      MLO_FLOAT_C (0.839212755),
      MLO_FLOAT_C (0.837756489),
      MLO_FLOAT_C (0.836292555),
      MLO_FLOAT_C (0.834820965),
      MLO_FLOAT_C (0.83334173),
      MLO_FLOAT_C (0.831854863),
      MLO_FLOAT_C (0.830360377),
      MLO_FLOAT_C (0.828858285),
      MLO_FLOAT_C (0.827348601),
      MLO_FLOAT_C (0.825831339),
      MLO_FLOAT_C (0.824306514),
      MLO_FLOAT_C (0.822774142),
      MLO_FLOAT_C (0.821234238),
      MLO_FLOAT_C (0.819686818),
      MLO_FLOAT_C (0.8181319),
      MLO_FLOAT_C (0.816569499),
      MLO_FLOAT_C (0.814999635),
      MLO_FLOAT_C (0.813422325),
      MLO_FLOAT_C (0.811837587),
      MLO_FLOAT_C (0.810245441),
      MLO_FLOAT_C (0.808645906),
      MLO_FLOAT_C (0.807039003),
      MLO_FLOAT_C (0.805424751),
      MLO_FLOAT_C (0.803803172),
      MLO_FLOAT_C (0.802174287),
      MLO_FLOAT_C (0.800538119),
      MLO_FLOAT_C (0.798894689),
      MLO_FLOAT_C (0.79724402),
      MLO_FLOAT_C (0.795586136),
      MLO_FLOAT_C (0.79392106),
      MLO_FLOAT_C (0.792248817),
      MLO_FLOAT_C (0.790569431),
      MLO_FLOAT_C (0.788882927),
      MLO_FLOAT_C (0.787189332),
      MLO_FLOAT_C (0.785488671),
      MLO_FLOAT_C (0.783780971),
      MLO_FLOAT_C (0.782066259),
      MLO_FLOAT_C (0.780344562),
      MLO_FLOAT_C (0.778615908),
      MLO_FLOAT_C (0.776880325),
      MLO_FLOAT_C (0.775137844),
      MLO_FLOAT_C (0.773388491),
      MLO_FLOAT_C (0.771632299),
      MLO_FLOAT_C (0.769869296),
      MLO_FLOAT_C (0.768099513),
      MLO_FLOAT_C (0.766322982),
      MLO_FLOAT_C (0.764539733),
      MLO_FLOAT_C (0.762749799),
      MLO_FLOAT_C (0.760953213),
      MLO_FLOAT_C (0.759150007),
      MLO_FLOAT_C (0.757340214),
      MLO_FLOAT_C (0.755523868),
      MLO_FLOAT_C (0.753701003),
      MLO_FLOAT_C (0.751871655),
      MLO_FLOAT_C (0.750035857),
      MLO_FLOAT_C (0.748193645),
      MLO_FLOAT_C (0.746345056),
      MLO_FLOAT_C (0.744490125),
      MLO_FLOAT_C (0.74262889),
      MLO_FLOAT_C (0.740761387),
      MLO_FLOAT_C (0.738887653),
      MLO_FLOAT_C (0.737007728),
      MLO_FLOAT_C (0.735121648),
      MLO_FLOAT_C (0.733229454),
      MLO_FLOAT_C (0.731331184),
      MLO_FLOAT_C (0.729426878),
      MLO_FLOAT_C (0.727516575),
      MLO_FLOAT_C (0.725600317),
      MLO_FLOAT_C (0.723678144),
      MLO_FLOAT_C (0.721750097),
      MLO_FLOAT_C (0.719816218),
      MLO_FLOAT_C (0.717876549),
      MLO_FLOAT_C (0.715931132),
      MLO_FLOAT_C (0.71398001),
      MLO_FLOAT_C (0.712023226),
      MLO_FLOAT_C (0.710060823),
      MLO_FLOAT_C (0.708092846),
      MLO_FLOAT_C (0.706119339),
      MLO_FLOAT_C (0.704140346),
      MLO_FLOAT_C (0.702155913),
      MLO_FLOAT_C (0.700166084),
      MLO_FLOAT_C (0.698170906),
      MLO_FLOAT_C (0.696170425),
      MLO_FLOAT_C (0.694164687),
      MLO_FLOAT_C (0.692153738),
      MLO_FLOAT_C (0.690137627),
      MLO_FLOAT_C (0.6881164),
      MLO_FLOAT_C (0.686090105),
      MLO_FLOAT_C (0.684058791),
      MLO_FLOAT_C (0.682022506),
      MLO_FLOAT_C (0.6799813),
      MLO_FLOAT_C (0.67793522),
      MLO_FLOAT_C (0.675884317),
      MLO_FLOAT_C (0.67382864),
      MLO_FLOAT_C (0.67176824),
      MLO_FLOAT_C (0.669703167),
      MLO_FLOAT_C (0.667633472),
      MLO_FLOAT_C (0.665559206),
      MLO_FLOAT_C (0.663480421),
      MLO_FLOAT_C (0.661397168),
      MLO_FLOAT_C (0.659309498),
      MLO_FLOAT_C (0.657217466),
      MLO_FLOAT_C (0.655121122),
      MLO_FLOAT_C (0.653020521),
      MLO_FLOAT_C (0.650915714),
      MLO_FLOAT_C (0.648806757),
      MLO_FLOAT_C (0.646693701),
      MLO_FLOAT_C (0.644576603),
      MLO_FLOAT_C (0.642455514),
      MLO_FLOAT_C (0.640330491),
      MLO_FLOAT_C (0.638201588),
      MLO_FLOAT_C (0.636068861),
      MLO_FLOAT_C (0.633932363),
      MLO_FLOAT_C (0.631792152),
      MLO_FLOAT_C (0.629648283),
      MLO_FLOAT_C (0.627500811),
      MLO_FLOAT_C (0.625349794),
      MLO_FLOAT_C (0.623195288),
      MLO_FLOAT_C (0.62103735),
      MLO_FLOAT_C (0.618876036),
      MLO_FLOAT_C (0.616711404),
      MLO_FLOAT_C (0.614543511),
      MLO_FLOAT_C (0.612372416),
      MLO_FLOAT_C (0.610198175),
      MLO_FLOAT_C (0.608020847),
      MLO_FLOAT_C (0.605840491),
      MLO_FLOAT_C (0.603657165),
      MLO_FLOAT_C (0.601470927),
      MLO_FLOAT_C (0.599281837),
      MLO_FLOAT_C (0.597089954),
      MLO_FLOAT_C (0.594895336),
      MLO_FLOAT_C (0.592698043),
      MLO_FLOAT_C (0.590498136),
      MLO_FLOAT_C (0.588295673),
      MLO_FLOAT_C (0.586090714),
      MLO_FLOAT_C (0.583883321),
      MLO_FLOAT_C (0.581673553),
      MLO_FLOAT_C (0.57946147),
      MLO_FLOAT_C (0.577247133),
      MLO_FLOAT_C (0.575030603),
      MLO_FLOAT_C (0.572811941),
      MLO_FLOAT_C (0.570591208),
      MLO_FLOAT_C (0.568368464),
      MLO_FLOAT_C (0.566143772),
      MLO_FLOAT_C (0.563917192),
      MLO_FLOAT_C (0.561688786),
      MLO_FLOAT_C (0.559458617),
      MLO_FLOAT_C (0.557226744),
      MLO_FLOAT_C (0.554993231),
      MLO_FLOAT_C (0.55275814),
      MLO_FLOAT_C (0.550521531),
      MLO_FLOAT_C (0.548283469),
      MLO_FLOAT_C (0.546044014),
      MLO_FLOAT_C (0.543803229),
      MLO_FLOAT_C (0.541561177),
      MLO_FLOAT_C (0.539317919),
      MLO_FLOAT_C (0.53707352),
      MLO_FLOAT_C (0.53482804),
      MLO_FLOAT_C (0.532581544),
      MLO_FLOAT_C (0.530334093),
      MLO_FLOAT_C (0.528085751),
      MLO_FLOAT_C (0.52583658),
      MLO_FLOAT_C (0.523586643),
      MLO_FLOAT_C (0.521336004),
      MLO_FLOAT_C (0.519084724),
      MLO_FLOAT_C (0.516832868),
      MLO_FLOAT_C (0.514580498),
      MLO_FLOAT_C (0.512327677),
      MLO_FLOAT_C (0.510074469),
      MLO_FLOAT_C (0.507820936),
      MLO_FLOAT_C (0.505567142),
      MLO_FLOAT_C (0.50331315),
      MLO_FLOAT_C (0.501059022),
      MLO_FLOAT_C (0.498804823),
      MLO_FLOAT_C (0.496550614),
      MLO_FLOAT_C (0.49429646),
      MLO_FLOAT_C (0.492042423),
      MLO_FLOAT_C (0.489788566),
      MLO_FLOAT_C (0.487534953),
      MLO_FLOAT_C (0.485281646),
      MLO_FLOAT_C (0.483028709),
      MLO_FLOAT_C (0.480776204),
      MLO_FLOAT_C (0.478524194),
      MLO_FLOAT_C (0.476272742),
      MLO_FLOAT_C (0.474021911),
      MLO_FLOAT_C (0.471771764),
      MLO_FLOAT_C (0.469522363),
      MLO_FLOAT_C (0.467273771),
      MLO_FLOAT_C (0.465026051),
      MLO_FLOAT_C (0.462779264),
      MLO_FLOAT_C (0.460533474),
      MLO_FLOAT_C (0.458288743),
      MLO_FLOAT_C (0.456045133),
      MLO_FLOAT_C (0.453802706),
      MLO_FLOAT_C (0.451561524),
      MLO_FLOAT_C (0.44932165),
      MLO_FLOAT_C (0.447083144),
      MLO_FLOAT_C (0.44484607),
      MLO_FLOAT_C (0.442610488),
      MLO_FLOAT_C (0.440376459),
      MLO_FLOAT_C (0.438144047),
      MLO_FLOAT_C (0.435913311),
      MLO_FLOAT_C (0.433684313),
      MLO_FLOAT_C (0.431457113),
      MLO_FLOAT_C (0.429231774),
      MLO_FLOAT_C (0.427008355),
      MLO_FLOAT_C (0.424786918),
      MLO_FLOAT_C (0.422567522),
      MLO_FLOAT_C (0.420350228),
      MLO_FLOAT_C (0.418135096),
      MLO_FLOAT_C (0.415922187),
      MLO_FLOAT_C (0.413711559),
      MLO_FLOAT_C (0.411503274),
      MLO_FLOAT_C (0.409297389),
      MLO_FLOAT_C (0.407093965),
      MLO_FLOAT_C (0.40489306),
      MLO_FLOAT_C (0.402694735),
      MLO_FLOAT_C (0.400499046),
      MLO_FLOAT_C (0.398306054),
      MLO_FLOAT_C (0.396115816),
      MLO_FLOAT_C (0.39392839),
      MLO_FLOAT_C (0.391743835),
      MLO_FLOAT_C (0.389562209),
      MLO_FLOAT_C (0.387383568),
      MLO_FLOAT_C (0.385207971),
      MLO_FLOAT_C (0.383035474),
      MLO_FLOAT_C (0.380866135),
      MLO_FLOAT_C (0.378700009),
      MLO_FLOAT_C (0.376537155),
      MLO_FLOAT_C (0.374377627),
      MLO_FLOAT_C (0.372221481),
      MLO_FLOAT_C (0.370068775),
      MLO_FLOAT_C (0.367919562),
      MLO_FLOAT_C (0.365773899),
      MLO_FLOAT_C (0.36363184),
      MLO_FLOAT_C (0.36149344),
      MLO_FLOAT_C (0.359358754),
      MLO_FLOAT_C (0.357227836),
      MLO_FLOAT_C (0.35510074),
      MLO_FLOAT_C (0.352977519),
      MLO_FLOAT_C (0.350858228),
      MLO_FLOAT_C (0.348742919),
      MLO_FLOAT_C (0.346631645),
      MLO_FLOAT_C (0.344524459),
      MLO_FLOAT_C (0.342421413),
      MLO_FLOAT_C (0.340322559),
      MLO_FLOAT_C (0.338227949),
      MLO_FLOAT_C (0.336137635),
      MLO_FLOAT_C (0.334051667),
      MLO_FLOAT_C (0.331970097),
      MLO_FLOAT_C (0.329892974),
      MLO_FLOAT_C (0.327820351),
      MLO_FLOAT_C (0.325752275),
      MLO_FLOAT_C (0.323688798),
      MLO_FLOAT_C (0.321629968),
      MLO_FLOAT_C (0.319575834),
      MLO_FLOAT_C (0.317526445),
      MLO_FLOAT_C (0.31548185),
      MLO_FLOAT_C (0.313442096),
      MLO_FLOAT_C (0.311407231),
      MLO_FLOAT_C (0.309377303),
      MLO_FLOAT_C (0.307352358),
      MLO_FLOAT_C (0.305332444),
      MLO_FLOAT_C (0.303317606),
      MLO_FLOAT_C (0.301307892),
      MLO_FLOAT_C (0.299303346),
      MLO_FLOAT_C (0.297304013),
      MLO_FLOAT_C (0.29530994),
      MLO_FLOAT_C (0.29332117),
      MLO_FLOAT_C (0.291337748),
      MLO_FLOAT_C (0.289359717),
      MLO_FLOAT_C (0.287387122),
      MLO_FLOAT_C (0.285420005),
      MLO_FLOAT_C (0.28345841),
      MLO_FLOAT_C (0.281502378),
      MLO_FLOAT_C (0.279551953),
      MLO_FLOAT_C (0.277607175),
      MLO_FLOAT_C (0.275668086),
      MLO_FLOAT_C (0.273734727),
      MLO_FLOAT_C (0.271807139),
      MLO_FLOAT_C (0.269885362),
      MLO_FLOAT_C (0.267969436),
      MLO_FLOAT_C (0.266059399),
      MLO_FLOAT_C (0.264155293),
      MLO_FLOAT_C (0.262257154),
      MLO_FLOAT_C (0.260365022),
      MLO_FLOAT_C (0.258478934),
      MLO_FLOAT_C (0.256598928),
      MLO_FLOAT_C (0.25472504),
      MLO_FLOAT_C (0.252857309),
      MLO_FLOAT_C (0.250995769),
      MLO_FLOAT_C (0.249140458),
      MLO_FLOAT_C (0.24729141),
      MLO_FLOAT_C (0.24544866),
      MLO_FLOAT_C (0.243612244),
      MLO_FLOAT_C (0.241782195),
      MLO_FLOAT_C (0.239958549),
      MLO_FLOAT_C (0.238141337),
      MLO_FLOAT_C (0.236330593),
      MLO_FLOAT_C (0.23452635),
      MLO_FLOAT_C (0.232728641),
      MLO_FLOAT_C (0.230937496),
      MLO_FLOAT_C (0.229152948),
      MLO_FLOAT_C (0.227375027),
      MLO_FLOAT_C (0.225603764),
      MLO_FLOAT_C (0.223839189),
      MLO_FLOAT_C (0.222081333),
      MLO_FLOAT_C (0.220330223),
      MLO_FLOAT_C (0.21858589),
      MLO_FLOAT_C (0.216848361),
      MLO_FLOAT_C (0.215117666),
      MLO_FLOAT_C (0.21339383),
      MLO_FLOAT_C (0.211676882),
      MLO_FLOAT_C (0.209966848),
      MLO_FLOAT_C (0.208263755),
      MLO_FLOAT_C (0.206567629),
      MLO_FLOAT_C (0.204878495),
      MLO_FLOAT_C (0.203196378),
      MLO_FLOAT_C (0.201521302),
      MLO_FLOAT_C (0.199853293),
      MLO_FLOAT_C (0.198192373),
      MLO_FLOAT_C (0.196538566),
      MLO_FLOAT_C (0.194891895),
      MLO_FLOAT_C (0.193252383),
      MLO_FLOAT_C (0.191620051),
      MLO_FLOAT_C (0.18999492),
      MLO_FLOAT_C (0.188377013),
      MLO_FLOAT_C (0.18676635),
      MLO_FLOAT_C (0.185162951),
      MLO_FLOAT_C (0.183566835),
      MLO_FLOAT_C (0.181978023),
      MLO_FLOAT_C (0.180396534),
      MLO_FLOAT_C (0.178822384),
      MLO_FLOAT_C (0.177255594),
      MLO_FLOAT_C (0.17569618),
      MLO_FLOAT_C (0.17414416),
      MLO_FLOAT_C (0.172599551),
      MLO_FLOAT_C (0.171062368),
      MLO_FLOAT_C (0.169532627),
      MLO_FLOAT_C (0.168010345),
      MLO_FLOAT_C (0.166495536),
      MLO_FLOAT_C (0.164988215),
      MLO_FLOAT_C (0.163488395),
      MLO_FLOAT_C (0.161996091),
      MLO_FLOAT_C (0.160511315),
      MLO_FLOAT_C (0.159034082),
      MLO_FLOAT_C (0.157564402),
      MLO_FLOAT_C (0.156102288),
      MLO_FLOAT_C (0.154647751),
      MLO_FLOAT_C (0.153200803),
      MLO_FLOAT_C (0.151761454),
      MLO_FLOAT_C (0.150329714),
      MLO_FLOAT_C (0.148905594),
      MLO_FLOAT_C (0.147489102),
      MLO_FLOAT_C (0.146080247),
      MLO_FLOAT_C (0.144679038),
      MLO_FLOAT_C (0.143285482),
      MLO_FLOAT_C (0.141899589),
      MLO_FLOAT_C (0.140521364),
      MLO_FLOAT_C (0.139150814),
      MLO_FLOAT_C (0.137787946),
      MLO_FLOAT_C (0.136432765),
      MLO_FLOAT_C (0.135085278),
      MLO_FLOAT_C (0.133745488),
      MLO_FLOAT_C (0.132413401),
      MLO_FLOAT_C (0.131089022),
      MLO_FLOAT_C (0.129772352),
      MLO_FLOAT_C (0.128463397),
      MLO_FLOAT_C (0.127162159),
      MLO_FLOAT_C (0.12586864),
      MLO_FLOAT_C (0.124582843),
      MLO_FLOAT_C (0.123304768),
      MLO_FLOAT_C (0.122034419),
      MLO_FLOAT_C (0.120771794),
      MLO_FLOAT_C (0.119516895),
      MLO_FLOAT_C (0.118269722),
      MLO_FLOAT_C (0.117030274),
      MLO_FLOAT_C (0.11579855),
      MLO_FLOAT_C (0.11457455),
      MLO_FLOAT_C (0.113358272),
      MLO_FLOAT_C (0.112149712),
      MLO_FLOAT_C (0.110948871),
      MLO_FLOAT_C (0.109755743),
      MLO_FLOAT_C (0.108570326),
      MLO_FLOAT_C (0.107392617),
      MLO_FLOAT_C (0.106222612),
      MLO_FLOAT_C (0.105060305),
      MLO_FLOAT_C (0.103905692),
      MLO_FLOAT_C (0.102758769),
      MLO_FLOAT_C (0.101619528),
      MLO_FLOAT_C (0.100487965),
      MLO_FLOAT_C (0.0993640728),
      MLO_FLOAT_C (0.0982478447),
      MLO_FLOAT_C (0.0971392736),
      MLO_FLOAT_C (0.0960383519),
      MLO_FLOAT_C (0.0949450717),
      MLO_FLOAT_C (0.0938594248),
      MLO_FLOAT_C (0.0927814023),
      MLO_FLOAT_C (0.0917109954),
      MLO_FLOAT_C (0.0906481945),
      MLO_FLOAT_C (0.0895929898),
      MLO_FLOAT_C (0.0885453713),
      MLO_FLOAT_C (0.0875053284),
      MLO_FLOAT_C (0.0864728501),
      MLO_FLOAT_C (0.0854479253),
      MLO_FLOAT_C (0.0844305424),
      MLO_FLOAT_C (0.0834206892),
      MLO_FLOAT_C (0.0824183536),
      MLO_FLOAT_C (0.0814235229),
      MLO_FLOAT_C (0.080436184),
      MLO_FLOAT_C (0.0794563235),
      MLO_FLOAT_C (0.0784839277),
      MLO_FLOAT_C (0.0775189826),
      MLO_FLOAT_C (0.0765614737),
      MLO_FLOAT_C (0.0756113862),
      MLO_FLOAT_C (0.0746687052),
      MLO_FLOAT_C (0.0737334151),
      MLO_FLOAT_C (0.0728055003),
      MLO_FLOAT_C (0.0718849445),
      MLO_FLOAT_C (0.0709717315),
      MLO_FLOAT_C (0.0700658444),
      MLO_FLOAT_C (0.0691672663),
      MLO_FLOAT_C (0.0682759797),
      MLO_FLOAT_C (0.0673919669),
      MLO_FLOAT_C (0.0665152099),
      MLO_FLOAT_C (0.0656456904),
      MLO_FLOAT_C (0.0647833898),
      MLO_FLOAT_C (0.063928289),
      MLO_FLOAT_C (0.063080369),
      MLO_FLOAT_C (0.06223961),
      MLO_FLOAT_C (0.0614059923),
      MLO_FLOAT_C (0.0605794957),
      MLO_FLOAT_C (0.0597600998),
      MLO_FLOAT_C (0.0589477838),
      MLO_FLOAT_C (0.0581425268),
      MLO_FLOAT_C (0.0573443073),
      MLO_FLOAT_C (0.0565531039),
      MLO_FLOAT_C (0.0557688947),
      MLO_FLOAT_C (0.0549916574),
      MLO_FLOAT_C (0.0542213698),
      MLO_FLOAT_C (0.053458009),
      MLO_FLOAT_C (0.0527015522),
      MLO_FLOAT_C (0.051951976),
      MLO_FLOAT_C (0.0512092571),
      MLO_FLOAT_C (0.0504733717),
      MLO_FLOAT_C (0.0497442956),
      MLO_FLOAT_C (0.0490220048),
      MLO_FLOAT_C (0.0483064746),
      MLO_FLOAT_C (0.0475976803),
      MLO_FLOAT_C (0.0468955969),
      MLO_FLOAT_C (0.0462001991),
      MLO_FLOAT_C (0.0455114615),
      MLO_FLOAT_C (0.0448293582),
      MLO_FLOAT_C (0.0441538633),
      MLO_FLOAT_C (0.0434849507),
      MLO_FLOAT_C (0.0428225939),
      MLO_FLOAT_C (0.0421667661),
      MLO_FLOAT_C (0.0415174407),
      MLO_FLOAT_C (0.0408745904),
      MLO_FLOAT_C (0.040238188),
      MLO_FLOAT_C (0.0396082058),
      MLO_FLOAT_C (0.0389846163),
      MLO_FLOAT_C (0.0383673914),
      MLO_FLOAT_C (0.0377565029),
      MLO_FLOAT_C (0.0371519226),
      MLO_FLOAT_C (0.0365536219),
      MLO_FLOAT_C (0.035961572),
      MLO_FLOAT_C (0.035375744),
      MLO_FLOAT_C (0.0347961088),
      MLO_FLOAT_C (0.034222637),
      MLO_FLOAT_C (0.0336552992),
      MLO_FLOAT_C (0.0330940657),
      MLO_FLOAT_C (0.0325389065),
      MLO_FLOAT_C (0.0319897918),
      MLO_FLOAT_C (0.0314466912),
      MLO_FLOAT_C (0.0309095744),
      MLO_FLOAT_C (0.030378411),
      MLO_FLOAT_C (0.02985317),
      MLO_FLOAT_C (0.0293338209),
      MLO_FLOAT_C (0.0288203324),
      MLO_FLOAT_C (0.0283126734),
      MLO_FLOAT_C (0.0278108127),
      MLO_FLOAT_C (0.0273147188),
      MLO_FLOAT_C (0.0268243599),
      MLO_FLOAT_C (0.0263397045),
      MLO_FLOAT_C (0.0258607206),
      MLO_FLOAT_C (0.0253873762),
      MLO_FLOAT_C (0.0249196392),
      MLO_FLOAT_C (0.0244574771),
      MLO_FLOAT_C (0.0240008578),
      MLO_FLOAT_C (0.0235497485),
      MLO_FLOAT_C (0.0231041167),
      MLO_FLOAT_C (0.0226639296),
      MLO_FLOAT_C (0.0222291542),
      MLO_FLOAT_C (0.0217997577),
      MLO_FLOAT_C (0.0213757068),
      MLO_FLOAT_C (0.0209569685),
      MLO_FLOAT_C (0.0205435093),
      MLO_FLOAT_C (0.0201352958),
      MLO_FLOAT_C (0.0197322946),
      MLO_FLOAT_C (0.019334472),
      MLO_FLOAT_C (0.0189417944),
      MLO_FLOAT_C (0.0185542279),
      MLO_FLOAT_C (0.0181717386),
      MLO_FLOAT_C (0.0177942926),
      MLO_FLOAT_C (0.0174218559),
      MLO_FLOAT_C (0.0170543944),
      MLO_FLOAT_C (0.0166918738),
      MLO_FLOAT_C (0.0163342599),
      MLO_FLOAT_C (0.0159815183),
      MLO_FLOAT_C (0.0156336146),
      MLO_FLOAT_C (0.0152905144),
      MLO_FLOAT_C (0.0149521831),
      MLO_FLOAT_C (0.0146185862),
      MLO_FLOAT_C (0.0142896888),
      MLO_FLOAT_C (0.0139654565),
      MLO_FLOAT_C (0.0136458542),
      MLO_FLOAT_C (0.0133308473),
      MLO_FLOAT_C (0.0130204009),
      MLO_FLOAT_C (0.01271448),
      MLO_FLOAT_C (0.0124130496),
      MLO_FLOAT_C (0.0121160748),
      MLO_FLOAT_C (0.0118235204),
      MLO_FLOAT_C (0.0115353514),
      MLO_FLOAT_C (0.0112515326),
      MLO_FLOAT_C (0.0109720287),
      MLO_FLOAT_C (0.0106968047),
      MLO_FLOAT_C (0.0104258251),
      MLO_FLOAT_C (0.0101590547),
      MLO_FLOAT_C (0.00989645812),
      MLO_FLOAT_C (0.00963799995),
      MLO_FLOAT_C (0.00938364478),
      MLO_FLOAT_C (0.00913335712),
      MLO_FLOAT_C (0.00888710146),
      MLO_FLOAT_C (0.00864484224),
      MLO_FLOAT_C (0.00840654386),
      MLO_FLOAT_C (0.00817217067),
      MLO_FLOAT_C (0.00794168698),
      MLO_FLOAT_C (0.00771505704),
      MLO_FLOAT_C (0.00749224503),
      MLO_FLOAT_C (0.0072732151),
      MLO_FLOAT_C (0.0070579313),
      MLO_FLOAT_C (0.00684635764),
      MLO_FLOAT_C (0.00663845803),
      MLO_FLOAT_C (0.00643419629),
      MLO_FLOAT_C (0.00623353614),
      MLO_FLOAT_C (0.00603644121),
      MLO_FLOAT_C (0.00584287498),
      MLO_FLOAT_C (0.0056528008),
      MLO_FLOAT_C (0.00546618188),
      MLO_FLOAT_C (0.00528298122),
      MLO_FLOAT_C (0.00510316165),
      MLO_FLOAT_C (0.00492668576),
      MLO_FLOAT_C (0.00475351587),
      MLO_FLOAT_C (0.00458361403),
      MLO_FLOAT_C (0.00441694192),
      MLO_FLOAT_C (0.00425346088),
      MLO_FLOAT_C (0.00409313177),
      MLO_FLOAT_C (0.00393591495),
      MLO_FLOAT_C (0.00378177019),
      MLO_FLOAT_C (0.00363065661),
      MLO_FLOAT_C (0.0034825325),
      MLO_FLOAT_C (0.00333735527),
      MLO_FLOAT_C (0.00319508125),
      MLO_FLOAT_C (0.0030556655),
      MLO_FLOAT_C (0.00291906163),
      MLO_FLOAT_C (0.00278522149),
      MLO_FLOAT_C (0.00265409486),
      MLO_FLOAT_C (0.00252562903),
      MLO_FLOAT_C (0.00239976832),
      MLO_FLOAT_C (0.00227645343),
      MLO_FLOAT_C (0.00215562063),
      MLO_FLOAT_C (0.00203720076),
      MLO_FLOAT_C (0.00192111791),
      MLO_FLOAT_C (0.00180728766),
      MLO_FLOAT_C (0.0016956148),
      MLO_FLOAT_C (0.00158599017),
      MLO_FLOAT_C (0.00147828639),
      MLO_FLOAT_C (0.0013723517),
      MLO_FLOAT_C (0.0012680012),
      MLO_FLOAT_C (0.00116500361),
      MLO_FLOAT_C (0.00106306093),
      MLO_FLOAT_C (0.000961775402),
      MLO_FLOAT_C (0.000860593306),
      MLO_FLOAT_C (0.000758701942),
      MLO_FLOAT_C (0.000654823037),
      MLO_FLOAT_C (0.000546740743),
      MLO_FLOAT_C (0.000429985671),
      MLO_FLOAT_C (0.000292561535)
   }
};



static const MLO_Float MloFilterBank_table_short [MLO_ICS_INFO_WINDOW_SHAPE_NBR_ELT] [MLO_DEFS_FRAME_LEN_SHORT * 2] =
{
   {
      MLO_FLOAT_C (0.00613588465),
      MLO_FLOAT_C (0.0184067299),
      MLO_FLOAT_C (0.0306748032),
      MLO_FLOAT_C (0.0429382569),
      MLO_FLOAT_C (0.0551952443),
      MLO_FLOAT_C (0.0674439196),
      MLO_FLOAT_C (0.079682438),
      MLO_FLOAT_C (0.0919089565),
      MLO_FLOAT_C (0.104121634),
      MLO_FLOAT_C (0.116318631),
      MLO_FLOAT_C (0.128498111),
      MLO_FLOAT_C (0.140658239),
      MLO_FLOAT_C (0.152797185),
      MLO_FLOAT_C (0.16491312),
      MLO_FLOAT_C (0.17700422),
      MLO_FLOAT_C (0.189068664),
      MLO_FLOAT_C (0.201104635),
      MLO_FLOAT_C (0.21311032),
      MLO_FLOAT_C (0.225083911),
      MLO_FLOAT_C (0.237023606),
      MLO_FLOAT_C (0.248927606),
      MLO_FLOAT_C (0.260794118),
      MLO_FLOAT_C (0.272621355),
      MLO_FLOAT_C (0.284407537),
      MLO_FLOAT_C (0.296150888),
      MLO_FLOAT_C (0.30784964),
      MLO_FLOAT_C (0.319502031),
      MLO_FLOAT_C (0.331106306),
      MLO_FLOAT_C (0.342660717),
      MLO_FLOAT_C (0.354163525),
      MLO_FLOAT_C (0.365612998),
      MLO_FLOAT_C (0.37700741),
      MLO_FLOAT_C (0.388345047),
      MLO_FLOAT_C (0.3996242),
      MLO_FLOAT_C (0.410843171),
      MLO_FLOAT_C (0.422000271),
      MLO_FLOAT_C (0.433093819),
      MLO_FLOAT_C (0.444122145),
      MLO_FLOAT_C (0.455083587),
      MLO_FLOAT_C (0.465976496),
      MLO_FLOAT_C (0.47679923),
      MLO_FLOAT_C (0.48755016),
      MLO_FLOAT_C (0.498227667),
      MLO_FLOAT_C (0.508830143),
      MLO_FLOAT_C (0.51935599),
      MLO_FLOAT_C (0.529803625),
      MLO_FLOAT_C (0.540171473),
      MLO_FLOAT_C (0.550457973),
      MLO_FLOAT_C (0.560661576),
      MLO_FLOAT_C (0.570780746),
      MLO_FLOAT_C (0.580813958),
      MLO_FLOAT_C (0.590759702),
      MLO_FLOAT_C (0.600616479),
      MLO_FLOAT_C (0.610382806),
      MLO_FLOAT_C (0.620057212),
      MLO_FLOAT_C (0.629638239),
      MLO_FLOAT_C (0.639124445),
      MLO_FLOAT_C (0.648514401),
      MLO_FLOAT_C (0.657806693),
      MLO_FLOAT_C (0.666999922),
      MLO_FLOAT_C (0.676092704),
      MLO_FLOAT_C (0.685083668),
      MLO_FLOAT_C (0.693971461),
      MLO_FLOAT_C (0.702754744),
      MLO_FLOAT_C (0.711432196),
      MLO_FLOAT_C (0.720002508),
      MLO_FLOAT_C (0.72846439),
      MLO_FLOAT_C (0.736816569),
      MLO_FLOAT_C (0.745057785),
      MLO_FLOAT_C (0.753186799),
      MLO_FLOAT_C (0.761202385),
      MLO_FLOAT_C (0.769103338),
      MLO_FLOAT_C (0.776888466),
      MLO_FLOAT_C (0.784556597),
      MLO_FLOAT_C (0.792106577),
      MLO_FLOAT_C (0.799537269),
      MLO_FLOAT_C (0.806847554),
      MLO_FLOAT_C (0.81403633),
      MLO_FLOAT_C (0.821102515),
      MLO_FLOAT_C (0.828045045),
      MLO_FLOAT_C (0.834862875),
      MLO_FLOAT_C (0.841554977),
      MLO_FLOAT_C (0.848120345),
      MLO_FLOAT_C (0.854557988),
      MLO_FLOAT_C (0.860866939),
      MLO_FLOAT_C (0.867046246),
      MLO_FLOAT_C (0.873094978),
      MLO_FLOAT_C (0.879012226),
      MLO_FLOAT_C (0.884797098),
      MLO_FLOAT_C (0.890448723),
      MLO_FLOAT_C (0.89596625),
      MLO_FLOAT_C (0.901348847),
      MLO_FLOAT_C (0.906595705),
      MLO_FLOAT_C (0.911706032),
      MLO_FLOAT_C (0.91667906),
      MLO_FLOAT_C (0.921514039),
      MLO_FLOAT_C (0.926210242),
      MLO_FLOAT_C (0.930766961),
      MLO_FLOAT_C (0.93518351),
      MLO_FLOAT_C (0.939459224),
      MLO_FLOAT_C (0.943593458),
      MLO_FLOAT_C (0.947585591),
      MLO_FLOAT_C (0.951435021),
      MLO_FLOAT_C (0.955141168),
      MLO_FLOAT_C (0.958703475),
      MLO_FLOAT_C (0.962121404),
      MLO_FLOAT_C (0.965394442),
      MLO_FLOAT_C (0.968522094),
      MLO_FLOAT_C (0.971503891),
      MLO_FLOAT_C (0.974339383),
      MLO_FLOAT_C (0.977028143),
      MLO_FLOAT_C (0.979569766),
      MLO_FLOAT_C (0.981963869),
      MLO_FLOAT_C (0.984210092),
      MLO_FLOAT_C (0.986308097),
      MLO_FLOAT_C (0.988257568),
      MLO_FLOAT_C (0.99005821),
      MLO_FLOAT_C (0.991709754),
      MLO_FLOAT_C (0.993211949),
      MLO_FLOAT_C (0.994564571),
      MLO_FLOAT_C (0.995767414),
      MLO_FLOAT_C (0.996820299),
      MLO_FLOAT_C (0.997723067),
      MLO_FLOAT_C (0.998475581),
      MLO_FLOAT_C (0.999077728),
      MLO_FLOAT_C (0.999529418),
      MLO_FLOAT_C (0.999830582),
      MLO_FLOAT_C (0.999981175),
      MLO_FLOAT_C (0.999981175),
      MLO_FLOAT_C (0.999830582),
      MLO_FLOAT_C (0.999529418),
      MLO_FLOAT_C (0.999077728),
      MLO_FLOAT_C (0.998475581),
      MLO_FLOAT_C (0.997723067),
      MLO_FLOAT_C (0.996820299),
      MLO_FLOAT_C (0.995767414),
      MLO_FLOAT_C (0.994564571),
      MLO_FLOAT_C (0.993211949),
      MLO_FLOAT_C (0.991709754),
      MLO_FLOAT_C (0.99005821),
      MLO_FLOAT_C (0.988257568),
      MLO_FLOAT_C (0.986308097),
      MLO_FLOAT_C (0.984210092),
      MLO_FLOAT_C (0.981963869),
      MLO_FLOAT_C (0.979569766),
      MLO_FLOAT_C (0.977028143),
      MLO_FLOAT_C (0.974339383),
      MLO_FLOAT_C (0.971503891),
      MLO_FLOAT_C (0.968522094),
      MLO_FLOAT_C (0.965394442),
      MLO_FLOAT_C (0.962121404),
      MLO_FLOAT_C (0.958703475),
      MLO_FLOAT_C (0.955141168),
      MLO_FLOAT_C (0.951435021),
      MLO_FLOAT_C (0.947585591),
      MLO_FLOAT_C (0.943593458),
      MLO_FLOAT_C (0.939459224),
      MLO_FLOAT_C (0.93518351),
      MLO_FLOAT_C (0.930766961),
      MLO_FLOAT_C (0.926210242),
      MLO_FLOAT_C (0.921514039),
      MLO_FLOAT_C (0.91667906),
      MLO_FLOAT_C (0.911706032),
      MLO_FLOAT_C (0.906595705),
      MLO_FLOAT_C (0.901348847),
      MLO_FLOAT_C (0.89596625),
      MLO_FLOAT_C (0.890448723),
      MLO_FLOAT_C (0.884797098),
      MLO_FLOAT_C (0.879012226),
      MLO_FLOAT_C (0.873094978),
      MLO_FLOAT_C (0.867046246),
      MLO_FLOAT_C (0.860866939),
      MLO_FLOAT_C (0.854557988),
      MLO_FLOAT_C (0.848120345),
      MLO_FLOAT_C (0.841554977),
      MLO_FLOAT_C (0.834862875),
      MLO_FLOAT_C (0.828045045),
      MLO_FLOAT_C (0.821102515),
      MLO_FLOAT_C (0.81403633),
      MLO_FLOAT_C (0.806847554),
      MLO_FLOAT_C (0.799537269),
      MLO_FLOAT_C (0.792106577),
      MLO_FLOAT_C (0.784556597),
      MLO_FLOAT_C (0.776888466),
      MLO_FLOAT_C (0.769103338),
      MLO_FLOAT_C (0.761202385),
      MLO_FLOAT_C (0.753186799),
      MLO_FLOAT_C (0.745057785),
      MLO_FLOAT_C (0.736816569),
      MLO_FLOAT_C (0.72846439),
      MLO_FLOAT_C (0.720002508),
      MLO_FLOAT_C (0.711432196),
      MLO_FLOAT_C (0.702754744),
      MLO_FLOAT_C (0.693971461),
      MLO_FLOAT_C (0.685083668),
      MLO_FLOAT_C (0.676092704),
      MLO_FLOAT_C (0.666999922),
      MLO_FLOAT_C (0.657806693),
      MLO_FLOAT_C (0.648514401),
      MLO_FLOAT_C (0.639124445),
      MLO_FLOAT_C (0.629638239),
      MLO_FLOAT_C (0.620057212),
      MLO_FLOAT_C (0.610382806),
      MLO_FLOAT_C (0.600616479),
      MLO_FLOAT_C (0.590759702),
      MLO_FLOAT_C (0.580813958),
      MLO_FLOAT_C (0.570780746),
      MLO_FLOAT_C (0.560661576),
      MLO_FLOAT_C (0.550457973),
      MLO_FLOAT_C (0.540171473),
      MLO_FLOAT_C (0.529803625),
      MLO_FLOAT_C (0.51935599),
      MLO_FLOAT_C (0.508830143),
      MLO_FLOAT_C (0.498227667),
      MLO_FLOAT_C (0.48755016),
      MLO_FLOAT_C (0.47679923),
      MLO_FLOAT_C (0.465976496),
      MLO_FLOAT_C (0.455083587),
      MLO_FLOAT_C (0.444122145),
      MLO_FLOAT_C (0.433093819),
      MLO_FLOAT_C (0.422000271),
      MLO_FLOAT_C (0.410843171),
      MLO_FLOAT_C (0.3996242),
      MLO_FLOAT_C (0.388345047),
      MLO_FLOAT_C (0.37700741),
      MLO_FLOAT_C (0.365612998),
      MLO_FLOAT_C (0.354163525),
      MLO_FLOAT_C (0.342660717),
      MLO_FLOAT_C (0.331106306),
      MLO_FLOAT_C (0.319502031),
      MLO_FLOAT_C (0.30784964),
      MLO_FLOAT_C (0.296150888),
      MLO_FLOAT_C (0.284407537),
      MLO_FLOAT_C (0.272621355),
      MLO_FLOAT_C (0.260794118),
      MLO_FLOAT_C (0.248927606),
      MLO_FLOAT_C (0.237023606),
      MLO_FLOAT_C (0.225083911),
      MLO_FLOAT_C (0.21311032),
      MLO_FLOAT_C (0.201104635),
      MLO_FLOAT_C (0.189068664),
      MLO_FLOAT_C (0.17700422),
      MLO_FLOAT_C (0.16491312),
      MLO_FLOAT_C (0.152797185),
      MLO_FLOAT_C (0.140658239),
      MLO_FLOAT_C (0.128498111),
      MLO_FLOAT_C (0.116318631),
      MLO_FLOAT_C (0.104121634),
      MLO_FLOAT_C (0.0919089565),
      MLO_FLOAT_C (0.079682438),
      MLO_FLOAT_C (0.0674439196),
      MLO_FLOAT_C (0.0551952443),
      MLO_FLOAT_C (0.0429382569),
      MLO_FLOAT_C (0.0306748032),
      MLO_FLOAT_C (0.0184067299),
      MLO_FLOAT_C (0.00613588465)
   },
   {
      MLO_FLOAT_C (4.37957041e-005),
      MLO_FLOAT_C (0.000118673846),
      MLO_FLOAT_C (0.000230716583),
      MLO_FLOAT_C (0.000389472837),
      MLO_FLOAT_C (0.00060581274),
      MLO_FLOAT_C (0.000891996975),
      MLO_FLOAT_C (0.00126172547),
      MLO_FLOAT_C (0.00173017247),
      MLO_FLOAT_C (0.00231400723),
      MLO_FLOAT_C (0.00303139901),
      MLO_FLOAT_C (0.00390200504),
      MLO_FLOAT_C (0.00494694029),
      MLO_FLOAT_C (0.00618872809),
      MLO_FLOAT_C (0.00765123086),
      MLO_FLOAT_C (0.00935956026),
      MLO_FLOAT_C (0.0113399666),
      MLO_FLOAT_C (0.0136197074),
      MLO_FLOAT_C (0.0162268952),
      MLO_FLOAT_C (0.0191903255),
      MLO_FLOAT_C (0.0225392849),
      MLO_FLOAT_C (0.0263033416),
      MLO_FLOAT_C (0.0305121183),
      MLO_FLOAT_C (0.0351950506),
      MLO_FLOAT_C (0.0403811316),
      MLO_FLOAT_C (0.0460986453),
      MLO_FLOAT_C (0.0523748917),
      MLO_FLOAT_C (0.0592359057),
      MLO_FLOAT_C (0.0667061728),
      MLO_FLOAT_C (0.0748083441),
      MLO_FLOAT_C (0.0835629551),
      MLO_FLOAT_C (0.0929881498),
      MLO_FLOAT_C (0.103099415),
      MLO_FLOAT_C (0.113909325),
      MLO_FLOAT_C (0.125427308),
      MLO_FLOAT_C (0.137659422),
      MLO_FLOAT_C (0.150608163),
      MLO_FLOAT_C (0.164272292),
      MLO_FLOAT_C (0.178646689),
      MLO_FLOAT_C (0.193722244),
      MLO_FLOAT_C (0.209485773),
      MLO_FLOAT_C (0.225919972),
      MLO_FLOAT_C (0.243003405),
      MLO_FLOAT_C (0.260710533),
      MLO_FLOAT_C (0.279011774),
      MLO_FLOAT_C (0.297873607),
      MLO_FLOAT_C (0.31725871),
      MLO_FLOAT_C (0.337126141),
      MLO_FLOAT_C (0.357431546),
      MLO_FLOAT_C (0.378127412),
      MLO_FLOAT_C (0.399163349),
      MLO_FLOAT_C (0.420486402),
      MLO_FLOAT_C (0.442041391),
      MLO_FLOAT_C (0.463771281),
      MLO_FLOAT_C (0.48561757),
      MLO_FLOAT_C (0.507520695),
      MLO_FLOAT_C (0.529420455),
      MLO_FLOAT_C (0.551256441),
      MLO_FLOAT_C (0.572968478),
      MLO_FLOAT_C (0.594497058),
      MLO_FLOAT_C (0.615783783),
      MLO_FLOAT_C (0.636771788),
      MLO_FLOAT_C (0.657406158),
      MLO_FLOAT_C (0.677634329),
      MLO_FLOAT_C (0.697406466),
      MLO_FLOAT_C (0.716675813),
      MLO_FLOAT_C (0.735399018),
      MLO_FLOAT_C (0.753536425),
      MLO_FLOAT_C (0.771052327),
      MLO_FLOAT_C (0.787915181),
      MLO_FLOAT_C (0.804097785),
      MLO_FLOAT_C (0.819577405),
      MLO_FLOAT_C (0.834335865),
      MLO_FLOAT_C (0.848359583),
      MLO_FLOAT_C (0.861639567),
      MLO_FLOAT_C (0.874171365),
      MLO_FLOAT_C (0.885954964),
      MLO_FLOAT_C (0.896994654),
      MLO_FLOAT_C (0.90729884),
      MLO_FLOAT_C (0.916879829),
      MLO_FLOAT_C (0.925753564),
      MLO_FLOAT_C (0.93393934),
      MLO_FLOAT_C (0.941459487),
      MLO_FLOAT_C (0.948339027),
      MLO_FLOAT_C (0.954605319),
      MLO_FLOAT_C (0.960287681),
      MLO_FLOAT_C (0.965417018),
      MLO_FLOAT_C (0.970025435),
      MLO_FLOAT_C (0.974145865),
      MLO_FLOAT_C (0.977811695),
      MLO_FLOAT_C (0.981056416),
      MLO_FLOAT_C (0.983913289),
      MLO_FLOAT_C (0.986415031),
      MLO_FLOAT_C (0.988593537),
      MLO_FLOAT_C (0.990479623),
      MLO_FLOAT_C (0.992102812),
      MLO_FLOAT_C (0.99349115),
      MLO_FLOAT_C (0.994671057),
      MLO_FLOAT_C (0.995667215),
      MLO_FLOAT_C (0.9965025),
      MLO_FLOAT_C (0.99719793),
      MLO_FLOAT_C (0.997772663),
      MLO_FLOAT_C (0.998244012),
      MLO_FLOAT_C (0.998627493),
      MLO_FLOAT_C (0.998936892),
      MLO_FLOAT_C (0.999184349),
      MLO_FLOAT_C (0.999380462),
      MLO_FLOAT_C (0.999534397),
      MLO_FLOAT_C (0.999654007),
      MLO_FLOAT_C (0.999745958),
      MLO_FLOAT_C (0.999815849),
      MLO_FLOAT_C (0.999868335),
      MLO_FLOAT_C (0.999907247),
      MLO_FLOAT_C (0.999935701),
      MLO_FLOAT_C (0.999956198),
      MLO_FLOAT_C (0.999970729),
      MLO_FLOAT_C (0.99998085),
      MLO_FLOAT_C (0.999987764),
      MLO_FLOAT_C (0.999992387),
      MLO_FLOAT_C (0.999995405),
      MLO_FLOAT_C (0.999997323),
      MLO_FLOAT_C (0.999998503),
      MLO_FLOAT_C (0.999999204),
      MLO_FLOAT_C (0.999999602),
      MLO_FLOAT_C (0.999999816),
      MLO_FLOAT_C (0.999999924),
      MLO_FLOAT_C (0.999999973),
      MLO_FLOAT_C (0.999999993),
      MLO_FLOAT_C (0.999999999),
      MLO_FLOAT_C (0.999999999),
      MLO_FLOAT_C (0.999999993),
      MLO_FLOAT_C (0.999999973),
      MLO_FLOAT_C (0.999999924),
      MLO_FLOAT_C (0.999999816),
      MLO_FLOAT_C (0.999999602),
      MLO_FLOAT_C (0.999999204),
      MLO_FLOAT_C (0.999998503),
      MLO_FLOAT_C (0.999997323),
      MLO_FLOAT_C (0.999995405),
      MLO_FLOAT_C (0.999992387),
      MLO_FLOAT_C (0.999987764),
      MLO_FLOAT_C (0.99998085),
      MLO_FLOAT_C (0.999970729),
      MLO_FLOAT_C (0.999956198),
      MLO_FLOAT_C (0.999935701),
      MLO_FLOAT_C (0.999907247),
      MLO_FLOAT_C (0.999868335),
      MLO_FLOAT_C (0.999815849),
      MLO_FLOAT_C (0.999745958),
      MLO_FLOAT_C (0.999654007),
      MLO_FLOAT_C (0.999534397),
      MLO_FLOAT_C (0.999380462),
      MLO_FLOAT_C (0.999184349),
      MLO_FLOAT_C (0.998936892),
      MLO_FLOAT_C (0.998627493),
      MLO_FLOAT_C (0.998244012),
      MLO_FLOAT_C (0.997772663),
      MLO_FLOAT_C (0.99719793),
      MLO_FLOAT_C (0.9965025),
      MLO_FLOAT_C (0.995667215),
      MLO_FLOAT_C (0.994671057),
      MLO_FLOAT_C (0.99349115),
      MLO_FLOAT_C (0.992102812),
      MLO_FLOAT_C (0.990479623),
      MLO_FLOAT_C (0.988593537),
      MLO_FLOAT_C (0.986415031),
      MLO_FLOAT_C (0.983913289),
      MLO_FLOAT_C (0.981056416),
      MLO_FLOAT_C (0.977811695),
      MLO_FLOAT_C (0.974145865),
      MLO_FLOAT_C (0.970025435),
      MLO_FLOAT_C (0.965417018),
      MLO_FLOAT_C (0.960287681),
      MLO_FLOAT_C (0.954605319),
      MLO_FLOAT_C (0.948339027),
      MLO_FLOAT_C (0.941459487),
      MLO_FLOAT_C (0.93393934),
      MLO_FLOAT_C (0.925753564),
      MLO_FLOAT_C (0.916879829),
      MLO_FLOAT_C (0.90729884),
      MLO_FLOAT_C (0.896994654),
      MLO_FLOAT_C (0.885954964),
      MLO_FLOAT_C (0.874171365),
      MLO_FLOAT_C (0.861639567),
      MLO_FLOAT_C (0.848359583),
      MLO_FLOAT_C (0.834335865),
      MLO_FLOAT_C (0.819577405),
      MLO_FLOAT_C (0.804097785),
      MLO_FLOAT_C (0.787915181),
      MLO_FLOAT_C (0.771052327),
      MLO_FLOAT_C (0.753536425),
      MLO_FLOAT_C (0.735399018),
      MLO_FLOAT_C (0.716675813),
      MLO_FLOAT_C (0.697406466),
      MLO_FLOAT_C (0.677634329),
      MLO_FLOAT_C (0.657406158),
      MLO_FLOAT_C (0.636771788),
      MLO_FLOAT_C (0.615783783),
      MLO_FLOAT_C (0.594497058),
      MLO_FLOAT_C (0.572968478),
      MLO_FLOAT_C (0.551256441),
      MLO_FLOAT_C (0.529420455),
      MLO_FLOAT_C (0.507520695),
      MLO_FLOAT_C (0.48561757),
      MLO_FLOAT_C (0.463771281),
      MLO_FLOAT_C (0.442041391),
      MLO_FLOAT_C (0.420486402),
      MLO_FLOAT_C (0.399163349),
      MLO_FLOAT_C (0.378127412),
      MLO_FLOAT_C (0.357431546),
      MLO_FLOAT_C (0.337126141),
      MLO_FLOAT_C (0.31725871),
      MLO_FLOAT_C (0.297873607),
      MLO_FLOAT_C (0.279011774),
      MLO_FLOAT_C (0.260710533),
      MLO_FLOAT_C (0.243003405),
      MLO_FLOAT_C (0.225919972),
      MLO_FLOAT_C (0.209485773),
      MLO_FLOAT_C (0.193722244),
      MLO_FLOAT_C (0.178646689),
      MLO_FLOAT_C (0.164272292),
      MLO_FLOAT_C (0.150608163),
      MLO_FLOAT_C (0.137659422),
      MLO_FLOAT_C (0.125427308),
      MLO_FLOAT_C (0.113909325),
      MLO_FLOAT_C (0.103099415),
      MLO_FLOAT_C (0.0929881498),
      MLO_FLOAT_C (0.0835629551),
      MLO_FLOAT_C (0.0748083441),
      MLO_FLOAT_C (0.0667061728),
      MLO_FLOAT_C (0.0592359057),
      MLO_FLOAT_C (0.0523748917),
      MLO_FLOAT_C (0.0460986453),
      MLO_FLOAT_C (0.0403811316),
      MLO_FLOAT_C (0.0351950506),
      MLO_FLOAT_C (0.0305121183),
      MLO_FLOAT_C (0.0263033416),
      MLO_FLOAT_C (0.0225392849),
      MLO_FLOAT_C (0.0191903255),
      MLO_FLOAT_C (0.0162268952),
      MLO_FLOAT_C (0.0136197074),
      MLO_FLOAT_C (0.0113399666),
      MLO_FLOAT_C (0.00935956026),
      MLO_FLOAT_C (0.00765123086),
      MLO_FLOAT_C (0.00618872809),
      MLO_FLOAT_C (0.00494694029),
      MLO_FLOAT_C (0.00390200504),
      MLO_FLOAT_C (0.00303139901),
      MLO_FLOAT_C (0.00231400723),
      MLO_FLOAT_C (0.00173017247),
      MLO_FLOAT_C (0.00126172547),
      MLO_FLOAT_C (0.000891996975),
      MLO_FLOAT_C (0.00060581274),
      MLO_FLOAT_C (0.000389472837),
      MLO_FLOAT_C (0.000230716583),
      MLO_FLOAT_C (0.000118673846),
      MLO_FLOAT_C (4.37957041e-005)
   }
};



/*----------------------------------------------------------------------
|       Functions
+---------------------------------------------------------------------*/



/**********************************************************************************************************/
/*** Debug ***/
#if 0
#include <stdio.h>

static int  MLO_FilterBank_frame_t_index = 0;

void  MLO_FilterBank_dump_frame_t (int sub_nbr, const MLO_Float *data_ptr, long len)
{
   if (MLO_FilterBank_frame_t_index < 500)
   {
      long           pos;
      FILE *         f_ptr;
      const char *   fname_0 = "D:\\Ohm Force\\dev\\test\\frames_t_test.txt";

      if (MLO_FilterBank_frame_t_index == 0)
      {
         remove (fname_0);
      }
      f_ptr = fopen (fname_0, "a");

      fprintf (f_ptr, "Frame # %06d, sub # %02d\n", MLO_FilterBank_frame_t_index, sub_nbr);
      for (pos = 0; pos < len; ++pos)
      {
         fprintf (f_ptr, "%6d\n", (int) (floor (data_ptr [pos] + 0.5)));
      }
      fprintf (f_ptr, "\n");

      fclose (f_ptr);

      ++ MLO_FilterBank_frame_t_index;
   }
}
#endif
/**********************************************************************************************************/



/*
==============================================================================
Name: MLO_FilterBank_Init
Description:
   Initialise the filterbank, fill tables. Call this function at least first
   before using the filterbank object.
Output parameters:
	- fb_ptr: The filterbank object to initialise
Returns:
   Currently MLO_SUCCESS.
==============================================================================
*/

MLO_Result	MLO_FilterBank_Init (MLO_FilterBank *fb_ptr)
{
   MLO_Result  result = MLO_SUCCESS;

   MLO_ASSERT(fb_ptr != NULL);

   if (MLO_SUCCEEDED (result))
   {
	   result = MLO_Imdct_Init (&fb_ptr->imdct);
   }

	return (result);
}



/*
==============================================================================
Name: MLO_FilterBank_Restore
Description:
   Release all occupied resources. Call this function when the object is no
   longer used, but only if call to MLO_FilterBank_Init() was
   successful.
Output parameters:
	- fb_ptr: The filterbank object to destroy
==============================================================================
*/

void	
MLO_FilterBank_Restore (MLO_FilterBank *fb_ptr)
{
   MLO_ASSERT(fb_ptr != NULL);

   MLO_Imdct_Restore (&fb_ptr->imdct);
}




/*
==============================================================================
Name: MLO_FilterBank_ConvertSpectralToTime
Description:
   Converts the spectral data from a channel to the time domain.
   Also does the overlapping with the previous frame.
   Ref: 4.6.11.3
Input/output parameters:
	- fb_ptr: the filter bank object which is used to do the processing. It is
      shared by all the channels.
   - ics_ptr: channel to convert. coef_arr[] is changed, prev_frame[] updated.
==============================================================================
*/

void	MLO_FilterBank_ConvertSpectralToTime (MLO_FilterBank *fb_ptr, MLO_IndivChnStream *ics_ptr)
{
   int            win;
   int            win_pos = 0;
   int            win_len = MLO_DEFS_FRAME_LEN_LONG;
   int            num_windows;

   MLO_ASSERT(fb_ptr != NULL);
   MLO_ASSERT(ics_ptr != NULL);

   if (ics_ptr->ics_info.window_sequence == MLO_ICS_INFO_WIN_EIGHT_SHORT_SEQUENCE)
   {
      win_len = MLO_DEFS_FRAME_LEN_SHORT;
   }

   num_windows = ics_ptr->ics_info.num_windows;
   for (win = 0; win < num_windows; ++win)
   {
      MLO_Imdct_Process (
         &fb_ptr->imdct,
         &fb_ptr->tmp_buf [win_pos * 2],
         &ics_ptr->coef_arr [win_pos],
         win_len * 2
      );
/**********************************************************************************************************/
/*** Debug ***/
#if 0
      MLO_FilterBank_dump_frame_t (win, &fb_ptr->tmp_buf [win_pos * 2], win_len * 2);
#endif
/**********************************************************************************************************/
      win_pos += win_len;
   }

   /* Applies windowing */
   MLO_FilterBank_ApplyWindow (fb_ptr, ics_ptr);

   /* Mixes current and previous frames to the output buffer */
   MLO_FilterBank_MixFrames (fb_ptr, ics_ptr);
}



/*
==============================================================================
Name: MLO_FilterBank_ApplyWindow
Description:
   Applies the window on the output of the IMDCT (time domain). This output
   is in the tmp_buf field. Windowed data is produced into the tmp_win field.
   Ref: 4.6.11.3.2
Input parameters:
	- ics_ptr: processed individual_channel_stream.
Input/output parameters:
	- fb_ptr: object containing the temporary input and output.
==============================================================================
*/

static void 
MLO_FilterBank_ApplyWindow (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr)
{
   MLO_ASSERT(fb_ptr != NULL);
   MLO_ASSERT(ics_ptr != NULL);

   switch (ics_ptr->ics_info.window_sequence)
   {
   case  MLO_ICS_INFO_WIN_ONLY_LONG_SEQUENCE:
      MLO_FilterBank_ApplyWindowLong (fb_ptr, ics_ptr, 0);
      MLO_FilterBank_ApplyWindowLong (fb_ptr, ics_ptr, 1);
      break;

   case  MLO_ICS_INFO_WIN_LONG_START_SEQUENCE:
      MLO_FilterBank_ApplyWindowLong (fb_ptr, ics_ptr, 0);
      MLO_FilterBank_ApplyWindowStart (fb_ptr, ics_ptr);
      break;

   case  MLO_ICS_INFO_WIN_EIGHT_SHORT_SEQUENCE:
      MLO_FilterBank_ApplyWindowShort (fb_ptr, ics_ptr);
      break;

   case  MLO_ICS_INFO_WIN_LONG_STOP_SEQUENCE:
      MLO_FilterBank_ApplyWindowStop (fb_ptr, ics_ptr);
      MLO_FilterBank_ApplyWindowLong (fb_ptr, ics_ptr, 1);
      break;

   default:
      MLO_ASSERT (MLO_FALSE);
   }
}



/*
==============================================================================
Name: MLO_FilterBank_ApplyWindowLong
Description:
   Applies a long window on a half of the IMDCT output.
Input parameters:
	- ics_ptr: processed individual_channel_stream.
	- part: The part to process: 0 = left, cur. frame ; 1 = right, next frame
Input/output parameters:
	- fb_ptr: object containing the temporary input and output.
==============================================================================
*/

static void 
MLO_FilterBank_ApplyWindowLong (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr, int part)
{
   const int      part_pos = part * MLO_DEFS_FRAME_LEN_LONG;
   MLO_IcsInfo_WindowShape shape;
   MLO_Float *    dest_ptr;
   const MLO_Float * win_ptr;
   const MLO_Float * src_ptr;
   int            pos;

   MLO_ASSERT(fb_ptr != NULL);
   MLO_ASSERT(ics_ptr != NULL);
   MLO_ASSERT(part >= 0);
   MLO_ASSERT(part < 2);

   shape = ics_ptr->ics_info.window_shape [part];
   win_ptr = &MloFilterBank_table_long [shape] [part_pos];
   src_ptr = &fb_ptr->tmp_buf [part_pos];
   dest_ptr = &fb_ptr->tmp_win [part_pos];
   for (pos = 0; pos < MLO_DEFS_FRAME_LEN_LONG; ++pos)
   {
      dest_ptr [pos] = MLO_Float_Mul (src_ptr [pos], win_ptr [pos]);
   }
}



/*
==============================================================================
Name: MLO_FilterBank_ApplyWindowShort
Description:
   Applies a set of short windows on the IMDCT output.
Input parameters:
	- ics_ptr: processed individual_channel_stream.
Input/output parameters:
	- fb_ptr: object containing the temporary input and output.
==============================================================================
*/

static void 
MLO_FilterBank_ApplyWindowShort (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr)
{
   MLO_IcsInfo_WindowShape shape;
   const MLO_Float * win_ptr;
   const MLO_Float * src_ptr;
   MLO_Float *    dest_ptr;
   int            win;
   int            pos;

   MLO_ASSERT(fb_ptr != NULL);
   MLO_ASSERT(ics_ptr != NULL);

   shape = ics_ptr->ics_info.window_shape [MLO_IcsInfo_WSIndex_PREV];
   win_ptr = &MloFilterBank_table_short [shape] [0];
   dest_ptr = &fb_ptr->tmp_win [0];
   src_ptr = &fb_ptr->tmp_buf [0];

   /* Clears before the first frame + first part of the first frame */
   MLO_SetMemory (
      &dest_ptr [0],
      0,
      (MLO_FILTER_BANK_BORDER + MLO_DEFS_FRAME_LEN_SHORT) * sizeof (dest_ptr [0])
   );

   /* Copy and overlap frames */
   for (win = 0; win < ics_ptr->ics_info.num_windows; ++win)
   {
      const int      data_pos =
         MLO_FILTER_BANK_BORDER + win * MLO_DEFS_FRAME_LEN_SHORT;
      dest_ptr = &fb_ptr->tmp_win [data_pos];

      for (pos = 0; pos < MLO_DEFS_FRAME_LEN_SHORT; ++pos)
      {
         dest_ptr [pos] = MLO_Float_Add (
            dest_ptr [pos],
            MLO_Float_Mul (src_ptr [pos], win_ptr [pos])
         );
      }

      shape = ics_ptr->ics_info.window_shape [MLO_IcsInfo_WSIndex_CUR];
      win_ptr = &MloFilterBank_table_short [shape] [0];

      for (pos = MLO_DEFS_FRAME_LEN_SHORT
      ;  pos < MLO_DEFS_FRAME_LEN_SHORT * 2
      ;  ++pos)
      {
         dest_ptr [pos] = MLO_Float_Mul (src_ptr [pos], win_ptr [pos]);
      }

      src_ptr += MLO_DEFS_FRAME_LEN_SHORT * 2;
   }

   /* Clears after the last frame */
   dest_ptr = &fb_ptr->tmp_win [MLO_DEFS_FRAME_LEN_LONG * 2 - MLO_FILTER_BANK_BORDER];
   MLO_SetMemory (
      dest_ptr,
      0,
      MLO_FILTER_BANK_BORDER * sizeof (dest_ptr [0])
   );
}



/*
==============================================================================
Name: MLO_FilterBank_ApplyWindowStart
Description:
   Applies the right side of the LONG_START_SEQUENCE window.
Input parameters:
	- ics_ptr: processed individual_channel_stream.
Input/output parameters:
	- fb_ptr: object containing the temporary input and output.
==============================================================================
*/

static void 
MLO_FilterBank_ApplyWindowStart (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr)
{
   MLO_IcsInfo_WindowShape shape;
   const MLO_Float * win_ptr;
   const MLO_Float * src_ptr;
   MLO_Float *    dest_ptr;
   int            pos;

   MLO_ASSERT(fb_ptr != NULL);
   MLO_ASSERT(ics_ptr != NULL);

   dest_ptr = &fb_ptr->tmp_win [MLO_DEFS_FRAME_LEN_LONG];
   src_ptr = &fb_ptr->tmp_buf [MLO_DEFS_FRAME_LEN_LONG];
   MLO_CopyMemory (
      dest_ptr,
      src_ptr,
      MLO_FILTER_BANK_BORDER * sizeof (dest_ptr [0])
   );

   shape = ics_ptr->ics_info.window_shape [MLO_IcsInfo_WSIndex_CUR];
   win_ptr = &MloFilterBank_table_short [shape] [MLO_DEFS_FRAME_LEN_SHORT];

   dest_ptr =
      &fb_ptr->tmp_win [MLO_DEFS_FRAME_LEN_LONG + MLO_FILTER_BANK_BORDER];
   src_ptr += MLO_FILTER_BANK_BORDER;
   for (pos = 0; pos < MLO_DEFS_FRAME_LEN_SHORT; ++pos)
   {
      dest_ptr [pos] = MLO_Float_Mul (src_ptr [pos], win_ptr [pos]);
   }

   dest_ptr =
      &fb_ptr->tmp_win [MLO_DEFS_FRAME_LEN_LONG * 2 - MLO_FILTER_BANK_BORDER];
   MLO_SetMemory (
      dest_ptr,
      0,
      MLO_FILTER_BANK_BORDER * sizeof (dest_ptr [0])
   );
}



/*
==============================================================================
Name: MLO_FilterBank_ApplyWindowStart
Description:
   Applies the left side of the LONG_END_SEQUENCE window.
Input parameters:
	- ics_ptr: processed individual_channel_stream.
Input/output parameters:
	- fb_ptr: object containing the temporary input and output.
==============================================================================
*/

static void 
MLO_FilterBank_ApplyWindowStop (MLO_FilterBank *fb_ptr, const MLO_IndivChnStream *ics_ptr)
{
   MLO_IcsInfo_WindowShape shape;
   const MLO_Float * win_ptr;
   const MLO_Float * src_ptr;
   MLO_Float *    dest_ptr;
   int            pos;

   MLO_ASSERT(fb_ptr != NULL);
   MLO_ASSERT(ics_ptr != NULL);

   dest_ptr = &fb_ptr->tmp_win [0];
   MLO_SetMemory (
      dest_ptr,
      0,
      MLO_FILTER_BANK_BORDER * sizeof (dest_ptr [0])
   );

   shape = ics_ptr->ics_info.window_shape [MLO_IcsInfo_WSIndex_PREV];
   win_ptr = &MloFilterBank_table_short [shape] [0];

   dest_ptr = &fb_ptr->tmp_win [MLO_FILTER_BANK_BORDER];
   src_ptr = &fb_ptr->tmp_buf [MLO_FILTER_BANK_BORDER];
   for (pos = 0; pos < MLO_DEFS_FRAME_LEN_SHORT; ++pos)
   {
      dest_ptr [pos] = MLO_Float_Mul (src_ptr [pos], win_ptr [pos]);
   }

   dest_ptr =
      &fb_ptr->tmp_win [MLO_DEFS_FRAME_LEN_LONG - MLO_FILTER_BANK_BORDER];
   src_ptr += MLO_DEFS_FRAME_LEN_SHORT;
   MLO_CopyMemory (
      dest_ptr,
      src_ptr,
      MLO_FILTER_BANK_BORDER * sizeof (dest_ptr [0])
   );
}



/*
==============================================================================
Name: MLO_FilterBank_MixFrames
Description:
   Mixes the current windowed frame to the previous frame and saves the
   right part into the individual_channel_stream for the next frame.
Input parameters:
	- fb_ptr: object containing the windowed data in tmp_buf.
Input/output parameters:
	- ics_ptr: processed individual_channel_stream.
==============================================================================
*/

static void 
MLO_FilterBank_MixFrames (const MLO_FilterBank *fb_ptr, MLO_IndivChnStream *ics_ptr)
{
   int            pos;

   MLO_ASSERT(fb_ptr != NULL);
   MLO_ASSERT(ics_ptr != NULL);

   /* Overlaps current and previous frame */
   for (pos = 0; pos < MLO_DEFS_FRAME_LEN_LONG; ++pos)
   {
      ics_ptr->coef_arr [pos] = MLO_Float_Add (
         fb_ptr->tmp_win [pos],
         ics_ptr->prev_frame [pos]
      );
   }

   /* Saves 2nd part of the frame */
/*
   MLO_CopyMemory (
      &ics_ptr->prev_frame [0],
      &fb_ptr->tmp_win [MLO_DEFS_FRAME_LEN_LONG],
      MLO_DEFS_FRAME_LEN_LONG * sizeof (ics_ptr->prev_frame [0])
   );
*/
   for (pos = 0; pos < MLO_DEFS_FRAME_LEN_LONG; ++pos)
   {
      ics_ptr->prev_frame [pos] = fb_ptr->tmp_win [pos + MLO_DEFS_FRAME_LEN_LONG];
   }
}
