##########################################################################
#
#    top level make rules and variables
#
#    (c) 2001-2005 Gilles Boccon-Gibod
#    Author: Gilles Boccon-Gibod (bok@bok.net)
#
##########################################################################

##########################################################################
# exported variables
##########################################################################
BUILD_ROOT  = $(ROOT)/Build
SOURCE_ROOT = $(ROOT)/Source/C++

export BUILD_ROOT
export SOURCE_ROOT
export TARGET

export FILE_BYTE_STREAM_IMPLEMENTATION

export CC
export AUTODEP_CPP
export AUTODEP_STDOUT
export ARCHIVE
export COMPILE_CPP
export LINK_CPP
export MAKELIB
export MAKESHAREDLIB
export RANLIB
export STRIP
export DEBUG_CPP
export OPTIMIZE_CPP
export PROFILE_CPP
export DEFINES_CPP
export WARNINGS_CPP
export INCLUDES_CPP
export LIBRARIES_CPP

##########################################################################
# modular targets
##########################################################################

# ------- Setup -------------
.PHONY: Setup
Setup:
	mkdir $(OUTPUT_DIR)
    
# ------- Apps -----------
ALL_APPS = mp4dump mp4info mp42aac aac2mp4 mp4decrypt mp4encrypt mp4edit mp4extract mp4rtphintinfo mp4tag
export ALL_APPS

##################################################################
# cleanup
##################################################################
TO_CLEAN += *.d *.o *.a *.exe $(ALL_APPS) SDK

##################################################################
# end targets
##################################################################
.PHONY: lib
lib:
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Lib.mak

.PHONY: apps
apps: $(ALL_APPS)

 .PHONY: sdk
sdk: lib apps
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/SDK.mak
   
mp4dump: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4Dump.mak

mp4info: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4Info.mak

mp42aac: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp42Aac.mak

aac2mp4: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Aac2Mp4.mak

mp4decrypt: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4Decrypt.mak

mp4encrypt: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4Encrypt.mak

mp4edit: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4Edit.mak

mp4extract: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4Extract.mak

mp4rtphintinfo: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4RtpHintInfo.mak

mp4tag: lib
	$(TITLE)
	@$(INVOKE_SUBMAKE) -f $(BUILD_ROOT)/Makefiles/Mp4Tag.mak

##################################################################
# includes
##################################################################
include $(BUILD_ROOT)/Makefiles/Rules.mak






