/*****************************************************************
|
|   Fluo - Data Tables
|
|   (c) 2002-2006 Gilles Boccon-Gibod
|   Author: Gilles Boccon-Gibod (bok@bok.net)
|
 ****************************************************************/

/*----------------------------------------------------------------------
|   includes
+---------------------------------------------------------------------*/
#include "FloConfig.h"
#include "FloTypes.h"
#include "FloSyntax.h"
#include "FloTables.h"

/*----------------------------------------------------------------------
|   tables
+---------------------------------------------------------------------*/
const unsigned short FLO_MpegBitrates[3][3][16] = {
    /* MPEG2 */
    {
        /* layer I */
        {  
              0,  32,  48,  56,  64,  80,  96, 112, 
            128, 144, 160, 176, 192, 224, 256,   0
        },

        /* layer II */
        {  
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        },

        /* layer III */
        {  
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        }
    },

    /* MPEG1 */
    {
        /* layer I */
        {
              0,  32,  64,  96, 128, 160, 192, 224, 
            256, 288, 320, 352, 384, 416, 448,   0
        },
        
        /* layer II */
        {
              0,  32,  48,  56,  64,  80,  96, 112, 
            128, 160, 192, 224, 256, 320, 384,   0
        },
        
        /* layer III */
        {
              0,  32,  40,  48,  56,  64,  80,  96, 
            112, 128, 160, 192, 224, 256, 320,   0
        },
    },

    /* MPEG2.5 */
    {
        /* layer I */
        {
              0,  32,  48,  56,  64,  80,  96, 112, 
            128, 144, 160, 176, 192, 224, 256,   0
        },

        /* layer II */
        {
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        },

        /* layer III */
        {
              0,   8,  16,  24,  32,  40,  48,  56, 
             64,  80,  96, 112, 128, 144, 160,   0
        }
    }
};

const unsigned FLO_MpegSamplingFrequencies[3][4] = {
    {22050, 24000, 16000, 0}, /* MPEG2   */
    {44100, 48000, 32000, 0}, /* MPEG1   */
    {11025, 12000,  8000, 0}  /* MPEG2.5 */
};
 
#if (FLO_DECODER_ENGINE == FLO_DECODER_ENGINE_BUILTIN)
/*-------------------------------------------------------------------------
|       D values from table 3-B.3
|       (in a different order)
+-------------------------------------------------------------------------*/
const FLO_Float FLO_SynthesisFilter_D[32*17] = {
    FLO_FC0(0.0),     FLO_FC0(-14.5),   FLO_FC0(106.5),   FLO_FC0(-229.5), 
    FLO_FC0(1018.5),  FLO_FC0(-2576.5), FLO_FC0(3287.0),  FLO_FC0(-18744.5), 
    FLO_FC0(37519.0), FLO_FC0(18744.5), FLO_FC0(3287.0),  FLO_FC0(2576.5), 
    FLO_FC0(1018.5),  FLO_FC0(229.5),   FLO_FC0(106.5),   FLO_FC0(14.5), 
    FLO_FC0(0.0),     FLO_FC0(-14.5),   FLO_FC0(106.5),   FLO_FC0(-229.5), 
    FLO_FC0(1018.5),  FLO_FC0(-2576.5), FLO_FC0(3287.0),  FLO_FC0(-18744.5), 
    FLO_FC0(37519.0), FLO_FC0(18744.5), FLO_FC0(3287.0),  FLO_FC0(2576.5), 
    FLO_FC0(1018.5),  FLO_FC0(229.5),   FLO_FC0(106.5),   FLO_FC0(14.5), 
    FLO_FC0(-0.5),    FLO_FC0(-15.5),   FLO_FC0(109.0),   FLO_FC0(-259.5), 
    FLO_FC0(1000.0),  FLO_FC0(-2758.5), FLO_FC0(2979.5),  FLO_FC0(-19668.0), 
    FLO_FC0(37496.0), FLO_FC0(17820.0), FLO_FC0(3567.0),  FLO_FC0(2394.0), 
    FLO_FC0(1031.5),  FLO_FC0(200.5),   FLO_FC0(104.0),   FLO_FC0(13.0), 
    FLO_FC0(-0.5),    FLO_FC0(-15.5),   FLO_FC0(109.0),   FLO_FC0(-259.5), 
    FLO_FC0(1000.0),  FLO_FC0(-2758.5), FLO_FC0(2979.5),  FLO_FC0(-19668.0), 
    FLO_FC0(37496.0), FLO_FC0(17820.0), FLO_FC0(3567.0),  FLO_FC0(2394.0), 
    FLO_FC0(1031.5),  FLO_FC0(200.5),   FLO_FC0(104.0),   FLO_FC0(13.0), 
    FLO_FC0(-0.5),    FLO_FC0(-17.5),   FLO_FC0(111.0),   FLO_FC0(-290.5), 
    FLO_FC0(976.0),   FLO_FC0(-2939.5), FLO_FC0(2644.0),  FLO_FC0(-20588.0), 
    FLO_FC0(37428.0), FLO_FC0(16895.5), FLO_FC0(3820.0),  FLO_FC0(2212.5), 
    FLO_FC0(1040.0),  FLO_FC0(173.5),   FLO_FC0(101.0),   FLO_FC0(12.0), 
    FLO_FC0(-0.5),    FLO_FC0(-17.5),   FLO_FC0(111.0),   FLO_FC0(-290.5), 
    FLO_FC0(976.0),   FLO_FC0(-2939.5), FLO_FC0(2644.0),  FLO_FC0(-20588.0), 
    FLO_FC0(37428.0), FLO_FC0(16895.5), FLO_FC0(3820.0),  FLO_FC0(2212.5), 
    FLO_FC0(1040.0),  FLO_FC0(173.5),   FLO_FC0(101.0),   FLO_FC0(12.0), 
    FLO_FC0(-0.5),    FLO_FC0(-19.0),   FLO_FC0(112.5),   FLO_FC0(-322.5), 
    FLO_FC0(946.5),   FLO_FC0(-3118.5), FLO_FC0(2280.5),  FLO_FC0(-21503.0), 
    FLO_FC0(37315.0), FLO_FC0(15973.5), FLO_FC0(4046.0),  FLO_FC0(2031.5), 
    FLO_FC0(1043.5),  FLO_FC0(147.0),   FLO_FC0(98.0),    FLO_FC0(10.5), 
    FLO_FC0(-0.5),    FLO_FC0(-19.0),   FLO_FC0(112.5),   FLO_FC0(-322.5), 
    FLO_FC0(946.5),   FLO_FC0(-3118.5), FLO_FC0(2280.5),  FLO_FC0(-21503.0), 
    FLO_FC0(37315.0), FLO_FC0(15973.5), FLO_FC0(4046.0),  FLO_FC0(2031.5), 
    FLO_FC0(1043.5),  FLO_FC0(147.0),   FLO_FC0(98.0),    FLO_FC0(10.5), 
    FLO_FC0(-0.5),    FLO_FC0(-20.5),   FLO_FC0(113.5),   FLO_FC0(-355.5), 
    FLO_FC0(911.0),   FLO_FC0(-3294.5), FLO_FC0(1888.0),  FLO_FC0(-22410.5), 
    FLO_FC0(37156.5), FLO_FC0(15056.0), FLO_FC0(4246.0),  FLO_FC0(1852.5), 
    FLO_FC0(1042.5),  FLO_FC0(122.0),   FLO_FC0(95.0),    FLO_FC0(9.5), 
    FLO_FC0(-0.5),    FLO_FC0(-20.5),   FLO_FC0(113.5),   FLO_FC0(-355.5), 
    FLO_FC0(911.0),   FLO_FC0(-3294.5), FLO_FC0(1888.0),  FLO_FC0(-22410.5), 
    FLO_FC0(37156.5), FLO_FC0(15056.0), FLO_FC0(4246.0),  FLO_FC0(1852.5), 
    FLO_FC0(1042.5),  FLO_FC0(122.0),   FLO_FC0(95.0),    FLO_FC0(9.5), 
    FLO_FC0(-0.5),    FLO_FC0(-22.5),   FLO_FC0(114.0),   FLO_FC0(-389.5), 
    FLO_FC0(869.5),   FLO_FC0(-3467.5), FLO_FC0(1467.5),  FLO_FC0(-23308.5), 
    FLO_FC0(36954.0), FLO_FC0(14144.5), FLO_FC0(4420.0),  FLO_FC0(1675.5),
    FLO_FC0(1037.5),  FLO_FC0(98.5),    FLO_FC0(91.5),    FLO_FC0(8.5), 
    FLO_FC0(-0.5),    FLO_FC0(-22.5),   FLO_FC0(114.0),   FLO_FC0(-389.5), 
    FLO_FC0(869.5),   FLO_FC0(-3467.5), FLO_FC0(1467.5),  FLO_FC0(-23308.5), 
    FLO_FC0(36954.0), FLO_FC0(14144.5), FLO_FC0(4420.0),  FLO_FC0(1675.5), 
    FLO_FC0(1037.5),  FLO_FC0(98.5),    FLO_FC0(91.5),    FLO_FC0(8.5), 
    FLO_FC0(-0.5),    FLO_FC0(-24.5),   FLO_FC0(114.0),   FLO_FC0(-424.0), 
    FLO_FC0(822.0),   FLO_FC0(-3635.5), FLO_FC0(1018.5),  FLO_FC0(-24195.0), 
    FLO_FC0(36707.5), FLO_FC0(13241.0), FLO_FC0(4569.5),  FLO_FC0(1502.0), 
    FLO_FC0(1028.5),  FLO_FC0(76.5),    FLO_FC0(88.0),    FLO_FC0(8.0), 
    FLO_FC0(-0.5),    FLO_FC0(-24.5),   FLO_FC0(114.0),   FLO_FC0(-424.0), 
    FLO_FC0(822.0),   FLO_FC0(-3635.5), FLO_FC0(1018.5),  FLO_FC0(-24195.0),
    FLO_FC0(36707.5), FLO_FC0(13241.0), FLO_FC0(4569.5),  FLO_FC0(1502.0),
    FLO_FC0(1028.5),  FLO_FC0(76.5),    FLO_FC0(88.0),    FLO_FC0(8.0), 
    FLO_FC0(-1.0),    FLO_FC0(-26.5),   FLO_FC0(113.5),   FLO_FC0(-459.5),
    FLO_FC0(767.5),   FLO_FC0(-3798.5), FLO_FC0(541.0),   FLO_FC0(-25068.5),
    FLO_FC0(36417.5), FLO_FC0(12347.0), FLO_FC0(4694.5),  FLO_FC0(1331.5),
    FLO_FC0(1016.0),  FLO_FC0(55.5),    FLO_FC0(84.5),    FLO_FC0(7.0), 
    FLO_FC0(-1.0),    FLO_FC0(-26.5),   FLO_FC0(113.5),   FLO_FC0(-459.5), 
    FLO_FC0(767.5),   FLO_FC0(-3798.5), FLO_FC0(541.0),   FLO_FC0(-25068.5), 
    FLO_FC0(36417.5), FLO_FC0(12347.0), FLO_FC0(4694.5),  FLO_FC0(1331.5), 
    FLO_FC0(1016.0),  FLO_FC0(55.5),    FLO_FC0(84.5),    FLO_FC0(7.0), 
    FLO_FC0(-1.0),    FLO_FC0(-29.0),   FLO_FC0(112.0),   FLO_FC0(-495.5), 
    FLO_FC0(707.0),   FLO_FC0(-3955.0), FLO_FC0(35.0),    FLO_FC0(-25926.5), 
    FLO_FC0(36084.5), FLO_FC0(11464.5), FLO_FC0(4796.0),  FLO_FC0(1165.0), 
    FLO_FC0(1000.5),  FLO_FC0(36.0),    FLO_FC0(80.5),    FLO_FC0(6.5), 
    FLO_FC0(-1.0),    FLO_FC0(-29.0),   FLO_FC0(112.0),   FLO_FC0(-495.5), 
    FLO_FC0(707.0),   FLO_FC0(-3955.0), FLO_FC0(35.0),    FLO_FC0(-25926.5), 
    FLO_FC0(36084.5), FLO_FC0(11464.5), FLO_FC0(4796.0),  FLO_FC0(1165.0), 
    FLO_FC0(1000.5),  FLO_FC0(36.0),    FLO_FC0(80.5),    FLO_FC0(6.5), 
    FLO_FC0(-1.0),    FLO_FC0(-31.5),   FLO_FC0(110.5),   FLO_FC0(-532.0), 
    FLO_FC0(640.0),   FLO_FC0(-4104.5), FLO_FC0(-499.0),  FLO_FC0(-26767.0), 
    FLO_FC0(35710.0), FLO_FC0(10594.5), FLO_FC0(4875.0),  FLO_FC0(1003.0), 
    FLO_FC0(981.0),   FLO_FC0(18.0),    FLO_FC0(77.0),    FLO_FC0(5.5), 
    FLO_FC0(-1.0),    FLO_FC0(-31.5),   FLO_FC0(110.5),   FLO_FC0(-532.0),
    FLO_FC0(640.0),   FLO_FC0(-4104.5), FLO_FC0(-499.0),  FLO_FC0(-26767.0), 
    FLO_FC0(35710.0), FLO_FC0(10594.5), FLO_FC0(4875.0),  FLO_FC0(1003.0), 
    FLO_FC0(981.0),   FLO_FC0(18.0),    FLO_FC0(77.0),    FLO_FC0(5.5), 
    FLO_FC0(-1.0),    FLO_FC0(-34.0),   FLO_FC0(107.5),   FLO_FC0(-568.5), 
    FLO_FC0(565.5),   FLO_FC0(-4245.5), FLO_FC0(-1061.0), FLO_FC0(-27589.0), 
    FLO_FC0(35295.0), FLO_FC0(9739.0),  FLO_FC0(4931.5),  FLO_FC0(846.0), 
    FLO_FC0(959.5),   FLO_FC0(1.0),     FLO_FC0(73.5),    FLO_FC0(5.0), 
    FLO_FC0(-1.0),    FLO_FC0(-34.0),   FLO_FC0(107.5),   FLO_FC0(-568.5), 
    FLO_FC0(565.5),   FLO_FC0(-4245.5), FLO_FC0(-1061.0), FLO_FC0(-27589.0), 
    FLO_FC0(35295.0), FLO_FC0(9739.0),  FLO_FC0(4931.5),  FLO_FC0(846.0), 
    FLO_FC0(959.5),   FLO_FC0(1.0),     FLO_FC0(73.5),    FLO_FC0(5.0), 
    FLO_FC0(-1.5),    FLO_FC0(-36.5),   FLO_FC0(104.0),   FLO_FC0(-605.0), 
    FLO_FC0(485.0),   FLO_FC0(-4377.5), FLO_FC0(-1650.0), FLO_FC0(-28389.0), 
    FLO_FC0(34839.5), FLO_FC0(8899.5),  FLO_FC0(4967.5),  FLO_FC0(694.0), 
    FLO_FC0(935.0),   FLO_FC0(-14.5),   FLO_FC0(69.5),    FLO_FC0(4.5), 
    FLO_FC0(-1.5),    FLO_FC0(-36.5),   FLO_FC0(104.0),   FLO_FC0(-605.0), 
    FLO_FC0(485.0),   FLO_FC0(-4377.5), FLO_FC0(-1650.0), FLO_FC0(-28389.0), 
    FLO_FC0(34839.5), FLO_FC0(8899.5),  FLO_FC0(4967.5),  FLO_FC0(694.0), 
    FLO_FC0(935.0),   FLO_FC0(-14.5),   FLO_FC0(69.5),    FLO_FC0(4.5), 
    FLO_FC0(-1.5),    FLO_FC0(-39.5),   FLO_FC0(100.0),   FLO_FC0(-641.5), 
    FLO_FC0(397.0),   FLO_FC0(-4499.0), FLO_FC0(-2266.5), FLO_FC0(-29166.5), 
    FLO_FC0(34346.0), FLO_FC0(8077.5),  FLO_FC0(4983.0),  FLO_FC0(547.5), 
    FLO_FC0(908.5),   FLO_FC0(-28.5),   FLO_FC0(66.0),    FLO_FC0(4.0), 
    FLO_FC0(-1.5),    FLO_FC0(-39.5),   FLO_FC0(100.0),   FLO_FC0(-641.5), 
    FLO_FC0(397.0),   FLO_FC0(-4499.0), FLO_FC0(-2266.5), FLO_FC0(-29166.5), 
    FLO_FC0(34346.0), FLO_FC0(8077.5),  FLO_FC0(4983.0),  FLO_FC0(547.5), 
    FLO_FC0(908.5),   FLO_FC0(-28.5),   FLO_FC0(66.0),    FLO_FC0(4.0), 
    FLO_FC0(-2.0),    FLO_FC0(-42.5),   FLO_FC0(94.5),    FLO_FC0(-678.0), 
    FLO_FC0(302.5),   FLO_FC0(-4609.5), FLO_FC0(-2909.0), FLO_FC0(-29919.0), 
    FLO_FC0(33814.5), FLO_FC0(7274.0),  FLO_FC0(4979.5),  FLO_FC0(407.0), 
    FLO_FC0(879.5),   FLO_FC0(-41.5),   FLO_FC0(62.5),    FLO_FC0(3.5), 
    FLO_FC0(-2.0),    FLO_FC0(-42.5),   FLO_FC0(94.5),    FLO_FC0(-678.0), 
    FLO_FC0(302.5),   FLO_FC0(-4609.5), FLO_FC0(-2909.0), FLO_FC0(-29919.0), 
    FLO_FC0(33814.5), FLO_FC0(7274.0),  FLO_FC0(4979.5),  FLO_FC0(407.0), 
    FLO_FC0(879.5),   FLO_FC0(-41.5),   FLO_FC0(62.5),    FLO_FC0(3.5), 
    FLO_FC0(-2.0),    FLO_FC0(-45.5),   FLO_FC0(88.5),    FLO_FC0(-714.0), 
    FLO_FC0(201.0),   FLO_FC0(-4708.0), FLO_FC0(-3577.0), FLO_FC0(-30644.5), 
    FLO_FC0(33247.0), FLO_FC0(6490.0),  FLO_FC0(4958.0),  FLO_FC0(272.5), 
    FLO_FC0(849.0),   FLO_FC0(-53.0),   FLO_FC0(58.5),    FLO_FC0(3.5), 
    FLO_FC0(-2.0),    FLO_FC0(-45.5),   FLO_FC0(88.5),    FLO_FC0(-714.0), 
    FLO_FC0(201.0),   FLO_FC0(-4708.0), FLO_FC0(-3577.0), FLO_FC0(-30644.5), 
    FLO_FC0(33247.0), FLO_FC0(6490.0),  FLO_FC0(4958.0),  FLO_FC0(272.5), 
    FLO_FC0(849.0),   FLO_FC0(-53.0),   FLO_FC0(58.5),    FLO_FC0(3.5), 
    FLO_FC0(-2.5),    FLO_FC0(-48.5),   FLO_FC0(81.5),    FLO_FC0(-749.0), 
    FLO_FC0(92.5),    FLO_FC0(-4792.5), FLO_FC0(-4270.0), FLO_FC0(-31342.0), 
    FLO_FC0(32645.0), FLO_FC0(5727.5),  FLO_FC0(4919.0),  FLO_FC0(144.0), 
    FLO_FC0(817.0),   FLO_FC0(-63.5),   FLO_FC0(55.5),    FLO_FC0(3.0), 
    FLO_FC0(-2.5),    FLO_FC0(-48.5),   FLO_FC0(81.5),    FLO_FC0(-749.0), 
    FLO_FC0(92.5),    FLO_FC0(-4792.5), FLO_FC0(-4270.0), FLO_FC0(-31342.0), 
    FLO_FC0(32645.0), FLO_FC0(5727.5),  FLO_FC0(4919.0),  FLO_FC0(144.0), 
    FLO_FC0(817.0),   FLO_FC0(-63.5),   FLO_FC0(55.5),    FLO_FC0(3.0), 
    FLO_FC0(-2.5),    FLO_FC0(-52.0),   FLO_FC0(73.0),    FLO_FC0(-783.5), 
    FLO_FC0(-22.5),   FLO_FC0(-4863.5), FLO_FC0(-4987.5), FLO_FC0(-32009.5), 
    FLO_FC0(32009.5), FLO_FC0(4987.5),  FLO_FC0(4863.5),  FLO_FC0(22.5), 
    FLO_FC0(783.5),   FLO_FC0(-73.0),   FLO_FC0(52.0),    FLO_FC0(2.5), 
    FLO_FC0(-2.5),    FLO_FC0(-52.0),   FLO_FC0(73.0),    FLO_FC0(-783.5), 
    FLO_FC0(-22.5),   FLO_FC0(-4863.5), FLO_FC0(-4987.5), FLO_FC0(-32009.5), 
    FLO_FC0(32009.5), FLO_FC0(4987.5),  FLO_FC0(4863.5),  FLO_FC0(22.5), 
    FLO_FC0(783.5),   FLO_FC0(-73.0),   FLO_FC0(52.0),    FLO_FC0(2.5)
};

/*-------------------------------------------------------------------------
|       scale factors
+-------------------------------------------------------------------------*/
/* from table 3-B.1 */
const FLO_Float FLO_Scalefactors[64] =
{
    FLO_FC1(2.00000000000000), FLO_FC1(1.58740105196820), 
    FLO_FC1(1.25992104989487), FLO_FC1(1.00000000000000),
    FLO_FC1(0.79370052598410), FLO_FC1(0.62996052494744), 
    FLO_FC1(0.50000000000000), FLO_FC1(0.39685026299205),
    FLO_FC1(0.31498026247372), FLO_FC1(0.25000000000000), 
    FLO_FC1(0.19842513149602), FLO_FC1(0.15749013123686),
    FLO_FC1(0.12500000000000), FLO_FC1(0.09921256574801), 
    FLO_FC1(0.07874506561843), FLO_FC1(0.06250000000000),
    FLO_FC1(0.04960628287401), FLO_FC1(0.03937253280921), 
    FLO_FC1(0.03125000000000), FLO_FC1(0.02480314143700),
    FLO_FC1(0.01968626640461), FLO_FC1(0.01562500000000), 
    FLO_FC1(0.01240157071850), FLO_FC1(0.00984313320230),
    FLO_FC1(0.00781250000000), FLO_FC1(0.00620078535925), 
    FLO_FC1(0.00492156660115), FLO_FC1(0.00390625000000),
    FLO_FC1(0.00310039267963), FLO_FC1(0.00246078330058), 
    FLO_FC1(0.00195312500000), FLO_FC1(0.00155019633981),
    FLO_FC1(0.00123039165029), FLO_FC1(0.00097656250000), 
    FLO_FC1(0.00077509816991), FLO_FC1(0.00061519582514),
    FLO_FC1(0.00048828125000), FLO_FC1(0.00038754908495), 
    FLO_FC1(0.00030759791257), FLO_FC1(0.00024414062500),
    FLO_FC1(0.00019377454248), FLO_FC1(0.00015379895629), 
    FLO_FC1(0.00012207031250), FLO_FC1(0.00009688727124),
    FLO_FC1(0.00007689947814), FLO_FC1(0.00006103515625), 
    FLO_FC1(0.00004844363562), FLO_FC1(0.00003844973907),
    FLO_FC1(0.00003051757813), FLO_FC1(0.00002422181781), 
    FLO_FC1(0.00001922486954), FLO_FC1(0.00001525878906),
    FLO_FC1(0.00001211090890), FLO_FC1(0.00000961243477), 
    FLO_FC1(0.00000762939453), FLO_FC1(0.00000605545445),
    FLO_FC1(0.00000480621738), FLO_FC1(0.00000381469727), 
    FLO_FC1(0.00000302772723), FLO_FC1(0.00000240310869),
    FLO_FC1(0.00000190734863), FLO_FC1(0.00000151386361), 
    FLO_FC1(0.00000120155435), FLO_FC1(0.00000000000000)
};

#ifdef FLO_CONFIG_INTEGER_DECODE
/*-------------------------------------------------------------------------
|       Layer I quantization factors and offsets
+-------------------------------------------------------------------------*/
const FLO_Float FLO_LayerI_QuantFactors[15] = 
{
    65535,
    65535/3,
    65535/7,
    65535/15,
    65535/31,
    65535/63,
    65535/127,
    65535/255,
    65535/511,
    65535/1023,
    65535/2047,
    65535/4095,
    65535/8191,
    65535/16383,
    65535/32767,
};

const FLO_Float FLO_LayerI_QuantOffsets[15] = 
{
     0,
    -1,
    -3,
    -7,
    -15,
    -31,
    -63,
    -127,
    -255,
    -511,
    -1023,
    -2047,
    -4095,
    -8191,
    -16383
};

#else

/*-------------------------------------------------------------------------
|       Layer I quantization factors and offsets
+-------------------------------------------------------------------------*/
const FLO_Float FLO_LayerI_QuantFactors[15] = 
{
    2.0f/1.0f,
    2.0f/3.0f,
    2.0f/7.0f,
    2.0f/15.0f,
    2.0f/31.0f, 
    2.0f/63.0f, 
    2.0f/127.0f,
    2.0f/255.0f,  
    2.0f/511.0f,
    2.0f/1023.0f, 
    2.0f/2047.0f,
    2.0f/4095.0f, 
    2.0f/8191.0f,
    2.0f/16383.0f, 
    2.0f/32767.0f
};

const FLO_Float FLO_LayerI_QuantOffsets[15] = 
{
    -0.0000f,
    -1.00000f,
    -3.00000f,
    -7.00000f,
    -15.0000f,
    -31.0000f,
    -63.000f,
    -127.000f,
    -255.000f,
    -511.00f,
    -1023.00f,
    -2047.00f,
    -4095.00f,
    -8191.00f,
    -16383.0f
};
#endif /* FLO_CONFIG_INTEGER_DECODE */

/*-------------------------------------------------------------------------
|       grouping tables
+-------------------------------------------------------------------------*/
/* 3 steps */
static const FLO_GroupingTable G_3 /* 27*3 + 5*3 */ =
{ 
    {FLO_FC2(-2.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2(-2.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2( 0.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2(-2.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2( 0.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2(-2.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2( 0.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2( 2.0/3.0)},
    {FLO_FC2( 2.0/3.0), FLO_FC2( 2.0/3.0), FLO_FC2( 2.0/3.0)},

    /* padding for illegal groupped values */
    {FLO_FC2(     0.0), FLO_FC2(     0.0), FLO_FC2(     0.0)},
    {FLO_FC2(     0.0), FLO_FC2(     0.0), FLO_FC2(     0.0)},
    {FLO_FC2(     0.0), FLO_FC2(     0.0), FLO_FC2(     0.0)},
    {FLO_FC2(     0.0), FLO_FC2(     0.0), FLO_FC2(     0.0)},
    {FLO_FC2(     0.0), FLO_FC2(     0.0), FLO_FC2(     0.0)}
};

/* 5 steps */
static const FLO_GroupingTable G_5 /* 125*3 + 3*3 */ =
{
    {FLO_FC2(-0.8), FLO_FC2(-0.8), FLO_FC2(-0.8)},
    {FLO_FC2(-0.4), FLO_FC2(-0.8), FLO_FC2(-0.8)},
    {FLO_FC2( 0.0), FLO_FC2(-0.8), FLO_FC2(-0.8)},
    {FLO_FC2( 0.4), FLO_FC2(-0.8), FLO_FC2(-0.8)},
    {FLO_FC2( 0.8), FLO_FC2(-0.8), FLO_FC2(-0.8)},
    {FLO_FC2(-0.8), FLO_FC2(-0.4), FLO_FC2(-0.8)},
    {FLO_FC2(-0.4), FLO_FC2(-0.4), FLO_FC2(-0.8)},
    {FLO_FC2( 0.0), FLO_FC2(-0.4), FLO_FC2(-0.8)},
    {FLO_FC2( 0.4), FLO_FC2(-0.4), FLO_FC2(-0.8)},
    {FLO_FC2( 0.8), FLO_FC2(-0.4), FLO_FC2(-0.8)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.0), FLO_FC2(-0.8)},
    {FLO_FC2(-0.4), FLO_FC2( 0.0), FLO_FC2(-0.8)},
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2(-0.8)},
    {FLO_FC2( 0.4), FLO_FC2( 0.0), FLO_FC2(-0.8)},
    {FLO_FC2( 0.8), FLO_FC2( 0.0), FLO_FC2(-0.8)},
    {FLO_FC2(-0.8), FLO_FC2( 0.4), FLO_FC2(-0.8)},
    {FLO_FC2(-0.4), FLO_FC2( 0.4), FLO_FC2(-0.8)},
    {FLO_FC2( 0.0), FLO_FC2( 0.4), FLO_FC2(-0.8)},
    {FLO_FC2( 0.4), FLO_FC2( 0.4), FLO_FC2(-0.8)},
    {FLO_FC2( 0.8), FLO_FC2( 0.4), FLO_FC2(-0.8)},
    {FLO_FC2(-0.8), FLO_FC2( 0.8), FLO_FC2(-0.8)},
    {FLO_FC2(-0.4), FLO_FC2( 0.8), FLO_FC2(-0.8)},
    {FLO_FC2( 0.0), FLO_FC2( 0.8), FLO_FC2(-0.8)},
    {FLO_FC2( 0.4), FLO_FC2( 0.8), FLO_FC2(-0.8)},
    {FLO_FC2( 0.8), FLO_FC2( 0.8), FLO_FC2(-0.8)},
    {FLO_FC2(-0.8), FLO_FC2(-0.8), FLO_FC2(-0.4)},
    {FLO_FC2(-0.4), FLO_FC2(-0.8), FLO_FC2(-0.4)},
    {FLO_FC2( 0.0), FLO_FC2(-0.8), FLO_FC2(-0.4)},
    {FLO_FC2( 0.4), FLO_FC2(-0.8), FLO_FC2(-0.4)},
    {FLO_FC2( 0.8), FLO_FC2(-0.8), FLO_FC2(-0.4)},
    {FLO_FC2(-0.8), FLO_FC2(-0.4), FLO_FC2(-0.4)},
    {FLO_FC2(-0.4), FLO_FC2(-0.4), FLO_FC2(-0.4)},
    {FLO_FC2( 0.0), FLO_FC2(-0.4), FLO_FC2(-0.4)},
    {FLO_FC2( 0.4), FLO_FC2(-0.4), FLO_FC2(-0.4)},
    {FLO_FC2( 0.8), FLO_FC2(-0.4), FLO_FC2(-0.4)},
    {FLO_FC2(-0.8), FLO_FC2( 0.0), FLO_FC2(-0.4)},
    {FLO_FC2(-0.4), FLO_FC2( 0.0), FLO_FC2(-0.4)},
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2(-0.4)},
    {FLO_FC2( 0.4), FLO_FC2( 0.0), FLO_FC2(-0.4)},
    {FLO_FC2( 0.8), FLO_FC2( 0.0), FLO_FC2(-0.4)},
    {FLO_FC2(-0.8), FLO_FC2( 0.4), FLO_FC2(-0.4)},
    {FLO_FC2(-0.4), FLO_FC2( 0.4), FLO_FC2(-0.4)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.4), FLO_FC2(-0.4)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.4), FLO_FC2(-0.4)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.4), FLO_FC2(-0.4)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.8), FLO_FC2(-0.4)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.8), FLO_FC2(-0.4)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.8), FLO_FC2(-0.4)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.8), FLO_FC2(-0.4)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.8), FLO_FC2(-0.4)}, 
    {FLO_FC2(-0.8), FLO_FC2(-0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.4), FLO_FC2(-0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.0), FLO_FC2(-0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.4), FLO_FC2(-0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.8), FLO_FC2(-0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.8), FLO_FC2(-0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.4), FLO_FC2(-0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.0), FLO_FC2(-0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.4), FLO_FC2(-0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.8), FLO_FC2(-0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.0), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.0), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.0), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.0), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.4), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.8), FLO_FC2( 0.0)}, 
    {FLO_FC2(-0.8), FLO_FC2(-0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.4), FLO_FC2(-0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.0), FLO_FC2(-0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.4), FLO_FC2(-0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.8), FLO_FC2(-0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.8), FLO_FC2(-0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.4), FLO_FC2(-0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.0), FLO_FC2(-0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.4), FLO_FC2(-0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.8), FLO_FC2(-0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.0), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.0), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.0), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.0), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.4), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.8), FLO_FC2( 0.4)}, 
    {FLO_FC2(-0.8), FLO_FC2(-0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.4), FLO_FC2(-0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.0), FLO_FC2(-0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.4), FLO_FC2(-0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.8), FLO_FC2(-0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.8), FLO_FC2(-0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.4), FLO_FC2(-0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.0), FLO_FC2(-0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.4), FLO_FC2(-0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.8), FLO_FC2(-0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.0), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.0), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.0), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.0), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.4), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.8), FLO_FC2( 0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2(-0.4), FLO_FC2( 0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.0), FLO_FC2( 0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.4), FLO_FC2( 0.8), FLO_FC2( 0.8)}, 
    {FLO_FC2( 0.8), FLO_FC2( 0.8), FLO_FC2( 0.8)},

    /* padding for illegal groupped values */
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2( 0.0)},
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2( 0.0)},
    {FLO_FC2( 0.0), FLO_FC2( 0.0), FLO_FC2( 0.0)}
};

/* 9 steps */
static const FLO_GroupingTable G_9 /* 729*3 + 295*3 */ =
{
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2(-2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 0.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 2.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 4.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 6.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},
    {FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0), FLO_FC2( 8.0/9.0)},

    /* padding for illegal groupped values */
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)},
    { FLO_FC2(    0.0),  FLO_FC2(    0.0),  FLO_FC2(    0.0)}
};

/*-------------------------------------------------------------------------
|   Layer II
|   values from 11172-3 tables 3-B.2a 3-B.2b 3-B.2c 3-B.2d 
|   and 3-B.4
+-------------------------------------------------------------------------*/
const unsigned char FLO_LayerII_SubbandLimits[4][11] = 
{
    /* 44.1 kHz */
    { 30,  8,  8, 27, 27, 27, 30, 30, 30, 30, 30 },
    /* 48   kHz */
    { 27,  8,  8, 27, 27, 27, 27, 27, 27, 27, 27 },
    /* 32   kHz */
    { 30, 12, 12, 27, 27, 27, 30, 30, 30, 30, 30 }
};

/* alloc tables for MPEG 1 */

/* for subbands 0..2 of tables 3-B.2a and 3-B.2b */
static const FLO_AllocationTableEntry LayerII_3B_2ab_0_2 = {
    4,      /* allocation_length */
    {
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5,  &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {3,     0, FLO_FC3(1.14285714286, 4.00000), 3    },
        {4,     0, FLO_FC3(1.06666666666, 8.00000), 7    },
        {5,     0, FLO_FC3(1.03225806452, 16.0000), 15   },
        {6,     0, FLO_FC3(1.01587301587, 32.0000), 31   },
        {7,     0, FLO_FC3(1.00787401575, 64.0000), 63   },
        {8,     0, FLO_FC3(1.00392156863, 128.000), 127  },
        {9,     0, FLO_FC3(1.00195694716, 256.000), 255  },
        {10,    0, FLO_FC3(1.00097751711, 512.000), 511  },
        {11,    0, FLO_FC3(1.00048851979, 1024.00), 1023 },
        {12,    0, FLO_FC3(1.00024420024, 2048.00), 2047 },
        {13,    0, FLO_FC3(1.00012208522, 4096.00), 4095 },
        {14,    0, FLO_FC3(1.00006103888, 8192.00), 8191 },
        {15,    0, FLO_FC3(1.00003051851, 16384.0), 16383},
        {16,    0, FLO_FC3(1.00001525902, 32768.0), 32767}
    }
};

/* for subbands 3..10 of tables 3-B.2a and 3-B.2b */
static const FLO_AllocationTableEntry LayerII_3B_2ab_3_10 = {
    4,      /* allocation_length */
    {
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5,  &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7,  &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {3,     0, FLO_FC3(1.14285714286, 4.00000), 3    },
        {10, &G_9, FLO_FC3(1.77777777777, 8.00000), 7    },
        {4,     0, FLO_FC3(1.06666666666, 8.00000), 7    },
        {5,     0, FLO_FC3(1.03225806452, 16.0000), 15   },
        {6,     0, FLO_FC3(1.01587301587, 32.0000), 31   },
        {7,     0, FLO_FC3(1.00787401575, 64.0000), 63   },
        {8,     0, FLO_FC3(1.00392156863, 128.000), 127  },
        {9,     0, FLO_FC3(1.00195694716, 256.000), 255  },
        {10,    0, FLO_FC3(1.00097751711, 512.000), 511  },
        {11,    0, FLO_FC3(1.00048851979, 1024.00), 1023 },
        {12,    0, FLO_FC3(1.00024420024, 2048.00), 2047 },
        {13,    0, FLO_FC3(1.00012208522, 4096.00), 4095 },
        {16,    0, FLO_FC3(1.00001525902, 32768.0), 32767}
    }
};

/* for subbands 11..22 of tables 3-B.2a and 3-B.2b */
static const FLO_AllocationTableEntry LayerII_3B_2ab_11_22 = {
    3,     /* allocation length */
    {
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5,  &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7,  &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {3,     0, FLO_FC3(1.14285714286, 4.00000), 3    },
        {10, &G_9, FLO_FC3(1.77777777777, 8.00000), 7    },
        {4,     0, FLO_FC3(1.06666666666, 8.00000), 7    },
        {5,     0, FLO_FC3(1.03225806452, 16.0000), 15   },
        {16,    0, FLO_FC3(1.00001525902, 32768.0), 32767},
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    }
    }
};
       
/* for subbands 23..{26,29}  of tables 3-B.2a and 3-B.2b */
static const FLO_AllocationTableEntry LayerII_3B_2ab_23_29 = {
    2,     /* allocation length */
    {
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5 , &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7 , &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {16,    0, FLO_FC3(1.00001525902, 32768.0), 32767},
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0,     0, FLO_FC3(0.00000000000, 1.00000), 0    }
    }
}; 

/* for subbands 0..1  of tables 3-B.2c and 3-B.2d */
static const FLO_AllocationTableEntry LayerII_3B_2cd_0_1 = {
    4,     /* allocation length */
    {
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5 , &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7 , &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {10, &G_9, FLO_FC3(1.77777777777, 8.00000), 7    },
        {4 ,    0, FLO_FC3(1.06666666666, 8.00000), 7    },
        {5 ,    0, FLO_FC3(1.03225806452, 16.0000), 15   },
        {6 ,    0, FLO_FC3(1.01587301587, 32.0000), 31   },
        {7 ,    0, FLO_FC3(1.00787401575, 64.0000), 63   },
        {8 ,    0, FLO_FC3(1.00392156863, 128.000), 127  },
        {9 ,    0, FLO_FC3(1.00195694716, 256.000), 255  },
        {10,    0, FLO_FC3(1.00097751711, 512.000), 511  },
        {11,    0, FLO_FC3(1.00048851979, 1024.00), 1023 },
        {12,    0, FLO_FC3(1.00024420024, 2048.00), 2047 },
        {13,    0, FLO_FC3(1.00012208522, 4096.00), 4095 },
        {14,    0, FLO_FC3(1.00006103888, 8192.00), 8191 },
        {15,    0, FLO_FC3(1.00003051851, 16384.0), 16383}
    }
};

/* for subbands 2..11  of tables 3-B.2c and 3-B.2d */
static const FLO_AllocationTableEntry LayerII_3B_2cd_2_11 = {
    3,     /* allocation length */
    {
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5 , &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7 , &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {10, &G_9, FLO_FC3(1.77777777777, 8.00000), 7    },
        {4 ,    0, FLO_FC3(1.06666666666, 8.00000), 7    },
        {5 ,    0, FLO_FC3(1.03225806452, 16.0000), 15   },
        {6 ,    0, FLO_FC3(1.01587301587, 32.0000), 31   },
        {7 ,    0, FLO_FC3(1.00787401575, 64.0000), 63   },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
    }
};

/* same tables for MPEG 2 */

/* for subbands 0..3 of table 3-B.1 (MPEG 2) */
static const FLO_AllocationTableEntry LayerII_3B_1_0_3 = {
    4,     /* allocation length */
    {
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5 , &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7 , &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {3 ,    0, FLO_FC3(1.14285714286, 4.00000), 3    },
        {10, &G_9, FLO_FC3(1.77777777777, 8.00000), 7    },
        {4 ,    0, FLO_FC3(1.06666666666, 8.00000), 7    },
        {5 ,    0, FLO_FC3(1.03225806452, 16.0000), 15   },
        {6 ,    0, FLO_FC3(1.01587301587, 32.0000), 31   },
        {7 ,    0, FLO_FC3(1.00787401575, 64.0000), 63   },
        {8 ,    0, FLO_FC3(1.00392156863, 128.000), 127  },
        {9 ,    0, FLO_FC3(1.00195694716, 256.000), 255  },
        {10,    0, FLO_FC3(1.00097751711, 512.000), 511  },
        {11,    0, FLO_FC3(1.00048851979, 1024.00), 1023 },
        {12,    0, FLO_FC3(1.00024420024, 2048.00), 2047 },
        {13,    0, FLO_FC3(1.00012208522, 4096.00), 4095 },
        {14,    0, FLO_FC3(1.00006103888, 8192.00), 8191 }
    }
};

/* for subbands 4..10 of table 3-B.1 (MPEG 2) */
static const FLO_AllocationTableEntry LayerII_3B_1_4_10 = {
    3,     /* allocation length */
    {
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5 , &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7 , &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {10, &G_9, FLO_FC3(1.77777777777, 8.00000), 7    },
        {4 ,    0, FLO_FC3(1.06666666666, 8.00000), 7    },
        {5 ,    0, FLO_FC3(1.03225806452, 16.0000), 15   },
        {6 ,    0, FLO_FC3(1.01587301587, 32.0000), 31   },
        {7 ,    0, FLO_FC3(1.00787401575, 64.0000), 63   },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
    }
};

/* for subbands 11..29 of table 3-B.1 (MPEG 2) */
static const FLO_AllocationTableEntry LayerII_3B_1_11_29 = {
    2,     /* allocation length */
    {
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {5 , &G_3, FLO_FC3(1.33333333333, 2.00000), 1    },
        {7 , &G_5, FLO_FC3(1.60000000000, 4.00000), 3    },
        {10, &G_9, FLO_FC3(1.77777777777, 8.00000), 7    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
        {0 ,    0, FLO_FC3(0.00000000000, 1.00000), 0    },
    }
};

static const FLO_AllocationTableEntry * const LayerII_3B_2a[27] = {
    &LayerII_3B_2ab_0_2,         /* subband 0  */
    &LayerII_3B_2ab_0_2,         /* subband 1  */
    &LayerII_3B_2ab_0_2,         /* subband 2  */
    &LayerII_3B_2ab_3_10,        /* subband 3  */
    &LayerII_3B_2ab_3_10,        /* subband 4  */
    &LayerII_3B_2ab_3_10,        /* subband 5  */
    &LayerII_3B_2ab_3_10,        /* subband 6  */
    &LayerII_3B_2ab_3_10,        /* subband 7  */
    &LayerII_3B_2ab_3_10,        /* subband 8  */
    &LayerII_3B_2ab_3_10,        /* subband 9  */
    &LayerII_3B_2ab_3_10,        /* subband 10 */
    &LayerII_3B_2ab_11_22,       /* subband 11 */
    &LayerII_3B_2ab_11_22,       /* subband 12 */
    &LayerII_3B_2ab_11_22,       /* subband 13 */
    &LayerII_3B_2ab_11_22,       /* subband 14 */
    &LayerII_3B_2ab_11_22,       /* subband 15 */
    &LayerII_3B_2ab_11_22,       /* subband 16 */
    &LayerII_3B_2ab_11_22,       /* subband 17 */
    &LayerII_3B_2ab_11_22,       /* subband 18 */
    &LayerII_3B_2ab_11_22,       /* subband 19 */
    &LayerII_3B_2ab_11_22,       /* subband 20 */
    &LayerII_3B_2ab_11_22,       /* subband 21 */
    &LayerII_3B_2ab_11_22,       /* subband 22 */
    &LayerII_3B_2ab_23_29,       /* subband 23 */
    &LayerII_3B_2ab_23_29,       /* subband 24 */
    &LayerII_3B_2ab_23_29,       /* subband 25 */
    &LayerII_3B_2ab_23_29,       /* subband 26 */
};

static const FLO_AllocationTableEntry * const LayerII_3B_2b[30] = {
    &LayerII_3B_2ab_0_2,         /* subband 0  */
    &LayerII_3B_2ab_0_2,         /* subband 1  */
    &LayerII_3B_2ab_0_2,         /* subband 2  */
    &LayerII_3B_2ab_3_10,        /* subband 3  */
    &LayerII_3B_2ab_3_10,        /* subband 4  */
    &LayerII_3B_2ab_3_10,        /* subband 5  */
    &LayerII_3B_2ab_3_10,        /* subband 6  */
    &LayerII_3B_2ab_3_10,        /* subband 7  */
    &LayerII_3B_2ab_3_10,        /* subband 8  */
    &LayerII_3B_2ab_3_10,        /* subband 9  */
    &LayerII_3B_2ab_3_10,        /* subband 10 */
    &LayerII_3B_2ab_11_22,       /* subband 11 */
    &LayerII_3B_2ab_11_22,       /* subband 12 */
    &LayerII_3B_2ab_11_22,       /* subband 13 */
    &LayerII_3B_2ab_11_22,       /* subband 14 */
    &LayerII_3B_2ab_11_22,       /* subband 15 */
    &LayerII_3B_2ab_11_22,       /* subband 16 */
    &LayerII_3B_2ab_11_22,       /* subband 17 */
    &LayerII_3B_2ab_11_22,       /* subband 18 */
    &LayerII_3B_2ab_11_22,       /* subband 19 */
    &LayerII_3B_2ab_11_22,       /* subband 20 */
    &LayerII_3B_2ab_11_22,       /* subband 21 */
    &LayerII_3B_2ab_11_22,       /* subband 22 */
    &LayerII_3B_2ab_23_29,       /* subband 23 */
    &LayerII_3B_2ab_23_29,       /* subband 24 */
    &LayerII_3B_2ab_23_29,       /* subband 25 */
    &LayerII_3B_2ab_23_29,       /* subband 26 */
    &LayerII_3B_2ab_23_29,       /* subband 27 */
    &LayerII_3B_2ab_23_29,       /* subband 28 */
    &LayerII_3B_2ab_23_29,       /* subband 29 */
};

static const FLO_AllocationTableEntry * const LayerII_3B_2c[8] = {
    &LayerII_3B_2cd_0_1,         /* subband 0  */
    &LayerII_3B_2cd_0_1,         /* subband 1  */
    &LayerII_3B_2cd_2_11,        /* subband 2  */
    &LayerII_3B_2cd_2_11,        /* subband 3  */
    &LayerII_3B_2cd_2_11,        /* subband 4  */
    &LayerII_3B_2cd_2_11,        /* subband 5  */
    &LayerII_3B_2cd_2_11,        /* subband 6  */
    &LayerII_3B_2cd_2_11,        /* subband 7  */
};

static const FLO_AllocationTableEntry * const LayerII_3B_2d[12] = {
    &LayerII_3B_2cd_0_1,         /* subband 0  */
    &LayerII_3B_2cd_0_1,         /* subband 1  */
    &LayerII_3B_2cd_2_11,        /* subband 2  */
    &LayerII_3B_2cd_2_11,        /* subband 3  */
    &LayerII_3B_2cd_2_11,        /* subband 4  */
    &LayerII_3B_2cd_2_11,        /* subband 5  */
    &LayerII_3B_2cd_2_11,        /* subband 6  */
    &LayerII_3B_2cd_2_11,        /* subband 7  */
    &LayerII_3B_2cd_2_11,        /* subband 8  */
    &LayerII_3B_2cd_2_11,        /* subband 9  */
    &LayerII_3B_2cd_2_11,        /* subband 10 */
    &LayerII_3B_2cd_2_11,        /* subband 11 */
};

const FLO_AllocationTableEntry * const FLO_LayerII_Mpeg2_AllocationTable[30] = {
    &LayerII_3B_1_0_3,           /* subband 0  */
    &LayerII_3B_1_0_3,           /* subband 1  */
    &LayerII_3B_1_0_3,           /* subband 2  */
    &LayerII_3B_1_0_3,           /* subband 3  */
    &LayerII_3B_1_4_10,          /* subband 4  */
    &LayerII_3B_1_4_10,          /* subband 5  */
    &LayerII_3B_1_4_10,          /* subband 6  */
    &LayerII_3B_1_4_10,          /* subband 7  */
    &LayerII_3B_1_4_10,          /* subband 8  */
    &LayerII_3B_1_4_10,          /* subband 9  */
    &LayerII_3B_1_4_10,          /* subband 10 */
    &LayerII_3B_1_11_29,         /* subband 11 */
    &LayerII_3B_1_11_29,         /* subband 12 */
    &LayerII_3B_1_11_29,         /* subband 13 */
    &LayerII_3B_1_11_29,         /* subband 14 */
    &LayerII_3B_1_11_29,         /* subband 15 */
    &LayerII_3B_1_11_29,         /* subband 16 */
    &LayerII_3B_1_11_29,         /* subband 17 */
    &LayerII_3B_1_11_29,         /* subband 18 */
    &LayerII_3B_1_11_29,         /* subband 19 */
    &LayerII_3B_1_11_29,         /* subband 20 */
    &LayerII_3B_1_11_29,         /* subband 21 */
    &LayerII_3B_1_11_29,         /* subband 22 */
    &LayerII_3B_1_11_29,         /* subband 23 */
    &LayerII_3B_1_11_29,         /* subband 24 */
    &LayerII_3B_1_11_29,         /* subband 25 */
    &LayerII_3B_1_11_29,         /* subband 26 */
    &LayerII_3B_1_11_29,         /* subband 27 */
    &LayerII_3B_1_11_29,         /* subband 28 */
    &LayerII_3B_1_11_29,         /* subband 29 */
};

const FLO_AllocationTableEntry * const * const FLO_LayerII_AllocationTables[3][11] = {
    {
        /* 44.1 kHz */
        LayerII_3B_2b, 
        LayerII_3B_2c,
        LayerII_3B_2c,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2b,
        LayerII_3B_2b,
        LayerII_3B_2b,
        LayerII_3B_2b,
        LayerII_3B_2b
    },
    {
        /* 48   kHz */
        LayerII_3B_2a, 
        LayerII_3B_2c,
        LayerII_3B_2c,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a
    },
    {
        /* 32   kHz */
        LayerII_3B_2b, 
        LayerII_3B_2d,
        LayerII_3B_2d,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2a,
        LayerII_3B_2b,
        LayerII_3B_2b,
        LayerII_3B_2b,
        LayerII_3B_2b,
        LayerII_3B_2b
    }
};

/*-------------------------------------------------------------------------
|   Layer III
+-------------------------------------------------------------------------*/
const int FLO_ScalefactorLengths[16][2] = 
{
    {0,0}, {0,1}, {0,2}, {0,3}, {3,0}, {1,1}, {1,2}, {1,3}, 
    {2,1}, {2,2}, {2,3}, {3,1}, {3,2}, {3,3}, {4,2}, {4,3}
};

/* info about layer III subbands. From table 3-B.8{a,b,c} */
const FLO_LayerIII_BandInfo FLO_SubbandInfo_Long[3][3][23] = 
{
    {
        /* MPEG 2 */
        {
            /* pure long, 22.05kHz */
            {  0,   6,   0},
            {  6,   6,   6},
            { 12,   6,  12}, 
            { 18,   6,  18}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   8,  36}, 
            { 44,  10,  44}, 
            { 54,  12,  54}, 
            { 66,  14,  66}, 
            { 80,  16,  80}, 
            { 96,  20,  96}, 
            {116,  24, 116}, 
            {140,  28, 140},
            {168,  32, 168},
            {200,  38, 200},
            {238,  46, 238},
            {284,  52, 284},
            {336,  60, 336},
            {396,  68, 396},
            {464,  58, 464},
            {522,  54, 522},
            { -1,   0,   0}
        },
        {
            /* pure long, 24kHz */
            {  0,   6,   0},
            {  6,   6,   6},
            { 12,   6,  12}, 
            { 18,   6,  18}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   8,  36}, 
            { 44,  10,  44}, 
            { 54,  12,  54}, 
            { 66,  14,  66}, 
            { 80,  16,  80}, 
            { 96,  18,  96}, 
            {114,  22, 114}, 
            {136,  26, 136},
            {162,  32, 162},
            {194,  38, 194},
            {232,  46, 232},
            {278,  54, 278},
            {332,  62, 332},
            {394,  70, 394},
            {464,  76, 464},
            {540,  36, 540},
            { -1,   0,   0}
        },
        {
            /* pure long, 16kHz */
            {  0,   6,   0},
            {  6,   6,   6},
            { 12,   6,  12}, 
            { 18,   6,  18}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   8,  36}, 
            { 44,  10,  44}, 
            { 54,  12,  54}, 
            { 66,  14,  66}, 
            { 80,  16,  80}, 
            { 96,  20,  96}, 
            {116,  24, 116}, 
            {140,  28, 140},
            {168,  32, 168},
            {200,  38, 200},
            {238,  46, 238},
            {284,  52, 284},
            {336,  60, 336},
            {396,  68, 396},
            {464,  58, 464},
            {522,  54, 522},
            { -1,   0,   0}
        }
    },
    {
        /* MPEG 1 */
        {
            /* pure long, 44.1kHz */
            {  0,   4,   0},
            {  4,   4,   4},
            {  8,   4,   8}, 
            { 12,   4,  12}, 
            { 16,   4,  16}, 
            { 20,   4,  20}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   8,  36}, 
            { 44,   8,  44}, 
            { 52,  10,  52}, 
            { 62,  12,  62}, 
            { 74,  16,  74}, 
            { 90,  20,  90},
            {110,  24, 110},
            {134,  28, 134},
            {162,  34, 162},
            {196,  42, 196},
            {238,  50, 238},
            {288,  54, 288},
            {342,  76, 342},
            {418, 158, 418},
            { -1,   0,   0}
        },
        {
            /* pure long, 48kHz */
            {  0,   4,   0},
            {  4,   4,   4},
            {  8,   4,   8}, 
            { 12,   4,  12}, 
            { 16,   4,  16}, 
            { 20,   4,  20}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   6,  36}, 
            { 42,   8,  42}, 
            { 50,  10,  50}, 
            { 60,  12,  60}, 
            { 72,  16,  72}, 
            { 88,  18,  88},
            {106,  22, 106},
            {128,  28, 128},
            {156,  34, 156},
            {190,  40, 190},
            {230,  46, 230},
            {276,  54, 276},
            {330,  54, 330},
            {384, 192, 384},
            { -1,   0,   0}
        },
        {
            /* pure long, 32kHz */
            {  0,   4,   0},
            {  4,   4,   4},
            {  8,   4,   8}, 
            { 12,   4,  12}, 
            { 16,   4,  16}, 
            { 20,   4,  20}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   8,  36}, 
            { 44,  10,  44}, 
            { 54,  12,  54}, 
            { 66,  16,  66}, 
            { 82,  20,  82}, 
            {102,  24, 102},
            {126,  30, 126},
            {156,  38, 156},
            {194,  46, 194},
            {240,  56, 240},
            {296,  68, 296},
            {364,  84, 364},
            {448, 102, 448},
            {550,  26, 550},
            { -1,   0,   0}
        }
    },
    {
        /* MPEG 2.5 */
        {
            /* pure long, 11.025kHz */
            {  0,   6,   0},
            {  6,   6,   6},
            { 12,   6,  12}, 
            { 18,   6,  18}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   8,  36}, 
            { 44,  10,  44}, 
            { 54,  12,  54}, 
            { 66,  14,  66}, 
            { 80,  16,  80}, 
            { 96,  20,  96}, 
            {116,  24, 116}, 
            {140,  28, 140},
            {168,  32, 168},
            {200,  38, 200},
            {238,  46, 238},
            {284,  52, 284},
            {336,  60, 336},
            {396,  68, 396},
            {464,  58, 464},
            {522,  54, 522},
            { -1,   0,   0}
        },
        {
            /* pure long, 12kHz */
            {  0,   6,   0},
            {  6,   6,   6},
            { 12,   6,  12}, 
            { 18,   6,  18}, 
            { 24,   6,  24}, 
            { 30,   6,  30}, 
            { 36,   8,  36}, 
            { 44,  10,  44}, 
            { 54,  12,  54}, 
            { 66,  14,  66}, 
            { 80,  16,  80}, 
            { 96,  20,  96}, 
            {116,  24, 116}, 
            {140,  28, 140},
            {168,  32, 168},
            {200,  38, 200},
            {238,  46, 238},
            {284,  52, 284},
            {336,  60, 336},
            {396,  68, 396},
            {464,  58, 464},
            {522,  54, 522},
            { -1,   0,   0}
        },
        {
            /* pure long, 8kHz */
            {  0,  12,   0},
            { 12,  12,  12},
            { 24,  12,  24}, 
            { 36,  12,  36}, 
            { 48,  12,  48}, 
            { 60,  12,  60}, 
            { 72,  16,  72}, 
            { 88,  20,  88}, 
            {108,  24, 108}, 
            {132,  28, 132}, 
            {160,  32, 160}, 
            {192,  40, 192}, 
            {232,  48, 232}, 
            {280,  56, 280},
            {336,  64, 336},
            {400,  76, 400},
            {476,  90, 476},
            {566,   2, 566},
            {568,   2, 568},
            {570,   2, 570},
            {572,   2, 572},
            {574,   2, 574},
            { -1,   0,   0}
        }
    }
};

const FLO_LayerIII_BandInfo FLO_SubbandInfo_Short[3][3][13*3+1] =
{
    /* MPEG 2 */
    {
        {
            /* pure short, 22.05kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   6,  36}, 
            { 12,   6,  37}, 
            { 12,   6,  38}, 
            { 18,   6,  54},
            { 18,   6,  55},
            { 18,   6,  56},
            { 24,   8,  72},
            { 24,   8,  73},
            { 24,   8,  74},
            { 32,  10,  96},
            { 32,  10,  97},
            { 32,  10,  98},
            { 42,  14, 126},
            { 42,  14, 127},
            { 42,  14, 128},
            { 56,  18, 168}, 
            { 56,  18, 169}, 
            { 56,  18, 170}, 
            { 74,  26, 222}, 
            { 74,  26, 223}, 
            { 74,  26, 224}, 
            {100,  32, 300},
            {100,  32, 301},
            {100,  32, 302},
            {132,  42, 396},
            {132,  42, 397},
            {132,  42, 398},
            {174,  18, 522},
            {174,  18, 523},
            {174,  18, 524},
            { -1,   0,   0}
        },
        {
            /* pure short, 24kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   6,  36}, 
            { 12,   6,  37}, 
            { 12,   6,  38}, 
            { 18,   8,  54},
            { 18,   8,  55},
            { 18,   8,  56},
            { 26,  10,  78},
            { 26,  10,  79},
            { 26,  10,  90},
            { 36,  12, 108},
            { 36,  12, 109},
            { 36,  12, 110},
            { 48,  14, 144},
            { 48,  14, 145},
            { 48,  14, 146},
            { 62,  18, 186}, 
            { 62,  18, 187}, 
            { 62,  18, 188}, 
            { 80,  24, 240}, 
            { 80,  24, 241}, 
            { 80,  24, 242}, 
            {104,  32, 312},
            {104,  32, 313},
            {104,  32, 314},
            {136,  44, 408},
            {136,  44, 409},
            {136,  44, 410},
            {180,  12, 540},
            {180,  12, 541},
            {180,  12, 542},
            { -1,   0,   0}
        },
        {
            /* pure short, 16kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   6,  36}, 
            { 12,   6,  37}, 
            { 12,   6,  38}, 
            { 18,   8,  54},
            { 18,   8,  55},
            { 18,   8,  56},
            { 26,  10,  78},
            { 26,  10,  79},
            { 26,  10,  80},
            { 36,  12, 108},
            { 36,  12, 109},
            { 36,  12, 110},
            { 48,  14, 144},
            { 48,  14, 145},
            { 48,  14, 146},
            { 62,  18, 186}, 
            { 62,  18, 187}, 
            { 62,  18, 188}, 
            { 80,  24, 240}, 
            { 80,  24, 241}, 
            { 80,  24, 242}, 
            {104,  30, 312},
            {104,  30, 313},
            {104,  30, 314},
            {134,  40, 402},
            {134,  40, 403},
            {134,  40, 404},
            {174,  18, 522},
            {174,  18, 523},
            {174,  18, 524},
            { -1,   0,   0}
        }
    },
    {
        /* MPEG 1 */
        {
            /* pure short, 44.1kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   4,  36}, 
            { 12,   4,  37}, 
            { 12,   4,  38}, 
            { 16,   6,  48},
            { 16,   6,  49},
            { 16,   6,  50},
            { 22,   8,  66},
            { 22,   8,  67},
            { 22,   8,  68},
            { 30,  10,  90},
            { 30,  10,  91},
            { 30,  10,  92},
            { 40,  12, 120},
            { 40,  12, 121},
            { 40,  12, 122},
            { 52,  14, 156}, 
            { 52,  14, 157}, 
            { 52,  14, 158}, 
            { 66,  18, 198}, 
            { 66,  18, 199}, 
            { 66,  18, 200}, 
            { 84,  22, 252},
            { 84,  22, 253},
            { 84,  22, 254},
            {106,  30, 318},
            {106,  30, 319},
            {106,  30, 320},
            {136,  56, 408},
            {136,  56, 409},
            {136,  56, 410},
            { -1,   0,   0}
        },
        {
            /* pure short, 48kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   4,  36}, 
            { 12,   4,  37}, 
            { 12,   4,  38}, 
            { 16,   6,  48},
            { 16,   6,  49},
            { 16,   6,  50},
            { 22,   6,  66},
            { 22,   6,  67},
            { 22,   6,  68},
            { 28,  10,  84},
            { 28,  10,  85},
            { 28,  10,  86},
            { 38,  12, 114},
            { 38,  12, 115},
            { 38,  12, 116},
            { 50,  14, 150}, 
            { 50,  14, 151}, 
            { 50,  14, 152}, 
            { 64,  16, 192}, 
            { 64,  16, 193}, 
            { 64,  16, 194}, 
            { 80,  20, 240},
            { 80,  20, 241},
            { 80,  20, 242},
            {100,  26, 300},
            {100,  26, 301},
            {100,  26, 302},
            {126,  66, 378},
            {126,  66, 379},
            {126,  66, 380},
            { -1,   0,   0}
        },
        {
            /* pure short, 32kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   4,  36}, 
            { 12,   4,  37}, 
            { 12,   4,  38}, 
            { 16,   6,  48},
            { 16,   6,  49},
            { 16,   6,  50},
            { 22,   8,  66},
            { 22,   8,  67},
            { 22,   8,  68},
            { 30,  12,  90},
            { 30,  12,  91},
            { 30,  12,  92},
            { 42,  16, 126},
            { 42,  16, 127},
            { 42,  16, 128},
            { 58,  20, 174}, 
            { 58,  20, 175}, 
            { 58,  20, 176}, 
            { 78,  26, 234}, 
            { 78,  26, 235}, 
            { 78,  26, 236}, 
            {104,  34, 312},
            {104,  34, 313},
            {104,  34, 314},
            {138,  42, 414},
            {138,  42, 415},
            {138,  42, 416},
            {180,  12, 540},
            {180,  12, 541},
            {180,  12, 542},
            { -1,   0,   0}
        }
    },
    {
        /* MPEG 2.5 */
        {
            /* pure short, 11.025kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   6,  36}, 
            { 12,   6,  37}, 
            { 12,   6,  38}, 
            { 18,   8,  54},
            { 18,   8,  55},
            { 18,   8,  56},
            { 26,  10,  78},
            { 26,  10,  79},
            { 26,  10,  80},
            { 36,  12, 108},
            { 36,  12, 109},
            { 36,  12, 110},
            { 48,  14, 144},
            { 48,  14, 145},
            { 48,  14, 146},
            { 62,  18, 186}, 
            { 62,  18, 187}, 
            { 62,  18, 188}, 
            { 80,  24, 240}, 
            { 80,  24, 241}, 
            { 80,  24, 242}, 
            {104,  30, 312},
            {104,  30, 313},
            {104,  30, 314},
            {134,  40, 402},
            {134,  40, 403},
            {134,  40, 404},
            {174,  18, 522},
            {174,  18, 523},
            {174,  18, 524},
            { -1,   0,   0}
        },
        {
            /* pure short, 12kHz */
            {  0,   4,   0},   
            {  0,   4,   1},   
            {  0,   4,   2},   
            {  4,   4,  12},
            {  4,   4,  13},
            {  4,   4,  14},
            {  8,   4,  24},
            {  8,   4,  25},
            {  8,   4,  26},
            { 12,   6,  36}, 
            { 12,   6,  37}, 
            { 12,   6,  38}, 
            { 18,   8,  54},
            { 18,   8,  55},
            { 18,   8,  56},
            { 26,  10,  78},
            { 26,  10,  79},
            { 26,  10,  80},
            { 36,  12, 108},
            { 36,  12, 109},
            { 36,  12, 110},
            { 48,  14, 144},
            { 48,  14, 145},
            { 48,  14, 146},
            { 62,  18, 186}, 
            { 62,  18, 187}, 
            { 62,  18, 188}, 
            { 80,  24, 240}, 
            { 80,  24, 241}, 
            { 80,  24, 242}, 
            {104,  30, 312},
            {104,  30, 313},
            {104,  30, 314},
            {134,  40, 402},
            {134,  40, 403},
            {134,  40, 404},
            {174,  18, 522},
            {174,  18, 523},
            {174,  18, 524},
            { -1,   0,   0}
        },
        {
            /* pure short, 8kHz */
            {  0,   8,   0},   
            {  0,   8,   1},   
            {  0,   8,   2},   
            {  8,   8,  24},
            {  8,   8,  25},
            {  8,   8,  26},
            { 16,   8,  48},
            { 16,   8,  49},
            { 16,   8,  50},
            { 24,  12,  72}, 
            { 24,  12,  73}, 
            { 24,  12,  74}, 
            { 36,  16, 108},
            { 36,  16, 109},
            { 36,  16, 110},
            { 52,  20, 156},
            { 52,  20, 157},
            { 52,  20, 158},
            { 72,  24, 216},
            { 72,  24, 217},
            { 72,  24, 218},
            { 96,  28, 288},
            { 96,  28, 289},
            { 96,  28, 290},
            {124,  36, 372}, 
            {124,  36, 373}, 
            {124,  36, 374}, 
            {160,   2, 480}, 
            {160,   2, 481}, 
            {160,   2, 482}, 
            {162,   2, 486},
            {162,   2, 487},
            {162,   2, 488},
            {164,   2, 492},
            {164,   2, 493},
            {164,   2, 494},
            {166,  26, 498},
            {166,  26, 499},
            {166,  26, 500},
            { -1,   0,   0}
        }
    }
};

/* scalefactor pretab */
const int FLO_LayerIII_Pretab[22] = 
{0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,3,2,0};

const int FLO_LayerIII_NullPretab[22] = 
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

/* tables for antialias butterflies */
const FLO_Float FLO_CsTable[8] = {
    FLO_FC4(0.8574929257125443),
    FLO_FC4(0.8817419973177052),
    FLO_FC4(0.9496286491027328),
    FLO_FC4(0.9833145924917902),
    FLO_FC4(0.9955178160675858),
    FLO_FC4(0.9991605581781475),
    FLO_FC4(0.9998991952444471),
    FLO_FC4(0.9999931550702803)
};

const FLO_Float FLO_CaTable[8] = {
    FLO_FC4(-0.5144957554275266),
    FLO_FC4(-0.4717319685649723),
    FLO_FC4(-0.3133774542039018),
    FLO_FC4(-0.1819131996109812),
    FLO_FC4(-0.0945741925264207),
    FLO_FC4(-0.0409655828853041),
    FLO_FC4(-0.0141985685724712),
    FLO_FC4(-0.0036999746737600)
};

/* windowing tables */

/* blocks of type 0 (idct factor added) */
static const FLO_Float FLO_LayerIII_ImdctWindow_0_Even[36] = {
     FLO_FC5(0.032282430143),  FLO_FC5(0.107206358682),  FLO_FC5(0.201414267362),
     FLO_FC5(0.325616353666),  FLO_FC5(0.500000000000),  FLO_FC5(0.767774705370),
     FLO_FC5(1.241222894850),  FLO_FC5(2.331951230070),  FLO_FC5(7.744150576410),
    -FLO_FC5(8.451257357590), -FLO_FC5(3.039058011260), -FLO_FC5(1.948329676040),
    -FLO_FC5(1.474881486560), -FLO_FC5(1.207106781190), -FLO_FC5(1.032723134850),
    -FLO_FC5(0.908521048549), -FLO_FC5(0.814313139868), -FLO_FC5(0.739389211330),
    -FLO_FC5(0.677525384073), -FLO_FC5(0.624844448887), -FLO_FC5(0.578791741348),
    -FLO_FC5(0.537601636347), -FLO_FC5(0.500000000000), -FLO_FC5(0.465028346451),
    -FLO_FC5(0.431934290247), -FLO_FC5(0.400099577495), -FLO_FC5(0.368989864995),
    -FLO_FC5(0.338116916191), -FLO_FC5(0.307007203691), -FLO_FC5(0.275172490939),
    -FLO_FC5(0.242078434735), -FLO_FC5(0.207106781187), -FLO_FC5(0.169505144840),
    -FLO_FC5(0.128315039839), -FLO_FC5(0.082262332299), -FLO_FC5(0.029581397113)
};

/* same as above, with odd coefficients negated */
static const FLO_Float FLO_LayerIII_ImdctWindow_0_Odd[36] = {
     FLO_FC5(0.032282430143), -FLO_FC5(0.107206358682),  FLO_FC5(0.201414267362),
    -FLO_FC5(0.325616353666),  FLO_FC5(0.500000000000), -FLO_FC5(0.767774705370),
     FLO_FC5(1.241222894850), -FLO_FC5(2.331951230070),  FLO_FC5(7.744150576410),
     FLO_FC5(8.451257357590), -FLO_FC5(3.039058011260),  FLO_FC5(1.948329676040),
    -FLO_FC5(1.474881486560),  FLO_FC5(1.207106781190), -FLO_FC5(1.032723134850),
     FLO_FC5(0.908521048549), -FLO_FC5(0.814313139868),  FLO_FC5(0.739389211330),
    -FLO_FC5(0.677525384073),  FLO_FC5(0.624844448887), -FLO_FC5(0.578791741348),
     FLO_FC5(0.537601636347), -FLO_FC5(0.500000000000),  FLO_FC5(0.465028346451),
    -FLO_FC5(0.431934290247),  FLO_FC5(0.400099577495), -FLO_FC5(0.368989864995),
     FLO_FC5(0.338116916191), -FLO_FC5(0.307007203691),  FLO_FC5(0.275172490939),
    -FLO_FC5(0.242078434735),  FLO_FC5(0.207106781187), -FLO_FC5(0.169505144840),
     FLO_FC5(0.128315039839), -FLO_FC5(0.082262332299),  FLO_FC5(0.029581397113)
};

/* blocks of type 1 (idct factor added) */
static const FLO_Float FLO_LayerIII_ImdctWindow_1_Even[36] = {
    FLO_FC5(0.032282430143),  FLO_FC5(0.107206358682),  FLO_FC5(0.201414267362),
    FLO_FC5(0.325616353666),  FLO_FC5(0.500000000000),  FLO_FC5(0.767774705370),
    FLO_FC5(1.241222894850),  FLO_FC5(2.331951230070),  FLO_FC5(7.744150576410),
   -FLO_FC5(8.451257357590), -FLO_FC5(3.039058011260), -FLO_FC5(1.948329676040),
   -FLO_FC5(1.474881486560), -FLO_FC5(1.207106781190), -FLO_FC5(1.032723134850),
   -FLO_FC5(0.908521048549), -FLO_FC5(0.814313139868), -FLO_FC5(0.739389211330),
   -FLO_FC5(0.678170852455), -FLO_FC5(0.630236207005), -FLO_FC5(0.592844523717),
   -FLO_FC5(0.563690973433), -FLO_FC5(0.541196100146), -FLO_FC5(0.524264562570),
   -FLO_FC5(0.507758330539), -FLO_FC5(0.465925826289), -FLO_FC5(0.397054578124),
   -FLO_FC5(0.304670693495), -FLO_FC5(0.192992796309), -FLO_FC5(0.066847652386),
    FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),
    FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000) 
};

/* same as above, with odd coefficients negated */ 
static const FLO_Float FLO_LayerIII_ImdctWindow_1_Odd[36] = {
    FLO_FC5(0.032282430143), -FLO_FC5(0.107206358682),  FLO_FC5(0.201414267362),
   -FLO_FC5(0.325616353666),  FLO_FC5(0.500000000000), -FLO_FC5(0.767774705370),
    FLO_FC5(1.241222894850), -FLO_FC5(2.331951230070),  FLO_FC5(7.744150576410),
    FLO_FC5(8.451257357590), -FLO_FC5(3.039058011260),  FLO_FC5(1.948329676040),
   -FLO_FC5(1.474881486560),  FLO_FC5(1.207106781190), -FLO_FC5(1.032723134850),
    FLO_FC5(0.908521048549), -FLO_FC5(0.814313139868),  FLO_FC5(0.739389211330),
   -FLO_FC5(0.678170852455),  FLO_FC5(0.630236207005), -FLO_FC5(0.592844523717),
    FLO_FC5(0.563690973433), -FLO_FC5(0.541196100146),  FLO_FC5(0.524264562570),
   -FLO_FC5(0.507758330539),  FLO_FC5(0.465925826289), -FLO_FC5(0.397054578124),
    FLO_FC5(0.304670693495), -FLO_FC5(0.192992796309),  FLO_FC5(0.066847652386),
    FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),
    FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000) 
};

/* blocks of type 2 */
static const FLO_Float FLO_LayerIII_ImdctWindow_2_Even[12] =  {
     FLO_FC5(0.107206358682),  FLO_FC5(0.500000000000),  FLO_FC5(2.331951230070),
    -FLO_FC5(3.039058011260), -FLO_FC5(1.207106781190), -FLO_FC5(0.814313139868),
    -FLO_FC5(0.624844448887), -FLO_FC5(0.500000000000), -FLO_FC5(0.400099577495),
    -FLO_FC5(0.307007203691), -FLO_FC5(0.207106781187), -FLO_FC5(0.082262332299)
};

/* same as above, with odd coefficients negated */ 
static const FLO_Float FLO_LayerIII_ImdctWindow_2_Odd[12] =  {
    FLO_FC5(0.107206358682), -FLO_FC5(0.500000000000),  FLO_FC5(2.331951230070),
    FLO_FC5(3.039058011260), -FLO_FC5(1.207106781190),  FLO_FC5(0.814313139868),
   -FLO_FC5(0.624844448887),  FLO_FC5(0.500000000000), -FLO_FC5(0.400099577495),
    FLO_FC5(0.307007203691), -FLO_FC5(0.207106781187),  FLO_FC5(0.082262332299)
};

/* blocks of type 3 (idct factor added) */
static const FLO_Float FLO_LayerIII_ImdctWindow_3_Even[36] = {
    FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),
    FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),
    FLO_FC5(0.301530274068),  FLO_FC5(1.465925826290),  FLO_FC5(6.978106133290),
   -FLO_FC5(9.094044967280), -FLO_FC5(3.539058011260), -FLO_FC5(2.290349819370),
   -FLO_FC5(1.662754761710), -FLO_FC5(1.306562964880), -FLO_FC5(1.082840285100),
   -FLO_FC5(0.930579498352), -FLO_FC5(0.821339815852), -FLO_FC5(0.740093616461),
   -FLO_FC5(0.677525384073), -FLO_FC5(0.624844448887), -FLO_FC5(0.578791741348),
   -FLO_FC5(0.537601636347), -FLO_FC5(0.500000000000), -FLO_FC5(0.465028346451),
   -FLO_FC5(0.431934290247), -FLO_FC5(0.400099577495), -FLO_FC5(0.368989864995),
   -FLO_FC5(0.338116916191), -FLO_FC5(0.307007203691), -FLO_FC5(0.275172490939),
   -FLO_FC5(0.242078434735), -FLO_FC5(0.207106781187), -FLO_FC5(0.169505144840),
   -FLO_FC5(0.128315039839), -FLO_FC5(0.082262332299), -FLO_FC5(0.029581397113)
};

/* same as above, with odd coefficients negated */ 
static const FLO_Float FLO_LayerIII_ImdctWindow_3_Odd[36] = {
    FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000),
   -FLO_FC5(0.000000000000),  FLO_FC5(0.000000000000), -FLO_FC5(0.000000000000),
    FLO_FC5(0.301530274068), -FLO_FC5(1.465925826290),  FLO_FC5(6.978106133290),
    FLO_FC5(9.094044967280), -FLO_FC5(3.539058011260),  FLO_FC5(2.290349819370),
   -FLO_FC5(1.662754761710),  FLO_FC5(1.306562964880), -FLO_FC5(1.082840285100),
    FLO_FC5(0.930579498352), -FLO_FC5(0.821339815852),  FLO_FC5(0.740093616461),
   -FLO_FC5(0.677525384073),  FLO_FC5(0.624844448887), -FLO_FC5(0.578791741348),
    FLO_FC5(0.537601636347), -FLO_FC5(0.500000000000),  FLO_FC5(0.465028346451),
   -FLO_FC5(0.431934290247),  FLO_FC5(0.400099577495), -FLO_FC5(0.368989864995),
    FLO_FC5(0.338116916191), -FLO_FC5(0.307007203691),  FLO_FC5(0.275172490939),
   -FLO_FC5(0.242078434735),  FLO_FC5(0.207106781187), -FLO_FC5(0.169505144840),
    FLO_FC5(0.128315039839), -FLO_FC5(0.082262332299),  FLO_FC5(0.029581397113)
};

const FLO_Float * const FLO_LayerIII_ImdctWindows_Even[4] = {
    FLO_LayerIII_ImdctWindow_0_Even,
    FLO_LayerIII_ImdctWindow_1_Even,
    FLO_LayerIII_ImdctWindow_2_Even,
    FLO_LayerIII_ImdctWindow_3_Even
};

const FLO_Float * const FLO_LayerIII_ImdctWindows_Odd[4] = {
    FLO_LayerIII_ImdctWindow_0_Odd,
    FLO_LayerIII_ImdctWindow_1_Odd,
    FLO_LayerIII_ImdctWindow_2_Odd,
    FLO_LayerIII_ImdctWindow_3_Odd
};

const int FLO_LayerIII_ScalefactorPartitions[2][3][3][4] = {
    /* normal blocks */
    { 
        /* long blocks */
        {
            {  6,  5,  5,  5}, {  6,  5,  7,  3}, { 11, 10,  0,  0}
        },
        /* short blocks */
        {
            {  9,  9,  9,  9}, {  9,  9, 12,  6}, { 18, 18,  0,  0}
        },
        /* mixed blocks */
        { 
            {  6,  9,  9,  9}, {  6,  9, 12,  6}, { 15, 18,  0,  0}
        }
    }, 
    /* intensity blocks of right channel */
    {
        /* long blocks */
        {
            {  7,  7,  7,  0}, {  6,  6,  6,  3}, {  8,  8,  5,  0}
        },
        /* short blocks */
        {
            { 12, 12, 12,  0}, { 12,  9,  9,  6}, { 15, 12,  9,  0}
        },
        /* mixed blocks */
        {
            {  6, 15, 12,  0}, {  6, 12,  9,  6}, {  6, 18,  9,  0}
        }
    }
}; 

/* scalefactor lengths for mpeg 2 */
const FLO_LayerIII_ScalefactorLengthInfo FLO_LayerIII_ScalefactorInfo_0[512] = {
    {{0,0,0,0},0,0}, {{0,0,0,1},0,0}, {{0,0,0,2},0,0}, {{0,0,0,3},0,0}, 
    {{0,0,1,0},0,0}, {{0,0,1,1},0,0}, {{0,0,1,2},0,0}, {{0,0,1,3},0,0}, 
    {{0,0,2,0},0,0}, {{0,0,2,1},0,0}, {{0,0,2,2},0,0}, {{0,0,2,3},0,0}, 
    {{0,0,3,0},0,0}, {{0,0,3,1},0,0}, {{0,0,3,2},0,0}, {{0,0,3,3},0,0}, 
    {{0,1,0,0},0,0}, {{0,1,0,1},0,0}, {{0,1,0,2},0,0}, {{0,1,0,3},0,0}, 
    {{0,1,1,0},0,0}, {{0,1,1,1},0,0}, {{0,1,1,2},0,0}, {{0,1,1,3},0,0}, 
    {{0,1,2,0},0,0}, {{0,1,2,1},0,0}, {{0,1,2,2},0,0}, {{0,1,2,3},0,0}, 
    {{0,1,3,0},0,0}, {{0,1,3,1},0,0}, {{0,1,3,2},0,0}, {{0,1,3,3},0,0}, 
    {{0,2,0,0},0,0}, {{0,2,0,1},0,0}, {{0,2,0,2},0,0}, {{0,2,0,3},0,0}, 
    {{0,2,1,0},0,0}, {{0,2,1,1},0,0}, {{0,2,1,2},0,0}, {{0,2,1,3},0,0}, 
    {{0,2,2,0},0,0}, {{0,2,2,1},0,0}, {{0,2,2,2},0,0}, {{0,2,2,3},0,0}, 
    {{0,2,3,0},0,0}, {{0,2,3,1},0,0}, {{0,2,3,2},0,0}, {{0,2,3,3},0,0}, 
    {{0,3,0,0},0,0}, {{0,3,0,1},0,0}, {{0,3,0,2},0,0}, {{0,3,0,3},0,0}, 
    {{0,3,1,0},0,0}, {{0,3,1,1},0,0}, {{0,3,1,2},0,0}, {{0,3,1,3},0,0}, 
    {{0,3,2,0},0,0}, {{0,3,2,1},0,0}, {{0,3,2,2},0,0}, {{0,3,2,3},0,0}, 
    {{0,3,3,0},0,0}, {{0,3,3,1},0,0}, {{0,3,3,2},0,0}, {{0,3,3,3},0,0}, 
    {{0,4,0,0},0,0}, {{0,4,0,1},0,0}, {{0,4,0,2},0,0}, {{0,4,0,3},0,0}, 
    {{0,4,1,0},0,0}, {{0,4,1,1},0,0}, {{0,4,1,2},0,0}, {{0,4,1,3},0,0}, 
    {{0,4,2,0},0,0}, {{0,4,2,1},0,0}, {{0,4,2,2},0,0}, {{0,4,2,3},0,0}, 
    {{0,4,3,0},0,0}, {{0,4,3,1},0,0}, {{0,4,3,2},0,0}, {{0,4,3,3},0,0}, 
    {{1,0,0,0},0,0}, {{1,0,0,1},0,0}, {{1,0,0,2},0,0}, {{1,0,0,3},0,0}, 
    {{1,0,1,0},0,0}, {{1,0,1,1},0,0}, {{1,0,1,2},0,0}, {{1,0,1,3},0,0}, 
    {{1,0,2,0},0,0}, {{1,0,2,1},0,0}, {{1,0,2,2},0,0}, {{1,0,2,3},0,0}, 
    {{1,0,3,0},0,0}, {{1,0,3,1},0,0}, {{1,0,3,2},0,0}, {{1,0,3,3},0,0}, 
    {{1,1,0,0},0,0}, {{1,1,0,1},0,0}, {{1,1,0,2},0,0}, {{1,1,0,3},0,0}, 
    {{1,1,1,0},0,0}, {{1,1,1,1},0,0}, {{1,1,1,2},0,0}, {{1,1,1,3},0,0}, 
    {{1,1,2,0},0,0}, {{1,1,2,1},0,0}, {{1,1,2,2},0,0}, {{1,1,2,3},0,0}, 
    {{1,1,3,0},0,0}, {{1,1,3,1},0,0}, {{1,1,3,2},0,0}, {{1,1,3,3},0,0}, 
    {{1,2,0,0},0,0}, {{1,2,0,1},0,0}, {{1,2,0,2},0,0}, {{1,2,0,3},0,0}, 
    {{1,2,1,0},0,0}, {{1,2,1,1},0,0}, {{1,2,1,2},0,0}, {{1,2,1,3},0,0}, 
    {{1,2,2,0},0,0}, {{1,2,2,1},0,0}, {{1,2,2,2},0,0}, {{1,2,2,3},0,0}, 
    {{1,2,3,0},0,0}, {{1,2,3,1},0,0}, {{1,2,3,2},0,0}, {{1,2,3,3},0,0}, 
    {{1,3,0,0},0,0}, {{1,3,0,1},0,0}, {{1,3,0,2},0,0}, {{1,3,0,3},0,0}, 
    {{1,3,1,0},0,0}, {{1,3,1,1},0,0}, {{1,3,1,2},0,0}, {{1,3,1,3},0,0}, 
    {{1,3,2,0},0,0}, {{1,3,2,1},0,0}, {{1,3,2,2},0,0}, {{1,3,2,3},0,0}, 
    {{1,3,3,0},0,0}, {{1,3,3,1},0,0}, {{1,3,3,2},0,0}, {{1,3,3,3},0,0}, 
    {{1,4,0,0},0,0}, {{1,4,0,1},0,0}, {{1,4,0,2},0,0}, {{1,4,0,3},0,0}, 
    {{1,4,1,0},0,0}, {{1,4,1,1},0,0}, {{1,4,1,2},0,0}, {{1,4,1,3},0,0}, 
    {{1,4,2,0},0,0}, {{1,4,2,1},0,0}, {{1,4,2,2},0,0}, {{1,4,2,3},0,0}, 
    {{1,4,3,0},0,0}, {{1,4,3,1},0,0}, {{1,4,3,2},0,0}, {{1,4,3,3},0,0}, 
    {{2,0,0,0},0,0}, {{2,0,0,1},0,0}, {{2,0,0,2},0,0}, {{2,0,0,3},0,0}, 
    {{2,0,1,0},0,0}, {{2,0,1,1},0,0}, {{2,0,1,2},0,0}, {{2,0,1,3},0,0}, 
    {{2,0,2,0},0,0}, {{2,0,2,1},0,0}, {{2,0,2,2},0,0}, {{2,0,2,3},0,0}, 
    {{2,0,3,0},0,0}, {{2,0,3,1},0,0}, {{2,0,3,2},0,0}, {{2,0,3,3},0,0}, 
    {{2,1,0,0},0,0}, {{2,1,0,1},0,0}, {{2,1,0,2},0,0}, {{2,1,0,3},0,0}, 
    {{2,1,1,0},0,0}, {{2,1,1,1},0,0}, {{2,1,1,2},0,0}, {{2,1,1,3},0,0}, 
    {{2,1,2,0},0,0}, {{2,1,2,1},0,0}, {{2,1,2,2},0,0}, {{2,1,2,3},0,0}, 
    {{2,1,3,0},0,0}, {{2,1,3,1},0,0}, {{2,1,3,2},0,0}, {{2,1,3,3},0,0}, 
    {{2,2,0,0},0,0}, {{2,2,0,1},0,0}, {{2,2,0,2},0,0}, {{2,2,0,3},0,0}, 
    {{2,2,1,0},0,0}, {{2,2,1,1},0,0}, {{2,2,1,2},0,0}, {{2,2,1,3},0,0}, 
    {{2,2,2,0},0,0}, {{2,2,2,1},0,0}, {{2,2,2,2},0,0}, {{2,2,2,3},0,0}, 
    {{2,2,3,0},0,0}, {{2,2,3,1},0,0}, {{2,2,3,2},0,0}, {{2,2,3,3},0,0}, 
    {{2,3,0,0},0,0}, {{2,3,0,1},0,0}, {{2,3,0,2},0,0}, {{2,3,0,3},0,0}, 
    {{2,3,1,0},0,0}, {{2,3,1,1},0,0}, {{2,3,1,2},0,0}, {{2,3,1,3},0,0}, 
    {{2,3,2,0},0,0}, {{2,3,2,1},0,0}, {{2,3,2,2},0,0}, {{2,3,2,3},0,0}, 
    {{2,3,3,0},0,0}, {{2,3,3,1},0,0}, {{2,3,3,2},0,0}, {{2,3,3,3},0,0}, 
    {{2,4,0,0},0,0}, {{2,4,0,1},0,0}, {{2,4,0,2},0,0}, {{2,4,0,3},0,0}, 
    {{2,4,1,0},0,0}, {{2,4,1,1},0,0}, {{2,4,1,2},0,0}, {{2,4,1,3},0,0}, 
    {{2,4,2,0},0,0}, {{2,4,2,1},0,0}, {{2,4,2,2},0,0}, {{2,4,2,3},0,0}, 
    {{2,4,3,0},0,0}, {{2,4,3,1},0,0}, {{2,4,3,2},0,0}, {{2,4,3,3},0,0}, 
    {{3,0,0,0},0,0}, {{3,0,0,1},0,0}, {{3,0,0,2},0,0}, {{3,0,0,3},0,0}, 
    {{3,0,1,0},0,0}, {{3,0,1,1},0,0}, {{3,0,1,2},0,0}, {{3,0,1,3},0,0}, 
    {{3,0,2,0},0,0}, {{3,0,2,1},0,0}, {{3,0,2,2},0,0}, {{3,0,2,3},0,0}, 
    {{3,0,3,0},0,0}, {{3,0,3,1},0,0}, {{3,0,3,2},0,0}, {{3,0,3,3},0,0}, 
    {{3,1,0,0},0,0}, {{3,1,0,1},0,0}, {{3,1,0,2},0,0}, {{3,1,0,3},0,0}, 
    {{3,1,1,0},0,0}, {{3,1,1,1},0,0}, {{3,1,1,2},0,0}, {{3,1,1,3},0,0}, 
    {{3,1,2,0},0,0}, {{3,1,2,1},0,0}, {{3,1,2,2},0,0}, {{3,1,2,3},0,0}, 
    {{3,1,3,0},0,0}, {{3,1,3,1},0,0}, {{3,1,3,2},0,0}, {{3,1,3,3},0,0}, 
    {{3,2,0,0},0,0}, {{3,2,0,1},0,0}, {{3,2,0,2},0,0}, {{3,2,0,3},0,0}, 
    {{3,2,1,0},0,0}, {{3,2,1,1},0,0}, {{3,2,1,2},0,0}, {{3,2,1,3},0,0}, 
    {{3,2,2,0},0,0}, {{3,2,2,1},0,0}, {{3,2,2,2},0,0}, {{3,2,2,3},0,0}, 
    {{3,2,3,0},0,0}, {{3,2,3,1},0,0}, {{3,2,3,2},0,0}, {{3,2,3,3},0,0}, 
    {{3,3,0,0},0,0}, {{3,3,0,1},0,0}, {{3,3,0,2},0,0}, {{3,3,0,3},0,0}, 
    {{3,3,1,0},0,0}, {{3,3,1,1},0,0}, {{3,3,1,2},0,0}, {{3,3,1,3},0,0}, 
    {{3,3,2,0},0,0}, {{3,3,2,1},0,0}, {{3,3,2,2},0,0}, {{3,3,2,3},0,0}, 
    {{3,3,3,0},0,0}, {{3,3,3,1},0,0}, {{3,3,3,2},0,0}, {{3,3,3,3},0,0}, 
    {{3,4,0,0},0,0}, {{3,4,0,1},0,0}, {{3,4,0,2},0,0}, {{3,4,0,3},0,0}, 
    {{3,4,1,0},0,0}, {{3,4,1,1},0,0}, {{3,4,1,2},0,0}, {{3,4,1,3},0,0}, 
    {{3,4,2,0},0,0}, {{3,4,2,1},0,0}, {{3,4,2,2},0,0}, {{3,4,2,3},0,0}, 
    {{3,4,3,0},0,0}, {{3,4,3,1},0,0}, {{3,4,3,2},0,0}, {{3,4,3,3},0,0}, 
    {{4,0,0,0},0,0}, {{4,0,0,1},0,0}, {{4,0,0,2},0,0}, {{4,0,0,3},0,0}, 
    {{4,0,1,0},0,0}, {{4,0,1,1},0,0}, {{4,0,1,2},0,0}, {{4,0,1,3},0,0}, 
    {{4,0,2,0},0,0}, {{4,0,2,1},0,0}, {{4,0,2,2},0,0}, {{4,0,2,3},0,0}, 
    {{4,0,3,0},0,0}, {{4,0,3,1},0,0}, {{4,0,3,2},0,0}, {{4,0,3,3},0,0}, 
    {{4,1,0,0},0,0}, {{4,1,0,1},0,0}, {{4,1,0,2},0,0}, {{4,1,0,3},0,0}, 
    {{4,1,1,0},0,0}, {{4,1,1,1},0,0}, {{4,1,1,2},0,0}, {{4,1,1,3},0,0}, 
    {{4,1,2,0},0,0}, {{4,1,2,1},0,0}, {{4,1,2,2},0,0}, {{4,1,2,3},0,0}, 
    {{4,1,3,0},0,0}, {{4,1,3,1},0,0}, {{4,1,3,2},0,0}, {{4,1,3,3},0,0}, 
    {{4,2,0,0},0,0}, {{4,2,0,1},0,0}, {{4,2,0,2},0,0}, {{4,2,0,3},0,0}, 
    {{4,2,1,0},0,0}, {{4,2,1,1},0,0}, {{4,2,1,2},0,0}, {{4,2,1,3},0,0}, 
    {{4,2,2,0},0,0}, {{4,2,2,1},0,0}, {{4,2,2,2},0,0}, {{4,2,2,3},0,0}, 
    {{4,2,3,0},0,0}, {{4,2,3,1},0,0}, {{4,2,3,2},0,0}, {{4,2,3,3},0,0}, 
    {{4,3,0,0},0,0}, {{4,3,0,1},0,0}, {{4,3,0,2},0,0}, {{4,3,0,3},0,0}, 
    {{4,3,1,0},0,0}, {{4,3,1,1},0,0}, {{4,3,1,2},0,0}, {{4,3,1,3},0,0}, 
    {{4,3,2,0},0,0}, {{4,3,2,1},0,0}, {{4,3,2,2},0,0}, {{4,3,2,3},0,0}, 
    {{4,3,3,0},0,0}, {{4,3,3,1},0,0}, {{4,3,3,2},0,0}, {{4,3,3,3},0,0}, 
    {{4,4,0,0},0,0}, {{4,4,0,1},0,0}, {{4,4,0,2},0,0}, {{4,4,0,3},0,0}, 
    {{4,4,1,0},0,0}, {{4,4,1,1},0,0}, {{4,4,1,2},0,0}, {{4,4,1,3},0,0}, 
    {{4,4,2,0},0,0}, {{4,4,2,1},0,0}, {{4,4,2,2},0,0}, {{4,4,2,3},0,0}, 
    {{4,4,3,0},0,0}, {{4,4,3,1},0,0}, {{4,4,3,2},0,0}, {{4,4,3,3},0,0}, 
    {{0,0,0,0},0,1}, {{0,0,1,0},0,1}, {{0,0,2,0},0,1}, {{0,0,3,0},0,1}, 
    {{0,1,0,0},0,1}, {{0,1,1,0},0,1}, {{0,1,2,0},0,1}, {{0,1,3,0},0,1}, 
    {{0,2,0,0},0,1}, {{0,2,1,0},0,1}, {{0,2,2,0},0,1}, {{0,2,3,0},0,1}, 
    {{0,3,0,0},0,1}, {{0,3,1,0},0,1}, {{0,3,2,0},0,1}, {{0,3,3,0},0,1}, 
    {{0,4,0,0},0,1}, {{0,4,1,0},0,1}, {{0,4,2,0},0,1}, {{0,4,3,0},0,1}, 
    {{1,0,0,0},0,1}, {{1,0,1,0},0,1}, {{1,0,2,0},0,1}, {{1,0,3,0},0,1}, 
    {{1,1,0,0},0,1}, {{1,1,1,0},0,1}, {{1,1,2,0},0,1}, {{1,1,3,0},0,1}, 
    {{1,2,0,0},0,1}, {{1,2,1,0},0,1}, {{1,2,2,0},0,1}, {{1,2,3,0},0,1}, 
    {{1,3,0,0},0,1}, {{1,3,1,0},0,1}, {{1,3,2,0},0,1}, {{1,3,3,0},0,1}, 
    {{1,4,0,0},0,1}, {{1,4,1,0},0,1}, {{1,4,2,0},0,1}, {{1,4,3,0},0,1}, 
    {{2,0,0,0},0,1}, {{2,0,1,0},0,1}, {{2,0,2,0},0,1}, {{2,0,3,0},0,1}, 
    {{2,1,0,0},0,1}, {{2,1,1,0},0,1}, {{2,1,2,0},0,1}, {{2,1,3,0},0,1}, 
    {{2,2,0,0},0,1}, {{2,2,1,0},0,1}, {{2,2,2,0},0,1}, {{2,2,3,0},0,1}, 
    {{2,3,0,0},0,1}, {{2,3,1,0},0,1}, {{2,3,2,0},0,1}, {{2,3,3,0},0,1}, 
    {{2,4,0,0},0,1}, {{2,4,1,0},0,1}, {{2,4,2,0},0,1}, {{2,4,3,0},0,1}, 
    {{3,0,0,0},0,1}, {{3,0,1,0},0,1}, {{3,0,2,0},0,1}, {{3,0,3,0},0,1}, 
    {{3,1,0,0},0,1}, {{3,1,1,0},0,1}, {{3,1,2,0},0,1}, {{3,1,3,0},0,1}, 
    {{3,2,0,0},0,1}, {{3,2,1,0},0,1}, {{3,2,2,0},0,1}, {{3,2,3,0},0,1}, 
    {{3,3,0,0},0,1}, {{3,3,1,0},0,1}, {{3,3,2,0},0,1}, {{3,3,3,0},0,1}, 
    {{3,4,0,0},0,1}, {{3,4,1,0},0,1}, {{3,4,2,0},0,1}, {{3,4,3,0},0,1}, 
    {{4,0,0,0},0,1}, {{4,0,1,0},0,1}, {{4,0,2,0},0,1}, {{4,0,3,0},0,1}, 
    {{4,1,0,0},0,1}, {{4,1,1,0},0,1}, {{4,1,2,0},0,1}, {{4,1,3,0},0,1}, 
    {{4,2,0,0},0,1}, {{4,2,1,0},0,1}, {{4,2,2,0},0,1}, {{4,2,3,0},0,1}, 
    {{4,3,0,0},0,1}, {{4,3,1,0},0,1}, {{4,3,2,0},0,1}, {{4,3,3,0},0,1}, 
    {{4,4,0,0},0,1}, {{4,4,1,0},0,1}, {{4,4,2,0},0,1}, {{4,4,3,0},0,1}, 
    {{0,0,0,0},1,2}, {{0,1,0,0},1,2}, {{0,2,0,0},1,2}, {{1,0,0,0},1,2}, 
    {{1,1,0,0},1,2}, {{1,2,0,0},1,2}, {{2,0,0,0},1,2}, {{2,1,0,0},1,2}, 
    {{2,2,0,0},1,2}, {{3,0,0,0},1,2}, {{3,1,0,0},1,2}, {{3,2,0,0},1,2}
};

const FLO_LayerIII_ScalefactorLengthInfo FLO_LayerIII_ScalefactorInfo_1[256] = {
    {{0,0,0,0},0,0}, {{0,0,1,0},0,0}, {{0,0,2,0},0,0}, {{0,0,3,0},0,0}, 
    {{0,0,4,0},0,0}, {{0,0,5,0},0,0}, {{0,1,0,0},0,0}, {{0,1,1,0},0,0}, 
    {{0,1,2,0},0,0}, {{0,1,3,0},0,0}, {{0,1,4,0},0,0}, {{0,1,5,0},0,0}, 
    {{0,2,0,0},0,0}, {{0,2,1,0},0,0}, {{0,2,2,0},0,0}, {{0,2,3,0},0,0}, 
    {{0,2,4,0},0,0}, {{0,2,5,0},0,0}, {{0,3,0,0},0,0}, {{0,3,1,0},0,0}, 
    {{0,3,2,0},0,0}, {{0,3,3,0},0,0}, {{0,3,4,0},0,0}, {{0,3,5,0},0,0}, 
    {{0,4,0,0},0,0}, {{0,4,1,0},0,0}, {{0,4,2,0},0,0}, {{0,4,3,0},0,0}, 
    {{0,4,4,0},0,0}, {{0,4,5,0},0,0}, {{0,5,0,0},0,0}, {{0,5,1,0},0,0}, 
    {{0,5,2,0},0,0}, {{0,5,3,0},0,0}, {{0,5,4,0},0,0}, {{0,5,5,0},0,0}, 
    {{1,0,0,0},0,0}, {{1,0,1,0},0,0}, {{1,0,2,0},0,0}, {{1,0,3,0},0,0}, 
    {{1,0,4,0},0,0}, {{1,0,5,0},0,0}, {{1,1,0,0},0,0}, {{1,1,1,0},0,0}, 
    {{1,1,2,0},0,0}, {{1,1,3,0},0,0}, {{1,1,4,0},0,0}, {{1,1,5,0},0,0}, 
    {{1,2,0,0},0,0}, {{1,2,1,0},0,0}, {{1,2,2,0},0,0}, {{1,2,3,0},0,0}, 
    {{1,2,4,0},0,0}, {{1,2,5,0},0,0}, {{1,3,0,0},0,0}, {{1,3,1,0},0,0}, 
    {{1,3,2,0},0,0}, {{1,3,3,0},0,0}, {{1,3,4,0},0,0}, {{1,3,5,0},0,0}, 
    {{1,4,0,0},0,0}, {{1,4,1,0},0,0}, {{1,4,2,0},0,0}, {{1,4,3,0},0,0}, 
    {{1,4,4,0},0,0}, {{1,4,5,0},0,0}, {{1,5,0,0},0,0}, {{1,5,1,0},0,0}, 
    {{1,5,2,0},0,0}, {{1,5,3,0},0,0}, {{1,5,4,0},0,0}, {{1,5,5,0},0,0}, 
    {{2,0,0,0},0,0}, {{2,0,1,0},0,0}, {{2,0,2,0},0,0}, {{2,0,3,0},0,0}, 
    {{2,0,4,0},0,0}, {{2,0,5,0},0,0}, {{2,1,0,0},0,0}, {{2,1,1,0},0,0}, 
    {{2,1,2,0},0,0}, {{2,1,3,0},0,0}, {{2,1,4,0},0,0}, {{2,1,5,0},0,0}, 
    {{2,2,0,0},0,0}, {{2,2,1,0},0,0}, {{2,2,2,0},0,0}, {{2,2,3,0},0,0}, 
    {{2,2,4,0},0,0}, {{2,2,5,0},0,0}, {{2,3,0,0},0,0}, {{2,3,1,0},0,0}, 
    {{2,3,2,0},0,0}, {{2,3,3,0},0,0}, {{2,3,4,0},0,0}, {{2,3,5,0},0,0}, 
    {{2,4,0,0},0,0}, {{2,4,1,0},0,0}, {{2,4,2,0},0,0}, {{2,4,3,0},0,0}, 
    {{2,4,4,0},0,0}, {{2,4,5,0},0,0}, {{2,5,0,0},0,0}, {{2,5,1,0},0,0}, 
    {{2,5,2,0},0,0}, {{2,5,3,0},0,0}, {{2,5,4,0},0,0}, {{2,5,5,0},0,0}, 
    {{3,0,0,0},0,0}, {{3,0,1,0},0,0}, {{3,0,2,0},0,0}, {{3,0,3,0},0,0}, 
    {{3,0,4,0},0,0}, {{3,0,5,0},0,0}, {{3,1,0,0},0,0}, {{3,1,1,0},0,0}, 
    {{3,1,2,0},0,0}, {{3,1,3,0},0,0}, {{3,1,4,0},0,0}, {{3,1,5,0},0,0}, 
    {{3,2,0,0},0,0}, {{3,2,1,0},0,0}, {{3,2,2,0},0,0}, {{3,2,3,0},0,0}, 
    {{3,2,4,0},0,0}, {{3,2,5,0},0,0}, {{3,3,0,0},0,0}, {{3,3,1,0},0,0}, 
    {{3,3,2,0},0,0}, {{3,3,3,0},0,0}, {{3,3,4,0},0,0}, {{3,3,5,0},0,0}, 
    {{3,4,0,0},0,0}, {{3,4,1,0},0,0}, {{3,4,2,0},0,0}, {{3,4,3,0},0,0}, 
    {{3,4,4,0},0,0}, {{3,4,5,0},0,0}, {{3,5,0,0},0,0}, {{3,5,1,0},0,0}, 
    {{3,5,2,0},0,0}, {{3,5,3,0},0,0}, {{3,5,4,0},0,0}, {{3,5,5,0},0,0}, 
    {{4,0,0,0},0,0}, {{4,0,1,0},0,0}, {{4,0,2,0},0,0}, {{4,0,3,0},0,0}, 
    {{4,0,4,0},0,0}, {{4,0,5,0},0,0}, {{4,1,0,0},0,0}, {{4,1,1,0},0,0}, 
    {{4,1,2,0},0,0}, {{4,1,3,0},0,0}, {{4,1,4,0},0,0}, {{4,1,5,0},0,0}, 
    {{4,2,0,0},0,0}, {{4,2,1,0},0,0}, {{4,2,2,0},0,0}, {{4,2,3,0},0,0}, 
    {{4,2,4,0},0,0}, {{4,2,5,0},0,0}, {{4,3,0,0},0,0}, {{4,3,1,0},0,0}, 
    {{4,3,2,0},0,0}, {{4,3,3,0},0,0}, {{4,3,4,0},0,0}, {{4,3,5,0},0,0}, 
    {{4,4,0,0},0,0}, {{4,4,1,0},0,0}, {{4,4,2,0},0,0}, {{4,4,3,0},0,0}, 
    {{4,4,4,0},0,0}, {{4,4,5,0},0,0}, {{4,5,0,0},0,0}, {{4,5,1,0},0,0}, 
    {{4,5,2,0},0,0}, {{4,5,3,0},0,0}, {{4,5,4,0},0,0}, {{4,5,5,0},0,0}, 
    {{0,0,0,0},0,1}, {{0,0,1,0},0,1}, {{0,0,2,0},0,1}, {{0,0,3,0},0,1}, 
    {{0,1,0,0},0,1}, {{0,1,1,0},0,1}, {{0,1,2,0},0,1}, {{0,1,3,0},0,1}, 
    {{0,2,0,0},0,1}, {{0,2,1,0},0,1}, {{0,2,2,0},0,1}, {{0,2,3,0},0,1}, 
    {{0,3,0,0},0,1}, {{0,3,1,0},0,1}, {{0,3,2,0},0,1}, {{0,3,3,0},0,1}, 
    {{1,0,0,0},0,1}, {{1,0,1,0},0,1}, {{1,0,2,0},0,1}, {{1,0,3,0},0,1}, 
    {{1,1,0,0},0,1}, {{1,1,1,0},0,1}, {{1,1,2,0},0,1}, {{1,1,3,0},0,1}, 
    {{1,2,0,0},0,1}, {{1,2,1,0},0,1}, {{1,2,2,0},0,1}, {{1,2,3,0},0,1}, 
    {{1,3,0,0},0,1}, {{1,3,1,0},0,1}, {{1,3,2,0},0,1}, {{1,3,3,0},0,1}, 
    {{2,0,0,0},0,1}, {{2,0,1,0},0,1}, {{2,0,2,0},0,1}, {{2,0,3,0},0,1}, 
    {{2,1,0,0},0,1}, {{2,1,1,0},0,1}, {{2,1,2,0},0,1}, {{2,1,3,0},0,1}, 
    {{2,2,0,0},0,1}, {{2,2,1,0},0,1}, {{2,2,2,0},0,1}, {{2,2,3,0},0,1}, 
    {{2,3,0,0},0,1}, {{2,3,1,0},0,1}, {{2,3,2,0},0,1}, {{2,3,3,0},0,1}, 
    {{3,0,0,0},0,1}, {{3,0,1,0},0,1}, {{3,0,2,0},0,1}, {{3,0,3,0},0,1}, 
    {{3,1,0,0},0,1}, {{3,1,1,0},0,1}, {{3,1,2,0},0,1}, {{3,1,3,0},0,1}, 
    {{3,2,0,0},0,1}, {{3,2,1,0},0,1}, {{3,2,2,0},0,1}, {{3,2,3,0},0,1}, 
    {{3,3,0,0},0,1}, {{3,3,1,0},0,1}, {{3,3,2,0},0,1}, {{3,3,3,0},0,1}, 
    {{0,0,0,0},0,2}, {{0,1,0,0},0,2}, {{0,2,0,0},0,2}, {{1,0,0,0},0,2}, 
    {{1,1,0,0},0,2}, {{1,2,0,0},0,2}, {{2,0,0,0},0,2}, {{2,1,0,0},0,2}, 
    {{2,2,0,0},0,2}, {{3,0,0,0},0,2}, {{3,1,0,0},0,2}, {{3,2,0,0},0,2}, 
};

/* raise 2 to the power 0.25*([i-256]-210) */
static const FLO_Float TwoPower_0_25[512] = {
#ifdef FLO_CONFIG_COMPILER_HAS_STRICT_FLOAT_TO_INT_CONVERSION
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000), 
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000),
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000), 
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000),
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000), 
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000),
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000), 
    FLO_FC8(0.000000000000000), FLO_FC8(0.000000000000000),
#else 
    FLO_FC8(2.89630937574e+03), FLO_FC8(2.43549617153e+03), 
    FLO_FC8(2.04800000000e+03), FLO_FC8(1.72215585844e+03),
    FLO_FC8(1.44815468787e+03), FLO_FC8(1.21774808576e+03), 
    FLO_FC8(1.02400000000e+03), FLO_FC8(8.61077929220e+02),
    FLO_FC8(7.24077343935e+02), FLO_FC8(6.08874042881e+02), 
    FLO_FC8(5.12000000000e+02), FLO_FC8(4.30538964610e+02),
    FLO_FC8(3.62038671968e+02), FLO_FC8(3.04437021441e+02), 
    FLO_FC8(2.56000000000e+02), FLO_FC8(2.15269482305e+02),
#endif
    FLO_FC8(1.81019335984e+02), FLO_FC8(1.52218510720e+02), 
    FLO_FC8(1.28000000000e+02), FLO_FC8(1.07634741152e+02),
    FLO_FC8(9.05096679919e+01), FLO_FC8(7.61092553602e+01), 
    FLO_FC8(6.40000000000e+01), FLO_FC8(5.38173705762e+01),
    FLO_FC8(4.52548339959e+01), FLO_FC8(3.80546276801e+01), 
    FLO_FC8(3.20000000000e+01), FLO_FC8(2.69086852881e+01),
    FLO_FC8(2.26274169980e+01), FLO_FC8(1.90273138400e+01), 
    FLO_FC8(1.60000000000e+01), FLO_FC8(1.34543426441e+01),
    FLO_FC8(1.13137084990e+01), FLO_FC8(9.51365692002e+00), 
    FLO_FC8(8.00000000000e+00), FLO_FC8(6.72717132203e+00),
    FLO_FC8(5.65685424949e+00), FLO_FC8(4.75682846001e+00), 
    FLO_FC8(4.00000000000e+00), FLO_FC8(3.36358566101e+00),
    FLO_FC8(2.82842712475e+00), FLO_FC8(2.37841423001e+00), 
    FLO_FC8(2.00000000000e+00), FLO_FC8(1.68179283051e+00),
    FLO_FC8(1.41421356237e+00), FLO_FC8(1.18920711500e+00), 
    FLO_FC8(1.00000000000e+00), FLO_FC8(8.40896415254e-01),
    FLO_FC8(7.07106781187e-01), FLO_FC8(5.94603557501e-01), 
    FLO_FC8(5.00000000000e-01), FLO_FC8(4.20448207627e-01),
    FLO_FC8(3.53553390593e-01), FLO_FC8(2.97301778751e-01), 
    FLO_FC8(2.50000000000e-01), FLO_FC8(2.10224103813e-01),
    FLO_FC8(1.76776695297e-01), FLO_FC8(1.48650889375e-01), 
    FLO_FC8(1.25000000000e-01), FLO_FC8(1.05112051907e-01),
    FLO_FC8(8.83883476483e-02), FLO_FC8(7.43254446877e-02), 
    FLO_FC8(6.25000000000e-02), FLO_FC8(5.25560259534e-02),
    FLO_FC8(4.41941738242e-02), FLO_FC8(3.71627223438e-02), 
    FLO_FC8(3.12500000000e-02), FLO_FC8(2.62780129767e-02),
    FLO_FC8(2.20970869121e-02), FLO_FC8(1.85813611719e-02), 
    FLO_FC8(1.56250000000e-02), FLO_FC8(1.31390064883e-02),
    FLO_FC8(1.10485434560e-02), FLO_FC8(9.29068058596e-03), 
    FLO_FC8(7.81250000000e-03), FLO_FC8(6.56950324417e-03),
    FLO_FC8(5.52427172802e-03), FLO_FC8(4.64534029298e-03), 
    FLO_FC8(3.90625000000e-03), FLO_FC8(3.28475162208e-03),
    FLO_FC8(2.76213586401e-03), FLO_FC8(2.32267014649e-03), 
    FLO_FC8(1.95312500000e-03), FLO_FC8(1.64237581104e-03),
    FLO_FC8(1.38106793200e-03), FLO_FC8(1.16133507324e-03), 
    FLO_FC8(9.76562500000e-04), FLO_FC8(8.21187905521e-04),
    FLO_FC8(6.90533966002e-04), FLO_FC8(5.80667536622e-04), 
    FLO_FC8(4.88281250000e-04), FLO_FC8(4.10593952761e-04),
    FLO_FC8(3.45266983001e-04), FLO_FC8(2.90333768311e-04), 
    FLO_FC8(2.44140625000e-04), FLO_FC8(2.05296976380e-04),
    FLO_FC8(1.72633491501e-04), FLO_FC8(1.45166884156e-04), 
    FLO_FC8(1.22070312500e-04), FLO_FC8(1.02648488190e-04),
    FLO_FC8(8.63167457503e-05), FLO_FC8(7.25834420778e-05), 
    FLO_FC8(6.10351562500e-05), FLO_FC8(5.13242440951e-05),
    FLO_FC8(4.31583728752e-05), FLO_FC8(3.62917210389e-05), 
    FLO_FC8(3.05175781250e-05), FLO_FC8(2.56621220475e-05),
    FLO_FC8(2.15791864376e-05), FLO_FC8(1.81458605195e-05), 
    FLO_FC8(1.52587890625e-05), FLO_FC8(1.28310610238e-05),
    FLO_FC8(1.07895932188e-05), FLO_FC8(9.07293025973e-06), 
    FLO_FC8(7.62939453125e-06), FLO_FC8(6.41553051188e-06),
    FLO_FC8(5.39479660939e-06), FLO_FC8(4.53646512986e-06), 
    FLO_FC8(3.81469726563e-06), FLO_FC8(3.20776525594e-06),
    FLO_FC8(2.69739830470e-06), FLO_FC8(2.26823256493e-06), 
    FLO_FC8(1.90734863281e-06), FLO_FC8(1.60388262797e-06),
    FLO_FC8(1.34869915235e-06), FLO_FC8(1.13411628247e-06), 
    FLO_FC8(9.53674316406e-07), FLO_FC8(8.01941313986e-07),
    FLO_FC8(6.74349576174e-07), FLO_FC8(5.67058141233e-07), 
    FLO_FC8(4.76837158203e-07), FLO_FC8(4.00970656993e-07),
    FLO_FC8(3.37174788087e-07), FLO_FC8(2.83529070616e-07), 
    FLO_FC8(2.38418579102e-07), FLO_FC8(2.00485328496e-07),
    FLO_FC8(1.68587394044e-07), FLO_FC8(1.41764535308e-07),
    FLO_FC8(1.19209289551e-07), FLO_FC8(1.00242664248e-07),
    FLO_FC8(8.42936970218e-08), FLO_FC8(7.08822676541e-08), 
    FLO_FC8(5.96046447754e-08), FLO_FC8(5.01213321241e-08),
    FLO_FC8(4.21468485109e-08), FLO_FC8(3.54411338271e-08), 
    FLO_FC8(2.98023223877e-08), FLO_FC8(2.50606660620e-08),
    FLO_FC8(2.10734242554e-08), FLO_FC8(1.77205669135e-08), 
    FLO_FC8(1.49011611938e-08), FLO_FC8(1.25303330310e-08),
    FLO_FC8(1.05367121277e-08), FLO_FC8(8.86028345676e-09), 
    FLO_FC8(7.45058059692e-09), FLO_FC8(6.26516651551e-09),
    FLO_FC8(5.26835606386e-09), FLO_FC8(4.43014172838e-09), 
    FLO_FC8(3.72529029846e-09), FLO_FC8(3.13258325776e-09),
    FLO_FC8(2.63417803193e-09), FLO_FC8(2.21507086419e-09), 
    FLO_FC8(1.86264514923e-09), FLO_FC8(1.56629162888e-09),
    FLO_FC8(1.31708901597e-09), FLO_FC8(1.10753543210e-09), 
    FLO_FC8(9.31322574615e-10), FLO_FC8(7.83145814439e-10),
    FLO_FC8(6.58544507983e-10), FLO_FC8(5.53767716048e-10), 
    FLO_FC8(4.65661287308e-10), FLO_FC8(3.91572907220e-10),
    FLO_FC8(3.29272253991e-10), FLO_FC8(2.76883858024e-10),
    FLO_FC8(2.32830643654e-10), FLO_FC8(1.95786453610e-10),
    FLO_FC8(1.64636126996e-10), FLO_FC8(1.38441929012e-10),
    FLO_FC8(1.16415321827e-10), FLO_FC8(9.78932268049e-11),
    FLO_FC8(8.23180634978e-11), FLO_FC8(6.92209645060e-11), 
    FLO_FC8(5.82076609135e-11), FLO_FC8(4.89466134024e-11),
    FLO_FC8(4.11590317489e-11), FLO_FC8(3.46104822530e-11), 
    FLO_FC8(2.91038304567e-11), FLO_FC8(2.44733067012e-11),
    FLO_FC8(2.05795158745e-11), FLO_FC8(1.73052411265e-11), 
    FLO_FC8(1.45519152284e-11), FLO_FC8(1.22366533506e-11),
    FLO_FC8(1.02897579372e-11), FLO_FC8(8.65262056325e-12), 
    FLO_FC8(7.27595761418e-12), FLO_FC8(6.11832667530e-12),
    FLO_FC8(5.14487896861e-12), FLO_FC8(4.32631028162e-12), 
    FLO_FC8(3.63797880709e-12), FLO_FC8(3.05916333765e-12),
    FLO_FC8(2.57243948431e-12), FLO_FC8(2.16315514081e-12), 
    FLO_FC8(1.81898940355e-12), FLO_FC8(1.52958166883e-12),
    FLO_FC8(1.28621974215e-12), FLO_FC8(1.08157757041e-12), 
    FLO_FC8(9.09494701773e-13), FLO_FC8(7.64790834413e-13),
    FLO_FC8(6.43109871077e-13), FLO_FC8(5.40788785203e-13), 
    FLO_FC8(4.54747350886e-13), FLO_FC8(3.82395417207e-13),
    FLO_FC8(3.21554935538e-13), FLO_FC8(2.70394392601e-13), 
    FLO_FC8(2.27373675443e-13), FLO_FC8(1.91197708603e-13),
    FLO_FC8(1.60777467769e-13), FLO_FC8(1.35197196301e-13), 
    FLO_FC8(1.13686837722e-13), FLO_FC8(9.55988543016e-14),
    FLO_FC8(8.03887338846e-14), FLO_FC8(6.75985981504e-14), 
    FLO_FC8(5.68434188608e-14), FLO_FC8(4.77994271508e-14),
    FLO_FC8(4.01943669423e-14), FLO_FC8(3.37992990752e-14), 
    FLO_FC8(2.84217094304e-14), FLO_FC8(2.38997135754e-14),
    FLO_FC8(2.00971834712e-14), FLO_FC8(1.68996495376e-14), 
    FLO_FC8(1.42108547152e-14), FLO_FC8(1.19498567877e-14),
    FLO_FC8(1.00485917356e-14), FLO_FC8(8.44982476879e-15), 
    FLO_FC8(7.10542735760e-15), FLO_FC8(5.97492839385e-15),
    FLO_FC8(5.02429586779e-15), FLO_FC8(4.22491238440e-15), 
    FLO_FC8(3.55271367880e-15), FLO_FC8(2.98746419693e-15),
    FLO_FC8(2.51214793389e-15), FLO_FC8(2.11245619220e-15), 
    FLO_FC8(1.77635683940e-15), FLO_FC8(1.49373209846e-15),
    FLO_FC8(1.25607396695e-15), FLO_FC8(1.05622809610e-15), 
    FLO_FC8(8.88178419700e-16), FLO_FC8(7.46866049232e-16),
    FLO_FC8(6.28036983474e-16), FLO_FC8(5.28114048050e-16), 
    FLO_FC8(4.44089209850e-16), FLO_FC8(3.73433024616e-16),
    FLO_FC8(3.14018491737e-16), FLO_FC8(2.64057024025e-16), 
    FLO_FC8(2.22044604925e-16), FLO_FC8(1.86716512308e-16),
    FLO_FC8(1.57009245868e-16), FLO_FC8(1.32028512012e-16), 
    FLO_FC8(1.11022302463e-16), FLO_FC8(9.33582561539e-17),
    FLO_FC8(7.85046229342e-17), FLO_FC8(6.60142560062e-17), 
    FLO_FC8(5.55111512313e-17), FLO_FC8(4.66791280770e-17),
    FLO_FC8(3.92523114671e-17), FLO_FC8(3.30071280031e-17), 
    FLO_FC8(2.77555756156e-17), FLO_FC8(2.33395640385e-17),
    FLO_FC8(1.96261557335e-17), FLO_FC8(1.65035640016e-17), 
    FLO_FC8(1.38777878078e-17), FLO_FC8(1.16697820192e-17),
    FLO_FC8(9.81307786677e-18), FLO_FC8(8.25178200078e-18), 
    FLO_FC8(6.93889390391e-18), FLO_FC8(5.83489100962e-18),
    FLO_FC8(4.90653893339e-18), FLO_FC8(4.12589100039e-18), 
    FLO_FC8(3.46944695195e-18), FLO_FC8(2.91744550481e-18),
    FLO_FC8(2.45326946669e-18), FLO_FC8(2.06294550019e-18), 
    FLO_FC8(1.73472347598e-18), FLO_FC8(1.45872275241e-18),
    FLO_FC8(1.22663473335e-18), FLO_FC8(1.03147275010e-18), 
    FLO_FC8(8.67361737988e-19), FLO_FC8(7.29361376203e-19),
    FLO_FC8(6.13317366673e-19), FLO_FC8(5.15736375048e-19), 
    FLO_FC8(4.33680868994e-19), FLO_FC8(3.64680688101e-19),
    FLO_FC8(3.06658683337e-19), FLO_FC8(2.57868187524e-19), 
    FLO_FC8(2.16840434497e-19), FLO_FC8(1.82340344051e-19),
    FLO_FC8(1.53329341668e-19), FLO_FC8(1.28934093762e-19), 
    FLO_FC8(1.08420217249e-19), FLO_FC8(9.11701720253e-20),
    FLO_FC8(7.66646708342e-20), FLO_FC8(6.44670468811e-20), 
    FLO_FC8(5.42101086243e-20), FLO_FC8(4.55850860127e-20),
    FLO_FC8(3.83323354171e-20), FLO_FC8(3.22335234405e-20), 
    FLO_FC8(2.71050543121e-20), FLO_FC8(2.27925430063e-20),
    FLO_FC8(1.91661677085e-20), FLO_FC8(1.61167617203e-20), 
    FLO_FC8(1.35525271561e-20), FLO_FC8(1.13962715032e-20),
    FLO_FC8(9.58308385427e-21), FLO_FC8(8.05838086013e-21), 
    FLO_FC8(6.77626357803e-21), FLO_FC8(5.69813575158e-21),
    FLO_FC8(4.79154192714e-21), FLO_FC8(4.02919043007e-21), 
    FLO_FC8(3.38813178902e-21), FLO_FC8(2.84906787579e-21),
    FLO_FC8(2.39577096357e-21), FLO_FC8(2.01459521503e-21), 
    FLO_FC8(1.69406589451e-21), FLO_FC8(1.42453393790e-21),
    FLO_FC8(1.19788548178e-21), FLO_FC8(1.00729760752e-21), 
    FLO_FC8(8.47032947254e-22), FLO_FC8(7.12266968948e-22),
    FLO_FC8(5.98942740892e-22), FLO_FC8(5.03648803758e-22),
    FLO_FC8(4.23516473627e-22), FLO_FC8(3.56133484474e-22),
    FLO_FC8(2.99471370446e-22), FLO_FC8(2.51824401879e-22), 
    FLO_FC8(2.11758236814e-22), FLO_FC8(1.78066742237e-22),
    FLO_FC8(1.49735685223e-22), FLO_FC8(1.25912200940e-22), 
    FLO_FC8(1.05879118407e-22), FLO_FC8(8.90333711185e-23),
    FLO_FC8(7.48678426115e-23), FLO_FC8(6.29561004698e-23), 
    FLO_FC8(5.29395592034e-23), FLO_FC8(4.45166855592e-23),
    FLO_FC8(3.74339213057e-23), FLO_FC8(3.14780502349e-23), 
    FLO_FC8(2.64697796017e-23), FLO_FC8(2.22583427796e-23),
    FLO_FC8(1.87169606529e-23), FLO_FC8(1.57390251174e-23), 
    FLO_FC8(1.32348898008e-23), FLO_FC8(1.11291713898e-23),
    FLO_FC8(9.35848032644e-24), FLO_FC8(7.86951255872e-24), 
    FLO_FC8(6.61744490042e-24), FLO_FC8(5.56458569491e-24),
    FLO_FC8(4.67924016322e-24), FLO_FC8(3.93475627936e-24), 
    FLO_FC8(3.30872245021e-24), FLO_FC8(2.78229284745e-24),
    FLO_FC8(2.33962008161e-24), FLO_FC8(1.96737813968e-24), 
    FLO_FC8(1.65436122511e-24), FLO_FC8(1.39114642373e-24),
    FLO_FC8(1.16981004080e-24), FLO_FC8(9.83689069840e-25), 
    FLO_FC8(8.27180612553e-25), FLO_FC8(6.95573211863e-25),
    FLO_FC8(5.84905020402e-25), FLO_FC8(4.91844534920e-25), 
    FLO_FC8(4.13590306277e-25), FLO_FC8(3.47786605932e-25),
    FLO_FC8(2.92452510201e-25), FLO_FC8(2.45922267460e-25), 
    FLO_FC8(2.06795153138e-25), FLO_FC8(1.73893302966e-25),
    FLO_FC8(1.46226255101e-25), FLO_FC8(1.22961133730e-25), 
    FLO_FC8(1.03397576569e-25), FLO_FC8(8.69466514829e-26),
    FLO_FC8(7.31131275503e-26), FLO_FC8(6.14805668650e-26), 
    FLO_FC8(5.16987882846e-26), FLO_FC8(4.34733257415e-26),
    FLO_FC8(3.65565637751e-26), FLO_FC8(3.07402834325e-26), 
    FLO_FC8(2.58493941423e-26), FLO_FC8(2.17366628707e-26),
    FLO_FC8(1.82782818876e-26), FLO_FC8(1.53701417163e-26), 
    FLO_FC8(1.29246970711e-26), FLO_FC8(1.08683314354e-26),
    FLO_FC8(9.13914094379e-27), FLO_FC8(7.68507085813e-27), 
    FLO_FC8(6.46234853557e-27), FLO_FC8(5.43416571768e-27),
    FLO_FC8(4.56957047189e-27), FLO_FC8(3.84253542906e-27), 
    FLO_FC8(3.23117426779e-27), FLO_FC8(2.71708285884e-27),
    FLO_FC8(2.28478523595e-27), FLO_FC8(1.92126771453e-27), 
    FLO_FC8(1.61558713389e-27), FLO_FC8(1.35854142942e-27),
    FLO_FC8(1.14239261797e-27), FLO_FC8(9.60633857266e-28), 
    FLO_FC8(8.07793566946e-28), FLO_FC8(6.79270714710e-28),
    FLO_FC8(5.71196308987e-28), FLO_FC8(4.80316928633e-28), 
    FLO_FC8(4.03896783473e-28), FLO_FC8(3.39635357355e-28),
    FLO_FC8(2.85598154493e-28), FLO_FC8(2.40158464316e-28), 
    FLO_FC8(2.01948391737e-28), FLO_FC8(1.69817678678e-28),
    FLO_FC8(1.42799077247e-28), FLO_FC8(1.20079232158e-28), 
    FLO_FC8(1.00974195868e-28), FLO_FC8(8.49088393388e-29),
    FLO_FC8(7.13995386233e-29), FLO_FC8(6.00396160791e-29), 
    FLO_FC8(5.04870979341e-29), FLO_FC8(4.24544196694e-29),
    FLO_FC8(3.56997693117e-29), FLO_FC8(3.00198080396e-29), 
    FLO_FC8(2.52435489671e-29), FLO_FC8(2.12272098347e-29),
    FLO_FC8(1.78498846558e-29), FLO_FC8(1.50099040198e-29), 
    FLO_FC8(1.26217744835e-29), FLO_FC8(1.06136049173e-29),
    FLO_FC8(8.92494232792e-30), FLO_FC8(7.50495200989e-30),
    FLO_FC8(6.31088724177e-30), FLO_FC8(5.30680245867e-30),
    FLO_FC8(4.46247116396e-30), FLO_FC8(3.75247600495e-30), 
    FLO_FC8(3.15544362088e-30), FLO_FC8(2.65340122934e-30),
    FLO_FC8(2.23123558198e-30), FLO_FC8(1.87623800247e-30), 
    FLO_FC8(1.57772181044e-30), FLO_FC8(1.32670061467e-30),
    FLO_FC8(1.11561779099e-30), FLO_FC8(9.38119001236e-31), 
    FLO_FC8(7.88860905221e-31), FLO_FC8(6.63350307334e-31),
    FLO_FC8(5.57808895495e-31), FLO_FC8(4.69059500618e-31), 
    FLO_FC8(3.94430452611e-31), FLO_FC8(3.31675153667e-31),
    FLO_FC8(2.78904447747e-31), FLO_FC8(2.34529750309e-31), 
    FLO_FC8(1.97215226305e-31), FLO_FC8(1.65837576834e-31),
    FLO_FC8(1.39452223874e-31), FLO_FC8(1.17264875155e-31),
    FLO_FC8(9.86076131526e-32), FLO_FC8(8.29187884168e-32),
    FLO_FC8(6.97261119368e-32), FLO_FC8(5.86324375773e-32),
    FLO_FC8(4.93038065763e-32), FLO_FC8(4.14593942084e-32),
    FLO_FC8(3.48630559684e-32), FLO_FC8(2.93162187886e-32), 
    FLO_FC8(2.46519032882e-32), FLO_FC8(2.07296971042e-32),
    FLO_FC8(1.74315279842e-32), FLO_FC8(1.46581093943e-32), 
    FLO_FC8(1.23259516441e-32), FLO_FC8(1.03648485521e-32),
    FLO_FC8(8.71576399211e-33), FLO_FC8(7.32905469716e-33),
    FLO_FC8(6.16297582204e-33), FLO_FC8(5.18242427605e-33),
    FLO_FC8(4.35788199605e-33), FLO_FC8(3.66452734858e-33), 
    FLO_FC8(3.08148791102e-33), FLO_FC8(2.59121213802e-33),
    FLO_FC8(2.17894099803e-33), FLO_FC8(1.83226367429e-33), 
    FLO_FC8(1.54074395551e-33), FLO_FC8(1.29560606901e-33),
    FLO_FC8(1.08947049901e-33), FLO_FC8(9.16131837145e-34), 
    FLO_FC8(7.70371977755e-34), FLO_FC8(6.47803034506e-34),
    FLO_FC8(5.44735249507e-34), FLO_FC8(4.58065918572e-34), 
    FLO_FC8(3.85185988877e-34), FLO_FC8(3.23901517253e-34),
    FLO_FC8(2.72367624753e-34), FLO_FC8(2.29032959286e-34),
    FLO_FC8(1.92592994439e-34), FLO_FC8(1.61950758627e-34),
    FLO_FC8(1.36183812377e-34), FLO_FC8(1.14516479643e-34), 
    FLO_FC8(9.62964972194e-35), FLO_FC8(8.09753793133e-35),
    FLO_FC8(6.80919061883e-35), FLO_FC8(5.72582398216e-35), 
    FLO_FC8(4.81482486097e-35), FLO_FC8(4.04876896566e-35),
    FLO_FC8(3.40459530942e-35), FLO_FC8(2.86291199108e-35), 
    FLO_FC8(2.40741243048e-35), FLO_FC8(2.02438448283e-35),
    FLO_FC8(1.70229765471e-35), FLO_FC8(1.43145599554e-35), 
    FLO_FC8(1.20370621524e-35), FLO_FC8(1.01219224142e-35)
};

const FLO_Float * const FLO_GainTable = &TwoPower_0_25[256];

/* raise to the power 4/3 */
const FLO_Float FLO_Power_4_3[8192 + 15] = 
{
     FLO_FC9(0.0000000000000000),    FLO_FC9(1.0000000000000000),
     FLO_FC9(2.5198420997897464),    FLO_FC9(4.3267487109222245),
     FLO_FC9(6.3496042078727974),    FLO_FC9(8.5498797333834844),
     FLO_FC9(10.9027235569928358),   FLO_FC9(13.3905182794067219),
     FLO_FC9(15.9999999999999982),   FLO_FC9(18.7207544074671333),
     FLO_FC9(21.5443469003188319),   FLO_FC9(24.4637809962624679),
     FLO_FC9(27.4731418212799596),   FLO_FC9(30.5673509403698418),
     FLO_FC9(33.7419916984532122),   FLO_FC9(36.9931811149570464),
     FLO_FC9(40.3174735966359350),   FLO_FC9(43.7117870411899929),
     FLO_FC9(47.1733450957601264),   FLO_FC9(50.6996313257169433),
     FLO_FC9(54.2883523318981176),   FLO_FC9(57.9374077040035189),
     FLO_FC9(61.6448652744184997),   FLO_FC9(65.4089405365859875),
     FLO_FC9(69.2279793747555914),   FLO_FC9(73.1004434553216385),
     FLO_FC9(77.0248977785916082),   FLO_FC9(80.9999999999999858),
     FLO_FC9(85.0244912125185266),   FLO_FC9(89.0971879448895550),
     FLO_FC9(93.2169751786157406),   FLO_FC9(97.3828002241331632),
     FLO_FC9(101.5936673259647449),  FLO_FC9(105.8486328898622446),
     FLO_FC9(110.1468012434344104),  FLO_FC9(114.4873208566006042),
     FLO_FC9(118.8693809602065272),  FLO_FC9(123.2922085109002381),
     FLO_FC9(127.7550654583605763),  FLO_FC9(132.2572462775524684),
     FLO_FC9(136.7980757341357219),  FLO_FC9(141.3769068556919137),
     FLO_FC9(145.9931190852308589),  FLO_FC9(150.6461165966290991),
     FLO_FC9(155.3353267543467382),  FLO_FC9(160.0601987020527872),
     FLO_FC9(164.8202020667334864),  FLO_FC9(169.6148257665186065),
     FLO_FC9(174.4435769118853443),  FLO_FC9(179.3059797911255657),
     FLO_FC9(184.2015749320192697),  FLO_FC9(189.1299182325756192),
     FLO_FC9(194.0905801544968483),  FLO_FC9(199.0831449737167702),
     FLO_FC9(204.1072100829694023),  FLO_FC9(209.1623853418764725),
     FLO_FC9(214.2482924705075220),  FLO_FC9(219.3645644827778369),
     FLO_FC9(224.5108451564121310),  FLO_FC9(229.6867885365223003),
     FLO_FC9(234.8920584701317580),  FLO_FC9(240.1263281692324938),
     FLO_FC9(245.3892798001850508),  FLO_FC9(250.6806040974726102),
     FLO_FC9(255.9999999999999147),  FLO_FC9(261.3471743082886860),
     FLO_FC9(266.7218413610644916),  FLO_FC9(272.1237227298604466),
     FLO_FC9(277.5525469303796058),  FLO_FC9(283.0080491494618968),
     FLO_FC9(288.4899709865989053),  FLO_FC9(293.9980602090224693),
     FLO_FC9(299.5320705194740754),  FLO_FC9(305.0917613358298581),
     FLO_FC9(310.6768975818220611),  FLO_FC9(316.2872494881558509),
     FLO_FC9(321.9225924033717661),  FLO_FC9(327.5827066138553505),
     FLO_FC9(333.2673771724374205),  FLO_FC9(338.9763937350702463),
     FLO_FC9(344.7095504051013108),  FLO_FC9(350.4666455847001316),
     FLO_FC9(356.2474818330260860),  FLO_FC9(362.0518657307513877),
     FLO_FC9(367.8796077505825792),  FLO_FC9(373.7305221334451062),
     FLO_FC9(379.6044267700207797),  FLO_FC9(385.5011430873460654),
     FLO_FC9(391.4204959401994302),  FLO_FC9(397.3623135070237140),
     FLO_FC9(403.3264271901446705),  FLO_FC9(409.3126715200626222),
     FLO_FC9(415.3208840636079913),  FLO_FC9(421.3509053357647076),
     FLO_FC9(427.4025787149761868),  FLO_FC9(433.4757503617616976),
     FLO_FC9(439.5702691404792972),  FLO_FC9(445.6859865440827093),
     FLO_FC9(451.8227566217275921),  FLO_FC9(457.9804359090912840),
     FLO_FC9(464.1588833612777307),  FLO_FC9(470.3579602881872574),
     FLO_FC9(476.5775302922363039),  FLO_FC9(482.8174592083204288),
     FLO_FC9(489.0776150459174119),  FLO_FC9(495.3578679332358092),
     FLO_FC9(501.6580900633168767),  FLO_FC9(507.9781556420036850),
     FLO_FC9(514.3179408376964830),  FLO_FC9(520.6773237328167170),
     FLO_FC9(527.0561842769060377),  FLO_FC9(533.4544042412917406),
     FLO_FC9(539.8718671752512819),  FLO_FC9(546.3084583636150455),
     FLO_FC9(552.7640647857460863),  FLO_FC9(559.2385750758419363),
     FLO_FC9(565.7318794845041339),  FLO_FC9(572.2438698415234057),
     FLO_FC9(578.7744395198337770),  FLO_FC9(585.3234834005884295),
     FLO_FC9(591.8908978393126290),  FLO_FC9(598.4765806330925670),
     FLO_FC9(605.0804309887604404),  FLO_FC9(611.7023494920364328),
     FLO_FC9(618.3422380775919009),  FLO_FC9(624.9999999999997726),
     FLO_FC9(631.6755398055374826),  FLO_FC9(638.3687633048116368),
     FLO_FC9(645.0795775461748462),  FLO_FC9(651.8078907899041496),
     FLO_FC9(658.5536124831149891),  FLO_FC9(665.3166532353835692),
     FLO_FC9(672.0969247950522458),  FLO_FC9(678.8943400261942998),
     FLO_FC9(685.7088128862142185),  FLO_FC9(692.5402584040620013),
     FLO_FC9(699.3885926590397730),  FLO_FC9(706.2537327601805828),
     FLO_FC9(713.1355968261797216),  FLO_FC9(720.0341039658603677),
     FLO_FC9(726.9491742591543471),  FLO_FC9(733.8807287385820928),
     FLO_FC9(740.8286893712154324),  FLO_FC9(747.7929790411053546),
     FLO_FC9(754.7735215321619080),  FLO_FC9(761.7702415114704309),
     FLO_FC9(768.7830645130295579),  FLO_FC9(775.8119169218989555),
     FLO_FC9(782.8567259587424587),  FLO_FC9(789.9174196647544477),
     FLO_FC9(796.9939268869579791),  FLO_FC9(804.0861772638627372),
     FLO_FC9(811.1941012114709793),  FLO_FC9(818.3176299096222692),
     FLO_FC9(825.4566952886656281),  FLO_FC9(832.6112300164486442),
     FLO_FC9(839.7811674856160380),  FLO_FC9(846.9664418012055194),
     FLO_FC9(854.1669877685351366),  FLO_FC9(861.3827408813714328),
     FLO_FC9(868.6136373103697679),  FLO_FC9(875.8596138917820326),
     FLO_FC9(883.1206081164195894),  FLO_FC9(890.3965581188675742),
     FLO_FC9(897.6874026669418072),  FLO_FC9(904.9930811513817162),
     FLO_FC9(912.3135335757718849),  FLO_FC9(919.6487005466875644),
     FLO_FC9(926.9985232640561890),  FLO_FC9(934.3629435117289859),
     FLO_FC9(941.7419036482585852),  FLO_FC9(949.1353465978742179),
     FLO_FC9(956.5432158416521133),  FLO_FC9(963.9654554088734812),
     FLO_FC9(971.4020098685654148),  FLO_FC9(978.8528243212217603),
     FLO_FC9(986.3178443906958819),  FLO_FC9(993.7970162162635006),
     FLO_FC9(1001.2902864448500395),  FLO_FC9(1008.7976022234180391),
     FLO_FC9(1016.3189111915103240),  FLO_FC9(1023.8541614739464194),
     FLO_FC9(1031.4033016736652826),  FLO_FC9(1038.9662808647137808),
     FLO_FC9(1046.5430485853758000),  FLO_FC9(1054.1335548314366406),
     FLO_FC9(1061.7377500495838376),  FLO_FC9(1069.3555851309356513),
     FLO_FC9(1076.9870114046977960),  FLO_FC9(1084.6319806319440886),
     FLO_FC9(1092.2904449995173763),  FLO_FC9(1099.9623571140482454),
     FLO_FC9(1107.6476699960892347),  FLO_FC9(1115.3463370743606902),
     FLO_FC9(1123.0583121801059860),  FLO_FC9(1130.7835495415540663),
     FLO_FC9(1138.5220037784856686),  FLO_FC9(1146.2736298969009567),
     FLO_FC9(1154.0383832837878799),  FLO_FC9(1161.8162197019860287),
     FLO_FC9(1169.6070952851459879),  FLO_FC9(1177.4109665327807761),
     FLO_FC9(1185.2277903054077797),  FLO_FC9(1193.0575238197798171),
     FLO_FC9(1200.9001246442001047),  FLO_FC9(1208.7555506939247607),
     FLO_FC9(1216.6237602266442082),  FLO_FC9(1224.5047118380477968),
     FLO_FC9(1232.3983644574657319),  FLO_FC9(1240.3046773435874002),
     FLO_FC9(1248.2236100802567762),  FLO_FC9(1256.1551225723394509),
     FLO_FC9(1264.0991750416619652),  FLO_FC9(1272.0557280230227661),
     FLO_FC9(1280.0247423602691015),  FLO_FC9(1288.0061792024444003),
     FLO_FC9(1295.9999999999995453),  FLO_FC9(1304.0061665010680372),
     FLO_FC9(1312.0246407478061883),  FLO_FC9(1320.0553850727928875),
     FLO_FC9(1328.0983620954903017),  FLO_FC9(1336.1535347187650586),
     FLO_FC9(1344.2208661254646813),  FLO_FC9(1352.3003197750522304),
     FLO_FC9(1360.3918594002961981),  FLO_FC9(1368.4954490040145174),
     FLO_FC9(1376.6110528558708666),  FLO_FC9(1384.7386354892244071),
     FLO_FC9(1392.8781616980295439),  FLO_FC9(1401.0295965337854796),
     FLO_FC9(1409.1929053025353369),  FLO_FC9(1417.3680535619118928),
     FLO_FC9(1425.5550071182326519),  FLO_FC9(1433.7537320236374399),
     FLO_FC9(1441.9641945732744261),  FLO_FC9(1450.1863613025282120),
     FLO_FC9(1458.4201989842913463),  FLO_FC9(1466.6656746262797242),
     FLO_FC9(1474.9227554683875496),  FLO_FC9(1483.1914089800841339),
     FLO_FC9(1491.4716028578516216),  FLO_FC9(1499.7633050226595515),
     FLO_FC9(1508.0664836174794345),  FLO_FC9(1516.3811070048375313),
     FLO_FC9(1524.7071437644028720),  FLO_FC9(1533.0445626906127927),
     FLO_FC9(1541.3933327903341706),  FLO_FC9(1549.7534232805580814),
     FLO_FC9(1558.1248035861303833),  FLO_FC9(1566.5074433375150420),
     FLO_FC9(1574.9013123685908795),  FLO_FC9(1583.3063807144794737),
     FLO_FC9(1591.7226186094069362),  FLO_FC9(1600.1499964845941122),
     FLO_FC9(1608.5884849661799763),  FLO_FC9(1617.0380548731736781),
     FLO_FC9(1625.4986772154356913),  FLO_FC9(1633.9703231916887489),
     FLO_FC9(1642.4529641875576544),  FLO_FC9(1650.9465717736345596),
     FLO_FC9(1659.4511177035751643),  FLO_FC9(1667.9665739122185641),
     FLO_FC9(1676.4929125137352912),  FLO_FC9(1685.0301057998010492),
     FLO_FC9(1693.5781262377956864),  FLO_FC9(1702.1369464690269524),
     FLO_FC9(1710.7065393069794936),  FLO_FC9(1719.2868777355877228),
     FLO_FC9(1727.8779349075323353),  FLO_FC9(1736.4796841425595630),
     FLO_FC9(1745.0920989258249847),  FLO_FC9(1753.7151529062582540),
     FLO_FC9(1762.3488198949503385),  FLO_FC9(1770.9930738635630405),
     FLO_FC9(1779.6478889427596641),  FLO_FC9(1788.3132394206563731),
     FLO_FC9(1796.9890997412946945),  FLO_FC9(1805.6754445031333489),
     FLO_FC9(1814.3722484575621365),  FLO_FC9(1823.0794865074321933),
     FLO_FC9(1831.7971337056094399),  FLO_FC9(1840.5251652535437188),
     FLO_FC9(1849.2635564998579412),  FLO_FC9(1858.0122829389563321),
     FLO_FC9(1866.7713202096492751),  FLO_FC9(1875.5406440937965726),
     FLO_FC9(1884.3202305149686708),  FLO_FC9(1893.1100555371240262),
     FLO_FC9(1901.9100953633042081),  FLO_FC9(1910.7203263343453727),
     FLO_FC9(1919.5407249276056518),  FLO_FC9(1928.3712677557098232),
     FLO_FC9(1937.2119315653083049),  FLO_FC9(1946.0626932358525210),
     FLO_FC9(1954.9235297783859551),  FLO_FC9(1963.7944183343499844),
     FLO_FC9(1972.6753361744035828),  FLO_FC9(1981.5662606972593949),
     FLO_FC9(1990.4671694285329977),  FLO_FC9(1999.3780400196069422),
     FLO_FC9(2008.2988502465077545),  FLO_FC9(2017.2295780087981711),
     FLO_FC9(2026.1702013284818804),  FLO_FC9(2035.1206983489212234),
     FLO_FC9(2044.0810473337687654),  FLO_FC9(2053.0512266659125089),
     FLO_FC9(2062.0312148464308848),  FLO_FC9(2071.0209904935645682),
     FLO_FC9(2080.0205323416957981),  FLO_FC9(2089.0298192403442954),
     FLO_FC9(2098.0488301531713660),  FLO_FC9(2107.0775441569994655),
     FLO_FC9(2116.1159404408390401),  FLO_FC9(2125.1639983049317379),
     FLO_FC9(2134.2216971597995325),  FLO_FC9(2143.2890165253097621),
     FLO_FC9(2152.3659360297483545),  FLO_FC9(2161.4524354089030567),
     FLO_FC9(2170.5484945051616705),  FLO_FC9(2179.6540932666143817),
     FLO_FC9(2188.7692117461710950),  FLO_FC9(2197.8938301006887741),
     FLO_FC9(2207.0279285901042385),  FLO_FC9(2216.1714875765837860),
     FLO_FC9(2225.3244875236759981),  FLO_FC9(2234.4869089954781884),
     FLO_FC9(2243.6587326558101267),  FLO_FC9(2252.8399392673982220),
     FLO_FC9(2262.0305096910701650),  FLO_FC9(2271.2304248849536634),
     FLO_FC9(2280.4396659036897290),  FLO_FC9(2289.6582138976523311),
     FLO_FC9(2298.8860501121762354),  FLO_FC9(2308.1231558867925742),
     FLO_FC9(2317.3695126544766936),  FLO_FC9(2326.6251019409005494),
     FLO_FC9(2335.8899053636932877),  FLO_FC9(2345.1639046317131942),
     FLO_FC9(2354.4470815443232823),  FLO_FC9(2363.7394179906791578),
     FLO_FC9(2373.0408959490205234),  FLO_FC9(2382.3514974859731410),
     FLO_FC9(2391.6712047558557970),  FLO_FC9(2400.9999999999990905),
     FLO_FC9(2410.3378655460651316),  FLO_FC9(2419.6847838073813364),
     FLO_FC9(2429.0407372822746765),  FLO_FC9(2438.4057085534191174),
     FLO_FC9(2447.7796802871857835),  FLO_FC9(2457.1626352330008558),
     FLO_FC9(2466.5545562227111986),  FLO_FC9(2475.9554261699563540),
     FLO_FC9(2485.3652280695473564),  FLO_FC9(2494.7839449968487315),
     FLO_FC9(2504.2115601071736819),  FLO_FC9(2513.6480566351788184),
     FLO_FC9(2523.0934178942675317),  FLO_FC9(2532.5476272760024585),
     FLO_FC9(2542.0106682495188579),  FLO_FC9(2551.4825243609479912),
     FLO_FC9(2560.9631792328441406),  FLO_FC9(2570.4526165636184487),
     FLO_FC9(2579.9508201269791243),  FLO_FC9(2589.4577737713743772),
     FLO_FC9(2598.9734614194458118),  FLO_FC9(2608.4978670674822752),
     FLO_FC9(2618.0309747848837105),  FLO_FC9(2627.5727687136259192),
     FLO_FC9(2637.1232330677353275),  FLO_FC9(2646.6823521327646631),
     FLO_FC9(2656.2501102652768168),  FLO_FC9(2665.8264918923327969),
     FLO_FC9(2675.4114815109842311),  FLO_FC9(2685.0050636877722354),
     FLO_FC9(2694.6072230582294651),  FLO_FC9(2704.2179443263894427),
     FLO_FC9(2713.8372122642972499),  FLO_FC9(2723.4650117115279500),
     FLO_FC9(2733.1013275747095577),  FLO_FC9(2742.7461448270482833),
     FLO_FC9(2752.3994485078601429),  FLO_FC9(2762.0612237221084797),
     FLO_FC9(2771.7314556399419416),  FLO_FC9(2781.4101294962406428),
     FLO_FC9(2791.0972305901655091),  FLO_FC9(2800.7927442847094426),
     FLO_FC9(2810.4966560062589451),  FLO_FC9(2820.2089512441521038),
     FLO_FC9(2829.9296155502465808),  FLO_FC9(2839.6586345384894230),
     FLO_FC9(2849.3959938844918724),  FLO_FC9(2859.1416793251064519),
     FLO_FC9(2868.8956766580085969),  FLO_FC9(2878.6579717412846549),
     FLO_FC9(2888.4285504930212483),  FLO_FC9(2898.2073988908973661),
     FLO_FC9(2907.9945029717837315),  FLO_FC9(2917.7898488313439884),
     FLO_FC9(2927.5934226236377071),  FLO_FC9(2937.4052105607311205),
     FLO_FC9(2947.2251989123078602),  FLO_FC9(2957.0533740052865141),
     FLO_FC9(2966.8897222234368201),  FLO_FC9(2976.7342300070049532),
     FLO_FC9(2986.5868838523397244),  FLO_FC9(2996.4476703115196869),
     FLO_FC9(3006.3165759919888842),  FLO_FC9(3016.1935875561907778),
     FLO_FC9(3026.0786917212094522),  FLO_FC9(3035.9718752584108188),
     FLO_FC9(3045.8731249930901868),  FLO_FC9(3055.7824278041207435),
     FLO_FC9(3065.6997706236038539),  FLO_FC9(3075.6251404365279996),
     FLO_FC9(3085.5585242804245354),  FLO_FC9(3095.4999092450298122),
     FLO_FC9(3105.4492824719491182),  FLO_FC9(3115.4066311543256234),
     FLO_FC9(3125.3719425365088682),  FLO_FC9(3135.3452039137287102),
     FLO_FC9(3145.3264026317715434),  FLO_FC9(3155.3155260866592471),
     FLO_FC9(3165.3125617243294982),  FLO_FC9(3175.3174970403229054),
     FLO_FC9(3185.3303195794674139),  FLO_FC9(3195.3510169355699873),
     FLO_FC9(3205.3795767511078338),  FLO_FC9(3215.4159867169250901),
     FLO_FC9(3225.4602345719290497),  FLO_FC9(3235.5123081027927583),
     FLO_FC9(3245.5721951436557902),  FLO_FC9(3255.6398835758300265),
     FLO_FC9(3265.7153613275099815),  FLO_FC9(3275.7986163734794900),
     FLO_FC9(3285.8896367348288550),  FLO_FC9(3295.9884104786665375),
     FLO_FC9(3306.0949257178394873),  FLO_FC9(3316.2091706106516540),
     FLO_FC9(3326.3311333605879554),  FLO_FC9(3336.4608022160382461),
     FLO_FC9(3346.5981654700231047),  FLO_FC9(3356.7432114599264423),
     FLO_FC9(3366.8959285672249280),  FLO_FC9(3377.0563052172210519),
     FLO_FC9(3387.2243298787821004),  FLO_FC9(3397.3999910640764028),
     FLO_FC9(3407.5832773283127608),  FLO_FC9(3417.7741772694862448),
     FLO_FC9(3427.9726795281198974),  FLO_FC9(3438.1787727870123490),
     FLO_FC9(3448.3924457709872513),  FLO_FC9(3458.6136872466445311),
     FLO_FC9(3468.8424860221107338),  FLO_FC9(3479.0788309467975523),
     FLO_FC9(3489.3227109111553546),  FLO_FC9(3499.5741148464344406),
     FLO_FC9(3509.8330317244444814),  FLO_FC9(3520.0994505573185052),
     FLO_FC9(3530.3733603972750643),  FLO_FC9(3540.6547503363885880),
     FLO_FC9(3550.9436095063533685),  FLO_FC9(3561.2399270782580061),
     FLO_FC9(3571.5436922623534883),  FLO_FC9(3581.8548943078308184),
     FLO_FC9(3592.1735225025936415),  FLO_FC9(3602.4995661730372376),
     FLO_FC9(3612.8330146838275141),  FLO_FC9(3623.1738574376813631),
     FLO_FC9(3633.5220838751502015),  FLO_FC9(3643.8776834744030566),
     FLO_FC9(3654.2406457510141990),  FLO_FC9(3664.6109602577494115),
     FLO_FC9(3674.9886165843563504),  FLO_FC9(3685.3736043573544521),
     FLO_FC9(3695.7659132398293877),  FLO_FC9(3706.1655329312247886),
     FLO_FC9(3716.5724531671398836),  FLO_FC9(3726.9866637191262271),
     FLO_FC9(3737.4081543944876103),  FLO_FC9(3747.8369150360781532),
     FLO_FC9(3758.2729355221072183),  FLO_FC9(3768.7162057659411403),
     FLO_FC9(3779.1667157159076851),  FLO_FC9(3789.6244553551055105),
     FLO_FC9(3800.0894147012081703),  FLO_FC9(3810.5615838062767580),
     FLO_FC9(3821.0409527565693679),  FLO_FC9(3831.5275116723532847),
     FLO_FC9(3842.0212507077194459),  FLO_FC9(3852.5221600503959962),
     FLO_FC9(3863.0302299215672974),  FLO_FC9(3873.5454505756893013),
     FLO_FC9(3884.0678123003108340),  FLO_FC9(3894.5973054158921514),
     FLO_FC9(3905.1339202756284976),  FLO_FC9(3915.6776472652732082),
     FLO_FC9(3926.2284768029603583),  FLO_FC9(3936.7863993390337782),
     FLO_FC9(3947.3514053558706109),  FLO_FC9(3957.9234853677135106),
     FLO_FC9(3968.5026299204969291),  FLO_FC9(3979.0888295916797688),
     FLO_FC9(3989.6820749900775809),  FLO_FC9(4000.2823567556947637),
     FLO_FC9(4010.8896655595613083),  FLO_FC9(4021.5039921035654515),
     FLO_FC9(4032.1253271202945143),  FLO_FC9(4042.7536613728693737),
     FLO_FC9(4053.3889856547857562),  FLO_FC9(4064.0312907897550758),
     FLO_FC9(4074.6805676315448181),  FLO_FC9(4085.3368070638221070),
     FLO_FC9(4095.9999999999981810),  FLO_FC9(4106.6701373830710509),
     FLO_FC9(4117.3472101854749781),  FLO_FC9(4128.0312094089258608),
     FLO_FC9(4138.7221260842679840),  FLO_FC9(4149.4199512713266813),
     FLO_FC9(4160.1246760587582685),  FLO_FC9(4170.8362915638981576),
     FLO_FC9(4181.5547889326180666),  FLO_FC9(4192.2801593391768620),
     FLO_FC9(4203.0123939860741302),  FLO_FC9(4213.7514841039101157),
     FLO_FC9(4224.4974209512383823),  FLO_FC9(4235.2501958144257515),
     FLO_FC9(4246.0098000075095115),  FLO_FC9(4256.7762248720573552),
     FLO_FC9(4267.5494617770309560),  FLO_FC9(4278.3295021186422673),
     FLO_FC9(4289.1163373202198272),  FLO_FC9(4299.9099588320714247),
     FLO_FC9(4310.7103581313494942),  FLO_FC9(4321.5175267219137822),
     FLO_FC9(4332.3314561342003799),  FLO_FC9(4343.1521379250880273),
     FLO_FC9(4353.9795636777671461),  FLO_FC9(4364.8137250016052349),
     FLO_FC9(4375.6546135320222675),  FLO_FC9(4386.5022209303588170),
     FLO_FC9(4397.3565388837469072),  FLO_FC9(4408.2175591049826835),
     FLO_FC9(4419.0852733324018118),  FLO_FC9(4429.9596733297530591),
     FLO_FC9(4440.8407508860727830),  FLO_FC9(4451.7284978155603312),
     FLO_FC9(4462.6229059574570783),  FLO_FC9(4473.5239671759227349),
     FLO_FC9(4484.4316733599125655),  FLO_FC9(4495.3460164230582450),
     FLO_FC9(4506.2669883035496241),  FLO_FC9(4517.1945809640119478),
     FLO_FC9(4528.1287863913894398),  FLO_FC9(4539.0695965968279779),
     FLO_FC9(4550.0170036155586786),  FLO_FC9(4560.9709995067805721),
     FLO_FC9(4571.9315763535460064),  FLO_FC9(4582.8987262626469601),
     FLO_FC9(4593.8724413645004461),  FLO_FC9(4604.8527138130348249),
     FLO_FC9(4615.8395357855815746),  FLO_FC9(4626.8328994827570568),
     FLO_FC9(4637.8327971283588340),  FLO_FC9(4648.8392209692510733),
     FLO_FC9(4659.8521632752563164),  FLO_FC9(4670.8716163390472502),
     FLO_FC9(4681.8975724760393859),  FLO_FC9(4692.9300240242837390),
     FLO_FC9(4703.9689633443595085),  FLO_FC9(4715.0143828192667570),
     FLO_FC9(4726.0662748543254565),  FLO_FC9(4737.1246318770681683),
     FLO_FC9(4748.1894463371372694),  FLO_FC9(4759.2607107061803617),
     FLO_FC9(4770.3384174777493172),  FLO_FC9(4781.4225591671993243),
     FLO_FC9(4792.5131283115852057),  FLO_FC9(4803.6101174695613736),
     FLO_FC9(4814.7135192212854236),  FLO_FC9(4825.8233261683153614),
     FLO_FC9(4836.9395309335095590),  FLO_FC9(4848.0621261609348949),
     FLO_FC9(4859.1911045157630724),  FLO_FC9(4870.3264586841778510),
     FLO_FC9(4881.4681813732768205),  FLO_FC9(4892.6162653109768144),
     FLO_FC9(4903.7707032459193215),  FLO_FC9(4914.9314879473749897),
     FLO_FC9(4926.0986122051508573),  FLO_FC9(4937.2720688294966749),
     FLO_FC9(4948.4518506510112275),  FLO_FC9(4959.6379505205550231),
     FLO_FC9(4970.8303613091520674),  FLO_FC9(4982.0290759079043710),
     FLO_FC9(4993.2340872278973620),  FLO_FC9(5004.4453882001153033),
     FLO_FC9(5015.6629717753467048),  FLO_FC9(5026.8868309241006500),
     FLO_FC9(5038.1169586365131181),  FLO_FC9(5049.3533479222660389),
     FLO_FC9(5060.5959918104927056),  FLO_FC9(5071.8448833496995576),
     FLO_FC9(5083.1000156076734129),  FLO_FC9(5094.3613816713996130),
     FLO_FC9(5105.6289746469747115),  FLO_FC9(5116.9027876595246198),
     FLO_FC9(5128.1828138531200239),  FLO_FC9(5139.4690463906918012),
     FLO_FC9(5150.7614784539473476),  FLO_FC9(5162.0601032432932698),
     FLO_FC9(5173.3649139777471646),  FLO_FC9(5184.6759038948594025),
     FLO_FC9(5195.9930662506321823),  FLO_FC9(5207.3163943194385865),
     FLO_FC9(5218.6458813939434549),  FLO_FC9(5229.9815207850233492),
     FLO_FC9(5241.3233058216846985),  FLO_FC9(5252.6712298509919492),
     FLO_FC9(5264.0252862379829821),  FLO_FC9(5275.3854683655954432),
     FLO_FC9(5286.7517696345876175),  FLO_FC9(5298.1241834634638508),
     FLO_FC9(5309.5027032883954234),  FLO_FC9(5320.8873225631459718),
     FLO_FC9(5332.2780347589978192),  FLO_FC9(5343.6748333646755782),
     FLO_FC9(5355.0777118862715724),  FLO_FC9(5366.4866638471721672),
     FLO_FC9(5377.9016827879850098),  FLO_FC9(5389.3227622664635419),
     FLO_FC9(5400.7498958574369681),  FLO_FC9(5412.1830771527356774),
     FLO_FC9(5423.6222997611230312),  FLO_FC9(5435.0675573082189658),
     FLO_FC9(5446.5188434364317800),  FLO_FC9(5457.9761518048871949),
     FLO_FC9(5469.4394760893592320),  FLO_FC9(5480.9088099821974538),
     FLO_FC9(5492.3841471922605706),  FLO_FC9(5503.8654814448454999),
     FLO_FC9(5515.3528064816200640),  FLO_FC9(5526.8461160605520490),
     FLO_FC9(5538.3454039558464501),  FLO_FC9(5549.8506639578736213),
     FLO_FC9(5561.3618898731028821),  FLO_FC9(5572.8790755240361250),
     FLO_FC9(5584.4022147491450596),  FLO_FC9(5595.9313014027975441),
     FLO_FC9(5607.4663293552011964),  FLO_FC9(5619.0072924923297251),
     FLO_FC9(5630.5541847158656310),  FLO_FC9(5642.1069999431283577),
     FLO_FC9(5653.6657321070169928),  FLO_FC9(5665.2303751559429656),
     FLO_FC9(5676.8009230537654730),  FLO_FC9(5688.3773697797332716),
     FLO_FC9(5699.9597093284164657),  FLO_FC9(5711.5479357096473905),
     FLO_FC9(5723.1420429484587657),  FLO_FC9(5734.7420250850209413),
     FLO_FC9(5746.3478761745809607),  FLO_FC9(5757.9595902874016247),
     FLO_FC9(5769.5771615087005557),  FLO_FC9(5781.2005839385910804),
     FLO_FC9(5792.8298516920212933),  FLO_FC9(5804.4649588987149400),
     FLO_FC9(5816.1058997031113904),  FLO_FC9(5827.7526682643065215),
     FLO_FC9(5839.4052587559972380),  FLO_FC9(5851.0636653664196274),
     FLO_FC9(5862.7278822982907514),  FLO_FC9(5874.3979037687540767),
     FLO_FC9(5886.0737240093203582),  FLO_FC9(5897.7553372658094304),
     FLO_FC9(5909.4427377982956386),  FLO_FC9(5921.1359198810505404),
     FLO_FC9(5932.8348778024874264),  FLO_FC9(5944.5396058651031126),
     FLO_FC9(5956.2500983854260994),  FLO_FC9(5967.9663496939574543),
     FLO_FC9(5979.6883541351207896),  FLO_FC9(5991.4161060672022359),
     FLO_FC9(6003.1495998623004198),  FLO_FC9(6014.8888299062700753),
     FLO_FC9(6026.6337905986674741),  FLO_FC9(6038.3844763527031319),
     FLO_FC9(6050.1408815951781435),  FLO_FC9(6061.9030007664414370),
     FLO_FC9(6073.6708283203315659),  FLO_FC9(6085.4443587241266869),
     FLO_FC9(6097.2235864584890805),  FLO_FC9(6109.0085060174196769),
     FLO_FC9(6120.7991119081998477),  FLO_FC9(6132.5953986513450218),
     FLO_FC9(6144.3973607805519350),  FLO_FC9(6156.2049928426458791),
     FLO_FC9(6168.0182893975361367),  FLO_FC9(6179.8372450181577733),
     FLO_FC9(6191.6618542904307105),  FLO_FC9(6203.4921118132024276),
     FLO_FC9(6215.3280121982015771),  FLO_FC9(6227.1695500699925105),
     FLO_FC9(6239.0167200659188893),  FLO_FC9(6250.8695168360627576),
     FLO_FC9(6262.7279350431890634),  FLO_FC9(6274.5919693627056404),
     FLO_FC9(6286.4616144826068194),  FLO_FC9(6298.3368651034325012),
     FLO_FC9(6310.2177159382172249),  FLO_FC9(6322.1041617124456025),
     FLO_FC9(6333.9961971640032061),  FLO_FC9(6345.8938170431310937),
     FLO_FC9(6357.7970161123785147),  FLO_FC9(6369.7057891465583452),
     FLO_FC9(6381.6201309327016133),  FLO_FC9(6393.5400362700074766),
     FLO_FC9(6405.4654999698032043),  FLO_FC9(6417.3965168554977936),
     FLO_FC9(6429.3330817625328564),  FLO_FC9(6441.2751895383453302),
     FLO_FC9(6453.2228350423138181),  FLO_FC9(6465.1760131457240277),
     FLO_FC9(6477.1347187317160206),  FLO_FC9(6489.0989466952469229),
     FLO_FC9(6501.0686919430445414),  FLO_FC9(6513.0439493935627979),
     FLO_FC9(6525.0247139769417117),  FLO_FC9(6537.0109806349610153),
     FLO_FC9(6549.0027443210010460),  FLO_FC9(6560.9999999999963620),
     FLO_FC9(6573.0027426483984527),  FLO_FC9(6585.0109672541284453),
     FLO_FC9(6597.0246688165370870),  FLO_FC9(6609.0438423463656363),
     FLO_FC9(6621.0684828657003891),  FLO_FC9(6633.0985854079353885),
     FLO_FC9(6645.1341450177269508),  FLO_FC9(6657.1751567509572851),
     FLO_FC9(6669.2216156746899287),  FLO_FC9(6681.2735168671342763),
     FLO_FC9(6693.3308554176001053),  FLO_FC9(6705.3936264264593774),
     FLO_FC9(6717.4618250051080395),  FLO_FC9(6729.5354462759260059),
     FLO_FC9(6741.6144853722335029),  FLO_FC9(6753.6989374382601454),
     FLO_FC9(6765.7887976290967345),  FLO_FC9(6777.8840611106634242),
     FLO_FC9(6789.9847230596660665),  FLO_FC9(6802.0907786635625598),
     FLO_FC9(6814.2022231205201024),  FLO_FC9(6826.3190516393797225),
     FLO_FC9(6838.4412594396180793),  FLO_FC9(6850.5688417513074455),
     FLO_FC9(6862.7017938150829650),  FLO_FC9(6874.8401108820989975),
     FLO_FC9(6886.9837882139991052),  FLO_FC9(6899.1328210828723968),
     FLO_FC9(6911.2872047712207859),  FLO_FC9(6923.4469345719198827),
     FLO_FC9(6935.6120057881862522),  FLO_FC9(6947.7824137335364867),
     FLO_FC9(6959.9581537317535549),  FLO_FC9(6972.1392211168531503),
     FLO_FC9(6984.3256112330409451),  FLO_FC9(6996.5173194346862147),
     FLO_FC9(7008.7143410862772726),  FLO_FC9(7020.9166715623941855),
     FLO_FC9(7033.1243062476678460),  FLO_FC9(7045.3372405367481406),
     FLO_FC9(7057.5554698342684787),  FLO_FC9(7069.7789895548103232),
     FLO_FC9(7082.0077951228713573),  FLO_FC9(7094.2418819728272865),
     FLO_FC9(7106.4812455489018248),  FLO_FC9(7118.7258813051284960),
     FLO_FC9(7130.9757847053224395),  FLO_FC9(7143.2309512230394830),
     FLO_FC9(7155.4913763415515859),  FLO_FC9(7167.7570555538031840),
     FLO_FC9(7180.0279843623893612),  FLO_FC9(7192.3041582795131035),
     FLO_FC9(7204.5855728269571046),  FLO_FC9(7216.8722235360519335),
     FLO_FC9(7229.1641059476405644),  FLO_FC9(7241.4612156120492727),
     FLO_FC9(7253.7635480890503459),  FLO_FC9(7266.0710989478375268),
     FLO_FC9(7278.3838637669869058),  FLO_FC9(7290.7018381344296358),
     FLO_FC9(7303.0250176474173713),  FLO_FC9(7315.3533979124931648),
     FLO_FC9(7327.6869745454596341),  FLO_FC9(7340.0257431713462211),
     FLO_FC9(7352.3696994243800873),  FLO_FC9(7364.7188389479542820),
     FLO_FC9(7377.0731573945968194),  FLO_FC9(7389.4326504259415742),
     FLO_FC9(7401.7973137126937218),  FLO_FC9(7414.1671429346060904),
     FLO_FC9(7426.5421337804427822),  FLO_FC9(7438.9222819479509781),
     FLO_FC9(7451.3075831438345631),  FLO_FC9(7463.6980330837177462),
     FLO_FC9(7476.0936274921214135),  FLO_FC9(7488.4943621024303866),
     FLO_FC9(7500.9002326568652279),  FLO_FC9(7513.3112349064522277),
     FLO_FC9(7525.7273646109943002),  FLO_FC9(7538.1486175390446078),
     FLO_FC9(7550.5749894678729106),  FLO_FC9(7563.0064761834419187),
     FLO_FC9(7575.4430734803736414),  FLO_FC9(7587.8847771619248306),
     FLO_FC9(7600.3315830399596962),  FLO_FC9(7612.7834869349153450),
     FLO_FC9(7625.2404846757799532),  FLO_FC9(7637.7025721000636622),
     FLO_FC9(7650.1697450537676559),  FLO_FC9(7662.6419993913596045),
     FLO_FC9(7675.1193309757445604),  FLO_FC9(7687.6017356782404022),
     FLO_FC9(7700.0892093785441830),  FLO_FC9(7712.5817479647112123),
     FLO_FC9(7725.0793473331250425),  FLO_FC9(7737.5820033884729128),
     FLO_FC9(7750.0897120437139165),  FLO_FC9(7762.6024692200580830),
     FLO_FC9(7775.1202708469354548),  FLO_FC9(7787.6431128619733499),
     FLO_FC9(7800.1709912109645302),  FLO_FC9(7812.7039018478481012),
     FLO_FC9(7825.2418407346767708),  FLO_FC9(7837.7848038415968404),
     FLO_FC9(7850.3327871468154626),  FLO_FC9(7862.8857866365806331),
     FLO_FC9(7875.4437983051539049),  FLO_FC9(7888.0068181547840140),
     FLO_FC9(7900.5748421956805032),  FLO_FC9(7913.1478664459900756),
     FLO_FC9(7925.7258869317720382),  FLO_FC9(7938.3088996869719267),
     FLO_FC9(7950.8969007533951299),  FLO_FC9(7963.4898861806850618),
     FLO_FC9(7976.0878520262958773),  FLO_FC9(7988.6907943554688245),
     FLO_FC9(8001.2987092412085985),  FLO_FC9(8013.9115927642569659),
     FLO_FC9(8026.5294410130691176),  FLO_FC9(8039.1522500837891130),
     FLO_FC9(8051.7800160802271421),  FLO_FC9(8064.4127351138349695),
     FLO_FC9(8077.0504033036795590),  FLO_FC9(8089.6930167764221551),
     FLO_FC9(8102.3405716662946361),  FLO_FC9(8114.9930641150731390),
     FLO_FC9(8127.6504902720571408),  FLO_FC9(8140.3128462940449026),
     FLO_FC9(8152.9801283453098222),  FLO_FC9(8165.6523325975786065),
     FLO_FC9(8178.3294552300048963),  FLO_FC9(8191.0114924291528951),
     FLO_FC9(8203.6984403889655368),  FLO_FC9(8216.3902953107462963),
     FLO_FC9(8229.0870534031419083),  FLO_FC9(8241.7887108821068978),
     FLO_FC9(8254.4952639708935749),  FLO_FC9(8267.2067089000211126),
     FLO_FC9(8279.9230419072573568),  FLO_FC9(8292.6442592375951790),
     FLO_FC9(8305.3703571432306489),  FLO_FC9(8318.1013318835430255),
     FLO_FC9(8330.8371797250656527),  FLO_FC9(8343.5778969414750463),
     FLO_FC9(8356.3234798135581514),  FLO_FC9(8369.0739246291977906),
     FLO_FC9(8381.8292276833508367),  FLO_FC9(8394.5893852780209272),
     FLO_FC9(8407.3543937222420936),  FLO_FC9(8420.1242493320587528),
     FLO_FC9(8432.8989484304947837),  FLO_FC9(8445.6784873475498898),
     FLO_FC9(8458.4628624201577622),  FLO_FC9(8471.2520699921806226),
     FLO_FC9(8484.0461064143837575),  FLO_FC9(8496.8449680444082333),
     FLO_FC9(8509.6486512467636203),  FLO_FC9(8522.4571523927952512),
     FLO_FC9(8535.2704678606660309),  FLO_FC9(8548.0885940353437036),
     FLO_FC9(8560.9115273085662920),  FLO_FC9(8573.7392640788402787),
     FLO_FC9(8586.5718007514005876),  FLO_FC9(8599.4091337382069469),
     FLO_FC9(8612.2512594579147844),  FLO_FC9(8625.0981743358552194),
     FLO_FC9(8637.9498748040205101),  FLO_FC9(8650.8063573010385880),
     FLO_FC9(8663.6676182721566875),  FLO_FC9(8676.5336541692249739),
     FLO_FC9(8689.4044614506638027),  FLO_FC9(8702.2800365814600809),
     FLO_FC9(8715.1603760331418016),  FLO_FC9(8728.0454762837507587),
     FLO_FC9(8740.9353338178389095),  FLO_FC9(8753.8299451264356321),
     FLO_FC9(8766.7293067070331745),  FLO_FC9(8779.6334150635721016),
     FLO_FC9(8792.5422667064158304),  FLO_FC9(8805.4558581523324392),
     FLO_FC9(8818.3741859244819352),  FLO_FC9(8831.2972465523907886),
     FLO_FC9(8844.2250365719355614),  FLO_FC9(8857.1575525253265369),
     FLO_FC9(8870.0947909610840725),  FLO_FC9(8883.0367484340295050),
     FLO_FC9(8895.9834215052524087),  FLO_FC9(8908.9348067421069572),
     FLO_FC9(8921.8909007181846391),  FLO_FC9(8934.8517000132997055),
     FLO_FC9(8947.8172012134709803),  FLO_FC9(8960.7874009109000326),
     FLO_FC9(8973.7622957039602625),  FLO_FC9(8986.7418821971732541),
     FLO_FC9(8999.7261570011924050),  FLO_FC9(9012.7151167327883741),
     FLO_FC9(9025.7087580148236157),  FLO_FC9(9038.7070774762469227),
     FLO_FC9(9051.7100717520643229),  FLO_FC9(9064.7177374833281647),
     FLO_FC9(9077.7300713171152893),  FLO_FC9(9090.7470699065179360),
     FLO_FC9(9103.7687299106146384),  FLO_FC9(9116.7950479944647668),
     FLO_FC9(9129.8260208290812443),  FLO_FC9(9142.8616450914232701),
     FLO_FC9(9155.9019174643726728),  FLO_FC9(9168.9468346367157210),
     FLO_FC9(9181.9963933031358465),  FLO_FC9(9195.0505901641845412),
     FLO_FC9(9208.1094219262740808),  FLO_FC9(9221.1728853016556968),
     FLO_FC9(9234.2409770084050251),  FLO_FC9(9247.3136937704075535),
     FLO_FC9(9260.3910323173386132),  FLO_FC9(9273.4729893846470077),
     FLO_FC9(9286.5595617135422799),  FLO_FC9(9299.6507460509747034),
     FLO_FC9(9312.7465391496207303),  FLO_FC9(9325.8469377678684396),
     FLO_FC9(9338.9519386698011658),  FLO_FC9(9352.0615386251756718),
     FLO_FC9(9365.1757344094130531),  FLO_FC9(9378.2945228035841865),
     FLO_FC9(9391.4179005943842640),  FLO_FC9(9404.5458645741273358),
     FLO_FC9(9417.6784115407263016),  FLO_FC9(9430.8155382976747205),
     FLO_FC9(9443.9572416540358972),  FLO_FC9(9457.1035184244265110),
     FLO_FC9(9470.2543654290002451),  FLO_FC9(9483.4097794934295962),
     FLO_FC9(9496.5697574488931423),  FLO_FC9(9509.7342961320664472),
     FLO_FC9(9522.9033923850911378),  FLO_FC9(9536.0770430555803614),
     FLO_FC9(9549.2552449965824053),  FLO_FC9(9562.4379950665825163),
     FLO_FC9(9575.6252901294792537),  FLO_FC9(9588.8171270545735752),
     FLO_FC9(9602.0135027165488282),  FLO_FC9(9615.2144139954634738),
     FLO_FC9(9628.4198577767256211),  FLO_FC9(9641.6298309510930267),
     FLO_FC9(9654.8443304146439914),  FLO_FC9(9668.0633530687719031),
     FLO_FC9(9681.2868958201670466),  FLO_FC9(9694.5149555808002333),
     FLO_FC9(9707.7475292679191625),  FLO_FC9(9720.9846138040156802),
     FLO_FC9(9734.2262061168275977),  FLO_FC9(9747.4723031393186830),
     FLO_FC9(9760.7229018096641084),  FLO_FC9(9773.9779990712322615),
     FLO_FC9(9787.2375918725811061),  FLO_FC9(9800.5016771674327174),
     FLO_FC9(9813.7702519146696432),  FLO_FC9(9827.0433130783094384),
     FLO_FC9(9840.3208576275028463),  FLO_FC9(9853.6028825365119701),
     FLO_FC9(9866.8893847846993594),  FLO_FC9(9880.1803613565116393),
     FLO_FC9(9893.4758092414685962),  FLO_FC9(9906.7757254341522639),
     FLO_FC9(9920.0801069341850962),  FLO_FC9(9933.3889507462245092),
     FLO_FC9(9946.7022538799428730),  FLO_FC9(9960.0200133500220545),
     FLO_FC9(9973.3422261761297705),  FLO_FC9(9986.6688893829159497),
     FLO_FC9(9999.9999999999945430),  FLO_FC9(10013.3355550619289716),
     FLO_FC9(10026.6755516082212125),  FLO_FC9(10040.0199866833008855),
     FLO_FC9(10053.3688573365088814),  FLO_FC9(10066.7221606220809917),
     FLO_FC9(10080.0798935991442704),  FLO_FC9(10093.4420533316970250),
     FLO_FC9(10106.8086368885979027),  FLO_FC9(10120.1796413435495197),
     FLO_FC9(10133.5550637750948226),  FLO_FC9(10146.9349012665952614),
     FLO_FC9(10160.3191509062198747),  FLO_FC9(10173.7078097869361955),
     FLO_FC9(10187.1008750064956985),  FLO_FC9(10200.4983436674174300),
     FLO_FC9(10213.9002128769843694),  FLO_FC9(10227.3064797472216014),
     FLO_FC9(10240.7171413948890404),  FLO_FC9(10254.1321949414668779),
     FLO_FC9(10267.5516375131464883),  FLO_FC9(10280.9754662408140575),
     FLO_FC9(10294.4036782600396691),  FLO_FC9(10307.8362707110663905),
     FLO_FC9(10321.2732407387957210),  FLO_FC9(10334.7145854927803157),
     FLO_FC9(10348.1603021272039769),  FLO_FC9(10361.6103878008780157),
     FLO_FC9(10375.0648396772212436),  FLO_FC9(10388.5236549242581532),
     FLO_FC9(10401.9868307145934523),  FLO_FC9(10415.4543642254120641),
     FLO_FC9(10428.9262526384645753),  FLO_FC9(10442.4024931400490459),
     FLO_FC9(10455.8830829210073716),  FLO_FC9(10469.3680191767089127),
     FLO_FC9(10482.8572991070395801),  FLO_FC9(10496.3509199163927406),
     FLO_FC9(10509.8488788136528456),  FLO_FC9(10523.3511730121881556),
     FLO_FC9(10536.8577997298380069),  FLO_FC9(10550.3687561889000790),
     FLO_FC9(10563.8840396161212993),  FLO_FC9(10577.4036472426851105),
     FLO_FC9(10590.9275763041969185),  FLO_FC9(10604.4558240406786354),
     FLO_FC9(10617.9883876965559466),  FLO_FC9(10631.5252645206419402),
     FLO_FC9(10645.0664517661352875),  FLO_FC9(10658.6119466905984154),
     FLO_FC9(10672.1617465559556877),  FLO_FC9(10685.7158486284752144),
     FLO_FC9(10699.2742501787615765),  FLO_FC9(10712.8369484817467310),
     FLO_FC9(10726.4039408166754583),  FLO_FC9(10739.9752244670908112),
     FLO_FC9(10753.5507967208341142),  FLO_FC9(10767.1306548700267740),
     FLO_FC9(10780.7147962110575463),  FLO_FC9(10794.3032180445788981),
     FLO_FC9(10807.8959176754869986),  FLO_FC9(10821.4928924129217194),
     FLO_FC9(10835.0941395702484442),  FLO_FC9(10848.6996564650471555),
     FLO_FC9(10862.3094404191087960),  FLO_FC9(10875.9234887584152602),
     FLO_FC9(10889.5417988131375751),  FLO_FC9(10903.1643679176195292),
     FLO_FC9(10916.7911934103722160),  FLO_FC9(10930.4222726340558438),
     FLO_FC9(10944.0576029354797356),  FLO_FC9(10957.6971816655823204),
     FLO_FC9(10971.3410061794274952),  FLO_FC9(10984.9890738361900731),
     FLO_FC9(10998.6413819991485070),  FLO_FC9(11012.2979280356757954),
     FLO_FC9(11025.9587093172231107),  FLO_FC9(11039.6237232193161617),
     FLO_FC9(11053.2929671215406415),  FLO_FC9(11066.9664384075385897),
     FLO_FC9(11080.6441344649902021),  FLO_FC9(11094.3260526856083743),
     FLO_FC9(11108.0121904651277873),  FLO_FC9(11121.7025452032958128),
     FLO_FC9(11135.3971143038634182),  FLO_FC9(11149.0958951745706145),
     FLO_FC9(11162.7988852271428186),  FLO_FC9(11176.5060818772781204),
     FLO_FC9(11190.2174825446345494),  FLO_FC9(11203.9330846528282564),
     FLO_FC9(11217.6528856294153229),  FLO_FC9(11231.3768829058863048),
     FLO_FC9(11245.1050739176589559),  FLO_FC9(11258.8374561040618573),
     FLO_FC9(11272.5740269083325984),  FLO_FC9(11286.3147837776014057),
     FLO_FC9(11300.0597241628875054),  FLO_FC9(11313.8088455190827517),
     FLO_FC9(11327.5621453049516276),  FLO_FC9(11341.3196209831112355),
     FLO_FC9(11355.0812700200331165),  FLO_FC9(11368.8470898860232410),
     FLO_FC9(11382.6170780552183714),  FLO_FC9(11396.3912320055787859),
     FLO_FC9(11410.1695492188737262),  FLO_FC9(11423.9520271806759411),
     FLO_FC9(11437.7386633803489531),  FLO_FC9(11451.5294553110416018),
     FLO_FC9(11465.3244004696789489),  FLO_FC9(11479.1234963569513639),
     FLO_FC9(11492.9267404773036105),  FLO_FC9(11506.7341303389312088),
     FLO_FC9(11520.5456634537640639),  FLO_FC9(11534.3613373374664661),
     FLO_FC9(11548.1811495094225393),  FLO_FC9(11562.0050974927235075),
     FLO_FC9(11575.8331788141695142),  FLO_FC9(11589.6653910042532516),
     FLO_FC9(11603.5017315971490461),  FLO_FC9(11617.3421981307146780),
     FLO_FC9(11631.1867881464677339),  FLO_FC9(11645.0354991895892454),
     FLO_FC9(11658.8883288089109556),  FLO_FC9(11672.7452745569044055),
     FLO_FC9(11686.6063339896754769),  FLO_FC9(11700.4715046669552976),
     FLO_FC9(11714.3407841520856891),  FLO_FC9(11728.2141700120209862),
     FLO_FC9(11742.0916598173116654),  FLO_FC9(11755.9732511421007075),
     FLO_FC9(11769.8589415641108644),  FLO_FC9(11783.7487286646355642),
     FLO_FC9(11797.6426100285389111),  FLO_FC9(11811.5405832442374958),
     FLO_FC9(11825.4426459036967572),  FLO_FC9(11839.3487956024200685),
     FLO_FC9(11853.2590299394450994),  FLO_FC9(11867.1733465173329023),
     FLO_FC9(11881.0917429421551788),  FLO_FC9(11895.0142168234924611),
     FLO_FC9(11908.9407657744268363),  FLO_FC9(11922.8713874115255749),
     FLO_FC9(11936.8060793548393121),  FLO_FC9(11950.7448392278965912),
     FLO_FC9(11964.6876646576838539),  FLO_FC9(11978.6345532746527169),
     FLO_FC9(11992.5855027126999630),  FLO_FC9(12006.5405106091675407),
     FLO_FC9(12020.4995746048280125),  FLO_FC9(12034.4626923438790982),
     FLO_FC9(12048.4298614739382174),  FLO_FC9(12062.4010796460315760),
     FLO_FC9(12076.3763445145887090),  FLO_FC9(12090.3556537374315667),
     FLO_FC9(12104.3390049757690576),  FLO_FC9(12118.3263958941879537),
     FLO_FC9(12132.3178241606437950),  FLO_FC9(12146.3132874464572524),
     FLO_FC9(12160.3127834263032128),  FLO_FC9(12174.3163097782053228),
     FLO_FC9(12188.3238641835250746),  FLO_FC9(12202.3354443269545300),
     FLO_FC9(12216.3510478965108632),  FLO_FC9(12230.3706725835309044),
     FLO_FC9(12244.3943160826565872),  FLO_FC9(12258.4219760918313114),
     FLO_FC9(12272.4536503122963040),  FLO_FC9(12286.4893364485742495),
     FLO_FC9(12300.5290322084711079),  FLO_FC9(12314.5727353030579252),
     FLO_FC9(12328.6204434466781095),  FLO_FC9(12342.6721543569219648),
     FLO_FC9(12356.7278657546376053),  FLO_FC9(12370.7875753639091272),
     FLO_FC9(12384.8512809120547900),  FLO_FC9(12398.9189801296233782),
     FLO_FC9(12412.9906707503814687),  FLO_FC9(12427.0663505113061547),
     FLO_FC9(12441.1460171525814076),  FLO_FC9(12455.2296684175889823),
     FLO_FC9(12469.3173020529011410),  FLO_FC9(12483.4089158082697395),
     FLO_FC9(12497.5045074366298650),  FLO_FC9(12511.6040746940780082),
     FLO_FC9(12525.7076153398775205),  FLO_FC9(12539.8151271364440618),
     FLO_FC9(12553.9266078493419627),  FLO_FC9(12568.0420552472751297),
     FLO_FC9(12582.1614671020815877),  FLO_FC9(12596.2848411887262046),
     FLO_FC9(12610.4121752852897771),  FLO_FC9(12624.5434671729708498),
     FLO_FC9(12638.6787146360693441),  FLO_FC9(12652.8179154619847395),
     FLO_FC9(12666.9610674412087974),  FLO_FC9(12681.1081683673164662),
     FLO_FC9(12695.2592160369622434),  FLO_FC9(12709.4142082498692616),
     FLO_FC9(12723.5731428088274697),  FLO_FC9(12737.7360175196808996),
     FLO_FC9(12751.9028301913258474),  FLO_FC9(12766.0735786357035977),
     FLO_FC9(12780.2482606677876902),  FLO_FC9(12794.4268741055875580),
     FLO_FC9(12808.6094167701321567),  FLO_FC9(12822.7958864854681451),
     FLO_FC9(12836.9862810786526097),  FLO_FC9(12851.1805983797439694),
     FLO_FC9(12865.3788362218019756),  FLO_FC9(12879.5809924408713414),
     FLO_FC9(12893.7870648759835603),  FLO_FC9(12907.9970513691441738),
     FLO_FC9(12922.2109497653345898),  FLO_FC9(12936.4287579124957119),
     FLO_FC9(12950.6504736615243019),  FLO_FC9(12964.8760948662729788),
     FLO_FC9(12979.1056193835338490),  FLO_FC9(12993.3390450730385055),
     FLO_FC9(13007.5763697974543902),  FLO_FC9(13021.8175914223684231),
     FLO_FC9(13036.0627078162851831),  FLO_FC9(13050.3117168506287271),
     FLO_FC9(13064.5646163997225813),  FLO_FC9(13078.8214043407915597),
     FLO_FC9(13093.0820785539544886),  FLO_FC9(13107.3466369222169305),
     FLO_FC9(13121.6150773314657272),  FLO_FC9(13135.8873976704580855),
     FLO_FC9(13150.1635958308270347),  FLO_FC9(13164.4436697070595983),
     FLO_FC9(13178.7276171965022513),  FLO_FC9(13193.0154361993518251),
     FLO_FC9(13207.3071246186482313),  FLO_FC9(13221.6026803602653672),
     FLO_FC9(13235.9021013329111156),  FLO_FC9(13250.2053854481182498),
     FLO_FC9(13264.5125306202389766),  FLO_FC9(13278.8235347664340225),
     FLO_FC9(13293.1383958066762716),  FLO_FC9(13307.4571116637343948),
     FLO_FC9(13321.7796802631764876),  FLO_FC9(13336.1060995333555184),
     FLO_FC9(13350.4363674054093281),  FLO_FC9(13364.7704818132497167),
     FLO_FC9(13379.1084406935624429),  FLO_FC9(13393.4502419857963105),
     FLO_FC9(13407.7958836321577110),  FLO_FC9(13422.1453635776069859),
     FLO_FC9(13436.4986797698547889),  FLO_FC9(13450.8558301593457145),
     FLO_FC9(13465.2168126992655743),  FLO_FC9(13479.5816253455286642),
     FLO_FC9(13493.9502660567723069),  FLO_FC9(13508.3227327943495766),
     FLO_FC9(13522.6990235223292984),  FLO_FC9(13537.0791362074833160),
     FLO_FC9(13551.4630688192864909),  FLO_FC9(13565.8508193299057893),
     FLO_FC9(13580.2423857142002817),  FLO_FC9(13594.6377659497102286),
     FLO_FC9(13609.0369580166570813),  FLO_FC9(13623.4399598979271104),
     FLO_FC9(13637.8467695790805010),  FLO_FC9(13652.2573850483331626),
     FLO_FC9(13666.6718042965603672),  FLO_FC9(13681.0900253172840166),
     FLO_FC9(13695.5120461066690041),  FLO_FC9(13709.9378646635213954),
     FLO_FC9(13724.3674789892775152),  FLO_FC9(13738.8008870880039467),
     FLO_FC9(13753.2380869663847989),  FLO_FC9(13767.6790766337271634),
     FLO_FC9(13782.1238541019392869),  FLO_FC9(13796.5724173855451227),
     FLO_FC9(13811.0247645016588649),  FLO_FC9(13825.4808934699976817),
     FLO_FC9(13839.9408023128598870),  FLO_FC9(13854.4044890551340359),
     FLO_FC9(13868.8719517242825532),  FLO_FC9(13883.3431883503417339),
     FLO_FC9(13897.8181969659144670),  FLO_FC9(13912.2969756061684166),
     FLO_FC9(13926.7795223088251078),  FLO_FC9(13941.2658351141599269),
     FLO_FC9(13955.7559120649912074),  FLO_FC9(13970.2497512066820491),
     FLO_FC9(13984.7473505871257657),  FLO_FC9(13999.2487082567513426),
     FLO_FC9(14013.7538222685107030),  FLO_FC9(14028.2626906778732518),
     FLO_FC9(14042.7753115428276942),  FLO_FC9(14057.2916829238674836),
     FLO_FC9(14071.8118028839944600),  FLO_FC9(14086.3356694887042977),
     FLO_FC9(14100.8632808059937815),  FLO_FC9(14115.3946349063407979),
     FLO_FC9(14129.9297298627097916),  FLO_FC9(14144.4685637505481282),
     FLO_FC9(14159.0111346477697225),  FLO_FC9(14173.5574406347604963),
     FLO_FC9(14188.1074797943692829),  FLO_FC9(14202.6612502119005512),
     FLO_FC9(14217.2187499751180439),  FLO_FC9(14231.7799771742265875),
     FLO_FC9(14246.3449299018793681),  FLO_FC9(14260.9136062531633797),
     FLO_FC9(14275.4860043256012432),  FLO_FC9(14290.0621222191457491),
     FLO_FC9(14304.6419580361707631),  FLO_FC9(14319.2255098814657686),
     FLO_FC9(14333.8127758622358670),  FLO_FC9(14348.4037540880981396),
     FLO_FC9(14362.9984426710670959),  FLO_FC9(14377.5968397255601303),
     FLO_FC9(14392.1989433683884272),  FLO_FC9(14406.8047517187478661),
     FLO_FC9(14421.4142628982226597),  FLO_FC9(14436.0274750307744398),
     FLO_FC9(14450.6443862427404383),  FLO_FC9(14465.2649946628280304),
     FLO_FC9(14479.8892984221056395),  FLO_FC9(14494.5172956540045561),
     FLO_FC9(14509.1489844943134813),  FLO_FC9(14523.7843630811657931),
     FLO_FC9(14538.4234295550486422),  FLO_FC9(14553.0661820587811235),
     FLO_FC9(14567.7126187375270092),  FLO_FC9(14582.3627377387765591),
     FLO_FC9(14597.0165372123483394),  FLO_FC9(14611.6740153103819466),
     FLO_FC9(14626.3351701873398270),  FLO_FC9(14640.9999999999927240),
     FLO_FC9(14655.6685029074178601),  FLO_FC9(14670.3406770710025739),
     FLO_FC9(14685.0165206544261309),  FLO_FC9(14699.6960318236706371),
     FLO_FC9(14714.3792087469992111),  FLO_FC9(14729.0660495949668984),
     FLO_FC9(14743.7565525404079381),  FLO_FC9(14758.4507157584303059),
     FLO_FC9(14773.1485374264175334),  FLO_FC9(14787.8500157240177941),
     FLO_FC9(14802.5551488331420842),  FLO_FC9(14817.2639349379605846),
     FLO_FC9(14831.9763722248972044),  FLO_FC9(14846.6924588826241234),
     FLO_FC9(14861.4121931020599732),  FLO_FC9(14876.1355730763625616),
     FLO_FC9(14890.8625970009234152),  FLO_FC9(14905.5932630733714177),
     FLO_FC9(14920.3275694935582578),  FLO_FC9(14935.0655144635566103),
     FLO_FC9(14949.8070961876619549),  FLO_FC9(14964.5523128723816626),
     FLO_FC9(14979.3011627264313574),  FLO_FC9(14994.0536439607349166),
     FLO_FC9(15008.8097547884135565),  FLO_FC9(15023.5694934247876517),
     FLO_FC9(15038.3328580873694591),  FLO_FC9(15053.0998469958576607),
     FLO_FC9(15067.8704583721337258),  FLO_FC9(15082.6446904402637301),
     FLO_FC9(15097.4225414264838037),  FLO_FC9(15112.2040095592019497),
     FLO_FC9(15126.9890930689944071),  FLO_FC9(15141.7777901885965548),
     FLO_FC9(15156.5700991529047315),  FLO_FC9(15171.3660181989671401),
     FLO_FC9(15186.1655455659856671),  FLO_FC9(15200.9686794953013305),
     FLO_FC9(15215.7754182304015558),  FLO_FC9(15230.5857600169092620),
     FLO_FC9(15245.3997031025792239),  FLO_FC9(15260.2172457372980716),
     FLO_FC9(15275.0383861730733770),  FLO_FC9(15289.8631226640354726),
     FLO_FC9(15304.6914534664319945),  FLO_FC9(15319.5233768386206066),
     FLO_FC9(15334.3588910410690005),  FLO_FC9(15349.1979943363458005),
     FLO_FC9(15364.0406849891278398),  FLO_FC9(15378.8869612661765132),
     FLO_FC9(15393.7368214363559673),  FLO_FC9(15408.5902637706094538),
     FLO_FC9(15423.4472865419720620),  FLO_FC9(15438.3078880255543481),
     FLO_FC9(15453.1720664985423355),  FLO_FC9(15468.0398202401956951),
     FLO_FC9(15482.9111475318404700),  FLO_FC9(15497.7860466568690754),
     FLO_FC9(15512.6645159007330221),  FLO_FC9(15527.5465535509392794),
     FLO_FC9(15542.4321578970448172),  FLO_FC9(15557.3213272306602448),
     FLO_FC9(15572.2140598454352585),  FLO_FC9(15587.1103540370640985),
     FLO_FC9(15602.0102081032728165),  FLO_FC9(15616.9136203438229131),
     FLO_FC9(15631.8205890605058812),  FLO_FC9(15646.7311125571359298),
     FLO_FC9(15661.6451891395463463),  FLO_FC9(15676.5628171155931341),
     FLO_FC9(15691.4839947951386421),  FLO_FC9(15706.4087204900624783),
     FLO_FC9(15721.3369925142415013),  FLO_FC9(15736.2688091835607338),
     FLO_FC9(15751.2041688159006299),  FLO_FC9(15766.1430697311352560),
     FLO_FC9(15781.0855102511322912),  FLO_FC9(15796.0314886997402937),
     FLO_FC9(15810.9810034027977963),  FLO_FC9(15825.9340526881187543),
     FLO_FC9(15840.8906348854889075),  FLO_FC9(15855.8507483266730560),
     FLO_FC9(15870.8143913454005087),  FLO_FC9(15885.7815622773614450),
     FLO_FC9(15900.7522594602141908),  FLO_FC9(15915.7264812335652095),
     FLO_FC9(15930.7042259389836545),  FLO_FC9(15945.6854919199777214),
     FLO_FC9(15960.6702775220092008),  FLO_FC9(15975.6585810924807447),
     FLO_FC9(15990.6504009807304101),  FLO_FC9(16005.6457355380352965),
     FLO_FC9(16020.6445831175988133),  FLO_FC9(16035.6469420745561365),
     FLO_FC9(16050.6528107659669331),  FLO_FC9(16065.6621875508062658),
     FLO_FC9(16080.6750707899736881),  FLO_FC9(16095.6914588462732354),
     FLO_FC9(16110.7113500844243390),  FLO_FC9(16125.7347428710527311),
     FLO_FC9(16140.7616355746849877),  FLO_FC9(16155.7920265657467098),
     FLO_FC9(16170.8259142165607045),  FLO_FC9(16185.8632969013378897),
     FLO_FC9(16200.9041729961827514),  FLO_FC9(16215.9485408790787915),
     FLO_FC9(16230.9963989298994420),  FLO_FC9(16246.0477455303862371),
     FLO_FC9(16261.1025790641633648),  FLO_FC9(16276.1608979167212965),
     FLO_FC9(16291.2227004754204245),  FLO_FC9(16306.2879851294837863),
     FLO_FC9(16321.3567502699952456),  FLO_FC9(16336.4289942898958543),
     FLO_FC9(16351.5047155839820334),  FLO_FC9(16366.5839125489001162),
     FLO_FC9(16381.6665835831408913),  FLO_FC9(16396.7527270870414213),
     FLO_FC9(16411.8423414627759485),  FLO_FC9(16426.9354251143631700),
     FLO_FC9(16442.0319764476444107),  FLO_FC9(16457.1319938702981744),
     FLO_FC9(16472.2354757918292307),  FLO_FC9(16487.3424206235613383),
     FLO_FC9(16502.4528267786408833),  FLO_FC9(16517.5666926720332413),
     FLO_FC9(16532.6840167205155012),  FLO_FC9(16547.8047973426764656),
     FLO_FC9(16562.9290329589020985),  FLO_FC9(16578.0567219913937151),
     FLO_FC9(16593.1878628641497926),  FLO_FC9(16608.3224540029623313),
     FLO_FC9(16623.4604938354168553),  FLO_FC9(16638.6019807908960502),
     FLO_FC9(16653.7469133005579351),  FLO_FC9(16668.8952897973540530),
     FLO_FC9(16684.0471087160149182),  FLO_FC9(16699.2023684930463787),
     FLO_FC9(16714.3610675667259784),  FLO_FC9(16729.5232043771065946),
     FLO_FC9(16744.6887773660091625),  FLO_FC9(16759.8577849770117609),
     FLO_FC9(16775.0302256554641644),  FLO_FC9(16790.2060978484660154),
     FLO_FC9(16805.3854000048741000),  FLO_FC9(16820.5681305753023480),
     FLO_FC9(16835.7542880121036433),  FLO_FC9(16850.9438707693807373),
     FLO_FC9(16866.1368773029826116),  FLO_FC9(16881.3333060704935633),
     FLO_FC9(16896.5331555312295677),  FLO_FC9(16911.7364241462491918),
     FLO_FC9(16926.9431103783317667),  FLO_FC9(16942.1532126919919392),
     FLO_FC9(16957.3667295534542063),  FLO_FC9(16972.5836594306820189),
     FLO_FC9(16987.8040007933377638),  FLO_FC9(17003.0277521128155058),
     FLO_FC9(17018.2549118622046080),  FLO_FC9(17033.4854785163115594),
     FLO_FC9(17048.7194505516454228),  FLO_FC9(17063.9568264464214735),
     FLO_FC9(17079.1976046805466467),  FLO_FC9(17094.4417837356304517),
     FLO_FC9(17109.6893620949667820),  FLO_FC9(17124.9403382435521053),
     FLO_FC9(17140.1947106680636352),  FLO_FC9(17155.4524778568520560),
     FLO_FC9(17170.7136382999669877),  FLO_FC9(17185.9781904891278828),
     FLO_FC9(17201.2461329177240259),  FLO_FC9(17216.5174640808254480),
     FLO_FC9(17231.7921824751647364),  FLO_FC9(17247.0702865991406725),
     FLO_FC9(17262.3517749528255081),  FLO_FC9(17277.6366460379358614),
     FLO_FC9(17292.9248983578545449),  FLO_FC9(17308.2165304176232894),
     FLO_FC9(17323.5115407239209162),  FLO_FC9(17338.8099277850888029),
     FLO_FC9(17354.1116901111054176),  FLO_FC9(17369.4168262135935947),
     FLO_FC9(17384.7253346058205352),  FLO_FC9(17400.0372138026832545),
     FLO_FC9(17415.3524623207158584),  FLO_FC9(17430.6710786780895432),
     FLO_FC9(17445.9930613945871301),  FLO_FC9(17461.3184089916358062),
     FLO_FC9(17476.6471199922743835),  FLO_FC9(17491.9791929211678507),
     FLO_FC9(17507.3146263045855449),  FLO_FC9(17522.6534186704229796),
     FLO_FC9(17537.9955685481872933),  FLO_FC9(17553.3410744689863350),
     FLO_FC9(17568.6899349655359401),  FLO_FC9(17584.0421485721562931),
     FLO_FC9(17599.3977138247682888),  FLO_FC9(17614.7566292608898948),
     FLO_FC9(17630.1188934196252376),  FLO_FC9(17645.4845048416827922),
     FLO_FC9(17660.8534620693535544),  FLO_FC9(17676.2257636465110409),
     FLO_FC9(17691.6014081186185649),  FLO_FC9(17706.9803940327183227),
     FLO_FC9(17722.3627199374241172),  FLO_FC9(17737.7483843829359103),
     FLO_FC9(17753.1373859210143564),  FLO_FC9(17768.5297231049989932),
     FLO_FC9(17783.9253944897900510),  FLO_FC9(17799.3243986318557290),
     FLO_FC9(17814.7267340892249194),  FLO_FC9(17830.1323994214799313),
     FLO_FC9(17845.5413931897674047),  FLO_FC9(17860.9537139567801205),
     FLO_FC9(17876.3693602867715526),  FLO_FC9(17891.7883307455304021),
     FLO_FC9(17907.2106239003951487),  FLO_FC9(17922.6362383202540514),
     FLO_FC9(17938.0651725755269581),  FLO_FC9(17953.4974252381762199),
     FLO_FC9(17968.9329948816921387),  FLO_FC9(17984.3718800811038818),
     FLO_FC9(17999.8140794129722053),  FLO_FC9(18015.2595914553712646),
     FLO_FC9(18030.7084147879140801),  FLO_FC9(18046.1605479917307093),
     FLO_FC9(18061.6159896494646091),  FLO_FC9(18077.0747383452835493),
     FLO_FC9(18092.5367926648614230),  FLO_FC9(18108.0021511953927984),
     FLO_FC9(18123.4708125255710911),  FLO_FC9(18138.9427752455994778),
     FLO_FC9(18154.4180379471908964),  FLO_FC9(18169.8965992235462181),
     FLO_FC9(18185.3784576693797135),  FLO_FC9(18200.8636118808863102),
     FLO_FC9(18216.3520604557670595),  FLO_FC9(18231.8438019932036696),
     FLO_FC9(18247.3388350938730582),  FLO_FC9(18262.8371583599364385),
     FLO_FC9(18278.3387703950320429),  FLO_FC9(18293.8436698042896751),
     FLO_FC9(18309.3518551943088823),  FLO_FC9(18324.8633251731662313),
     FLO_FC9(18340.3780783504116698),  FLO_FC9(18355.8961133370685275),
     FLO_FC9(18371.4174287456226011),  FLO_FC9(18386.9420231900330691),
     FLO_FC9(18402.4698952857179393),  FLO_FC9(18418.0010436495504109),
     FLO_FC9(18433.5354668998697889),  FLO_FC9(18449.0731636564742075),
     FLO_FC9(18464.6141325406024407),  FLO_FC9(18480.1583721749557299),
     FLO_FC9(18495.7058811836759560),  FLO_FC9(18511.2566581923565536),
     FLO_FC9(18526.8107018280352349),  FLO_FC9(18542.3680107191830757),
     FLO_FC9(18557.9285834957154293),  FLO_FC9(18573.4924187889846507),
     FLO_FC9(18589.0595152317728207),  FLO_FC9(18604.6298714583026594),
     FLO_FC9(18620.2034861042120610),  FLO_FC9(18635.7803578065795591),
     FLO_FC9(18651.3604852038988611),  FLO_FC9(18666.9438669360861240),
     FLO_FC9(18682.5305016444799548),  FLO_FC9(18698.1203879718414100),
     FLO_FC9(18713.7135245623321680),  FLO_FC9(18729.3099100615399948),
     FLO_FC9(18744.9095431164569163),  FLO_FC9(18760.5124223754792183),
     FLO_FC9(18776.1185464884183602),  FLO_FC9(18791.7279141064791474),
     FLO_FC9(18807.3405238822742831),  FLO_FC9(18822.9563744698098162),
     FLO_FC9(18838.5754645244887797),  FLO_FC9(18854.1977927031111903),
     FLO_FC9(18869.8233576638631348),  FLO_FC9(18885.4521580663276836),
     FLO_FC9(18901.0841925714703393),  FLO_FC9(18916.7194598416390363),
     FLO_FC9(18932.3579585405641410),  FLO_FC9(18947.9996873333620897),
     FLO_FC9(18963.6446448865208367),  FLO_FC9(18979.2928298679071304),
     FLO_FC9(18994.9442409467592370),  FLO_FC9(19010.5988767936869408),
     FLO_FC9(19026.2567360806679062),  FLO_FC9(19041.9178174810476776),
     FLO_FC9(19057.5821196695324033),  FLO_FC9(19073.2496413221997500),
     FLO_FC9(19088.9203811164734361),  FLO_FC9(19104.5943377311450604),
     FLO_FC9(19120.2715098463559116),  FLO_FC9(19135.9518961436042446),
     FLO_FC9(19151.6354953057380044),  FLO_FC9(19167.3223060169475502),
     FLO_FC9(19183.0123269627838454),  FLO_FC9(19198.7055568301220774),
     FLO_FC9(19214.4019943071980379),  FLO_FC9(19230.1016380835790187),
     FLO_FC9(19245.8044868501674500),  FLO_FC9(19261.5105392992081761),
     FLO_FC9(19277.2197941242739034),  FLO_FC9(19292.9322500202652009),
     FLO_FC9(19308.6479056834214134),  FLO_FC9(19324.3667598113024724),
     FLO_FC9(19340.0888111027925333),  FLO_FC9(19355.8140582580999762),
     FLO_FC9(19371.5424999787537672),  FLO_FC9(19387.2741349675998208),
     FLO_FC9(19403.0089619287973619),  FLO_FC9(19418.7469795678225637),
     FLO_FC9(19434.4881865914685477),  FLO_FC9(19450.2325817078271939),
     FLO_FC9(19465.9801636263036926),  FLO_FC9(19481.7309310576129064),
     FLO_FC9(19497.4848827137611806),  FLO_FC9(19513.2420173080681707),
     FLO_FC9(19529.0023335551413766),  FLO_FC9(19544.7658301708979707),
     FLO_FC9(19560.5325058725393319),  FLO_FC9(19576.3023593785655976),
     FLO_FC9(19592.0753894087611116),  FLO_FC9(19607.8515946842089761),
     FLO_FC9(19623.6309739272692241),  FLO_FC9(19639.4135258615897328),
     FLO_FC9(19655.1992492121025862),  FLO_FC9(19670.9881427050167986),
     FLO_FC9(19686.7802050678255910),  FLO_FC9(19702.5754350292882009),
     FLO_FC9(19718.3738313194480725),  FLO_FC9(19734.1753926696146664),
     FLO_FC9(19749.9801178123707359),  FLO_FC9(19765.7880054815686890),
     FLO_FC9(19781.5990544123233121),  FLO_FC9(19797.4132633410081326),
     FLO_FC9(19813.2306310052736080),  FLO_FC9(19829.0511561440143851),
     FLO_FC9(19844.8748374973947648),  FLO_FC9(19860.7016738068268751),
     FLO_FC9(19876.5316638149852224),  FLO_FC9(19892.3648062657885021),
     FLO_FC9(19908.2010999044068740),  FLO_FC9(19924.0405434772583249),
     FLO_FC9(19939.8831357320123061),  FLO_FC9(19955.7288754175788199),
     FLO_FC9(19971.5777612841047812),  FLO_FC9(19987.4297920829849318),
     FLO_FC9(20003.2849665668472880),  FLO_FC9(20019.1432834895604174),
     FLO_FC9(20035.0047416062188859),  FLO_FC9(20050.8693396731614484),
     FLO_FC9(20066.7370764479419449),  FLO_FC9(20082.6079506893620419),
     FLO_FC9(20098.4819611574275768),  FLO_FC9(20114.3591066133849381),
     FLO_FC9(20130.2393858196992369),  FLO_FC9(20146.1227975400543073),
     FLO_FC9(20162.0093405393527064),  FLO_FC9(20177.8990135837157140),
     FLO_FC9(20193.7918154404760571),  FLO_FC9(20209.6877448781815474),
     FLO_FC9(20225.5868006665914436),  FLO_FC9(20241.4889815766691754),
     FLO_FC9(20257.3942863805968955),  FLO_FC9(20273.3027138517536514),
     FLO_FC9(20289.2142627647153859),  FLO_FC9(20305.1289318952767644),
     FLO_FC9(20321.0467200204147957),  FLO_FC9(20336.9676259183179354),
     FLO_FC9(20352.8916483683606202),  FLO_FC9(20368.8187861511141818),
     FLO_FC9(20384.7490380483468471),  FLO_FC9(20400.6824028430091857),
     FLO_FC9(20416.6188793192486628),  FLO_FC9(20432.5584662623914483),
     FLO_FC9(20448.5011624589533312),  FLO_FC9(20464.4469666966288059),
     FLO_FC9(20480.3958777643019857),  FLO_FC9(20496.3478944520247751),
     FLO_FC9(20512.3030155510314216),  FLO_FC9(20528.2612398537348781),
     FLO_FC9(20544.2225661537195265),  FLO_FC9(20560.1869932457411778),
     FLO_FC9(20576.1545199257197964),  FLO_FC9(20592.1251449907576898),
     FLO_FC9(20608.0988672391067666),  FLO_FC9(20624.0756854701976408),
     FLO_FC9(20640.0555984846178035),  FLO_FC9(20656.0386050841152610),
     FLO_FC9(20672.0247040715948970),  FLO_FC9(20688.0138942511257483),
     FLO_FC9(20704.0061744279264531),  FLO_FC9(20720.0015434083725268),
     FLO_FC9(20735.9999999999890861),  FLO_FC9(20752.0015430114544870),
     FLO_FC9(20768.0061712525966868),  FLO_FC9(20784.0138835343823303),
     FLO_FC9(20800.0246786689313012),  FLO_FC9(20816.0385554695058090),
     FLO_FC9(20832.0555127505067503),  FLO_FC9(20848.0755493274737091),
     FLO_FC9(20864.0986640170849569),  FLO_FC9(20880.1248556371610903),
     FLO_FC9(20896.1541230066468415),  FLO_FC9(20912.1864649456256302),
     FLO_FC9(20928.2218802753122873),  FLO_FC9(20944.2603678180494171),
     FLO_FC9(20960.3019263973110355),  FLO_FC9(20976.3465548376843799),
     FLO_FC9(20992.3942519648953748),  FLO_FC9(21008.4450166057868046),
     FLO_FC9(21024.4988475883183128),  FLO_FC9(21040.5557437415736786),
     FLO_FC9(21056.6157038957535406),  FLO_FC9(21072.6787268821681209),
     FLO_FC9(21088.7448115332517773),  FLO_FC9(21104.8139566825375368),
     FLO_FC9(21120.8861611646825622),  FLO_FC9(21136.9614238154390478),
     FLO_FC9(21153.0397434716833232),  FLO_FC9(21169.1211189713794738),
     FLO_FC9(21185.2055491536048066),  FLO_FC9(21201.2930328585352981),
     FLO_FC9(21217.3835689274528704),  FLO_FC9(21233.4771562027308391),
     FLO_FC9(21249.5737935278411896),  FLO_FC9(21265.6734797473582148),
     FLO_FC9(21281.7762137069366872),  FLO_FC9(21297.8819942533336871),
     FLO_FC9(21313.9908202343976882),  FLO_FC9(21330.1026904990540061),
     FLO_FC9(21346.2176038973302639),  FLO_FC9(21362.3355592803272884),
     FLO_FC9(21378.4565555002409383),  FLO_FC9(21394.5805914103329997),
     FLO_FC9(21410.7076658649639285),  FLO_FC9(21426.8377777195564704),
     FLO_FC9(21442.9709258306284028),  FLO_FC9(21459.1071090557561547),
     FLO_FC9(21475.2463262536039110),  FLO_FC9(21491.3885762838945084),
     FLO_FC9(21507.5338580074312631),  FLO_FC9(21523.6821702860870573),
     FLO_FC9(21539.8335119827970630),  FLO_FC9(21555.9878819615660177),
     FLO_FC9(21572.1452790874609491),  FLO_FC9(21588.3057022266148124),
     FLO_FC9(21604.4691502462155768),  FLO_FC9(21620.6356220145207772),
     FLO_FC9(21636.8051164008320484),  FLO_FC9(21652.9776322755205911),
     FLO_FC9(21669.1531685100089817),  FLO_FC9(21685.3317239767638966),
     FLO_FC9(21701.5132975493179401),  FLO_FC9(21717.6978881022441783),
     FLO_FC9(21733.8854945111670531),  FLO_FC9(21750.0761156527587445),
     FLO_FC9(21766.2697504047355324),  FLO_FC9(21782.4663976458614343),
     FLO_FC9(21798.6660562559336540),  FLO_FC9(21814.8687251158007712),
     FLO_FC9(21831.0744031073445512),  FLO_FC9(21847.2830891134835838),
     FLO_FC9(21863.4947820181769202),  FLO_FC9(21879.7094807064167981),
     FLO_FC9(21895.9271840642286406),  FLO_FC9(21912.1478909786674194),
     FLO_FC9(21928.3716003378176538),  FLO_FC9(21944.5983110307970492),
     FLO_FC9(21960.8280219477455830),  FLO_FC9(21977.0607319798291428),
     FLO_FC9(21993.2964400192431640),  FLO_FC9(22009.5351449591980781),
     FLO_FC9(22025.7768456939302268),  FLO_FC9(22042.0215411186909478),
     FLO_FC9(22058.2692301297574886),  FLO_FC9(22074.5199116244111792),
     FLO_FC9(22090.7735845009592595),  FLO_FC9(22107.0302476587166893),
     FLO_FC9(22123.2898999980134249),  FLO_FC9(22139.5525404201871424),
     FLO_FC9(22155.8181678275868762),  FLO_FC9(22172.0867811235693807),
     FLO_FC9(22188.3583792124954925),  FLO_FC9(22204.6329609997301304),
     FLO_FC9(22220.9105253916386573),  FLO_FC9(22237.1910712956014322),
     FLO_FC9(22253.4745976199810684),  FLO_FC9(22269.7611032741478994),
     FLO_FC9(22286.0505871684690646),  FLO_FC9(22302.3430482143121480),
     FLO_FC9(22318.6384853240269877),  FLO_FC9(22334.9368974109675037),
     FLO_FC9(22351.2382833894698706),  FLO_FC9(22367.5426421748707071),
     FLO_FC9(22383.8499726834816101),  FLO_FC9(22400.1602738326182589),
     FLO_FC9(22416.4735445405676728),  FLO_FC9(22432.7897837266027636),
     FLO_FC9(22449.1089903109859733),  FLO_FC9(22465.4311632149583602),
     FLO_FC9(22481.7563013607395987),  FLO_FC9(22498.0844036715279799),
     FLO_FC9(22514.4154690714967728),  FLO_FC9(22530.7494964858015010),
     FLO_FC9(22547.0864848405617522),  FLO_FC9(22563.4264330628793687),
     FLO_FC9(22579.7693400808238948),  FLO_FC9(22596.1152048234362155),
     FLO_FC9(22612.4640262207212800),  FLO_FC9(22628.8158032036553777),
     FLO_FC9(22645.1705347041788627),  FLO_FC9(22661.5282196551997913),
     FLO_FC9(22677.8888569905866461),  FLO_FC9(22694.2524456451683363),
     FLO_FC9(22710.6189845547341974),  FLO_FC9(22726.9884726560339914),
     FLO_FC9(22743.3609088867779064),  FLO_FC9(22759.7362921856220055),
     FLO_FC9(22776.1146214921864157),  FLO_FC9(22792.4958957470444147),
     FLO_FC9(22808.8801138917187927),  FLO_FC9(22825.2672748686782143),
     FLO_FC9(22841.6573776213481324),  FLO_FC9(22858.0504210940962366),
     FLO_FC9(22874.4464042322433670),  FLO_FC9(22890.8453259820526000),
     FLO_FC9(22907.2471852907219727),  FLO_FC9(22923.6519811064063106),
     FLO_FC9(22940.0597123781953997),  FLO_FC9(22956.4703780561139865),
     FLO_FC9(22972.8839770911290543),  FLO_FC9(22989.3005084351498226),
     FLO_FC9(23005.7199710410168336),  FLO_FC9(23022.1423638624983141),
     FLO_FC9(23038.5676858543047274),  FLO_FC9(23054.9959359720778593),
     FLO_FC9(23071.4271131723871804),  FLO_FC9(23087.8612164127298456),
     FLO_FC9(23104.2982446515306947),  FLO_FC9(23120.7381968481458898),
     FLO_FC9(23137.1810719628483639),  FLO_FC9(23153.6268689568460104),
     FLO_FC9(23170.0755867922634934),  FLO_FC9(23186.5272244321422477),
     FLO_FC9(23202.9817808404477546),  FLO_FC9(23219.4392549820659042),
     FLO_FC9(23235.8996458227957191),  FLO_FC9(23252.3629523293566308),
     FLO_FC9(23268.8291734693775652),  FLO_FC9(23285.2983082114078570),
     FLO_FC9(23301.7703555248990597),  FLO_FC9(23318.2453143802231352),
     FLO_FC9(23334.7231837486579025),  FLO_FC9(23351.2039626023870369),
     FLO_FC9(23367.6876499145037087),  FLO_FC9(23384.1742446590069449),
     FLO_FC9(23400.6637458107979910),  FLO_FC9(23417.1561523456803116),
     FLO_FC9(23433.6514632403668656),  FLO_FC9(23450.1496774724619172),
     FLO_FC9(23466.6507940204719489),  FLO_FC9(23483.1548118638056621),
     FLO_FC9(23499.6617299827630632),  FLO_FC9(23516.1715473585391010),
     FLO_FC9(23532.6842629732309433),  FLO_FC9(23549.1998758098234248),
     FLO_FC9(23565.7183848521854088),  FLO_FC9(23582.2397890850916156),
     FLO_FC9(23598.7640874941971560),  FLO_FC9(23615.2912790660411702),
     FLO_FC9(23631.8213627880577405),  FLO_FC9(23648.3543376485649787),
     FLO_FC9(23664.8902026367613871),  FLO_FC9(23681.4289567427331349),
     FLO_FC9(23697.9705989574431442),  FLO_FC9(23714.5151282727383659),
     FLO_FC9(23731.0625436813425040),  FLO_FC9(23747.6128441768632911),
     FLO_FC9(23764.1660287537779368),  FLO_FC9(23780.7220964074404037),
     FLO_FC9(23797.2810461340850452),  FLO_FC9(23813.8428769308156916),
     FLO_FC9(23830.4075877956056502),  FLO_FC9(23846.9751777273013431),
     FLO_FC9(23863.5456457256223075),  FLO_FC9(23880.1189907911502814),
     FLO_FC9(23896.6952119253364799),  FLO_FC9(23913.2743081304979569),
     FLO_FC9(23929.8562784098212433),  FLO_FC9(23946.4411217673477950),
     FLO_FC9(23963.0288372079885448),  FLO_FC9(23979.6194237375129887),
     FLO_FC9(23996.2128803625491855),  FLO_FC9(24012.8092060905837570),
     FLO_FC9(24029.4083999299655261),  FLO_FC9(24046.0104608898982406),
     FLO_FC9(24062.6153879804332973),  FLO_FC9(24079.2231802124915703),
     FLO_FC9(24095.8338365978270303),  FLO_FC9(24112.4473561490631255),
     FLO_FC9(24129.0637378796673147),  FLO_FC9(24145.6829808039510681),
     FLO_FC9(24162.3050839370807807),  FLO_FC9(24178.9300462950668589),
     FLO_FC9(24195.5578668947673577),  FLO_FC9(24212.1885447538843437),
     FLO_FC9(24228.8220788909602561),  FLO_FC9(24245.4584683253888215),
     FLO_FC9(24262.0977120773968636),  FLO_FC9(24278.7398091680479411),
     FLO_FC9(24295.3847586192605377),  FLO_FC9(24312.0325594537680445),
     FLO_FC9(24328.6832106951624155),  FLO_FC9(24345.3367113678577880),
     FLO_FC9(24361.9930604971086723),  FLO_FC9(24378.6522571089953999),
     FLO_FC9(24395.3143002304423135),  FLO_FC9(24411.9791888891923008),
     FLO_FC9(24428.6469221138249850),  FLO_FC9(24445.3174989337458101),
     FLO_FC9(24461.9909183791933174),  FLO_FC9(24478.6671794812245935),
     FLO_FC9(24495.3462812717261841),  FLO_FC9(24512.0282227834068181),
     FLO_FC9(24528.7130030498010456),  FLO_FC9(24545.4006211052655999),
     FLO_FC9(24562.0910759849757596),  FLO_FC9(24578.7843667249253485),
     FLO_FC9(24595.4804923619267356),  FLO_FC9(24612.1794519336144731),
     FLO_FC9(24628.8812444784380205),  FLO_FC9(24645.5858690356544685),
     FLO_FC9(24662.2933246453430911),  FLO_FC9(24679.0036103483980696),
     FLO_FC9(24695.7167251865139406),  FLO_FC9(24712.4326682022110617),
     FLO_FC9(24729.1514384388065082),  FLO_FC9(24745.8730349404359004),
     FLO_FC9(24762.5974567520315759),  FLO_FC9(24779.3247029193444178),
     FLO_FC9(24796.0547724889256642),  FLO_FC9(24812.7876645081232709),
     FLO_FC9(24829.5233780251001008),  FLO_FC9(24846.2619120888193720),
     FLO_FC9(24863.0032657490337442),  FLO_FC9(24879.7474380563071463),
     FLO_FC9(24896.4944280620038626),  FLO_FC9(24913.2442348182776186),
     FLO_FC9(24929.9968573780824954),  FLO_FC9(24946.7522947951656533),
     FLO_FC9(24963.5105461240782461),  FLO_FC9(24980.2716104201572307),
     FLO_FC9(24997.0354867395253677),  FLO_FC9(25013.8021741391130490),
     FLO_FC9(25030.5716716766291938),  FLO_FC9(25047.3439784105721628),
     FLO_FC9(25064.1190934002370341),  FLO_FC9(25080.8970157056974131),
     FLO_FC9(25097.6777443878127087),  FLO_FC9(25114.4612785082390474),
     FLO_FC9(25131.2476171294001688),  FLO_FC9(25148.0367593145165301),
     FLO_FC9(25164.8287041275834781),  FLO_FC9(25181.6234506333748868),
     FLO_FC9(25198.4209978974504338),  FLO_FC9(25215.2213449861446861),
     FLO_FC9(25232.0244909665743762),  FLO_FC9(25248.8304349066274881),
     FLO_FC9(25265.6391758749741712),  FLO_FC9(25282.4507129410485504),
     FLO_FC9(25299.2650451750705543),  FLO_FC9(25316.0821716480240866),
     FLO_FC9(25332.9020914316679409),  FLO_FC9(25349.7248035985321621),
     FLO_FC9(25366.5503072219144087),  FLO_FC9(25383.3786013758835907),
     FLO_FC9(25400.2096851352689555),  FLO_FC9(25417.0435575756782782),
     FLO_FC9(25433.8802177734723955),  FLO_FC9(25450.7196648057833954),
     FLO_FC9(25467.5618977505073417),  FLO_FC9(25484.4069156862969976),
     FLO_FC9(25501.2547176925727399),  FLO_FC9(25518.1053028495116450),
     FLO_FC9(25534.9586702380511269),  FLO_FC9(25551.8148189398889372),
     FLO_FC9(25568.6737480374795268),  FLO_FC9(25585.5354566140267707),
     FLO_FC9(25602.3999437535021571),  FLO_FC9(25619.2672085406193219),
     FLO_FC9(25636.1372500608522387),  FLO_FC9(25653.0100674004315806),
     FLO_FC9(25669.8856596463265305),  FLO_FC9(25686.7640258862702467),
     FLO_FC9(25703.6451652087343973),  FLO_FC9(25720.5290767029473500),
     FLO_FC9(25737.4157594588759821),  FLO_FC9(25754.3052125672438706),
     FLO_FC9(25771.1974351195167401),  FLO_FC9(25788.0924262078988249),
     FLO_FC9(25804.9901849253437831),  FLO_FC9(25821.8907103655474202),
     FLO_FC9(25838.7940016229440516),  FLO_FC9(25855.7000577927174163),
     FLO_FC9(25872.6088779707752110),  FLO_FC9(25889.5204612537781941),
     FLO_FC9(25906.4348067391183577),  FLO_FC9(25923.3519135249225656),
     FLO_FC9(25940.2717807100634673),  FLO_FC9(25957.1944073941376701),
     FLO_FC9(25974.1197926774766529),  FLO_FC9(25991.0479356611540425),
     FLO_FC9(26007.9788354469637852),  FLO_FC9(26024.9124911374419753),
     FLO_FC9(26041.8489018358413887),  FLO_FC9(26058.7880666461605870),
     FLO_FC9(26075.7299846731075377),  FLO_FC9(26092.6746550221323560),
     FLO_FC9(26109.6220767994091148),  FLO_FC9(26126.5722491118285689),
     FLO_FC9(26143.5251710670163448),  FLO_FC9(26160.4808417733147508),
     FLO_FC9(26177.4392603397900530),  FLO_FC9(26194.4004258762288373),
     FLO_FC9(26211.3643374931452854),  FLO_FC9(26228.3309943017666228),
     FLO_FC9(26245.3003954140403948),  FLO_FC9(26262.2725399426271906),
     FLO_FC9(26279.2474270009188331),  FLO_FC9(26296.2250557030056370),
     FLO_FC9(26313.2054251637018751),  FLO_FC9(26330.1885344985385018),
     FLO_FC9(26347.1743828237558773),  FLO_FC9(26364.1629692563074059),
     FLO_FC9(26381.1542929138522595),  FLO_FC9(26398.1483529147735680),
     FLO_FC9(26415.1451483781493152),  FLO_FC9(26432.1446784237778047),
     FLO_FC9(26449.1469421721558319),  FLO_FC9(26466.1519387444932363),
     FLO_FC9(26483.1596672627019871),  FLO_FC9(26500.1701268494034593),
     FLO_FC9(26517.1833166279211582),  FLO_FC9(26534.1992357222770806),
     FLO_FC9(26551.2178832571989915),  FLO_FC9(26568.2392583581204235),
     FLO_FC9(26585.2633601511734014),  FLO_FC9(26602.2901877631811658),
     FLO_FC9(26619.3197403216763632),  FLO_FC9(26636.3520169548828562),
     FLO_FC9(26653.3870167917266372),  FLO_FC9(26670.4247389618249144),
     FLO_FC9(26687.4651825954933884),  FLO_FC9(26704.5083468237389752),
     FLO_FC9(26721.5542307782670832),  FLO_FC9(26738.6028335914670606),
     FLO_FC9(26755.6541543964303855),  FLO_FC9(26772.7081923269288382),
     FLO_FC9(26789.7649465174326906),  FLO_FC9(26806.8244161030961550),
     FLO_FC9(26823.8866002197610214),  FLO_FC9(26840.9514980039602960),
     FLO_FC9(26858.0191085929145629),  FLO_FC9(26875.0894311245174322),
     FLO_FC9(26892.1624647373646440),  FLO_FC9(26909.2382085707213264),
     FLO_FC9(26926.3166617645474616),  FLO_FC9(26943.3978234594724199),
     FLO_FC9(26960.4816927968131495),  FLO_FC9(26977.5682689185741765),
     FLO_FC9(26994.6575509674221394),  FLO_FC9(27011.7495380867221684),
     FLO_FC9(27028.8442294204978680),  FLO_FC9(27045.9416241134640586),
     FLO_FC9(27063.0417213110049488),  FLO_FC9(27080.1445201591814111),
     FLO_FC9(27097.2500198047273443),  FLO_FC9(27114.3582193950496730),
     FLO_FC9(27131.4691180782356241),  FLO_FC9(27148.5827150030308985),
     FLO_FC9(27165.6990093188578612),  FLO_FC9(27182.8180001758155413),
     FLO_FC9(27199.9396867246650800),  FLO_FC9(27217.0640681168370065),
     FLO_FC9(27234.1911435044276004),  FLO_FC9(27251.3209120402025292),
     FLO_FC9(27268.4533728775932104),  FLO_FC9(27285.5885251706931740),
     FLO_FC9(27302.7263680742689758),  FLO_FC9(27319.8669007437347318),
     FLO_FC9(27337.0101223351812223),  FLO_FC9(27354.1560320053577016),
     FLO_FC9(27371.3046289116682601),  FLO_FC9(27388.4559122121827386),
     FLO_FC9(27405.6098810656258138),  FLO_FC9(27422.7665346313879127),
     FLO_FC9(27439.9258720695070224),  FLO_FC9(27457.0878925406832423),
     FLO_FC9(27474.2525952062751458),  FLO_FC9(27491.4199792282925046),
     FLO_FC9(27508.5900437693999265),  FLO_FC9(27525.7627879929168557),
     FLO_FC9(27542.9382110628102964),  FLO_FC9(27560.1163121437057271),
     FLO_FC9(27577.2970904008761863),  FLO_FC9(27594.4805450002422731),
     FLO_FC9(27611.6666751083830604),  FLO_FC9(27628.8554798925179057),
     FLO_FC9(27646.0469585205137264),  FLO_FC9(27663.2411101608886383),
     FLO_FC9(27680.4379339828010416),  FLO_FC9(27697.6374291560678103),
     FLO_FC9(27714.8395948511315510),  FLO_FC9(27732.0444302390897064),
     FLO_FC9(27749.2519344916872797),  FLO_FC9(27766.4621067812986439),
     FLO_FC9(27783.6749462809493707),  FLO_FC9(27800.8904521643016778),
     FLO_FC9(27818.1086236056544294),  FLO_FC9(27835.3294597799540497),
     FLO_FC9(27852.5529598627799714),  FLO_FC9(27869.7791230303446355),
     FLO_FC9(27887.0079484595044050),  FLO_FC9(27904.2394353277450136),
     FLO_FC9(27921.4735828131961171),  FLO_FC9(27938.7103900946131034),
     FLO_FC9(27955.9498563513916451),  FLO_FC9(27973.1919807635495090),
     FLO_FC9(27990.4367625117447460),  FLO_FC9(28007.6842007772720535),
     FLO_FC9(28024.9342947420409473),  FLO_FC9(28042.1870435886012274),
     FLO_FC9(28059.4424465001284261),  FLO_FC9(28076.7005026604274462),
     FLO_FC9(28093.9612112539289228),  FLO_FC9(28111.2245714656928612),
     FLO_FC9(28128.4905824814013613),  FLO_FC9(28145.7592434873622551),
     FLO_FC9(28163.0305536705091072),  FLO_FC9(28180.3045122183939384),
     FLO_FC9(28197.5811183191981399),  FLO_FC9(28214.8603711617251975),
     FLO_FC9(28232.1422699353897769),  FLO_FC9(28249.4268138302395528),
     FLO_FC9(28266.7140020369297417),  FLO_FC9(28284.0038337467449310),
     FLO_FC9(28301.2963081515845261),  FLO_FC9(28318.5914244439591130),
     FLO_FC9(28335.8891818170013721),  FLO_FC9(28353.1895794644624402),
     FLO_FC9(28370.4926165807046345),  FLO_FC9(28387.7982923607014527),
     FLO_FC9(28405.1066060000484867),  FLO_FC9(28422.4175566949452332),
     FLO_FC9(28439.7311436422060069),  FLO_FC9(28457.0473660392635793),
     FLO_FC9(28474.3662230841473502),  FLO_FC9(28491.6877139755124517),
     FLO_FC9(28509.0118379126106447),  FLO_FC9(28526.3385940953048703),
     FLO_FC9(28543.6679817240692500),  FLO_FC9(28560.9999999999854481),
     FLO_FC9(28578.3346481247317570),  FLO_FC9(28595.6719253006049257),
     FLO_FC9(28613.0118307304983318),  FLO_FC9(28630.3543636179092573),
     FLO_FC9(28647.6995231669425266),  FLO_FC9(28665.0473085822995927),
     FLO_FC9(28682.3977190692894510),  FLO_FC9(28699.7507538338177255),
     FLO_FC9(28717.1064120823903068),  FLO_FC9(28734.4646930221206276),
     FLO_FC9(28751.8255958607114735),  FLO_FC9(28769.1891198064622586),
     FLO_FC9(28786.5552640682799392),  FLO_FC9(28803.9240278556644625),
     FLO_FC9(28821.2954103787014901),  FLO_FC9(28838.6694108480878640),
     FLO_FC9(28856.0460284751025029),  FLO_FC9(28873.4252624716282298),
     FLO_FC9(28890.8071120501299447),  FLO_FC9(28908.1915764236728137),
     FLO_FC9(28925.5786548059149936),  FLO_FC9(28942.9683464110967179),
     FLO_FC9(28960.3606504540548485),  FLO_FC9(28977.7555661502155999),
     FLO_FC9(28995.1530927155909012),  FLO_FC9(29012.5532293667856720),
     FLO_FC9(29029.9559753209869086),  FLO_FC9(29047.3613297959745978),
     FLO_FC9(29064.7692920101071650),  FLO_FC9(29082.1798611823360261),
     FLO_FC9(29099.5930365321873978),  FLO_FC9(29117.0088172797804873),
     FLO_FC9(29134.4272026458129403),  FLO_FC9(29151.8481918515717553),
     FLO_FC9(29169.2717841189114552),  FLO_FC9(29186.6979786702831916),
     FLO_FC9(29204.1267747287056409),  FLO_FC9(29221.5581715177904698),
     FLO_FC9(29238.9921682617168699),  FLO_FC9(29256.4287641852497472),
     FLO_FC9(29273.8679585137251706),  FLO_FC9(29291.3097504730576475),
     FLO_FC9(29308.7541392897473997),  FLO_FC9(29326.2011241908548982),
     FLO_FC9(29343.6507044040299661),  FLO_FC9(29361.1028791574826755),
     FLO_FC9(29378.5576476800124510),  FLO_FC9(29396.0150092009753280),
     FLO_FC9(29413.4749629503094184),  FLO_FC9(29430.9375081585239968),
     FLO_FC9(29448.4026440566922247),  FLO_FC9(29465.8703698764693399),
     FLO_FC9(29483.3406848500708293),  FLO_FC9(29500.8135882102797041),
     FLO_FC9(29518.2890791904537764),  FLO_FC9(29535.7671570245111070),
     FLO_FC9(29553.2478209469445574),  FLO_FC9(29570.7310701928072376),
     FLO_FC9(29588.2169039977234206),  FLO_FC9(29605.7053215978703520),
     FLO_FC9(29623.1963222300000780),  FLO_FC9(29640.6899051314285316),
     FLO_FC9(29658.1860695400282566),  FLO_FC9(29675.6848146942356834),
     FLO_FC9(29693.1861398330474913),  FLO_FC9(29710.6900441960278840),
     FLO_FC9(29728.1965270232976764),  FLO_FC9(29745.7055875555270177),
     FLO_FC9(29763.2172250339644961),  FLO_FC9(29780.7314387003971206),
     FLO_FC9(29798.2482277971830626),  FLO_FC9(29815.7675915672298288),
     FLO_FC9(29833.2895292540051742),  FLO_FC9(29850.8140401015298266),
     FLO_FC9(29868.3411233543811250),  FLO_FC9(29885.8707782576930185),
     FLO_FC9(29903.4030040571451536),  FLO_FC9(29920.9377999989737873),
     FLO_FC9(29938.4751653299754253),  FLO_FC9(29956.0150992974813562),
     FLO_FC9(29973.5576011493940314),  FLO_FC9(29991.1026701341470471),
     FLO_FC9(30008.6503055007415242),  FLO_FC9(30026.2005064987097285),
     FLO_FC9(30043.7532723781441746),  FLO_FC9(30061.3086023896830739),
     FLO_FC9(30078.8664957845066965),  FLO_FC9(30096.4269518143519235),
     FLO_FC9(30113.9899697314940568),  FLO_FC9(30131.5555487887504569),
     FLO_FC9(30149.1236882394914574),  FLO_FC9(30166.6943873376294505),
     FLO_FC9(30184.2676453376079735),  FLO_FC9(30201.8434614944344503),
     FLO_FC9(30219.4218350636401738),  FLO_FC9(30237.0027653013094096),
     FLO_FC9(30254.5862514640575682),  FLO_FC9(30272.1722928090457572),
     FLO_FC9(30289.7608885939771426),  FLO_FC9(30307.3520380770896736),
     FLO_FC9(30324.9457405171597202),  FLO_FC9(30342.5419951735020732),
     FLO_FC9(30360.1408013059663062),  FLO_FC9(30377.7421581749440520),
     FLO_FC9(30395.3460650413580879),  FLO_FC9(30412.9525211666659743),
     FLO_FC9(30430.5615258128636924),  FLO_FC9(30448.1730782424747304),
     FLO_FC9(30465.7871777185609972),  FLO_FC9(30483.4038235047191847),
     FLO_FC9(30501.0230148650698538),  FLO_FC9(30518.6447510642719863),
     FLO_FC9(30536.2690313675157086),  FLO_FC9(30553.8958550405150163),
     FLO_FC9(30571.5252213495186879),  FLO_FC9(30589.1571295613066468),
     FLO_FC9(30606.7915789431754092),  FLO_FC9(30624.4285687629635504),
     FLO_FC9(30642.0680982890298765),  FLO_FC9(30659.7101667902607005),
     FLO_FC9(30677.3547735360698425),  FLO_FC9(30695.0019177963913535),
     FLO_FC9(30712.6515988416867913),  FLO_FC9(30730.3038159429452207),
     FLO_FC9(30747.9585683716759377),  FLO_FC9(30765.6158553999121068),
     FLO_FC9(30783.2756763002107618),  FLO_FC9(30800.9380303456455295),
     FLO_FC9(30818.6029168098139053),  FLO_FC9(30836.2703349668372539),
     FLO_FC9(30853.9402840913535329),  FLO_FC9(30871.6127634585209307),
     FLO_FC9(30889.2877723440105910),  FLO_FC9(30906.9653100240248023),
     FLO_FC9(30924.6453757752715319),  FLO_FC9(30942.3279688749826164),
     FLO_FC9(30960.0130886009028472),  FLO_FC9(30977.7007342312936089),
     FLO_FC9(30995.3909050449292408),  FLO_FC9(31013.0836003211006755),
     FLO_FC9(31030.7788193396190763),  FLO_FC9(31048.4765613807976479),
     FLO_FC9(31066.1768257254698256),  FLO_FC9(31083.8796116549783619),
     FLO_FC9(31101.5849184511789645),  FLO_FC9(31119.2927453964402957),
     FLO_FC9(31137.0030917736366973),  FLO_FC9(31154.7159568661554658),
     FLO_FC9(31172.4313399578932149),  FLO_FC9(31190.1492403332595131),
     FLO_FC9(31207.8696572771623323),  FLO_FC9(31225.5925900750225992),
     FLO_FC9(31243.3180380127705575),  FLO_FC9(31261.0460003768384922),
     FLO_FC9(31278.7764764541716431),  FLO_FC9(31296.5094655322100152),
     FLO_FC9(31314.2449668989102065),  FLO_FC9(31331.9829798427199421),
     FLO_FC9(31349.7235036525999021),  FLO_FC9(31367.4665376180128078),
     FLO_FC9(31385.2120810289234214),  FLO_FC9(31402.9601331757949083),
     FLO_FC9(31420.7106933495961130),  FLO_FC9(31438.4637608417906449),
     FLO_FC9(31456.2193349443514307),  FLO_FC9(31473.9774149497425242),
     FLO_FC9(31491.7380001509336580),  FLO_FC9(31509.5010898413893301),
     FLO_FC9(31527.2666833150688035),  FLO_FC9(31545.0347798664370202),
     FLO_FC9(31562.8053787904500496),  FLO_FC9(31580.5784793825623638),
     FLO_FC9(31598.3540809387195623),  FLO_FC9(31616.1321827553692856),
     FLO_FC9(31633.9127841294503014),  FLO_FC9(31651.6958843583961425),
     FLO_FC9(31669.4814827401314687),  FLO_FC9(31687.2695785730757052),
     FLO_FC9(31705.0601711561430420),  FLO_FC9(31722.8532597887351585),
     FLO_FC9(31740.6488437707484991),  FLO_FC9(31758.4469224025669973),
     FLO_FC9(31776.2474949850657140),  FLO_FC9(31794.0505608196144749),
     FLO_FC9(31811.8561192080596811),  FLO_FC9(31829.6641694527534128),
     FLO_FC9(31847.4747108565206872),  FLO_FC9(31865.2877427226849250),
     FLO_FC9(31883.1032643550461216),  FLO_FC9(31900.9212750578990381),
     FLO_FC9(31918.7417741360186483),  FLO_FC9(31936.5647608946710534),
     FLO_FC9(31954.3902346395989298),  FLO_FC9(31972.2181946770397190),
     FLO_FC9(31990.0486403137037996),  FLO_FC9(32007.8815708567926777),
     FLO_FC9(32025.7169856139844342),  FLO_FC9(32043.5548838934446394),
     FLO_FC9(32061.3952650038154388),  FLO_FC9(32079.2381282542228291),
     FLO_FC9(32097.0834729542693822),  FLO_FC9(32114.9312984140487970),
     FLO_FC9(32132.7816039441167959),  FLO_FC9(32150.6343888555238664),
     FLO_FC9(32168.4896524597897951),  FLO_FC9(32186.3473940689145820),
     FLO_FC9(32204.2076129953711643),  FLO_FC9(32222.0703085521199682),
     FLO_FC9(32239.9354800525834435),  FLO_FC9(32257.8031268106715288),
     FLO_FC9(32275.6732481407671003),  FLO_FC9(32293.5458433577186952),
     FLO_FC9(32311.4209117768623400),  FLO_FC9(32329.2984527139960846),
     FLO_FC9(32347.1784654853945540),  FLO_FC9(32365.0609494078125863),
     FLO_FC9(32382.9459037984634051),  FLO_FC9(32400.8333279750404472),
     FLO_FC9(32418.7232212557064486),  FLO_FC9(32436.6155829590934445),
     FLO_FC9(32454.5104124043064076),  FLO_FC9(32472.4077089109159715),
     FLO_FC9(32490.3074717989657074),  FLO_FC9(32508.2097003889612097),
     FLO_FC9(32526.1143940018773719),  FLO_FC9(32544.0215519591656630),
     FLO_FC9(32561.9311735827322991),  FLO_FC9(32579.8432581949564337),
     FLO_FC9(32597.7578051186792436),  FLO_FC9(32615.6748136772112048),
     FLO_FC9(32633.5942831943284546),  FLO_FC9(32651.5162129942582396),
     FLO_FC9(32669.4406024017116579),  FLO_FC9(32687.3674507418472786),
     FLO_FC9(32705.2967573402966082),  FLO_FC9(32723.2285215231459006),
     FLO_FC9(32741.1627426169434329),  FLO_FC9(32759.0994199487031437),
     FLO_FC9(32777.0385528459009947),  FLO_FC9(32794.9801406364640570),
     FLO_FC9(32812.9241826487923390),  FLO_FC9(32830.8706782117296825),
     FLO_FC9(32848.8196266545928665),  FLO_FC9(32866.7710273071497795),
     FLO_FC9(32884.7248794996194192),  FLO_FC9(32902.6811825626864447),
     FLO_FC9(32920.6399358274939004),  FLO_FC9(32938.6011386256432161),
     FLO_FC9(32956.5647902891796548),  FLO_FC9(32974.5308901506068651),
     FLO_FC9(32992.4994375428941566),  FLO_FC9(33010.4704317994473968),
     FLO_FC9(33028.4438722541453899),  FLO_FC9(33046.4197582413107739),
     FLO_FC9(33064.3980890957100200),  FLO_FC9(33082.3788641525825369),
     FLO_FC9(33100.3620827475897386),  FLO_FC9(33118.3477442168805283),
     FLO_FC9(33136.3358478970258147),  FLO_FC9(33154.3263931250621681),
     FLO_FC9(33172.3193792384699918),  FLO_FC9(33190.3148055751735228),
     FLO_FC9(33208.3126714735553833),  FLO_FC9(33226.3129762724420289),
     FLO_FC9(33244.3157193111110246),  FLO_FC9(33262.3208999292837689),
     FLO_FC9(33280.3285174671254936),  FLO_FC9(33298.3385712652598158),
     FLO_FC9(33316.3510606647469103),  FLO_FC9(33334.3659850070907851),
     FLO_FC9(33352.3833436342392815),  FLO_FC9(33370.4031358885913505),
     FLO_FC9(33388.4253611129897763),  FLO_FC9(33406.4500186507211765),
     FLO_FC9(33424.4771078455014504),  FLO_FC9(33442.5066280415121582),
     FLO_FC9(33460.5385785833495902),  FLO_FC9(33478.5729588160829735),
     FLO_FC9(33496.6097680851889891),  FLO_FC9(33514.6490057366172550),
     FLO_FC9(33532.6906711167393951),  FLO_FC9(33550.7347635723563144),
     FLO_FC9(33568.7812824507345795),  FLO_FC9(33586.8302270995627623),
     FLO_FC9(33604.8815968669732683),  FLO_FC9(33622.9353911015277845),
     FLO_FC9(33640.9916091522391071),  FLO_FC9(33659.0502503685420379),
     FLO_FC9(33677.1113141003224882),  FLO_FC9(33695.1747996978810988),
     FLO_FC9(33713.2407065119841718),  FLO_FC9(33731.3090338938054629),
     FLO_FC9(33749.3797811949698371),  FLO_FC9(33767.4529477675314411),
     FLO_FC9(33785.5285329639737029),  FLO_FC9(33803.6065361372093321),
     FLO_FC9(33821.6869566406021477),  FLO_FC9(33839.7697938279379741),
     FLO_FC9(33857.8550470534246415),  FLO_FC9(33875.9427156717065373),
     FLO_FC9(33894.0327990378718823),  FLO_FC9(33912.1252965074309031),
     FLO_FC9(33930.2202074363158317),  FLO_FC9(33948.3175311808881816),
     FLO_FC9(33966.4172670979605755),  FLO_FC9(33984.5194145447458141),
     FLO_FC9(34002.6239728789005312),  FLO_FC9(34020.7309414585106424),
     FLO_FC9(34038.8403196420767927),  FLO_FC9(34056.9521067885361845),
     FLO_FC9(34075.0663022572553018),  FLO_FC9(34093.1829054080153583),
     FLO_FC9(34111.3019156010268489),  FLO_FC9(34129.4233321969295503),
     FLO_FC9(34147.5471545567852445),  FLO_FC9(34165.6733820420777192),
     FLO_FC9(34183.8020140147200436),  FLO_FC9(34201.9330498370327405),
     FLO_FC9(34220.0664888717801659),  FLO_FC9(34238.2023304821414058),
     FLO_FC9(34256.3405740317029995),  FLO_FC9(34274.4812188844953198),
     FLO_FC9(34292.6242644049489172),  FLO_FC9(34310.7697099579381756),
     FLO_FC9(34328.9175549087303807),  FLO_FC9(34347.0677986230293754),
     FLO_FC9(34365.2204404669537325),  FLO_FC9(34383.3754798070513061),
     FLO_FC9(34401.5329160102628521),  FLO_FC9(34419.6927484439729596),
     FLO_FC9(34437.8549764759663958),  FLO_FC9(34456.0195994744499330),
     FLO_FC9(34474.1866168080596253),  FLO_FC9(34492.3560278458171524),
     FLO_FC9(34510.5278319571880274),  FLO_FC9(34528.7020285120524932),
     FLO_FC9(34546.8786168806764181),  FLO_FC9(34565.0575964337695041),
     FLO_FC9(34583.2389665424489067),  FLO_FC9(34601.4227265782319591),
     FLO_FC9(34619.6088759130652761),  FLO_FC9(34637.7974139192956500),
     FLO_FC9(34655.9883399696918787),  FLO_FC9(34674.1816534374229377),
     FLO_FC9(34692.3773536960798083),  FLO_FC9(34710.5754401196682011),
     FLO_FC9(34728.7759120825794525),  FLO_FC9(34746.9787689596487326),
     FLO_FC9(34765.1840101260822848),  FLO_FC9(34783.3916349575374625),
     FLO_FC9(34801.6016428300499683),  FLO_FC9(34819.8140331200629589),
     FLO_FC9(34838.0288052044561482),  FLO_FC9(34856.2459584604803240),
     FLO_FC9(34874.4654922658228315),  FLO_FC9(34892.6874059985566419),
     FLO_FC9(34910.9116990371767315),  FLO_FC9(34929.1383707605637028),
     FLO_FC9(34947.3674205480274395),  FLO_FC9(34965.5988477792707272),
     FLO_FC9(34983.8326518343892531),  FLO_FC9(35002.0688320939079858),
     FLO_FC9(35020.3073879387375200),  FLO_FC9(35038.5483187501886277),
     FLO_FC9(35056.7916239099795348),  FLO_FC9(35075.0373028002504725),
     FLO_FC9(35093.2853548035127460),  FLO_FC9(35111.5357793026851141),
     FLO_FC9(35129.7885756811156170),  FLO_FC9(35148.0437433225160930),
     FLO_FC9(35166.3012816110131098),  FLO_FC9(35184.5611899311406887),
     FLO_FC9(35202.8234676678257529),  FLO_FC9(35221.0881142063881271),
     FLO_FC9(35239.3551289325550897),  FLO_FC9(35257.6245112324468209),
     FLO_FC9(35275.8962604925836786),  FLO_FC9(35294.1703760998861981),
     FLO_FC9(35312.4468574416678166),  FLO_FC9(35330.7257039056275971),
     FLO_FC9(35349.0069148798866081),  FLO_FC9(35367.2904897529442678),
     FLO_FC9(35385.5764279136856203),  FLO_FC9(35403.8647287514177151),
     FLO_FC9(35422.1553916558113997),  FLO_FC9(35440.4484160169668030),
     FLO_FC9(35458.7438012253405759),  FLO_FC9(35477.0415466718040989),
     FLO_FC9(35495.3416517476216541),  FLO_FC9(35513.6441158444358734),
     FLO_FC9(35531.9489383543041185),  FLO_FC9(35550.2561186696548248),
     FLO_FC9(35568.5656561833093292),  FLO_FC9(35586.8775502884964226),
     FLO_FC9(35605.1918003788159695),  FLO_FC9(35623.5084058482680121),
     FLO_FC9(35641.8273660912382184),  FLO_FC9(35660.1486805025051581),
     FLO_FC9(35678.4723484772330266),  FLO_FC9(35696.7983694109789212),
     FLO_FC9(35715.1267426996782888),  FLO_FC9(35733.4574677396594780),
     FLO_FC9(35751.7905439276437392),  FLO_FC9(35770.1259706607379485),
     FLO_FC9(35788.4637473364200559),  FLO_FC9(35806.8038733525681891),
     FLO_FC9(35825.1463481074533775),  FLO_FC9(35843.4911709997104481),
     FLO_FC9(35861.8383414283671300),  FLO_FC9(35880.1878587928513298),
     FLO_FC9(35898.5397224929547519),  FLO_FC9(35916.8939319288620027),
     FLO_FC9(35935.2504865011287620),  FLO_FC9(35953.6093856107181637),
     FLO_FC9(35971.9706286589571391),  FLO_FC9(35990.3342150475582457),
     FLO_FC9(36008.7001441786123905),  FLO_FC9(36027.0684154545961064),
     FLO_FC9(36045.4390282783715520),  FLO_FC9(36063.8119820531646837),
     FLO_FC9(36082.1872761826089118),  FLO_FC9(36100.5649100706941681),
     FLO_FC9(36118.9448831217887346),  FLO_FC9(36137.3271947406537947),
     FLO_FC9(36155.7118443324288819),  FLO_FC9(36174.0988313026173273),
     FLO_FC9(36192.4881550571153639),  FLO_FC9(36210.8798150021902984),
     FLO_FC9(36229.2738105444732355),  FLO_FC9(36247.6701410910027334),
     FLO_FC9(36266.0688060491665965),  FLO_FC9(36284.4698048267382546),
     FLO_FC9(36302.8731368318622117),  FLO_FC9(36321.2788014730685973),
     FLO_FC9(36339.6867981592513388),  FLO_FC9(36358.0971262996827136),
     FLO_FC9(36376.5097853040133487),  FLO_FC9(36394.9247745822576690),
     FLO_FC9(36413.3420935448157252),  FLO_FC9(36431.7617416024440899),
     FLO_FC9(36450.1837181662922376),  FLO_FC9(36468.6080226478588884),
     FLO_FC9(36487.0346544590283884),  FLO_FC9(36505.4636130120634334),
     FLO_FC9(36523.8948977195832413),  FLO_FC9(36542.3285079945781035),
     FLO_FC9(36560.7644432504093857),  FLO_FC9(36579.2027029008313548),
     FLO_FC9(36597.6432863599256962),  FLO_FC9(36616.0861930421815487),
     FLO_FC9(36634.5314223624372971),  FLO_FC9(36652.9789737358951243),
     FLO_FC9(36671.4288465781428386),  FLO_FC9(36689.8810403051247704),
     FLO_FC9(36708.3355543331490480),  FLO_FC9(36726.7923880789021496),
     FLO_FC9(36745.2515409594270750),  FLO_FC9(36763.7130123921378981),
     FLO_FC9(36782.1768017948124907),  FLO_FC9(36800.6429085855925223),
     FLO_FC9(36819.1113321829907363),  FLO_FC9(36837.5820720058691222),
     FLO_FC9(36856.0551274734825711),  FLO_FC9(36874.5304980054206681),
     FLO_FC9(36893.0081830216513481),  FLO_FC9(36911.4881819425063441),
     FLO_FC9(36929.9704941886739107),  FLO_FC9(36948.4551191812061006),
     FLO_FC9(36966.9420563415187644),  FLO_FC9(36985.4313050913915504),
     FLO_FC9(37003.9228648529606289),  FLO_FC9(37022.4167350487332442),
     FLO_FC9(37040.9129151015586103),  FLO_FC9(37059.4114044346570154),
     FLO_FC9(37077.9122024716198212),  FLO_FC9(37096.4153086363876355),
     FLO_FC9(37114.9207223532430362),  FLO_FC9(37133.4284430468615028),
     FLO_FC9(37151.9384701422532089),  FLO_FC9(37170.4508030647848500),
     FLO_FC9(37188.9654412402087473),  FLO_FC9(37207.4823840945973643),
     FLO_FC9(37226.0016310544015141),  FLO_FC9(37244.5231815464285319),
     FLO_FC9(37263.0470349978422746),  FLO_FC9(37281.5731908361485694),
     FLO_FC9(37300.1016484892243170),  FLO_FC9(37318.6324073852956644),
     FLO_FC9(37337.1654669529452804),  FLO_FC9(37355.7008266211123555),
     FLO_FC9(37374.2384858190853265),  FLO_FC9(37392.7784439765091520),
     FLO_FC9(37411.3207005233853124),  FLO_FC9(37429.8652548900572583),
     FLO_FC9(37448.4121065072322381),  FLO_FC9(37466.9612548059667461),
     FLO_FC9(37485.5126992176810745),  FLO_FC9(37504.0664391741156578),
     FLO_FC9(37522.6224741074038320),  FLO_FC9(37541.1808034499917994),
     FLO_FC9(37559.7414266346968361),  FLO_FC9(37578.3043430946927401),
     FLO_FC9(37596.8695522634880035),  FLO_FC9(37615.4370535749403643),
     FLO_FC9(37634.0068464632713585),  FLO_FC9(37652.5789303630444920),
     FLO_FC9(37671.1533047091652406),  FLO_FC9(37689.7299689368956024),
     FLO_FC9(37708.3089224818468210),  FLO_FC9(37726.8901647799648345),
     FLO_FC9(37745.4736952675593784),  FLO_FC9(37764.0595133812748827),
     FLO_FC9(37782.6476185581122991),  FLO_FC9(37801.2380102354145492),
     FLO_FC9(37819.8306878508592490),  FLO_FC9(37838.4256508424950880),
     FLO_FC9(37857.0228986486908980),  FLO_FC9(37875.6224307081720326),
     FLO_FC9(37894.2242464600130916),  FLO_FC9(37912.8283453436160926),
     FLO_FC9(37931.4347267987468513),  FLO_FC9(37950.0433902655058773),
     FLO_FC9(37968.6543351843283745),  FLO_FC9(37987.2675609959987924),
     FLO_FC9(38005.8830671416653786),  FLO_FC9(38024.5008530627746950),
     FLO_FC9(38043.1209182011589292),  FLO_FC9(38061.7432619989631348),
     FLO_FC9(38080.3678838986816118),  FLO_FC9(38098.9947833431579056),
     FLO_FC9(38117.6239597755629802),  FLO_FC9(38136.2554126394170453),
     FLO_FC9(38154.8891413785750046),  FLO_FC9(38173.5251454372337321),
     FLO_FC9(38192.1634242599393474),  FLO_FC9(38210.8039772915508365),
     FLO_FC9(38229.4468039772837074),  FLO_FC9(38248.0919037627027137),
     FLO_FC9(38266.7392760936854756),  FLO_FC9(38285.3889204164661351),
     FLO_FC9(38304.0408361776062520),  FLO_FC9(38322.6950228240020806),
     FLO_FC9(38341.3514798028991208),  FLO_FC9(38360.0102065618630149),
     FLO_FC9(38378.6712025488159270),  FLO_FC9(38397.3344672119928873),
     FLO_FC9(38415.9999999999781721),  FLO_FC9(38434.6678003616834758),
     FLO_FC9(38453.3378677463697386),  FLO_FC9(38472.0102016036107671),
     FLO_FC9(38490.6848013833368896),  FLO_FC9(38509.3616665357840247),
     FLO_FC9(38528.0407965115518891),  FLO_FC9(38546.7221907615530654),
     FLO_FC9(38565.4058487370348303),  FLO_FC9(38584.0917698895937065),
     FLO_FC9(38602.7799536711318069),  FLO_FC9(38621.4703995339077665),
     FLO_FC9(38640.1631069304858102),  FLO_FC9(38658.8580753137939610),
     FLO_FC9(38677.5553041370585561),  FLO_FC9(38696.2547928538624546),
     FLO_FC9(38714.9565409180941060),  FLO_FC9(38733.6605477839912055),
     FLO_FC9(38752.3668129061115906),  FLO_FC9(38771.0753357393477927),
     FLO_FC9(38789.7861157389197615),  FLO_FC9(38808.4991523603675887),
     FLO_FC9(38827.2144450595733360),  FLO_FC9(38845.9319932927392074),
     FLO_FC9(38864.6517965163875488),  FLO_FC9(38883.3738541873826762),
     FLO_FC9(38902.0981657629163237),  FLO_FC9(38920.8247307004858158),
     FLO_FC9(38939.5535484579377226),  FLO_FC9(38958.2846184934314806),
     FLO_FC9(38977.0179402654612204),  FLO_FC9(38995.7535132328339387),
     FLO_FC9(39014.4913368546986021),  FLO_FC9(39033.2314105905170436),
     FLO_FC9(39051.9737339000785141),  FLO_FC9(39070.7183062434851308),
     FLO_FC9(39089.4651270811882569),  FLO_FC9(39108.2141958739448455),
     FLO_FC9(39126.9655120828319923),  FLO_FC9(39145.7190751692614867),
     FLO_FC9(39164.4748845949652605),  FLO_FC9(39183.2329398219881114),
     FLO_FC9(39201.9932403127095313),  FLO_FC9(39220.7557855298146023),
     FLO_FC9(39239.5205749363303767),  FLO_FC9(39258.2876079955894966),
     FLO_FC9(39277.0568841712447465),  FLO_FC9(39295.8284029272908811),
     FLO_FC9(39314.6021637280064169),  FLO_FC9(39333.3781660380191170),
     FLO_FC9(39352.1564093222696101),  FLO_FC9(39370.9368930460041156),
     FLO_FC9(39389.7196166748108226),  FLO_FC9(39408.5045796745835105),
     FLO_FC9(39427.2917815115215490),  FLO_FC9(39446.0812216521735536),
     FLO_FC9(39464.8728995633719023),  FLO_FC9(39483.6668147122909431),
     FLO_FC9(39502.4629665664106142),  FLO_FC9(39521.2613545935382717),
     FLO_FC9(39540.0619782617795863),  FLO_FC9(39558.8648370395676466),
     FLO_FC9(39577.6699303956556832),  FLO_FC9(39596.4772577991097933),
     FLO_FC9(39615.2868187193016638),  FLO_FC9(39634.0986126259231241),
     FLO_FC9(39652.9126389889934217),  FLO_FC9(39671.7288972788228421),
     FLO_FC9(39690.5473869660636410),  FLO_FC9(39709.3681075216518366),
     FLO_FC9(39728.1910584168581408),  FLO_FC9(39747.0162391232588561),
     FLO_FC9(39765.8436491127504269),  FLO_FC9(39784.6732878575276118),
     FLO_FC9(39803.5051548301053117),  FLO_FC9(39822.3392495033185696),
     FLO_FC9(39841.1755713502934668),  FLO_FC9(39860.0141198444980546),
     FLO_FC9(39878.8548944596768706),  FLO_FC9(39897.6978946699091466),
     FLO_FC9(39916.5431199495797046),  FLO_FC9(39935.3905697733716806),
     FLO_FC9(39954.2402436163029051),  FLO_FC9(39973.0921409536749707),
     FLO_FC9(39991.9462612611168879),  FLO_FC9(40010.8026040145487059),
     FLO_FC9(40029.6611686902251677),  FLO_FC9(40048.5219547646775027),
     FLO_FC9(40067.3849617147789104),  FLO_FC9(40086.2501890176790766),
     FLO_FC9(40105.1176361508551054),  FLO_FC9(40123.9873025920896907),
     FLO_FC9(40142.8591878194711171),  FLO_FC9(40161.7332913113787072),
     FLO_FC9(40180.6096125465264777),  FLO_FC9(40199.4881510039122077),
     FLO_FC9(40218.3689061628538184),  FLO_FC9(40237.2518775029602693),
     FLO_FC9(40256.1370645041533862),  FLO_FC9(40275.0244666466678609),
     FLO_FC9(40293.9140834110294236),  FLO_FC9(40312.8059142780839466),
     FLO_FC9(40331.6999587289610645),  FLO_FC9(40350.5962162451032782),
     FLO_FC9(40369.4946863082732307),  FLO_FC9(40388.3953684005100513),
     FLO_FC9(40407.2982620041730115),  FLO_FC9(40426.2033666019196971),
     FLO_FC9(40445.1106816767060081),  FLO_FC9(40464.0202067117934348),
     FLO_FC9(40482.9319411907563335),  FLO_FC9(40501.8458845974455471),
     FLO_FC9(40520.7620364160320605),  FLO_FC9(40539.6803961309851729),
     FLO_FC9(40558.6009632270724978),  FLO_FC9(40577.5237371893672389),
     FLO_FC9(40596.4487175032336381),  FLO_FC9(40615.3759036543415277),
     FLO_FC9(40634.3052951286590542),  FLO_FC9(40653.2368914124526782),
     FLO_FC9(40672.1706919922944508),  FLO_FC9(40691.1066963550474611),
     FLO_FC9(40710.0449039878731128),  FLO_FC9(40728.9853143782383995),
     FLO_FC9(40747.9279270139013533),  FLO_FC9(40766.8727413829183206),
     FLO_FC9(40785.8197569736512378),  FLO_FC9(40804.7689732747458038),
     FLO_FC9(40823.7203897751605837),  FLO_FC9(40842.6740059641306289),
     FLO_FC9(40861.6298213312111329),  FLO_FC9(40880.5878353662264999),
     FLO_FC9(40899.5480475593285519),  FLO_FC9(40918.5104574009310454),
     FLO_FC9(40937.4750643817606033),  FLO_FC9(40956.4418679928494385),
     FLO_FC9(40975.4108677254989743),  FLO_FC9(40994.3820630713235005),
     FLO_FC9(41013.3554535222356208),  FLO_FC9(41032.3310385704171495),
     FLO_FC9(41051.3088177083627670),  FLO_FC9(41070.2887904288581922),
     FLO_FC9(41089.2709562249874580),  FLO_FC9(41108.2553145901110838),
     FLO_FC9(41127.2418650178879034),  FLO_FC9(41146.2306070022896165),
     FLO_FC9(41165.2215400375425816),  FLO_FC9(41184.2146636181932990),
     FLO_FC9(41203.2099772390793078),  FLO_FC9(41222.2074803953073570),
     FLO_FC9(41241.2071725822970620),  FLO_FC9(41260.2090532957518008),
     FLO_FC9(41279.2131220316587132),  FLO_FC9(41298.2193782863032538),
     FLO_FC9(41317.2278215562546393),  FLO_FC9(41336.2384513383804006),
     FLO_FC9(41355.2512671298318310),  FLO_FC9(41374.2662684280367102),
     FLO_FC9(41393.2834547307429602),  FLO_FC9(41412.3028255359531613),
     FLO_FC9(41431.3243803419827600),  FLO_FC9(41450.3481186474164133),
     FLO_FC9(41469.3740399511443684),  FLO_FC9(41488.4021437523260829),
     FLO_FC9(41507.4324295504266047),  FLO_FC9(41526.4648968451874680),
     FLO_FC9(41545.4995451366266934),  FLO_FC9(41564.5363739250751678),
     FLO_FC9(41583.5753827111257124),  FLO_FC9(41602.6165709956621868),
     FLO_FC9(41621.6599382798740407),  FLO_FC9(41640.7054840652053826),
     FLO_FC9(41659.7532078534059110),  FLO_FC9(41678.8031091464945348),
     FLO_FC9(41697.8551874468030292),  FLO_FC9(41716.9094422569105518),
     FLO_FC9(41735.9658730797091266),  FLO_FC9(41755.0244794183599879),
     FLO_FC9(41774.0852607763154083),  FLO_FC9(41793.1482166572968708),
     FLO_FC9(41812.2133465653314488),  FLO_FC9(41831.2806500047081499),
     FLO_FC9(41850.3501264800142962),  FLO_FC9(41869.4217754961064202),
     FLO_FC9(41888.4955965581320925),  FLO_FC9(41907.5715891715153703),
     FLO_FC9(41926.6497528419567971),  FLO_FC9(41945.7300870754625066),
     FLO_FC9(41964.8125913782860152),  FLO_FC9(41983.8972652569791535),
     FLO_FC9(42002.9841082183775143),  FLO_FC9(42022.0731197695931769),
     FLO_FC9(42041.1642994180074311),  FLO_FC9(42060.2576466713071568),
     FLO_FC9(42079.3531610374193406),  FLO_FC9(42098.4508420245911111),
     FLO_FC9(42117.5506891413242556),  FLO_FC9(42136.6527018964043236),
     FLO_FC9(42155.7568797988933511),  FLO_FC9(42174.8632223581371363),
     FLO_FC9(42193.9717290837579640),  FLO_FC9(42213.0823994856546051),
     FLO_FC9(42232.1952330740023172),  FLO_FC9(42251.3102293592455680),
     FLO_FC9(42270.4273878521271399),  FLO_FC9(42289.5467080636444734),
     FLO_FC9(42308.6681895050787716),  FLO_FC9(42327.7918316879949998),
     FLO_FC9(42346.9176341242273338),  FLO_FC9(42366.0455963258864358),
     FLO_FC9(42385.1757178053521784),  FLO_FC9(42404.3079980752954725),
     FLO_FC9(42423.4424366486418876),  FLO_FC9(42442.5790330386080313),
     FLO_FC9(42461.7177867586724460),  FLO_FC9(42480.8586973225974361),
     FLO_FC9(42500.0017642444217927),  FLO_FC9(42519.1469870384462411),
     FLO_FC9(42538.2943652192479931),  FLO_FC9(42557.4438983016880229),
     FLO_FC9(42576.5955858008819632),  FLO_FC9(42595.7494272322364850),
     FLO_FC9(42614.9054221114201937),  FLO_FC9(42634.0635699543709052),
     FLO_FC9(42653.2238702773174737),  FLO_FC9(42672.3863225967288599),
     FLO_FC9(42691.5509264293796150),  FLO_FC9(42710.7176812922916724),
     FLO_FC9(42729.8865867027634522),  FLO_FC9(42749.0576421783625847),
     FLO_FC9(42768.2308472369404626),  FLO_FC9(42787.4062013966104132),
     FLO_FC9(42806.5837041757404222),  FLO_FC9(42825.7633550929895137),
     FLO_FC9(42844.9451536672859220),  FLO_FC9(42864.1290994178052642),
     FLO_FC9(42883.3151918640141957),  FLO_FC9(42902.5034305256485823),
     FLO_FC9(42921.6938149226916721),  FLO_FC9(42940.8863445754104760),
     FLO_FC9(42960.0810190043484909),  FLO_FC9(42979.2778377302965964),
     FLO_FC9(42998.4768002743221587),  FLO_FC9(43017.6779061577690300),
     FLO_FC9(43036.8811549022284453),  FLO_FC9(43056.0865460295826779),
     FLO_FC9(43075.2940790619613836),  FLO_FC9(43094.5037535217634286),
     FLO_FC9(43113.7155689316641656),  FLO_FC9(43132.9295248146008817),
     FLO_FC9(43152.1456206937655224),  FLO_FC9(43171.3638560926192440),
     FLO_FC9(43190.5842305349069647),  FLO_FC9(43209.8067435446209856),
     FLO_FC9(43229.0313946460155421),  FLO_FC9(43248.2581833636213560),
     FLO_FC9(43267.4871092222238076),  FLO_FC9(43286.7181717468847637),
     FLO_FC9(43305.9513704629061976),  FLO_FC9(43325.1867048958811210),
     FLO_FC9(43344.4241745716499281),  FLO_FC9(43363.6637790163222235),
     FLO_FC9(43382.9055177562622703),  FLO_FC9(43402.1493903181035421),
     FLO_FC9(43421.3953962287487229),  FLO_FC9(43440.6435350153478794),
     FLO_FC9(43459.8938062053202884),  FLO_FC9(43479.1462093263471616),
     FLO_FC9(43498.4007439063789207),  FLO_FC9(43517.6574094736060943),
     FLO_FC9(43536.9162055564956972),  FLO_FC9(43556.1771316837839549),
     FLO_FC9(43575.4401873844399233),  FLO_FC9(43594.7053721877236967),
     FLO_FC9(43613.9726856231354759),  FLO_FC9(43633.2421272204373963),
     FLO_FC9(43652.5136965096680797),  FLO_FC9(43671.7873930210989784),
     FLO_FC9(43691.0632162852707552),  FLO_FC9(43710.3411658330005594),
     FLO_FC9(43729.6212411953456467),  FLO_FC9(43748.9034419036252075),
     FLO_FC9(43768.1877674894130905),  FLO_FC9(43787.4742174845523550),
     FLO_FC9(43806.7627914211261668),  FLO_FC9(43826.0534888315014541),
     FLO_FC9(43845.3463092482779757),  FLO_FC9(43864.6412522043247009),
     FLO_FC9(43883.9383172327652574),  FLO_FC9(43903.2375038669779315),
     FLO_FC9(43922.5388116405956680),  FLO_FC9(43941.8422400875133462),
     FLO_FC9(43961.1477887418805039),  FLO_FC9(43980.4554571381013375),
     FLO_FC9(43999.7652448108347016),  FLO_FC9(44019.0771512950013857),
     FLO_FC9(44038.3911761257550097),  FLO_FC9(44057.7073188385402318),
     FLO_FC9(44077.0255789690199890),  FLO_FC9(44096.3459560531409807),
     FLO_FC9(44115.6684496270827367),  FLO_FC9(44134.9930592272867216),
     FLO_FC9(44154.3197843904563342),  FLO_FC9(44173.6486246535350801),
     FLO_FC9(44192.9795795537283993),  FLO_FC9(44212.3126486284891143),
     FLO_FC9(44231.6478314155319822),  FLO_FC9(44250.9851274528045906),
     FLO_FC9(44270.3245362785382895),  FLO_FC9(44289.6660574311827077),
     FLO_FC9(44309.0096904494639602),  FLO_FC9(44328.3554348723555449),
     FLO_FC9(44347.7032902390637901),  FLO_FC9(44367.0532560890787863),
     FLO_FC9(44386.4053319621089031),  FLO_FC9(44405.7595173981389962),
     FLO_FC9(44425.1158119373867521),  FLO_FC9(44444.4742151203317917),
     FLO_FC9(44463.8347264876938425),  FLO_FC9(44483.1973455804618425),
     FLO_FC9(44502.5620719398430083),  FLO_FC9(44521.9289051073283190),
     FLO_FC9(44541.2978446246343083),  FLO_FC9(44560.6688900337321684),
     FLO_FC9(44580.0420408768477500),  FLO_FC9(44599.4172966964542866),
     FLO_FC9(44618.7946570352723938),  FLO_FC9(44638.1741214362555183),
     FLO_FC9(44657.5556894426408689),  FLO_FC9(44676.9393605978693813),
     FLO_FC9(44696.3251344456730294),  FLO_FC9(44715.7130105300020659),
     FLO_FC9(44735.1029883950541262),  FLO_FC9(44754.4950675852960558),
     FLO_FC9(44773.8892476454202551),  FLO_FC9(44793.2855281203737832),
     FLO_FC9(44812.6839085553438053),  FLO_FC9(44832.0843884957794216),
     FLO_FC9(44851.4869674873552867),  FLO_FC9(44870.8916450760152657),
     FLO_FC9(44890.2984208079142263),  FLO_FC9(44909.7072942294907989),
     FLO_FC9(44929.1182648874091683),  FLO_FC9(44948.5313323285663500),
     FLO_FC9(44967.9464961001358461),  FLO_FC9(44987.3637557495021611),
     FLO_FC9(45006.7831108243262861),  FLO_FC9(45026.2045608724729391),
     FLO_FC9(45045.6281054420978762),  FLO_FC9(45065.0537440815605805),
     FLO_FC9(45084.4814763394897454),  FLO_FC9(45103.9113017647396191),
     FLO_FC9(45123.3432199064263841),  FLO_FC9(45142.7772303138845018),
     FLO_FC9(45162.2133325367103680),  FLO_FC9(45181.6515261247332091),
     FLO_FC9(45201.0918106280369102),  FLO_FC9(45220.5341855969236349),
     FLO_FC9(45239.9786505819647573),  FLO_FC9(45259.4252051339572063),
     FLO_FC9(45278.8738488039380172),  FLO_FC9(45298.3245811431916081),
     FLO_FC9(45317.7774017032352276),  FLO_FC9(45337.2323100358480588),
     FLO_FC9(45356.6893056930202874),  FLO_FC9(45376.1483882269967580),
     FLO_FC9(45395.6095571902696975),  FLO_FC9(45415.0728121355568874),
     FLO_FC9(45434.5381526158234919),  FLO_FC9(45454.0055781842820579),
     FLO_FC9(45473.4750883943561348),  FLO_FC9(45492.9466827997457585),
     FLO_FC9(45512.4203609543619677),  FLO_FC9(45531.8961224123631837),
     FLO_FC9(45551.3739667281552101),  FLO_FC9(45570.8538934563621297),
     FLO_FC9(45590.3359021518699592),  FLO_FC9(45609.8199923697757185),
     FLO_FC9(45629.3061636654383619),  FLO_FC9(45648.7944155944423983),
     FLO_FC9(45668.2847477126124431),  FLO_FC9(45687.7771595760059427),
     FLO_FC9(45707.2716507409204496),  FLO_FC9(45726.7682207638936234),
     FLO_FC9(45746.2668692016959540),  FLO_FC9(45765.7675956113234861),
     FLO_FC9(45785.2703995500341989),  FLO_FC9(45804.7752805752970744),
     FLO_FC9(45824.2822382448212011),  FLO_FC9(45843.7912721165703260),
     FLO_FC9(45863.3023817487191991),  FLO_FC9(45882.8155666996826767),
     FLO_FC9(45902.3308265281302738),  FLO_FC9(45921.8481607929352322),
     FLO_FC9(45941.3675690532254521),  FLO_FC9(45960.8890508683543885),
     FLO_FC9(45980.4126057979301549),  FLO_FC9(45999.9382334017573157),
     FLO_FC9(46019.4659332399023697),  FLO_FC9(46038.9957048726573703),
     FLO_FC9(46058.5275478605472017),  FLO_FC9(46078.0614617643295787),
     FLO_FC9(46097.5974461450023227),  FLO_FC9(46117.1355005637742579),
     FLO_FC9(46136.6756245821088669),  FLO_FC9(46156.2178177617024630),
     FLO_FC9(46175.7620796644623624),  FLO_FC9(46195.3084098525432637),
     FLO_FC9(46214.8568078883326962),  FLO_FC9(46234.4072733344437438),
     FLO_FC9(46253.9598057537150453),  FLO_FC9(46273.5144047092398978),
     FLO_FC9(46293.0710697643153253),  FLO_FC9(46312.6298004824784584),
     FLO_FC9(46332.1905964274992584),  FLO_FC9(46351.7534571633805172),
     FLO_FC9(46371.3183822543505812),  FLO_FC9(46390.8853712648633518),
     FLO_FC9(46410.4544237596201128),  FLO_FC9(46430.0255393035258749),
     FLO_FC9(46449.5987174617330311),  FLO_FC9(46469.1739577996195294),
     FLO_FC9(46488.7512598827815964),  FLO_FC9(46508.3306232770701172),
     FLO_FC9(46527.9120475485324278),  FLO_FC9(46547.4955322634705226),
     FLO_FC9(46567.0810769883973990),  FLO_FC9(46586.6686812900588848),
     FLO_FC9(46606.2583447354336386),  FLO_FC9(46625.8500668917185976),
     FLO_FC9(46645.4438473263508058),  FLO_FC9(46665.0396856069855858),
     FLO_FC9(46684.6375813014965388),  FLO_FC9(46704.2375339780046488),
     FLO_FC9(46723.8395432048419025),  FLO_FC9(46743.4436085505731171),
     FLO_FC9(46763.0497295839886647),  FLO_FC9(46782.6579058741044719),
     FLO_FC9(46802.2681369901620201),  FLO_FC9(46821.8804225016283453),
     FLO_FC9(46841.4947619781960384),  FLO_FC9(46861.1111549897759687),
     FLO_FC9(46880.7296011065263883),  FLO_FC9(46900.3500998987947241),
     FLO_FC9(46919.9726509371903376),  FLO_FC9(46939.5972537925263168),
     FLO_FC9(46959.2239080358413048),  FLO_FC9(46978.8526132383994991),
     FLO_FC9(46998.4833689716906520),  FLO_FC9(47018.1161748074300704),
     FLO_FC9(47037.7510303175513400),  FLO_FC9(47057.3879350742136012),
     FLO_FC9(47077.0268886498088250),  FLO_FC9(47096.6678906169399852),
     FLO_FC9(47116.3109405484283343),  FLO_FC9(47135.9560380173279555),
     FLO_FC9(47155.6031825969184865),  FLO_FC9(47175.2523738606978441),
     FLO_FC9(47194.9036113823749474),  FLO_FC9(47214.5568947358988225),
     FLO_FC9(47234.2122234954222222),  FLO_FC9(47253.8695972353380057),
     FLO_FC9(47273.5290155302500352),  FLO_FC9(47293.1904779549804516),
     FLO_FC9(47312.8539840845769504),  FLO_FC9(47332.5195334943055059),
     FLO_FC9(47352.1871257596576470),  FLO_FC9(47371.8567604563431814),
     FLO_FC9(47391.5284371602974716),  FLO_FC9(47411.2021554476523306),
     FLO_FC9(47430.8779148947869544),  FLO_FC9(47450.5557150782988174),
     FLO_FC9(47470.2355555749818450),  FLO_FC9(47489.9174359618627932),
     FLO_FC9(47509.6013558162012487),  FLO_FC9(47529.2873147154532489),
     FLO_FC9(47548.9753122373076621),  FLO_FC9(47568.6653479596716352),
     FLO_FC9(47588.3574214606560417),  FLO_FC9(47608.0515323186045862),
     FLO_FC9(47627.7476801120719756),  FLO_FC9(47647.4458644198457478),
     FLO_FC9(47667.1460848209098913),  FLO_FC9(47686.8483408944739494),
     FLO_FC9(47706.5526322199730203),  FLO_FC9(47726.2589583770459285),
     FLO_FC9(47745.9673189455570537),  FLO_FC9(47765.6777135055817780),
     FLO_FC9(47785.3901416374283144),  FLO_FC9(47805.1046029216013267),
     FLO_FC9(47824.8210969388237572),  FLO_FC9(47844.5396232700441033),
     FLO_FC9(47864.2601814964291407),  FLO_FC9(47883.9827711993493722),
     FLO_FC9(47903.7073919603935792),  FLO_FC9(47923.4340433613760979),
     FLO_FC9(47943.1627249843077152),  FLO_FC9(47962.8934364114393247),
     FLO_FC9(47982.6261772252182709),  FLO_FC9(48002.3609470083101769),
     FLO_FC9(48022.0977453435989446),  FLO_FC9(48041.8365718141722027),
     FLO_FC9(48061.5774260033504106),  FLO_FC9(48081.3203074946504785),
     FLO_FC9(48101.0652158718148712),  FLO_FC9(48120.8121507187897805),
     FLO_FC9(48140.5611116197396768),  FLO_FC9(48160.3120981590473093),
     FLO_FC9(48180.0651099213064299),  FLO_FC9(48199.8201464913072414),
     FLO_FC9(48219.5772074540727772),  FLO_FC9(48239.3362923948443495),
     FLO_FC9(48259.0974008990451694),  FLO_FC9(48278.8605325523385545),
     FLO_FC9(48298.6256869405915495),  FLO_FC9(48318.3928636498749256),
     FLO_FC9(48338.1620622664850089),  FLO_FC9(48357.9332823769145762),
     FLO_FC9(48377.7065235678892350),  FLO_FC9(48397.4817854263164918),
     FLO_FC9(48417.2590675393439597),  FLO_FC9(48437.0383694943084265),
     FLO_FC9(48456.8196908787649591),  FLO_FC9(48476.6030312804869027),
     FLO_FC9(48496.3883902874513296),  FLO_FC9(48516.1757674878390389),
     FLO_FC9(48535.9651624700418324),  FLO_FC9(48555.7565748226843425),
     FLO_FC9(48575.5500041345658246),  FLO_FC9(48595.3454499947183649),
     FLO_FC9(48615.1429119923777762),  FLO_FC9(48634.9423897169908741),
     FLO_FC9(48654.7438827582009253),  FLO_FC9(48674.5473907058767509),
     FLO_FC9(48694.3529131500908989),  FLO_FC9(48714.1604496811123681),
     FLO_FC9(48733.9699998894357122),  FLO_FC9(48753.7815633657592116),
     FLO_FC9(48773.5951397009848733),  FLO_FC9(48793.4107284862111555),
     FLO_FC9(48813.2283293127693469),  FLO_FC9(48833.0479417721871869),
     FLO_FC9(48852.8695654561888659),  FLO_FC9(48872.6931999567168532),
     FLO_FC9(48892.5188448659246205),  FLO_FC9(48912.3464997761548148),
     FLO_FC9(48932.1761642799756373),  FLO_FC9(48952.0078379701517406),
     FLO_FC9(48971.8415204396587797),  FLO_FC9(48991.6772112816761364),
     FLO_FC9(49011.5149100895869196),  FLO_FC9(49031.3546164569779648),
     FLO_FC9(49051.1963299776543863),  FLO_FC9(49071.0400502456104732),
     FLO_FC9(49090.8857768550587934),  FLO_FC9(49110.7335094004083658),
     FLO_FC9(49130.5832474762792117),  FLO_FC9(49150.4349906774878036),
     FLO_FC9(49170.2887385990616167),  FLO_FC9(49190.1444908362391288),
     FLO_FC9(49210.0022469844407169),  FLO_FC9(49229.8620066393268644),
     FLO_FC9(49249.7237693967181258),  FLO_FC9(49269.5875348526751623),
     FLO_FC9(49289.4533026034478098),  FLO_FC9(49309.3210722454823554),
     FLO_FC9(49329.1908433754506405),  FLO_FC9(49349.0626155901918537),
     FLO_FC9(49368.9363884867852903),  FLO_FC9(49388.8121616624921444),
     FLO_FC9(49408.6899347147846129),  FLO_FC9(49428.5697072413240676),
     FLO_FC9(49448.4514788399901590),  FLO_FC9(49468.3352491088662646),
     FLO_FC9(49488.2210176462103846),  FLO_FC9(49508.1087840505206259),
     FLO_FC9(49527.9985479204697185),  FLO_FC9(49547.8903088549341192),
     FLO_FC9(49567.7840664530085633),  FLO_FC9(49587.6798203139769612),
     FLO_FC9(49607.5775700373123982),  FLO_FC9(49627.4773152227207902),
     FLO_FC9(49647.3790554700754001),  FLO_FC9(49667.2827903794604936),
     FLO_FC9(49687.1885195511786151),  FLO_FC9(49707.0962425857069320),
     FLO_FC9(49727.0059590837408905),  FLO_FC9(49746.9176686461651116),
     FLO_FC9(49766.8313708740679431),  FLO_FC9(49786.7470653687341837),
     FLO_FC9(49806.6647517316596350),  FLO_FC9(49826.5844295645147213),
     FLO_FC9(49846.5060984692026977),  FLO_FC9(49866.4297580477941665),
     FLO_FC9(49886.3554079025780084),  FLO_FC9(49906.2830476360322791),
     FLO_FC9(49926.2126768508460373),  FLO_FC9(49946.1442951498829643),
     FLO_FC9(49966.0779021362250205),  FLO_FC9(49986.0134974131506169),
     FLO_FC9(50005.9510805841346155),  FLO_FC9(50025.8906512528337771),
     FLO_FC9(50045.8322090231231414),  FLO_FC9(50065.7757534990669228),
     FLO_FC9(50085.7212842849330627),  FLO_FC9(50105.6688009851641254),
     FLO_FC9(50125.6183032044282299),  FLO_FC9(50145.5697905475753942),
     FLO_FC9(50165.5232626196520869),  FLO_FC9(50185.4787190259012277),
     FLO_FC9(50205.4361593717694632),  FLO_FC9(50225.3955832628926146),
     FLO_FC9(50245.3569903051029542),  FLO_FC9(50265.3203801044292049),
     FLO_FC9(50285.2857522671038168),  FLO_FC9(50305.2531063995338627),
     FLO_FC9(50325.2224421083374182),  FLO_FC9(50345.1937590003290097),
     FLO_FC9(50365.1670566825196147),  FLO_FC9(50385.1423347621021094),
     FLO_FC9(50405.1195928464730969),  FLO_FC9(50425.0988305432183552),
     FLO_FC9(50445.0800474601273891),  FLO_FC9(50465.0632432051788783),
     FLO_FC9(50485.0484173865406774),  FLO_FC9(50505.0355696125770919),
     FLO_FC9(50525.0246994918561541),  FLO_FC9(50545.0158066331277951),
     FLO_FC9(50565.0088906453383970),  FLO_FC9(50585.0039511376307928),
     FLO_FC9(50605.0009877193297143),  FLO_FC9(50624.9999999999708962),
     FLO_FC9(50645.0009875892646960),  FLO_FC9(50665.0039500971324742),
     FLO_FC9(50685.0088871336774901),  FLO_FC9(50705.0157983091921778),
     FLO_FC9(50725.0246832341654226),  FLO_FC9(50745.0355415192825603),
     FLO_FC9(50765.0483727754108259),  FLO_FC9(50785.0631766136211809),
     FLO_FC9(50805.0799526451592101),  FLO_FC9(50825.0987004814887769),
     FLO_FC9(50845.1194197342410916),  FLO_FC9(50865.1421100152438157),
     FLO_FC9(50885.1667709365210612),  FLO_FC9(50905.1934021102788392),
     FLO_FC9(50925.2220031489341636),  FLO_FC9(50945.2525736650713952),
     FLO_FC9(50965.2851132714713458),  FLO_FC9(50985.3196215811185539),
     FLO_FC9(51005.3560982071721810),  FLO_FC9(51025.3945427629805636),
     FLO_FC9(51045.4349548620957648),  FLO_FC9(51065.4773341182444710),
     FLO_FC9(51085.5216801453570952),  FLO_FC9(51105.5679925575459492),
     FLO_FC9(51125.6162709691125201),  FLO_FC9(51145.6665149945401936),
     FLO_FC9(51165.7187242485233583),  FLO_FC9(51185.7728983459164738),
     FLO_FC9(51205.8290369017777266),  FLO_FC9(51225.8871395313617541),
     FLO_FC9(51245.9472058501050924),  FLO_FC9(51266.0092354736189009),
     FLO_FC9(51286.0732280177180655),  FLO_FC9(51306.1391830983993714),
     FLO_FC9(51326.2071003318560543),  FLO_FC9(51346.2769793344486970),
     FLO_FC9(51366.3488197227561614),  FLO_FC9(51386.4226211135101039),
     FLO_FC9(51406.4983831236531842),  FLO_FC9(51426.5761053703099606),
     FLO_FC9(51446.6557874707868905),  FLO_FC9(51466.7374290425868821),
     FLO_FC9(51486.8210297033801908),  FLO_FC9(51506.9065890710480744),
     FLO_FC9(51526.9941067636318621),  FLO_FC9(51547.0835823993911617),
     FLO_FC9(51567.1750155967383762),  FLO_FC9(51587.2684059742969112),
     FLO_FC9(51607.3637531508575194),  FLO_FC9(51627.4610567454146803),
     FLO_FC9(51647.5603163771302206),  FLO_FC9(51667.6615316653624177),
     FLO_FC9(51687.7647022296514479),  FLO_FC9(51707.8698276897266624),
     FLO_FC9(51727.9769076654993114),  FLO_FC9(51748.0859417770552682),
     FLO_FC9(51768.1969296446768567),  FLO_FC9(51788.3098708888355759),
     FLO_FC9(51808.4247651301702717),  FLO_FC9(51828.5416119895235170),
     FLO_FC9(51848.6604110879052314),  FLO_FC9(51868.7811620465145097),
     FLO_FC9(51888.9038644867396215),  FLO_FC9(51909.0285180301434593),
     FLO_FC9(51929.1551222984853666),  FLO_FC9(51949.2836769136847579),
     FLO_FC9(51969.4141814978720504),  FLO_FC9(51989.5466356733450084),
     FLO_FC9(52009.6810390625905711),  FLO_FC9(52029.8173912882630248),
     FLO_FC9(52049.9556919732131064),  FLO_FC9(52070.0959407404807280),
     FLO_FC9(52090.2381372132731485),  FLO_FC9(52110.3822810149868019),
     FLO_FC9(52130.5283717692000209),  FLO_FC9(52150.6764090996657615),
     FLO_FC9(52170.8263926303334301),  FLO_FC9(52190.9783219853197807),
     FLO_FC9(52211.1321967889307416),  FLO_FC9(52231.2880166656541405),
     FLO_FC9(52251.4457812401451520),  FLO_FC9(52271.6054901372699533),
     FLO_FC9(52291.7671429820402409),  FLO_FC9(52311.9307393996641622),
     FLO_FC9(52332.0962790155463153),  FLO_FC9(52352.2637614552440937),
     FLO_FC9(52372.4331863445186173),  FLO_FC9(52392.6045533092838014),
     FLO_FC9(52412.7778619756645639),  FLO_FC9(52432.9531119699458941),
     FLO_FC9(52453.1303029185946798),  FLO_FC9(52473.3094344482742599),
     FLO_FC9(52493.4905061857934925),  FLO_FC9(52513.6735177581795142),
     FLO_FC9(52533.8584687926049810),  FLO_FC9(52554.0453589164462755),
     FLO_FC9(52574.2341877572544036),  FLO_FC9(52594.4249549427404418),
     FLO_FC9(52614.6176601008119178),  FLO_FC9(52634.8123028595582582),
     FLO_FC9(52655.0088828472289606),  FLO_FC9(52675.2073996922699735),
     FLO_FC9(52695.4078530232945923),  FLO_FC9(52715.6102424690980115),
     FLO_FC9(52735.8145676586573245),  FLO_FC9(52756.0208282211096957),
     FLO_FC9(52776.2290237858032924),  FLO_FC9(52796.4391539822245250),
     FLO_FC9(52816.6512184400562546),  FLO_FC9(52836.8652167891705176),
     FLO_FC9(52857.0811486595994211),  FLO_FC9(52877.2990136815496953),
     FLO_FC9(52897.5188114854245214),  FLO_FC9(52917.7405417017725995),
     FLO_FC9(52937.9642039613536326),  FLO_FC9(52958.1897978950801189),
     FLO_FC9(52978.4173231340464554),  FLO_FC9(52998.6467793095289380),
     FLO_FC9(53018.8781660529784858),  FLO_FC9(53039.1114829960060888),
     FLO_FC9(53059.3467297704191878),  FLO_FC9(53079.5839060081925709),
     FLO_FC9(53099.8230113414829248),  FLO_FC9(53120.0640454025997315),
     FLO_FC9(53140.3070078240634757),  FLO_FC9(53160.5518982385328854),
     FLO_FC9(53180.7987162788704154),  FLO_FC9(53201.0474615780913155),
     FLO_FC9(53221.2981337694000104),  FLO_FC9(53241.5507324861755478),
     FLO_FC9(53261.8052573619643226),  FLO_FC9(53282.0617080304873525),
     FLO_FC9(53302.3200841256402782),  FLO_FC9(53322.5803852814933634),
     FLO_FC9(53342.8426111322987708),  FLO_FC9(53363.1067613124687341),
     FLO_FC9(53383.3728354565973859),  FLO_FC9(53403.6408331994534819),
     FLO_FC9(53423.9107541759731248),  FLO_FC9(53444.1825980212597642),
     FLO_FC9(53464.4563643706133007),  FLO_FC9(53484.7320528594791540),
     FLO_FC9(53505.0096631234991946),  FLO_FC9(53525.2891947984680883),
     FLO_FC9(53545.5706475203623995),  FLO_FC9(53565.8540209253333160),
     FLO_FC9(53586.1393146496993722),  FLO_FC9(53606.4265283299537259),
     FLO_FC9(53626.7156616027641576),  FLO_FC9(53647.0067141049585189),
     FLO_FC9(53667.2996854735465604),  FLO_FC9(53687.5945753457199316),
     FLO_FC9(53707.8913833588158013),  FLO_FC9(53728.1901091503605130),
     FLO_FC9(53748.4907523580550333),  FLO_FC9(53768.7933126197531237),
     FLO_FC9(53789.0977895734977210),  FLO_FC9(53809.4041828574845567),
     FLO_FC9(53829.7124921101058135),  FLO_FC9(53850.0227169698991929),
     FLO_FC9(53870.3348570755842957),  FLO_FC9(53890.6489120660553453),
     FLO_FC9(53910.9648815803666366),  FLO_FC9(53931.2827652577398112),
     FLO_FC9(53951.6025627375856857),  FLO_FC9(53971.9242736594605958),
     FLO_FC9(53992.2478976631100522),  FLO_FC9(54012.5734343884396367),
     FLO_FC9(54032.9008834755295538),  FLO_FC9(54053.2302445646200795),
     FLO_FC9(54073.5615172961333883),  FLO_FC9(54093.8947013106444501),
     FLO_FC9(54114.2297962489101337),  FLO_FC9(54134.5668017518546549),
     FLO_FC9(54154.9057174605695764),  FLO_FC9(54175.2465430163138080),
     FLO_FC9(54195.5892780605063308),  FLO_FC9(54215.9339222347553005),
     FLO_FC9(54236.2804751808143919),  FLO_FC9(54256.6289365406264551),
     FLO_FC9(54276.9793059562798589),  FLO_FC9(54297.3315830700448714),
     FLO_FC9(54317.6857675243591075),  FLO_FC9(54338.0418589618275291),
     FLO_FC9(54358.3998570252151694),  FLO_FC9(54378.7597613574544084),
     FLO_FC9(54399.1215716016668011),  FLO_FC9(54419.4852874011048698),
     FLO_FC9(54439.8509083992248634),  FLO_FC9(54460.2184342396139982),
     FLO_FC9(54480.5878645660559414),  FLO_FC9(54500.9591990224798792),
     FLO_FC9(54521.3324372529968969),  FLO_FC9(54541.7075789018781506),
     FLO_FC9(54562.0846236135548679),  FLO_FC9(54582.4635710326401750),
     FLO_FC9(54602.8444208038854413),  FLO_FC9(54623.2271725722457631),
     FLO_FC9(54643.6118259828072041),  FLO_FC9(54663.9983806808377267),
     FLO_FC9(54684.3868363117726403),  FLO_FC9(54704.7771925212073256),
     FLO_FC9(54725.1694489548972342),  FLO_FC9(54745.5636052587724407),
     FLO_FC9(54765.9596610789230908),  FLO_FC9(54786.3576160616139532),
     FLO_FC9(54806.7574698532553157),  FLO_FC9(54827.1592221004393650),
     FLO_FC9(54847.5628724499038071),  FLO_FC9(54867.9684205485827988),
     FLO_FC9(54888.3758660435341881),  FLO_FC9(54908.7852085820122738),
     FLO_FC9(54929.1964478114168742),  FLO_FC9(54949.6095833793224301),
     FLO_FC9(54970.0246149334634538),  FLO_FC9(54990.4415421217272524),
     FLO_FC9(55010.8603645921903080),  FLO_FC9(55031.2810819930600701),
     FLO_FC9(55051.7036939727331628),  FLO_FC9(55072.1282001797590056),
     FLO_FC9(55092.5546002628398128),  FLO_FC9(55112.9828938708742498),
     FLO_FC9(55133.4130806528773974),  FLO_FC9(55153.8451602580607869),
     FLO_FC9(55174.2791323357887450),  FLO_FC9(55194.7149965355856693),
     FLO_FC9(55215.1527525071433047),  FLO_FC9(55235.5923999002989149),
     FLO_FC9(55256.0339383650789387),  FLO_FC9(55276.4773675516553340),
     FLO_FC9(55296.9226871103601297),  FLO_FC9(55317.3698966916854260),
     FLO_FC9(55337.8189959463052219),  FLO_FC9(55358.2699845250244834),
     FLO_FC9(55378.7228620788300759),  FLO_FC9(55399.1776282588689355),
     FLO_FC9(55419.6342827164407936),  FLO_FC9(55440.0928251030127285),
     FLO_FC9(55460.5532550702046137),  FLO_FC9(55481.0155722698036698),
     FLO_FC9(55501.4797763537644641),  FLO_FC9(55521.9458669741870835),
     FLO_FC9(55542.4138437833389617),  FLO_FC9(55562.8837064336548792),
     FLO_FC9(55583.3554545777151361),  FLO_FC9(55603.8290878682601033),
     FLO_FC9(55624.3046059582193266),  FLO_FC9(55644.7820085006387671),
     FLO_FC9(55665.2612951487535611),  FLO_FC9(55685.7424655559516395),
     FLO_FC9(55706.2255193757737288),  FLO_FC9(55726.7104562619279022),
     FLO_FC9(55747.1972758682750282),  FLO_FC9(55767.6859778488433221),
     FLO_FC9(55788.1765618578137946),  FLO_FC9(55808.6690275495275273),
     FLO_FC9(55829.1633745784783969),  FLO_FC9(55849.6596025993276271),
     FLO_FC9(55870.1577112668892369),  FLO_FC9(55890.6577002361445921),
     FLO_FC9(55911.1595691622205777),  FLO_FC9(55931.6633177004114259),
     FLO_FC9(55952.1689455061641638),  FLO_FC9(55972.6764522350858897),
     FLO_FC9(55993.1858375429437729),  FLO_FC9(56013.6971010856505018),
     FLO_FC9(56034.2102425193006638),  FLO_FC9(56054.7252615001198137),
     FLO_FC9(56075.2421576845081290),  FLO_FC9(56095.7609307290113065),
     FLO_FC9(56116.2815802903423901),  FLO_FC9(56136.8041060253672185),
     FLO_FC9(56157.3285075911044260),  FLO_FC9(56177.8547846447399934),
     FLO_FC9(56198.3829368435981451),  FLO_FC9(56218.9129638451850042),
     FLO_FC9(56239.4448653071376611),  FLO_FC9(56259.9786408872678294),
     FLO_FC9(56280.5142902435254655),  FLO_FC9(56301.0518130340424250),
     FLO_FC9(56321.5912089170815307),  FLO_FC9(56342.1324775510802283),
     FLO_FC9(56362.6756185946142068),  FLO_FC9(56383.2206317064192262),
     FLO_FC9(56403.7675165453983936),  FLO_FC9(56424.3162727706076112),
     FLO_FC9(56444.8669000412410242),  FLO_FC9(56465.4193980166674010),
     FLO_FC9(56485.9737663563937531),  FLO_FC9(56506.5300047201017151),
     FLO_FC9(56527.0881127676111646),  FLO_FC9(56547.6480901589020505),
     FLO_FC9(56568.2099365541071165),  FLO_FC9(56588.7736516135191778),
     FLO_FC9(56609.3392349975838442),  FLO_FC9(56629.9066863668995211),
     FLO_FC9(56650.4760053822101327),  FLO_FC9(56671.0471917044196744),
     FLO_FC9(56691.6202449945994886),  FLO_FC9(56712.1951649139591609),
     FLO_FC9(56732.7719511238683481),  FLO_FC9(56753.3506032858349499),
     FLO_FC9(56773.9311210615414893),  FLO_FC9(56794.5135041128232842),
     FLO_FC9(56815.0977521016466198),  FLO_FC9(56835.6838646901524044),
     FLO_FC9(56856.2718415406270651),  FLO_FC9(56876.8616823155098245),
     FLO_FC9(56897.4533866773927002),  FLO_FC9(56918.0469542890277808),
     FLO_FC9(56938.6423848132981220),  FLO_FC9(56959.2396779132614029),
     FLO_FC9(56979.8388332521208213),  FLO_FC9(57000.4398504932250944),
     FLO_FC9(57021.0427293000902864),  FLO_FC9(57041.6474693363707047),
     FLO_FC9(57062.2540702658734517),  FLO_FC9(57082.8625317525584251),
     FLO_FC9(57103.4728534605528694),  FLO_FC9(57124.0850350541077205),
     FLO_FC9(57144.6990761976485373),  FLO_FC9(57165.3149765557391220),
     FLO_FC9(57185.9327357931033475),  FLO_FC9(57206.5523535746106063),
     FLO_FC9(57227.1738295652758097),  FLO_FC9(57247.7971634302812163),
     FLO_FC9(57268.4223548349400517),  FLO_FC9(57289.0494034447328886),
     FLO_FC9(57309.6783089252858190),  FLO_FC9(57330.3090709423704538),
     FLO_FC9(57350.9416891619111993),  FLO_FC9(57371.5761632499852567),
     FLO_FC9(57392.2124928728153463),  FLO_FC9(57412.8506776967842598),
     FLO_FC9(57433.4907173884057556),  FLO_FC9(57454.1326116143682157),
     FLO_FC9(57474.7763600414909888),  FLO_FC9(57495.4219623367462191),
     FLO_FC9(57516.0694181672661216),  FLO_FC9(57536.7187272003138787),
     FLO_FC9(57557.3698891033200198),  FLO_FC9(57578.0229035438605933),
     FLO_FC9(57598.6777701896426152),  FLO_FC9(57619.3344887085477239),
     FLO_FC9(57639.9930587685885257),  FLO_FC9(57660.6534800379376975),
     FLO_FC9(57681.3157521849061595),  FLO_FC9(57701.9798748779649031),
     FLO_FC9(57722.6458477857304388),  FLO_FC9(57743.3136705769502441),
     FLO_FC9(57763.9833429205464199),  FLO_FC9(57784.6548644855720340),
     FLO_FC9(57805.3282349412329495),  FLO_FC9(57826.0034539568805485),
     FLO_FC9(57846.6805212020262843),  FLO_FC9(57867.3594363463125774),
     FLO_FC9(57888.0401990595273674),  FLO_FC9(57908.7228090116332169),
     FLO_FC9(57929.4072658727091039),  FLO_FC9(57950.0935693130013533),
     FLO_FC9(57970.7817190028945333),  FLO_FC9(57991.4717146129114553),
     FLO_FC9(58012.1635558137495536),  FLO_FC9(58032.8572422762226779),
     FLO_FC9(58053.5527736713120248),  FLO_FC9(58074.2501496701297583),
     FLO_FC9(58094.9493699439481134),  FLO_FC9(58115.6504341641848441),
     FLO_FC9(58136.3533420023886720),  FLO_FC9(58157.0580931302756653),
     FLO_FC9(58177.7646872196928598),  FLO_FC9(58198.4731239426400862),
     FLO_FC9(58219.1834029712554184),  FLO_FC9(58239.8955239778370014),
     FLO_FC9(58260.6094866348212236),  FLO_FC9(58281.3252906147754402),
     FLO_FC9(58302.0429355904343538),  FLO_FC9(58322.7624212346781860),
     FLO_FC9(58343.4837472205108497),  FLO_FC9(58364.2069132210963289),
     FLO_FC9(58384.9319189097514027),  FLO_FC9(58405.6587639599238173),
     FLO_FC9(58426.3874480451995623),  FLO_FC9(58447.1179708393392502),
     FLO_FC9(58467.8503320162126329),  FLO_FC9(58488.5845312498640851),
     FLO_FC9(58509.3205682144616731),  FLO_FC9(58530.0584425843335339),
     FLO_FC9(58550.7981540339314961),  FLO_FC9(58571.5397022378747351),
     FLO_FC9(58592.2830868709061178),  FLO_FC9(58613.0283076079285820),
     FLO_FC9(58633.7753641239833087),  FLO_FC9(58654.5242560942497221),
     FLO_FC9(58675.2749831940527656),  FLO_FC9(58696.0275450988774537),
     FLO_FC9(58716.7819414843252162),  FLO_FC9(58737.5381720261575538),
     FLO_FC9(58758.2962364002742106),  FLO_FC9(58779.0561342827277258),
     FLO_FC9(58799.8178653496943298),  FLO_FC9(58820.5814292775030481),
     FLO_FC9(58841.3468257426429773),  FLO_FC9(58862.1140544217123534),
     FLO_FC9(58882.8831149914840353),  FLO_FC9(58903.6540071288472973),
     FLO_FC9(58924.4267305108514847),  FLO_FC9(58945.2012848146841861),
     FLO_FC9(58965.9776697176639573),  FLO_FC9(58986.7558848972694250),
     FLO_FC9(59007.5359300311174593),  FLO_FC9(59028.3178047969486215),
     FLO_FC9(59049.1015088726635440),  FLO_FC9(59069.8870419363011024),
     FLO_FC9(59090.6744036660456914),  FLO_FC9(59111.4635937402126729),
     FLO_FC9(59132.2546118372629280),  FLO_FC9(59153.0474576358028571),
     FLO_FC9(59173.8421308145698276),  FLO_FC9(59194.6386310524685541),
     FLO_FC9(59215.4369580285056145),  FLO_FC9(59236.2371114218549337),
     FLO_FC9(59257.0390909118286800),  FLO_FC9(59277.8428961778772646),
     FLO_FC9(59298.6485268995893421),  FLO_FC9(59319.4559827566845343),
     FLO_FC9(59340.2652634290498099),  FLO_FC9(59361.0763685966958292),
     FLO_FC9(59381.8892979397569434),  FLO_FC9(59402.7040511385421269),
     FLO_FC9(59423.5206278734767693),  FLO_FC9(59444.3390278251390555),
     FLO_FC9(59465.1592506742308615),  FLO_FC9(59485.9812961015995825),
     FLO_FC9(59506.8051637882526848),  FLO_FC9(59527.6308534153140499),
     FLO_FC9(59548.4583646640458028),  FLO_FC9(59569.2876972158628632),
     FLO_FC9(59590.1188507523183944),  FLO_FC9(59610.9518249550892506),
     FLO_FC9(59631.7866195060123573),  FLO_FC9(59652.6232340870483313),
     FLO_FC9(59673.4616683803105843),  FLO_FC9(59694.3019220680289436),
     FLO_FC9(59715.1439948325933074),  FLO_FC9(59735.9878863565245410),
     FLO_FC9(59756.8335963224817533),  FLO_FC9(59777.6811244132550200),
     FLO_FC9(59798.5304703117944882),  FLO_FC9(59819.3816337011594442),
     FLO_FC9(59840.2346142645692453),  FLO_FC9(59861.0894116853814921),
     FLO_FC9(59881.9460256470702006),  FLO_FC9(59902.8044558332694578),
     FLO_FC9(59923.6647019277443178),  FLO_FC9(59944.5267636143835261),
     FLO_FC9(59965.3906405772431754),  FLO_FC9(59986.2563325004884973),
     FLO_FC9(60007.1238390684375190),  FLO_FC9(60027.9931599655392347),
     FLO_FC9(60048.8642948763808818),  FLO_FC9(60069.7372434856879408),
     FLO_FC9(60090.6120054783241358),  FLO_FC9(60111.4885805392841576),
     FLO_FC9(60132.3669683537082165),  FLO_FC9(60153.2471686068674899),
     FLO_FC9(60174.1291809841641225),  FLO_FC9(60195.0130051711530541),
     FLO_FC9(60215.8986408535129158),  FLO_FC9(60236.7860877170605818),
     FLO_FC9(60257.6753454477511696),  FLO_FC9(60278.5664137316707638),
     FLO_FC9(60299.4592922550436924),  FLO_FC9(60320.3539807042470784),
     FLO_FC9(60341.2504787657599081),  FLO_FC9(60362.1487861262285151),
     FLO_FC9(60383.0489024724156479),  FLO_FC9(60403.9508274912368506),
     FLO_FC9(60424.8545608697168063),  FLO_FC9(60445.7601022950402694),
     FLO_FC9(60466.6674514545156853),  FLO_FC9(60487.5766080355897429),
     FLO_FC9(60508.4875717258473742),  FLO_FC9(60529.4003422129972023),
     FLO_FC9(60550.3149191848933697),  FLO_FC9(60571.2313023295209859),
     FLO_FC9(60592.1494913350034039),  FLO_FC9(60613.0694858895876678),
     FLO_FC9(60633.9912856816736166),  FLO_FC9(60654.9148903997847810),
     FLO_FC9(60675.8402997325683828),  FLO_FC9(60696.7675133688317146),
     FLO_FC9(60717.6965309974839329),  FLO_FC9(60738.6273523076015408),
     FLO_FC9(60759.5599769883701811),  FLO_FC9(60780.4944047291282914),
     FLO_FC9(60801.4306352193234488),  FLO_FC9(60822.3686681485560257),
     FLO_FC9(60843.3085032065646374),  FLO_FC9(60864.2501400832043146),
     FLO_FC9(60885.1935784684683313),  FLO_FC9(60906.1388180524954805),
     FLO_FC9(60927.0858585255409707),  FLO_FC9(60948.0346995780055295),
     FLO_FC9(60968.9853409004208515),  FLO_FC9(60989.9377821834423230),
     FLO_FC9(61010.8920231178635731),  FLO_FC9(61031.8480633946164744),
     FLO_FC9(61052.8059027047638665),  FLO_FC9(61073.7655407394922804),
     FLO_FC9(61094.7269771901337663),  FLO_FC9(61115.6902117481367895),
     FLO_FC9(61136.6552441051026108),  FLO_FC9(61157.6220739527416299),
     FLO_FC9(61178.5907009829170420),  FLO_FC9(61199.5611248876157333),
     FLO_FC9(61220.5333453589482815),  FLO_FC9(61241.5073620891707833),
     FLO_FC9(61262.4831747706630267),  FLO_FC9(61283.4607830959430430),
     FLO_FC9(61304.4401867576452787),  FLO_FC9(61325.4213854485569755),
     FLO_FC9(61346.4043788615817903),  FLO_FC9(61367.3891666897616233),
     FLO_FC9(61388.3757486262620660),  FLO_FC9(61409.3641243643869529),
     FLO_FC9(61430.3542935975710861),  FLO_FC9(61451.3462560193729587),
     FLO_FC9(61472.3400113234965829),  FLO_FC9(61493.3355592037623865),
     FLO_FC9(61514.3328993541217642),  FLO_FC9(61535.3320314686716301),
     FLO_FC9(61556.3329552416180377),  FLO_FC9(61577.3356703673125594),
     FLO_FC9(61598.3401765402377350),  FLO_FC9(61619.3464734549925197),
     FLO_FC9(61640.3545608063286636),  FLO_FC9(61661.3644382890997804),
     FLO_FC9(61682.3761055983122787),  FLO_FC9(61703.3895624290889828),
     FLO_FC9(61724.4048084766909597),  FLO_FC9(61745.4218434365102439),
     FLO_FC9(61766.4406670040625613),  FLO_FC9(61787.4612788749873289),
     FLO_FC9(61808.4836787450694828),  FLO_FC9(61829.5078663102030987),
     FLO_FC9(61850.5338412664350471),  FLO_FC9(61871.5616033099286142),
     FLO_FC9(61892.5911521369707771),  FLO_FC9(61913.6224874439867563),
     FLO_FC9(61934.6556089275254635),  FLO_FC9(61955.6905162842667778),
     FLO_FC9(61976.7272092110215453),  FLO_FC9(61997.7656874047243036),
     FLO_FC9(62018.8059505624478334),  FLO_FC9(62039.8479983813813305),
     FLO_FC9(62060.8918305588376825),  FLO_FC9(62081.9374467922898475),
     FLO_FC9(62102.9848467792980955),  FLO_FC9(62124.0340302175754914),
     FLO_FC9(62145.0849968049660674),  FLO_FC9(62166.1377462394157192),
     FLO_FC9(62187.1922782190304133),  FLO_FC9(62208.2485924420252559),
     FLO_FC9(62229.3066886067390442),  FLO_FC9(62250.3665664116560947),
     FLO_FC9(62271.4282255553771392),  FLO_FC9(62292.4916657366266008),
     FLO_FC9(62313.5568866542671458),  FLO_FC9(62334.6238880072705797),
     FLO_FC9(62355.6926694947615033),  FLO_FC9(62376.7632308159736567),
     FLO_FC9(62397.8355716702717473),  FLO_FC9(62418.9096917571441736),
     FLO_FC9(62439.9855907762103016),  FLO_FC9(62461.0632684272204642),
     FLO_FC9(62482.1427244100486860),  FLO_FC9(62503.2239584246854065),
     FLO_FC9(62524.3069701712665847),  FLO_FC9(62545.3917593500300427),
     FLO_FC9(62566.4783256613663980),  FLO_FC9(62587.5666688057681313),
     FLO_FC9(62608.6567884838805185),  FLO_FC9(62629.7486843964506988),
     FLO_FC9(62650.8423562443567789),  FLO_FC9(62671.9378037286223844),
     FLO_FC9(62693.0350265503657283),  FLO_FC9(62714.1340244108578190),
     FLO_FC9(62735.2347970114788041),  FLO_FC9(62756.3373440537325223),
     FLO_FC9(62777.4416652392756077),  FLO_FC9(62798.5477602698520059),
     FLO_FC9(62819.6556288473584573),  FLO_FC9(62840.7652706738008419),
     FLO_FC9(62861.8766854513232829),  FLO_FC9(62882.9898728821863187),
     FLO_FC9(62904.1048326687741792),  FLO_FC9(62925.2215645136020612),
     FLO_FC9(62946.3400681193088531),  FLO_FC9(62967.4603431886571343),
     FLO_FC9(62988.5823894245258998),  FLO_FC9(63009.7062065299396636),
     FLO_FC9(63030.8317942080175271),  FLO_FC9(63051.9591521620386629),
     FLO_FC9(63073.0882800953695551),  FLO_FC9(63094.2191777115294826),
     FLO_FC9(63115.3518447141541401),  FLO_FC9(63136.4862808069883613),
     FLO_FC9(63157.6224856939224992),  FLO_FC9(63178.7604590789560461),
     FLO_FC9(63199.9002006662194617),  FLO_FC9(63221.0417101599668968),
     FLO_FC9(63242.1849872645689175),  FLO_FC9(63263.3300316845343332),
     FLO_FC9(63284.4768431244738167),  FLO_FC9(63305.6254212891435600),
     FLO_FC9(63326.7757658834088943),  FLO_FC9(63347.9278766122588422),
     FLO_FC9(63369.0817531808133936),  FLO_FC9(63390.2373952943162294),
     FLO_FC9(63411.3948026581201702),  FLO_FC9(63432.5539749777162797),
     FLO_FC9(63453.7149119587120367),  FLO_FC9(63474.8776133068386116),
     FLO_FC9(63496.0420787279435899),  FLO_FC9(63517.2083079279982485),
     FLO_FC9(63538.3763006131193833),  FLO_FC9(63559.5460564895038260),
     FLO_FC9(63580.7175752635157551),  FLO_FC9(63601.8908566416066606),
     FLO_FC9(63623.0659003303735517),  FLO_FC9(63644.2427060365153011),
     FLO_FC9(63665.4212734668690246),  FLO_FC9(63686.6016023283809773),
     FLO_FC9(63707.7836923281356576),  FLO_FC9(63728.9675431733339792),
     FLO_FC9(63750.1531545712787192),  FLO_FC9(63771.3405262294181739),
     FLO_FC9(63792.5296578553170548),  FLO_FC9(63813.7205491566492128),
     FLO_FC9(63834.9131998412267421),  FLO_FC9(63856.1076096169781522),
     FLO_FC9(63877.3037781919410918),  FLO_FC9(63898.5017052742841770),
     FLO_FC9(63919.7013905722997151),  FLO_FC9(63940.9028337944037048),
     FLO_FC9(63962.1060346491140081),  FLO_FC9(63983.3109928450940060),
     FLO_FC9(64004.5177080911089433),  FLO_FC9(64025.7261800960477558),
     FLO_FC9(64046.9364085689376225),  FLO_FC9(64068.1483932189003099),
     FLO_FC9(64089.3621337551958277),  FLO_FC9(64110.5776298871933250),
     FLO_FC9(64131.7948813243929180),  FLO_FC9(64153.0138877764038625),
     FLO_FC9(64174.2346489529663813),  FLO_FC9(64195.4571645639371127),
     FLO_FC9(64216.6814343192891101),  FLO_FC9(64237.9074579291118425),
     FLO_FC9(64259.1352351036257460),  FLO_FC9(64280.3647655531603959),
     FLO_FC9(64301.5960489881690592),  FLO_FC9(64322.8290851192359696),
     FLO_FC9(64344.0638736570399487),  FLO_FC9(64365.3004143123980612),
     FLO_FC9(64386.5387067962510628),  FLO_FC9(64407.7787508196342969),
     FLO_FC9(64429.0205460937213502),  FLO_FC9(64450.2640923298095004),
     FLO_FC9(64471.5093892392906127),  FLO_FC9(64492.7564365337093477),
     FLO_FC9(64514.0052339247049531),  FLO_FC9(64535.2557811240330921),
     FLO_FC9(64556.5080778435803950),  FLO_FC9(64577.7621237953571836),
     FLO_FC9(64599.0179186914683669),  FLO_FC9(64620.2754622441716492),
     FLO_FC9(64641.5347541658047703),  FLO_FC9(64662.7957941688437131),
     FLO_FC9(64684.0585819658954279),  FLO_FC9(64705.3231172696614522),
     FLO_FC9(64726.5893997929742909),  FLO_FC9(64747.8574292487755883),
     FLO_FC9(64769.1272053501379560),  FLO_FC9(64790.3987278102358687),
     FLO_FC9(64811.6719963423747686),  FLO_FC9(64832.9470106599692372),
     FLO_FC9(64854.2237704765575472),  FLO_FC9(64875.5022755057943868),
     FLO_FC9(64896.7825254614508594),  FLO_FC9(64918.0645200574144837),
     FLO_FC9(64939.3482590076819179),  FLO_FC9(64960.6337420263880631),
     FLO_FC9(64981.9209688277624082),  FLO_FC9(65003.2099391261654091),
     FLO_FC9(65024.5006526360666612),  FLO_FC9(65045.7931090720667271),
     FLO_FC9(65067.0873081488607568),  FLO_FC9(65088.3832495812821435),
     FLO_FC9(65109.6809330842588679),  FLO_FC9(65130.9803583728644298),
     FLO_FC9(65152.2815251622596406),  FLO_FC9(65173.5844331677362788),
     FLO_FC9(65194.8890821047025383),  FLO_FC9(65216.1954716886830283),
     FLO_FC9(65237.5036016353187733),  FLO_FC9(65258.8134716603526613),
     FLO_FC9(65280.1250814796658233),  FLO_FC9(65301.4384308092412539),
     FLO_FC9(65322.7535193651783629),  FLO_FC9(65344.0703468637075275),
     FLO_FC9(65365.3889130211464362),  FLO_FC9(65386.7092175539582968),
     FLO_FC9(65408.0312601787009044),  FLO_FC9(65429.3550406120557454),
     FLO_FC9(65450.6805585708207218),  FLO_FC9(65472.0078137719101505),
     FLO_FC9(65493.3368059323547641),  FLO_FC9(65514.6675347692798823),
     FLO_FC9(65535.9999999999563443),  FLO_FC9(65557.3342013417568523),
     FLO_FC9(65578.6701385121705243),  FLO_FC9(65600.0078112287883414),
     FLO_FC9(65621.3472192093322519),  FLO_FC9(65642.6883621716260677),
     FLO_FC9(65664.0312398336391198),  FLO_FC9(65685.3758519134134986),
     FLO_FC9(65706.7221981291368138),  FLO_FC9(65728.0702781990839867),
     FLO_FC9(65749.4200918416609056),  FLO_FC9(65770.7716387754044263),
     FLO_FC9(65792.1249187189387158),  FLO_FC9(65813.4799313910043566),
     FLO_FC9(65834.8366765104583465),  FLO_FC9(65856.1951537963032024),
     FLO_FC9(65877.5553629675996490),  FLO_FC9(65898.9173037435539300),
     FLO_FC9(65920.2809758434887044),  FLO_FC9(65941.6463789868430467),
     FLO_FC9(65963.0135128931578947),  FLO_FC9(65984.3823772820760496),
     FLO_FC9(66005.7529718733858317),  FLO_FC9(66027.1252963869628729),
     FLO_FC9(66048.4993505427992204),  FLO_FC9(66069.8751340610178886),
     FLO_FC9(66091.2526466618437553),  FLO_FC9(66112.6318880656181136),
     FLO_FC9(66134.0128579927695682),  FLO_FC9(66155.3955561638867948),
     FLO_FC9(66176.7799822996312287),  FLO_FC9(66198.1661361207952723),
     FLO_FC9(66219.5540173482731916),  FLO_FC9(66240.9436257031047717),
     FLO_FC9(66262.3349609063880052),  FLO_FC9(66283.7280226793955080),
     FLO_FC9(66305.1228107434435515),  FLO_FC9(66326.5193248200230300),
     FLO_FC9(66347.9175646306975977),  FLO_FC9(66369.3175298971618759),
     FLO_FC9(66390.7192203412269009),  FLO_FC9(66412.1226356847910210),
     FLO_FC9(66433.5277756498835515),  FLO_FC9(66454.9346399586356711),
     FLO_FC9(66476.3432283333240775),  FLO_FC9(66497.7535404962836765),
     FLO_FC9(66519.1655761699948926),  FLO_FC9(66540.5793350770400139),
     FLO_FC9(66561.9948169401177438),  FLO_FC9(66583.4120214820432011),
     FLO_FC9(66604.8309484257333679),  FLO_FC9(66626.2515974942216417),
     FLO_FC9(66647.6739684106287314),  FLO_FC9(66669.0980608982354170),
     FLO_FC9(66690.5238746803806862),  FLO_FC9(66711.9514094805635978),
     FLO_FC9(66733.3806650223705219),  FLO_FC9(66754.8116410294751404),
     FLO_FC9(66776.2443372257112060),  FLO_FC9(66797.6787533349852310),
     FLO_FC9(66819.1148890813201433),  FLO_FC9(66840.5527441888843896),
     FLO_FC9(66861.9923183819046244),  FLO_FC9(66883.4336113847384695),
     FLO_FC9(66904.8766229218890658),  FLO_FC9(66926.3213527179032099),
     FLO_FC9(66947.7678004975023214),  FLO_FC9(66969.2159659854660276),
     FLO_FC9(66990.6658489067340270),  FLO_FC9(67012.1174489863042254),
     FLO_FC9(67033.5707659493346000),  FLO_FC9(67055.0257995210558875),
     FLO_FC9(67076.4825494268152397),  FLO_FC9(67097.9410153920762241),
     FLO_FC9(67119.4011971424333751),  FLO_FC9(67140.8630944035539869),
     FLO_FC9(67162.3267069012217689),  FLO_FC9(67183.7920343613513978),
     FLO_FC9(67205.2590765099594137),  FLO_FC9(67226.7278330731496681),
     FLO_FC9(67248.1983037771715317),  FLO_FC9(67269.6704883483471349),
     FLO_FC9(67291.1443865131441271),  FLO_FC9(67312.6199979980883654),
     FLO_FC9(67334.0973225298803300),  FLO_FC9(67355.5763598352932604),
     FLO_FC9(67377.0571096411877079),  FLO_FC9(67398.5395716745697428),
     FLO_FC9(67420.0237456625472987),  FLO_FC9(67441.5096313323301729),
     FLO_FC9(67462.9972284112300258),  FLO_FC9(67484.4865366266894853),
     FLO_FC9(67505.9775557062239386),  FLO_FC9(67527.4702853774942923),
     FLO_FC9(67548.9647253682633163),  FLO_FC9(67570.4608754063665401),
     FLO_FC9(67591.9587352197995642),  FLO_FC9(67613.4583045366307488),
     FLO_FC9(67634.9595830850303173),  FLO_FC9(67656.4625705933285644),
     FLO_FC9(67677.9672667898994405),  FLO_FC9(67699.4736714032478631),
     FLO_FC9(67720.9817841620242689),  FLO_FC9(67742.4916047949227504),
     FLO_FC9(67764.0031330307974713),  FLO_FC9(67785.5163685985753546),
     FLO_FC9(67807.0313112273142906),  FLO_FC9(67828.5479606461740332),
     FLO_FC9(67850.0663165844016476),  FLO_FC9(67871.5863787713897182),
     FLO_FC9(67893.1081469365890371),  FLO_FC9(67914.6316208096104674),
     FLO_FC9(67936.1568001201376319),  FLO_FC9(67957.6836845979705686),
     FLO_FC9(67979.2122739730111789),  FLO_FC9(68000.7425679752632277),
     FLO_FC9(68022.2745663348759990),  FLO_FC9(68043.8082687820569845),
     FLO_FC9(68065.3436750471446430),  FLO_FC9(68086.8807848605792969),
     FLO_FC9(68108.4195979529176839),  FLO_FC9(68129.9601140547893010),
     FLO_FC9(68151.5023328969691647),  FLO_FC9(68173.0462542103196029),
     FLO_FC9(68194.5918777258339105),  FLO_FC9(68216.1392031745635904),
     FLO_FC9(68237.6882302877056645),  FLO_FC9(68259.2389587965444662),
     FLO_FC9(68280.7913884324807441),  FLO_FC9(68302.3455189270316623),
     FLO_FC9(68323.9013500117871445),  FLO_FC9(68345.4588814184826333),
     FLO_FC9(68367.0181128789117793),  FLO_FC9(68388.5790441250283038),
     FLO_FC9(68410.1416748888441361),  FLO_FC9(68431.7060049025021726),
     FLO_FC9(68453.2720338982617250),  FLO_FC9(68474.8397616084548645),
     FLO_FC9(68496.4091877655446297),  FLO_FC9(68517.9803121020813705),
     FLO_FC9(68539.5531343507318525),  FLO_FC9(68561.1276542442792561),
     FLO_FC9(68582.7038715155795217),  FLO_FC9(68604.2817858976341086),
     FLO_FC9(68625.8613971235026838),  FLO_FC9(68647.4427049263904337),
     FLO_FC9(68669.0257090396044077),  FLO_FC9(68690.6104091965244152),
     FLO_FC9(68712.1968051306612324),  FLO_FC9(68733.7848965756274993),
     FLO_FC9(68755.3746832651231671),  FLO_FC9(68776.9661649329937063),
     FLO_FC9(68798.5593413131282432),  FLO_FC9(68820.1542121395905269),
     FLO_FC9(68841.7507771464734105),  FLO_FC9(68863.3490360680443700),
     FLO_FC9(68884.9489886386290891),  FLO_FC9(68906.5506345926842187),
     FLO_FC9(68928.1539736647391692),  FLO_FC9(68949.7590055894397665),
     FLO_FC9(68971.3657301015773555),  FLO_FC9(68992.9741469359869370),
     FLO_FC9(69014.5842558276344789),  FLO_FC9(69036.1960565115878126),
     FLO_FC9(69057.8095487230166327),  FLO_FC9(69079.4247321972070495),
     FLO_FC9(69101.0416066695324844),  FLO_FC9(69122.6601718754682224),
     FLO_FC9(69144.2804275506059639),  FLO_FC9(69165.9023734306247206),
     FLO_FC9(69187.5260092513344716),  FLO_FC9(69209.1513347486179555),
     FLO_FC9(69230.7783496584743261),  FLO_FC9(69252.4070537169900490),
     FLO_FC9(69274.0374466604116606),  FLO_FC9(69295.6695282250002492),
     FLO_FC9(69317.3032981471915264),  FLO_FC9(69338.9387561634939630),
     FLO_FC9(69360.5759020105324453),  FLO_FC9(69382.2147354250046192),
     FLO_FC9(69403.8552561437536497),  FLO_FC9(69425.4974639036809094),
     FLO_FC9(69447.1413584418332903),  FLO_FC9(69468.7869394953304436),
     FLO_FC9(69490.4342068013938842),  FLO_FC9(69512.0831600973906461),
     FLO_FC9(69533.7337991207168670),  FLO_FC9(69555.3861236089287559),
     FLO_FC9(69577.0401332996698329),  FLO_FC9(69598.6958279306854820),
     FLO_FC9(69620.3532072397938464),  FLO_FC9(69642.0122709649731405),
     FLO_FC9(69663.6730188442597864),  FLO_FC9(69685.3354506157920696),
     FLO_FC9(69706.9995660178392427),  FLO_FC9(69728.6653647887433181),
     FLO_FC9(69750.3328466669627232),  FLO_FC9(69772.0020113910577493),
     FLO_FC9(69793.6728586996905506),  FLO_FC9(69815.3453883316105930),
     FLO_FC9(69837.0196000256692059),  FLO_FC9(69858.6954935208486859),
     FLO_FC9(69880.3730685562040890),  FLO_FC9(69902.0523248709068866),
     FLO_FC9(69923.7332622042158619),  FLO_FC9(69945.4158802954916609),
     FLO_FC9(69967.1001788842113456),  FLO_FC9(69988.7861577099392889),
     FLO_FC9(70010.4738165123562794),  FLO_FC9(70032.1631550312158652),
     FLO_FC9(70053.8541730064025614),  FLO_FC9(70075.5468701778736431),
     FLO_FC9(70097.2412462857173523),  FLO_FC9(70118.9373010701092426),
     FLO_FC9(70140.6350342712976271),  FLO_FC9(70162.3344456296908902),
     FLO_FC9(70184.0355348857410718),  FLO_FC9(70205.7383017800166272),
     FLO_FC9(70227.4427460532169789),  FLO_FC9(70249.1488674460997572),
     FLO_FC9(70270.8566656995390076),  FLO_FC9(70292.5661405545106390),
     FLO_FC9(70314.2772917521069758),  FLO_FC9(70335.9901190334931016),
     FLO_FC9(70357.7046221399359638),  FLO_FC9(70379.4208008128189249),
     FLO_FC9(70401.1386547936126590),  FLO_FC9(70422.8581838238897035),
     FLO_FC9(70444.5793876453390112),  FLO_FC9(70466.3022659997222945),
     FLO_FC9(70488.0268186289176811),  FLO_FC9(70509.7530452748760581),
     FLO_FC9(70531.4809456797083840),  FLO_FC9(70553.2105195855547208),
     FLO_FC9(70574.9417667347006500),  FLO_FC9(70596.6746868695045123),
     FLO_FC9(70618.4092797324556159),  FLO_FC9(70640.1455450661014766),
     FLO_FC9(70661.8834826131060254),  FLO_FC9(70683.6230921162641607),
     FLO_FC9(70705.3643733184144367),  FLO_FC9(70727.1073259625263745),
     FLO_FC9(70748.8519497916713590),  FLO_FC9(70770.5982445490080863),
     FLO_FC9(70792.3462099777825642),  FLO_FC9(70814.0958458213717677),
     FLO_FC9(70835.8471518232254311),  FLO_FC9(70857.6001277268951526),
     FLO_FC9(70879.3547732760343933),  FLO_FC9(70901.1110882144130301),
     FLO_FC9(70922.8690722858591471),  FLO_FC9(70944.6287252343317959),
     FLO_FC9(70966.3900468038773397),  FLO_FC9(70988.1530367386294529),
     FLO_FC9(71009.9176947828527773),  FLO_FC9(71031.6840206808847142),
     FLO_FC9(71053.4520141771499766),  FLO_FC9(71075.2216750162042445),
     FLO_FC9(71096.9930029426614055),  FLO_FC9(71118.7659977012663148),
     FLO_FC9(71140.5406590368511388),  FLO_FC9(71162.3169866943353554),
     FLO_FC9(71184.0949804187403060),  FLO_FC9(71205.8746399552182993),
     FLO_FC9(71227.6559650489507476),  FLO_FC9(71249.4389554452936864),
     FLO_FC9(71271.2236108896322548),  FLO_FC9(71293.0099311274825595),
     FLO_FC9(71314.7979159044771222),  FLO_FC9(71336.5875649663066724),
     FLO_FC9(71358.3788780587638030),  FLO_FC9(71380.1718549277720740),
     FLO_FC9(71401.9664953193132533),  FLO_FC9(71423.7627989794855239),
     FLO_FC9(71445.5607656544889323),  FLO_FC9(71467.3603950905962847),
     FLO_FC9(71489.1616870342113543),  FLO_FC9(71510.9646412318106741),
     FLO_FC9(71532.7692574299726402),  FLO_FC9(71554.5755353753629606),
     FLO_FC9(71576.3834748147492064),  FLO_FC9(71598.1930754950299161),
     FLO_FC9(71620.0043371631327318),  FLO_FC9(71641.8172595661453670),
     FLO_FC9(71663.6318424512137426),  FLO_FC9(71685.4480855656001950),
     FLO_FC9(71707.2659886566398200),  FLO_FC9(71729.0855514717841288),
     FLO_FC9(71750.9067737585864961),  FLO_FC9(71772.7296552646730561),
     FLO_FC9(71794.5541957377718063),  FLO_FC9(71816.3803949257126078),
     FLO_FC9(71838.2082525764417369),  FLO_FC9(71860.0377684379636776),
     FLO_FC9(71881.8689422583847772),  FLO_FC9(71903.7017737859423505),
     FLO_FC9(71925.5362627689319197),  FLO_FC9(71947.3724089557508705),
     FLO_FC9(71969.2102120948984521),  FLO_FC9(71991.0496719349757768),
     FLO_FC9(72012.8907882246858208),  FLO_FC9(72034.7335607127897674),
     FLO_FC9(72056.5779891481652157),  FLO_FC9(72078.4240732798207318),
     FLO_FC9(72100.2718128567939857),  FLO_FC9(72122.1212076282536145),
     FLO_FC9(72143.9722573434701189),  FLO_FC9(72165.8249617518013110),
     FLO_FC9(72187.6793206026923144),  FLO_FC9(72209.5353336456901161),
     FLO_FC9(72231.3930006304290146),  FLO_FC9(72253.2523213066451717),
     FLO_FC9(72275.1132954241766129),  FLO_FC9(72296.9759227329486748),
     FLO_FC9(72318.8402029829594539),  FLO_FC9(72340.7061359243380139),
     FLO_FC9(72362.5737213072716258),  FLO_FC9(72384.4429588820930803),
     FLO_FC9(72406.3138483991788235),  FLO_FC9(72428.1863896090362687),
     FLO_FC9(72450.0605822622164851),  FLO_FC9(72471.9364261094306130),
     FLO_FC9(72493.8139209014334483),  FLO_FC9(72515.6930663890962023),
     FLO_FC9(72537.5738623233919498),  FLO_FC9(72559.4563084553519730),
     FLO_FC9(72581.3404045361385215),  FLO_FC9(72603.2261503169866046),
     FLO_FC9(72625.1135455492476467),  FLO_FC9(72647.0025899843312800),
     FLO_FC9(72668.8932833737635519),  FLO_FC9(72690.7856254691723734),
     FLO_FC9(72712.6796160222729668),  FLO_FC9(72734.5752547848533140),
     FLO_FC9(72756.4725415088178124),  FLO_FC9(72778.3714759461436188),
     FLO_FC9(72800.2720578489388572),  FLO_FC9(72822.1742869693553075),
     FLO_FC9(72844.0781630596902687),  FLO_FC9(72865.9836858722846955),
     FLO_FC9(72887.8908551595959580),  FLO_FC9(72909.7996706741832895),
     FLO_FC9(72931.7101321686932351),  FLO_FC9(72953.6222393958450994),
     FLO_FC9(72975.5359921084891539),  FLO_FC9(72997.4513900595193263),
     FLO_FC9(73019.3684330019605113),  FLO_FC9(73041.2871206889249152),
     FLO_FC9(73063.2074528736120556),  FLO_FC9(73085.1294293092942098),
     FLO_FC9(73107.0530497493891744),  FLO_FC9(73128.9783139473438496),
     FLO_FC9(73150.9052216567361029),  FLO_FC9(73172.8337726312165614),
     FLO_FC9(73194.7639666245668195),  FLO_FC9(73216.6958033906121273),
     FLO_FC9(73238.6292826832795981),  FLO_FC9(73260.5644042566273129),
     FLO_FC9(73282.5011678647570079),  FLO_FC9(73304.4395732619013870),
     FLO_FC9(73326.3796202023368096),  FLO_FC9(73348.3213084404851543),
     FLO_FC9(73370.2646377308410592),  FLO_FC9(73392.2096078279573703),
     FLO_FC9(73414.1562184865324525),  FLO_FC9(73436.1044694613228785),
     FLO_FC9(73458.0543605071725324),  FLO_FC9(73480.0058913790562656),
     FLO_FC9(73501.9590618319925852),  FLO_FC9(73523.9138716211164137),
     FLO_FC9(73545.8703205016645370),  FLO_FC9(73567.8284082289319485),
     FLO_FC9(73589.7881345583300572),  FLO_FC9(73611.7494992453575833),
     FLO_FC9(73633.7125020456151105),  FLO_FC9(73655.6771427147468785),
     FLO_FC9(73677.6434210085571976),  FLO_FC9(73699.6113366828794824),
     FLO_FC9(73721.5808894936926663),  FLO_FC9(73743.5520791970193386),
     FLO_FC9(73765.5249055489985039),  FLO_FC9(73787.4993683058564784),
     FLO_FC9(73809.4754672239068896),  FLO_FC9(73831.4532020595506765),
     FLO_FC9(73853.4325725692906417),  FLO_FC9(73875.4135785097168991),
     FLO_FC9(73897.3962196375068743),  FLO_FC9(73919.3804957094107522),
     FLO_FC9(73941.3664064823096851),  FLO_FC9(73963.3539517131430330),
     FLO_FC9(73985.3431311589520192),  FLO_FC9(74007.3339445768651785),
     FLO_FC9(74029.3263917240983574),  FLO_FC9(74051.3204723579692654),
     FLO_FC9(74073.3161862358829239),  FLO_FC9(74095.3135331153025618),
     FLO_FC9(74117.3125127538369270),  FLO_FC9(74139.3131249091384234),
     FLO_FC9(74161.3153693389758701),  FLO_FC9(74183.3192458011908457),
     FLO_FC9(74205.3247540537267923),  FLO_FC9(74227.3318938546290156),
     FLO_FC9(74249.3406649619864766),  FLO_FC9(74271.3510671340336557),
     FLO_FC9(74293.3631001290486893),  FLO_FC9(74315.3767637054406805),
     FLO_FC9(74337.3920576216623886),  FLO_FC9(74359.4089816362975398),
     FLO_FC9(74381.4275355080026202),  FLO_FC9(74403.4477189955068752),
     FLO_FC9(74425.4695318576705176),  FLO_FC9(74447.4929738533828640),
     FLO_FC9(74469.5180447416933021),  FLO_FC9(74491.5447442816803232),
     FLO_FC9(74513.5730722325388342),  FLO_FC9(74535.6030283535510534),
     FLO_FC9(74557.6346124040865107),  FLO_FC9(74579.6678241436020471),
     FLO_FC9(74601.7026633316418156),  FLO_FC9(74623.7391297278372804),
     FLO_FC9(74645.7772230919363210),  FLO_FC9(74667.8169431837159209),
     FLO_FC9(74689.8582897631131345),  FLO_FC9(74711.9012625900941202),
     FLO_FC9(74733.9458614247414516),  FLO_FC9(74755.9920860272250138),
     FLO_FC9(74778.0399361578020034),  FLO_FC9(74800.0894115768169286),
     FLO_FC9(74822.1405120447016088),  FLO_FC9(74844.1932373219606234),
     FLO_FC9(74866.2475871692295186),  FLO_FC9(74888.3035613471874967),
     FLO_FC9(74910.3611596166301752),  FLO_FC9(74932.4203817384113790),
     FLO_FC9(74954.4812274735013489),  FLO_FC9(74976.5436965829721885),
     FLO_FC9(74998.6077888279251056),  FLO_FC9(75020.6735039696068270),
     FLO_FC9(75042.7408417693222873),  FLO_FC9(75064.8098019884637324),
     FLO_FC9(75086.8803843885398237),  FLO_FC9(75108.9525887311028782),
     FLO_FC9(75131.0264147778361803),  FLO_FC9(75153.1018622904666699),
     FLO_FC9(75175.1789310308522545),  FLO_FC9(75197.2576207609236008),
     FLO_FC9(75219.3379312426695833),  FLO_FC9(75241.4198622382100439),
     FLO_FC9(75263.5034135097375838),  FLO_FC9(75285.5885848195030121),
     FLO_FC9(75307.6753759298735531),  FLO_FC9(75329.7637866033182945),
     FLO_FC9(75351.8538166023645317),  FLO_FC9(75373.9454656896123197),
     FLO_FC9(75396.0387336278072326),  FLO_FC9(75418.1336201797239482),
     FLO_FC9(75440.2301251082535600),  FLO_FC9(75462.3282481763599208),
     FLO_FC9(75484.4279891471087467),  FLO_FC9(75506.5293477836530656),
     FLO_FC9(75528.6323238491895609),  FLO_FC9(75550.7369171070749871),
     FLO_FC9(75572.8431273206952028),  FLO_FC9(75594.9509542535379296),
     FLO_FC9(75617.0603976691927528),  FLO_FC9(75639.1714573313074652),
     FLO_FC9(75661.2841330036462750),  FLO_FC9(75683.3984244500315981),
     FLO_FC9(75705.5143314344022656),  FLO_FC9(75727.6318537207407644),
     FLO_FC9(75749.7509910731751006),  FLO_FC9(75771.8717432558623841),
     FLO_FC9(75793.9941100330761401),  FLO_FC9(75816.1180911691772053),
     FLO_FC9(75838.2436864285846241),  FLO_FC9(75860.3708955758484080),
     FLO_FC9(75882.4997183755622245),  FLO_FC9(75904.6301545924216043),
     FLO_FC9(75926.7622039912239416),  FLO_FC9(75948.8958663368248381),
     FLO_FC9(75971.0311413941817591),  FLO_FC9(75993.1680289283249294),
     FLO_FC9(76015.3065287044009892),  FLO_FC9(76037.4466404876002343),
     FLO_FC9(76059.5883640432148241),  FLO_FC9(76081.7316991366533330),
     FLO_FC9(76103.8766455333534395),  FLO_FC9(76126.0232029988837894),
     FLO_FC9(76148.1713712988712359),  FLO_FC9(76170.3211501990444958),
     FLO_FC9(76192.4725394652050454),  FLO_FC9(76214.6255388632562244),
     FLO_FC9(76236.7801481591741322),  FLO_FC9(76258.9363671190076275),
     FLO_FC9(76281.0941955089219846),  FLO_FC9(76303.2536330951406853),
     FLO_FC9(76325.4146796439745231),  FLO_FC9(76347.5773349218507065),
     FLO_FC9(76369.7415986952255480),  FLO_FC9(76391.9074707306863274),
     FLO_FC9(76414.0749507948785322),  FLO_FC9(76436.2440386545640649),
     FLO_FC9(76458.4147340765484842),  FLO_FC9(76480.5870368277537636),
     FLO_FC9(76502.7609466751746368),  FLO_FC9(76524.9364633858931484),
     FLO_FC9(76547.1135867270495510),  FLO_FC9(76569.2923164659150643),
     FLO_FC9(76591.4726523698191158),  FLO_FC9(76613.6545942061638925),
     FLO_FC9(76635.8381417424679967),  FLO_FC9(76658.0232947463082382),
     FLO_FC9(76680.2100529853487387),  FLO_FC9(76702.3984162273409311),
     FLO_FC9(76724.5883842401381116),  FLO_FC9(76746.7799567916372325),
     FLO_FC9(76768.9731336498662131),  FLO_FC9(76791.1679145828966284),
     FLO_FC9(76813.3642993589019170),  FLO_FC9(76835.5622877461573808),
     FLO_FC9(76857.7618795129674254),  FLO_FC9(76879.9630744277965277),
     FLO_FC9(76902.1658722591091646),  FLO_FC9(76924.3702727755298838),
     FLO_FC9(76946.5762757457268890),  FLO_FC9(76968.7838809384411434),
     FLO_FC9(76990.9930881225154735),  FLO_FC9(77013.2038970668945694),
     FLO_FC9(77035.4163075405667769),  FLO_FC9(77057.6303193126223050),
     FLO_FC9(77079.8459321522386745),  FLO_FC9(77102.0631458286952693),
     FLO_FC9(77124.2819601113005774),  FLO_FC9(77146.5023747694795020),
     FLO_FC9(77168.7243895727588097),  FLO_FC9(77190.9480042907234747),
     FLO_FC9(77213.1732186930312309),  FLO_FC9(77235.4000325494416757),
     FLO_FC9(77257.6284456298017176),  FLO_FC9(77279.8584577040310251),
     FLO_FC9(77302.0900685421220260),  FLO_FC9(77324.3232779141690116),
     FLO_FC9(77346.5580855903390329),  FLO_FC9(77368.7944913408864522),
     FLO_FC9(77391.0324949361383915),  FLO_FC9(77413.2720961465238361),
     FLO_FC9(77435.5132947425299790),  FLO_FC9(77457.7560904947313247),
     FLO_FC9(77480.0004831738042412),  FLO_FC9(77502.2464725504978560),
     FLO_FC9(77524.4940583956340561),  FLO_FC9(77546.7432404801074881),
     FLO_FC9(77568.9940185749437660),  FLO_FC9(77591.2463924511976074),
     FLO_FC9(77613.5003618800255936),  FLO_FC9(77635.7559266326570651),
     FLO_FC9(77658.0130864804377779),  FLO_FC9(77680.2718411947571440),
     FLO_FC9(77702.5321905470918864),  FLO_FC9(77724.7941343090205919),
     FLO_FC9(77747.0576722521946067),  FLO_FC9(77769.3228041483234847),
     FLO_FC9(77791.5895297692477470),  FLO_FC9(77813.8578488868370187),
     FLO_FC9(77836.1277612730627880),  FLO_FC9(77858.3992666999984067),
     FLO_FC9(77880.6723649397899862),  FLO_FC9(77902.9470557646272937),
     FLO_FC9(77925.2233389468310634),  FLO_FC9(77947.5012142587802373),
     FLO_FC9(77969.7806814729265170),  FLO_FC9(77992.0617403618380195),
     FLO_FC9(78014.3443906981265172),  FLO_FC9(78036.6286322544910945),
     FLO_FC9(78058.9144648037472507),  FLO_FC9(78081.2018881187250372),
     FLO_FC9(78103.4909019724145764),  FLO_FC9(78125.7815061378205428),
     FLO_FC9(78148.0737003880640259),  FLO_FC9(78170.3674844963388750),
     FLO_FC9(78192.6628582359262509),  FLO_FC9(78214.9598213801655220),
     FLO_FC9(78237.2583737024979200),  FLO_FC9(78259.5585149764519883),
     FLO_FC9(78281.8602449756144779),  FLO_FC9(78304.1635634736594511),
     FLO_FC9(78326.4684702443628339),  FLO_FC9(78348.7749650615296559),
     FLO_FC9(78371.0830476991250180),  FLO_FC9(78393.3927179310994688),
     FLO_FC9(78415.7039755315781804),  FLO_FC9(78438.0168202747008763),
     FLO_FC9(78460.3312519346945919),  FLO_FC9(78482.6472702859027777),
     FLO_FC9(78504.9648751027270919),  FLO_FC9(78527.2840661596274003),
     FLO_FC9(78549.6048432311945362),  FLO_FC9(78571.9272060920484364),
     FLO_FC9(78594.2511545169109013),  FLO_FC9(78616.5766882806055946),
     FLO_FC9(78638.9038071579852840),  FLO_FC9(78661.2325109240337042),
     FLO_FC9(78683.5627993537782459),  FLO_FC9(78705.8946722223481629),
     FLO_FC9(78728.2281293049454689),  FLO_FC9(78750.5631703768594889),
     FLO_FC9(78772.8997952134232037),  FLO_FC9(78795.2380035901005613),
     FLO_FC9(78817.5777952823991654),  FLO_FC9(78839.9191700659284834),
     FLO_FC9(78862.2621277163561899),  FLO_FC9(78884.6066680094518233),
     FLO_FC9(78906.9527907210431295),  FLO_FC9(78929.3004956270451657),
     FLO_FC9(78951.6497825034603011),  FLO_FC9(78974.0006511263782158),
     FLO_FC9(78996.3531012719322462),  FLO_FC9(79018.7071327163575916),
     FLO_FC9(79041.0627452359767631),  FLO_FC9(79063.4199386071850313),
     FLO_FC9(79085.7787126064358745),  FLO_FC9(79108.1390670102846343),
     FLO_FC9(79130.5010015953885159),  FLO_FC9(79152.8645161384192761),
     FLO_FC9(79175.2296104161796393),  FLO_FC9(79197.5962842055305373),
     FLO_FC9(79219.9645372834202135),  FLO_FC9(79242.3343694268696709),
     FLO_FC9(79264.7057804129872238),  FLO_FC9(79287.0787700189539464),
     FLO_FC9(79309.4533380220091203),  FLO_FC9(79331.8294841995084425),
     FLO_FC9(79354.2072083288658177),  FLO_FC9(79376.5865101875824621),
     FLO_FC9(79398.9673895532177994),  FLO_FC9(79421.3498462034331169),
     FLO_FC9(79443.7338799159479095),  FLO_FC9(79466.1194904685835354),
     FLO_FC9(79488.5066776392195607),  FLO_FC9(79510.8954412058228627),
     FLO_FC9(79533.2857809464330785),  FLO_FC9(79555.6776966391626047),
     FLO_FC9(79578.0711880622257013),  FLO_FC9(79600.4662549938948359),
     FLO_FC9(79622.8628972125152359),  FLO_FC9(79645.2611144965485437),
     FLO_FC9(79667.6609066244709538),  FLO_FC9(79690.0622733748750761),
     FLO_FC9(79712.4652145264553837),  FLO_FC9(79734.8697298579354538),
     FLO_FC9(79757.2758191481261747),  FLO_FC9(79779.6834821759548504),
     FLO_FC9(79802.0927187203778885),  FLO_FC9(79824.5035285604535602),
     FLO_FC9(79846.9159114753274480),  FLO_FC9(79869.3298672441887902),
     FLO_FC9(79891.7453956463432405),  FLO_FC9(79914.1624964611546602),
     FLO_FC9(79936.5811694680451183),  FLO_FC9(79959.0014144465530990),
     FLO_FC9(79981.4232311762607424),  FLO_FC9(80003.8466194368520519),
     FLO_FC9(80026.2715790080837905),  FLO_FC9(80048.6981096697709290),
     FLO_FC9(80071.1262112018303014),  FLO_FC9(80093.5558833842369495),
     FLO_FC9(80115.9871259970532265),  FLO_FC9(80138.4199388204142451),
     FLO_FC9(80160.8543216345278779),  FLO_FC9(80183.2902742196893087),
     FLO_FC9(80205.7277963562810328),  FLO_FC9(80228.1668878247146495),
     FLO_FC9(80250.6075484055327252),  FLO_FC9(80273.0497778793360339),
     FLO_FC9(80295.4935760267981095),  FLO_FC9(80317.9389426286506932),
     FLO_FC9(80340.3858774657273898),  FLO_FC9(80362.8343803189491155),
     FLO_FC9(80385.2844509692804422),  FLO_FC9(80407.7360891977878055),
     FLO_FC9(80430.1892947855958482),  FLO_FC9(80452.6440675139165251),
     FLO_FC9(80475.1004071640345501),  FLO_FC9(80497.5583135173219489),
     FLO_FC9(80520.0177863552089548),  FLO_FC9(80542.4788254592131125),
     FLO_FC9(80564.9414306109247264),  FLO_FC9(80587.4056015920068603),
     FLO_FC9(80609.8713381841953378),  FLO_FC9(80632.3386401693278458),
     FLO_FC9(80654.8075073293002788),  FLO_FC9(80677.2779394460667390),
     FLO_FC9(80699.7499363016831921),  FLO_FC9(80722.2234976782783633),
     FLO_FC9(80744.6986233580391854),  FLO_FC9(80767.1753131232399028),
     FLO_FC9(80789.6535667562420713),  FLO_FC9(80812.1333840394654544),
     FLO_FC9(80834.6147647554025752),  FLO_FC9(80857.0977086866478203),
     FLO_FC9(80879.5822156158537837),  FLO_FC9(80902.0682853257312672),
     FLO_FC9(80924.5559175990929361),  FLO_FC9(80947.0451122188242152),
     FLO_FC9(80969.5358689678832889),  FLO_FC9(80992.0281876292719971),
     FLO_FC9(81014.5220679861231474),  FLO_FC9(81037.0175098216132028),
     FLO_FC9(81059.5145129190059379),  FLO_FC9(81082.0130770616087830),
     FLO_FC9(81104.5132020328310318),  FLO_FC9(81127.0148876161838416),
     FLO_FC9(81149.5181335951929213),  FLO_FC9(81172.0229397535003955),
     FLO_FC9(81194.5293058748065960),  FLO_FC9(81217.0372317428991664),
     FLO_FC9(81239.5467171416385099),  FLO_FC9(81262.0577618549577892),
     FLO_FC9(81284.5703656668483745),  FLO_FC9(81307.0845283614034997),
     FLO_FC9(81329.6002497227746062),  FLO_FC9(81352.1175295351858949),
     FLO_FC9(81374.6363675829488784),  FLO_FC9(81397.1567636504478287),
     FLO_FC9(81419.6787175221252255),  FLO_FC9(81442.2022289825108601),
     FLO_FC9(81464.7272978162218351),  FLO_FC9(81487.2539238079334609),
     FLO_FC9(81509.7821067423792556),  FLO_FC9(81532.3118464043946005),
     FLO_FC9(81554.8431425789021887),  FLO_FC9(81577.3759950508392649),
     FLO_FC9(81599.9104036052740412),  FLO_FC9(81622.4463680273329373),
     FLO_FC9(81644.9838881022151327),  FLO_FC9(81667.5229636151780142),
     FLO_FC9(81690.0635943515808322),  FLO_FC9(81712.6057800968410447),
     FLO_FC9(81735.1495206364488695),  FLO_FC9(81757.6948157559672836),
     FLO_FC9(81780.2416652410465758),  FLO_FC9(81802.7900688774097944),
     FLO_FC9(81825.3400264508236432),  FLO_FC9(81847.8915377471712418),
     FLO_FC9(81870.4446025523793651),  FLO_FC9(81892.9992206524766516),
     FLO_FC9(81915.5553918335062917),  FLO_FC9(81938.1131158816715470),
     FLO_FC9(81960.6723925831756787),  FLO_FC9(81983.2332217243383639),
     FLO_FC9(82005.7956030915374868),  FLO_FC9(82028.3595364712236915),
     FLO_FC9(82050.9250216499058297),  FLO_FC9(82073.4920584142091684),
     FLO_FC9(82096.0606465507880785),  FLO_FC9(82118.6307858463987941),
     FLO_FC9(82141.2024760878412053),  FLO_FC9(82163.7757170620316174),
     FLO_FC9(82186.3505085559299914),  FLO_FC9(82208.9268503565690480),
     FLO_FC9(82231.5047422510542674),  FLO_FC9(82254.0841840265784413),
     FLO_FC9(82276.6651754703925690),  FLO_FC9(82299.2477163698495133),
     FLO_FC9(82321.8318065123166889),  FLO_FC9(82344.4174456853070296),
     FLO_FC9(82367.0046336763480213),  FLO_FC9(82389.5933702730544610),
     FLO_FC9(82412.1836552631430095),  FLO_FC9(82434.7754884343739832),
     FLO_FC9(82457.3688695745950099),  FLO_FC9(82479.9637984716973733),
     FLO_FC9(82502.5602749136887724),  FLO_FC9(82525.1582986886060098),
     FLO_FC9(82547.7578695846023038),  FLO_FC9(82570.3589873898599762),
     FLO_FC9(82592.9616518926777644),  FLO_FC9(82615.5658628813980613),
     FLO_FC9(82638.1716201444214676),  FLO_FC9(82660.7789234702649992),
     FLO_FC9(82683.3877726474747760),  FLO_FC9(82705.9981674647133332),
     FLO_FC9(82728.6101077106577577),  FLO_FC9(82751.2235931741161039),
     FLO_FC9(82773.8386236439400818),  FLO_FC9(82796.4551989090396091),
     FLO_FC9(82819.0733187584410189),  FLO_FC9(82841.6929829811851960),
     FLO_FC9(82864.3141913664294407),  FLO_FC9(82886.9369437033747090),
     FLO_FC9(82909.5612397813238204),  FLO_FC9(82932.1870793896378018),
     FLO_FC9(82954.8144623177358881),  FLO_FC9(82977.4433883551246254),
     FLO_FC9(83000.0738572913687676),  FLO_FC9(83022.7058689161203802),
     FLO_FC9(83045.3394230191042880),  FLO_FC9(83067.9745193900889717),
     FLO_FC9(83090.6111578189593274),  FLO_FC9(83113.2493380956293549),
     FLO_FC9(83135.8890600101003656),  FLO_FC9(83158.5303233524609823),
     FLO_FC9(83181.1731279128580354),  FLO_FC9(83203.8174734814965632),
     FLO_FC9(83226.4633598486689152),  FLO_FC9(83249.1107868047402008),
     FLO_FC9(83271.7597541401337367),  FLO_FC9(83294.4102616453747032),
     FLO_FC9(83317.0623091110028327),  FLO_FC9(83339.7158963277033763),
     FLO_FC9(83362.3710230861615855),  FLO_FC9(83385.0276891771645751),
     FLO_FC9(83407.6858943915867712),  FLO_FC9(83430.3456385203608079),
     FLO_FC9(83453.0069213544775266),  FLO_FC9(83475.6697426850005286),
     FLO_FC9(83498.3341023030952783),  FLO_FC9(83520.9999999999417923),
     FLO_FC9(83543.6674355668656062),  FLO_FC9(83566.3364087951922556),
     FLO_FC9(83589.0069194763491396),  FLO_FC9(83611.6789674018509686),
     FLO_FC9(83634.3525523632415570),  FLO_FC9(83657.0276741521665826),
     FLO_FC9(83679.7043325603590347),  FLO_FC9(83702.3825273795519024),
     FLO_FC9(83725.0622584016382461),  FLO_FC9(83747.7435254185111262),
     FLO_FC9(83770.4263282221800182),  FLO_FC9(83793.1106666046835016),
     FLO_FC9(83815.7965403581620194),  FLO_FC9(83838.4839492748287739),
     FLO_FC9(83861.1728931469406234),  FLO_FC9(83883.8633717668417376),
     FLO_FC9(83906.5553849269635975),  FLO_FC9(83929.2489324197522365),
     FLO_FC9(83951.9440140377992066),  FLO_FC9(83974.6406295736960601),
     FLO_FC9(83997.3387788201507647),  FLO_FC9(84020.0384615699294955),
     FLO_FC9(84042.7396776158566354),  FLO_FC9(84065.4424267508293269),
     FLO_FC9(84088.1467087678465759),  FLO_FC9(84110.8525234599219402),
     FLO_FC9(84133.5598706201708410),  FLO_FC9(84156.2687500417960109),
     FLO_FC9(84178.9791615180292865),  FLO_FC9(84201.6911048422043677),
     FLO_FC9(84224.4045798077131622),  FLO_FC9(84247.1195862080057850),
     FLO_FC9(84269.8361238366196631),  FLO_FC9(84292.5541924871504307),
     FLO_FC9(84315.2737919532810338),  FLO_FC9(84337.9949220287380740),
     FLO_FC9(84360.7175825073354645),  FLO_FC9(84383.4417731829453260),
     FLO_FC9(84406.1674938495125389),  FLO_FC9(84428.8947443010692950),
     FLO_FC9(84451.6235243316914421),  FLO_FC9(84474.3538337355421390),
     FLO_FC9(84497.0856723068282008),  FLO_FC9(84519.8190398398728576),
     FLO_FC9(84542.5539361289993394),  FLO_FC9(84565.2903609686763957),
     FLO_FC9(84588.0283141534018796),  FLO_FC9(84610.7677954777172999),
     FLO_FC9(84633.5088047362951329),  FLO_FC9(84656.2513417238224065),
     FLO_FC9(84678.9954062350734603),  FLO_FC9(84701.7409980649099452),
     FLO_FC9(84724.4881170082517201),  FLO_FC9(84747.2367628600622993),
     FLO_FC9(84769.9869354154070606),  FLO_FC9(84792.7386344694095897),
     FLO_FC9(84815.4918598172516795),  FLO_FC9(84838.2466112541878829),
     FLO_FC9(84861.0028885755600641),  FLO_FC9(84883.7606915767682949),
     FLO_FC9(84906.5200200532563031),  FLO_FC9(84929.2808738005696796),
     FLO_FC9(84952.0432526143122232),  FLO_FC9(84974.8071562901459401),
     FLO_FC9(84997.5725846238055965),  FLO_FC9(85020.3395374111132696),
     FLO_FC9(85043.1080144479492446),  FLO_FC9(85065.8780155302374624),
     FLO_FC9(85088.6495404539891751),  FLO_FC9(85111.4225890153029468),
     FLO_FC9(85134.1971610103209969),  FLO_FC9(85156.9732562352437526),
     FLO_FC9(85179.7508744863735046),  FLO_FC9(85202.5300155600707512),
     FLO_FC9(85225.3106792527396465),  FLO_FC9(85248.0928653608571040),
     FLO_FC9(85270.8765736810164526),  FLO_FC9(85293.6618040098110214),
     FLO_FC9(85316.4485561439505545),  FLO_FC9(85339.2368298801884521),
     FLO_FC9(85362.0266250153508736),  FLO_FC9(85384.8179413463512901),
     FLO_FC9(85407.6107786701322766),  FLO_FC9(85430.4051367837237194),
     FLO_FC9(85453.2010154842573684),  FLO_FC9(85475.9984145688649733),
     FLO_FC9(85498.7973338347946992),  FLO_FC9(85521.5977730793529190),
     FLO_FC9(85544.3997320999042131),  FLO_FC9(85567.2032106938859215),
     FLO_FC9(85590.0082086588081438),  FLO_FC9(85612.8147257922391873),
     FLO_FC9(85635.6227618918201188),  FLO_FC9(85658.4323167552647647),
     FLO_FC9(85681.2433901803306071),  FLO_FC9(85704.0559819648769917),
     FLO_FC9(85726.8700919068069197),  FLO_FC9(85749.6857198040816002),
     FLO_FC9(85772.5028654547641054),  FLO_FC9(85795.3215286569611635),
     FLO_FC9(85818.1417092088522622),  FLO_FC9(85840.9634069086750969),
     FLO_FC9(85863.7866215547401225),  FLO_FC9(85886.6113529454451054),
     FLO_FC9(85909.4376008792169159),  FLO_FC9(85932.2653651545697358),
     FLO_FC9(85955.0946455700905062),  FLO_FC9(85977.9254419244098244),
     FLO_FC9(86000.7577540162747027),  FLO_FC9(86023.5915816444321536),
     FLO_FC9(86046.4269246077456046),  FLO_FC9(86069.2637827051221393),
     FLO_FC9(86092.1021557355561526),  FLO_FC9(86114.9420434980711434),
     FLO_FC9(86137.7834457918070257),  FLO_FC9(86160.6263624159182655),
     FLO_FC9(86183.4707931696757441),  FLO_FC9(86206.3167378523794468),
     FLO_FC9(86229.1641962634021183),  FLO_FC9(86252.0131682022038149),
     FLO_FC9(86274.8636534683028003),  FLO_FC9(86297.7156518612609943),
     FLO_FC9(86320.5691631807276281),  FLO_FC9(86343.4241872264246922),
     FLO_FC9(86366.2807237981178332),  FLO_FC9(86389.1387726956745610),
     FLO_FC9(86411.9983337189769372),  FLO_FC9(86434.8594066680088872),
     FLO_FC9(86457.7219913428270957),  FLO_FC9(86480.5860875435319031),
     FLO_FC9(86503.4516950702964095),  FLO_FC9(86526.3188137233519228),
     FLO_FC9(86549.1874433030316141),  FLO_FC9(86572.0575836096832063),
     FLO_FC9(86594.9292344437708380),  FLO_FC9(86617.8023956057731993),
     FLO_FC9(86640.6770668962708442),  FLO_FC9(86663.5532481159025338),
     FLO_FC9(86686.4309390653797891),  FLO_FC9(86709.3101395454432350),
     FLO_FC9(86732.1908493569644634),  FLO_FC9(86755.0730683008005144),
     FLO_FC9(86777.9567961779539473),  FLO_FC9(86800.8420327894418733),
     FLO_FC9(86823.7287779363541631),  FLO_FC9(86846.6170314198534470),
     FLO_FC9(86869.5067930411751149),  FLO_FC9(86892.3980626016127644),
     FLO_FC9(86915.2908399025182007),  FLO_FC9(86938.1851247453159885),
     FLO_FC9(86961.0809169314889004),  FLO_FC9(86983.9782162626070203),
     FLO_FC9(87006.8770225402695360),  FLO_FC9(87029.7773355661774985),
     FLO_FC9(87052.6791551420901669),  FLO_FC9(87075.5824810697959037),
     FLO_FC9(87098.4873131511849351),  FLO_FC9(87121.3936511882202467),
     FLO_FC9(87144.3014949828939280),  FLO_FC9(87167.2108443372853799),
     FLO_FC9(87190.1216990535322111),  FLO_FC9(87213.0340589338447899),
     FLO_FC9(87235.9479237805062439),  FLO_FC9(87258.8632933958288049),
     FLO_FC9(87281.7801675822411198),  FLO_FC9(87304.6985461421718355),
     FLO_FC9(87327.6184288781805662),  FLO_FC9(87350.5398155928560300),
     FLO_FC9(87373.4627060888451524),  FLO_FC9(87396.3871001688967226),
     FLO_FC9(87419.3129976357740816),  FLO_FC9(87442.2403982923569856),
     FLO_FC9(87465.1693019415397430),  FLO_FC9(87488.0997083863185253),
     FLO_FC9(87511.0316174297331600),  FLO_FC9(87533.9650288748962339),
     FLO_FC9(87556.8999425250076456),  FLO_FC9(87579.8363581832818454),
     FLO_FC9(87602.7742756530205952),  FLO_FC9(87625.7136947376129683),
     FLO_FC9(87648.6546152404916938),  FLO_FC9(87671.5970369651477085),
     FLO_FC9(87694.5409597151447088),  FLO_FC9(87717.4863832941045985),
     FLO_FC9(87740.4333075057365932),  FLO_FC9(87763.3817321537790122),
     FLO_FC9(87786.3316570420574863),  FLO_FC9(87809.2830819744558539),
     FLO_FC9(87832.2360067549161613),  FLO_FC9(87855.1904311874532141),
     FLO_FC9(87878.1463550761545775),  FLO_FC9(87901.1037782251514727),
     FLO_FC9(87924.0627004386333283),  FLO_FC9(87947.0231215208914364),
     FLO_FC9(87969.9850412762461929),  FLO_FC9(87992.9484595091053052),
     FLO_FC9(88015.9133760239055846),  FLO_FC9(88038.8797906251711538),
     FLO_FC9(88061.8477031175134471),  FLO_FC9(88084.8171133055730024),
     FLO_FC9(88107.7880209940485656),  FLO_FC9(88130.7604259877261939),
     FLO_FC9(88153.7343280914647039),  FLO_FC9(88176.7097271101374645),
     FLO_FC9(88199.6866228487488115),  FLO_FC9(88222.6650151123030810),
     FLO_FC9(88245.6449037059064722),  FLO_FC9(88268.6262884347088402),
     FLO_FC9(88291.6091691039473517),  FLO_FC9(88314.5935455189028289),
     FLO_FC9(88337.5794174849143019),  FLO_FC9(88360.5667848074081121),
     FLO_FC9(88383.5556472918542568),  FLO_FC9(88406.5460047437954927),
     FLO_FC9(88429.5378569688182324),  FLO_FC9(88452.5312037726107519),
     FLO_FC9(88475.5260449608904310),  FLO_FC9(88498.5223803394474089),
     FLO_FC9(88521.5202097141300328),  FLO_FC9(88544.5195328908739612),
     FLO_FC9(88567.5203496756585082),  FLO_FC9(88590.5226598745066440),
     FLO_FC9(88613.5264632935432019),  FLO_FC9(88636.5317597389221191),
     FLO_FC9(88659.5385490168991964),  FLO_FC9(88682.5468309337447863),
     FLO_FC9(88705.5566052958456567),  FLO_FC9(88728.5678719095885754),
     FLO_FC9(88751.5806305814912776),  FLO_FC9(88774.5948811180714983),
     FLO_FC9(88797.6106233259633882),  FLO_FC9(88820.6278570118302014),
     FLO_FC9(88843.6465819823933998),  FLO_FC9(88866.6667980444617569),
     FLO_FC9(88889.6885050048877019),  FLO_FC9(88912.7117026706109755),
     FLO_FC9(88935.7363908486004220),  FLO_FC9(88958.7625693458976457),
     FLO_FC9(88981.7902379696315620),  FLO_FC9(89004.8193965269601904),
     FLO_FC9(89027.8500448251143098),  FLO_FC9(89050.8821826714120107),
     FLO_FC9(89073.9158098732004873),  FLO_FC9(89096.9509262378851417),
     FLO_FC9(89119.9875315729732392),  FLO_FC9(89143.0256256860011490),
     FLO_FC9(89166.0652083845634479),  FLO_FC9(89189.1062794763565762),
     FLO_FC9(89212.1488387691060780),  FLO_FC9(89235.1928860705811530),
     FLO_FC9(89258.2384211886674166),  FLO_FC9(89281.2854439312650356),
     FLO_FC9(89304.3339541063760407),  FLO_FC9(89327.3839515220170142),
     FLO_FC9(89350.4354359863064019),  FLO_FC9(89373.4884073074063053),
     FLO_FC9(89396.5428652935370337),  FLO_FC9(89419.5988097530062078),
     FLO_FC9(89442.6562404941651039),  FLO_FC9(89465.7151573253941024),
     FLO_FC9(89488.7755600552191027),  FLO_FC9(89511.8374484921369003),
     FLO_FC9(89534.9008224447461544),  FLO_FC9(89557.9656817217328353),
     FLO_FC9(89581.0320261318120174),  FLO_FC9(89604.0998554837424308),
     FLO_FC9(89627.1691695863992209),  FLO_FC9(89650.2399682486720849),
     FLO_FC9(89673.3122512795380317),  FLO_FC9(89696.3860184880177258),
     FLO_FC9(89719.4612696832045913),  FLO_FC9(89742.5380046742502600),
     FLO_FC9(89765.6162232703645714),  FLO_FC9(89788.6959252808301244),
     FLO_FC9(89811.7771105149877258),  FLO_FC9(89834.8597787822072860),
     FLO_FC9(89857.9439298919751309),  FLO_FC9(89881.0295636538066901),
     FLO_FC9(89904.1166798772610491),  FLO_FC9(89927.2052783720137086),
     FLO_FC9(89950.2953589477401692),  FLO_FC9(89973.3869214142177952),
     FLO_FC9(89996.4799655812676065),  FLO_FC9(90019.5744912587833824),
     FLO_FC9(90042.6704982566880062),  FLO_FC9(90065.7679863850207767),
     FLO_FC9(90088.8669554538355442),  FLO_FC9(90111.9674052732589189),
     FLO_FC9(90135.0693356534757186),  FLO_FC9(90158.1727464047580725),
     FLO_FC9(90181.2776373374072136),  FLO_FC9(90204.3840082617971348),
     FLO_FC9(90227.4918589883600362),  FLO_FC9(90250.6011893275863258),
     FLO_FC9(90273.7119990900391713),  FLO_FC9(90296.8242880863253959),
     FLO_FC9(90319.9380561271391343),  FLO_FC9(90343.0533030231890734),
     FLO_FC9(90366.1700285852857633),  FLO_FC9(90389.2882326242979616),
     FLO_FC9(90412.4079149511380820),  FLO_FC9(90435.5290753767767455),
     FLO_FC9(90458.6517137122573331),  FLO_FC9(90481.7758297686814331),
     FLO_FC9(90504.9014233572088415),  FLO_FC9(90528.0284942890575621),
     FLO_FC9(90551.1570423755038064),  FLO_FC9(90574.2870674279110972),
     FLO_FC9(90597.4185692576429574),  FLO_FC9(90620.5515476761938771),
     FLO_FC9(90643.6860024950728985),  FLO_FC9(90666.8219335258472711),
     FLO_FC9(90689.9593405801861081),  FLO_FC9(90713.0982234697730746),
     FLO_FC9(90736.2385820063645951),  FLO_FC9(90759.3804160018044058),
     FLO_FC9(90782.5237252679507947),  FLO_FC9(90805.6685096167639131),
     FLO_FC9(90828.8147688602330163),  FLO_FC9(90851.9625028104346711),
     FLO_FC9(90875.1117112794599961),  FLO_FC9(90898.2623940795310773),
     FLO_FC9(90921.4145510228554485),  FLO_FC9(90944.5681819217425073),
     FLO_FC9(90967.7232865885598585),  FLO_FC9(90990.8798648357187631),
     FLO_FC9(91014.0379164757177932),  FLO_FC9(91037.1974413210700732),
     FLO_FC9(91060.3584391843905905),  FLO_FC9(91083.5209098783379886),
     FLO_FC9(91106.6848532156291185),  FLO_FC9(91129.8502690090390388),
     FLO_FC9(91153.0171570714010159),  FLO_FC9(91176.1855172156210756),
     FLO_FC9(91199.3553492546488997),  FLO_FC9(91222.5266530014923774),
     FLO_FC9(91245.6994282692467095),  FLO_FC9(91268.8736748710362008),
     FLO_FC9(91292.0493926200579153),  FLO_FC9(91315.2265813295525732),
     FLO_FC9(91338.4052408128336538),  FLO_FC9(91361.5853708832873963),
     FLO_FC9(91384.7669713543436956),  FLO_FC9(91407.9500420394761022),
     FLO_FC9(91431.1345827522454783),  FLO_FC9(91454.3205933062563417),
     FLO_FC9(91477.5080735151714180),  FLO_FC9(91500.6970231927261921),
     FLO_FC9(91523.8874421526852529),  FLO_FC9(91547.0793302089296049),
     FLO_FC9(91570.2726871753257001),  FLO_FC9(91593.4675128658564063),
     FLO_FC9(91616.6638070945336949),  FLO_FC9(91639.8615696754422970),
     FLO_FC9(91663.0608004227251513),  FLO_FC9(91686.2614991505543003),
     FLO_FC9(91709.4636656732182018),  FLO_FC9(91732.6672998050198657),
     FLO_FC9(91755.8724013603205094),  FLO_FC9(91779.0789701535686618),
     FLO_FC9(91802.2870059992565075),  FLO_FC9(91825.4965087119198870),
     FLO_FC9(91848.7074781061674003),  FLO_FC9(91871.9199139966658549),
     FLO_FC9(91895.1338161981693702),  FLO_FC9(91918.3491845254175132),
     FLO_FC9(91941.5660187932808185),  FLO_FC9(91964.7843188166589243),
     FLO_FC9(91988.0040844104951248),  FLO_FC9(92011.2253153898200253),
     FLO_FC9(92034.4480115697078872),  FLO_FC9(92057.6721727652911795),
     FLO_FC9(92080.8977987917460268),  FLO_FC9(92104.1248894643649692),
     FLO_FC9(92127.3534445984114427),  FLO_FC9(92150.5834640092798509),
     FLO_FC9(92173.8149475123791490),  FLO_FC9(92197.0478949232201558),
     FLO_FC9(92220.2823060573136900),  FLO_FC9(92243.5181807302724337),
     FLO_FC9(92266.7555187577527249),  FLO_FC9(92289.9943199554691091),
     FLO_FC9(92313.2345841391943395),  FLO_FC9(92336.4763111247739289),
     FLO_FC9(92359.7195007280824939),  FLO_FC9(92382.9641527650674107),
     FLO_FC9(92406.2102670517488150),  FLO_FC9(92429.4578434041613946),
     FLO_FC9(92452.7068816384708043),  FLO_FC9(92475.9573815708135953),
     FLO_FC9(92499.2093430174427340),  FLO_FC9(92522.4627657946693944),
     FLO_FC9(92545.7176497188193025),  FLO_FC9(92568.9739946063054958),
     FLO_FC9(92592.2318002736137714),  FLO_FC9(92615.4910665372590302),
     FLO_FC9(92638.7517932138289325),  FLO_FC9(92662.0139801199402427),
     FLO_FC9(92685.2776270723261405),  FLO_FC9(92708.5427338877198054),
     FLO_FC9(92731.8093003829562804),  FLO_FC9(92755.0773263748706086),
     FLO_FC9(92778.3468116804142483),  FLO_FC9(92801.6177561165823136),
     FLO_FC9(92824.8901595003844704),  FLO_FC9(92848.1640216489468003),
     FLO_FC9(92871.4393423794244882),  FLO_FC9(92894.7161215090163751),
     FLO_FC9(92917.9943588550231652),  FLO_FC9(92941.2740542347455630),
     FLO_FC9(92964.5552074655715842),  FLO_FC9(92987.8378183649620041),
     FLO_FC9(93011.1218867504067020),  FLO_FC9(93034.4074124394683167),
     FLO_FC9(93057.6943952497676946),  FLO_FC9(93080.9828349989547860),
     FLO_FC9(93104.2727315047668526),  FLO_FC9(93127.5640845849993639),
     FLO_FC9(93150.8568940574914450),  FLO_FC9(93174.1511597401404288),
     FLO_FC9(93197.4468814509164076),  FLO_FC9(93220.7440590078040259),
     FLO_FC9(93244.0426922288897913),  FLO_FC9(93267.3427809323038673),
     FLO_FC9(93290.6443249362346251),  FLO_FC9(93313.9473240589140914),
     FLO_FC9(93337.2517781186325010),  FLO_FC9(93360.5576869337673998),
     FLO_FC9(93383.8650503226963338),  FLO_FC9(93407.1738681039278163),
     FLO_FC9(93430.4841400959412567),  FLO_FC9(93453.7958661173615837),
     FLO_FC9(93477.1090459867991740),  FLO_FC9(93500.4236795229517156),
     FLO_FC9(93523.7397665445605526),  FLO_FC9(93547.0573068704543402),
     FLO_FC9(93570.3763003194908379),  FLO_FC9(93593.6967467105714604),
     FLO_FC9(93617.0186458626994863),  FLO_FC9(93640.3419975948927458),
     FLO_FC9(93663.6668017262272770),  FLO_FC9(93686.9930580758809811),
     FLO_FC9(93710.3207664630317595),  FLO_FC9(93733.6499267069302732),
     FLO_FC9(93756.9805386269144947),  FLO_FC9(93780.3126020423369482),
     FLO_FC9(93803.6461167726374697),  FLO_FC9(93826.9810826372849988),
     FLO_FC9(93850.3174994558357866),  FLO_FC9(93873.6553670478606364),
     FLO_FC9(93896.9946852330322145),  FLO_FC9(93920.3354538310377393),
     FLO_FC9(93943.6776726616662927),  FLO_FC9(93967.0213415447069565),
     FLO_FC9(93990.3664603000506759),  FLO_FC9(94013.7130287476320518),
     FLO_FC9(94037.0610467074293410),  FLO_FC9(94060.4105139994935598),
     FLO_FC9(94083.7614304439193802),  FLO_FC9(94107.1137958608451299),
     FLO_FC9(94130.4676100705110002),  FLO_FC9(94153.8228728931571823),
     FLO_FC9(94177.1795841491111787),  FLO_FC9(94200.5377436587586999),
     FLO_FC9(94223.8973512425291119),  FLO_FC9(94247.2584067209099885),
     FLO_FC9(94270.6209099144325592),  FLO_FC9(94293.9848606437299168),
     FLO_FC9(94317.3502587294206023),  FLO_FC9(94340.7171039922395721),
     FLO_FC9(94364.0853962529363343),  FLO_FC9(94387.4551353323477088),
     FLO_FC9(94410.8263210513396189),  FLO_FC9(94434.1989532308507478),
     FLO_FC9(94457.5730316918779863),  FLO_FC9(94480.9485562554473290),
     FLO_FC9(94504.3255267426575301),  FLO_FC9(94527.7039429746801034),
     FLO_FC9(94551.0838047727156663),  FLO_FC9(94574.4651119580230443),
     FLO_FC9(94597.8478643519338220),  FLO_FC9(94621.2320617758232402),
     FLO_FC9(94644.6177040510956431),  FLO_FC9(94668.0047909992717905),
     FLO_FC9(94691.3933224418724421),  FLO_FC9(94714.7832982005056692),
     FLO_FC9(94738.1747180967940949),  FLO_FC9(94761.5675819524767576),
     FLO_FC9(94784.9618895893072477),  FLO_FC9(94808.3576408290973632),
     FLO_FC9(94831.7548354937025579),  FLO_FC9(94855.1534734050655970),
     FLO_FC9(94878.5535543851729017),  FLO_FC9(94901.9550782560545485),
     FLO_FC9(94925.3580448397842702),  FLO_FC9(94948.7624539585231105),
     FLO_FC9(94972.1683054344757693),  FLO_FC9(94995.5755990898906020),
     FLO_FC9(95018.9843347470741719),  FLO_FC9(95042.3945122283912497),
     FLO_FC9(95065.8061313562648138),  FLO_FC9(95089.2191919531760504),
     FLO_FC9(95112.6336938416352496),  FLO_FC9(95136.0496368442400126),
     FLO_FC9(95159.4670207836170448),  FLO_FC9(95182.8858454824658111),
     FLO_FC9(95206.3061107635294320),  FLO_FC9(95229.7278164496092359),
     FLO_FC9(95253.1509623635647586),  FLO_FC9(95276.5755483283137437),
     FLO_FC9(95300.0015741668030387),  FLO_FC9(95323.4290397020522505),
     FLO_FC9(95346.8579447571537457),  FLO_FC9(95370.2882891552144429),
     FLO_FC9(95393.7200727194285719),  FLO_FC9(95417.1532952730194665),
     FLO_FC9(95440.5879566392977722),  FLO_FC9(95464.0240566415886860),
     FLO_FC9(95487.4615951033047168),  FLO_FC9(95510.9005718479020288),
     FLO_FC9(95534.3409866988658905),  FLO_FC9(95557.7828394797834335),
     FLO_FC9(95581.2261300142563414),  FLO_FC9(95604.6708581259590574),
     FLO_FC9(95628.1170236385951284),  FLO_FC9(95651.5646263759845169),
     FLO_FC9(95675.0136661619180813),  FLO_FC9(95698.4641428203030955),
     FLO_FC9(95721.9160561750759371),  FLO_FC9(95745.3694060502311913),
     FLO_FC9(95768.8241922698070994),  FLO_FC9(95792.2804146579146618),
     FLO_FC9(95815.7380730387085350),  FLO_FC9(95839.1971672363870312),
     FLO_FC9(95862.6576970752212219),  FLO_FC9(95886.1196623795403866),
     FLO_FC9(95909.5830629736883566),  FLO_FC9(95933.0478986821108265),
     FLO_FC9(95956.5141693292680429),  FLO_FC9(95979.9818747397075640),
     FLO_FC9(96003.4510147380060516),  FLO_FC9(96026.9215891487983754),
     FLO_FC9(96050.3935977967921644),  FLO_FC9(96073.8670405067241518),
     FLO_FC9(96097.3419171033747261),  FLO_FC9(96120.8182274116261397),
     FLO_FC9(96144.2959712563751964),  FLO_FC9(96167.7751484625769081),
     FLO_FC9(96191.2557588552444940),  FLO_FC9(96214.7378022594493814),
     FLO_FC9(96238.2212785003066529),  FLO_FC9(96261.7061874029895989),
     FLO_FC9(96285.1925287927151658),  FLO_FC9(96308.6803024947876111),
     FLO_FC9(96332.1695083345257444),  FLO_FC9(96355.6601461373211350),
     FLO_FC9(96379.1522157286090078),  FLO_FC9(96402.6457169338682434),
     FLO_FC9(96426.1406495786650339),  FLO_FC9(96449.6370134886092274),
     FLO_FC9(96473.1348084893106716),  FLO_FC9(96496.6340344065101817),
     FLO_FC9(96520.1346910659631249),  FLO_FC9(96543.6367782934685238),
     FLO_FC9(96567.1402959148836089),  FLO_FC9(96590.6452437561529223),
     FLO_FC9(96614.1516216432210058),  FLO_FC9(96637.6594294021342648),
     FLO_FC9(96661.1686668589536566),  FLO_FC9(96684.6793338397983462),
     FLO_FC9(96708.1914301708748098),  FLO_FC9(96731.7049556783895241),
     FLO_FC9(96755.2199101886653807),  FLO_FC9(96778.7362935280107195),
     FLO_FC9(96802.2541055228357436),  FLO_FC9(96825.7733459995797602),
     FLO_FC9(96849.2940147847402841),  FLO_FC9(96872.8161117048730375),
     FLO_FC9(96896.3396365865773987),  FLO_FC9(96919.8645892565109534),
     FLO_FC9(96943.3909695413894951),  FLO_FC9(96966.9187772679579211),
     FLO_FC9(96990.4480122630484402),  FLO_FC9(97013.9786743535223650),
     FLO_FC9(97037.5107633662846638),  FLO_FC9(97061.0442791283276165),
     FLO_FC9(97084.5792214666726068),  FLO_FC9(97108.1155902083846740),
     FLO_FC9(97131.6533851805870654),  FLO_FC9(97155.1926062104903394),
     FLO_FC9(97178.7332531252905028),  FLO_FC9(97202.2753257522999775),
     FLO_FC9(97225.8188239188602893),  FLO_FC9(97249.3637474523420678),
     FLO_FC9(97272.9100961801887024),  FLO_FC9(97296.4578699299163418),
     FLO_FC9(97320.0070685290411348),  FLO_FC9(97343.5576918051956454),
     FLO_FC9(97367.1097395860124379),  FLO_FC9(97390.6632116991968360),
     FLO_FC9(97414.2181079724978190),  FLO_FC9(97437.7744282337371260),
     FLO_FC9(97461.3321723107655998),  FLO_FC9(97484.8913400315068429),
     FLO_FC9(97508.4519312238990096),  FLO_FC9(97532.0139457159821177),
     FLO_FC9(97555.5773833358107368),  FLO_FC9(97579.1422439115121961),
     FLO_FC9(97602.7085272712574806),  FLO_FC9(97626.2762332432612311),
     FLO_FC9(97649.8453616558108479),  FLO_FC9(97673.4159123372228350),
     FLO_FC9(97696.9878851158864563),  FLO_FC9(97720.5612798202055274),
     FLO_FC9(97744.1360962787002791),  FLO_FC9(97767.7123343198763905),
     FLO_FC9(97791.2899937723414041),  FLO_FC9(97814.8690744647028623),
     FLO_FC9(97838.4495762256847229),  FLO_FC9(97862.0314988839963917),
     FLO_FC9(97885.6148422684491379),  FLO_FC9(97909.1996062078833347),
     FLO_FC9(97932.7857905311830109),  FLO_FC9(97956.3733950673195068),
     FLO_FC9(97979.9624196452641627),  FLO_FC9(98003.5528640940756304),
     FLO_FC9(98027.1447282428562175),  FLO_FC9(98050.7380119207664393),
     FLO_FC9(98074.3327149569959147),  FLO_FC9(98097.9288371808070224),
     FLO_FC9(98121.5263784215057967),  FLO_FC9(98145.1253385084564798),
     FLO_FC9(98168.7257172710669693),  FLO_FC9(98192.3275145387742668),
     FLO_FC9(98215.9307301411317894),  FLO_FC9(98239.5353639076638501),
     FLO_FC9(98263.1414156680111773),  FLO_FC9(98286.7488852518144995),
     FLO_FC9(98310.3577724888164084),  FLO_FC9(98333.9680772087594960),
     FLO_FC9(98357.5797992414882174),  FLO_FC9(98381.1929384168470278),
     FLO_FC9(98404.8074945647822460),  FLO_FC9(98428.4234675152401906),
     FLO_FC9(98452.0408570982690435),  FLO_FC9(98475.6596631439169869),
     FLO_FC9(98499.2798854823195143),  FLO_FC9(98522.9015239436557749),
     FLO_FC9(98546.5245783581631258),  FLO_FC9(98570.1490485560934758),
     FLO_FC9(98593.7749343677860452),  FLO_FC9(98617.4022356236237101),
     FLO_FC9(98641.0309521540475544),  FLO_FC9(98664.6610837895132136),
     FLO_FC9(98688.2926303605636349),  FLO_FC9(98711.9255916977708694),
     FLO_FC9(98735.5599676317942794),  FLO_FC9(98759.1957579932932276),
     FLO_FC9(98782.8329626130143879),  FLO_FC9(98806.4715813217335381),
     FLO_FC9(98830.1116139502846636),  FLO_FC9(98853.7530603295745095),
     FLO_FC9(98877.3959202905098209),  FLO_FC9(98901.0401936640992062),
     FLO_FC9(98924.6858802813803777),  FLO_FC9(98948.3329799734201515),
     FLO_FC9(98971.9814925713872071),  FLO_FC9(98995.6314179064502241),
     FLO_FC9(99019.2827558098506415),  FLO_FC9(99042.9355061128735542),
     FLO_FC9(99066.5896686468768166),  FLO_FC9(99090.2452432432328351),
     FLO_FC9(99113.9022297334013274),  FLO_FC9(99137.5606279488565633),
     FLO_FC9(99161.2204377211455721),  FLO_FC9(99184.8816588818590390),
     FLO_FC9(99208.5442912626313046),  FLO_FC9(99232.2083346951694693),
     FLO_FC9(99255.8737890112097375),  FLO_FC9(99279.5406540425465209),
     FLO_FC9(99303.2089296210324392),  FLO_FC9(99326.8786155785201117),
     FLO_FC9(99350.5497117469931254),  FLO_FC9(99374.2222179584350670),
     FLO_FC9(99397.8961340448877309),  FLO_FC9(99421.5714598384220153),
     FLO_FC9(99445.2481951712106820),  FLO_FC9(99468.9263398754410446),
     FLO_FC9(99492.6058937833440723),  FLO_FC9(99516.2868567272089422),
     FLO_FC9(99539.9692285393975908),  FLO_FC9(99563.6530090522865066),
     FLO_FC9(99587.3381980983249377),  FLO_FC9(99611.0247955100057879),
     FLO_FC9(99634.7128011198656168),  FLO_FC9(99658.4022147604991915),
     FLO_FC9(99682.0930362645449350),  FLO_FC9(99705.7852654646994779),
     FLO_FC9(99729.4789021936885547),  FLO_FC9(99753.1739462843252113),
     FLO_FC9(99776.8703975694370456),  FLO_FC9(99800.5682558819098631),
     FLO_FC9(99824.2675210546876770),  FLO_FC9(99847.9681929207727080),
     FLO_FC9(99871.6702713131817291),  FLO_FC9(99895.3737560650042724),
     FLO_FC9(99919.0786470093880780),  FLO_FC9(99942.7849439795245416),
     FLO_FC9(99966.4926468086341629),  FLO_FC9(99990.2017553300102009),
     FLO_FC9(100013.9122693769895704),  FLO_FC9(100037.6241887829528423),
     FLO_FC9(100061.3375133813387947),  FLO_FC9(100085.0522430056298617),
     FLO_FC9(100108.7683774893521331),  FLO_FC9(100132.4859166661044583),
     FLO_FC9(100156.2048603695002384),  FLO_FC9(100179.9252084332256345),
     FLO_FC9(100203.6469606910104631),  FLO_FC9(100227.3701169766427483),
     FLO_FC9(100251.0946771239396185),  FLO_FC9(100274.8206409667764092),
     FLO_FC9(100298.5480083390866639),  FLO_FC9(100322.2767790748330299),
     FLO_FC9(100346.0069530080654658),  FLO_FC9(100369.7385299728339305),
     FLO_FC9(100393.4715098032756941),  FLO_FC9(100417.2058923335425789),
     FLO_FC9(100440.9416773978882702),  FLO_FC9(100464.6788648305519018),
     FLO_FC9(100488.4174544658599189),  FLO_FC9(100512.1574461381969741),
     FLO_FC9(100535.8988396819622722),  FLO_FC9(100559.6416349316132255),
     FLO_FC9(100583.3858317216945579),  FLO_FC9(100607.1314298867364414),
     FLO_FC9(100630.8784292613709113),  FLO_FC9(100654.6268296802445548),
     FLO_FC9(100678.3766309780912707),  FLO_FC9(100702.1278329896449577),
     FLO_FC9(100725.8804355497122742),  FLO_FC9(100749.6344384931726381),
     FLO_FC9(100773.3898416549054673),  FLO_FC9(100797.1466448698629392),
     FLO_FC9(100820.9048479730699910),  FLO_FC9(100844.6644507995661115),
     FLO_FC9(100868.4254531844344456),  FLO_FC9(100892.1878549628454493),
     FLO_FC9(100915.9516559699841309),  FLO_FC9(100939.7168560410937062),
     FLO_FC9(100963.4834550114610465),  FLO_FC9(100987.2514527164457832),
     FLO_FC9(101011.0208489914220991),  FLO_FC9(101034.7916436718223849),
     FLO_FC9(101058.5638365931663429),  FLO_FC9(101082.3374275909445714),
     FLO_FC9(101106.1124165007786360),  FLO_FC9(101129.8888031582755502),
     FLO_FC9(101153.6665873991150875),  FLO_FC9(101177.4457690590497805),
     FLO_FC9(101201.2263479738321621),  FLO_FC9(101225.0083239792875247),
     FLO_FC9(101248.7916969112993684),  FLO_FC9(101272.5764666057948489),
     FLO_FC9(101296.3626328987302259),  FLO_FC9(101320.1501956261199666),
     FLO_FC9(101343.9391546240367461),  FLO_FC9(101367.7295097285968950),
     FLO_FC9(101391.5212607759603998),  FLO_FC9(101415.3144076023309026),
     FLO_FC9(101439.1089500439702533),  FLO_FC9(101462.9048879371985095),
     FLO_FC9(101486.7022211183357285),  FLO_FC9(101510.5009494238183834),
     FLO_FC9(101534.3010726900829468),  FLO_FC9(101558.1025907536240993),
     FLO_FC9(101581.9055034509801771),  FLO_FC9(101605.7098106187622761),
     FLO_FC9(101629.5155120935960440),  FLO_FC9(101653.3226077121798880),
     FLO_FC9(101677.1310973112558713),  FLO_FC9(101700.9409807275951607),
     FLO_FC9(101724.7522577980416827),  FLO_FC9(101748.5649283594684675),
     FLO_FC9(101772.3789922488067532),  FLO_FC9(101796.1944493030314334),
     FLO_FC9(101820.0112993591610575),  FLO_FC9(101843.8295422542723827),
     FLO_FC9(101867.6491778254858218),  FLO_FC9(101891.4702059099654434),
     FLO_FC9(101915.2926263449189719),  FLO_FC9(101939.1164389676268911),
     FLO_FC9(101962.9416436153696850),  FLO_FC9(101986.7682401255297009),
     FLO_FC9(102010.5962283354892861),  FLO_FC9(102034.4256080827180995),
     FLO_FC9(102058.2563792047149036),  FLO_FC9(102082.0885415390075650),
     FLO_FC9(102105.9220949231967097),  FLO_FC9(102129.7570391949411714),
     FLO_FC9(102153.5933741919143358),  FLO_FC9(102177.4310997518477961),
     FLO_FC9(102201.2702157125313533),  FLO_FC9(102225.1107219117984641),
     FLO_FC9(102248.9526181875262409),  FLO_FC9(102272.7959043776354520),
     FLO_FC9(102296.6405803200905211),  FLO_FC9(102320.4866458529286319),
     FLO_FC9(102344.3341008142160717),  FLO_FC9(102368.1829450420482317),
     FLO_FC9(102392.0331783746078145),  FLO_FC9(102415.8848006500775227),
     FLO_FC9(102439.7378117067273706),  FLO_FC9(102463.5922113828710280),
     FLO_FC9(102487.4479995168367168),  FLO_FC9(102511.3051759470399702),
     FLO_FC9(102535.1637405118963216),  FLO_FC9(102559.0236930499231676),
     FLO_FC9(102582.8850333996524569),  FLO_FC9(102606.7477613996743457),
     FLO_FC9(102630.6118768885935424),  FLO_FC9(102654.4773797051166184),
     FLO_FC9(102678.3442696879501455),  FLO_FC9(102702.2125466758734547),
     FLO_FC9(102726.0822105077095330),  FLO_FC9(102749.9532610223104712),
     FLO_FC9(102773.8256980586011196),  FLO_FC9(102797.6995214555354323),
     FLO_FC9(102821.5747310521255713),  FLO_FC9(102845.4513266874273540),
     FLO_FC9(102869.3293082005111501),  FLO_FC9(102893.2086754305637442),
     FLO_FC9(102917.0894282167428173),  FLO_FC9(102940.9715663983079139),
     FLO_FC9(102964.8550898145476822),  FLO_FC9(102988.7399983047798742),
     FLO_FC9(103012.6262917083950015),  FLO_FC9(103036.5139698648126796),
     FLO_FC9(103060.4030326135107316),  FLO_FC9(103084.2934797939960845),
     FLO_FC9(103108.1853112458484247),  FLO_FC9(103132.0785268086619908),
     FLO_FC9(103155.9731263221183326),  FLO_FC9(103179.8691096258990001),
     FLO_FC9(103203.7664765597728547),  FLO_FC9(103227.6652269635233097),
     FLO_FC9(103251.5653606770065380),  FLO_FC9(103275.4668775401078165),
     FLO_FC9(103299.3697773927560775),  FLO_FC9(103323.2740600749530131),
     FLO_FC9(103347.1797254267003154),  FLO_FC9(103371.0867732881015399),
     FLO_FC9(103394.9952034992456902),  FLO_FC9(103418.9050159003381850),
     FLO_FC9(103442.8162103315698914),  FLO_FC9(103466.7287866331898840),
     FLO_FC9(103490.6427446455345489),  FLO_FC9(103514.5580842089402722),
     FLO_FC9(103538.4748051638016477),  FLO_FC9(103562.3929073505714769),
     FLO_FC9(103586.3123906097316649),  FLO_FC9(103610.2332547818368766),
     FLO_FC9(103634.1554997074417770),  FLO_FC9(103658.0791252271883423),
     FLO_FC9(103682.0041311817622045),  FLO_FC9(103705.9305174118780997),
     FLO_FC9(103729.8582837582944194),  FLO_FC9(103753.7874300618277630),
     FLO_FC9(103777.7179561633383855),  FLO_FC9(103801.6498619037156459),
     FLO_FC9(103825.5831471239362145),  FLO_FC9(103849.5178116649767617),
     FLO_FC9(103873.4538553679012693),  FLO_FC9(103897.3912780737591675),
     FLO_FC9(103921.3300796237163013),  FLO_FC9(103945.2702598589385161),
     FLO_FC9(103969.2118186206644168),  FLO_FC9(103993.1547557501326082),
     FLO_FC9(104017.0990710886981105),  FLO_FC9(104041.0447644777013920),
     FLO_FC9(104064.9918357585411286),  FLO_FC9(104088.9402847726887558),
     FLO_FC9(104112.8901113616302609),  FLO_FC9(104136.8413153669243911),
     FLO_FC9(104160.7938966301444452),  FLO_FC9(104184.7478549929510336),
     FLO_FC9(104208.7031902969902148),  FLO_FC9(104232.6599023840099107),
     FLO_FC9(104256.6179910957725951),  FLO_FC9(104280.5774562741135014),
     FLO_FC9(104304.5382977608678630),  FLO_FC9(104328.5005153979727766),
     FLO_FC9(104352.4641090273653390),  FLO_FC9(104376.4290784910408547),
     FLO_FC9(104400.3954236310528358),  FLO_FC9(104424.3631442894838983),
     FLO_FC9(104448.3322403084603138),  FLO_FC9(104472.3027115301956655),
     FLO_FC9(104496.2745577968889847),  FLO_FC9(104520.2477789507975103),
     FLO_FC9(104544.2223748342803447),  FLO_FC9(104568.1983452896529343),
     FLO_FC9(104592.1756901593616931),  FLO_FC9(104616.1544092858239310),
     FLO_FC9(104640.1345025115588214),  FLO_FC9(104664.1159696791000897),
     FLO_FC9(104688.0988106310251169),  FLO_FC9(104712.0830252099840436),
     FLO_FC9(104736.0686132586415624),  FLO_FC9(104760.0555746197205735),
     FLO_FC9(104784.0439091360021848),  FLO_FC9(104808.0336166502675042),
     FLO_FC9(104832.0246970054140547),  FLO_FC9(104856.0171500443102559),
     FLO_FC9(104880.0109756099118385),  FLO_FC9(104904.0061735452181892),
     FLO_FC9(104928.0027436932577984),  FLO_FC9(104952.0006858971319161),
     FLO_FC9(104975.9999999999272404),  FLO_FC9(105000.0006858448614366),
     FLO_FC9(105024.0027432751085144),  FLO_FC9(105048.0061721339588985),
     FLO_FC9(105072.0109722647030139),  FLO_FC9(105096.0171435107040452),
     FLO_FC9(105120.0246857153397286),  FLO_FC9(105144.0335987220751122),
     FLO_FC9(105168.0438823743606918),  FLO_FC9(105192.0555365157488268),
     FLO_FC9(105216.0685609898209805),  FLO_FC9(105240.0829556401731679),
     FLO_FC9(105264.0987203104741639),  FLO_FC9(105288.1158548444363987),
     FLO_FC9(105312.1343590858159587),  FLO_FC9(105336.1542328783980338),
     FLO_FC9(105360.1754760660405736),  FLO_FC9(105384.1980884926160797),
     FLO_FC9(105408.2220700020552613),  FLO_FC9(105432.2474204383324832),
     FLO_FC9(105456.2741396454657661),  FLO_FC9(105480.3022274675313383),
     FLO_FC9(105504.3316837486345321),  FLO_FC9(105528.3625083329097833),
     FLO_FC9(105552.3947010645788396),  FLO_FC9(105576.4282617878634483),
     FLO_FC9(105600.4631903470581165),  FLO_FC9(105624.4994865864864551),
     FLO_FC9(105648.5371503505302826),  FLO_FC9(105672.5761814836005215),
     FLO_FC9(105696.6165798301663017),  FLO_FC9(105720.6583452347258572),
     FLO_FC9(105744.7014775418356294),  FLO_FC9(105768.7459765960957156),
     FLO_FC9(105792.7918422421353171),  FLO_FC9(105816.8390743246418424),
     FLO_FC9(105840.8876726883463562),  FLO_FC9(105864.9376371780090267),
     FLO_FC9(105888.9889676384627819),  FLO_FC9(105913.0416639145551017),
     FLO_FC9(105937.0957258511916734),  FLO_FC9(105961.1511532933218405),
     FLO_FC9(105985.2079460859531537),  FLO_FC9(106009.2661040740931639),
     FLO_FC9(106033.3256271028367337),  FLO_FC9(106057.3865150172932772),
     FLO_FC9(106081.4487676626595203),  FLO_FC9(106105.5123848841176368),
     FLO_FC9(106129.5773665269516641),  FLO_FC9(106153.6437124364310876),
     FLO_FC9(106177.7114224579127040),  FLO_FC9(106201.7804964367969660),
     FLO_FC9(106225.8509342184843263),  FLO_FC9(106249.9227356484771008),
     FLO_FC9(106273.9959005722776055),  FLO_FC9(106298.0704288354609162),
     FLO_FC9(106322.1463202836166602),  FLO_FC9(106346.2235747624072246),
     FLO_FC9(106370.3021921175095486),  FLO_FC9(106394.3821721946878824),
     FLO_FC9(106418.4635148396919249),  FLO_FC9(106442.5462198983732378),
     FLO_FC9(106466.6302872165833833),  FLO_FC9(106490.7157166402466828),
     FLO_FC9(106514.8025080152874580),  FLO_FC9(106538.8906611877464456),
     FLO_FC9(106562.9801760036352789),  FLO_FC9(106587.0710523090529023),
     FLO_FC9(106611.1632899501128122),  FLO_FC9(106635.2568887730158167),
     FLO_FC9(106659.3518486239481717),  FLO_FC9(106683.4481693491834449),
     FLO_FC9(106707.5458507950243074),  FLO_FC9(106731.6448928078170866),
     FLO_FC9(106755.7452952339517651),  FLO_FC9(106779.8470579198619816),
     FLO_FC9(106803.9501807120104786),  FLO_FC9(106828.0546634569327580),
     FLO_FC9(106852.1605060011788737),  FLO_FC9(106876.2677081913716393),
     FLO_FC9(106900.3762698741338681),  FLO_FC9(106924.4861908961902373),
     FLO_FC9(106948.5974711042508716),  FLO_FC9(106972.7101103451132076),
     FLO_FC9(106996.8241084655892337),  FLO_FC9(107020.9394653125345940),
     FLO_FC9(107045.0561807328776922),  FLO_FC9(107069.1742545735614840),
     FLO_FC9(107093.2936866815871326),  FLO_FC9(107117.4144769039703533),
     FLO_FC9(107141.5366250878141727),  FLO_FC9(107165.6601310802361695),
     FLO_FC9(107189.7849947283975780),  FLO_FC9(107213.9112158795178402),
     FLO_FC9(107238.0387943808455020),  FLO_FC9(107262.1677300796727650),
     FLO_FC9(107286.2980228233354865),  FLO_FC9(107310.4296724592277315),
     FLO_FC9(107334.5626788347581169),  FLO_FC9(107358.6970417974080192),
     FLO_FC9(107382.8327611946733668),  FLO_FC9(107406.9698368741228478),
     FLO_FC9(107431.1082686833542539),  FLO_FC9(107455.2480564699944807),
     FLO_FC9(107479.3892000817140797),  FLO_FC9(107503.5316993662709137),
     FLO_FC9(107527.6755541713937419),  FLO_FC9(107551.8207643449277384),
     FLO_FC9(107575.9673297346889740),  FLO_FC9(107600.1152501886099344),
     FLO_FC9(107624.2645255546085536),  FLO_FC9(107648.4151556806609733),
     FLO_FC9(107672.5671404148015426),  FLO_FC9(107696.7204796050791629),
     FLO_FC9(107720.8751730996300466),  FLO_FC9(107745.0312207465758547),
     FLO_FC9(107769.1886223941401113),  FLO_FC9(107793.3473778905317886),
     FLO_FC9(107817.5074870840326184),  FLO_FC9(107841.6689498229825404),
     FLO_FC9(107865.8317659557214938),  FLO_FC9(107889.9959353306767298),
     FLO_FC9(107914.1614577962900512),  FLO_FC9(107938.3283332010469167),
     FLO_FC9(107962.4965613934764406),  FLO_FC9(107986.6661422221659450),
     FLO_FC9(108010.8370755357173039),  FLO_FC9(108035.0093611828197027),
     FLO_FC9(108059.1829990121477749),  FLO_FC9(108083.3579888724489138),
     FLO_FC9(108107.5343306125287199),  FLO_FC9(108131.7120240812073462),
     FLO_FC9(108155.8910691273486009),  FLO_FC9(108180.0714655998745002),
     FLO_FC9(108204.2532133477507159),  FLO_FC9(108228.4363122199574718),
     FLO_FC9(108252.6207620655331993),  FLO_FC9(108276.8065627335745376),
     FLO_FC9(108300.9937140732072294),  FLO_FC9(108325.1822159335861215),
     FLO_FC9(108349.3720681639388204),  FLO_FC9(108373.5632706134929322),
     FLO_FC9(108397.7558231315633748),  FLO_FC9(108421.9497255674650660),
     FLO_FC9(108446.1449777706002351),  FLO_FC9(108470.3415795903565595),
     FLO_FC9(108494.5395308762235800),  FLO_FC9(108518.7388314776908373),
     FLO_FC9(108542.9394812443206320),  FLO_FC9(108567.1414800256752642),
     FLO_FC9(108591.3448276713897940),  FLO_FC9(108615.5495240311429370),
     FLO_FC9(108639.7555689546425128),  FLO_FC9(108663.9629622916545486),
     FLO_FC9(108688.1717038919596234),  FLO_FC9(108712.3817936054110760),
     FLO_FC9(108736.5932312818767969),  FLO_FC9(108760.8060167712828843),
     FLO_FC9(108785.0201499235845404),  FLO_FC9(108809.2356305888097268),
     FLO_FC9(108833.4524586169864051),  FLO_FC9(108857.6706338582152966),
     FLO_FC9(108881.8901561626116745),  FLO_FC9(108906.1110253803635715),
     FLO_FC9(108930.3332413616735721),  FLO_FC9(108954.5568039568170207),
     FLO_FC9(108978.7817130160692614),  FLO_FC9(109003.0079683897638461),
     FLO_FC9(109027.2355699283070862),  FLO_FC9(109051.4645174821052933),
     FLO_FC9(109075.6948109016229864),  FLO_FC9(109099.9264500373683404),
     FLO_FC9(109124.1594347398931859),  FLO_FC9(109148.3937648597639054),
     FLO_FC9(109172.6294402476341929),  FLO_FC9(109196.8664607541577425),
     FLO_FC9(109221.1048262300610077),  FLO_FC9(109245.3445365260995459),
     FLO_FC9(109269.5855914930434665),  FLO_FC9(109293.8279909817501903),
     FLO_FC9(109318.0717348431062419),  FLO_FC9(109342.3168229280126980),
     FLO_FC9(109366.5632550874288427),  FLO_FC9(109390.8110311723721679),
     FLO_FC9(109415.0601510338747175),  FLO_FC9(109439.3106145230121911),
     FLO_FC9(109463.5624214909330476),  FLO_FC9(109487.8155717888002982),
     FLO_FC9(109512.0700652678060578),  FLO_FC9(109536.3259017792006489),
     FLO_FC9(109560.5830811742926016),  FLO_FC9(109584.8416033044049982),
     FLO_FC9(109609.1014680209045764),  FLO_FC9(109633.3626751752162818),
     FLO_FC9(109657.6252246187796118),  FLO_FC9(109681.8891162030922715),
     FLO_FC9(109706.1543497797101736),  FLO_FC9(109730.4209252002037829),
     FLO_FC9(109754.6888423161872197),  FLO_FC9(109778.9581009793182602),
     FLO_FC9(109803.2287010412983363),  FLO_FC9(109827.5006423538870877),
     FLO_FC9(109851.7739247688441537),  FLO_FC9(109876.0485481380019337),
     FLO_FC9(109900.3245123132364824),  FLO_FC9(109924.6018171464384068),
     FLO_FC9(109948.8804624895710731),  FLO_FC9(109973.1604481945978478),
     FLO_FC9(109997.4417741135694087),  FLO_FC9(110021.7244400985509856),
     FLO_FC9(110046.0084460016369121),  FLO_FC9(110070.2937916750088334),
     FLO_FC9(110094.5804769708192907),  FLO_FC9(110118.8685017413372407),
     FLO_FC9(110143.1578658388170879),  FLO_FC9(110167.4485691155714449),
     FLO_FC9(110191.7406114239711314),  FLO_FC9(110216.0339926163869677),
     FLO_FC9(110240.3287125452770852),  FLO_FC9(110264.6247710631141672),
     FLO_FC9(110288.9221680224000011),  FLO_FC9(110313.2209032757091336),
     FLO_FC9(110337.5209766756452154),  FLO_FC9(110361.8223880748264492),
     FLO_FC9(110386.1251373259437969),  FLO_FC9(110410.4292242817173246),
     FLO_FC9(110434.7346487949107541),  FLO_FC9(110459.0414107183169108),
     FLO_FC9(110483.3495099047868280),  FLO_FC9(110507.6589462071860908),
     FLO_FC9(110531.9697194784675958),  FLO_FC9(110556.2818295715696877),
     FLO_FC9(110580.5952763395034708),  FLO_FC9(110604.9100596353237052),
     FLO_FC9(110629.2261793120851507),  FLO_FC9(110653.5436352229444310),
     FLO_FC9(110677.8624272210581694),  FLO_FC9(110702.1825551596266450),
     FLO_FC9(110726.5040188918792410),  FLO_FC9(110750.8268182711326517),
     FLO_FC9(110775.1509531507035717),  FLO_FC9(110799.4764233839523513),
     FLO_FC9(110823.8032288242829964),  FLO_FC9(110848.1313693251431687),
     FLO_FC9(110872.4608447400387377),  FLO_FC9(110896.7916549224755727),
     FLO_FC9(110921.1237997260323027),  FLO_FC9(110945.4572790043021087),
     FLO_FC9(110969.7920926109654829),  FLO_FC9(110994.1282403996738140),
     FLO_FC9(111018.4657222241658019),  FLO_FC9(111042.8045379382238025),
     FLO_FC9(111067.1446873956592754),  FLO_FC9(111091.4861704502836801),
     FLO_FC9(111115.8289869560248917),  FLO_FC9(111140.1731367667962331),
     FLO_FC9(111164.5186197365692351),  FLO_FC9(111188.8654357193299802),
     FLO_FC9(111213.2135845691664144),  FLO_FC9(111237.5630661401373800),
     FLO_FC9(111261.9138802863890305),  FLO_FC9(111286.2660268620675197),
     FLO_FC9(111310.6195057214063127),  FLO_FC9(111334.9743167186388746),
     FLO_FC9(111359.3304597080423264),  FLO_FC9(111383.6879345439665485),
     FLO_FC9(111408.0467410807759734),  FLO_FC9(111432.4068791728641372),
     FLO_FC9(111456.7683486746827839),  FLO_FC9(111481.1311494407273130),
     FLO_FC9(111505.4952813255076762),  FLO_FC9(111529.8607441836065846),
     FLO_FC9(111554.2275378696358530),  FLO_FC9(111578.5956622382072965),
     FLO_FC9(111602.9651171440491453),  FLO_FC9(111627.3359024418459740),
     FLO_FC9(111651.7080179863987723),  FLO_FC9(111676.0814636324794265),
     FLO_FC9(111700.4562392349616857),  FLO_FC9(111724.8323446487047477),
     FLO_FC9(111749.2097797286405694),  FLO_FC9(111773.5885443297447637),
     FLO_FC9(111797.9686383069929434),  FLO_FC9(111822.3500615154480329),
     FLO_FC9(111846.7328138101875084),  FLO_FC9(111871.1168950463325018),
     FLO_FC9(111895.5023050790332491),  FLO_FC9(111919.8890437634981936),
     FLO_FC9(111944.2771109549503308),  FLO_FC9(111968.6665065086999675),
     FLO_FC9(111993.0572302800428588),  FLO_FC9(112017.4492821243475191),
     FLO_FC9(112041.8426618969970150),  FLO_FC9(112066.2373694534326205),
     FLO_FC9(112090.6334046491247136),  FLO_FC9(112115.0307673396164319),
     FLO_FC9(112139.4294573804218089),  FLO_FC9(112163.8294746271567419),
     FLO_FC9(112188.2308189354516799),  FLO_FC9(112212.6334901609661756),
     FLO_FC9(112237.0374881594325416),  FLO_FC9(112261.4428127865830902),
     FLO_FC9(112285.8494638982228935),  FLO_FC9(112310.2574413501715753),
     FLO_FC9(112334.6667449982924154),  FLO_FC9(112359.0773746984923491),
     FLO_FC9(112383.4893303067219676),  FLO_FC9(112407.9026116789755179),
     FLO_FC9(112432.3172186712617986),  FLO_FC9(112456.7331511396478163),
     FLO_FC9(112481.1504089402442332),  FLO_FC9(112505.5689919291908154),
     FLO_FC9(112529.9888999626564328),  FLO_FC9(112554.4101328968827147),
     FLO_FC9(112578.8326905881112907),  FLO_FC9(112603.2565728926274460),
     FLO_FC9(112627.6817796667892253),  FLO_FC9(112652.1083107669837773),
     FLO_FC9(112676.5361660495836986),  FLO_FC9(112700.9653453710780013),
     FLO_FC9(112725.3958485879411455),  FLO_FC9(112749.8276755567203509),
     FLO_FC9(112774.2608261339773890),  FLO_FC9(112798.6953001763031352),
     FLO_FC9(112823.1310975403757766),  FLO_FC9(112847.5682180828589480),
     FLO_FC9(112872.0066616604890442),  FLO_FC9(112896.4464281300315633),
     FLO_FC9(112920.8875173482665559),  FLO_FC9(112945.3299291720759356),
     FLO_FC9(112969.7736634583125124),  FLO_FC9(112994.2187200638873037),
     FLO_FC9(113018.6650988457840867),  FLO_FC9(113043.1127996609866386),
     FLO_FC9(113067.5618223665223923),  FLO_FC9(113092.0121668194769882),
     FLO_FC9(113116.4638328769506188),  FLO_FC9(113140.9168203961016843),
     FLO_FC9(113165.3711292341322405),  FLO_FC9(113189.8267592482443433),
     FLO_FC9(113214.2837102957273601),  FLO_FC9(113238.7419822338706581),
     FLO_FC9(113263.2015749200218124),  FLO_FC9(113287.6624882115720538),
     FLO_FC9(113312.1247219659271650),  FLO_FC9(113336.5882760405511362),
     FLO_FC9(113361.0531502929516137),  FLO_FC9(113385.5193445806653472),
     FLO_FC9(113409.9868587612436386),  FLO_FC9(113434.4556926923251012),
     FLO_FC9(113458.9258462315483484),  FLO_FC9(113483.3973192366102012),
     FLO_FC9(113507.8701115652220324),  FLO_FC9(113532.3442230751679745),
     FLO_FC9(113556.8196536242467118),  FLO_FC9(113581.2964030703005847),
     FLO_FC9(113605.7744712712155888),  FLO_FC9(113630.2538580849068239),
     FLO_FC9(113654.7345633693330456),  FLO_FC9(113679.2165869824966649),
     FLO_FC9(113703.6999287824146450),  FLO_FC9(113728.1845886271767085),
     FLO_FC9(113752.6705663748725783),  FLO_FC9(113777.1578618836792884),
     FLO_FC9(113801.6464750117738731),  FLO_FC9(113826.1364056173624704),
     FLO_FC9(113850.6276535587385297),  FLO_FC9(113875.1202186941809487),
     FLO_FC9(113899.6141008820413845),  FLO_FC9(113924.1092999807005981),
     FLO_FC9(113948.6058158485539025),  FLO_FC9(113973.1036483440693701),
     FLO_FC9(113997.6027973257441772),  FLO_FC9(114022.1032626521046041),
     FLO_FC9(114046.6050441817060346),  FLO_FC9(114071.1081417731766123),
     FLO_FC9(114095.6125552851444809),  FLO_FC9(114120.1182845762814395),
     FLO_FC9(114144.6253295053320471),  FLO_FC9(114169.1336899310408626),
     FLO_FC9(114193.6433657121961005),  FLO_FC9(114218.1543567076441832),
     FLO_FC9(114242.6666627762606367),  FLO_FC9(114267.1802837769355392),
     FLO_FC9(114291.6952195686171763),  FLO_FC9(114316.2114700103120413),
     FLO_FC9(114340.7290349610266276),  FLO_FC9(114365.2479142798256362),
     FLO_FC9(114389.7681078258028720),  FLO_FC9(114414.2896154580957955),
     FLO_FC9(114438.8124370358855231),  FLO_FC9(114463.3365724183677230),
     FLO_FC9(114487.8620214647962712),  FLO_FC9(114512.3887840344832512),
     FLO_FC9(114536.9168599867116427),  FLO_FC9(114561.4462491808662890),
     FLO_FC9(114585.9769514763611369),  FLO_FC9(114610.5089667325955816),
     FLO_FC9(114635.0422948090854334),  FLO_FC9(114659.5769355653173989),
     FLO_FC9(114684.1128888608363923),  FLO_FC9(114708.6501545552600874),
     FLO_FC9(114733.1887325081770541),  FLO_FC9(114757.7286225792777259),
     FLO_FC9(114782.2698246282525361),  FLO_FC9(114806.8123385148355737),
     FLO_FC9(114831.3561640988191357),  FLO_FC9(114855.9013012399809668),
     FLO_FC9(114880.4477497982152272),  FLO_FC9(114904.9955096333724214),
     FLO_FC9(114929.5445806054049172),  FLO_FC9(114954.0949625742505305),
     FLO_FC9(114978.6466553999198368),  FLO_FC9(115003.1996589424670674),
     FLO_FC9(115027.7539730619464535),  FLO_FC9(115052.3095976184704341),
     FLO_FC9(115076.8665324721805518),  FLO_FC9(115101.4247774832911091),
     FLO_FC9(115125.9843325120018562),  FLO_FC9(115150.5451974185853032),
     FLO_FC9(115175.1073720633430639),  FLO_FC9(115199.6708563065913040),
     FLO_FC9(115224.2356500087335007),  FLO_FC9(115248.8017530301440274),
     FLO_FC9(115273.3691652312991209),  FLO_FC9(115297.9378864726604661),
     FLO_FC9(115322.5079166147625074),  FLO_FC9(115347.0792555181687931),
     FLO_FC9(115371.6519030434719753),  FLO_FC9(115396.2258590512938099),
     FLO_FC9(115420.8011234023142606),  FLO_FC9(115445.3776959572423948),
     FLO_FC9(115469.9555765768163837),  FLO_FC9(115494.5347651218180545),
     FLO_FC9(115519.1152614530583378),  FLO_FC9(115543.6970654314063722),
     FLO_FC9(115568.2801769177604001),  FLO_FC9(115592.8645957730332157),
     FLO_FC9(115617.4503218581958208),  FLO_FC9(115642.0373550342483213),
     FLO_FC9(115666.6256951622344786),  FLO_FC9(115691.2153421032271581),
     FLO_FC9(115715.8062957183574326),  FLO_FC9(115740.3985558687563753),
     FLO_FC9(115764.9921224156278186),  FLO_FC9(115789.5869952201755950),
     FLO_FC9(115814.1831741436762968),  FLO_FC9(115838.7806590474356199),
     FLO_FC9(115863.3794497927592602),  FLO_FC9(115887.9795462410547771),
     FLO_FC9(115912.5809482537006261),  FLO_FC9(115937.1836556921625743),
     FLO_FC9(115961.7876684179209406),  FLO_FC9(115986.3929862924851477),
     FLO_FC9(116010.9996091774228262),  FLO_FC9(116035.6075369343161583),
     FLO_FC9(116060.2167694247909822),  FLO_FC9(116084.8273065105313435),
     FLO_FC9(116109.4391480532212881),  FLO_FC9(116134.0522939146030694),
     FLO_FC9(116158.6667439564625965),  FLO_FC9(116183.2824980406003306),
     FLO_FC9(116207.8995560288603883),  FLO_FC9(116232.5179177831596462),
     FLO_FC9(116257.1375831653858768),  FLO_FC9(116281.7585520375141641),
     FLO_FC9(116306.3808242615341442),  FLO_FC9(116331.0043996994936606),
     FLO_FC9(116355.6292782134260051),  FLO_FC9(116380.2554596654663328),
     FLO_FC9(116404.8829439177497989),  FLO_FC9(116429.5117308324552141),
     FLO_FC9(116454.1418202717759414),  FLO_FC9(116478.7732120979926549),
     FLO_FC9(116503.4059061733714771),  FLO_FC9(116528.0399023602512898),
     FLO_FC9(116552.6752005209709750),  FLO_FC9(116577.3118005179421743),
     FLO_FC9(116601.9497022135910811),  FLO_FC9(116626.5889054704020964),
     FLO_FC9(116651.2294101508596214),  FLO_FC9(116675.8712161175062647),
     FLO_FC9(116700.5143232329428429),  FLO_FC9(116725.1587313597556204),
     FLO_FC9(116749.8044403606036212),  FLO_FC9(116774.4514500981749734),
     FLO_FC9(116799.0997604352014605),  FLO_FC9(116823.7493712344294181),
     FLO_FC9(116848.4002823586633895),  FLO_FC9(116873.0524936707224697),
     FLO_FC9(116897.7060050334839616),  FLO_FC9(116922.3608163098397199),
     FLO_FC9(116947.0169273627543589),  FLO_FC9(116971.6743380551779410),
     FLO_FC9(116996.3330482501332881),  FLO_FC9(117020.9930578106723260),
     FLO_FC9(117045.6543665998760844),  FLO_FC9(117070.3169744808546966),
     FLO_FC9(117094.9808813167765038),  FLO_FC9(117119.6460869708389509),
     FLO_FC9(117144.3125913062394829),  FLO_FC9(117168.9803941862919601),
     FLO_FC9(117193.6494954742520349),  FLO_FC9(117218.3198950334772235),
     FLO_FC9(117242.9915927273250418),  FLO_FC9(117267.6645884192257654),
     FLO_FC9(117292.3388819726242218),  FLO_FC9(117317.0144732509652385),
     FLO_FC9(117341.6913621177955065),  FLO_FC9(117366.3695484366617166),
     FLO_FC9(117391.0490320711542154),  FLO_FC9(117415.7298128848779015),
     FLO_FC9(117440.4118907415249851),  FLO_FC9(117465.0952655047440203),
     FLO_FC9(117489.7799370383145288),  FLO_FC9(117514.4659052059723763),
     FLO_FC9(117539.1531698715261882),  FLO_FC9(117563.8417308988282457),
     FLO_FC9(117588.5315881517308298),  FLO_FC9(117613.2227414941589814),
     FLO_FC9(117637.9151907900668448),  FLO_FC9(117662.6089359034085646),
     FLO_FC9(117687.3039766982110450),  FLO_FC9(117712.0003130385302939),
     FLO_FC9(117736.6979447884659749),  FLO_FC9(117761.3968718121177517),
     FLO_FC9(117786.0970939736725995),  FLO_FC9(117810.7986111373029416),
     FLO_FC9(117835.5014231672539609),  FLO_FC9(117860.2055299277708400),
     FLO_FC9(117884.9109312831860734),  FLO_FC9(117909.6176270978030516),
     FLO_FC9(117934.3256172360270284),  FLO_FC9(117959.0349015622487059),
     FLO_FC9(117983.7454799409169937),  FLO_FC9(118008.4573522365099052),
     FLO_FC9(118033.1705183135345578),  FLO_FC9(118057.8849780365562765),
     FLO_FC9(118082.6007312701403862),  FLO_FC9(118107.3177778789249714),
     FLO_FC9(118132.0361177275772206),  FLO_FC9(118156.7557506807643222),
     FLO_FC9(118181.4766766032116720),  FLO_FC9(118206.1988953597174259),
     FLO_FC9(118230.9224068150360836),  FLO_FC9(118255.6472108340385603),
     FLO_FC9(118280.3733072815666674),  FLO_FC9(118305.1006960225349758),
     FLO_FC9(118329.8293769218726084),  FLO_FC9(118354.5593498445814475),
     FLO_FC9(118379.2906146556488238),  FLO_FC9(118404.0231712201202754),
     FLO_FC9(118428.7570194030849962),  FLO_FC9(118453.4921590696467320),
     FLO_FC9(118478.2285900849819882),  FLO_FC9(118502.9663123142381664),
     FLO_FC9(118527.7053256226790836),  FLO_FC9(118552.4456298755249009),
     FLO_FC9(118577.1872249380830908),  FLO_FC9(118601.9301106756756781),
     FLO_FC9(118626.6742869536828948),  FLO_FC9(118651.4197536374704214),
     FLO_FC9(118676.1665105925058015),  FLO_FC9(118700.9145576842129230),
     FLO_FC9(118725.6638947781320894),  FLO_FC9(118750.4145217397890519),
     FLO_FC9(118775.1664384347532177),  FLO_FC9(118799.9196447286230978),
     FLO_FC9(118824.6741404870554106),  FLO_FC9(118849.4299255757359788),
     FLO_FC9(118874.1869998603506247),  FLO_FC9(118898.9453632066579303),
     FLO_FC9(118923.7050154804310296),  FLO_FC9(118948.4659565475158161),
     FLO_FC9(118973.2281862737436313),  FLO_FC9(118997.9917045249894727),
     FLO_FC9(119022.7565111672010971),  FLO_FC9(119047.5226060663262615),
     FLO_FC9(119072.2899890883418266),  FLO_FC9(119097.0586600992974127),
     FLO_FC9(119121.8286189652280882),  FLO_FC9(119146.5998655522562331),
     FLO_FC9(119171.3723997265042271),  FLO_FC9(119196.1462213541235542),
     FLO_FC9(119220.9213303013384575),  FLO_FC9(119245.6977264343586285),
     FLO_FC9(119270.4754096194665181),  FLO_FC9(119295.2543797229736811),
     FLO_FC9(119320.0346366112062242),  FLO_FC9(119344.8161801505484618),
     FLO_FC9(119369.5990102073992603),  FLO_FC9(119394.3831266482156934),
     FLO_FC9(119419.1685293394693872),  FLO_FC9(119443.9552181476610713),
     FLO_FC9(119468.7431929393496830),  FLO_FC9(119493.5324535811232636),
     FLO_FC9(119518.3229999395844061),  FLO_FC9(119543.1148318813939113),
     FLO_FC9(119567.9079492732416838),  FLO_FC9(119592.7023519818321802),
     FLO_FC9(119617.4980398739280645),  FLO_FC9(119642.2950128163211048),
     FLO_FC9(119667.0932706758321729),  FLO_FC9(119691.8928133193112444),
     FLO_FC9(119716.6936406136665028),  FLO_FC9(119741.4957524258352350),
     FLO_FC9(119766.2991486227401765),  FLO_FC9(119791.1038290714059258),
     FLO_FC9(119815.9097936388716334),  FLO_FC9(119840.7170421921764500),
     FLO_FC9(119865.5255745984322857),  FLO_FC9(119890.3353907247656025),
     FLO_FC9(119915.1464904383610701),  FLO_FC9(119939.9588736064179102),
     FLO_FC9(119964.7725400961498963),  FLO_FC9(119989.5874897748581134),
     FLO_FC9(120014.4037225098290946),  FLO_FC9(120039.2212381684075808),
     FLO_FC9(120064.0400366179674165),  FLO_FC9(120088.8601177259115502),
     FLO_FC9(120113.6814813597011380),  FLO_FC9(120138.5041273867827840),
     FLO_FC9(120163.3280556747049559),  FLO_FC9(120188.1532660909870174),
     FLO_FC9(120212.9797585032065399),  FLO_FC9(120237.8075327789993025),
     FLO_FC9(120262.6365887860010844),  FLO_FC9(120287.4669263918767683),
     FLO_FC9(120312.2985454643639969),  FLO_FC9(120337.1314458712149644),
     FLO_FC9(120361.9656274801964173),  FLO_FC9(120386.8010901591333095),
     FLO_FC9(120411.6378337758942507),  FLO_FC9(120436.4758581983478507),
     FLO_FC9(120461.3151632944209268),  FLO_FC9(120486.1557489320694003),
     FLO_FC9(120510.9976149792782962),  FLO_FC9(120535.8407613040617434),
     FLO_FC9(120560.6851877745066304),  FLO_FC9(120585.5308942586707417),
     FLO_FC9(120610.3778806246991735),  FLO_FC9(120635.2261467407370219),
     FLO_FC9(120660.0756924749875907),  FLO_FC9(120684.9265176956832875),
     FLO_FC9(120709.7786222710565198),  FLO_FC9(120734.6320060694415588),
     FLO_FC9(120759.4866689591290196),  FLO_FC9(120784.3426108084968291),
     FLO_FC9(120809.1998314859520178),  FLO_FC9(120834.0583308599161683),
     FLO_FC9(120858.9181087988399668),  FLO_FC9(120883.7791651712468592),
     FLO_FC9(120908.6414998456457397),  FLO_FC9(120933.5051126906037098),
     FLO_FC9(120958.3700035747315269),  FLO_FC9(120983.2361723666545004),
     FLO_FC9(121008.1036189350415953),  FLO_FC9(121032.9723431486054324),
     FLO_FC9(121057.8423448760586325),  FLO_FC9(121082.7136239861720242),
     FLO_FC9(121107.5861803477455396),  FLO_FC9(121132.4600138296373188),
     FLO_FC9(121157.3351243006909499),  FLO_FC9(121182.2115116298227804),
     FLO_FC9(121207.0891756859491579),  FLO_FC9(121231.9681163380737416),
     FLO_FC9(121256.8483334551710868),  FLO_FC9(121281.7298269062885083),
     FLO_FC9(121306.6125965604878729),  FLO_FC9(121331.4966422868892550),
     FLO_FC9(121356.3819639546127291),  FLO_FC9(121381.2685614328511292),
     FLO_FC9(121406.1564345907827374),  FLO_FC9(121431.0455832976731472),
     FLO_FC9(121455.9360074227588484),  FLO_FC9(121480.8277068353927461),
     FLO_FC9(121505.7206814048695378),  FLO_FC9(121530.6149310005712323),
     FLO_FC9(121555.5104554919234943),  FLO_FC9(121580.4072547483519884),
     FLO_FC9(121605.3053286393260350),  FLO_FC9(121630.2046770343586104),
     FLO_FC9(121655.1052998029917944),  FLO_FC9(121680.0071968147822190),
     FLO_FC9(121704.9103679393447237),  FLO_FC9(121729.8148130463232519),
     FLO_FC9(121754.7205320053908508),  FLO_FC9(121779.6275246862351196),
     FLO_FC9(121804.5357909586164169),  FLO_FC9(121829.4453306923096534),
     FLO_FC9(121854.3561437571042916),  FLO_FC9(121879.2682300228480017),
     FLO_FC9(121904.1815893594030058),  FLO_FC9(121929.0962216366897337),
     FLO_FC9(121954.0121267246431671),  FLO_FC9(121978.9293044932273915),
     FLO_FC9(122003.8477548124647001),  FLO_FC9(122028.7674775523773860),
     FLO_FC9(122053.6884725830313982),  FLO_FC9(122078.6107397745508933),
     FLO_FC9(122103.5342789970745798),  FLO_FC9(122128.4590901207557181),
     FLO_FC9(122153.3851730158057762),  FLO_FC9(122178.3125275524653262),
     FLO_FC9(122203.2411536009894917),  FLO_FC9(122228.1710510317207081),
     FLO_FC9(122253.1022197149432031),  FLO_FC9(122278.0346595210721716),
     FLO_FC9(122302.9683703204937046),  FLO_FC9(122327.9033519836229971),
     FLO_FC9(122352.8396043809625553),  FLO_FC9(122377.7771273830003338),
     FLO_FC9(122402.7159208602533909),  FLO_FC9(122427.6559846833260963),
     FLO_FC9(122452.5973187227791641),  FLO_FC9(122477.5399228492751718),
     FLO_FC9(122502.4837969334766967),  FLO_FC9(122527.4289408460608684),
     FLO_FC9(122552.3753544577921275),  FLO_FC9(122577.3230376394203631),
     FLO_FC9(122602.2719902617245680),  FLO_FC9(122627.2222121955710463),
     FLO_FC9(122652.1737033118115505),  FLO_FC9(122677.1264634813269367),
     FLO_FC9(122702.0804925750562688),  FLO_FC9(122727.0357904639677145),
     FLO_FC9(122751.9923570190585451),  FLO_FC9(122776.9501921113551361),
     FLO_FC9(122801.9092956118984148),  FLO_FC9(122826.8696673918020679),
     FLO_FC9(122851.8313073221943341),  FLO_FC9(122876.7942152742180042),
     FLO_FC9(122901.7583911190886283),  FLO_FC9(122926.7238347279926529),
     FLO_FC9(122951.6905459722329397),  FLO_FC9(122976.6585247230686946),
     FLO_FC9(123001.6277708518173313),  FLO_FC9(123026.5982842298690230),
     FLO_FC9(123051.5700647285702871),  FLO_FC9(123076.5431122193695046),
     FLO_FC9(123101.5174265737005044),  FLO_FC9(123126.4930076630698750),
     FLO_FC9(123151.4698553589842049),  FLO_FC9(123176.4479695329937385),
     FLO_FC9(123201.4273500566778239),  FLO_FC9(123226.4079968016594648),
     FLO_FC9(123251.3899096395907691),  FLO_FC9(123276.3730884421383962),
     FLO_FC9(123301.3575330810272135),  FLO_FC9(123326.3432434279966401),
     FLO_FC9(123351.3302193548297510),  FLO_FC9(123376.3184607333387248),
     FLO_FC9(123401.3079674353502924),  FLO_FC9(123426.2987393327639438),
     FLO_FC9(123451.2907762974791694),  FLO_FC9(123476.2840782014391152),
     FLO_FC9(123501.2786449166014791),  FLO_FC9(123526.2744763149821665),
     FLO_FC9(123551.2715722686261870),  FLO_FC9(123576.2699326495931018),
     FLO_FC9(123601.2695573299861280),  FLO_FC9(123626.2704461819521384),
     FLO_FC9(123651.2725990776380058),  FLO_FC9(123676.2760158892633626),
     FLO_FC9(123701.2806964890332893),  FLO_FC9(123726.2866407492401777),
     FLO_FC9(123751.2938485421764199),  FLO_FC9(123776.3023197401635116),
     FLO_FC9(123801.3120542155520525),  FLO_FC9(123826.3230518407508498),
     FLO_FC9(123851.3353124881687108),  FLO_FC9(123876.3488360302872024),
     FLO_FC9(123901.3636223395733396),  FLO_FC9(123926.3796712885523448),
     FLO_FC9(123951.3969827497930964),  FLO_FC9(123976.4155565958790248),
     FLO_FC9(124001.4353926994081121),  FLO_FC9(124026.4564909330511000),
     FLO_FC9(124051.4788511694787303),  FLO_FC9(124076.5024732814199524),
     FLO_FC9(124101.5273571416037157),  FLO_FC9(124126.5535026228171773),
     FLO_FC9(124151.5809095978765981),  FLO_FC9(124176.6095779396127909),
     FLO_FC9(124201.6395075209147763),  FLO_FC9(124226.6706982146715745),
     FLO_FC9(124251.7031498938449658),  FLO_FC9(124276.7368624313821783),
     FLO_FC9(124301.7718357003031997),  FLO_FC9(124326.8080695736425696),
     FLO_FC9(124351.8455639244639315),  FLO_FC9(124376.8843186258454807),
     FLO_FC9(124401.9243335509527242),  FLO_FC9(124426.9656085729220649),
     FLO_FC9(124452.0081435649772175),  FLO_FC9(124477.0519384003127925),
     FLO_FC9(124502.0969929521961603),  FLO_FC9(124527.1433070939237950),
     FLO_FC9(124552.1908806988212746),  FLO_FC9(124577.2397136402287288),
     FLO_FC9(124602.2898057915444952),  FLO_FC9(124627.3411570261814632),
     FLO_FC9(124652.3937672175961779),  FLO_FC9(124677.4476362392597366),
     FLO_FC9(124702.5027639646868920),  FLO_FC9(124727.5591502674215008),
     FLO_FC9(124752.6167950210365234),  FLO_FC9(124777.6756980991631281),
     FLO_FC9(124802.7358593754179310),  FLO_FC9(124827.7972787234757561),
     FLO_FC9(124852.8599560170405312),  FLO_FC9(124877.9238911298598396),
     FLO_FC9(124902.9890839356812648),  FLO_FC9(124928.0555343083105981),
     FLO_FC9(124953.1232421215972863),  FLO_FC9(124978.1922072493762244),
     FLO_FC9(125003.2624295655405149),  FLO_FC9(125028.3339089440414682),
     FLO_FC9(125053.4066452588158427),  FLO_FC9(125078.4806383838440524),
     FLO_FC9(125103.5558881931792712),  FLO_FC9(125128.6323945608310169),
     FLO_FC9(125153.7101573609106708),  FLO_FC9(125178.7891764675150625),
     FLO_FC9(125203.8694517548137810),  FLO_FC9(125228.9509830969618633),
     FLO_FC9(125254.0337703681725543),  FLO_FC9(125279.1178134427027544),
     FLO_FC9(125304.2031121947948122),  FLO_FC9(125329.2896664987783879),
     FLO_FC9(125354.3774762289831415),  FLO_FC9(125379.4665412597678369),
     FLO_FC9(125404.5568614655203419),  FLO_FC9(125429.6484367207012838),
     FLO_FC9(125454.7412668997421861),  FLO_FC9(125479.8353518771473318),
     FLO_FC9(125504.9306915274355561),  FLO_FC9(125530.0272857251693495),
     FLO_FC9(125555.1251343449257547),  FLO_FC9(125580.2242372613254702),
     FLO_FC9(125605.3245943490182981),  FLO_FC9(125630.4262054826976964),
     FLO_FC9(125655.5290705370425712),  FLO_FC9(125680.6331893868191401),
     FLO_FC9(125705.7385619067936204),  FLO_FC9(125730.8451879717758857),
     FLO_FC9(125755.9530674566049129),  FLO_FC9(125781.0622002361342311),
     FLO_FC9(125806.1725861852755770),  FLO_FC9(125831.2842251789552392),
     FLO_FC9(125856.3971170921286102),  FLO_FC9(125881.5112617998092901),
     FLO_FC9(125906.6266591769817751),  FLO_FC9(125931.7433090987469768),
     FLO_FC9(125956.8612114401621511),  FLO_FC9(125981.9803660763427615),
     FLO_FC9(126007.1007728824479273),  FLO_FC9(126032.2224317336513195),
     FLO_FC9(126057.3453425051702652),  FLO_FC9(126082.4695050722511951),
     FLO_FC9(126107.5949193101405399),  FLO_FC9(126132.7215850941720419),
     FLO_FC9(126157.8495022996648913),  FLO_FC9(126182.9786708019819343),
     FLO_FC9(126208.1090904765296727),  FLO_FC9(126233.2407611987146083),
     FLO_FC9(126258.3736828440305544),  FLO_FC9(126283.5078552879422205),
     FLO_FC9(126308.6432784059870755),  FLO_FC9(126333.7799520736880368),
     FLO_FC9(126358.9178761666698847),  FLO_FC9(126384.0570505604991922),
     FLO_FC9(126409.1974751308589475),  FLO_FC9(126434.3391497534030350),
     FLO_FC9(126459.4820743038580986),  FLO_FC9(126484.6262486579362303),
     FLO_FC9(126509.7716726914222818),  FLO_FC9(126534.9183462801011046),
     FLO_FC9(126560.0662692998157581),  FLO_FC9(126585.2154416264238534),
     FLO_FC9(126610.3658631358121056),  FLO_FC9(126635.5175337039254373),
     FLO_FC9(126660.6704532066796673),  FLO_FC9(126685.8246215200779261),
     FLO_FC9(126710.9800385201378958),  FLO_FC9(126736.1367040829063626),
     FLO_FC9(126761.2946180844446644),  FLO_FC9(126786.4537804008723469),
     FLO_FC9(126811.6141909083380597),  FLO_FC9(126836.7758494829759002),
     FLO_FC9(126861.9387560010218294),  FLO_FC9(126887.1029103386827046),
     FLO_FC9(126912.2683123722381424),  FLO_FC9(126937.4349619779532077),
     FLO_FC9(126962.6028590321657248),  FLO_FC9(126987.7720034112280700),
     FLO_FC9(127012.9423949915217236),  FLO_FC9(127038.1140336494718213),
     FLO_FC9(127063.2869192615034990),  FLO_FC9(127088.4610517040855484),
     FLO_FC9(127113.6364308537595207),  FLO_FC9(127138.8130565870233113),
     FLO_FC9(127163.9909287804766791),  FLO_FC9(127189.1700473106902791),
     FLO_FC9(127214.3504120542929741),  FLO_FC9(127239.5320228879718343),
     FLO_FC9(127264.7148796883848263),  FLO_FC9(127289.8989823322626762),
     FLO_FC9(127315.0843306963506620),  FLO_FC9(127340.2709246574377175),
     FLO_FC9(127365.4587640923418803),  FLO_FC9(127390.6478488778811879),
     FLO_FC9(127415.8381788909318857),  FLO_FC9(127441.0297540084138745),
     FLO_FC9(127466.2225741072470555),  FLO_FC9(127491.4166390643949853),
     FLO_FC9(127516.6119487568503246),  FLO_FC9(127541.8085030616493896),
     FLO_FC9(127567.0063018558284966),  FLO_FC9(127592.2053450164676178),
     FLO_FC9(127617.4056324207049329),  FLO_FC9(127642.6071639456786215),
     FLO_FC9(127667.8099394685559673),  FLO_FC9(127693.0139588665333577),
     FLO_FC9(127718.2192220168799395),  FLO_FC9(127743.4257287968212040),
     FLO_FC9(127768.6334790836845059),  FLO_FC9(127793.8424727547826478),
     FLO_FC9(127819.0527096874866402),  FLO_FC9(127844.2641897591674933),
     FLO_FC9(127869.4769128472398734),  FLO_FC9(127894.6908788291766541),
     FLO_FC9(127919.9060875824216055),  FLO_FC9(127945.1225389845203608),
     FLO_FC9(127970.3402329129748978),  FLO_FC9(127995.5591692453745054),
     FLO_FC9(128020.7793478593230247),  FLO_FC9(128046.0007686324388487),
     FLO_FC9(128071.2234314423694741),  FLO_FC9(128096.4473361668351572),
     FLO_FC9(128121.6724826835270505),  FLO_FC9(128146.8988708702090662),
     FLO_FC9(128172.1265006046451163),  FLO_FC9(128197.3553717646718724),
     FLO_FC9(128222.5854842280969024),  FLO_FC9(128247.8168378728150856),
     FLO_FC9(128273.0494325767067494),  FLO_FC9(128298.2832682177104289),
     FLO_FC9(128323.5183446737937629),  FLO_FC9(128348.7546618229389424),
     FLO_FC9(128373.9922195431572618),  FLO_FC9(128399.2310177125182236),
     FLO_FC9(128424.4710562090913299),  FLO_FC9(128449.7123349109751871),
     FLO_FC9(128474.9548536963120569),  FLO_FC9(128500.1986124432878569),
     FLO_FC9(128525.4436110300885048),  FLO_FC9(128550.6898493349435739),
     FLO_FC9(128575.9373272361262934),  FLO_FC9(128601.1860446119098924),
     FLO_FC9(128626.4360013406112557),  FLO_FC9(128651.6871973005909240),
     FLO_FC9(128676.9396323702094378),  FLO_FC9(128702.1933064279000973),
     FLO_FC9(128727.4482193520816509),  FLO_FC9(128752.7043710212456062),
     FLO_FC9(128777.9617613138543675),  FLO_FC9(128803.2203901084576501),
     FLO_FC9(128828.4802572836197214),  FLO_FC9(128853.7413627179194009),
     FLO_FC9(128879.0037062899646116),  FLO_FC9(128904.2672878784069326),
     FLO_FC9(128929.5321073619270464),  FLO_FC9(128954.7981646192347398),
     FLO_FC9(128980.0654595290543512),  FLO_FC9(129005.3339919701538747),
     FLO_FC9(129030.6037618213449605),  FLO_FC9(129055.8747689614247065),
     FLO_FC9(129081.1470132692629704),  FLO_FC9(129106.4204946237587137),
     FLO_FC9(129131.6952129037963459),  FLO_FC9(129156.9711679883475881),
     FLO_FC9(129182.2483597563550575),  FLO_FC9(129207.5267880868486827),
     FLO_FC9(129232.8064528588438407),  FLO_FC9(129258.0873539514141157),
     FLO_FC9(129283.3694912436476443),  FLO_FC9(129308.6528646146616666),
     FLO_FC9(129333.9374739436025266),  FLO_FC9(129359.2233191096602241),
     FLO_FC9(129384.5103999920247588),  FLO_FC9(129409.7987164699734421),
     FLO_FC9(129435.0882684227399295),  FLO_FC9(129460.3790557296306361),
     FLO_FC9(129485.6710782699810807),  FLO_FC9(129510.9643359231413342),
     FLO_FC9(129536.2588285685051233),  FLO_FC9(129561.5545560854807263),
     FLO_FC9(129586.8515183535200777),  FLO_FC9(129612.1497152520896634),
     FLO_FC9(129637.4491466606996255),  FLO_FC9(129662.7498124588746578),
     FLO_FC9(129688.0517125261976616),  FLO_FC9(129713.3548467422369868),
     FLO_FC9(129738.6592149866337422),  FLO_FC9(129763.9648171390290372),
     FLO_FC9(129789.2716530790930847),  FLO_FC9(129814.5797226865543053),
     FLO_FC9(129839.8890258411556715),  FLO_FC9(129865.1995624226401560),
     FLO_FC9(129890.5113323108234908),  FLO_FC9(129915.8243353855359601),
     FLO_FC9(129941.1385715266223997),  FLO_FC9(129966.4540406139713014),
     FLO_FC9(129991.7707425275002606),  FLO_FC9(130017.0886771471559769),
     FLO_FC9(130042.4078443528997013),  FLO_FC9(130067.7282440247363411),
     FLO_FC9(130093.0498760427144589),  FLO_FC9(130118.3727402868680656),
     FLO_FC9(130143.6968366373184836),  FLO_FC9(130169.0221649741579313),
     FLO_FC9(130194.3487251775513869),  FLO_FC9(130219.6765171276638284),
     FLO_FC9(130245.0055407047038898),  FLO_FC9(130270.3357957889093086),
     FLO_FC9(130295.6672822605469264),  FLO_FC9(130320.9999999999126885),
     FLO_FC9(130346.3339488873316441),  FLO_FC9(130371.6691288031433942),
     FLO_FC9(130397.0055396277311957),  FLO_FC9(130422.3431812415219611),
     FLO_FC9(130447.6820535249426030),  FLO_FC9(130473.0221563584491378),
     FLO_FC9(130498.3634896225557895),  FLO_FC9(130523.7060531977913342),
     FLO_FC9(130549.0498469646990998),  FLO_FC9(130574.3948708038806217),
     FLO_FC9(130599.7411245959228836),  FLO_FC9(130625.0886082214856287),
     FLO_FC9(130650.4373215612286003),  FLO_FC9(130675.7872644958697492),
     FLO_FC9(130701.1384369061270263),  FLO_FC9(130726.4908386727474863),
     FLO_FC9(130751.8444696765363915),  FLO_FC9(130777.1993297983135562),
     FLO_FC9(130802.5554189188987948),  FLO_FC9(130827.9127369191846810),
     FLO_FC9(130853.2712836800637888),  FLO_FC9(130878.6310590824723477),
     FLO_FC9(130903.9920630073756911),  FLO_FC9(130929.3542953357537044),
     FLO_FC9(130954.7177559486153768),  FLO_FC9(130980.0824447270279052),
     FLO_FC9(131005.4483615520584863),  FLO_FC9(131030.8155063048179727),
     FLO_FC9(131056.1838788664172171),  FLO_FC9(131081.5534791180398315),
     FLO_FC9(131106.9243069408694282),  FLO_FC9(131132.2963622161187232),
     FLO_FC9(131157.6696448250440881),  FLO_FC9(131183.0441546489018947),
     FLO_FC9(131208.4198915690358263),  FLO_FC9(131233.7968554667604621),
     FLO_FC9(131259.1750462234194856),  FLO_FC9(131284.5544637204147875),
     FLO_FC9(131309.9351078391773626),  FLO_FC9(131335.3169784611673094),
     FLO_FC9(131360.7000754678447265),  FLO_FC9(131386.0843987406988163),
     FLO_FC9(131411.4699481612769887),  FLO_FC9(131436.8567236111557577),
     FLO_FC9(131462.2447249719407409),  FLO_FC9(131487.6339521252084523),
     FLO_FC9(131513.0244049526227172),  FLO_FC9(131538.4160833358764648),
     FLO_FC9(131563.8089871566335205),  FLO_FC9(131589.2031162967032287),
     FLO_FC9(131614.5984706377785187),  FLO_FC9(131639.9950500616978388),
     FLO_FC9(131665.3928544502414297),  FLO_FC9(131690.7918836853059474),
     FLO_FC9(131716.1921376487298403),  FLO_FC9(131741.5936162224097643),
     FLO_FC9(131766.9963192883005831),  FLO_FC9(131792.4002467283862643),
     FLO_FC9(131817.8053984246216714),  FLO_FC9(131843.2117742590489797),
     FLO_FC9(131868.6193741137103643),  FLO_FC9(131894.0281978706480004),
     FLO_FC9(131919.4382454120204784),  FLO_FC9(131944.8495166199281812),
     FLO_FC9(131970.2620113765588030),  FLO_FC9(131995.6757295640709344),
     FLO_FC9(132021.0906710646813735),  FLO_FC9(132046.5068357606651261),
     FLO_FC9(132071.9242235342971981),  FLO_FC9(132097.3428342678234912),
     FLO_FC9(132122.7626678436645307),  FLO_FC9(132148.1837241440953221),
     FLO_FC9(132173.6060030515654944),  FLO_FC9(132199.0295044484664686),
     FLO_FC9(132224.4542282172187697),  FLO_FC9(132249.8801742403593380),
     FLO_FC9(132275.3073424003086984),  FLO_FC9(132300.7357325796619989),
     FLO_FC9(132326.1653446609561797),  FLO_FC9(132351.5961785267572850),
     FLO_FC9(132377.0282340596895665),  FLO_FC9(132402.4615111424354836),
     FLO_FC9(132427.8960096575901844),  FLO_FC9(132453.3317294878943358),
     FLO_FC9(132478.7686705160886049),  FLO_FC9(132504.2068326249136589),
     FLO_FC9(132529.6462156971392687),  FLO_FC9(132555.0868196155934129),
     FLO_FC9(132580.5286442631040700),  FLO_FC9(132605.9716895225283224),
     FLO_FC9(132631.4159552767814603),  FLO_FC9(132656.8614414088078775),
     FLO_FC9(132682.3081478014937602),  FLO_FC9(132707.7560743378708139),
     FLO_FC9(132733.2052209009416401),  FLO_FC9(132758.6555873737379443),
     FLO_FC9(132784.1071736392914318),  FLO_FC9(132809.5599795807502232),
     FLO_FC9(132835.0140050811751280),  FLO_FC9(132860.4692500237724744),
     FLO_FC9(132885.9257142916612793),  FLO_FC9(132911.3833977681060787),
     FLO_FC9(132936.8423003362840973),  FLO_FC9(132962.3024218794598710),
     FLO_FC9(132987.7637622809561435),  FLO_FC9(133013.2263214240665548),
     FLO_FC9(133038.6900991921429522),  FLO_FC9(133064.1550954685371835),
     FLO_FC9(133089.6213101366593037),  FLO_FC9(133115.0887430799484719),
     FLO_FC9(133140.5573941818438470),  FLO_FC9(133166.0272633258136921),
     FLO_FC9(133191.4983503954135813),  FLO_FC9(133216.9706552741408814),
     FLO_FC9(133242.4441778456093743),  FLO_FC9(133267.9189179933455307),
     FLO_FC9(133293.3948756010213401),  FLO_FC9(133318.8720505522796884),
     FLO_FC9(133344.3504427307925653),  FLO_FC9(133369.8300520202319603),
     FLO_FC9(133395.3108783043862786),  FLO_FC9(133420.7929214670148212),
     FLO_FC9(133446.2761813918477856),  FLO_FC9(133471.7606579627608880),
     FLO_FC9(133497.2463510635716375),  FLO_FC9(133522.7332605781557504),
     FLO_FC9(133548.2213863903889433),  FLO_FC9(133573.7107283842633478),
     FLO_FC9(133599.2012864436546806),  FLO_FC9(133624.6930604526132811),
     FLO_FC9(133650.1860502951021772),  FLO_FC9(133675.6802558551717084),
     FLO_FC9(133701.1756770169013180),  FLO_FC9(133726.6723136643704493),
     FLO_FC9(133752.1701656817167532),  FLO_FC9(133777.6692329530487768),
     FLO_FC9(133803.1695153625914827),  FLO_FC9(133828.6710127945407294),
     FLO_FC9(133854.1737251330923755),  FLO_FC9(133879.6776522625295911),
     FLO_FC9(133905.1827940671355464),  FLO_FC9(133930.6891504312516190),
     FLO_FC9(133956.1967212391609792),  FLO_FC9(133981.7055063752632122),
     FLO_FC9(134007.2155057239870075),  FLO_FC9(134032.7267191697028466),
     FLO_FC9(134058.2391465968976263),  FLO_FC9(134083.7527878900000360),
     FLO_FC9(134109.2676429335842840),  FLO_FC9(134134.7837116121663712),
     FLO_FC9(134160.3009938102622982),  FLO_FC9(134185.8194894125044812),
     FLO_FC9(134211.3391983035253361),  FLO_FC9(134236.8601203678990714),
     FLO_FC9(134262.3822554903745186),  FLO_FC9(134287.9056035555840936),
     FLO_FC9(134313.4301644483057316),  FLO_FC9(134338.9559380532591604),
     FLO_FC9(134364.4829242552514188),  FLO_FC9(134390.0111229390895460),
     FLO_FC9(134415.5405339895514771),  FLO_FC9(134441.0711572915897705),
     FLO_FC9(134466.6029927300114650),  FLO_FC9(134492.1360401897982229),
     FLO_FC9(134517.6702995558443945),  FLO_FC9(134543.2057707131607458),
     FLO_FC9(134568.7424535467580426),  FLO_FC9(134594.2803479415888432),
     FLO_FC9(134619.8194537827803288),  FLO_FC9(134645.3597709553723689),
     FLO_FC9(134670.9012993445212487),  FLO_FC9(134696.4440388352959417),
     FLO_FC9(134721.9879893129109405),  FLO_FC9(134747.5331506625225302),
     FLO_FC9(134773.0795227693743072),  FLO_FC9(134798.6271055187098682),
     FLO_FC9(134824.1758987957728095),  FLO_FC9(134849.7259024858940393),
     FLO_FC9(134875.2771164743753616),  FLO_FC9(134900.8295406466058921),
     FLO_FC9(134926.3831748879165389),  FLO_FC9(134951.9380190837255213),
     FLO_FC9(134977.4940731195092667),  FLO_FC9(135003.0513368806859944),
     FLO_FC9(135028.6098102527612355),  FLO_FC9(135054.1694931212696247),
     FLO_FC9(135079.7303853717166930),  FLO_FC9(135105.2924868896661792),
     FLO_FC9(135130.8557975607691333),  FLO_FC9(135156.4203172706183977),
     FLO_FC9(135181.9860459048359189),  FLO_FC9(135207.5529833491600584),
     FLO_FC9(135233.1211294892418664),  FLO_FC9(135258.6904842108779121),
     FLO_FC9(135284.2610473997483496),  FLO_FC9(135309.8328189416788518),
     FLO_FC9(135335.4057987224950921),  FLO_FC9(135360.9799866280227434),
     FLO_FC9(135386.5553825441165827),  FLO_FC9(135412.1319863566895947),
     FLO_FC9(135437.7097979516838677),  FLO_FC9(135463.2888172149832826),
     FLO_FC9(135488.8690440326172393),  FLO_FC9(135514.4504782905569300),
     FLO_FC9(135540.0331198748608585),  FLO_FC9(135565.6169686715584248),
     FLO_FC9(135591.2020245667663403),  FLO_FC9(135616.7882874465431087),
     FLO_FC9(135642.3757571970636491),  FLO_FC9(135667.9644337044737767),
     FLO_FC9(135693.5543168549775146),  FLO_FC9(135719.1454065347497817),
     FLO_FC9(135744.7377026301110163),  FLO_FC9(135770.3312050272652414),
     FLO_FC9(135795.9259136125328951),  FLO_FC9(135821.5218282722344156),
     FLO_FC9(135847.1189488927193452),  FLO_FC9(135872.7172753603954334),
     FLO_FC9(135898.3168075616122223),  FLO_FC9(135923.9175453828356694),
     FLO_FC9(135949.5194887105317321),  FLO_FC9(135975.1226374311372638),
     FLO_FC9(136000.7269914312346373),  FLO_FC9(136026.3325505972898100),
     FLO_FC9(136051.9393148159142584),  FLO_FC9(136077.5472839736903552),
     FLO_FC9(136103.1564579572295770),  FLO_FC9(136128.7668366531725042),
     FLO_FC9(136154.3784199482179247),  FLO_FC9(136179.9912077290064190),
     FLO_FC9(136205.6051998823240865),  FLO_FC9(136231.2203962948988192),
     FLO_FC9(136256.8367968534876127),  FLO_FC9(136282.4544014449347742),
     FLO_FC9(136308.0732099560264032),  FLO_FC9(136333.6932222736650147),
     FLO_FC9(136359.3144382846949156),  FLO_FC9(136384.9368578760768287),
     FLO_FC9(136410.5604809346841648),  FLO_FC9(136436.1853073475358542),
     FLO_FC9(136461.8113370015635155),  FLO_FC9(136487.4385697838442866),
     FLO_FC9(136513.0670055814262014),  FLO_FC9(136538.6966442812990863),
     FLO_FC9(136564.3274857706564944),  FLO_FC9(136589.9595299365464598),
     FLO_FC9(136615.5927766661625355),  FLO_FC9(136641.2272258466691710),
     FLO_FC9(136666.8628773652308155),  FLO_FC9(136692.4997311091574375),
     FLO_FC9(136718.1377869656425901),  FLO_FC9(136743.7770448219671380),
     FLO_FC9(136769.4175045654701535),  FLO_FC9(136795.0591660834616050),
     FLO_FC9(136820.7020292633096687),  FLO_FC9(136846.3460939924407285),
     FLO_FC9(136871.9913601581938565),  FLO_FC9(136897.6378276480536442),
     FLO_FC9(136923.2854963494755793),  FLO_FC9(136948.9343661499733571),
     FLO_FC9(136974.5844369370606728),  FLO_FC9(137000.2357085982512217),
     FLO_FC9(137025.8881810211460106),  FLO_FC9(137051.5418540933169425),
     FLO_FC9(137077.1967277024232317),  FLO_FC9(137102.8528017360949889),
     FLO_FC9(137128.5100760820205323),  FLO_FC9(137154.1685506278590765),
     FLO_FC9(137179.8282252614153549),  FLO_FC9(137205.4890998704067897),
     FLO_FC9(137231.1511743425799068),  FLO_FC9(137256.8144485657976475),
     FLO_FC9(137282.4789224278938491),  FLO_FC9(137308.1445958166732453),
     FLO_FC9(137333.8114686200860888),  FLO_FC9(137359.4795407260244247),
     FLO_FC9(137385.1488120224094018),  FLO_FC9(137410.8192823971912730),
     FLO_FC9(137436.4909517384367064),  FLO_FC9(137462.1638199340668507),
     FLO_FC9(137487.8378868722065818),  FLO_FC9(137513.5131524408934638),
     FLO_FC9(137539.1896165282232687),  FLO_FC9(137564.8672790222917683),
     FLO_FC9(137590.5461398113111500),  FLO_FC9(137616.2261987833771855),
     FLO_FC9(137641.9074558267602697),  FLO_FC9(137667.5899108296725899),
     FLO_FC9(137693.2735636803263333),  FLO_FC9(137718.9584142670209985),
     FLO_FC9(137744.6444624780851882),  FLO_FC9(137770.3317082018184010),
     FLO_FC9(137796.0201513266074471),  FLO_FC9(137821.7097917408100329),
     FLO_FC9(137847.4006293328420725),  FLO_FC9(137873.0926639911485836),
     FLO_FC9(137898.7858956041745842),  FLO_FC9(137924.4803240604232997),
     FLO_FC9(137950.1759492483688518),  FLO_FC9(137975.8727710566017777),
     FLO_FC9(138001.5707893736544065),  FLO_FC9(138027.2700040881463792),
     FLO_FC9(138052.9704150886391290),  FLO_FC9(138078.6720222638396081),
     FLO_FC9(138104.3748255023965612),  FLO_FC9(138130.0788246929587331),
     FLO_FC9(138155.7840197243203875),  FLO_FC9(138181.4904104851593729),
     FLO_FC9(138207.1979968642990571),  FLO_FC9(138232.9067787505045999),
     FLO_FC9(138258.6167560326284729),  FLO_FC9(138284.3279285994940437),
     FLO_FC9(138310.0402963399537839),  FLO_FC9(138335.7538591429765802),
     FLO_FC9(138361.4686168974440079),  FLO_FC9(138387.1845694923249539),
     FLO_FC9(138412.9017168165883049),  FLO_FC9(138438.6200587592320517),
     FLO_FC9(138464.3395952093123924),  FLO_FC9(138490.0603260558564216),
     FLO_FC9(138515.7822511879785452),  FLO_FC9(138541.5053704947349615),
     FLO_FC9(138567.2296838652982842),  FLO_FC9(138592.9551911888411269),
     FLO_FC9(138618.6818923545069993),  FLO_FC9(138644.4097872515267227),
     FLO_FC9(138670.1388757691311184),  FLO_FC9(138695.8691577965801116),
     FLO_FC9(138721.6006332231627312),  FLO_FC9(138747.3333019382262137),
     FLO_FC9(138773.0671638310595881),  FLO_FC9(138798.8022187910391949),
     FLO_FC9(138824.5384667075704783),  FLO_FC9(138850.2759074700588826),
     FLO_FC9(138876.0145409679389559),  FLO_FC9(138901.7543670907034539),
     FLO_FC9(138927.4953857278160285),  FLO_FC9(138953.2375967687985394),
     FLO_FC9(138978.9810001032019500),  FLO_FC9(139004.7255956206063274),
     FLO_FC9(139030.4713832105917390),  FLO_FC9(139056.2183627627964597),
     FLO_FC9(139081.9665341668296605),  FLO_FC9(139107.7158973123878241),
     FLO_FC9(139133.4664520891674329),  FLO_FC9(139159.2181983868940733),
     FLO_FC9(139184.9711360953224357),  FLO_FC9(139210.7252651042072102),
     FLO_FC9(139236.4805853033612948),  FLO_FC9(139262.2370965825684834),
     FLO_FC9(139287.9947988317580894),  FLO_FC9(139313.7536919407139067),
     FLO_FC9(139339.5137757994234562),  FLO_FC9(139365.2750502977578435),
     FLO_FC9(139391.0375153256754857),  FLO_FC9(139416.8011707731639035),
     FLO_FC9(139442.5660165302397218),  FLO_FC9(139468.3320524868904613),
     FLO_FC9(139494.0992785332200583),  FLO_FC9(139519.8676945592742413),
     FLO_FC9(139545.6373004551569466),  FLO_FC9(139571.4080961110012140),
     FLO_FC9(139597.1800814169691876),  FLO_FC9(139622.9532562632230110),
     FLO_FC9(139648.7276205400121398),  FLO_FC9(139674.5031741374987178),
     FLO_FC9(139700.2799169460195117),  FLO_FC9(139726.0578488557948731),
     FLO_FC9(139751.8369697571324650),  FLO_FC9(139777.6172795404272620),
     FLO_FC9(139803.3987780959578231),  FLO_FC9(139829.1814653141482268),
     FLO_FC9(139854.9653410853934474),  FLO_FC9(139880.7504053001466673),
     FLO_FC9(139906.5366578488610685),  FLO_FC9(139932.3240986219898332),
     FLO_FC9(139958.1127275100734551),  FLO_FC9(139983.9025444036524277),
     FLO_FC9(140009.6935491932672448),  FLO_FC9(140035.4857417694875039),
     FLO_FC9(140061.2791220229410101),  FLO_FC9(140087.0736898442846723),
     FLO_FC9(140112.8694451241462957),  FLO_FC9(140138.6663877532118931),
     FLO_FC9(140164.4645176221965812),  FLO_FC9(140190.2638346218445804),
     FLO_FC9(140216.0643386429292150),  FLO_FC9(140241.8660295762238093),
     FLO_FC9(140267.6689073125307914),  FLO_FC9(140293.4729717426816933),
     FLO_FC9(140319.2782227575371508),  FLO_FC9(140345.0846602480160072),
     FLO_FC9(140370.8922841049788985),  FLO_FC9(140396.7010942194319796),
     FLO_FC9(140422.5110904822649900),  FLO_FC9(140448.3222727844840847),
     FLO_FC9(140474.1346410171245225),  FLO_FC9(140499.9481950712215621),
     FLO_FC9(140525.7629348378104623),  FLO_FC9(140551.5788602080137935),
     FLO_FC9(140577.3959710728959180),  FLO_FC9(140603.2142673236376140),
     FLO_FC9(140629.0337488513614517),  FLO_FC9(140654.8544155473064166),
     FLO_FC9(140680.6762673026241828),  FLO_FC9(140706.4993040085828397),
     FLO_FC9(140732.3235255564504769),  FLO_FC9(140758.1489318374951836),
     FLO_FC9(140783.9755227430432569),  FLO_FC9(140809.8032981644209940),
     FLO_FC9(140835.6322579929837957),  FLO_FC9(140861.4624021201452706),
     FLO_FC9(140887.2937304372899234),  FLO_FC9(140913.1262428358604666),
     FLO_FC9(140938.9599392073287163),  FLO_FC9(140964.7948194431664888),
     FLO_FC9(140990.6308834348747041),  FLO_FC9(141016.4681310740124900),
     FLO_FC9(141042.3065622521389741),  FLO_FC9(141068.1461768608132843),
     FLO_FC9(141093.9869747916818596),  FLO_FC9(141119.8289559363620356),
     FLO_FC9(141145.6721201865002513),  FLO_FC9(141171.5164674337720498),
     FLO_FC9(141197.3619975699402858),  FLO_FC9(141223.2087104866805021),
     FLO_FC9(141249.0566060757846572),  FLO_FC9(141274.9056842290447094),
     FLO_FC9(141300.7559448382235132),  FLO_FC9(141326.6073877952003386),
     FLO_FC9(141352.4600129917962477),  FLO_FC9(141378.3138203199196141),
     FLO_FC9(141404.1688096714788117),  FLO_FC9(141430.0249809383822139),
     FLO_FC9(141455.8823340125964023),  FLO_FC9(141481.7408687861170620),
     FLO_FC9(141507.6005851509398781),  FLO_FC9(141533.4614829990896396),
     FLO_FC9(141559.3235622226493433),  FLO_FC9(141585.1868227136437781),
     FLO_FC9(141611.0512643642141484),  FLO_FC9(141636.9168870665016584),
     FLO_FC9(141662.7836907126184087),  FLO_FC9(141688.6516751947929151),
     FLO_FC9(141714.5208404051954858),  FLO_FC9(141740.3911862360546365),
     FLO_FC9(141766.2627125796279870),  FLO_FC9(141792.1354193282022607),
     FLO_FC9(141818.0093063740641810),  FLO_FC9(141843.8843736095586792),
     FLO_FC9(141869.7606209270015825),  FLO_FC9(141895.6380482187960297),
     FLO_FC9(141921.5166553773451596),  FLO_FC9(141947.3964422950521111),
     FLO_FC9(141973.2774088643782306),  FLO_FC9(141999.1595549777848646),
     FLO_FC9(142025.0428805277624633),  FLO_FC9(142050.9273854068887886),
     FLO_FC9(142076.8130695076542906),  FLO_FC9(142102.6999327226367313),
     FLO_FC9(142128.5879749444429763),  FLO_FC9(142154.4771960657089949),
     FLO_FC9(142180.3675959790416528),  FLO_FC9(142206.2591745771351270),
     FLO_FC9(142232.1519317526544910),  FLO_FC9(142258.0458673983812332),
     FLO_FC9(142283.9409814069804270),  FLO_FC9(142309.8372736712626647),
     FLO_FC9(142335.7347440840094350),  FLO_FC9(142361.6333925380604342),
     FLO_FC9(142387.5332189261971507),  FLO_FC9(142413.4342231413174886),
     FLO_FC9(142439.3364050763484556),  FLO_FC9(142465.2397646241297480),
     FLO_FC9(142491.1443016776465811),  FLO_FC9(142517.0500161298259627),
     FLO_FC9(142542.9569078736822121),  FLO_FC9(142568.8649768022296485),
     FLO_FC9(142594.7742228084825911),  FLO_FC9(142620.6846457855135668),
     FLO_FC9(142646.5962456263659988),  FLO_FC9(142672.5090222242288291),
     FLO_FC9(142698.4229754721454810),  FLO_FC9(142724.3381052633340005),
     FLO_FC9(142750.2544114909251221),  FLO_FC9(142776.1718940481659956),
     FLO_FC9(142802.0905528282746673),  FLO_FC9(142828.0103877244691830),
     FLO_FC9(142853.9313986300840043),  FLO_FC9(142879.8535854383662809),
     FLO_FC9(142905.7769480426795781),  FLO_FC9(142931.7014863363583572),
     FLO_FC9(142957.6272002127661835),  FLO_FC9(142983.5540895653248299),
     FLO_FC9(143009.4821542874269653),  FLO_FC9(143035.4113942725525703),
     FLO_FC9(143061.3418094141525216),  FLO_FC9(143087.2733996057067998),
     FLO_FC9(143113.2061647407535929),  FLO_FC9(143139.1401047128310893),
     FLO_FC9(143165.0752194155065808),  FLO_FC9(143191.0115087423764635),
     FLO_FC9(143216.9489725870371331),  FLO_FC9(143242.8876108431431931),
     FLO_FC9(143268.8274234043492470),  FLO_FC9(143294.7684101643681061),
     FLO_FC9(143320.7105710168834776),  FLO_FC9(143346.6539058556372765),
     FLO_FC9(143372.5984145743714180),  FLO_FC9(143398.5440970669151284),
     FLO_FC9(143424.4909532270103227),  FLO_FC9(143450.4389829485735390),
     FLO_FC9(143476.3881861253757961),  FLO_FC9(143502.3385626513336319),
     FLO_FC9(143528.2901124203635845),  FLO_FC9(143554.2428353263821919),
     FLO_FC9(143580.1967312633350957),  FLO_FC9(143606.1518001251970418),
     FLO_FC9(143632.1080418059718795),  FLO_FC9(143658.0654561996925622),
     FLO_FC9(143684.0240432003920432),  FLO_FC9(143709.9838027021323796),
     FLO_FC9(143735.9447345990047324),  FLO_FC9(143761.9068387851875741),
     FLO_FC9(143787.8701151547429617),  FLO_FC9(143813.8345636018784717),
     FLO_FC9(143839.8001840208016802),  FLO_FC9(143865.7669763056910597),
     FLO_FC9(143891.7349403508123942),  FLO_FC9(143917.7040760504023638),
     FLO_FC9(143943.6743832987558562),  FLO_FC9(143969.6458619901968632),
     FLO_FC9(143995.6185120190493762),  FLO_FC9(144021.5923332796664909),
     FLO_FC9(144047.5673256664595101),  FLO_FC9(144073.5434890737815294),
     FLO_FC9(144099.5208233960729558),  FLO_FC9(144125.4993285278324038),
     FLO_FC9(144151.4790043635002803),  FLO_FC9(144177.4598507975752000),
     FLO_FC9(144203.4418677245848812),  FLO_FC9(144229.4250550390861463),
     FLO_FC9(144255.4094126356358174),  FLO_FC9(144281.3949404088489246),
     FLO_FC9(144307.3816382533113938),  FLO_FC9(144333.3695060637255665),
     FLO_FC9(144359.3585437346773688),  FLO_FC9(144385.3487511609273497),
     FLO_FC9(144411.3401282371778507),  FLO_FC9(144437.3326748581312131),
     FLO_FC9(144463.3263909185479861),  FLO_FC9(144489.3212763132469263),
     FLO_FC9(144515.3173309370467905),  FLO_FC9(144541.3145546847372316),
     FLO_FC9(144567.3129474511952139),  FLO_FC9(144593.3125091312977020),
     FLO_FC9(144619.3132396199507639),  FLO_FC9(144645.3151388120604679),
     FLO_FC9(144671.3182066026201937),  FLO_FC9(144697.3224428865651134),
     FLO_FC9(144723.3278475588886067),  FLO_FC9(144749.3344205146713648),
     FLO_FC9(144775.3421616488776635),  FLO_FC9(144801.3510708566464018),
     FLO_FC9(144827.3611480330291670),  FLO_FC9(144853.3723930731357541),
     FLO_FC9(144879.3848058721341658),  FLO_FC9(144905.3983863251633011),
     FLO_FC9(144931.4131343274202663),  FLO_FC9(144957.4290497741021682),
     FLO_FC9(144983.4461325604643207),  FLO_FC9(145009.4643825817329343),
     FLO_FC9(145035.4837997332215309),  FLO_FC9(145061.5043839102145284),
     FLO_FC9(145087.5261350080545526),  FLO_FC9(145113.5490529220842291),
     FLO_FC9(145139.5731375476461835),  FLO_FC9(145165.5983887801703531),
     FLO_FC9(145191.6248065150866751),  FLO_FC9(145217.6523906478250865),
     FLO_FC9(145243.6811410738446284),  FLO_FC9(145269.7110576886334457),
     FLO_FC9(145295.7421403877378907),  FLO_FC9(145321.7743890666752122),
     FLO_FC9(145347.8078036209917627),  FLO_FC9(145373.8423839462921023),
     FLO_FC9(145399.8781299381807912),  FLO_FC9(145425.9150414922914933),
     FLO_FC9(145451.9531185042578727),  FLO_FC9(145477.9923608698009048),
     FLO_FC9(145504.0327684845833573),  FLO_FC9(145530.0743412443553098),
     FLO_FC9(145556.1170790448377375),  FLO_FC9(145582.1609817818098236),
     FLO_FC9(145608.2060493510798551),  FLO_FC9(145634.2522816484852228),
     FLO_FC9(145660.2996785698051099),  FLO_FC9(145686.3482400109642185),
     FLO_FC9(145712.3979658678290434),  FLO_FC9(145738.4488560362951830),
     FLO_FC9(145764.5009104123164434),  FLO_FC9(145790.5541288918466307),
     FLO_FC9(145816.6085113708686549),  FLO_FC9(145842.6640577453654259),
     FLO_FC9(145868.7207679114071652),  FLO_FC9(145894.7786417650058866),
     FLO_FC9(145920.8376792022609152),  FLO_FC9(145946.8978801192424726),
     FLO_FC9(145972.9592444120789878),  FLO_FC9(145999.0217719769279938),
     FLO_FC9(146025.0854627099470235),  FLO_FC9(146051.1503165073227137),
     FLO_FC9(146077.2163332652708050),  FLO_FC9(146103.2835128800361417),
     FLO_FC9(146129.3518552478926722),  FLO_FC9(146155.4213602650561370),
     FLO_FC9(146181.4920278279168997),  FLO_FC9(146207.5638578327198047),
     FLO_FC9(146233.6368501758843195),  FLO_FC9(146259.7110047537717037),
     FLO_FC9(146285.7863214627432171),  FLO_FC9(146311.8628001992765348),
     FLO_FC9(146337.9404408597620204),  FLO_FC9(146364.0192433407064527),
     FLO_FC9(146390.0992075385584030),  FLO_FC9(146416.1803333498537540),
     FLO_FC9(146442.2626206711574923),  FLO_FC9(146468.3460693989763968),
     FLO_FC9(146494.4306794299336616),  FLO_FC9(146520.5164506606233772),
     FLO_FC9(146546.6033829876396339),  FLO_FC9(146572.6914763076929376),
     FLO_FC9(146598.7807305174064822),  FLO_FC9(146624.8711455135198776),
     FLO_FC9(146650.9627211927436292),  FLO_FC9(146677.0554574517882429),
     FLO_FC9(146703.1493541874515358),  FLO_FC9(146729.2444112965022214),
     FLO_FC9(146755.3406286757672206),  FLO_FC9(146781.4380062220734544),
     FLO_FC9(146807.5365438322769478),  FLO_FC9(146833.6362414032919332),
     FLO_FC9(146859.7370988319744356),  FLO_FC9(146885.8391160152677912),
     FLO_FC9(146911.9422928501444403),  FLO_FC9(146938.0466292335477192),
     FLO_FC9(146964.1521250624791719),  FLO_FC9(146990.2587802339694463),
     FLO_FC9(147016.3665946450491901),  FLO_FC9(147042.4755681928072590),
     FLO_FC9(147068.5857007742743008),  FLO_FC9(147094.6969922865973786),
     FLO_FC9(147120.8094426269235555),  FLO_FC9(147146.9230516923707910),
     FLO_FC9(147173.0378193801443558),  FLO_FC9(147199.1537455874495208),
     FLO_FC9(147225.2708302114915568),  FLO_FC9(147251.3890731495339423),
     FLO_FC9(147277.5084742988110520),  FLO_FC9(147303.6290335566445719),
     FLO_FC9(147329.7507508203561883),  FLO_FC9(147355.8736259872675873),
     FLO_FC9(147381.9976589547295589),  FLO_FC9(147408.1228496201511007),
     FLO_FC9(147434.2491978809121065),  FLO_FC9(147460.3767036344797816),
     FLO_FC9(147486.5053667782631237),  FLO_FC9(147512.6351872097584419),
     FLO_FC9(147538.7661648264620453),  FLO_FC9(147564.8982995258702431),
     FLO_FC9(147591.0315912055666558),  FLO_FC9(147617.1660397630766965),
     FLO_FC9(147643.3016450960130896),  FLO_FC9(147669.4384071019885596),
     FLO_FC9(147695.5763256785867270),  FLO_FC9(147721.7154007235367317),
     FLO_FC9(147747.8556321344512980),  FLO_FC9(147773.9970198090886697),
     FLO_FC9(147800.1395636451197788),  FLO_FC9(147826.2832635403319728),
     FLO_FC9(147852.4281193924834952),  FLO_FC9(147878.5741310993325897),
     FLO_FC9(147904.7212985587248113),  FLO_FC9(147930.8696216685057152),
     FLO_FC9(147957.0191003265208565),  FLO_FC9(147983.1697344306157902),
     FLO_FC9(148009.3215238787524868),  FLO_FC9(148035.4744685688347090),
     FLO_FC9(148061.6285683988244273),  FLO_FC9(148087.7838232666545082),
     FLO_FC9(148113.9402330703451298),  FLO_FC9(148140.0977977079164702),
     FLO_FC9(148166.2565170773887075),  FLO_FC9(148192.4163910768693313),
     FLO_FC9(148218.5774196043785196),  FLO_FC9(148244.7396025580819696),
     FLO_FC9(148270.9029398360580672),  FLO_FC9(148297.0674313365016133),
     FLO_FC9(148323.2330769575492013),  FLO_FC9(148349.3998765974247362),
     FLO_FC9(148375.5678301543230191),  FLO_FC9(148401.7369375265261624),
     FLO_FC9(148427.9071986122580711),  FLO_FC9(148454.0786133098299615),
     FLO_FC9(148480.2511815175239462),  FLO_FC9(148506.4249031336803455),
     FLO_FC9(148532.5997780566685833),  FLO_FC9(148558.7758061848580837),
     FLO_FC9(148584.9529874166473746),  FLO_FC9(148611.1313216504349839),
     FLO_FC9(148637.3108087847067509),  FLO_FC9(148663.4914487178903073),
     FLO_FC9(148689.6732413485005964),  FLO_FC9(148715.8561865750234574),
     FLO_FC9(148742.0402842960029375),  FLO_FC9(148768.2255344099830836),
     FLO_FC9(148794.4119368155661505),  FLO_FC9(148820.5994914113252889),
     FLO_FC9(148846.7881980958918575),  FLO_FC9(148872.9780567679263186),
     FLO_FC9(148899.1690673260600306),  FLO_FC9(148925.3612296690116636),
     FLO_FC9(148951.5545436954707839),  FLO_FC9(148977.7490093041851651),
     FLO_FC9(149003.9446263939025812),  FLO_FC9(149030.1413948633999098),
     FLO_FC9(149056.3393146115122363),  FLO_FC9(149082.5383855369873345),
     FLO_FC9(149108.7386075387476012),  FLO_FC9(149134.9399805155990180),
     FLO_FC9(149161.1425043664639816),  FLO_FC9(149187.3461789902648889),
     FLO_FC9(149213.5510042858950328),  FLO_FC9(149239.7569801523350179),
     FLO_FC9(149265.9641064885363448),  FLO_FC9(149292.1723831935378257),
     FLO_FC9(149318.3818101663491689),  FLO_FC9(149344.5923873059800826),
     FLO_FC9(149370.8041145115566906),  FLO_FC9(149397.0169916821178049),
     FLO_FC9(149423.2310187167895492),  FLO_FC9(149449.4461955147271510),
     FLO_FC9(149475.6625219750276301),  FLO_FC9(149501.8799979969335254),
     FLO_FC9(149528.0986234796000645),  FLO_FC9(149554.3183983222697861),
     FLO_FC9(149580.5393224241852295),  FLO_FC9(149606.7613956845889334),
     FLO_FC9(149632.9846180027816445),  FLO_FC9(149659.2089892780932132),
     FLO_FC9(149685.4345094098243862),  FLO_FC9(149711.6611782973341178),
     FLO_FC9(149737.8889958400104661),  FLO_FC9(149764.1179619372414891),
     FLO_FC9(149790.3480764884443488),  FLO_FC9(149816.5793393930944148),
     FLO_FC9(149842.8117505506088492),  FLO_FC9(149869.0453098604630213),
     FLO_FC9(149895.2800172222196124),  FLO_FC9(149921.5158725353830960),
     FLO_FC9(149947.7528756995161530),  FLO_FC9(149973.9910266141523607),
     FLO_FC9(150000.2303251789126080),  FLO_FC9(150026.4707712934177835),
     FLO_FC9(150052.7123648573178798),  FLO_FC9(150078.9551057702628896),
     FLO_FC9(150105.1989939319028053),  FLO_FC9(150131.4440292420040350),
     FLO_FC9(150157.6902116002456751),  FLO_FC9(150183.9375409063941333),
     FLO_FC9(150210.1860170602449216),  FLO_FC9(150236.4356399615353439),
     FLO_FC9(150262.6864095101191197),  FLO_FC9(150288.9383256058208644),
     FLO_FC9(150315.1913881485234015),  FLO_FC9(150341.4455970380513463),
     FLO_FC9(150367.7009521743748337),  FLO_FC9(150393.9574534573475830),
     FLO_FC9(150420.2151007869688328),  FLO_FC9(150446.4738940632087179),
     FLO_FC9(150472.7338331860082690),  FLO_FC9(150498.9949180554249324),
     FLO_FC9(150525.2571485714579467),  FLO_FC9(150551.5205246341938619),
     FLO_FC9(150577.7850461436901242),  FLO_FC9(150604.0507130000332836),
     FLO_FC9(150630.3175251033680979),  FLO_FC9(150656.5854823538393248),
     FLO_FC9(150682.8545846515917219),  FLO_FC9(150709.1248318967991509),
     FLO_FC9(150735.3962239897227846),  FLO_FC9(150761.6687608305073809),
     FLO_FC9(150787.9424423195014242),  FLO_FC9(150814.2172683569078799),
     FLO_FC9(150840.4932388430170249),  FLO_FC9(150866.7703536782064475),
     FLO_FC9(150893.0486127627664246),  FLO_FC9(150919.3280159970454406),
     FLO_FC9(150945.6085632814792916),  FLO_FC9(150971.8902545164164621),
     FLO_FC9(150998.1730896022927482),  FLO_FC9(151024.4570684395730495),
     FLO_FC9(151050.7421909287222661),  FLO_FC9(151077.0284569702052977),
     FLO_FC9(151103.3158664645452518),  FLO_FC9(151129.6044193122943398),
     FLO_FC9(151155.8941154140047729),  FLO_FC9(151182.1849546701996587),
     FLO_FC9(151208.4769369815476239),  FLO_FC9(151234.7700622486299835),
     FLO_FC9(151261.0643303720862605),  FLO_FC9(151287.3597412525850814),
     FLO_FC9(151313.6562947908241767),  FLO_FC9(151339.9539908874721732),
     FLO_FC9(151366.2528294432850089),  FLO_FC9(151392.5528103590186220),
     FLO_FC9(151418.8539335354289506),  FLO_FC9(151445.1561988733010367),
     FLO_FC9(151471.4596062734490260),  FLO_FC9(151497.7641556367452722),
     FLO_FC9(151524.0698468639748171),  FLO_FC9(151550.3766798560682219),
     FLO_FC9(151576.6846545139269438),  FLO_FC9(151602.9937707384524401),
     FLO_FC9(151629.3040284305752721),  FLO_FC9(151655.6154274912842084),
     FLO_FC9(151681.9279678215680178),  FLO_FC9(151708.2416493224154692),
     FLO_FC9(151734.5564718948444352),  FLO_FC9(151760.8724354399309959),
     FLO_FC9(151787.1895398587221280),  FLO_FC9(151813.5077850523521192),
     FLO_FC9(151839.8271709218679462),  FLO_FC9(151866.1476973684621044),
     FLO_FC9(151892.4693642932688817),  FLO_FC9(151918.7921715974807739),
     FLO_FC9(151945.1161191822902765),  FLO_FC9(151971.4412069488898851),
     FLO_FC9(151997.7674347985594068),  FLO_FC9(152024.0948026325495448),
     FLO_FC9(152050.4233103521401063),  FLO_FC9(152076.7529578586400021),
     FLO_FC9(152103.0837450533872470),  FLO_FC9(152129.4156718377198558),
     FLO_FC9(152155.7487381130340509),  FLO_FC9(152182.0829437806678470),
     FLO_FC9(152208.4182887420756742),  FLO_FC9(152234.7547728987119626),
     FLO_FC9(152261.0923961519729346),  FLO_FC9(152287.4311584033712279),
     FLO_FC9(152313.7710595543903764),  FLO_FC9(152340.1120995065721218),
     FLO_FC9(152366.4542781614582054),  FLO_FC9(152392.7975954205612652),
     FLO_FC9(152419.1420511855394579),  FLO_FC9(152445.4876453579345252),
     FLO_FC9(152471.8343778394046240),  FLO_FC9(152498.1822485316079110),
     FLO_FC9(152524.5312573361734394),  FLO_FC9(152550.8814041548175737),
     FLO_FC9(152577.2326888892566785),  FLO_FC9(152603.5851114412071183),
     FLO_FC9(152629.9386717124143615),  FLO_FC9(152656.2933696046820842),
     FLO_FC9(152682.6492050197848585),  FLO_FC9(152709.0061778595554642),
     FLO_FC9(152735.3642880258266814),  FLO_FC9(152761.7235354204312898),
     FLO_FC9(152788.0839199452893808),  FLO_FC9(152814.4454415022919420),
     FLO_FC9(152840.8080999933299609),  FLO_FC9(152867.1718953203817364),
     FLO_FC9(152893.5368273854255676),  FLO_FC9(152919.9028960904106498),
     FLO_FC9(152946.2701013373734895),  FLO_FC9(152972.6384430283214897),
     FLO_FC9(152999.0079210652911570),  FLO_FC9(153025.3785353504063096),
     FLO_FC9(153051.7502857857034542),  FLO_FC9(153078.1231722733355127),
     FLO_FC9(153104.4971947153971996),  FLO_FC9(153130.8723530140996445),
     FLO_FC9(153157.2486470715666655),  FLO_FC9(153183.6260767900093924),
     FLO_FC9(153210.0046420716680586),  FLO_FC9(153236.3843428187537938),
     FLO_FC9(153262.7651789335359354),  FLO_FC9(153289.1471503182838205),
     FLO_FC9(153315.5302568753540982),  FLO_FC9(153341.9144985070161056),
     FLO_FC9(153368.2998751155973878),  FLO_FC9(153394.6863866035419051),
     FLO_FC9(153421.0740328731480986),  FLO_FC9(153447.4628138268890325),
     FLO_FC9(153473.8527293671795633),  FLO_FC9(153500.2437793964345474),
     FLO_FC9(153526.6359638171561528),  FLO_FC9(153553.0292825318174437),
     FLO_FC9(153579.4237354429496918),  FLO_FC9(153605.8193224530841690),
     FLO_FC9(153632.2160434647812508),  FLO_FC9(153658.6138983805722091),
     FLO_FC9(153685.0128871031047311),  FLO_FC9(153711.4130095349682961),
     FLO_FC9(153737.8142655788105913),  FLO_FC9(153764.2166551372793037),
     FLO_FC9(153790.6201781130512245),  FLO_FC9(153817.0248344088613521),
     FLO_FC9(153843.4306239273864776),  FLO_FC9(153869.8375465713907033),
     FLO_FC9(153896.2456022436672356),  FLO_FC9(153922.6547908469219692),
     FLO_FC9(153949.0651122840354219),  FLO_FC9(153975.4765664578008000),
     FLO_FC9(154001.8891532710695174),  FLO_FC9(154028.3028726266929880),
     FLO_FC9(154054.7177244276099373),  FLO_FC9(154081.1337085766717792),
     FLO_FC9(154107.5508249768172391),  FLO_FC9(154133.9690735310141463),
     FLO_FC9(154160.3884541422303300),  FLO_FC9(154186.8089667134627234),
     FLO_FC9(154213.2306111477373634),  FLO_FC9(154239.6533873480511829),
     FLO_FC9(154266.0772952174593229),  FLO_FC9(154292.5023346590751316),
     FLO_FC9(154318.9285055759828538),  FLO_FC9(154345.3558078712667339),
     FLO_FC9(154371.7842414480983280),  FLO_FC9(154398.2138062096491922),
     FLO_FC9(154424.6445020590326749),  FLO_FC9(154451.0763288995076437),
     FLO_FC9(154477.5092866342747584),  FLO_FC9(154503.9433751665928867),
     FLO_FC9(154530.3785943996917922),  FLO_FC9(154556.8149442368885502),
     FLO_FC9(154583.2524245814420283),  FLO_FC9(154609.6910353367275093),
     FLO_FC9(154636.1307764060329646),  FLO_FC9(154662.5716476927918848),
     FLO_FC9(154689.0136491003213450),  FLO_FC9(154715.4567805320839398),
     FLO_FC9(154741.9010418914549518),  FLO_FC9(154768.3464330819260795),
     FLO_FC9(154794.7929540069599170),  FLO_FC9(154821.2406045700190589),
     FLO_FC9(154847.6893846746243071),  FLO_FC9(154874.1392942243255675),
     FLO_FC9(154900.5903331226436421),  FLO_FC9(154927.0425012731575407),
     FLO_FC9(154953.4957985794753768),  FLO_FC9(154979.9502249452052638),
     FLO_FC9(155006.4057802739553154),  FLO_FC9(155032.8624644694209564),
     FLO_FC9(155059.3202774352394044),  FLO_FC9(155085.7792190751351882),
     FLO_FC9(155112.2392892928037327),  FLO_FC9(155138.7004879919695668),
     FLO_FC9(155165.1628150764154270),  FLO_FC9(155191.6262704498949461),
     FLO_FC9(155218.0908540162490681),  FLO_FC9(155244.5565656792314257),
     FLO_FC9(155271.0234053427411709),  FLO_FC9(155297.4913729105901439),
     FLO_FC9(155323.9604682866774965),  FLO_FC9(155350.4306913749023806),
     FLO_FC9(155376.9020420791930519),  FLO_FC9(155403.3745203034777660),
     FLO_FC9(155429.8481259517138824),  FLO_FC9(155456.3228589278878644),
     FLO_FC9(155482.7987191360152792),  FLO_FC9(155509.2757064801116940),
     FLO_FC9(155535.7538208642217796),  FLO_FC9(155562.2330621923902072),
     FLO_FC9(155588.7134303687198553),  FLO_FC9(155615.1949252973136026),
     FLO_FC9(155641.6775468822743278),  FLO_FC9(155668.1612950277922209),
     FLO_FC9(155694.6461696379701607),  FLO_FC9(155721.1321706170565449),
     FLO_FC9(155747.6192978692124598),  FLO_FC9(155774.1075512986863032),
     FLO_FC9(155800.5969308097264729),  FLO_FC9(155827.0874363066104706),
     FLO_FC9(155853.5790676935866941),  FLO_FC9(155880.0718248749617487),
     FLO_FC9(155906.5657077551295515),  FLO_FC9(155933.0607162383676041),
     FLO_FC9(155959.5568502290989272),  FLO_FC9(155986.0541096316592302),
     FLO_FC9(156012.5524943505006377),  FLO_FC9(156039.0520042900170665),
     FLO_FC9(156065.5526393547188491),  FLO_FC9(156092.0543994489999022),
     FLO_FC9(156118.5572844773996621),  FLO_FC9(156145.0612943444284610),
     FLO_FC9(156171.5664289545966312),  FLO_FC9(156198.0726882124727126),
     FLO_FC9(156224.5800720225961413),  FLO_FC9(156251.0885802895936649),
     FLO_FC9(156277.5982129180920310),  FLO_FC9(156304.1089698126597796),
     FLO_FC9(156330.6208508780109696),  FLO_FC9(156357.1338560188014526),
     FLO_FC9(156383.6479851396870799),  FLO_FC9(156410.1632381454401184),
     FLO_FC9(156436.6796149407455232),  FLO_FC9(156463.1971154304046649),
     FLO_FC9(156489.7157395191316027),  FLO_FC9(156516.2354871117568109),
     FLO_FC9(156542.7563581131107640),  FLO_FC9(156569.2783524279948324),
     FLO_FC9(156595.8014699612685945),  FLO_FC9(156622.3257106178207323),
     FLO_FC9(156648.8510743025399279),  FLO_FC9(156675.3775609203148633),
     FLO_FC9(156701.9051703761215322),  FLO_FC9(156728.4339025749068242),
     FLO_FC9(156754.9637574216176290),  FLO_FC9(156781.4947348212881479),
     FLO_FC9(156808.0268346788943745),  FLO_FC9(156834.5600568995287176),
     FLO_FC9(156861.0944013881671708),  FLO_FC9(156887.6298680499312468),
     FLO_FC9(156914.1664567899424583),  FLO_FC9(156940.7041675132641103),
     FLO_FC9(156967.2430001250468194),  FLO_FC9(156993.7829545304703061),
     FLO_FC9(157020.3240306346851867),  FLO_FC9(157046.8662283429002855),
     FLO_FC9(157073.4095475603244267),  FLO_FC9(157099.9539881921955384),
     FLO_FC9(157126.4995501437806524),  FLO_FC9(157153.0462333203176968),
     FLO_FC9(157179.5940376271610148),  FLO_FC9(157206.1429629695776384),
     FLO_FC9(157232.6930092529219110),  FLO_FC9(157259.2441763825772796),
     FLO_FC9(157285.7964642638689838),  FLO_FC9(157312.3498728022095747),
     FLO_FC9(157338.9044019030407071),  FLO_FC9(157365.4600514717458282),
     FLO_FC9(157392.0168214138539042),  FLO_FC9(157418.5747116347774863),
     FLO_FC9(157445.1337220400455408),  FLO_FC9(157471.6938525351288263),
     FLO_FC9(157498.2551030256436206),  FLO_FC9(157524.8174734170606826),
     FLO_FC9(157551.3809636150253937),  FLO_FC9(157577.9455735250958242),
     FLO_FC9(157604.5113030528591480),  FLO_FC9(157631.0781521040189546),
     FLO_FC9(157657.6461205841624178),  FLO_FC9(157684.2152083990222309),
     FLO_FC9(157710.7854154542728793),  FLO_FC9(157737.3567416555888485),
     FLO_FC9(157763.9291869087610394),  FLO_FC9(157790.5027511195221450),
     FLO_FC9(157817.0774341936339624),  FLO_FC9(157843.6532360369164962),
     FLO_FC9(157870.2301565551606473),  FLO_FC9(157896.8081956542155240),
     FLO_FC9(157923.3873532399011310),  FLO_FC9(157949.9676292181247845),
     FLO_FC9(157976.5490234947938006),  FLO_FC9(158003.1315359757572878),
     FLO_FC9(158029.7151665670098737),  FLO_FC9(158056.2999151744879782),
     FLO_FC9(158082.8857817041571252),  FLO_FC9(158109.4727660619828384),
     FLO_FC9(158136.0608681540179532),  FLO_FC9(158162.6500878862862010),
     FLO_FC9(158189.2404251648404170),  FLO_FC9(158215.8318798957334366),
     FLO_FC9(158242.4244519850471988),  FLO_FC9(158269.0181413389218505),
     FLO_FC9(158295.6129478634684347),  FLO_FC9(158322.2088714648562018),
     FLO_FC9(158348.8059120492252987),  FLO_FC9(158375.4040695228031836),
     FLO_FC9(158402.0033437917591073),  FLO_FC9(158428.6037347623496316),
     FLO_FC9(158455.2052423408022150),  FLO_FC9(158481.8078664333734196),
     FLO_FC9(158508.4116069464071188),  FLO_FC9(158535.0164637861598749),
     FLO_FC9(158561.6224368589755613),  FLO_FC9(158588.2295260711980518),
     FLO_FC9(158614.8377313292003237),  FLO_FC9(158641.4470525393553544),
     FLO_FC9(158668.0574896080652252),  FLO_FC9(158694.6690424417902250),
     FLO_FC9(158721.2817109469324350),  FLO_FC9(158747.8954950299812481),
     FLO_FC9(158774.5103945973969530),  FLO_FC9(158801.1264095557271503),
     FLO_FC9(158827.7435398114321288),  FLO_FC9(158854.3617852711176965),
     FLO_FC9(158880.9811458413023502),  FLO_FC9(158907.6016214285627939),
     FLO_FC9(158934.2232119395630434),  FLO_FC9(158960.8459172808506992),
     FLO_FC9(158987.4697373590897769),  FLO_FC9(159014.0946720809733961),
     FLO_FC9(159040.7207213531364687),  FLO_FC9(159067.3478850823012181),
     FLO_FC9(159093.9761631751898676),  FLO_FC9(159120.6055555385246407),
     FLO_FC9(159147.2360620790568646),  FLO_FC9(159173.8676827035960741),
     FLO_FC9(159200.5004173188935965),  FLO_FC9(159227.1342658318171743),
     FLO_FC9(159253.7692281491763424),  FLO_FC9(159280.4053041778097395),
     FLO_FC9(159307.0424938246142119),  FLO_FC9(159333.6807969964866061),
     FLO_FC9(159360.3202136003237683),  FLO_FC9(159386.9607435430516489),
     FLO_FC9(159413.6023867316544056),  FLO_FC9(159440.2451430730870925),
     FLO_FC9(159466.8890124743338674),  FLO_FC9(159493.5339948424370959),
     FLO_FC9(159520.1800900843809359),  FLO_FC9(159546.8272981072368566),
     FLO_FC9(159573.4756188180472236),  FLO_FC9(159600.1250521239708178),
     FLO_FC9(159626.7755979320209008),  FLO_FC9(159653.4272561494144611),
     FLO_FC9(159680.0800266832520720),  FLO_FC9(159706.7339094406925142),
     FLO_FC9(159733.3889043289236724),  FLO_FC9(159760.0450112551625352),
     FLO_FC9(159786.7022301266551949),  FLO_FC9(159813.3605608505895361),
     FLO_FC9(159840.0200033342698589),  FLO_FC9(159866.6805574849713594),
     FLO_FC9(159893.3422232099692337),  FLO_FC9(159920.0050004166259896),
     FLO_FC9(159946.6688890122459270),  FLO_FC9(159973.3338889042206574),
     FLO_FC9(159999.9999999998835847),  FLO_FC9(160026.6672222066845279),
     FLO_FC9(160053.3355554320150986),  FLO_FC9(160080.0049995832960121),
     FLO_FC9(160106.6755545680061914),  FLO_FC9(160133.3472202935954556),
     FLO_FC9(160160.0199966676009353),  FLO_FC9(160186.6938835975015536),
     FLO_FC9(160213.3688809908344410),  FLO_FC9(160240.0449887551658321),
     FLO_FC9(160266.7222067980619613),  FLO_FC9(160293.4005350270890631),
     FLO_FC9(160320.0799733498715796),  FLO_FC9(160346.7605216740630567),
     FLO_FC9(160373.4421799072879367),  FLO_FC9(160400.1249479571997654),
     FLO_FC9(160426.8088257315102965),  FLO_FC9(160453.4938131379312836),
     FLO_FC9(160480.1799100841744803),  FLO_FC9(160506.8671164779516403),
     FLO_FC9(160533.5554322270909324),  FLO_FC9(160560.2448572393332142),
     FLO_FC9(160586.9353914224775508),  FLO_FC9(160613.6270346843521111),
     FLO_FC9(160640.3197869328141678),  FLO_FC9(160667.0136480756918900),
     FLO_FC9(160693.7086180208716542),  FLO_FC9(160720.4046966762689408),
     FLO_FC9(160747.1018839497992303),  FLO_FC9(160773.8001797493780032),
     FLO_FC9(160800.4995839829789475),  FLO_FC9(160827.2000965585466474),
     FLO_FC9(160853.9017173841129988),  FLO_FC9(160880.6044463676516898),
     FLO_FC9(160907.3082834172237199),  FLO_FC9(160934.0132284408609848),
     FLO_FC9(160960.7192813466535881),  FLO_FC9(160987.4264420426916331),
     FLO_FC9(161014.1347104370361194),  FLO_FC9(161040.8440864378353581),
     FLO_FC9(161067.5545699532667641),  FLO_FC9(161094.2661608914786484),
     FLO_FC9(161120.9788591606193222),  FLO_FC9(161147.6926646689244080),
     FLO_FC9(161174.4075773246295284),  FLO_FC9(161201.1235970359412022),
     FLO_FC9(161227.8407237111241557),  FLO_FC9(161254.5589572584722191),
     FLO_FC9(161281.2782975862792227),  FLO_FC9(161307.9987446028681006),
     FLO_FC9(161334.7202982165617868),  FLO_FC9(161361.4429583357123192),
     FLO_FC9(161388.1667248687008396),  FLO_FC9(161414.8915977239084896),
     FLO_FC9(161441.6175768097746186),  FLO_FC9(161468.3446620346803684),
     FLO_FC9(161495.0728533071232960),  FLO_FC9(161521.8021505355718546),
     FLO_FC9(161548.5325536284653936),  FLO_FC9(161575.2640624943596777),
     FLO_FC9(161601.9966770417522639),  FLO_FC9(161628.7303971791989170),
     FLO_FC9(161655.4652228152554017),  FLO_FC9(161682.2011538584774826),
     FLO_FC9(161708.9381902175373398),  FLO_FC9(161735.6763318009907380),
     FLO_FC9(161762.4155785175098572),  FLO_FC9(161789.1559302757086698),
     FLO_FC9(161815.8973869843175635),  FLO_FC9(161842.6399485520087183),
     FLO_FC9(161869.3836148874834180),  FLO_FC9(161896.1283858995011542),
     FLO_FC9(161922.8742614967923146),  FLO_FC9(161949.6212415881163906),
     FLO_FC9(161976.3693260822910815),  FLO_FC9(162003.1185148881049827),
     FLO_FC9(162029.8688079144048970),  FLO_FC9(162056.6202050700085238),
     FLO_FC9(162083.3727062638208736),  FLO_FC9(162110.1263114046596456),
     FLO_FC9(162136.8810204015171621),  FLO_FC9(162163.6368331632402260),
     FLO_FC9(162190.3937495987920556),  FLO_FC9(162217.1517696171067655),
     FLO_FC9(162243.9108931272348855),  FLO_FC9(162270.6711200380814262),
     FLO_FC9(162297.4324502587260213),  FLO_FC9(162324.1948836981900968),
     FLO_FC9(162350.9584202654950786),  FLO_FC9(162377.7230598697497044),
     FLO_FC9(162404.4888024200336076),  FLO_FC9(162431.2556478254264221),
     FLO_FC9(162458.0235959950659890),  FLO_FC9(162484.7926468381483573),
     FLO_FC9(162511.5628002637822647),  FLO_FC9(162538.3340561811637599),
     FLO_FC9(162565.1064144994888920),  FLO_FC9(162591.8798751280119177),
     FLO_FC9(162618.6544379759288859),  FLO_FC9(162645.4301029525231570),
     FLO_FC9(162672.2068699670780916),  FLO_FC9(162698.9847389288770501),
     FLO_FC9(162725.7637097472324967),  FLO_FC9(162752.5437823314859997),
     FLO_FC9(162779.3249565909500234),  FLO_FC9(162806.1072324350534473),
     FLO_FC9(162832.8906097731669433),  FLO_FC9(162859.6750885146611836),
     FLO_FC9(162886.4606685690232553),  FLO_FC9(162913.2473498456238303),
     FLO_FC9(162940.0351322540082037),  FLO_FC9(162966.8240157035761513),
     FLO_FC9(162993.6140001039020717),  FLO_FC9(163020.4050853644439485),
     FLO_FC9(163047.1972713948052842),  FLO_FC9(163073.9905581044731662),
     FLO_FC9(163100.7849454030510969),  FLO_FC9(163127.5804332001425792),
     FLO_FC9(163154.3770214053511154),  FLO_FC9(163181.1747099283093121),
     FLO_FC9(163207.9734986786497757),  FLO_FC9(163234.7733875660633203),
     FLO_FC9(163261.5743765002407599),  FLO_FC9(163288.3764653908729088),
     FLO_FC9(163315.1796541476505809),  FLO_FC9(163341.9839426803810056),
     FLO_FC9(163368.7893308987549972),  FLO_FC9(163395.5958187126088887),
     FLO_FC9(163422.4034060317208059),  FLO_FC9(163449.2120927658979781),
     FLO_FC9(163476.0218788249767385),  FLO_FC9(163502.8327641188225243),
     FLO_FC9(163529.6447485573007725),  FLO_FC9(163556.4578320502769202),
     FLO_FC9(163583.2720145077037159),  FLO_FC9(163610.0872958394465968),
     FLO_FC9(163636.9036759555165190),  FLO_FC9(163663.7211547658371273),
     FLO_FC9(163690.5397321804193780),  FLO_FC9(163717.3594081092160195),
     FLO_FC9(163744.1801824622962158),  FLO_FC9(163771.0020551496418193),
     FLO_FC9(163797.8250260813802015),  FLO_FC9(163824.6490951675223187),
     FLO_FC9(163851.4742623181955423),  FLO_FC9(163878.3005274434981402),
     FLO_FC9(163905.1278904535574839),  FLO_FC9(163931.9563512585300487),
     FLO_FC9(163958.7859097685723100),  FLO_FC9(163985.6165658938698471),
     FLO_FC9(164012.4483195446373429),  FLO_FC9(164039.2811706310894806),
     FLO_FC9(164066.1151190634409431),  FLO_FC9(164092.9501647519937251),
     FLO_FC9(164119.7863076069916133),  FLO_FC9(164146.6235475387366023),
     FLO_FC9(164173.4618844575597905),  FLO_FC9(164200.3013182737631723),
     FLO_FC9(164227.1418488977069501),  FLO_FC9(164253.9834762397804298),
     FLO_FC9(164280.8262002103147097),  FLO_FC9(164307.6700207197864074),
     FLO_FC9(164334.5149376785557251),  FLO_FC9(164361.3609509970992804),
     FLO_FC9(164388.2080605858645868),  FLO_FC9(164415.0562663553282619),
     FLO_FC9(164441.9055682159960270),  FLO_FC9(164468.7559660783736035),
     FLO_FC9(164495.6074598529958166),  FLO_FC9(164522.4600494503974915),
     FLO_FC9(164549.3137347811716609),  FLO_FC9(164576.1685157559113577),
     FLO_FC9(164603.0243922851805110),  FLO_FC9(164629.8813642796594650),
     FLO_FC9(164656.7394316499121487),  FLO_FC9(164683.5985943066771142),
     FLO_FC9(164710.4588521606056020),  FLO_FC9(164737.3202051223779563),
     FLO_FC9(164764.1826531027036253),  FLO_FC9(164791.0461960123502649),
     FLO_FC9(164817.9108337620564271),  FLO_FC9(164844.7765662625606637),
     FLO_FC9(164871.6433934246888384),  FLO_FC9(164898.5113151592377108),
     FLO_FC9(164925.3803313770331442),  FLO_FC9(164952.2504419888718985),
     FLO_FC9(164979.1216469056962524),  FLO_FC9(165005.9939460383029655),
     FLO_FC9(165032.8673392976343166),  FLO_FC9(165059.7418265946034808),
     FLO_FC9(165086.6174078401527368),  FLO_FC9(165113.4940829451952595),
     FLO_FC9(165140.3718518207024317),  FLO_FC9(165167.2507143777038436),
     FLO_FC9(165194.1306705271708779),  FLO_FC9(165221.0117201801331248),
     FLO_FC9(165247.8938632476201747),  FLO_FC9(165274.7770996407198254),
     FLO_FC9(165301.6614292704907712),  FLO_FC9(165328.5468520480208099),
     FLO_FC9(165355.4333678844559472),  FLO_FC9(165382.3209766908839811),
     FLO_FC9(165409.2096783784800209),  FLO_FC9(165436.0994728584191762),
     FLO_FC9(165462.9903600418765564),  FLO_FC9(165489.8823398400563747),
     FLO_FC9(165516.7754121641919482)
};
#endif
