/*****************************************************************
|
|    Copyright 2004-2006 Axiomatic Systems LLC
|
|    This file is part of Melo (Melo AAC Decoder).
|
|    Unless you have obtained Melo under a difference license,
|    this version of Melo is Melo|GPL.
|    Melo|GPL is free software; you can redistribute it and/or modify
|    it under the terms of the GNU General Public License as published by
|    the Free Software Foundation; either version 2, or (at your option)
|    any later version.
|
|    Melo|GPL is distributed in the hope that it will be useful,
|    but WITHOUT ANY WARRANTY; without even the implied warranty of
|    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|    GNU General Public License for more details.
|
|    You should have received a copy of the GNU General Public License
|    along with Melo|GPL; see the file COPYING.  If not, write to the
|    Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
|    02111-1307, USA.
|
 ****************************************************************/

/*----------------------------------------------------------------------
|       Includes
+---------------------------------------------------------------------*/
#include "MloBitStream.h"
#include "MloConfig.h"
#include "MloDebug.h"
#include "MloHcbPair.h"
#include "MloDefs.h"

/*----------------------------------------------------------------------
|       Types
+---------------------------------------------------------------------*/
typedef struct MLO_HcbPair_Binary
{
   MLO_Int8       leaf_flag;
   MLO_Int8       data [2];
}  MLO_HcbPair_Binary;



typedef struct MLO_HcbPair_Step1
{
   MLO_UInt8      offset;
   MLO_Int8       extra_bits;
}  MLO_HcbPair_Step1;



typedef struct MLO_HcbPair_Step2
{
   MLO_Int8       bits;
   MLO_Int8       x;
   MLO_Int8       y;
}  MLO_HcbPair_Step2;



typedef struct MLO_HcbPair_Index
{
   const MLO_HcbPair_Binary *
                  bin_ptr;
   const MLO_HcbPair_Step1 *
                  step_1_ptr;
   const MLO_HcbPair_Step2 *
                  step_2_ptr;
}  MLO_HcbPair_Index;



/*----------------------------------------------------------------------
|       Constants
+---------------------------------------------------------------------*/



/* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
   Codebooks using binary search tree
*/



/* 4.A, Table 4.A.6 */
static const MLO_HcbPair_Binary  MLO_HcbPair_coodbook_5 [] =
{
   { 0, {  1,  2 } },
   { 1, {  0,  0 } },
   { 0, {  1,  2 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 0, {  4,  5 } },
   { 0, {  5,  6 } },
   { 0, {  6,  7 } },
   { 0, {  7,  8 } },
   { 1, { -1,  0 } },
   { 1, {  1,  0 } },
   { 1, {  0,  1 } },
   { 1, {  0, -1 } },
   { 0, {  4,  5 } },
   { 0, {  5,  6 } },
   { 0, {  6,  7 } },
   { 0, {  7,  8 } },
   { 1, {  1, -1 } },
   { 1, { -1,  1 } },
   { 1, { -1, -1 } },
   { 1, {  1,  1 } },
   { 0, {  4,  5 } },
   { 0, {  5,  6 } },
   { 0, {  6,  7 } },
   { 0, {  7,  8 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 1, { -2,  0 } },
   { 1, {  0,  2 } },
   { 1, {  2,  0 } },
   { 1, {  0, -2 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 1, { -2, -1 } },
   { 1, {  2,  1 } },
   { 1, { -1, -2 } },
   { 1, {  1,  2 } },
   { 1, { -2,  1 } },
   { 1, {  2, -1 } },
   { 1, { -1,  2 } },
   { 1, {  1, -2 } },
   { 1, { -3,  0 } },
   { 1, {  3,  0 } },
   { 1, {  0, -3 } },
   { 1, {  0,  3 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 1, { -3, -1 } },
   { 1, {  1,  3 } },
   { 1, {  3,  1 } },
   { 1, { -1, -3 } },
   { 1, { -3,  1 } },
   { 1, {  3, -1 } },
   { 1, {  1, -3 } },
   { 1, { -1,  3 } },
   { 1, { -2,  2 } },
   { 1, {  2,  2 } },
   { 1, { -2, -2 } },
   { 1, {  2, -2 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 1, { -3, -2 } },
   { 1, {  3, -2 } },
   { 1, { -2,  3 } },
   { 1, {  2, -3 } },
   { 1, {  3,  2 } },
   { 1, {  2,  3 } },
   { 1, { -3,  2 } },
   { 1, { -2, -3 } },
   { 1, {  0, -4 } },
   { 1, { -4,  0 } },
   { 1, {  4,  1 } },
   { 1, {  4,  0 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 1, { -4, -1 } },
   { 1, {  0,  4 } },
   { 1, {  4, -1 } },
   { 1, { -1, -4 } },
   { 1, {  1,  4 } },
   { 1, { -1,  4 } },
   { 1, { -4,  1 } },
   { 1, {  1, -4 } },
   { 1, {  3, -3 } },
   { 1, { -3, -3 } },
   { 1, { -3,  3 } },
   { 1, { -2,  4 } },
   { 1, { -4, -2 } },
   { 1, {  4,  2 } },
   { 1, {  2, -4 } },
   { 1, {  2,  4 } },
   { 1, {  3,  3 } },
   { 1, { -4,  2 } },
   { 0, {  6,  7 } },
   { 0, {  7,  8 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 1, { -2, -4 } },
   { 1, {  4, -2 } },
   { 1, {  3, -4 } },
   { 1, { -4, -3 } },
   { 1, { -4,  3 } },
   { 1, {  3,  4 } },
   { 1, { -3,  4 } },
   { 1, {  4,  3 } },
   { 1, {  4, -3 } },
   { 1, { -3, -4 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 1, {  4, -4 } },
   { 1, { -4,  4 } },
   { 1, {  4,  4 } },
   { 1, { -4, -4 } }
};



/* 4.A, Table 4.A.8 */
static const MLO_HcbPair_Binary  MLO_HcbPair_coodbook_7 [] =
{
   { 0, {  1,  2 } },
   { 1, {  0,  0 } },
   { 0, {  1,  2 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 1, {  1,  0 } },
   { 1, {  0,  1 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 1, {  1,  1 } },
   { 0, {  3,  4 } },
   { 0, {  4,  5 } },
   { 0, {  5,  6 } },
   { 0, {  6,  7 } },
   { 0, {  7,  8 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 1, {  2,  1 } },
   { 1, {  1,  2 } },
   { 1, {  2,  0 } },
   { 1, {  0,  2 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 1, {  3,  1 } },
   { 1, {  1,  3 } },
   { 1, {  2,  2 } },
   { 1, {  3,  0 } },
   { 1, {  0,  3 } },
   { 0, { 11, 12 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 1, {  2,  3 } },
   { 1, {  3,  2 } },
   { 1, {  1,  4 } },
   { 1, {  4,  1 } },
   { 1, {  1,  5 } },
   { 1, {  5,  1 } },
   { 1, {  3,  3 } },
   { 1, {  2,  4 } },
   { 1, {  0,  4 } },
   { 1, {  4,  0 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 1, {  4,  2 } },
   { 1, {  2,  5 } },
   { 1, {  5,  2 } },
   { 1, {  0,  5 } },
   { 1, {  6,  1 } },
   { 1, {  5,  0 } },
   { 1, {  1,  6 } },
   { 1, {  4,  3 } },
   { 1, {  3,  5 } },
   { 1, {  3,  4 } },
   { 1, {  5,  3 } },
   { 1, {  2,  6 } },
   { 1, {  6,  2 } },
   { 1, {  1,  7 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 1, {  3,  6 } },
   { 1, {  0,  6 } },
   { 1, {  6,  0 } },
   { 1, {  4,  4 } },
   { 1, {  7,  1 } },
   { 1, {  4,  5 } },
   { 1, {  7,  2 } },
   { 1, {  5,  4 } },
   { 1, {  6,  3 } },
   { 1, {  2,  7 } },
   { 1, {  7,  3 } },
   { 1, {  6,  4 } },
   { 1, {  5,  5 } },
   { 1, {  4,  6 } },
   { 1, {  3,  7 } },
   { 0, {  5,  6 } },
   { 0, {  6,  7 } },
   { 0, {  7,  8 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 1, {  7,  0 } },
   { 1, {  0,  7 } },
   { 1, {  6,  5 } },
   { 1, {  5,  6 } },
   { 1, {  7,  4 } },
   { 1, {  4,  7 } },
   { 1, {  5,  7 } },
   { 1, {  7,  5 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 1, {  7,  6 } },
   { 1, {  6,  6 } },
   { 1, {  6,  7 } },
   { 1, {  7,  7 } }
};



/* 4.A, Table 4.A.10 */
static const MLO_HcbPair_Binary  MLO_HcbPair_coodbook_9 [] =
{
   { 0, {  1,  2 } },
   { 1, {  0,  0 } },
   { 0, {  1,  2 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 1, {  1,  0 } },
   { 1, {  0,  1 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 1, {  1,  1 } },
   { 0, {  3,  4 } },
   { 0, {  4,  5 } },
   { 0, {  5,  6 } },
   { 0, {  6,  7 } },
   { 0, {  7,  8 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 1, {  2,  1 } },
   { 1, {  1,  2 } },
   { 1, {  2,  0 } },
   { 1, {  0,  2 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 1, {  3,  1 } },
   { 1, {  2,  2 } },
   { 1, {  1,  3 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 0, { 16, 17 } },
   { 0, { 17, 18 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 0, { 24, 25 } },
   { 0, { 25, 26 } },
   { 1, {  3,  0 } },
   { 1, {  0,  3 } },
   { 1, {  2,  3 } },
   { 1, {  3,  2 } },
   { 1, {  1,  4 } },
   { 1, {  4,  1 } },
   { 1, {  2,  4 } },
   { 1, {  1,  5 } },
   { 0, { 18, 19 } },
   { 0, { 19, 20 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 0, { 24, 25 } },
   { 0, { 25, 26 } },
   { 0, { 26, 27 } },
   { 0, { 27, 28 } },
   { 0, { 28, 29 } },
   { 0, { 29, 30 } },
   { 0, { 30, 31 } },
   { 0, { 31, 32 } },
   { 0, { 32, 33 } },
   { 0, { 33, 34 } },
   { 0, { 34, 35 } },
   { 0, { 35, 36 } },
   { 1, {  4,  2 } },
   { 1, {  3,  3 } },
   { 1, {  0,  4 } },
   { 1, {  4,  0 } },
   { 1, {  5,  1 } },
   { 1, {  2,  5 } },
   { 1, {  1,  6 } },
   { 1, {  3,  4 } },
   { 1, {  5,  2 } },
   { 1, {  6,  1 } },
   { 1, {  4,  3 } },
   { 0, { 25, 26 } },
   { 0, { 26, 27 } },
   { 0, { 27, 28 } },
   { 0, { 28, 29 } },
   { 0, { 29, 30 } },
   { 0, { 30, 31 } },
   { 0, { 31, 32 } },
   { 0, { 32, 33 } },
   { 0, { 33, 34 } },
   { 0, { 34, 35 } },
   { 0, { 35, 36 } },
   { 0, { 36, 37 } },
   { 0, { 37, 38 } },
   { 0, { 38, 39 } },
   { 0, { 39, 40 } },
   { 0, { 40, 41 } },
   { 0, { 41, 42 } },
   { 0, { 42, 43 } },
   { 0, { 43, 44 } },
   { 0, { 44, 45 } },
   { 0, { 45, 46 } },
   { 0, { 46, 47 } },
   { 0, { 47, 48 } },
   { 0, { 48, 49 } },
   { 0, { 49, 50 } },
   { 1, {  0,  5 } },
   { 1, {  2,  6 } },
   { 1, {  5,  0 } },
   { 1, {  1,  7 } },
   { 1, {  3,  5 } },
   { 1, {  1,  8 } },
   { 1, {  8,  1 } },
   { 1, {  4,  4 } },
   { 1, {  5,  3 } },
   { 1, {  6,  2 } },
   { 1, {  7,  1 } },
   { 1, {  0,  6 } },
   { 1, {  8,  2 } },
   { 1, {  2,  8 } },
   { 1, {  3,  6 } },
   { 1, {  2,  7 } },
   { 1, {  4,  5 } },
   { 1, {  9,  1 } },
   { 1, {  1,  9 } },
   { 1, {  7,  2 } },
   { 0, { 30, 31 } },
   { 0, { 31, 32 } },
   { 0, { 32, 33 } },
   { 0, { 33, 34 } },
   { 0, { 34, 35 } },
   { 0, { 35, 36 } },
   { 0, { 36, 37 } },
   { 0, { 37, 38 } },
   { 0, { 38, 39 } },
   { 0, { 39, 40 } },
   { 0, { 40, 41 } },
   { 0, { 41, 42 } },
   { 0, { 42, 43 } },
   { 0, { 43, 44 } },
   { 0, { 44, 45 } },
   { 0, { 45, 46 } },
   { 0, { 46, 47 } },
   { 0, { 47, 48 } },
   { 0, { 48, 49 } },
   { 0, { 49, 50 } },
   { 0, { 50, 51 } },
   { 0, { 51, 52 } },
   { 0, { 52, 53 } },
   { 0, { 53, 54 } },
   { 0, { 54, 55 } },
   { 0, { 55, 56 } },
   { 0, { 56, 57 } },
   { 0, { 57, 58 } },
   { 0, { 58, 59 } },
   { 0, { 59, 60 } },
   { 1, {  6,  0 } },
   { 1, {  5,  4 } },
   { 1, {  6,  3 } },
   { 1, {  8,  3 } },
   { 1, {  0,  7 } },
   { 1, {  9,  2 } },
   { 1, {  3,  8 } },
   { 1, {  4,  6 } },
   { 1, {  3,  7 } },
   { 1, {  0,  8 } },
   { 1, { 10,  1 } },
   { 1, {  6,  4 } },
   { 1, {  2,  9 } },
   { 1, {  5,  5 } },
   { 1, {  8,  0 } },
   { 1, {  7,  0 } },
   { 1, {  7,  3 } },
   { 1, { 10,  2 } },
   { 1, {  9,  3 } },
   { 1, {  8,  4 } },
   { 1, {  1, 10 } },
   { 1, {  7,  4 } },
   { 1, {  6,  5 } },
   { 1, {  5,  6 } },
   { 1, {  4,  8 } },
   { 1, {  4,  7 } },
   { 1, {  3,  9 } },
   { 1, { 11,  1 } },
   { 1, {  5,  8 } },
   { 1, {  9,  0 } },
   { 1, {  8,  5 } },
   { 0, { 29, 30 } },
   { 0, { 30, 31 } },
   { 0, { 31, 32 } },
   { 0, { 32, 33 } },
   { 0, { 33, 34 } },
   { 0, { 34, 35 } },
   { 0, { 35, 36 } },
   { 0, { 36, 37 } },
   { 0, { 37, 38 } },
   { 0, { 38, 39 } },
   { 0, { 39, 40 } },
   { 0, { 40, 41 } },
   { 0, { 41, 42 } },
   { 0, { 42, 43 } },
   { 0, { 43, 44 } },
   { 0, { 44, 45 } },
   { 0, { 45, 46 } },
   { 0, { 46, 47 } },
   { 0, { 47, 48 } },
   { 0, { 48, 49 } },
   { 0, { 49, 50 } },
   { 0, { 50, 51 } },
   { 0, { 51, 52 } },
   { 0, { 52, 53 } },
   { 0, { 53, 54 } },
   { 0, { 54, 55 } },
   { 0, { 55, 56 } },
   { 0, { 56, 57 } },
   { 0, { 57, 58 } },
   { 1, { 10,  3 } },
   { 1, {  2, 10 } },
   { 1, {  0,  9 } },
   { 1, { 11,  2 } },
   { 1, {  9,  4 } },
   { 1, {  6,  6 } },
   { 1, { 12,  1 } },
   { 1, {  4,  9 } },
   { 1, {  8,  6 } },
   { 1, {  1, 11 } },
   { 1, {  9,  5 } },
   { 1, { 10,  4 } },
   { 1, {  5,  7 } },
   { 1, {  7,  5 } },
   { 1, {  2, 11 } },
   { 1, {  1, 12 } },
   { 1, { 12,  2 } },
   { 1, { 11,  3 } },
   { 1, {  3, 10 } },
   { 1, {  5,  9 } },
   { 1, {  6,  7 } },
   { 1, {  8,  7 } },
   { 1, { 11,  4 } },
   { 1, {  0, 10 } },
   { 1, {  7,  6 } },
   { 1, { 12,  3 } },
   { 1, { 10,  0 } },
   { 1, { 10,  5 } },
   { 1, {  4, 10 } },
   { 1, {  6,  8 } },
   { 1, {  2, 12 } },
   { 1, {  9,  6 } },
   { 1, {  9,  7 } },
   { 1, {  4, 11 } },
   { 1, { 11,  0 } },
   { 1, {  6,  9 } },
   { 1, {  3, 11 } },
   { 1, {  5, 10 } },
   { 0, { 20, 21 } },
   { 0, { 21, 22 } },
   { 0, { 22, 23 } },
   { 0, { 23, 24 } },
   { 0, { 24, 25 } },
   { 0, { 25, 26 } },
   { 0, { 26, 27 } },
   { 0, { 27, 28 } },
   { 0, { 28, 29 } },
   { 0, { 29, 30 } },
   { 0, { 30, 31 } },
   { 0, { 31, 32 } },
   { 0, { 32, 33 } },
   { 0, { 33, 34 } },
   { 0, { 34, 35 } },
   { 0, { 35, 36 } },
   { 0, { 36, 37 } },
   { 0, { 37, 38 } },
   { 0, { 38, 39 } },
   { 0, { 39, 40 } },
   { 1, {  8,  8 } },
   { 1, {  7,  8 } },
   { 1, { 12,  5 } },
   { 1, {  3, 12 } },
   { 1, { 11,  5 } },
   { 1, {  7,  7 } },
   { 1, { 12,  4 } },
   { 1, { 11,  6 } },
   { 1, { 10,  6 } },
   { 1, {  4, 12 } },
   { 1, {  7,  9 } },
   { 1, {  5, 11 } },
   { 1, {  0, 11 } },
   { 1, { 12,  6 } },
   { 1, {  6, 10 } },
   { 1, { 12,  0 } },
   { 1, { 10,  7 } },
   { 1, {  5, 12 } },
   { 1, {  7, 10 } },
   { 1, {  9,  8 } },
   { 1, {  0, 12 } },
   { 1, { 11,  7 } },
   { 1, {  8,  9 } },
   { 1, {  9,  9 } },
   { 1, { 10,  8 } },
   { 1, {  7, 11 } },
   { 1, { 12,  7 } },
   { 1, {  6, 11 } },
   { 1, {  8, 11 } },
   { 1, { 11,  8 } },
   { 1, {  7, 12 } },
   { 1, {  6, 12 } },
   { 0, {  8,  9 } },
   { 0, {  9, 10 } },
   { 0, { 10, 11 } },
   { 0, { 11, 12 } },
   { 0, { 12, 13 } },
   { 0, { 13, 14 } },
   { 0, { 14, 15 } },
   { 0, { 15, 16 } },
   { 1, {  8, 10 } },
   { 1, { 10,  9 } },
   { 1, {  8, 12 } },
   { 1, {  9, 10 } },
   { 1, {  9, 11 } },
   { 1, {  9, 12 } },
   { 1, { 10, 11 } },
   { 1, { 12,  9 } },
   { 1, { 10, 10 } },
   { 1, { 11,  9 } },
   { 1, { 12,  8 } },
   { 1, { 11, 10 } },
   { 1, { 12, 10 } },
   { 1, { 12, 11 } },
   { 0, {  2,  3 } },
   { 0, {  3,  4 } },
   { 1, { 10, 12 } },
   { 1, { 11, 11 } },
   { 1, { 11, 12 } },
   { 1, { 12, 12 } }
};



/* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
   Codebooks using 2-step lookup method
*/



/* 4.A, Table 4.A.7 */
static const MLO_HcbPair_Step1   MLO_HcbPair_coodbook_6_1 [32] =
{
   /* 4 bit codewords */
   { 0, 0 },
   { 0, 0 },
   { 1, 0 },
   { 1, 0 },
   { 2, 0 },
   { 2, 0 },
   { 3, 0 },
   { 3, 0 },
   { 4, 0 },
   { 4, 0 },
   { 5, 0 },
   { 5, 0 },
   { 6, 0 },
   { 6, 0 },
   { 7, 0 },
   { 7, 0 },
   { 8, 0 },
   { 8, 0 },

   /* 6 bit codewords */
   {  9, 1 },
   { 11, 1 },
   { 13, 1 },
   { 15, 1 },
   { 17, 1 },
   { 19, 1 },
   { 21, 1 },
   { 23, 1 },

   /* 7 bit codewords */
   { 25, 2 },
   { 29, 2 },
   { 33, 2 },

   /* 7/8 bit codewords */
   { 37, 3 },

   /* 8/9 bit codewords */
   { 45, 4 },

   /* 9/10/11 bit codewords */
   { 61, 6 }
};

static const MLO_HcbPair_Step2   MLO_HcbPair_coodbook_6_2 [] =
{
   /* 4 bit codewords */
   {  4,  0,  0 },
   {  4,  1,  0 },
   {  4,  0, -1 },
   {  4,  0,  1 },
   {  4, -1,  0 },
   {  4,  1,  1 },
   {  4, -1,  1 },
   {  4,  1, -1 },
   {  4, -1, -1 },

   /* 6 bit codewords */
   {  6,  2, -1 },
   {  6,  2,  1 },
   {  6, -2,  1 },
   {  6, -2, -1 },
   {  6, -2,  0 },
   {  6, -1,  2 },
   {  6,  2,  0 },
   {  6,  1, -2 },
   {  6,  1,  2 },
   {  6,  0, -2 },
   {  6, -1, -2 },
   {  6,  0,  2 },
   {  6,  2, -2 },
   {  6, -2,  2 },
   {  6, -2, -2 },
   {  6,  2,  2 },

   /* 7 bit codewords */
   {  7, -3,  1 },
   {  7,  3,  1 },
   {  7,  3, -1 },
   {  7, -1,  3 },
   {  7, -3, -1 },
   {  7,  1,  3 },
   {  7,  1, -3 },
   {  7, -1, -3 },
   {  7,  3,  0 },
   {  7, -3,  0 },
   {  7,  0, -3 },
   {  7,  0,  3 },

   /* 7/8 bit codewords */
   {  7,  3,  2 }, { 7,  3,  2 },
   {  8, -3, -2 },
   {  8, -2,  3 },
   {  8,  2,  3 },
   {  8,  3, -2 },
   {  8,  2, -3 },
   {  8, -2, -3 },

   /* 8 bit codewords */
   {  8, -3,  2 }, { 8, -3,  2 },
   {  8,  3,  3 }, { 8,  3,  3 },
   {  9,  3, -3 },
   {  9, -3, -3 },
   {  9, -3,  3 },
   {  9,  1, -4 },
   {  9, -1, -4 },
   {  9,  4,  1 },
   {  9, -4,  1 },
   {  9, -4, -1 },
   {  9,  1,  4 },
   {  9,  4, -1 },
   {  9, -1,  4 },
   {  9,  0, -4 },

   /* 9/10/11 bit codewords */
   {  9, -4,  2 }, {  9, -4,  2 }, {  9, -4,  2 }, {  9, -4,  2 },
   {  9, -4, -2 }, {  9, -4, -2 }, {  9, -4, -2 }, {  9, -4, -2 },
   {  9,  2,  4 }, {  9,  2,  4 }, {  9,  2,  4 }, {  9,  2,  4 },
   {  9, -2, -4 }, {  9, -2, -4 }, {  9, -2, -4 }, {  9, -2, -4 },
   {  9, -4,  0 }, {  9, -4,  0 }, {  9, -4,  0 }, {  9, -4,  0 },
   {  9,  4,  2 }, {  9,  4,  2 }, {  9,  4,  2 }, {  9,  4,  2 },
   {  9,  4, -2 }, {  9,  4, -2 }, {  9,  4, -2 }, {  9,  4, -2 },
   {  9, -2,  4 }, {  9, -2,  4 }, {  9, -2,  4 }, {  9, -2,  4 },
   {  9,  4,  0 }, {  9,  4,  0 }, {  9,  4,  0 }, {  9,  4,  0 },
   {  9,  2, -4 }, {  9,  2, -4 }, {  9,  2, -4 }, {  9,  2, -4 },
   {  9,  0,  4 }, {  9,  0,  4 }, {  9,  0,  4 }, {  9,  0,  4 },
   { 10, -3, -4 }, { 10, -3, -4 },
   { 10, -3,  4 }, { 10, -3,  4 },
   { 10,  3, -4 }, { 10,  3, -4 },
   { 10,  4, -3 }, { 10,  4, -3 },
   { 10,  3,  4 }, { 10,  3,  4 },
   { 10,  4,  3 }, { 10,  4,  3 },
   { 10, -4,  3 }, { 10, -4,  3 },
   { 10, -4, -3 }, { 10, -4, -3 },
   { 11,  4,  4 },
   { 11, -4,  4 },
   { 11, -4, -4 },
   { 11,  4, -4 }
};



/* 4.A, Table 4.A.9 */
static const MLO_HcbPair_Step1   MLO_HcbPair_coodbook_8_1 [32] =
{
   /* 3 bit codeword */
   {  0, 0 },
   {  0, 0 },
   {  0, 0 },
   {  0, 0 },

   /* 4 bit codewords */
   {  1, 0 },
   {  1, 0 },
   {  2, 0 },
   {  2, 0 },
   {  3, 0 },
   {  3, 0 },
   {  4, 0 },
   {  4, 0 },
   {  5, 0 },
   {  5, 0 },

   /* 5 bit codewords */
   {  6, 0 },
   {  7, 0 },
   {  8, 0 },
   {  9, 0 },
   { 10, 0 },
   { 11, 0 },
   { 12, 0 },

   /* 6 bit codewords */
   { 13, 1 },
   { 15, 1 },
   { 17, 1 },
   { 19, 1 },
   { 21, 1 },

   /* 7 bit codewords */
   { 23, 2 },
   { 27, 2 },
   { 31, 2 },

   /* 7/8 bit codewords */
   { 35, 3 },

   /* 8 bit codewords */
   { 43, 3 },

   /* 8/9/10 bit codewords */
   { 51, 5 }
};

static const MLO_HcbPair_Step2   MLO_HcbPair_coodbook_8_2 [] =
{
   /* 3 bit codeword */
   {  3,  1,  1 },

   /* 4 bit codewords */
   {  4,  2,  1 },
   {  4,  1,  0 },
   {  4,  1,  2 },
   {  4,  0,  1 },
   {  4,  2,  2 },

   /* 5 bit codewords */
   {  5,  0,  0 },
   {  5,  2,  0 },
   {  5,  0,  2 },
   {  5,  3,  1 },
   {  5,  1,  3 },
   {  5,  3,  2 },
   {  5,  2,  3 },

   /* 6 bit codewords */
   {  6,  3,  3 },
   {  6,  4,  1 },
   {  6,  1,  4 },
   {  6,  4,  2 },
   {  6,  2,  4 },
   {  6,  3,  0 },
   {  6,  0,  3 },
   {  6,  4,  3 },
   {  6,  3,  4 },
   {  6,  5,  2 },

   /* 7 bit codewords */
   {  7,  5,  1 },
   {  7,  2,  5 },
   {  7,  1,  5 },
   {  7,  5,  3 },
   {  7,  3,  5 },
   {  7,  4,  4 },
   {  7,  5,  4 },
   {  7,  0,  4 },
   {  7,  4,  5 },
   {  7,  4,  0 },
   {  7,  2,  6 },
   {  7,  6,  2 },

   /* 7/8 bit codewords */
   {  7,  6,  1 }, { 7,  6,  1 },
   {  7,  1,  6 }, { 7,  1,  6 },
   {  8,  3,  6 },
   {  8,  6,  3 },
   {  8,  5,  5 },
   {  8,  5,  0 },

   /* 8 bit codewords */
   {  8,  6,  4 },
   {  8,  0,  5 },
   {  8,  4,  6 },
   {  8,  7,  1 },
   {  8,  7,  2 },
   {  8,  2,  7 },
   {  8,  6,  5 },
   {  8,  7,  3 },

   /* 8/9/10 bit codewords */
   {  8,  1,  7 }, {  8,  1,  7 }, {  8,  1,  7 }, {  8,  1,  7 },
   {  8,  5,  6 }, {  8,  5,  6 }, {  8,  5,  6 }, {  8,  5,  6 },
   {  8,  3,  7 }, {  8,  3,  7 }, {  8,  3,  7 }, {  8,  3,  7 },
   {  9,  6,  6 }, {  9,  6,  6 },
   {  9,  7,  4 }, {  9,  7,  4 },
   {  9,  6,  0 }, {  9,  6,  0 },
   {  9,  4,  7 }, {  9,  4,  7 },
   {  9,  0,  6 }, {  9,  0,  6 },
   {  9,  7,  5 }, {  9,  7,  5 },
   {  9,  7,  6 }, {  9,  7,  6 },
   {  9,  6,  7 }, {  9,  6,  7 },
   { 10,  5,  7 },
   { 10,  7,  0 },
   { 10,  0,  7 },
   { 10,  7,  7 }
};



/* 4.A, Table 4.A.11 */
static const MLO_HcbPair_Step1   MLO_HcbPair_coodbook_10_1 [64] =
{
   /* 4 bit codewords */
   {  0, 0 },
   {  0, 0 },
   {  0, 0 },
   {  0, 0 },
   {  1, 0 },
   {  1, 0 },
   {  1, 0 },
   {  1, 0 },
   {  2, 0 },
   {  2, 0 },
   {  2, 0 },
   {  2, 0 },

   /* 5 bit codewords */
   {  3, 0 },
   {  3, 0 },
   {  4, 0 },
   {  4, 0 },
   {  5, 0 },
   {  5, 0 },
   {  6, 0 },
   {  6, 0 },
   {  7, 0 },
   {  7, 0 },
   {  8, 0 },
   {  8, 0 },
   {  9, 0 },
   {  9, 0 },
   { 10, 0 },
   { 10, 0 },

   /* 6 bit codewords */
   { 11, 0 },
   { 12, 0 },
   { 13, 0 },
   { 14, 0 },
   { 15, 0 },
   { 16, 0 },
   { 17, 0 },
   { 18, 0 },
   { 19, 0 },
   { 20, 0 },
   { 21, 0 },
   { 22, 0 },
   { 23, 0 },
   { 24, 0 },

   /* 7 bit codewords */
   { 25, 1 },
   { 27, 1 },
   { 29, 1 },
   { 31, 1 },
   { 33, 1 },
   { 35, 1 },
   { 37, 1 },
   { 39, 1 },

   /* 7/8 bit codewords */
   { 41, 2 },

   /* 8 bit codewords */
   { 45, 2 },
   { 49, 2 },
   { 53, 2 },
   { 57, 2 },
   { 61, 2 },

   /* 8/9 bit codewords */
   { 65, 3 },

   /* 9 bit codewords */
   { 73, 3 },
   { 81, 3 },
   { 89, 3 },

   /* 9/10 bit codewords */
   { 97, 4 },

   /* 10 bit codewords */
   { 113, 4 },
   { 129, 4 },

   /* 10/11/12 bit codewords */
   { 145, 6 }
};

static const MLO_HcbPair_Step2   MLO_HcbPair_coodbook_10_2 [] =
{
   /* 4 bit codewords */
   {  4,  1,  1 },
   {  4,  1,  2 },
   {  4,  2,  1 },

   /* 5 bit codewords */
   {  5,  2,  2 },
   {  5,  1,  0 },
   {  5,  0,  1 },
   {  5,  1,  3 },
   {  5,  3,  2 },
   {  5,  3,  1 },
   {  5,  2,  3 },
   {  5,  3,  3 },

   /* 6 bit codewords */
   {  6,  2,  0 },
   {  6,  0,  2 },
   {  6,  2,  4 },
   {  6,  4,  2 },
   {  6,  1,  4 },
   {  6,  4,  1 },
   {  6,  0,  0 },
   {  6,  4,  3 },
   {  6,  3,  4 },
   {  6,  3,  0 },
   {  6,  0,  3 },
   {  6,  4,  4 },
   {  6,  2,  5 },
   {  6,  5,  2 },

   /* 7 bit codewords */
   {  7,  1,  5 },
   {  7,  5,  1 },
   {  7,  5,  3 },
   {  7,  3,  5 },
   {  7,  5,  4 },
   {  7,  4,  5 },
   {  7,  6,  2 },
   {  7,  2,  6 },
   {  7,  6,  3 },
   {  7,  4,  0 },
   {  7,  6,  1 },
   {  7,  0,  4 },
   {  7,  1,  6 },
   {  7,  3,  6 },
   {  7,  5,  5 },
   {  7,  6,  4 },

   /* 7/8 bit codewords */
   {  7,  4,  6 }, { 7,  4,  6 },
   {  8,  6,  5 },
   {  8,  7,  2 },

   /* 8 bit codewords */
   {  8,  3,  7 },
   {  8,  2,  7 },
   {  8,  5,  6 },
   {  8,  8,  2 },
   {  8,  7,  3 },
   {  8,  5,  0 },
   {  8,  7,  1 },
   {  8,  0,  5 },
   {  8,  8,  1 },
   {  8,  1,  7 },
   {  8,  8,  3 },
   {  8,  7,  4 },
   {  8,  4,  7 },
   {  8,  2,  8 },
   {  8,  6,  6 },
   {  8,  7,  5 },
   {  8,  1,  8 },
   {  8,  3,  8 },
   {  8,  8,  4 },
   {  8,  4,  8 },

   /* 8/9 bit codewords */
   {  8,  5,  7 }, {  8,  5,  7 },
   {  8,  8,  5 }, {  8,  8,  5 },
   {  8,  5,  8 }, {  8,  5,  8 },
   {  9,  7,  6 },
   {  9,  6,  7 },

   /* 9 bit codewords */
   {  9,  9,  2 },
   {  9,  6,  0 },
   {  9,  6,  8 },
   {  9,  9,  3 },
   {  9,  3,  9 },
   {  9,  9,  1 },
   {  9,  2,  9 },
   {  9,  0,  6 },
   {  9,  8,  6 },
   {  9,  9,  4 },
   {  9,  4,  9 },
   {  9, 10,  2 },
   {  9,  1,  9 },
   {  9,  7,  7 },
   {  9,  8,  7 },
   {  9,  9,  5 },
   {  9,  7,  8 },
   {  9, 10,  3 },
   {  9,  5,  9 },
   {  9, 10,  4 },
   {  9,  2, 10 },
   {  9, 10,  1 },
   {  9,  3, 10 },
   {  9,  9,  6 },

   /* 9/10 bit codewords */
   {  9,  6,  9 }, { 9,  6,  9 },
   {  9,  8,  0 }, { 9,  8,  0 },
   {  9,  4, 10 }, { 9,  4, 10 },
   {  9,  7,  0 }, { 9,  7,  0 },
   {  9, 11,  2 }, { 9, 11,  2 },
   { 10,  7,  9 },
   { 10, 11,  3 },
   { 10, 10,  6 },
   { 10,  1, 10 },
   { 10, 11,  1 },
   { 10,  9,  7 },

   /* 10 bit codewords */
   { 10,  0,  7 },
   { 10,  8,  8 },
   { 10, 10,  5 },
   { 10,  3, 11 },
   { 10,  5, 10 },
   { 10,  8,  9 },
   { 10, 11,  5 },
   { 10,  0,  8 },
   { 10, 11,  4 },
   { 10,  2, 11 },
   { 10,  7, 10 },
   { 10,  6, 10 },
   { 10, 10,  7 },
   { 10,  4, 11 },
   { 10,  1, 11 },
   { 10, 12,  2 },
   { 10,  9,  8 },
   { 10, 12,  3 },
   { 10, 11,  6 },
   { 10,  5, 11 },
   { 10, 12,  4 },
   { 10, 11,  7 },
   { 10, 12,  5 },
   { 10,  3, 12 },
   { 10,  6, 11 },
   { 10,  9,  0 },
   { 10, 10,  8 },
   { 10, 10,  0 },
   { 10, 12,  1 },
   { 10,  0,  9 },
   { 10,  4, 12 },
   { 10,  9,  9 },

   /* 10/11/12 bit codewords */
   { 10, 12,  6 }, { 10, 12,  6 }, { 10, 12,  6 }, { 10, 12,  6 },
   { 10,  2, 12 }, { 10,  2, 12 }, { 10,  2, 12 }, { 10,  2, 12 },
   { 10,  8, 10 }, { 10,  8, 10 }, { 10,  8, 10 }, { 10,  8, 10 },
   { 11,  9, 10 }, { 11,  9, 10 },
   { 11,  1, 12 }, { 11,  1, 12 },
   { 11, 11,  8 }, { 11, 11,  8 },
   { 11, 12,  7 }, { 11, 12,  7 },
   { 11,  7, 11 }, { 11,  7, 11 },
   { 11,  5, 12 }, { 11,  5, 12 },
   { 11,  6, 12 }, { 11,  6, 12 },
   { 11, 10,  9 }, { 11, 10,  9 },
   { 11,  8, 11 }, { 11,  8, 11 },
   { 11, 12,  8 }, { 11, 12,  8 },
   { 11,  0, 10 }, { 11,  0, 10 },
   { 11,  7, 12 }, { 11,  7, 12 },
   { 11, 11,  0 }, { 11, 11,  0 },
   { 11, 10, 10 }, { 11, 10, 10 },
   { 11, 11,  9 }, { 11, 11,  9 },
   { 11, 11, 10 }, { 11, 11, 10 },
   { 11,  0, 11 }, { 11,  0, 11 },
   { 11, 11, 11 }, { 11, 11, 11 },
   { 11,  9, 11 }, { 11,  9, 11 },
   { 11, 10, 11 }, { 11, 10, 11 },
   { 11, 12,  0 }, { 11, 12,  0 },
   { 11,  8, 12 }, { 11,  8, 12 },
   { 12, 12,  9 },
   { 12, 10, 12 },
   { 12,  9, 12 },
   { 12, 11, 12 },
   { 12, 12, 11 },
   { 12,  0, 12 },
   { 12, 12, 10 },
   { 12, 12, 12 }
};



/* 4.A, Table 4.A.12 */
static const MLO_HcbPair_Step1   MLO_HcbPair_coodbook_11_1 [32] =
{
   /* 4 bits */
   {   0, 0 },
   {   0, 0 },
   {   1, 0 },
   {   1, 0 },

   /* 5 bits */
   {   2, 0 },
   {   3, 0 },
   {   4, 0 },
   {   5, 0 },
   {   6, 0 },
   {   7, 0 },

   /* 6 bits */
   {   8, 1 },
   {  10, 1 },
   {  12, 1 },

   /* 6/7 bits */
   {  14, 2 },

   /* 7 bits */
   {  18, 2 },
   {  22, 2 },
   {  26, 2 },

   /* 7/8 bits */
   {  30, 3 },

   /* 8 bits */
   {  38, 3 },
   {  46, 3 },
   {  54, 3 },
   {  62, 3 },
   {  70, 3 },
   {  78, 3 },

   /* 8/9 bits */
   {  86, 4 },

   /* 9 bits */
   { 102, 4 },
   { 118, 4 },
   { 134, 4 },

   /* 9/10 bits */
   { 150, 5 },

   /* 10 bits */
   { 182, 5 },
   { 214, 5 },

   /* 10/11/12 bits */
   { 246, 7 }
};

static const MLO_HcbPair_Step2   MLO_HcbPair_coodbook_11_2 [] =
{
   /* 4 */
   {  4,  0,  0 },
   {  4,  1,  1 },

   /* 5 */
   {  5, 16, 16 },
   {  5,  1,  0 },
   {  5,  0,  1 },
   {  5,  2,  1 },
   {  5,  1,  2 },
   {  5,  2,  2 },

   /* 6 */
   {  6,  1,  3 },
   {  6,  3,  1 },
   {  6,  3,  2 },
   {  6,  2,  0 },
   {  6,  2,  3 },
   {  6,  0,  2 },

   /* 6/7 */
   {  6,  3,  3 }, {  6,  3,  3 },
   {  7,  4,  1 },
   {  7,  1,  4 },

   /* 7 */
   {  7,  4,  2 },
   {  7,  2,  4 },
   {  7,  4,  3 },
   {  7,  3,  4 },
   {  7,  3,  0 },
   {  7,  0,  3 },
   {  7,  5,  1 },
   {  7,  5,  2 },
   {  7,  2,  5 },
   {  7,  4,  4 },
   {  7,  1,  5 },
   {  7,  5,  3 },

   /* 7/8 */
   {  7,  3,  5 }, {  7,  3,  5 },
   {  7,  5,  4 }, {  7,  5,  4 },
   {  8,  4,  5 },
   {  8,  6,  2 },
   {  8,  2,  6 },
   {  8,  6,  1 },

   /* 8 */
   {  8,  6,  3 },
   {  8,  3,  6 },
   {  8,  1,  6 },
   {  8,  4, 16 },
   {  8,  3, 16 },
   {  8, 16,  5 },
   {  8, 16,  3 },
   {  8, 16,  4 },
   {  8,  6,  4 },
   {  8, 16,  6 },
   {  8,  4,  0 },
   {  8,  4,  6 },
   {  8,  0,  4 },
   {  8,  2, 16 },
   {  8,  5,  5 },
   {  8,  5, 16 },
   {  8, 16,  7 },
   {  8, 16,  2 },
   {  8, 16,  8 },
   {  8,  2,  7 },
   {  8,  7,  2 },
   {  8,  3,  7 },
   {  8,  6,  5 },
   {  8,  5,  6 },
   {  8,  6, 16 },
   {  8, 16, 10 },
   {  8,  7,  3 },
   {  8,  7,  1 },
   {  8, 16,  9 },
   {  8,  7, 16 },
   {  8,  1, 16 },
   {  8,  1,  7 },
   {  8,  4,  7 },
   {  8, 16, 11 },
   {  8,  7,  4 },
   {  8, 16, 12 },
   {  8,  8, 16 },
   {  8, 16,  1 },
   {  8,  6,  6 },
   {  8,  9, 16 },
   {  8,  2,  8 },
   {  8,  5,  7 },
   {  8, 10, 16 },
   {  8, 16, 13 },
   {  8,  8,  3 },
   {  8,  8,  2 },
   {  8,  3,  8 },
   {  8,  5,  0 },

   /* 8/9 */
   {  8, 16, 14 }, {  8, 16, 14 },
   {  8, 11, 16 }, {  8, 11, 16 },
   {  8,  7,  5 }, {  8,  7,  5 },
   {  8,  4,  8 }, {  8,  4,  8 },
   {  8,  6,  7 }, {  8,  6,  7 },
   {  8,  7,  6 }, {  8,  7,  6 },
   {  8,  0,  5 }, {  8,  0,  5 },
   {  9,  8,  4 },
   {  9, 16, 15 },

   /* 9 */
   {  9, 12, 16 },
   {  9,  1,  8 },
   {  9,  8,  1 },
   {  9, 14, 16 },
   {  9,  5,  8 },
   {  9, 13, 16 },
   {  9,  3,  9 },
   {  9,  8,  5 },
   {  9,  7,  7 },
   {  9,  2,  9 },
   {  9,  8,  6 },
   {  9,  9,  2 },
   {  9,  9,  3 },
   {  9, 15, 16 },
   {  9,  4,  9 },
   {  9,  6,  8 },
   {  9,  6,  0 },
   {  9,  9,  4 },
   {  9,  5,  9 },
   {  9,  8,  7 },
   {  9,  7,  8 },
   {  9,  1,  9 },
   {  9, 10,  3 },
   {  9,  0,  6 },
   {  9, 10,  2 },
   {  9,  9,  1 },
   {  9,  9,  5 },
   {  9,  4, 10 },
   {  9,  2, 10 },
   {  9,  9,  6 },
   {  9,  3, 10 },
   {  9,  6,  9 },
   {  9, 10,  4 },
   {  9,  8,  8 },
   {  9, 10,  5 },
   {  9,  9,  7 },
   {  9, 11,  3 },
   {  9,  1, 10 },
   {  9,  7,  0 },
   {  9, 10,  6 },
   {  9,  7,  9 },
   {  9,  3, 11 },
   {  9,  5, 10 },
   {  9, 10,  1 },
   {  9,  4, 11 },
   {  9, 11,  2 },
   {  9, 13,  2 },
   {  9,  6, 10 },

   /* 9/10 */
   {  9, 13,  3 }, {  9, 13,  3 },
   {  9,  2, 11 }, {  9,  2, 11 },
   {  9, 16,  0 }, {  9, 16,  0 },
   {  9,  5, 11 }, {  9,  5, 11 },
   {  9, 11,  5 }, {  9, 11,  5 },
   { 10, 11,  4 },
   { 10,  9,  8 },
   { 10,  7, 10 },
   { 10,  8,  9 },
   { 10,  0, 16 },
   { 10,  4, 13 },
   { 10,  0,  7 },
   { 10,  3, 13 },
   { 10, 11,  6 },
   { 10, 13,  1 },
   { 10, 13,  4 },
   { 10, 12,  3 },
   { 10,  2, 13 },
   { 10, 13,  5 },
   { 10,  8, 10 },
   { 10,  6, 11 },
   { 10, 10,  8 },
   { 10, 10,  7 },
   { 10, 14,  2 },
   { 10, 12,  4 },
   { 10,  1, 11 },
   { 10,  4, 12 },

   /* 10 */
   { 10, 11,  1 },
   { 10,  3, 12 },
   { 10,  1, 13 },
   { 10, 12,  2 },
   { 10,  7, 11 },
   { 10,  3, 14 },
   { 10,  5, 12 },
   { 10,  5, 13 },
   { 10, 14,  4 },
   { 10,  4, 14 },
   { 10, 11,  7 },
   { 10, 14,  3 },
   { 10, 12,  5 },
   { 10, 13,  6 },
   { 10, 12,  6 },
   { 10,  8,  0 },
   { 10, 11,  8 },
   { 10,  2, 12 },
   { 10,  9,  9 },
   { 10, 14,  5 },
   { 10,  6, 13 },
   { 10, 10, 10 },
   { 10, 15,  2 },
   { 10,  8, 11 },
   { 10,  9, 10 },
   { 10, 14,  6 },
   { 10, 10,  9 },
   { 10,  5, 14 },
   { 10, 11,  9 },
   { 10, 14,  1 },
   { 10,  2, 14 },
   { 10,  6, 12 },
   { 10,  1, 12 },
   { 10, 13,  8 },
   { 10,  0,  8 },
   { 10, 13,  7 },
   { 10,  7, 12 },
   { 10, 12,  7 },
   { 10,  7, 13 },
   { 10, 15,  3 },
   { 10, 12,  1 },
   { 10,  6, 14 },
   { 10,  2, 15 },
   { 10, 15,  5 },
   { 10, 15,  4 },
   { 10,  1, 14 },
   { 10,  9, 11 },
   { 10,  4, 15 },
   { 10, 14,  7 },
   { 10,  8, 13 },
   { 10, 13,  9 },
   { 10,  8, 12 },
   { 10,  5, 15 },
   { 10,  3, 15 },
   { 10, 10, 11 },
   { 10, 11, 10 },
   { 10, 12,  8 },
   { 10, 15,  6 },
   { 10, 15,  7 },
   { 10,  8, 14 },
   { 10, 15,  1 },
   { 10,  7, 14 },
   { 10,  9,  0 },
   { 10,  0,  9 },

   /* 10/11/12 */
   { 10,  9, 13 }, { 10,  9, 13 }, { 10,  9, 13 }, { 10,  9, 13 },
   { 10,  9, 12 }, { 10,  9, 12 }, { 10,  9, 12 }, { 10,  9, 12 },
   { 10, 12,  9 }, { 10, 12,  9 }, { 10, 12,  9 }, { 10, 12,  9 },
   { 10, 14,  8 }, { 10, 14,  8 }, { 10, 14,  8 }, { 10, 14,  8 },
   { 10, 10, 13 }, { 10, 10, 13 }, { 10, 10, 13 }, { 10, 10, 13 },
   { 10, 14,  9 }, { 10, 14,  9 }, { 10, 14,  9 }, { 10, 14,  9 },
   { 10, 12, 10 }, { 10, 12, 10 }, { 10, 12, 10 }, { 10, 12, 10 },
   { 10,  6, 15 }, { 10,  6, 15 }, { 10,  6, 15 }, { 10,  6, 15 },
   { 10,  7, 15 }, { 10,  7, 15 }, { 10,  7, 15 }, { 10,  7, 15 },

   { 11,  9, 14 }, { 11,  9, 14 },
   { 11, 15,  8 }, { 11, 15,  8 },
   { 11, 11, 11 }, { 11, 11, 11 },
   { 11, 11, 14 }, { 11, 11, 14 },
   { 11,  1, 15 }, { 11,  1, 15 },
   { 11, 10, 12 }, { 11, 10, 12 },
   { 11, 10, 14 }, { 11, 10, 14 },
   { 11, 13, 11 }, { 11, 13, 11 },
   { 11, 13, 10 }, { 11, 13, 10 },
   { 11, 11, 13 }, { 11, 11, 13 },
   { 11, 11, 12 }, { 11, 11, 12 },
   { 11,  8, 15 }, { 11,  8, 15 },
   { 11, 14, 11 }, { 11, 14, 11 },
   { 11, 13, 12 }, { 11, 13, 12 },
   { 11, 12, 13 }, { 11, 12, 13 },
   { 11, 15,  9 }, { 11, 15,  9 },
   { 11, 14, 10 }, { 11, 14, 10 },
   { 11, 10,  0 }, { 11, 10,  0 },
   { 11, 12, 11 }, { 11, 12, 11 },
   { 11,  9, 15 }, { 11,  9, 15 },
   { 11,  0, 10 }, { 11,  0, 10 },
   { 11, 12, 12 }, { 11, 12, 12 },
   { 11, 11,  0 }, { 11, 11,  0 },
   { 11, 12, 14 }, { 11, 12, 14 },
   { 11, 10, 15 }, { 11, 10, 15 },
   { 11, 13, 13 }, { 11, 13, 13 },
   { 11,  0, 13 }, { 11,  0, 13 },
   { 11, 14, 12 }, { 11, 14, 12 },
   { 11, 15, 10 }, { 11, 15, 10 },
   { 11, 15, 11 }, { 11, 15, 11 },
   { 11, 11, 15 }, { 11, 11, 15 },
   { 11, 14, 13 }, { 11, 14, 13 },
   { 11, 13,  0 }, { 11, 13,  0 },
   { 11,  0, 11 }, { 11,  0, 11 },
   { 11, 13, 14 }, { 11, 13, 14 },
   { 11, 15, 12 }, { 11, 15, 12 },
   { 11, 15, 13 }, { 11, 15, 13 },
   { 11, 12, 15 }, { 11, 12, 15 },
   { 11, 14,  0 }, { 11, 14,  0 },
   { 11, 14, 14 }, { 11, 14, 14 },
   { 11, 13, 15 }, { 11, 13, 15 },
   { 11, 12,  0 }, { 11, 12,  0 },
   { 11, 14, 15 }, { 11, 14, 15 },
   { 12,  0, 14 },
   { 12,  0, 12 },
   { 12, 15, 14 },
   { 12, 15,  0 },
   { 12,  0, 15 },
   { 12, 15, 15 }
};



/* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -
   Codebook list
*/



static const MLO_HcbPair_Index   MLO_HcbPair_cookbook_index [MLO_HCB_ESC_HCB + 1] =
{
   { 0, 0, 0 },
   { 0, 0, 0 },
   { 0, 0, 0 },
   { 0, 0, 0 },
   { 0, 0, 0 },
   { MLO_HcbPair_coodbook_5, 0, 0 },
   { 0, MLO_HcbPair_coodbook_6_1, MLO_HcbPair_coodbook_6_2 },
   { MLO_HcbPair_coodbook_7, 0, 0 },
   { 0, MLO_HcbPair_coodbook_8_1, MLO_HcbPair_coodbook_8_2 },
   { MLO_HcbPair_coodbook_9, 0, 0 },
   { 0, MLO_HcbPair_coodbook_10_1, MLO_HcbPair_coodbook_10_2 },
   { 0, MLO_HcbPair_coodbook_11_1, MLO_HcbPair_coodbook_11_2 }
};



/*----------------------------------------------------------------------
|       Functions
+---------------------------------------------------------------------*/



/*
==============================================================================
Name: MLO_HcbPair_decode_binary
Description:
   Decodes 2 Huffman-compressed values from the stream, using the binary
   search tree method.
Input parameters:
	- data_ptr: Points on the first value location in the spectral data array.
	- hcb: Huffman CodeBook to use. Only Codebooks 5, 7 and 9 are allowed.
Input/output parameters:
	- bit_ptr: Input bitstream to decode.
==============================================================================
*/

void
MLO_HcbPair_decode_binary (MLO_Int16 data_ptr [2], MLO_BitStream *bit_ptr, MLO_Hcb hcb)
{
    unsigned int offset = 0;
    const MLO_HcbPair_Binary * table_ptr;

	MLO_ASSERT(data_ptr != NULL);
	MLO_ASSERT(bit_ptr != NULL);
    MLO_ASSERT(hcb >= MLO_HCB_FIRST_PAIR_HCB);
    MLO_ASSERT(hcb <= MLO_HCB_ESC_HCB);

   table_ptr = MLO_HcbPair_cookbook_index [hcb].bin_ptr;
   MLO_ASSERT (table_ptr != NULL);

   while (! table_ptr [offset].leaf_flag)
   {
      unsigned int bit = MLO_BitStream_ReadBit (bit_ptr);
      offset += table_ptr [offset].data [bit];
   }

   data_ptr [0] = table_ptr [offset].data [0];
   data_ptr [1] = table_ptr [offset].data [1];
}



/*
==============================================================================
Name: MLO_HcbPair_decode_2steps
Description:
   Decodes 2 Huffman-compressed values from the stream, using the 2-step
   method.
Input parameters:
	- data_ptr: Points on the first value location in the spectral data array.
	- hcb: Huffman CodeBook to use. Only Codebooks 6, 8, 10 and 11 are allowed.
Input/output parameters:
	- bit_ptr: Input bitstream to decode.
==============================================================================
*/

void  
MLO_HcbPair_decode_2steps (MLO_Int16 data_ptr [2], MLO_BitStream *bit_ptr, MLO_Hcb hcb)
{
   int            offset = 0;
   int            nbr_bits = (hcb == 10) ? 6 : 5;
   int            cw;
   int            extra_bits;
   const MLO_HcbPair_Step1 *  table_1_ptr;
   const MLO_HcbPair_Step2 *  table_2_ptr;

   MLO_ASSERT(data_ptr != NULL);
   MLO_ASSERT(bit_ptr != NULL);
   MLO_ASSERT(hcb >= MLO_HCB_FIRST_PAIR_HCB);
   MLO_ASSERT(hcb <= MLO_HCB_ESC_HCB);

   table_1_ptr = MLO_HcbPair_cookbook_index [hcb].step_1_ptr;
   table_2_ptr = MLO_HcbPair_cookbook_index [hcb].step_2_ptr;
   MLO_ASSERT (table_1_ptr != NULL);
   MLO_ASSERT (table_2_ptr != NULL);

   cw = MLO_BitStream_PeekBits (bit_ptr, nbr_bits);

   offset     = table_1_ptr [cw].offset;
   extra_bits = table_1_ptr [cw].extra_bits;

   if (extra_bits == 0)
   {
      MLO_BitStream_SkipBits (bit_ptr, table_2_ptr [offset].bits);
   }
   else
   {
      MLO_BitStream_SkipBits (bit_ptr, nbr_bits);
      offset += MLO_BitStream_PeekBits (bit_ptr, extra_bits);
      MLO_BitStream_SkipBits (bit_ptr, table_2_ptr [offset].bits - nbr_bits);
   }

   data_ptr [0] = table_2_ptr [offset].x;
   data_ptr [1] = table_2_ptr [offset].y;
}
