/*****************************************************************
|
|    Copyright 2004-2006 Axiomatic Systems LLC
|
|    This file is part of Melo (Melo AAC Decoder).
|
|    Unless you have obtained Melo under a difference license,
|    this version of Melo is Melo|GPL.
|    Melo|GPL is free software; you can redistribute it and/or modify
|    it under the terms of the GNU General Public License as published by
|    the Free Software Foundation; either version 2, or (at your option)
|    any later version.
|
|    Melo|GPL is distributed in the hope that it will be useful,
|    but WITHOUT ANY WARRANTY; without even the implied warranty of
|    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|    GNU General Public License for more details.
|
|    You should have received a copy of the GNU General Public License
|    along with Melo|GPL; see the file COPYING.  If not, write to the
|    Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
|    02111-1307, USA.
|
 ****************************************************************/

/*----------------------------------------------------------------------
|       Includes
+---------------------------------------------------------------------*/
#include "MloDebug.h"
#include "MloDefs.h"
#include "MloFloat.h"
#include "MloImdct.h"
#include "MloResults.h"
#include "MloUtils.h"

/*----------------------------------------------------------------------
|       Data
+---------------------------------------------------------------------*/

/*
f (k) = cos (PI * (k*2+1) / (len*4))
with k in [0 ; len[
*/
static const MLO_Float MLO_Imdct_cos_table_1 [MLO_DEFS_FRAME_LEN_LONG] =
{
   MLO_FLOAT_C (0.999999706),
   MLO_FLOAT_C (0.999997353),
   MLO_FLOAT_C (0.999992647),
   MLO_FLOAT_C (0.999985587),
   MLO_FLOAT_C (0.999976175),
   MLO_FLOAT_C (0.99996441),
   MLO_FLOAT_C (0.999950291),
   MLO_FLOAT_C (0.99993382),
   MLO_FLOAT_C (0.999914996),
   MLO_FLOAT_C (0.999893818),
   MLO_FLOAT_C (0.999870288),
   MLO_FLOAT_C (0.999844405),
   MLO_FLOAT_C (0.99981617),
   MLO_FLOAT_C (0.999785582),
   MLO_FLOAT_C (0.999752641),
   MLO_FLOAT_C (0.999717348),
   MLO_FLOAT_C (0.999679702),
   MLO_FLOAT_C (0.999639704),
   MLO_FLOAT_C (0.999597353),
   MLO_FLOAT_C (0.999552651),
   MLO_FLOAT_C (0.999505596),
   MLO_FLOAT_C (0.99945619),
   MLO_FLOAT_C (0.999404431),
   MLO_FLOAT_C (0.999350321),
   MLO_FLOAT_C (0.99929386),
   MLO_FLOAT_C (0.999235047),
   MLO_FLOAT_C (0.999173883),
   MLO_FLOAT_C (0.999110367),
   MLO_FLOAT_C (0.999044501),
   MLO_FLOAT_C (0.998976283),
   MLO_FLOAT_C (0.998905715),
   MLO_FLOAT_C (0.998832797),
   MLO_FLOAT_C (0.998757528),
   MLO_FLOAT_C (0.998679909),
   MLO_FLOAT_C (0.99859994),
   MLO_FLOAT_C (0.998517621),
   MLO_FLOAT_C (0.998432953),
   MLO_FLOAT_C (0.998345935),
   MLO_FLOAT_C (0.998256568),
   MLO_FLOAT_C (0.998164852),
   MLO_FLOAT_C (0.998070787),
   MLO_FLOAT_C (0.997974374),
   MLO_FLOAT_C (0.997875612),
   MLO_FLOAT_C (0.997774502),
   MLO_FLOAT_C (0.997671044),
   MLO_FLOAT_C (0.997565239),
   MLO_FLOAT_C (0.997457086),
   MLO_FLOAT_C (0.997346587),
   MLO_FLOAT_C (0.99723374),
   MLO_FLOAT_C (0.997118547),
   MLO_FLOAT_C (0.997001007),
   MLO_FLOAT_C (0.996881122),
   MLO_FLOAT_C (0.99675889),
   MLO_FLOAT_C (0.996634314),
   MLO_FLOAT_C (0.996507392),
   MLO_FLOAT_C (0.996378125),
   MLO_FLOAT_C (0.996246513),
   MLO_FLOAT_C (0.996112558),
   MLO_FLOAT_C (0.995976258),
   MLO_FLOAT_C (0.995837615),
   MLO_FLOAT_C (0.995696628),
   MLO_FLOAT_C (0.995553299),
   MLO_FLOAT_C (0.995407627),
   MLO_FLOAT_C (0.995259612),
   MLO_FLOAT_C (0.995109256),
   MLO_FLOAT_C (0.994956558),
   MLO_FLOAT_C (0.994801519),
   MLO_FLOAT_C (0.994644138),
   MLO_FLOAT_C (0.994484418),
   MLO_FLOAT_C (0.994322357),
   MLO_FLOAT_C (0.994157957),
   MLO_FLOAT_C (0.993991217),
   MLO_FLOAT_C (0.993822138),
   MLO_FLOAT_C (0.993650721),
   MLO_FLOAT_C (0.993476966),
   MLO_FLOAT_C (0.993300872),
   MLO_FLOAT_C (0.993122442),
   MLO_FLOAT_C (0.992941674),
   MLO_FLOAT_C (0.99275857),
   MLO_FLOAT_C (0.99257313),
   MLO_FLOAT_C (0.992385355),
   MLO_FLOAT_C (0.992195244),
   MLO_FLOAT_C (0.992002799),
   MLO_FLOAT_C (0.991808019),
   MLO_FLOAT_C (0.991610905),
   MLO_FLOAT_C (0.991411458),
   MLO_FLOAT_C (0.991209678),
   MLO_FLOAT_C (0.991005566),
   MLO_FLOAT_C (0.990799122),
   MLO_FLOAT_C (0.990590346),
   MLO_FLOAT_C (0.99037924),
   MLO_FLOAT_C (0.990165803),
   MLO_FLOAT_C (0.989950036),
   MLO_FLOAT_C (0.989731939),
   MLO_FLOAT_C (0.989511514),
   MLO_FLOAT_C (0.98928876),
   MLO_FLOAT_C (0.989063678),
   MLO_FLOAT_C (0.988836269),
   MLO_FLOAT_C (0.988606533),
   MLO_FLOAT_C (0.988374471),
   MLO_FLOAT_C (0.988140083),
   MLO_FLOAT_C (0.98790337),
   MLO_FLOAT_C (0.987664332),
   MLO_FLOAT_C (0.98742297),
   MLO_FLOAT_C (0.987179285),
   MLO_FLOAT_C (0.986933277),
   MLO_FLOAT_C (0.986684946),
   MLO_FLOAT_C (0.986434294),
   MLO_FLOAT_C (0.98618132),
   MLO_FLOAT_C (0.985926026),
   MLO_FLOAT_C (0.985668412),
   MLO_FLOAT_C (0.985408479),
   MLO_FLOAT_C (0.985146226),
   MLO_FLOAT_C (0.984881656),
   MLO_FLOAT_C (0.984614768),
   MLO_FLOAT_C (0.984345563),
   MLO_FLOAT_C (0.984074042),
   MLO_FLOAT_C (0.983800206),
   MLO_FLOAT_C (0.983524054),
   MLO_FLOAT_C (0.983245588),
   MLO_FLOAT_C (0.982964808),
   MLO_FLOAT_C (0.982681716),
   MLO_FLOAT_C (0.982396311),
   MLO_FLOAT_C (0.982108594),
   MLO_FLOAT_C (0.981818566),
   MLO_FLOAT_C (0.981526228),
   MLO_FLOAT_C (0.981231581),
   MLO_FLOAT_C (0.980934624),
   MLO_FLOAT_C (0.98063536),
   MLO_FLOAT_C (0.980333787),
   MLO_FLOAT_C (0.980029908),
   MLO_FLOAT_C (0.979723723),
   MLO_FLOAT_C (0.979415232),
   MLO_FLOAT_C (0.979104437),
   MLO_FLOAT_C (0.978791338),
   MLO_FLOAT_C (0.978475935),
   MLO_FLOAT_C (0.978158231),
   MLO_FLOAT_C (0.977838224),
   MLO_FLOAT_C (0.977515917),
   MLO_FLOAT_C (0.977191309),
   MLO_FLOAT_C (0.976864402),
   MLO_FLOAT_C (0.976535196),
   MLO_FLOAT_C (0.976203692),
   MLO_FLOAT_C (0.975869892),
   MLO_FLOAT_C (0.975533795),
   MLO_FLOAT_C (0.975195402),
   MLO_FLOAT_C (0.974854715),
   MLO_FLOAT_C (0.974511733),
   MLO_FLOAT_C (0.974166459),
   MLO_FLOAT_C (0.973818892),
   MLO_FLOAT_C (0.973469034),
   MLO_FLOAT_C (0.973116885),
   MLO_FLOAT_C (0.972762447),
   MLO_FLOAT_C (0.972405719),
   MLO_FLOAT_C (0.972046703),
   MLO_FLOAT_C (0.9716854),
   MLO_FLOAT_C (0.97132181),
   MLO_FLOAT_C (0.970955935),
   MLO_FLOAT_C (0.970587775),
   MLO_FLOAT_C (0.970217331),
   MLO_FLOAT_C (0.969844604),
   MLO_FLOAT_C (0.969469595),
   MLO_FLOAT_C (0.969092305),
   MLO_FLOAT_C (0.968712734),
   MLO_FLOAT_C (0.968330884),
   MLO_FLOAT_C (0.967946756),
   MLO_FLOAT_C (0.967560349),
   MLO_FLOAT_C (0.967171666),
   MLO_FLOAT_C (0.966780707),
   MLO_FLOAT_C (0.966387473),
   MLO_FLOAT_C (0.965991965),
   MLO_FLOAT_C (0.965594184),
   MLO_FLOAT_C (0.965194131),
   MLO_FLOAT_C (0.964791807),
   MLO_FLOAT_C (0.964387212),
   MLO_FLOAT_C (0.963980348),
   MLO_FLOAT_C (0.963571216),
   MLO_FLOAT_C (0.963159817),
   MLO_FLOAT_C (0.962746151),
   MLO_FLOAT_C (0.962330219),
   MLO_FLOAT_C (0.961912023),
   MLO_FLOAT_C (0.961491564),
   MLO_FLOAT_C (0.961068842),
   MLO_FLOAT_C (0.960643859),
   MLO_FLOAT_C (0.960216615),
   MLO_FLOAT_C (0.959787112),
   MLO_FLOAT_C (0.95935535),
   MLO_FLOAT_C (0.958921331),
   MLO_FLOAT_C (0.958485055),
   MLO_FLOAT_C (0.958046524),
   MLO_FLOAT_C (0.957605739),
   MLO_FLOAT_C (0.9571627),
   MLO_FLOAT_C (0.956717409),
   MLO_FLOAT_C (0.956269866),
   MLO_FLOAT_C (0.955820074),
   MLO_FLOAT_C (0.955368032),
   MLO_FLOAT_C (0.954913742),
   MLO_FLOAT_C (0.954457206),
   MLO_FLOAT_C (0.953998423),
   MLO_FLOAT_C (0.953537396),
   MLO_FLOAT_C (0.953074124),
   MLO_FLOAT_C (0.95260861),
   MLO_FLOAT_C (0.952140855),
   MLO_FLOAT_C (0.951670859),
   MLO_FLOAT_C (0.951198623),
   MLO_FLOAT_C (0.95072415),
   MLO_FLOAT_C (0.950247439),
   MLO_FLOAT_C (0.949768492),
   MLO_FLOAT_C (0.94928731),
   MLO_FLOAT_C (0.948803895),
   MLO_FLOAT_C (0.948318247),
   MLO_FLOAT_C (0.947830367),
   MLO_FLOAT_C (0.947340257),
   MLO_FLOAT_C (0.946847918),
   MLO_FLOAT_C (0.946353351),
   MLO_FLOAT_C (0.945856557),
   MLO_FLOAT_C (0.945357537),
   MLO_FLOAT_C (0.944856293),
   MLO_FLOAT_C (0.944352826),
   MLO_FLOAT_C (0.943847136),
   MLO_FLOAT_C (0.943339225),
   MLO_FLOAT_C (0.942829095),
   MLO_FLOAT_C (0.942316746),
   MLO_FLOAT_C (0.941802179),
   MLO_FLOAT_C (0.941285397),
   MLO_FLOAT_C (0.9407664),
   MLO_FLOAT_C (0.940245188),
   MLO_FLOAT_C (0.939721765),
   MLO_FLOAT_C (0.93919613),
   MLO_FLOAT_C (0.938668285),
   MLO_FLOAT_C (0.938138231),
   MLO_FLOAT_C (0.93760597),
   MLO_FLOAT_C (0.937071502),
   MLO_FLOAT_C (0.93653483),
   MLO_FLOAT_C (0.935995954),
   MLO_FLOAT_C (0.935454875),
   MLO_FLOAT_C (0.934911595),
   MLO_FLOAT_C (0.934366115),
   MLO_FLOAT_C (0.933818436),
   MLO_FLOAT_C (0.93326856),
   MLO_FLOAT_C (0.932716488),
   MLO_FLOAT_C (0.932162222),
   MLO_FLOAT_C (0.931605761),
   MLO_FLOAT_C (0.931047109),
   MLO_FLOAT_C (0.930486266),
   MLO_FLOAT_C (0.929923233),
   MLO_FLOAT_C (0.929358012),
   MLO_FLOAT_C (0.928790604),
   MLO_FLOAT_C (0.928221011),
   MLO_FLOAT_C (0.927649233),
   MLO_FLOAT_C (0.927075273),
   MLO_FLOAT_C (0.926499131),
   MLO_FLOAT_C (0.925920809),
   MLO_FLOAT_C (0.925340308),
   MLO_FLOAT_C (0.92475763),
   MLO_FLOAT_C (0.924172775),
   MLO_FLOAT_C (0.923585746),
   MLO_FLOAT_C (0.922996544),
   MLO_FLOAT_C (0.92240517),
   MLO_FLOAT_C (0.921811625),
   MLO_FLOAT_C (0.921215911),
   MLO_FLOAT_C (0.92061803),
   MLO_FLOAT_C (0.920017982),
   MLO_FLOAT_C (0.919415769),
   MLO_FLOAT_C (0.918811393),
   MLO_FLOAT_C (0.918204855),
   MLO_FLOAT_C (0.917596156),
   MLO_FLOAT_C (0.916985298),
   MLO_FLOAT_C (0.916372282),
   MLO_FLOAT_C (0.91575711),
   MLO_FLOAT_C (0.915139783),
   MLO_FLOAT_C (0.914520303),
   MLO_FLOAT_C (0.913898671),
   MLO_FLOAT_C (0.913274888),
   MLO_FLOAT_C (0.912648956),
   MLO_FLOAT_C (0.912020877),
   MLO_FLOAT_C (0.911390651),
   MLO_FLOAT_C (0.910758281),
   MLO_FLOAT_C (0.910123768),
   MLO_FLOAT_C (0.909487113),
   MLO_FLOAT_C (0.908848318),
   MLO_FLOAT_C (0.908207385),
   MLO_FLOAT_C (0.907564314),
   MLO_FLOAT_C (0.906919108),
   MLO_FLOAT_C (0.906271768),
   MLO_FLOAT_C (0.905622295),
   MLO_FLOAT_C (0.904970691),
   MLO_FLOAT_C (0.904316958),
   MLO_FLOAT_C (0.903661097),
   MLO_FLOAT_C (0.903003109),
   MLO_FLOAT_C (0.902342996),
   MLO_FLOAT_C (0.901680761),
   MLO_FLOAT_C (0.901016403),
   MLO_FLOAT_C (0.900349925),
   MLO_FLOAT_C (0.899681329),
   MLO_FLOAT_C (0.899010616),
   MLO_FLOAT_C (0.898337787),
   MLO_FLOAT_C (0.897662844),
   MLO_FLOAT_C (0.896985789),
   MLO_FLOAT_C (0.896306624),
   MLO_FLOAT_C (0.895625349),
   MLO_FLOAT_C (0.894941967),
   MLO_FLOAT_C (0.894256478),
   MLO_FLOAT_C (0.893568886),
   MLO_FLOAT_C (0.892879191),
   MLO_FLOAT_C (0.892187395),
   MLO_FLOAT_C (0.891493499),
   MLO_FLOAT_C (0.890797506),
   MLO_FLOAT_C (0.890099417),
   MLO_FLOAT_C (0.889399233),
   MLO_FLOAT_C (0.888696956),
   MLO_FLOAT_C (0.887992588),
   MLO_FLOAT_C (0.887286131),
   MLO_FLOAT_C (0.886577585),
   MLO_FLOAT_C (0.885866954),
   MLO_FLOAT_C (0.885154238),
   MLO_FLOAT_C (0.884439439),
   MLO_FLOAT_C (0.883722559),
   MLO_FLOAT_C (0.883003599),
   MLO_FLOAT_C (0.882282562),
   MLO_FLOAT_C (0.881559448),
   MLO_FLOAT_C (0.88083426),
   MLO_FLOAT_C (0.880107),
   MLO_FLOAT_C (0.879377668),
   MLO_FLOAT_C (0.878646267),
   MLO_FLOAT_C (0.877912799),
   MLO_FLOAT_C (0.877177265),
   MLO_FLOAT_C (0.876439667),
   MLO_FLOAT_C (0.875700006),
   MLO_FLOAT_C (0.874958285),
   MLO_FLOAT_C (0.874214505),
   MLO_FLOAT_C (0.873468668),
   MLO_FLOAT_C (0.872720775),
   MLO_FLOAT_C (0.871970829),
   MLO_FLOAT_C (0.871218831),
   MLO_FLOAT_C (0.870464783),
   MLO_FLOAT_C (0.869708687),
   MLO_FLOAT_C (0.868950544),
   MLO_FLOAT_C (0.868190357),
   MLO_FLOAT_C (0.867428126),
   MLO_FLOAT_C (0.866663855),
   MLO_FLOAT_C (0.865897544),
   MLO_FLOAT_C (0.865129195),
   MLO_FLOAT_C (0.864358811),
   MLO_FLOAT_C (0.863586393),
   MLO_FLOAT_C (0.862811943),
   MLO_FLOAT_C (0.862035462),
   MLO_FLOAT_C (0.861256953),
   MLO_FLOAT_C (0.860476418),
   MLO_FLOAT_C (0.859693857),
   MLO_FLOAT_C (0.858909274),
   MLO_FLOAT_C (0.85812267),
   MLO_FLOAT_C (0.857334046),
   MLO_FLOAT_C (0.856543405),
   MLO_FLOAT_C (0.855750748),
   MLO_FLOAT_C (0.854956078),
   MLO_FLOAT_C (0.854159396),
   MLO_FLOAT_C (0.853360704),
   MLO_FLOAT_C (0.852560004),
   MLO_FLOAT_C (0.851757298),
   MLO_FLOAT_C (0.850952587),
   MLO_FLOAT_C (0.850145875),
   MLO_FLOAT_C (0.849337161),
   MLO_FLOAT_C (0.84852645),
   MLO_FLOAT_C (0.847713741),
   MLO_FLOAT_C (0.846899038),
   MLO_FLOAT_C (0.846082342),
   MLO_FLOAT_C (0.845263655),
   MLO_FLOAT_C (0.844442979),
   MLO_FLOAT_C (0.843620316),
   MLO_FLOAT_C (0.842795668),
   MLO_FLOAT_C (0.841969036),
   MLO_FLOAT_C (0.841140424),
   MLO_FLOAT_C (0.840309832),
   MLO_FLOAT_C (0.839477263),
   MLO_FLOAT_C (0.838642718),
   MLO_FLOAT_C (0.8378062),
   MLO_FLOAT_C (0.836967711),
   MLO_FLOAT_C (0.836127252),
   MLO_FLOAT_C (0.835284825),
   MLO_FLOAT_C (0.834440433),
   MLO_FLOAT_C (0.833594078),
   MLO_FLOAT_C (0.832745761),
   MLO_FLOAT_C (0.831895485),
   MLO_FLOAT_C (0.831043251),
   MLO_FLOAT_C (0.830189061),
   MLO_FLOAT_C (0.829332918),
   MLO_FLOAT_C (0.828474824),
   MLO_FLOAT_C (0.82761478),
   MLO_FLOAT_C (0.826752788),
   MLO_FLOAT_C (0.825888851),
   MLO_FLOAT_C (0.825022971),
   MLO_FLOAT_C (0.824155149),
   MLO_FLOAT_C (0.823285388),
   MLO_FLOAT_C (0.82241369),
   MLO_FLOAT_C (0.821540057),
   MLO_FLOAT_C (0.82066449),
   MLO_FLOAT_C (0.819786992),
   MLO_FLOAT_C (0.818907566),
   MLO_FLOAT_C (0.818026212),
   MLO_FLOAT_C (0.817142933),
   MLO_FLOAT_C (0.816257732),
   MLO_FLOAT_C (0.81537061),
   MLO_FLOAT_C (0.814481569),
   MLO_FLOAT_C (0.813590612),
   MLO_FLOAT_C (0.81269774),
   MLO_FLOAT_C (0.811802956),
   MLO_FLOAT_C (0.810906261),
   MLO_FLOAT_C (0.810007659),
   MLO_FLOAT_C (0.80910715),
   MLO_FLOAT_C (0.808204737),
   MLO_FLOAT_C (0.807300423),
   MLO_FLOAT_C (0.806394209),
   MLO_FLOAT_C (0.805486098),
   MLO_FLOAT_C (0.804576091),
   MLO_FLOAT_C (0.803664191),
   MLO_FLOAT_C (0.8027504),
   MLO_FLOAT_C (0.801834719),
   MLO_FLOAT_C (0.800917153),
   MLO_FLOAT_C (0.799997701),
   MLO_FLOAT_C (0.799076367),
   MLO_FLOAT_C (0.798153153),
   MLO_FLOAT_C (0.79722806),
   MLO_FLOAT_C (0.796301092),
   MLO_FLOAT_C (0.795372249),
   MLO_FLOAT_C (0.794441536),
   MLO_FLOAT_C (0.793508952),
   MLO_FLOAT_C (0.792574502),
   MLO_FLOAT_C (0.791638187),
   MLO_FLOAT_C (0.790700008),
   MLO_FLOAT_C (0.78975997),
   MLO_FLOAT_C (0.788818072),
   MLO_FLOAT_C (0.787874319),
   MLO_FLOAT_C (0.786928712),
   MLO_FLOAT_C (0.785981253),
   MLO_FLOAT_C (0.785031944),
   MLO_FLOAT_C (0.784080789),
   MLO_FLOAT_C (0.783127788),
   MLO_FLOAT_C (0.782172944),
   MLO_FLOAT_C (0.78121626),
   MLO_FLOAT_C (0.780257738),
   MLO_FLOAT_C (0.779297379),
   MLO_FLOAT_C (0.778335187),
   MLO_FLOAT_C (0.777371164),
   MLO_FLOAT_C (0.776405311),
   MLO_FLOAT_C (0.775437631),
   MLO_FLOAT_C (0.774468126),
   MLO_FLOAT_C (0.773496799),
   MLO_FLOAT_C (0.772523652),
   MLO_FLOAT_C (0.771548688),
   MLO_FLOAT_C (0.770571907),
   MLO_FLOAT_C (0.769593314),
   MLO_FLOAT_C (0.768612909),
   MLO_FLOAT_C (0.767630696),
   MLO_FLOAT_C (0.766646677),
   MLO_FLOAT_C (0.765660853),
   MLO_FLOAT_C (0.764673228),
   MLO_FLOAT_C (0.763683804),
   MLO_FLOAT_C (0.762692582),
   MLO_FLOAT_C (0.761699566),
   MLO_FLOAT_C (0.760704757),
   MLO_FLOAT_C (0.759708159),
   MLO_FLOAT_C (0.758709773),
   MLO_FLOAT_C (0.757709601),
   MLO_FLOAT_C (0.756707647),
   MLO_FLOAT_C (0.755703911),
   MLO_FLOAT_C (0.754698398),
   MLO_FLOAT_C (0.753691109),
   MLO_FLOAT_C (0.752682046),
   MLO_FLOAT_C (0.751671212),
   MLO_FLOAT_C (0.75065861),
   MLO_FLOAT_C (0.749644241),
   MLO_FLOAT_C (0.748628108),
   MLO_FLOAT_C (0.747610213),
   MLO_FLOAT_C (0.746590559),
   MLO_FLOAT_C (0.745569149),
   MLO_FLOAT_C (0.744545984),
   MLO_FLOAT_C (0.743521067),
   MLO_FLOAT_C (0.7424944),
   MLO_FLOAT_C (0.741465987),
   MLO_FLOAT_C (0.740435828),
   MLO_FLOAT_C (0.739403927),
   MLO_FLOAT_C (0.738370287),
   MLO_FLOAT_C (0.737334909),
   MLO_FLOAT_C (0.736297796),
   MLO_FLOAT_C (0.73525895),
   MLO_FLOAT_C (0.734218374),
   MLO_FLOAT_C (0.733176071),
   MLO_FLOAT_C (0.732132042),
   MLO_FLOAT_C (0.73108629),
   MLO_FLOAT_C (0.730038818),
   MLO_FLOAT_C (0.728989629),
   MLO_FLOAT_C (0.727938724),
   MLO_FLOAT_C (0.726886106),
   MLO_FLOAT_C (0.725831777),
   MLO_FLOAT_C (0.724775741),
   MLO_FLOAT_C (0.723717999),
   MLO_FLOAT_C (0.722658554),
   MLO_FLOAT_C (0.721597409),
   MLO_FLOAT_C (0.720534566),
   MLO_FLOAT_C (0.719470027),
   MLO_FLOAT_C (0.718403795),
   MLO_FLOAT_C (0.717335873),
   MLO_FLOAT_C (0.716266263),
   MLO_FLOAT_C (0.715194967),
   MLO_FLOAT_C (0.714121988),
   MLO_FLOAT_C (0.713047329),
   MLO_FLOAT_C (0.711970993),
   MLO_FLOAT_C (0.71089298),
   MLO_FLOAT_C (0.709813295),
   MLO_FLOAT_C (0.70873194),
   MLO_FLOAT_C (0.707648917),
   MLO_FLOAT_C (0.706564229),
   MLO_FLOAT_C (0.705477878),
   MLO_FLOAT_C (0.704389868),
   MLO_FLOAT_C (0.703300199),
   MLO_FLOAT_C (0.702208876),
   MLO_FLOAT_C (0.701115901),
   MLO_FLOAT_C (0.700021275),
   MLO_FLOAT_C (0.698925003),
   MLO_FLOAT_C (0.697827085),
   MLO_FLOAT_C (0.696727526),
   MLO_FLOAT_C (0.695626327),
   MLO_FLOAT_C (0.694523492),
   MLO_FLOAT_C (0.693419022),
   MLO_FLOAT_C (0.69231292),
   MLO_FLOAT_C (0.69120519),
   MLO_FLOAT_C (0.690095832),
   MLO_FLOAT_C (0.688984851),
   MLO_FLOAT_C (0.687872249),
   MLO_FLOAT_C (0.686758028),
   MLO_FLOAT_C (0.685642191),
   MLO_FLOAT_C (0.684524741),
   MLO_FLOAT_C (0.68340568),
   MLO_FLOAT_C (0.682285011),
   MLO_FLOAT_C (0.681162736),
   MLO_FLOAT_C (0.680038859),
   MLO_FLOAT_C (0.678913381),
   MLO_FLOAT_C (0.677786306),
   MLO_FLOAT_C (0.676657636),
   MLO_FLOAT_C (0.675527374),
   MLO_FLOAT_C (0.674395522),
   MLO_FLOAT_C (0.673262083),
   MLO_FLOAT_C (0.67212706),
   MLO_FLOAT_C (0.670990455),
   MLO_FLOAT_C (0.669852271),
   MLO_FLOAT_C (0.668712512),
   MLO_FLOAT_C (0.667571178),
   MLO_FLOAT_C (0.666428274),
   MLO_FLOAT_C (0.665283802),
   MLO_FLOAT_C (0.664137764),
   MLO_FLOAT_C (0.662990163),
   MLO_FLOAT_C (0.661841002),
   MLO_FLOAT_C (0.660690284),
   MLO_FLOAT_C (0.659538012),
   MLO_FLOAT_C (0.658384187),
   MLO_FLOAT_C (0.657228813),
   MLO_FLOAT_C (0.656071892),
   MLO_FLOAT_C (0.654913428),
   MLO_FLOAT_C (0.653753423),
   MLO_FLOAT_C (0.652591879),
   MLO_FLOAT_C (0.6514288),
   MLO_FLOAT_C (0.650264187),
   MLO_FLOAT_C (0.649098045),
   MLO_FLOAT_C (0.647930375),
   MLO_FLOAT_C (0.646761181),
   MLO_FLOAT_C (0.645590465),
   MLO_FLOAT_C (0.644418229),
   MLO_FLOAT_C (0.643244478),
   MLO_FLOAT_C (0.642069212),
   MLO_FLOAT_C (0.640892436),
   MLO_FLOAT_C (0.639714152),
   MLO_FLOAT_C (0.638534362),
   MLO_FLOAT_C (0.63735307),
   MLO_FLOAT_C (0.636170278),
   MLO_FLOAT_C (0.634985989),
   MLO_FLOAT_C (0.633800206),
   MLO_FLOAT_C (0.632612932),
   MLO_FLOAT_C (0.631424169),
   MLO_FLOAT_C (0.63023392),
   MLO_FLOAT_C (0.629042188),
   MLO_FLOAT_C (0.627848976),
   MLO_FLOAT_C (0.626654286),
   MLO_FLOAT_C (0.625458122),
   MLO_FLOAT_C (0.624260486),
   MLO_FLOAT_C (0.623061382),
   MLO_FLOAT_C (0.621860811),
   MLO_FLOAT_C (0.620658777),
   MLO_FLOAT_C (0.619455282),
   MLO_FLOAT_C (0.61825033),
   MLO_FLOAT_C (0.617043923),
   MLO_FLOAT_C (0.615836064),
   MLO_FLOAT_C (0.614626756),
   MLO_FLOAT_C (0.613416001),
   MLO_FLOAT_C (0.612203803),
   MLO_FLOAT_C (0.610990165),
   MLO_FLOAT_C (0.609775089),
   MLO_FLOAT_C (0.608558578),
   MLO_FLOAT_C (0.607340635),
   MLO_FLOAT_C (0.606121263),
   MLO_FLOAT_C (0.604900464),
   MLO_FLOAT_C (0.603678242),
   MLO_FLOAT_C (0.6024546),
   MLO_FLOAT_C (0.60122954),
   MLO_FLOAT_C (0.600003065),
   MLO_FLOAT_C (0.598775179),
   MLO_FLOAT_C (0.597545883),
   MLO_FLOAT_C (0.596315182),
   MLO_FLOAT_C (0.595083077),
   MLO_FLOAT_C (0.593849572),
   MLO_FLOAT_C (0.592614669),
   MLO_FLOAT_C (0.591378372),
   MLO_FLOAT_C (0.590140684),
   MLO_FLOAT_C (0.588901607),
   MLO_FLOAT_C (0.587661144),
   MLO_FLOAT_C (0.586419298),
   MLO_FLOAT_C (0.585176072),
   MLO_FLOAT_C (0.58393147),
   MLO_FLOAT_C (0.582685493),
   MLO_FLOAT_C (0.581438145),
   MLO_FLOAT_C (0.580189429),
   MLO_FLOAT_C (0.578939348),
   MLO_FLOAT_C (0.577687905),
   MLO_FLOAT_C (0.576435102),
   MLO_FLOAT_C (0.575180942),
   MLO_FLOAT_C (0.57392543),
   MLO_FLOAT_C (0.572668566),
   MLO_FLOAT_C (0.571410356),
   MLO_FLOAT_C (0.5701508),
   MLO_FLOAT_C (0.568889903),
   MLO_FLOAT_C (0.567627668),
   MLO_FLOAT_C (0.566364096),
   MLO_FLOAT_C (0.565099192),
   MLO_FLOAT_C (0.563832959),
   MLO_FLOAT_C (0.562565398),
   MLO_FLOAT_C (0.561296514),
   MLO_FLOAT_C (0.560026309),
   MLO_FLOAT_C (0.558754786),
   MLO_FLOAT_C (0.557481948),
   MLO_FLOAT_C (0.556207799),
   MLO_FLOAT_C (0.55493234),
   MLO_FLOAT_C (0.553655576),
   MLO_FLOAT_C (0.552377509),
   MLO_FLOAT_C (0.551098143),
   MLO_FLOAT_C (0.549817479),
   MLO_FLOAT_C (0.548535522),
   MLO_FLOAT_C (0.547252274),
   MLO_FLOAT_C (0.545967738),
   MLO_FLOAT_C (0.544681918),
   MLO_FLOAT_C (0.543394816),
   MLO_FLOAT_C (0.542106435),
   MLO_FLOAT_C (0.540816778),
   MLO_FLOAT_C (0.539525849),
   MLO_FLOAT_C (0.538233651),
   MLO_FLOAT_C (0.536940186),
   MLO_FLOAT_C (0.535645457),
   MLO_FLOAT_C (0.534349468),
   MLO_FLOAT_C (0.533052222),
   MLO_FLOAT_C (0.531753721),
   MLO_FLOAT_C (0.530453969),
   MLO_FLOAT_C (0.529152969),
   MLO_FLOAT_C (0.527850723),
   MLO_FLOAT_C (0.526547236),
   MLO_FLOAT_C (0.52524251),
   MLO_FLOAT_C (0.523936547),
   MLO_FLOAT_C (0.522629352),
   MLO_FLOAT_C (0.521320927),
   MLO_FLOAT_C (0.520011275),
   MLO_FLOAT_C (0.5187004),
   MLO_FLOAT_C (0.517388304),
   MLO_FLOAT_C (0.51607499),
   MLO_FLOAT_C (0.514760463),
   MLO_FLOAT_C (0.513444723),
   MLO_FLOAT_C (0.512127776),
   MLO_FLOAT_C (0.510809624),
   MLO_FLOAT_C (0.509490269),
   MLO_FLOAT_C (0.508169716),
   MLO_FLOAT_C (0.506847967),
   MLO_FLOAT_C (0.505525026),
   MLO_FLOAT_C (0.504200894),
   MLO_FLOAT_C (0.502875577),
   MLO_FLOAT_C (0.501549076),
   MLO_FLOAT_C (0.500221395),
   MLO_FLOAT_C (0.498892537),
   MLO_FLOAT_C (0.497562504),
   MLO_FLOAT_C (0.496231301),
   MLO_FLOAT_C (0.494898931),
   MLO_FLOAT_C (0.493565396),
   MLO_FLOAT_C (0.492230699),
   MLO_FLOAT_C (0.490894844),
   MLO_FLOAT_C (0.489557834),
   MLO_FLOAT_C (0.488219672),
   MLO_FLOAT_C (0.486880361),
   MLO_FLOAT_C (0.485539905),
   MLO_FLOAT_C (0.484198306),
   MLO_FLOAT_C (0.482855568),
   MLO_FLOAT_C (0.481511693),
   MLO_FLOAT_C (0.480166685),
   MLO_FLOAT_C (0.478820548),
   MLO_FLOAT_C (0.477473284),
   MLO_FLOAT_C (0.476124896),
   MLO_FLOAT_C (0.474775388),
   MLO_FLOAT_C (0.473424763),
   MLO_FLOAT_C (0.472073023),
   MLO_FLOAT_C (0.470720173),
   MLO_FLOAT_C (0.469366215),
   MLO_FLOAT_C (0.468011153),
   MLO_FLOAT_C (0.46665499),
   MLO_FLOAT_C (0.465297728),
   MLO_FLOAT_C (0.463939371),
   MLO_FLOAT_C (0.462579923),
   MLO_FLOAT_C (0.461219386),
   MLO_FLOAT_C (0.459857765),
   MLO_FLOAT_C (0.45849506),
   MLO_FLOAT_C (0.457131277),
   MLO_FLOAT_C (0.455766419),
   MLO_FLOAT_C (0.454400488),
   MLO_FLOAT_C (0.453033487),
   MLO_FLOAT_C (0.451665421),
   MLO_FLOAT_C (0.450296292),
   MLO_FLOAT_C (0.448926103),
   MLO_FLOAT_C (0.447554858),
   MLO_FLOAT_C (0.44618256),
   MLO_FLOAT_C (0.444809211),
   MLO_FLOAT_C (0.443434816),
   MLO_FLOAT_C (0.442059378),
   MLO_FLOAT_C (0.4406829),
   MLO_FLOAT_C (0.439305384),
   MLO_FLOAT_C (0.437926835),
   MLO_FLOAT_C (0.436547255),
   MLO_FLOAT_C (0.435166648),
   MLO_FLOAT_C (0.433785017),
   MLO_FLOAT_C (0.432402366),
   MLO_FLOAT_C (0.431018696),
   MLO_FLOAT_C (0.429634013),
   MLO_FLOAT_C (0.428248319),
   MLO_FLOAT_C (0.426861617),
   MLO_FLOAT_C (0.42547391),
   MLO_FLOAT_C (0.424085202),
   MLO_FLOAT_C (0.422695497),
   MLO_FLOAT_C (0.421304797),
   MLO_FLOAT_C (0.419913105),
   MLO_FLOAT_C (0.418520425),
   MLO_FLOAT_C (0.417126761),
   MLO_FLOAT_C (0.415732115),
   MLO_FLOAT_C (0.41433649),
   MLO_FLOAT_C (0.412939891),
   MLO_FLOAT_C (0.41154232),
   MLO_FLOAT_C (0.410143781),
   MLO_FLOAT_C (0.408744276),
   MLO_FLOAT_C (0.40734381),
   MLO_FLOAT_C (0.405942385),
   MLO_FLOAT_C (0.404540005),
   MLO_FLOAT_C (0.403136673),
   MLO_FLOAT_C (0.401732392),
   MLO_FLOAT_C (0.400327166),
   MLO_FLOAT_C (0.398920998),
   MLO_FLOAT_C (0.397513892),
   MLO_FLOAT_C (0.39610585),
   MLO_FLOAT_C (0.394696876),
   MLO_FLOAT_C (0.393286973),
   MLO_FLOAT_C (0.391876144),
   MLO_FLOAT_C (0.390464394),
   MLO_FLOAT_C (0.389051725),
   MLO_FLOAT_C (0.38763814),
   MLO_FLOAT_C (0.386223643),
   MLO_FLOAT_C (0.384808238),
   MLO_FLOAT_C (0.383391926),
   MLO_FLOAT_C (0.381974713),
   MLO_FLOAT_C (0.380556601),
   MLO_FLOAT_C (0.379137593),
   MLO_FLOAT_C (0.377717694),
   MLO_FLOAT_C (0.376296905),
   MLO_FLOAT_C (0.374875231),
   MLO_FLOAT_C (0.373452675),
   MLO_FLOAT_C (0.37202924),
   MLO_FLOAT_C (0.37060493),
   MLO_FLOAT_C (0.369179747),
   MLO_FLOAT_C (0.367753696),
   MLO_FLOAT_C (0.36632678),
   MLO_FLOAT_C (0.364899001),
   MLO_FLOAT_C (0.363470364),
   MLO_FLOAT_C (0.362040871),
   MLO_FLOAT_C (0.360610527),
   MLO_FLOAT_C (0.359179334),
   MLO_FLOAT_C (0.357747296),
   MLO_FLOAT_C (0.356314416),
   MLO_FLOAT_C (0.354880698),
   MLO_FLOAT_C (0.353446145),
   MLO_FLOAT_C (0.352010759),
   MLO_FLOAT_C (0.350574546),
   MLO_FLOAT_C (0.349137508),
   MLO_FLOAT_C (0.347699648),
   MLO_FLOAT_C (0.34626097),
   MLO_FLOAT_C (0.344821477),
   MLO_FLOAT_C (0.343381173),
   MLO_FLOAT_C (0.34194006),
   MLO_FLOAT_C (0.340498144),
   MLO_FLOAT_C (0.339055425),
   MLO_FLOAT_C (0.337611909),
   MLO_FLOAT_C (0.336167599),
   MLO_FLOAT_C (0.334722498),
   MLO_FLOAT_C (0.333276609),
   MLO_FLOAT_C (0.331829935),
   MLO_FLOAT_C (0.330382481),
   MLO_FLOAT_C (0.32893425),
   MLO_FLOAT_C (0.327485244),
   MLO_FLOAT_C (0.326035468),
   MLO_FLOAT_C (0.324584925),
   MLO_FLOAT_C (0.323133618),
   MLO_FLOAT_C (0.32168155),
   MLO_FLOAT_C (0.320228726),
   MLO_FLOAT_C (0.318775148),
   MLO_FLOAT_C (0.31732082),
   MLO_FLOAT_C (0.315865745),
   MLO_FLOAT_C (0.314409927),
   MLO_FLOAT_C (0.312953369),
   MLO_FLOAT_C (0.311496075),
   MLO_FLOAT_C (0.310038048),
   MLO_FLOAT_C (0.308579291),
   MLO_FLOAT_C (0.307119808),
   MLO_FLOAT_C (0.305659602),
   MLO_FLOAT_C (0.304198678),
   MLO_FLOAT_C (0.302737037),
   MLO_FLOAT_C (0.301274684),
   MLO_FLOAT_C (0.299811622),
   MLO_FLOAT_C (0.298347855),
   MLO_FLOAT_C (0.296883385),
   MLO_FLOAT_C (0.295418217),
   MLO_FLOAT_C (0.293952354),
   MLO_FLOAT_C (0.292485799),
   MLO_FLOAT_C (0.291018556),
   MLO_FLOAT_C (0.289550628),
   MLO_FLOAT_C (0.288082019),
   MLO_FLOAT_C (0.286612731),
   MLO_FLOAT_C (0.28514277),
   MLO_FLOAT_C (0.283672137),
   MLO_FLOAT_C (0.282200837),
   MLO_FLOAT_C (0.280728873),
   MLO_FLOAT_C (0.279256248),
   MLO_FLOAT_C (0.277782967),
   MLO_FLOAT_C (0.276309031),
   MLO_FLOAT_C (0.274834445),
   MLO_FLOAT_C (0.273359213),
   MLO_FLOAT_C (0.271883337),
   MLO_FLOAT_C (0.270406822),
   MLO_FLOAT_C (0.26892967),
   MLO_FLOAT_C (0.267451886),
   MLO_FLOAT_C (0.265973472),
   MLO_FLOAT_C (0.264494432),
   MLO_FLOAT_C (0.26301477),
   MLO_FLOAT_C (0.261534489),
   MLO_FLOAT_C (0.260053593),
   MLO_FLOAT_C (0.258572085),
   MLO_FLOAT_C (0.257089968),
   MLO_FLOAT_C (0.255607246),
   MLO_FLOAT_C (0.254123923),
   MLO_FLOAT_C (0.252640002),
   MLO_FLOAT_C (0.251155486),
   MLO_FLOAT_C (0.24967038),
   MLO_FLOAT_C (0.248184685),
   MLO_FLOAT_C (0.246698407),
   MLO_FLOAT_C (0.245211549),
   MLO_FLOAT_C (0.243724113),
   MLO_FLOAT_C (0.242236104),
   MLO_FLOAT_C (0.240747525),
   MLO_FLOAT_C (0.239258379),
   MLO_FLOAT_C (0.23776867),
   MLO_FLOAT_C (0.236278402),
   MLO_FLOAT_C (0.234787578),
   MLO_FLOAT_C (0.233296201),
   MLO_FLOAT_C (0.231804276),
   MLO_FLOAT_C (0.230311805),
   MLO_FLOAT_C (0.228818792),
   MLO_FLOAT_C (0.22732524),
   MLO_FLOAT_C (0.225831154),
   MLO_FLOAT_C (0.224336536),
   MLO_FLOAT_C (0.222841391),
   MLO_FLOAT_C (0.221345721),
   MLO_FLOAT_C (0.21984953),
   MLO_FLOAT_C (0.218352822),
   MLO_FLOAT_C (0.2168556),
   MLO_FLOAT_C (0.215357867),
   MLO_FLOAT_C (0.213859628),
   MLO_FLOAT_C (0.212360886),
   MLO_FLOAT_C (0.210861644),
   MLO_FLOAT_C (0.209361906),
   MLO_FLOAT_C (0.207861675),
   MLO_FLOAT_C (0.206360955),
   MLO_FLOAT_C (0.20485975),
   MLO_FLOAT_C (0.203358062),
   MLO_FLOAT_C (0.201855896),
   MLO_FLOAT_C (0.200353255),
   MLO_FLOAT_C (0.198850143),
   MLO_FLOAT_C (0.197346562),
   MLO_FLOAT_C (0.195842517),
   MLO_FLOAT_C (0.194338012),
   MLO_FLOAT_C (0.192833049),
   MLO_FLOAT_C (0.191327632),
   MLO_FLOAT_C (0.189821765),
   MLO_FLOAT_C (0.188315452),
   MLO_FLOAT_C (0.186808695),
   MLO_FLOAT_C (0.185301499),
   MLO_FLOAT_C (0.183793867),
   MLO_FLOAT_C (0.182285802),
   MLO_FLOAT_C (0.180777308),
   MLO_FLOAT_C (0.179268389),
   MLO_FLOAT_C (0.177759048),
   MLO_FLOAT_C (0.176249289),
   MLO_FLOAT_C (0.174739115),
   MLO_FLOAT_C (0.17322853),
   MLO_FLOAT_C (0.171717537),
   MLO_FLOAT_C (0.17020614),
   MLO_FLOAT_C (0.168694343),
   MLO_FLOAT_C (0.167182148),
   MLO_FLOAT_C (0.165669561),
   MLO_FLOAT_C (0.164156583),
   MLO_FLOAT_C (0.162643219),
   MLO_FLOAT_C (0.161129473),
   MLO_FLOAT_C (0.159615347),
   MLO_FLOAT_C (0.158100846),
   MLO_FLOAT_C (0.156585973),
   MLO_FLOAT_C (0.155070731),
   MLO_FLOAT_C (0.153555124),
   MLO_FLOAT_C (0.152039156),
   MLO_FLOAT_C (0.150522831),
   MLO_FLOAT_C (0.149006151),
   MLO_FLOAT_C (0.14748912),
   MLO_FLOAT_C (0.145971742),
   MLO_FLOAT_C (0.144454021),
   MLO_FLOAT_C (0.14293596),
   MLO_FLOAT_C (0.141417563),
   MLO_FLOAT_C (0.139898833),
   MLO_FLOAT_C (0.138379774),
   MLO_FLOAT_C (0.136860389),
   MLO_FLOAT_C (0.135340682),
   MLO_FLOAT_C (0.133820656),
   MLO_FLOAT_C (0.132300316),
   MLO_FLOAT_C (0.130779664),
   MLO_FLOAT_C (0.129258705),
   MLO_FLOAT_C (0.127737441),
   MLO_FLOAT_C (0.126215877),
   MLO_FLOAT_C (0.124694016),
   MLO_FLOAT_C (0.123171861),
   MLO_FLOAT_C (0.121649417),
   MLO_FLOAT_C (0.120126686),
   MLO_FLOAT_C (0.118603673),
   MLO_FLOAT_C (0.117080381),
   MLO_FLOAT_C (0.115556813),
   MLO_FLOAT_C (0.114032973),
   MLO_FLOAT_C (0.112508865),
   MLO_FLOAT_C (0.110984492),
   MLO_FLOAT_C (0.109459858),
   MLO_FLOAT_C (0.107934966),
   MLO_FLOAT_C (0.106409821),
   MLO_FLOAT_C (0.104884425),
   MLO_FLOAT_C (0.103358782),
   MLO_FLOAT_C (0.101832896),
   MLO_FLOAT_C (0.10030677),
   MLO_FLOAT_C (0.0987804085),
   MLO_FLOAT_C (0.0972538144),
   MLO_FLOAT_C (0.0957269915),
   MLO_FLOAT_C (0.0941999433),
   MLO_FLOAT_C (0.0926726734),
   MLO_FLOAT_C (0.0911451855),
   MLO_FLOAT_C (0.0896174831),
   MLO_FLOAT_C (0.0880895698),
   MLO_FLOAT_C (0.0865614492),
   MLO_FLOAT_C (0.085033125),
   MLO_FLOAT_C (0.0835046006),
   MLO_FLOAT_C (0.0819758798),
   MLO_FLOAT_C (0.0804469661),
   MLO_FLOAT_C (0.078917863),
   MLO_FLOAT_C (0.0773885743),
   MLO_FLOAT_C (0.0758591034),
   MLO_FLOAT_C (0.0743294541),
   MLO_FLOAT_C (0.0727996298),
   MLO_FLOAT_C (0.0712696343),
   MLO_FLOAT_C (0.069739471),
   MLO_FLOAT_C (0.0682091437),
   MLO_FLOAT_C (0.0666786558),
   MLO_FLOAT_C (0.065148011),
   MLO_FLOAT_C (0.063617213),
   MLO_FLOAT_C (0.0620862652),
   MLO_FLOAT_C (0.0605551713),
   MLO_FLOAT_C (0.059023935),
   MLO_FLOAT_C (0.0574925597),
   MLO_FLOAT_C (0.0559610492),
   MLO_FLOAT_C (0.054429407),
   MLO_FLOAT_C (0.0528976367),
   MLO_FLOAT_C (0.051365742),
   MLO_FLOAT_C (0.0498337263),
   MLO_FLOAT_C (0.0483015934),
   MLO_FLOAT_C (0.0467693469),
   MLO_FLOAT_C (0.0452369903),
   MLO_FLOAT_C (0.0437045273),
   MLO_FLOAT_C (0.0421719614),
   MLO_FLOAT_C (0.0406392962),
   MLO_FLOAT_C (0.0391065355),
   MLO_FLOAT_C (0.0375736827),
   MLO_FLOAT_C (0.0360407415),
   MLO_FLOAT_C (0.0345077155),
   MLO_FLOAT_C (0.0329746083),
   MLO_FLOAT_C (0.0314414235),
   MLO_FLOAT_C (0.0299081648),
   MLO_FLOAT_C (0.0283748356),
   MLO_FLOAT_C (0.0268414397),
   MLO_FLOAT_C (0.0253079806),
   MLO_FLOAT_C (0.023774462),
   MLO_FLOAT_C (0.0222408874),
   MLO_FLOAT_C (0.0207072605),
   MLO_FLOAT_C (0.0191735849),
   MLO_FLOAT_C (0.0176398641),
   MLO_FLOAT_C (0.0161061019),
   MLO_FLOAT_C (0.0145723017),
   MLO_FLOAT_C (0.0130384672),
   MLO_FLOAT_C (0.0115046021),
   MLO_FLOAT_C (0.00997070991),
   MLO_FLOAT_C (0.00843679424),
   MLO_FLOAT_C (0.00690285872),
   MLO_FLOAT_C (0.00536890696),
   MLO_FLOAT_C (0.00383494257),
   MLO_FLOAT_C (0.00230096915),
   MLO_FLOAT_C (0.000766990319)
};



/*
f (k) = cos (PI * k / (len*2))
with k in [0 ; len[
*/
static const MLO_Float MLO_Imdct_cos_table_2 [MLO_DEFS_FRAME_LEN_LONG] =
{
   MLO_FLOAT_C (1),
   MLO_FLOAT_C (0.999998823),
   MLO_FLOAT_C (0.999995294),
   MLO_FLOAT_C (0.999989411),
   MLO_FLOAT_C (0.999981175),
   MLO_FLOAT_C (0.999970586),
   MLO_FLOAT_C (0.999957645),
   MLO_FLOAT_C (0.99994235),
   MLO_FLOAT_C (0.999924702),
   MLO_FLOAT_C (0.999904701),
   MLO_FLOAT_C (0.999882347),
   MLO_FLOAT_C (0.999857641),
   MLO_FLOAT_C (0.999830582),
   MLO_FLOAT_C (0.99980117),
   MLO_FLOAT_C (0.999769405),
   MLO_FLOAT_C (0.999735288),
   MLO_FLOAT_C (0.999698819),
   MLO_FLOAT_C (0.999659997),
   MLO_FLOAT_C (0.999618822),
   MLO_FLOAT_C (0.999575296),
   MLO_FLOAT_C (0.999529418),
   MLO_FLOAT_C (0.999481187),
   MLO_FLOAT_C (0.999430605),
   MLO_FLOAT_C (0.99937767),
   MLO_FLOAT_C (0.999322385),
   MLO_FLOAT_C (0.999264747),
   MLO_FLOAT_C (0.999204759),
   MLO_FLOAT_C (0.999142419),
   MLO_FLOAT_C (0.999077728),
   MLO_FLOAT_C (0.999010686),
   MLO_FLOAT_C (0.998941293),
   MLO_FLOAT_C (0.99886955),
   MLO_FLOAT_C (0.998795456),
   MLO_FLOAT_C (0.998719012),
   MLO_FLOAT_C (0.998640218),
   MLO_FLOAT_C (0.998559074),
   MLO_FLOAT_C (0.998475581),
   MLO_FLOAT_C (0.998389737),
   MLO_FLOAT_C (0.998301545),
   MLO_FLOAT_C (0.998211003),
   MLO_FLOAT_C (0.998118113),
   MLO_FLOAT_C (0.998022874),
   MLO_FLOAT_C (0.997925286),
   MLO_FLOAT_C (0.99782535),
   MLO_FLOAT_C (0.997723067),
   MLO_FLOAT_C (0.997618435),
   MLO_FLOAT_C (0.997511456),
   MLO_FLOAT_C (0.99740213),
   MLO_FLOAT_C (0.997290457),
   MLO_FLOAT_C (0.997176437),
   MLO_FLOAT_C (0.99706007),
   MLO_FLOAT_C (0.996941358),
   MLO_FLOAT_C (0.996820299),
   MLO_FLOAT_C (0.996696895),
   MLO_FLOAT_C (0.996571146),
   MLO_FLOAT_C (0.996443051),
   MLO_FLOAT_C (0.996312612),
   MLO_FLOAT_C (0.996179829),
   MLO_FLOAT_C (0.996044701),
   MLO_FLOAT_C (0.995907229),
   MLO_FLOAT_C (0.995767414),
   MLO_FLOAT_C (0.995625256),
   MLO_FLOAT_C (0.995480755),
   MLO_FLOAT_C (0.995333912),
   MLO_FLOAT_C (0.995184727),
   MLO_FLOAT_C (0.995033199),
   MLO_FLOAT_C (0.994879331),
   MLO_FLOAT_C (0.994723121),
   MLO_FLOAT_C (0.994564571),
   MLO_FLOAT_C (0.99440368),
   MLO_FLOAT_C (0.994240449),
   MLO_FLOAT_C (0.994074879),
   MLO_FLOAT_C (0.99390697),
   MLO_FLOAT_C (0.993736722),
   MLO_FLOAT_C (0.993564136),
   MLO_FLOAT_C (0.993389211),
   MLO_FLOAT_C (0.993211949),
   MLO_FLOAT_C (0.99303235),
   MLO_FLOAT_C (0.992850414),
   MLO_FLOAT_C (0.992666142),
   MLO_FLOAT_C (0.992479535),
   MLO_FLOAT_C (0.992290591),
   MLO_FLOAT_C (0.992099313),
   MLO_FLOAT_C (0.9919057),
   MLO_FLOAT_C (0.991709754),
   MLO_FLOAT_C (0.991511473),
   MLO_FLOAT_C (0.99131086),
   MLO_FLOAT_C (0.991107914),
   MLO_FLOAT_C (0.990902635),
   MLO_FLOAT_C (0.990695025),
   MLO_FLOAT_C (0.990485084),
   MLO_FLOAT_C (0.990272812),
   MLO_FLOAT_C (0.99005821),
   MLO_FLOAT_C (0.989841278),
   MLO_FLOAT_C (0.989622017),
   MLO_FLOAT_C (0.989400428),
   MLO_FLOAT_C (0.98917651),
   MLO_FLOAT_C (0.988950265),
   MLO_FLOAT_C (0.988721692),
   MLO_FLOAT_C (0.988490793),
   MLO_FLOAT_C (0.988257568),
   MLO_FLOAT_C (0.988022017),
   MLO_FLOAT_C (0.987784142),
   MLO_FLOAT_C (0.987543942),
   MLO_FLOAT_C (0.987301418),
   MLO_FLOAT_C (0.987056571),
   MLO_FLOAT_C (0.986809402),
   MLO_FLOAT_C (0.98655991),
   MLO_FLOAT_C (0.986308097),
   MLO_FLOAT_C (0.986053963),
   MLO_FLOAT_C (0.985797509),
   MLO_FLOAT_C (0.985538735),
   MLO_FLOAT_C (0.985277642),
   MLO_FLOAT_C (0.985014231),
   MLO_FLOAT_C (0.984748502),
   MLO_FLOAT_C (0.984480455),
   MLO_FLOAT_C (0.984210092),
   MLO_FLOAT_C (0.983937413),
   MLO_FLOAT_C (0.983662419),
   MLO_FLOAT_C (0.98338511),
   MLO_FLOAT_C (0.983105487),
   MLO_FLOAT_C (0.982823551),
   MLO_FLOAT_C (0.982539302),
   MLO_FLOAT_C (0.982252741),
   MLO_FLOAT_C (0.981963869),
   MLO_FLOAT_C (0.981672686),
   MLO_FLOAT_C (0.981379193),
   MLO_FLOAT_C (0.981083391),
   MLO_FLOAT_C (0.98078528),
   MLO_FLOAT_C (0.980484862),
   MLO_FLOAT_C (0.980182136),
   MLO_FLOAT_C (0.979877104),
   MLO_FLOAT_C (0.979569766),
   MLO_FLOAT_C (0.979260123),
   MLO_FLOAT_C (0.978948175),
   MLO_FLOAT_C (0.978633924),
   MLO_FLOAT_C (0.978317371),
   MLO_FLOAT_C (0.977998515),
   MLO_FLOAT_C (0.977677358),
   MLO_FLOAT_C (0.9773539),
   MLO_FLOAT_C (0.977028143),
   MLO_FLOAT_C (0.976700086),
   MLO_FLOAT_C (0.976369731),
   MLO_FLOAT_C (0.976037079),
   MLO_FLOAT_C (0.97570213),
   MLO_FLOAT_C (0.975364885),
   MLO_FLOAT_C (0.975025345),
   MLO_FLOAT_C (0.974683511),
   MLO_FLOAT_C (0.974339383),
   MLO_FLOAT_C (0.973992962),
   MLO_FLOAT_C (0.97364425),
   MLO_FLOAT_C (0.973293246),
   MLO_FLOAT_C (0.972939952),
   MLO_FLOAT_C (0.972584369),
   MLO_FLOAT_C (0.972226497),
   MLO_FLOAT_C (0.971866337),
   MLO_FLOAT_C (0.971503891),
   MLO_FLOAT_C (0.971139158),
   MLO_FLOAT_C (0.970772141),
   MLO_FLOAT_C (0.970402839),
   MLO_FLOAT_C (0.970031253),
   MLO_FLOAT_C (0.969657385),
   MLO_FLOAT_C (0.969281235),
   MLO_FLOAT_C (0.968902805),
   MLO_FLOAT_C (0.968522094),
   MLO_FLOAT_C (0.968139105),
   MLO_FLOAT_C (0.967753837),
   MLO_FLOAT_C (0.967366292),
   MLO_FLOAT_C (0.966976471),
   MLO_FLOAT_C (0.966584374),
   MLO_FLOAT_C (0.966190003),
   MLO_FLOAT_C (0.965793359),
   MLO_FLOAT_C (0.965394442),
   MLO_FLOAT_C (0.964993253),
   MLO_FLOAT_C (0.964589793),
   MLO_FLOAT_C (0.964184064),
   MLO_FLOAT_C (0.963776066),
   MLO_FLOAT_C (0.9633658),
   MLO_FLOAT_C (0.962953267),
   MLO_FLOAT_C (0.962538468),
   MLO_FLOAT_C (0.962121404),
   MLO_FLOAT_C (0.961702077),
   MLO_FLOAT_C (0.961280486),
   MLO_FLOAT_C (0.960856633),
   MLO_FLOAT_C (0.960430519),
   MLO_FLOAT_C (0.960002146),
   MLO_FLOAT_C (0.959571513),
   MLO_FLOAT_C (0.959138622),
   MLO_FLOAT_C (0.958703475),
   MLO_FLOAT_C (0.958266071),
   MLO_FLOAT_C (0.957826413),
   MLO_FLOAT_C (0.957384501),
   MLO_FLOAT_C (0.956940336),
   MLO_FLOAT_C (0.956493919),
   MLO_FLOAT_C (0.956045251),
   MLO_FLOAT_C (0.955594334),
   MLO_FLOAT_C (0.955141168),
   MLO_FLOAT_C (0.954685755),
   MLO_FLOAT_C (0.954228095),
   MLO_FLOAT_C (0.95376819),
   MLO_FLOAT_C (0.95330604),
   MLO_FLOAT_C (0.952841648),
   MLO_FLOAT_C (0.952375013),
   MLO_FLOAT_C (0.951906137),
   MLO_FLOAT_C (0.951435021),
   MLO_FLOAT_C (0.950961666),
   MLO_FLOAT_C (0.950486074),
   MLO_FLOAT_C (0.950008245),
   MLO_FLOAT_C (0.949528181),
   MLO_FLOAT_C (0.949045882),
   MLO_FLOAT_C (0.94856135),
   MLO_FLOAT_C (0.948074586),
   MLO_FLOAT_C (0.947585591),
   MLO_FLOAT_C (0.947094366),
   MLO_FLOAT_C (0.946600913),
   MLO_FLOAT_C (0.946105232),
   MLO_FLOAT_C (0.945607325),
   MLO_FLOAT_C (0.945107193),
   MLO_FLOAT_C (0.944604837),
   MLO_FLOAT_C (0.944100258),
   MLO_FLOAT_C (0.943593458),
   MLO_FLOAT_C (0.943084437),
   MLO_FLOAT_C (0.942573198),
   MLO_FLOAT_C (0.94205974),
   MLO_FLOAT_C (0.941544065),
   MLO_FLOAT_C (0.941026175),
   MLO_FLOAT_C (0.940506071),
   MLO_FLOAT_C (0.939983753),
   MLO_FLOAT_C (0.939459224),
   MLO_FLOAT_C (0.938932484),
   MLO_FLOAT_C (0.938403534),
   MLO_FLOAT_C (0.937872376),
   MLO_FLOAT_C (0.937339012),
   MLO_FLOAT_C (0.936803442),
   MLO_FLOAT_C (0.936265667),
   MLO_FLOAT_C (0.935725689),
   MLO_FLOAT_C (0.93518351),
   MLO_FLOAT_C (0.93463913),
   MLO_FLOAT_C (0.93409255),
   MLO_FLOAT_C (0.933543773),
   MLO_FLOAT_C (0.932992799),
   MLO_FLOAT_C (0.932439629),
   MLO_FLOAT_C (0.931884266),
   MLO_FLOAT_C (0.931326709),
   MLO_FLOAT_C (0.930766961),
   MLO_FLOAT_C (0.930205023),
   MLO_FLOAT_C (0.929640896),
   MLO_FLOAT_C (0.929074581),
   MLO_FLOAT_C (0.92850608),
   MLO_FLOAT_C (0.927935395),
   MLO_FLOAT_C (0.927362526),
   MLO_FLOAT_C (0.926787474),
   MLO_FLOAT_C (0.926210242),
   MLO_FLOAT_C (0.925630831),
   MLO_FLOAT_C (0.925049241),
   MLO_FLOAT_C (0.924465474),
   MLO_FLOAT_C (0.923879533),
   MLO_FLOAT_C (0.923291417),
   MLO_FLOAT_C (0.922701128),
   MLO_FLOAT_C (0.922108669),
   MLO_FLOAT_C (0.921514039),
   MLO_FLOAT_C (0.920917242),
   MLO_FLOAT_C (0.920318277),
   MLO_FLOAT_C (0.919717146),
   MLO_FLOAT_C (0.919113852),
   MLO_FLOAT_C (0.918508394),
   MLO_FLOAT_C (0.917900776),
   MLO_FLOAT_C (0.917290997),
   MLO_FLOAT_C (0.91667906),
   MLO_FLOAT_C (0.916064966),
   MLO_FLOAT_C (0.915448716),
   MLO_FLOAT_C (0.914830312),
   MLO_FLOAT_C (0.914209756),
   MLO_FLOAT_C (0.913587048),
   MLO_FLOAT_C (0.91296219),
   MLO_FLOAT_C (0.912335185),
   MLO_FLOAT_C (0.911706032),
   MLO_FLOAT_C (0.911074734),
   MLO_FLOAT_C (0.910441292),
   MLO_FLOAT_C (0.909805708),
   MLO_FLOAT_C (0.909167983),
   MLO_FLOAT_C (0.908528119),
   MLO_FLOAT_C (0.907886116),
   MLO_FLOAT_C (0.907241978),
   MLO_FLOAT_C (0.906595705),
   MLO_FLOAT_C (0.905947298),
   MLO_FLOAT_C (0.905296759),
   MLO_FLOAT_C (0.904644091),
   MLO_FLOAT_C (0.903989293),
   MLO_FLOAT_C (0.903332368),
   MLO_FLOAT_C (0.902673318),
   MLO_FLOAT_C (0.902012144),
   MLO_FLOAT_C (0.901348847),
   MLO_FLOAT_C (0.900683429),
   MLO_FLOAT_C (0.900015892),
   MLO_FLOAT_C (0.899346237),
   MLO_FLOAT_C (0.898674466),
   MLO_FLOAT_C (0.89800058),
   MLO_FLOAT_C (0.897324581),
   MLO_FLOAT_C (0.89664647),
   MLO_FLOAT_C (0.89596625),
   MLO_FLOAT_C (0.895283921),
   MLO_FLOAT_C (0.894599486),
   MLO_FLOAT_C (0.893912945),
   MLO_FLOAT_C (0.893224301),
   MLO_FLOAT_C (0.892533555),
   MLO_FLOAT_C (0.891840709),
   MLO_FLOAT_C (0.891145765),
   MLO_FLOAT_C (0.890448723),
   MLO_FLOAT_C (0.889749586),
   MLO_FLOAT_C (0.889048356),
   MLO_FLOAT_C (0.888345033),
   MLO_FLOAT_C (0.88763962),
   MLO_FLOAT_C (0.886932119),
   MLO_FLOAT_C (0.88622253),
   MLO_FLOAT_C (0.885510856),
   MLO_FLOAT_C (0.884797098),
   MLO_FLOAT_C (0.884081259),
   MLO_FLOAT_C (0.883363339),
   MLO_FLOAT_C (0.88264334),
   MLO_FLOAT_C (0.881921264),
   MLO_FLOAT_C (0.881197113),
   MLO_FLOAT_C (0.880470889),
   MLO_FLOAT_C (0.879742593),
   MLO_FLOAT_C (0.879012226),
   MLO_FLOAT_C (0.878279792),
   MLO_FLOAT_C (0.87754529),
   MLO_FLOAT_C (0.876808724),
   MLO_FLOAT_C (0.876070094),
   MLO_FLOAT_C (0.875329403),
   MLO_FLOAT_C (0.874586652),
   MLO_FLOAT_C (0.873841843),
   MLO_FLOAT_C (0.873094978),
   MLO_FLOAT_C (0.872346059),
   MLO_FLOAT_C (0.871595087),
   MLO_FLOAT_C (0.870842063),
   MLO_FLOAT_C (0.870086991),
   MLO_FLOAT_C (0.869329871),
   MLO_FLOAT_C (0.868570706),
   MLO_FLOAT_C (0.867809497),
   MLO_FLOAT_C (0.867046246),
   MLO_FLOAT_C (0.866280954),
   MLO_FLOAT_C (0.865513624),
   MLO_FLOAT_C (0.864744258),
   MLO_FLOAT_C (0.863972856),
   MLO_FLOAT_C (0.863199422),
   MLO_FLOAT_C (0.862423956),
   MLO_FLOAT_C (0.861646461),
   MLO_FLOAT_C (0.860866939),
   MLO_FLOAT_C (0.86008539),
   MLO_FLOAT_C (0.859301818),
   MLO_FLOAT_C (0.858516224),
   MLO_FLOAT_C (0.85772861),
   MLO_FLOAT_C (0.856938977),
   MLO_FLOAT_C (0.856147328),
   MLO_FLOAT_C (0.855353665),
   MLO_FLOAT_C (0.854557988),
   MLO_FLOAT_C (0.853760301),
   MLO_FLOAT_C (0.852960605),
   MLO_FLOAT_C (0.852158902),
   MLO_FLOAT_C (0.851355193),
   MLO_FLOAT_C (0.850549481),
   MLO_FLOAT_C (0.849741768),
   MLO_FLOAT_C (0.848932055),
   MLO_FLOAT_C (0.848120345),
   MLO_FLOAT_C (0.847306639),
   MLO_FLOAT_C (0.846490939),
   MLO_FLOAT_C (0.845673247),
   MLO_FLOAT_C (0.844853565),
   MLO_FLOAT_C (0.844031895),
   MLO_FLOAT_C (0.84320824),
   MLO_FLOAT_C (0.8423826),
   MLO_FLOAT_C (0.841554977),
   MLO_FLOAT_C (0.840725375),
   MLO_FLOAT_C (0.839893794),
   MLO_FLOAT_C (0.839060237),
   MLO_FLOAT_C (0.838224706),
   MLO_FLOAT_C (0.837387202),
   MLO_FLOAT_C (0.836547727),
   MLO_FLOAT_C (0.835706284),
   MLO_FLOAT_C (0.834862875),
   MLO_FLOAT_C (0.834017501),
   MLO_FLOAT_C (0.833170165),
   MLO_FLOAT_C (0.832320868),
   MLO_FLOAT_C (0.831469612),
   MLO_FLOAT_C (0.8306164),
   MLO_FLOAT_C (0.829761234),
   MLO_FLOAT_C (0.828904115),
   MLO_FLOAT_C (0.828045045),
   MLO_FLOAT_C (0.827184027),
   MLO_FLOAT_C (0.826321063),
   MLO_FLOAT_C (0.825456154),
   MLO_FLOAT_C (0.824589303),
   MLO_FLOAT_C (0.823720511),
   MLO_FLOAT_C (0.822849781),
   MLO_FLOAT_C (0.821977115),
   MLO_FLOAT_C (0.821102515),
   MLO_FLOAT_C (0.820225983),
   MLO_FLOAT_C (0.81934752),
   MLO_FLOAT_C (0.81846713),
   MLO_FLOAT_C (0.817584813),
   MLO_FLOAT_C (0.816700573),
   MLO_FLOAT_C (0.815814411),
   MLO_FLOAT_C (0.814926329),
   MLO_FLOAT_C (0.81403633),
   MLO_FLOAT_C (0.813144415),
   MLO_FLOAT_C (0.812250587),
   MLO_FLOAT_C (0.811354847),
   MLO_FLOAT_C (0.810457198),
   MLO_FLOAT_C (0.809557642),
   MLO_FLOAT_C (0.808656182),
   MLO_FLOAT_C (0.807752818),
   MLO_FLOAT_C (0.806847554),
   MLO_FLOAT_C (0.805940391),
   MLO_FLOAT_C (0.805031331),
   MLO_FLOAT_C (0.804120377),
   MLO_FLOAT_C (0.803207531),
   MLO_FLOAT_C (0.802292796),
   MLO_FLOAT_C (0.801376172),
   MLO_FLOAT_C (0.800457662),
   MLO_FLOAT_C (0.799537269),
   MLO_FLOAT_C (0.798614995),
   MLO_FLOAT_C (0.797690841),
   MLO_FLOAT_C (0.79676481),
   MLO_FLOAT_C (0.795836905),
   MLO_FLOAT_C (0.794907126),
   MLO_FLOAT_C (0.793975478),
   MLO_FLOAT_C (0.79304196),
   MLO_FLOAT_C (0.792106577),
   MLO_FLOAT_C (0.79116933),
   MLO_FLOAT_C (0.790230221),
   MLO_FLOAT_C (0.789289253),
   MLO_FLOAT_C (0.788346428),
   MLO_FLOAT_C (0.787401747),
   MLO_FLOAT_C (0.786455214),
   MLO_FLOAT_C (0.78550683),
   MLO_FLOAT_C (0.784556597),
   MLO_FLOAT_C (0.783604519),
   MLO_FLOAT_C (0.782650596),
   MLO_FLOAT_C (0.781694832),
   MLO_FLOAT_C (0.780737229),
   MLO_FLOAT_C (0.779777788),
   MLO_FLOAT_C (0.778816512),
   MLO_FLOAT_C (0.777853404),
   MLO_FLOAT_C (0.776888466),
   MLO_FLOAT_C (0.775921699),
   MLO_FLOAT_C (0.774953107),
   MLO_FLOAT_C (0.773982691),
   MLO_FLOAT_C (0.773010453),
   MLO_FLOAT_C (0.772036397),
   MLO_FLOAT_C (0.771060524),
   MLO_FLOAT_C (0.770082837),
   MLO_FLOAT_C (0.769103338),
   MLO_FLOAT_C (0.768122029),
   MLO_FLOAT_C (0.767138912),
   MLO_FLOAT_C (0.76615399),
   MLO_FLOAT_C (0.765167266),
   MLO_FLOAT_C (0.764178741),
   MLO_FLOAT_C (0.763188417),
   MLO_FLOAT_C (0.762196298),
   MLO_FLOAT_C (0.761202385),
   MLO_FLOAT_C (0.760206682),
   MLO_FLOAT_C (0.759209189),
   MLO_FLOAT_C (0.75820991),
   MLO_FLOAT_C (0.757208847),
   MLO_FLOAT_C (0.756206001),
   MLO_FLOAT_C (0.755201377),
   MLO_FLOAT_C (0.754194975),
   MLO_FLOAT_C (0.753186799),
   MLO_FLOAT_C (0.75217685),
   MLO_FLOAT_C (0.751165132),
   MLO_FLOAT_C (0.750151646),
   MLO_FLOAT_C (0.749136395),
   MLO_FLOAT_C (0.74811938),
   MLO_FLOAT_C (0.747100606),
   MLO_FLOAT_C (0.746080074),
   MLO_FLOAT_C (0.745057785),
   MLO_FLOAT_C (0.744033744),
   MLO_FLOAT_C (0.743007952),
   MLO_FLOAT_C (0.741980412),
   MLO_FLOAT_C (0.740951125),
   MLO_FLOAT_C (0.739920095),
   MLO_FLOAT_C (0.738887324),
   MLO_FLOAT_C (0.737852815),
   MLO_FLOAT_C (0.736816569),
   MLO_FLOAT_C (0.735778589),
   MLO_FLOAT_C (0.734738878),
   MLO_FLOAT_C (0.733697438),
   MLO_FLOAT_C (0.732654272),
   MLO_FLOAT_C (0.731609381),
   MLO_FLOAT_C (0.730562769),
   MLO_FLOAT_C (0.729514438),
   MLO_FLOAT_C (0.72846439),
   MLO_FLOAT_C (0.727412629),
   MLO_FLOAT_C (0.726359155),
   MLO_FLOAT_C (0.725303972),
   MLO_FLOAT_C (0.724247083),
   MLO_FLOAT_C (0.723188489),
   MLO_FLOAT_C (0.722128194),
   MLO_FLOAT_C (0.721066199),
   MLO_FLOAT_C (0.720002508),
   MLO_FLOAT_C (0.718937122),
   MLO_FLOAT_C (0.717870045),
   MLO_FLOAT_C (0.716801279),
   MLO_FLOAT_C (0.715730825),
   MLO_FLOAT_C (0.714658688),
   MLO_FLOAT_C (0.713584869),
   MLO_FLOAT_C (0.712509371),
   MLO_FLOAT_C (0.711432196),
   MLO_FLOAT_C (0.710353347),
   MLO_FLOAT_C (0.709272826),
   MLO_FLOAT_C (0.708190637),
   MLO_FLOAT_C (0.707106781),
   MLO_FLOAT_C (0.706021261),
   MLO_FLOAT_C (0.70493408),
   MLO_FLOAT_C (0.703845241),
   MLO_FLOAT_C (0.702754744),
   MLO_FLOAT_C (0.701662595),
   MLO_FLOAT_C (0.700568794),
   MLO_FLOAT_C (0.699473345),
   MLO_FLOAT_C (0.698376249),
   MLO_FLOAT_C (0.697277511),
   MLO_FLOAT_C (0.696177131),
   MLO_FLOAT_C (0.695075114),
   MLO_FLOAT_C (0.693971461),
   MLO_FLOAT_C (0.692866175),
   MLO_FLOAT_C (0.691759258),
   MLO_FLOAT_C (0.690650714),
   MLO_FLOAT_C (0.689540545),
   MLO_FLOAT_C (0.688428753),
   MLO_FLOAT_C (0.687315341),
   MLO_FLOAT_C (0.686200312),
   MLO_FLOAT_C (0.685083668),
   MLO_FLOAT_C (0.683965412),
   MLO_FLOAT_C (0.682845546),
   MLO_FLOAT_C (0.681724074),
   MLO_FLOAT_C (0.680600998),
   MLO_FLOAT_C (0.67947632),
   MLO_FLOAT_C (0.678350043),
   MLO_FLOAT_C (0.67722217),
   MLO_FLOAT_C (0.676092704),
   MLO_FLOAT_C (0.674961646),
   MLO_FLOAT_C (0.673829),
   MLO_FLOAT_C (0.672694769),
   MLO_FLOAT_C (0.671558955),
   MLO_FLOAT_C (0.67042156),
   MLO_FLOAT_C (0.669282588),
   MLO_FLOAT_C (0.668142041),
   MLO_FLOAT_C (0.666999922),
   MLO_FLOAT_C (0.665856234),
   MLO_FLOAT_C (0.664710978),
   MLO_FLOAT_C (0.663564159),
   MLO_FLOAT_C (0.662415778),
   MLO_FLOAT_C (0.661265838),
   MLO_FLOAT_C (0.660114342),
   MLO_FLOAT_C (0.658961293),
   MLO_FLOAT_C (0.657806693),
   MLO_FLOAT_C (0.656650546),
   MLO_FLOAT_C (0.655492853),
   MLO_FLOAT_C (0.654333618),
   MLO_FLOAT_C (0.653172843),
   MLO_FLOAT_C (0.652010531),
   MLO_FLOAT_C (0.650846685),
   MLO_FLOAT_C (0.649681307),
   MLO_FLOAT_C (0.648514401),
   MLO_FLOAT_C (0.647345969),
   MLO_FLOAT_C (0.646176013),
   MLO_FLOAT_C (0.645004537),
   MLO_FLOAT_C (0.643831543),
   MLO_FLOAT_C (0.642657034),
   MLO_FLOAT_C (0.641481013),
   MLO_FLOAT_C (0.640303482),
   MLO_FLOAT_C (0.639124445),
   MLO_FLOAT_C (0.637943904),
   MLO_FLOAT_C (0.636761861),
   MLO_FLOAT_C (0.63557832),
   MLO_FLOAT_C (0.634393284),
   MLO_FLOAT_C (0.633206755),
   MLO_FLOAT_C (0.632018736),
   MLO_FLOAT_C (0.63082923),
   MLO_FLOAT_C (0.629638239),
   MLO_FLOAT_C (0.628445767),
   MLO_FLOAT_C (0.627251815),
   MLO_FLOAT_C (0.626056388),
   MLO_FLOAT_C (0.624859488),
   MLO_FLOAT_C (0.623661118),
   MLO_FLOAT_C (0.622461279),
   MLO_FLOAT_C (0.621259977),
   MLO_FLOAT_C (0.620057212),
   MLO_FLOAT_C (0.618852988),
   MLO_FLOAT_C (0.617647308),
   MLO_FLOAT_C (0.616440175),
   MLO_FLOAT_C (0.615231591),
   MLO_FLOAT_C (0.614021559),
   MLO_FLOAT_C (0.612810082),
   MLO_FLOAT_C (0.611597164),
   MLO_FLOAT_C (0.610382806),
   MLO_FLOAT_C (0.609167012),
   MLO_FLOAT_C (0.607949785),
   MLO_FLOAT_C (0.606731127),
   MLO_FLOAT_C (0.605511041),
   MLO_FLOAT_C (0.604289531),
   MLO_FLOAT_C (0.603066599),
   MLO_FLOAT_C (0.601842247),
   MLO_FLOAT_C (0.600616479),
   MLO_FLOAT_C (0.599389298),
   MLO_FLOAT_C (0.598160707),
   MLO_FLOAT_C (0.596930708),
   MLO_FLOAT_C (0.595699304),
   MLO_FLOAT_C (0.594466499),
   MLO_FLOAT_C (0.593232295),
   MLO_FLOAT_C (0.591996695),
   MLO_FLOAT_C (0.590759702),
   MLO_FLOAT_C (0.589521319),
   MLO_FLOAT_C (0.588281548),
   MLO_FLOAT_C (0.587040394),
   MLO_FLOAT_C (0.585797857),
   MLO_FLOAT_C (0.584553943),
   MLO_FLOAT_C (0.583308653),
   MLO_FLOAT_C (0.58206199),
   MLO_FLOAT_C (0.580813958),
   MLO_FLOAT_C (0.579564559),
   MLO_FLOAT_C (0.578313796),
   MLO_FLOAT_C (0.577061673),
   MLO_FLOAT_C (0.575808191),
   MLO_FLOAT_C (0.574553355),
   MLO_FLOAT_C (0.573297167),
   MLO_FLOAT_C (0.572039629),
   MLO_FLOAT_C (0.570780746),
   MLO_FLOAT_C (0.569520519),
   MLO_FLOAT_C (0.568258953),
   MLO_FLOAT_C (0.566996049),
   MLO_FLOAT_C (0.565731811),
   MLO_FLOAT_C (0.564466242),
   MLO_FLOAT_C (0.563199344),
   MLO_FLOAT_C (0.561931121),
   MLO_FLOAT_C (0.560661576),
   MLO_FLOAT_C (0.559390712),
   MLO_FLOAT_C (0.558118531),
   MLO_FLOAT_C (0.556845037),
   MLO_FLOAT_C (0.555570233),
   MLO_FLOAT_C (0.554294121),
   MLO_FLOAT_C (0.553016706),
   MLO_FLOAT_C (0.551737988),
   MLO_FLOAT_C (0.550457973),
   MLO_FLOAT_C (0.549176662),
   MLO_FLOAT_C (0.547894059),
   MLO_FLOAT_C (0.546610167),
   MLO_FLOAT_C (0.545324988),
   MLO_FLOAT_C (0.544038527),
   MLO_FLOAT_C (0.542750785),
   MLO_FLOAT_C (0.541461766),
   MLO_FLOAT_C (0.540171473),
   MLO_FLOAT_C (0.538879909),
   MLO_FLOAT_C (0.537587076),
   MLO_FLOAT_C (0.536292979),
   MLO_FLOAT_C (0.53499762),
   MLO_FLOAT_C (0.533701002),
   MLO_FLOAT_C (0.532403128),
   MLO_FLOAT_C (0.531104001),
   MLO_FLOAT_C (0.529803625),
   MLO_FLOAT_C (0.528502002),
   MLO_FLOAT_C (0.527199135),
   MLO_FLOAT_C (0.525895027),
   MLO_FLOAT_C (0.524589683),
   MLO_FLOAT_C (0.523283103),
   MLO_FLOAT_C (0.521975293),
   MLO_FLOAT_C (0.520666254),
   MLO_FLOAT_C (0.51935599),
   MLO_FLOAT_C (0.518044504),
   MLO_FLOAT_C (0.516731799),
   MLO_FLOAT_C (0.515417878),
   MLO_FLOAT_C (0.514102744),
   MLO_FLOAT_C (0.512786401),
   MLO_FLOAT_C (0.51146885),
   MLO_FLOAT_C (0.510150097),
   MLO_FLOAT_C (0.508830143),
   MLO_FLOAT_C (0.507508991),
   MLO_FLOAT_C (0.506186645),
   MLO_FLOAT_C (0.504863109),
   MLO_FLOAT_C (0.503538384),
   MLO_FLOAT_C (0.502212474),
   MLO_FLOAT_C (0.500885383),
   MLO_FLOAT_C (0.499557113),
   MLO_FLOAT_C (0.498227667),
   MLO_FLOAT_C (0.496897049),
   MLO_FLOAT_C (0.495565262),
   MLO_FLOAT_C (0.494232309),
   MLO_FLOAT_C (0.492898192),
   MLO_FLOAT_C (0.491562916),
   MLO_FLOAT_C (0.490226483),
   MLO_FLOAT_C (0.488888897),
   MLO_FLOAT_C (0.48755016),
   MLO_FLOAT_C (0.486210276),
   MLO_FLOAT_C (0.484869248),
   MLO_FLOAT_C (0.483527079),
   MLO_FLOAT_C (0.482183772),
   MLO_FLOAT_C (0.480839331),
   MLO_FLOAT_C (0.479493758),
   MLO_FLOAT_C (0.478147056),
   MLO_FLOAT_C (0.47679923),
   MLO_FLOAT_C (0.475450282),
   MLO_FLOAT_C (0.474100215),
   MLO_FLOAT_C (0.472749032),
   MLO_FLOAT_C (0.471396737),
   MLO_FLOAT_C (0.470043332),
   MLO_FLOAT_C (0.468688822),
   MLO_FLOAT_C (0.467333209),
   MLO_FLOAT_C (0.465976496),
   MLO_FLOAT_C (0.464618686),
   MLO_FLOAT_C (0.463259784),
   MLO_FLOAT_C (0.461899791),
   MLO_FLOAT_C (0.460538711),
   MLO_FLOAT_C (0.459176548),
   MLO_FLOAT_C (0.457813304),
   MLO_FLOAT_C (0.456448982),
   MLO_FLOAT_C (0.455083587),
   MLO_FLOAT_C (0.453717121),
   MLO_FLOAT_C (0.452349587),
   MLO_FLOAT_C (0.450980989),
   MLO_FLOAT_C (0.44961133),
   MLO_FLOAT_C (0.448240612),
   MLO_FLOAT_C (0.44686884),
   MLO_FLOAT_C (0.445496017),
   MLO_FLOAT_C (0.444122145),
   MLO_FLOAT_C (0.442747228),
   MLO_FLOAT_C (0.441371269),
   MLO_FLOAT_C (0.439994271),
   MLO_FLOAT_C (0.438616239),
   MLO_FLOAT_C (0.437237174),
   MLO_FLOAT_C (0.43585708),
   MLO_FLOAT_C (0.434475961),
   MLO_FLOAT_C (0.433093819),
   MLO_FLOAT_C (0.431710658),
   MLO_FLOAT_C (0.430326481),
   MLO_FLOAT_C (0.428941292),
   MLO_FLOAT_C (0.427555093),
   MLO_FLOAT_C (0.426167889),
   MLO_FLOAT_C (0.424779681),
   MLO_FLOAT_C (0.423390474),
   MLO_FLOAT_C (0.422000271),
   MLO_FLOAT_C (0.420609074),
   MLO_FLOAT_C (0.419216888),
   MLO_FLOAT_C (0.417823716),
   MLO_FLOAT_C (0.41642956),
   MLO_FLOAT_C (0.415034424),
   MLO_FLOAT_C (0.413638312),
   MLO_FLOAT_C (0.412241227),
   MLO_FLOAT_C (0.410843171),
   MLO_FLOAT_C (0.409444149),
   MLO_FLOAT_C (0.408044163),
   MLO_FLOAT_C (0.406643217),
   MLO_FLOAT_C (0.405241314),
   MLO_FLOAT_C (0.403838458),
   MLO_FLOAT_C (0.402434651),
   MLO_FLOAT_C (0.401029897),
   MLO_FLOAT_C (0.3996242),
   MLO_FLOAT_C (0.398217562),
   MLO_FLOAT_C (0.396809987),
   MLO_FLOAT_C (0.395401479),
   MLO_FLOAT_C (0.39399204),
   MLO_FLOAT_C (0.392581674),
   MLO_FLOAT_C (0.391170384),
   MLO_FLOAT_C (0.389758174),
   MLO_FLOAT_C (0.388345047),
   MLO_FLOAT_C (0.386931006),
   MLO_FLOAT_C (0.385516054),
   MLO_FLOAT_C (0.384100195),
   MLO_FLOAT_C (0.382683432),
   MLO_FLOAT_C (0.381265769),
   MLO_FLOAT_C (0.379847209),
   MLO_FLOAT_C (0.378427755),
   MLO_FLOAT_C (0.37700741),
   MLO_FLOAT_C (0.375586178),
   MLO_FLOAT_C (0.374164063),
   MLO_FLOAT_C (0.372741067),
   MLO_FLOAT_C (0.371317194),
   MLO_FLOAT_C (0.369892447),
   MLO_FLOAT_C (0.36846683),
   MLO_FLOAT_C (0.367040346),
   MLO_FLOAT_C (0.365612998),
   MLO_FLOAT_C (0.36418479),
   MLO_FLOAT_C (0.362755724),
   MLO_FLOAT_C (0.361325806),
   MLO_FLOAT_C (0.359895037),
   MLO_FLOAT_C (0.358463421),
   MLO_FLOAT_C (0.357030961),
   MLO_FLOAT_C (0.355597662),
   MLO_FLOAT_C (0.354163525),
   MLO_FLOAT_C (0.352728556),
   MLO_FLOAT_C (0.351292756),
   MLO_FLOAT_C (0.34985613),
   MLO_FLOAT_C (0.34841868),
   MLO_FLOAT_C (0.346980411),
   MLO_FLOAT_C (0.345541325),
   MLO_FLOAT_C (0.344101426),
   MLO_FLOAT_C (0.342660717),
   MLO_FLOAT_C (0.341219202),
   MLO_FLOAT_C (0.339776884),
   MLO_FLOAT_C (0.338333767),
   MLO_FLOAT_C (0.336889853),
   MLO_FLOAT_C (0.335445147),
   MLO_FLOAT_C (0.333999651),
   MLO_FLOAT_C (0.33255337),
   MLO_FLOAT_C (0.331106306),
   MLO_FLOAT_C (0.329658463),
   MLO_FLOAT_C (0.328209844),
   MLO_FLOAT_C (0.326760452),
   MLO_FLOAT_C (0.325310292),
   MLO_FLOAT_C (0.323859367),
   MLO_FLOAT_C (0.322407679),
   MLO_FLOAT_C (0.320955232),
   MLO_FLOAT_C (0.319502031),
   MLO_FLOAT_C (0.318048077),
   MLO_FLOAT_C (0.316593376),
   MLO_FLOAT_C (0.315137929),
   MLO_FLOAT_C (0.31368174),
   MLO_FLOAT_C (0.312224814),
   MLO_FLOAT_C (0.310767153),
   MLO_FLOAT_C (0.30930876),
   MLO_FLOAT_C (0.30784964),
   MLO_FLOAT_C (0.306389795),
   MLO_FLOAT_C (0.30492923),
   MLO_FLOAT_C (0.303467947),
   MLO_FLOAT_C (0.302005949),
   MLO_FLOAT_C (0.300543241),
   MLO_FLOAT_C (0.299079826),
   MLO_FLOAT_C (0.297615707),
   MLO_FLOAT_C (0.296150888),
   MLO_FLOAT_C (0.294685372),
   MLO_FLOAT_C (0.293219163),
   MLO_FLOAT_C (0.291752263),
   MLO_FLOAT_C (0.290284677),
   MLO_FLOAT_C (0.288816408),
   MLO_FLOAT_C (0.28734746),
   MLO_FLOAT_C (0.285877835),
   MLO_FLOAT_C (0.284407537),
   MLO_FLOAT_C (0.28293657),
   MLO_FLOAT_C (0.281464938),
   MLO_FLOAT_C (0.279992643),
   MLO_FLOAT_C (0.278519689),
   MLO_FLOAT_C (0.27704608),
   MLO_FLOAT_C (0.275571819),
   MLO_FLOAT_C (0.27409691),
   MLO_FLOAT_C (0.272621355),
   MLO_FLOAT_C (0.27114516),
   MLO_FLOAT_C (0.269668326),
   MLO_FLOAT_C (0.268190857),
   MLO_FLOAT_C (0.266712757),
   MLO_FLOAT_C (0.26523403),
   MLO_FLOAT_C (0.263754679),
   MLO_FLOAT_C (0.262274707),
   MLO_FLOAT_C (0.260794118),
   MLO_FLOAT_C (0.259312915),
   MLO_FLOAT_C (0.257831102),
   MLO_FLOAT_C (0.256348682),
   MLO_FLOAT_C (0.25486566),
   MLO_FLOAT_C (0.253382037),
   MLO_FLOAT_C (0.251897818),
   MLO_FLOAT_C (0.250413007),
   MLO_FLOAT_C (0.248927606),
   MLO_FLOAT_C (0.247441619),
   MLO_FLOAT_C (0.24595505),
   MLO_FLOAT_C (0.244467903),
   MLO_FLOAT_C (0.24298018),
   MLO_FLOAT_C (0.241491885),
   MLO_FLOAT_C (0.240003022),
   MLO_FLOAT_C (0.238513595),
   MLO_FLOAT_C (0.237023606),
   MLO_FLOAT_C (0.235533059),
   MLO_FLOAT_C (0.234041959),
   MLO_FLOAT_C (0.232550307),
   MLO_FLOAT_C (0.231058108),
   MLO_FLOAT_C (0.229565366),
   MLO_FLOAT_C (0.228072083),
   MLO_FLOAT_C (0.226578264),
   MLO_FLOAT_C (0.225083911),
   MLO_FLOAT_C (0.223589029),
   MLO_FLOAT_C (0.222093621),
   MLO_FLOAT_C (0.22059769),
   MLO_FLOAT_C (0.21910124),
   MLO_FLOAT_C (0.217604275),
   MLO_FLOAT_C (0.216106797),
   MLO_FLOAT_C (0.214608811),
   MLO_FLOAT_C (0.21311032),
   MLO_FLOAT_C (0.211611327),
   MLO_FLOAT_C (0.210111837),
   MLO_FLOAT_C (0.208611852),
   MLO_FLOAT_C (0.207111376),
   MLO_FLOAT_C (0.205610413),
   MLO_FLOAT_C (0.204108966),
   MLO_FLOAT_C (0.202607039),
   MLO_FLOAT_C (0.201104635),
   MLO_FLOAT_C (0.199601758),
   MLO_FLOAT_C (0.198098411),
   MLO_FLOAT_C (0.196594598),
   MLO_FLOAT_C (0.195090322),
   MLO_FLOAT_C (0.193585587),
   MLO_FLOAT_C (0.192080397),
   MLO_FLOAT_C (0.190574755),
   MLO_FLOAT_C (0.189068664),
   MLO_FLOAT_C (0.187562129),
   MLO_FLOAT_C (0.186055152),
   MLO_FLOAT_C (0.184547737),
   MLO_FLOAT_C (0.183039888),
   MLO_FLOAT_C (0.181531608),
   MLO_FLOAT_C (0.180022901),
   MLO_FLOAT_C (0.178513771),
   MLO_FLOAT_C (0.17700422),
   MLO_FLOAT_C (0.175494253),
   MLO_FLOAT_C (0.173983873),
   MLO_FLOAT_C (0.172473084),
   MLO_FLOAT_C (0.170961889),
   MLO_FLOAT_C (0.169450291),
   MLO_FLOAT_C (0.167938295),
   MLO_FLOAT_C (0.166425904),
   MLO_FLOAT_C (0.16491312),
   MLO_FLOAT_C (0.163399949),
   MLO_FLOAT_C (0.161886394),
   MLO_FLOAT_C (0.160372457),
   MLO_FLOAT_C (0.158858143),
   MLO_FLOAT_C (0.157343456),
   MLO_FLOAT_C (0.155828398),
   MLO_FLOAT_C (0.154312973),
   MLO_FLOAT_C (0.152797185),
   MLO_FLOAT_C (0.151281038),
   MLO_FLOAT_C (0.149764535),
   MLO_FLOAT_C (0.148247679),
   MLO_FLOAT_C (0.146730474),
   MLO_FLOAT_C (0.145212925),
   MLO_FLOAT_C (0.143695033),
   MLO_FLOAT_C (0.142176804),
   MLO_FLOAT_C (0.140658239),
   MLO_FLOAT_C (0.139139344),
   MLO_FLOAT_C (0.137620122),
   MLO_FLOAT_C (0.136100575),
   MLO_FLOAT_C (0.134580709),
   MLO_FLOAT_C (0.133060525),
   MLO_FLOAT_C (0.131540029),
   MLO_FLOAT_C (0.130019223),
   MLO_FLOAT_C (0.128498111),
   MLO_FLOAT_C (0.126976696),
   MLO_FLOAT_C (0.125454983),
   MLO_FLOAT_C (0.123932975),
   MLO_FLOAT_C (0.122410675),
   MLO_FLOAT_C (0.120888087),
   MLO_FLOAT_C (0.119365215),
   MLO_FLOAT_C (0.117842062),
   MLO_FLOAT_C (0.116318631),
   MLO_FLOAT_C (0.114794927),
   MLO_FLOAT_C (0.113270952),
   MLO_FLOAT_C (0.111746711),
   MLO_FLOAT_C (0.110222207),
   MLO_FLOAT_C (0.108697444),
   MLO_FLOAT_C (0.107172425),
   MLO_FLOAT_C (0.105647154),
   MLO_FLOAT_C (0.104121634),
   MLO_FLOAT_C (0.102595869),
   MLO_FLOAT_C (0.101069863),
   MLO_FLOAT_C (0.0995436187),
   MLO_FLOAT_C (0.0980171403),
   MLO_FLOAT_C (0.0964904314),
   MLO_FLOAT_C (0.0949634953),
   MLO_FLOAT_C (0.0934363358),
   MLO_FLOAT_C (0.0919089565),
   MLO_FLOAT_C (0.0903813609),
   MLO_FLOAT_C (0.0888535526),
   MLO_FLOAT_C (0.0873255352),
   MLO_FLOAT_C (0.0857973123),
   MLO_FLOAT_C (0.0842688876),
   MLO_FLOAT_C (0.0827402645),
   MLO_FLOAT_C (0.0812114468),
   MLO_FLOAT_C (0.079682438),
   MLO_FLOAT_C (0.0781532416),
   MLO_FLOAT_C (0.0766238614),
   MLO_FLOAT_C (0.0750943008),
   MLO_FLOAT_C (0.0735645636),
   MLO_FLOAT_C (0.0720346532),
   MLO_FLOAT_C (0.0705045734),
   MLO_FLOAT_C (0.0689743276),
   MLO_FLOAT_C (0.0674439196),
   MLO_FLOAT_C (0.0659133528),
   MLO_FLOAT_C (0.0643826309),
   MLO_FLOAT_C (0.0628517576),
   MLO_FLOAT_C (0.0613207363),
   MLO_FLOAT_C (0.0597895707),
   MLO_FLOAT_C (0.0582582645),
   MLO_FLOAT_C (0.0567268212),
   MLO_FLOAT_C (0.0551952443),
   MLO_FLOAT_C (0.0536635377),
   MLO_FLOAT_C (0.0521317047),
   MLO_FLOAT_C (0.050599749),
   MLO_FLOAT_C (0.0490676743),
   MLO_FLOAT_C (0.0475354842),
   MLO_FLOAT_C (0.0460031821),
   MLO_FLOAT_C (0.0444707719),
   MLO_FLOAT_C (0.0429382569),
   MLO_FLOAT_C (0.041405641),
   MLO_FLOAT_C (0.0398729276),
   MLO_FLOAT_C (0.0383401204),
   MLO_FLOAT_C (0.0368072229),
   MLO_FLOAT_C (0.0352742389),
   MLO_FLOAT_C (0.0337411719),
   MLO_FLOAT_C (0.0322080254),
   MLO_FLOAT_C (0.0306748032),
   MLO_FLOAT_C (0.0291415088),
   MLO_FLOAT_C (0.0276081458),
   MLO_FLOAT_C (0.0260747178),
   MLO_FLOAT_C (0.0245412285),
   MLO_FLOAT_C (0.0230076815),
   MLO_FLOAT_C (0.0214740803),
   MLO_FLOAT_C (0.0199404286),
   MLO_FLOAT_C (0.0184067299),
   MLO_FLOAT_C (0.0168729879),
   MLO_FLOAT_C (0.0153392063),
   MLO_FLOAT_C (0.0138053885),
   MLO_FLOAT_C (0.0122715383),
   MLO_FLOAT_C (0.0107376592),
   MLO_FLOAT_C (0.00920375478),
   MLO_FLOAT_C (0.00766982874),
   MLO_FLOAT_C (0.00613588465),
   MLO_FLOAT_C (0.00460192612),
   MLO_FLOAT_C (0.00306795676),
   MLO_FLOAT_C (0.00153398019)
};



/*----------------------------------------------------------------------
|       Functions
+---------------------------------------------------------------------*/



/*
==============================================================================
Name: MLO_Imdct_Init
Description:
   Initialise the IMDCT object, fill tables. Call this function at least first
   before using this object.
Output parameters:
	- imdct_ptr: The IMDCT object to initialise.
Returns: currently MLO_SUCCESS.
==============================================================================
*/

MLO_Result  MLO_Imdct_Init (MLO_Imdct *imdct_ptr)
{
   MLO_Result     result = MLO_SUCCESS;

   MLO_ASSERT (imdct_ptr != NULL);

   MLO_Fft_Init (&imdct_ptr->fft);

   return (result);
}



/*
==============================================================================
Name: MLO_Imdct_Restore
Description:
   
Output parameters:
Input/output parameters:
	- imdct_ptr: 
Throws: ?
==============================================================================
*/

void  MLO_Imdct_Restore (MLO_Imdct *imdct_ptr)
{
    (void)imdct_ptr;
   /* Nothing */
}



/*
==============================================================================
Name: MLO_Imdct_Process
Description:

   Does the Inverse Modified Discrete Cosine Transform (IMDCT) of the input
   signal. Implemented via computation and reordering of the DCT-IV.

              len/2-1
            2   ___               2*pi        len + 2         1
   x [k] = ---  \   f [p] * cos ( ---- * (k + -------) * (p + -) )
           len  /__               len            4            2
               p = 0

   Can work in-place.

   Ref:
      4.6.11.3.1
      Mu-Huo Cheng and Yu-Hsin Hsu, "Fast IMDCT And MDCT Algorithms - A Matrix
      Approach", IEEE Transactions on signal processing, vol. 51, No. 1,
      January 2003

Input parameters:
	- f_ptr: input array, len/2 elements
	- len: Length of the IMDCT output, only 2048 or 256.
Output parameters:
	- x_ptr: output array, len elements
Input/output parameters:
	- imdct_ptr: IMDCT processing object (contains temporary data buffers)
==============================================================================
*/

void  MLO_Imdct_Process (MLO_Imdct *imdct_ptr, MLO_Float x_ptr [], const MLO_Float f_ptr [], int len)
{
   const int      len_h  = len >> 1;
   const int      len_q  = len >> 2;
   const int      len_q3 = len_h + len_q;
   const MLO_Float   s = MLO_Float_DivInt (MLO_FLOAT_C (2), len); /*** To do: optimise this (somewhere in the DCTs) ***/
   int            k;
   MLO_Float *    tmp_ptr;

   MLO_ASSERT (imdct_ptr != NULL);
   MLO_ASSERT (x_ptr != NULL);
   MLO_ASSERT (f_ptr != NULL);
   MLO_ASSERT (   len == MLO_DEFS_FRAME_LEN_LONG  * 2
/*************************************************************************************************************/
/*** Debug ***/
               || len == 8 * 2
/*************************************************************************************************************/
               || len == MLO_DEFS_FRAME_LEN_SHORT * 2);

   tmp_ptr = &imdct_ptr->buffer [1] [0];
   MLO_Imdct_ComputeDct4 (imdct_ptr, tmp_ptr, f_ptr, len_h);

   /* Duplicates and reorders coefficients */
   for (k = 0; k < len_q; ++k)
   {
      const MLO_Float   a = MLO_Float_Mul (tmp_ptr [        k], s);
      const MLO_Float   b = MLO_Float_Mul (tmp_ptr [len_q + k], s);
      const MLO_Float   ma = MLO_Float_Neg (a);

      x_ptr [             k] =  b;
      x_ptr [len_h  - 1 - k] = MLO_Float_Neg (b);
      x_ptr [len_q3 - 1 - k] = ma;
      x_ptr [len_q3     + k] = ma;
   }
}



/*
==============================================================================
Name: MLO_Imdct_ComputeDct4
Description:

   Computes the DCT-IV of input data.

   All coefficients are scaled the same way (no exception for DC)

           len-1
            ___                   1                 pi
   y [p] =  \   x [k] * cos ((p + -) * ((k + 0.5) * ---))
            /__                   2                 len
            k=0

   Computed as:

                            (p + 0.5) * pi
   u [p] = x [k] * 2 * cos (--------------)
                               len * 2

   v     = DCT-II (u)

   y [p] = { v [0] * 0.5       if p == 0
           { v [p] - y [p - 1] if p > 0

Input parameters:
	- src_ptr: DCT-IV input array, len elements
	- len: Number of elements to process. 1024 or 128.
Output parameters:
	- dest_ptr: Output of the DCT-IV, len elements
Input/output parameters:
	- imdct_ptr: IMDCT processing object (contains temporary data buffers)
==============================================================================
*/

void  MLO_Imdct_ComputeDct4 (MLO_Imdct *imdct_ptr, MLO_Float dest_ptr [], const MLO_Float src_ptr [], int len)
{
   int            k;
   MLO_Float *    buf_ptr;
   const MLO_Float * table_ptr = &MLO_Imdct_cos_table_1 [0];
   int            step = 1;

   MLO_ASSERT (imdct_ptr != NULL);
   MLO_ASSERT (dest_ptr != NULL);
   MLO_ASSERT (src_ptr != NULL);
   MLO_ASSERT (len > 0);

   /* Uses the FFT buffer as temporary buffer for input of the DCT-II */
   buf_ptr = &imdct_ptr->fft.buffer [0];

   /* Changes the table if frame is short */
   if (len == MLO_DEFS_FRAME_LEN_SHORT)
   {
      step = MLO_DEFS_FRAME_LEN_LONG / MLO_DEFS_FRAME_LEN_SHORT;
      MLO_ASSERT ((step & 3) == 0);
      table_ptr = &MLO_Imdct_cos_table_2 [step >> 1];
   }

   for (k = 0; k < len; ++k)
   {
      const MLO_Float   c = MLO_Float_MulInt (table_ptr [k * step], 2);
      const MLO_Float   x = src_ptr [k];
      buf_ptr [k] = MLO_Float_Mul (x, c);
   }

   MLO_Imdct_ComputeDct2 (imdct_ptr, dest_ptr, buf_ptr, len);

   dest_ptr [0] = MLO_Float_Mul (dest_ptr [0], MLO_FLOAT_C (0.5));
   for (k = 1; k < len; ++k)
   {
      dest_ptr [k] = MLO_Float_Sub (dest_ptr [k], dest_ptr [k - 1]);
   }
}



/*
==============================================================================
Name: MLO_Imdct_ComputeDct2
Description:

   Computes the DCT-II of input data.

   All coefficients are scaled the same way (no exception for DC)

           len-1
            ___                   1         pi
   y [p] =  \   x [k] * cos ((p + -) * (k * ---))
            /__                   2         len
            k=0

   Computed as:

   u [p] = { x [2*p]             if p <  len/2
           { x [2*len - 1 - 2*p] if p >= len/2

   v     = DFT (u)

                  2                        -j * p * pi
   y [p] = sqrt (---) * Real (v [p] * exp (-----------))
                 len                         2 * len

Input parameters:
	- src_ptr: DCT-II input array, len elements
	- len: Number of elements to process. 1024 or 128.
Output parameters:
	- dest_ptr: Output of the DCT-II, len elements
Input/output parameters:
	- imdct_ptr: IMDCT processing object (contains temporary data buffers)
==============================================================================
*/

void  MLO_Imdct_ComputeDct2 (MLO_Imdct *imdct_ptr, MLO_Float dest_ptr [], const MLO_Float src_ptr [], int len)
{
   int            len_h = len >> 1;
   int            len_q = len >> 2;
   MLO_Float *    buf_ptr;
   int            k;
   int            step = 1;
   int            qpi_offset = len_h;

   MLO_ASSERT (imdct_ptr != NULL);
   MLO_ASSERT (dest_ptr != NULL);
   MLO_ASSERT (src_ptr != NULL);
   MLO_ASSERT (len > 0);

   /* Reorders data */
   buf_ptr = &imdct_ptr->buffer [0] [0];
   MLO_ASSERT (buf_ptr != src_ptr);
   for (k = 0; k < len_h; ++k)
   {
      const int      k_2 = k * 2;
      buf_ptr [        k] = src_ptr [          k_2];
      buf_ptr [len_h + k] = src_ptr [len - 1 - k_2];
   }

   /* Does FFT */
   MLO_Fft_Process (&imdct_ptr->fft, dest_ptr, buf_ptr, len);

   if (len == MLO_DEFS_FRAME_LEN_SHORT)
   {
      const int      mult = MLO_DEFS_FRAME_LEN_LONG / MLO_DEFS_FRAME_LEN_SHORT;
      step = mult;
      qpi_offset *= mult;
   }

   dest_ptr [0    ] = dest_ptr [0];
   dest_ptr [len_h] =
      MLO_Float_Mul (dest_ptr [len_h], MLO_FLOAT_C (MLO_DEFS_SQRT2 * 0.5));
   for (k = 1; k <= len_q; ++k)
   {
      /* phase = (-PI/2) * (k / len) */
      const int      index_0 = k * step;
      const int      index_1 = index_0 + qpi_offset;

      /* cos/sin (phase) */
      const MLO_Float   r_re_0 = MLO_Imdct_cos_table_2 [index_0];
      const MLO_Float   r_im_0 =
         -MLO_Imdct_cos_table_2 [MLO_DEFS_FRAME_LEN_LONG - index_0];

      /* cos/sin (phase - PI/4) */
      const MLO_Float   r_re_1 = MLO_Imdct_cos_table_2 [index_1];
      const MLO_Float   r_im_1 =
         -MLO_Imdct_cos_table_2 [MLO_DEFS_FRAME_LEN_LONG - index_1];

      const MLO_Float   f_re_0   = dest_ptr [        k];
      const MLO_Float   f_im_0_n = dest_ptr [len_h + k];
      const MLO_Float   f_re_1   = dest_ptr [len_h - k];
      const MLO_Float   f_im_1   = dest_ptr [len   - k];

      const MLO_Float   c_0 = MLO_Float_Add (
         MLO_Float_Mul (f_re_0, r_re_0),
         MLO_Float_Mul (f_im_0_n, r_im_0)
      );
      const MLO_Float   c_1 = MLO_Float_Sub (
         MLO_Float_Mul (f_re_1, r_re_1),
         MLO_Float_Mul (f_im_1, r_im_1)
      );

      const MLO_Float   c_0m = MLO_Float_Sub (
         MLO_Float_Mul (f_im_0_n, r_re_0),
         MLO_Float_Mul (f_re_0, r_im_0)
      );
      const MLO_Float   c_1m_n = MLO_Float_Add (
         MLO_Float_Mul (f_re_1, r_im_1),
         MLO_Float_Mul (f_im_1, r_re_1)
      );

      dest_ptr [        k] = c_0;
      dest_ptr [len_h + k] = c_1;
      dest_ptr [len   - k] = c_0m;
      dest_ptr [len_h - k] = MLO_Float_Neg (c_1m_n);
   }
}
