/*****************************************************************
|
|    AP4 - Crypto Test
|
|    Copyright 2002-2008 Axiomatic Systems, LLC
|
|
|    This file is part of Bento4/AP4 (MP4 Atom Processing Library).
|
|    Unless you have obtained Bento4 under a difference license,
|    this version of Bento4 is Bento4|GPL.
|    Bento4|GPL is free software; you can redistribute it and/or modify
|    it under the terms of the GNU General Public License as published by
|    the Free Software Foundation; either version 2, or (at your option)
|    any later version.
|
|    Bento4|GPL is distributed in the hope that it will be useful,
|    but WITHOUT ANY WARRANTY; without even the implied warranty of
|    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|    GNU General Public License for more details.
|
|    You should have received a copy of the GNU General Public License
|    along with Bento4|GPL; see the file COPYING.  If not, write to the
|    Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
|    02111-1307, USA.
|
 ****************************************************************/

/*----------------------------------------------------------------------
|   includes
+---------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>

#include "Ap4.h"
#include "Ap4StreamCipher.h"
#include "Ap4Hmac.h"
#include "Ap4KeyWrap.h"

unsigned char __1_bin[] = {
  0x48
};
unsigned int __1_bin_len = 1;
unsigned char __1_cbc[] = {
  0x85, 0x86, 0x05, 0x21, 0xe8, 0xef, 0xb5, 0xed, 0xeb, 0x7f, 0xc6, 0x4b,
  0xe5, 0x94, 0xab, 0x6d
};
unsigned int __1_cbc_len = 16;
unsigned char __2_bin[] = {
  0xd2, 0x0b
};
unsigned int __2_bin_len = 2;
unsigned char __2_cbc[] = {
  0xaf, 0x4c, 0xd1, 0x11, 0x4b, 0x5c, 0xc6, 0xea, 0xd4, 0x72, 0x2a, 0xed,
  0x7e, 0xde, 0x06, 0xe7
};
unsigned int __2_cbc_len = 16;
unsigned char __3_bin[] = {
  0xfe, 0xf4, 0xe8
};
unsigned int __3_bin_len = 3;
unsigned char __3_cbc[] = {
  0x6a, 0x1a, 0xb6, 0x9f, 0xa0, 0x1f, 0x81, 0xfb, 0x09, 0xfb, 0x30, 0xb8,
  0x3e, 0x04, 0x8b, 0x7a
};
unsigned int __3_cbc_len = 16;
unsigned char __4_bin[] = {
  0xad, 0x8a, 0x44, 0x83
};
unsigned int __4_bin_len = 4;
unsigned char __4_cbc[] = {
  0xcd, 0x96, 0xb0, 0x55, 0xcc, 0x65, 0x4a, 0x52, 0x01, 0x65, 0xa6, 0xc9,
  0x6a, 0xe7, 0x52, 0xb7
};
unsigned int __4_cbc_len = 16;
unsigned char __5_bin[] = {
  0x2f, 0x11, 0x22, 0xc1, 0x2b
};
unsigned int __5_bin_len = 5;
unsigned char __5_cbc[] = {
  0x8e, 0x0b, 0x0d, 0x41, 0xc2, 0x24, 0x83, 0x2b, 0x7d, 0x90, 0x7a, 0x40,
  0x46, 0xdc, 0xc1, 0x4f
};
unsigned int __5_cbc_len = 16;
unsigned char __6_bin[] = {
  0x02, 0x84, 0xc6, 0xd9, 0x64, 0x77
};
unsigned int __6_bin_len = 6;
unsigned char __6_cbc[] = {
  0xd7, 0xbd, 0x68, 0xf1, 0x6e, 0xf1, 0xaa, 0xb2, 0xa1, 0x11, 0xa6, 0x00,
  0xc6, 0x08, 0xb5, 0x9e
};
unsigned int __6_cbc_len = 16;
unsigned char __7_bin[] = {
  0x1f, 0x8e, 0x70, 0x3d, 0x5b, 0xc6, 0x66
};
unsigned int __7_bin_len = 7;
unsigned char __7_cbc[] = {
  0x0c, 0x8f, 0x6c, 0x1e, 0x37, 0x24, 0x8a, 0x06, 0xa0, 0xb9, 0xdd, 0xa6,
  0x90, 0x04, 0xb4, 0xea
};
unsigned int __7_cbc_len = 16;
unsigned char __8_bin[] = {
  0x53, 0xc0, 0x82, 0x82, 0xca, 0xf7, 0x8a, 0xf8
};
unsigned int __8_bin_len = 8;
unsigned char __8_cbc[] = {
  0xda, 0xe6, 0x27, 0x05, 0xd8, 0x68, 0xc9, 0x5d, 0x56, 0x68, 0x92, 0x1b,
  0x96, 0x8b, 0x91, 0x73
};
unsigned int __8_cbc_len = 16;
unsigned char __9_bin[] = {
  0xb3, 0x82, 0x05, 0x78, 0x24, 0x73, 0x4f, 0xc4, 0x6a
};
unsigned int __9_bin_len = 9;
unsigned char __9_cbc[] = {
  0x68, 0x8d, 0xfe, 0x30, 0xd0, 0x88, 0x84, 0x92, 0xe4, 0x35, 0x3a, 0xee,
  0x71, 0xb8, 0x2a, 0x85
};
unsigned int __9_cbc_len = 16;
unsigned char __10_bin[] = {
  0x99, 0xbf, 0xb3, 0xd5, 0xa0, 0xf4, 0x23, 0xf2, 0x0d, 0xf0
};
unsigned int __10_bin_len = 10;
unsigned char __10_cbc[] = {
  0xf3, 0x83, 0x53, 0x16, 0x80, 0x90, 0x03, 0x0e, 0x70, 0xc5, 0x13, 0x3c,
  0x39, 0x02, 0x20, 0x5c
};
unsigned int __10_cbc_len = 16;
unsigned char __11_bin[] = {
  0x63, 0xfa, 0x43, 0xb2, 0x98, 0x36, 0x33, 0x79, 0x23, 0xda, 0xf1
};
unsigned int __11_bin_len = 11;
unsigned char __11_cbc[] = {
  0x62, 0x4d, 0x8e, 0x81, 0xc8, 0x5d, 0x06, 0x41, 0x84, 0x6c, 0xbc, 0xf2,
  0x95, 0x6d, 0x14, 0xfb
};
unsigned int __11_cbc_len = 16;
unsigned char __12_bin[] = {
  0x6f, 0x01, 0xf4, 0xba, 0xb0, 0x69, 0x8b, 0x03, 0x7a, 0x0a, 0x60, 0x7a
};
unsigned int __12_bin_len = 12;
unsigned char __12_cbc[] = {
  0xf8, 0x9c, 0xff, 0x07, 0xf1, 0xc4, 0xca, 0x10, 0x65, 0xcf, 0xa4, 0x5f,
  0x0a, 0x84, 0x28, 0x4b
};
unsigned int __12_cbc_len = 16;
unsigned char __13_bin[] = {
  0xa8, 0xbf, 0xd7, 0x17, 0xca, 0xbb, 0x6b, 0xf2, 0x4f, 0xfc, 0xe4, 0x83,
  0x39
};
unsigned int __13_bin_len = 13;
unsigned char __13_cbc[] = {
  0xe8, 0xda, 0x33, 0xee, 0x94, 0x42, 0x8c, 0x8e, 0xd8, 0xa6, 0x99, 0x5b,
  0x19, 0x3c, 0xe0, 0xe2
};
unsigned int __13_cbc_len = 16;
unsigned char __14_bin[] = {
  0xf6, 0xdf, 0x5f, 0x55, 0x35, 0xca, 0xc8, 0x30, 0xad, 0x41, 0xb0, 0x5c,
  0xe4, 0xc6
};
unsigned int __14_bin_len = 14;
unsigned char __14_cbc[] = {
  0x9c, 0xc6, 0xe9, 0x9b, 0x8d, 0x4a, 0x04, 0x94, 0x2a, 0x1e, 0x48, 0x05,
  0x33, 0x84, 0x41, 0x33
};
unsigned int __14_cbc_len = 16;
unsigned char __15_bin[] = {
  0x95, 0x90, 0xc1, 0xb6, 0xe6, 0x75, 0x9c, 0x28, 0xd7, 0x2f, 0xe3, 0x92,
  0xab, 0x47, 0xb5
};
unsigned int __15_bin_len = 15;
unsigned char __15_cbc[] = {
  0x07, 0xdf, 0x4a, 0x6e, 0xa9, 0x37, 0x42, 0x09, 0xbe, 0x78, 0x2a, 0x5c,
  0xd1, 0xb4, 0x59, 0xff
};
unsigned int __15_cbc_len = 16;
unsigned char __16_bin[] = {
  0xcf, 0xc9, 0xf6, 0xe6, 0x4a, 0x6a, 0x8c, 0x39, 0xfb, 0xb7, 0xcc, 0xda,
  0x8a, 0x63, 0x7a, 0xb9
};
unsigned int __16_bin_len = 16;
unsigned char __16_cbc[] = {
  0xa2, 0xac, 0xcc, 0x9a, 0xab, 0xdc, 0x4d, 0x6c, 0x61, 0xe1, 0x03, 0x8d,
  0x83, 0xb0, 0x5f, 0xea, 0xb2, 0x62, 0xe8, 0x9d, 0x2a, 0x60, 0x02, 0xd3,
  0x9c, 0xd6, 0x74, 0x11, 0x15, 0xc4, 0x87, 0x0a
};
unsigned int __16_cbc_len = 32;
unsigned char __17_bin[] = {
  0x78, 0x3c, 0x13, 0xf8, 0xa5, 0xff, 0xb9, 0xd6, 0x3b, 0x75, 0xf1, 0xdc,
  0xbf, 0x33, 0x88, 0xc1, 0x45
};
unsigned int __17_bin_len = 17;
unsigned char __17_cbc[] = {
  0x1f, 0xde, 0x94, 0x38, 0x0e, 0x1b, 0x01, 0x9c, 0x60, 0xfe, 0xb7, 0x2e,
  0x66, 0x12, 0xff, 0x0d, 0x19, 0x89, 0x4a, 0x8c, 0xaa, 0x77, 0x1c, 0x28,
  0x79, 0x52, 0x6a, 0x36, 0x43, 0x9e, 0x7e, 0x80
};
unsigned int __17_cbc_len = 32;

unsigned char __1023_bin[] = {
  0x76, 0x03, 0x0b, 0x76, 0x94, 0x7a, 0x51, 0x79, 0xa8, 0x81, 0x73, 0x14,
  0xbf, 0x66, 0xdb, 0x34, 0xe0, 0xb1, 0x96, 0x44, 0xee, 0xec, 0xb2, 0x32,
  0x62, 0x15, 0x23, 0x70, 0xd1, 0xa9, 0x0f, 0x5d, 0xb7, 0x9e, 0x5e, 0xe3,
  0x57, 0x69, 0xe5, 0x86, 0x2f, 0x82, 0x2d, 0x86, 0xc6, 0xe8, 0x75, 0xad,
  0x47, 0xdd, 0xd5, 0x3d, 0x04, 0x29, 0x66, 0x3c, 0x1d, 0x44, 0xbe, 0xcf,
  0x11, 0x0d, 0x27, 0xd1, 0x0f, 0xd9, 0x01, 0x23, 0xbf, 0xc9, 0xf4, 0x77,
  0x80, 0x42, 0x9f, 0xb0, 0xc2, 0xe1, 0x6c, 0xbc, 0xf8, 0xaa, 0xba, 0xe6,
  0xa5, 0xcf, 0xe4, 0x94, 0x6f, 0x0e, 0x21, 0xe3, 0x8d, 0xee, 0x21, 0x1f,
  0x44, 0xa3, 0x22, 0x8d, 0x68, 0xd6, 0xb6, 0xb4, 0xb8, 0xd3, 0xe6, 0x2d,
  0xb8, 0xa9, 0xee, 0xf9, 0x06, 0x47, 0xec, 0x9a, 0xde, 0x92, 0xff, 0x4b,
  0x8e, 0x32, 0x67, 0xce, 0x60, 0x3e, 0xdb, 0xb9, 0xba, 0xfb, 0xec, 0x62,
  0xb3, 0xa6, 0xad, 0xf5, 0x0a, 0xd7, 0xb9, 0x18, 0x4b, 0x6e, 0x15, 0xa9,
  0x80, 0x95, 0xfa, 0x80, 0x9f, 0x81, 0x41, 0x19, 0x7b, 0x3c, 0xf2, 0x83,
  0x0b, 0x9b, 0xb5, 0xae, 0x48, 0x27, 0xb1, 0x0f, 0x1a, 0x34, 0x0d, 0x47,
  0xd1, 0x58, 0x1d, 0x0b, 0x53, 0x8c, 0xc8, 0xa0, 0x52, 0x9f, 0xee, 0xcf,
  0x9b, 0xc5, 0xf1, 0x07, 0x38, 0xed, 0x25, 0xeb, 0x0a, 0xbe, 0x32, 0xb4,
  0xb1, 0x63, 0x5b, 0x7b, 0xb8, 0xa2, 0x46, 0xd3, 0xe6, 0xfa, 0xf6, 0xe8,
  0xe6, 0xa3, 0x32, 0x26, 0xa2, 0xcc, 0x85, 0x81, 0x67, 0x2a, 0xf2, 0xac,
  0x10, 0x98, 0x2d, 0x88, 0xe0, 0x50, 0x5c, 0x77, 0xc0, 0x92, 0xbd, 0x2a,
  0xc7, 0xbe, 0x94, 0x2a, 0x4b, 0xcd, 0x18, 0xc4, 0xd1, 0xeb, 0xb1, 0x07,
  0x27, 0xc3, 0x2d, 0xb6, 0xbb, 0xdd, 0x80, 0x7e, 0x1e, 0xc2, 0x27, 0x0e,
  0x92, 0x89, 0x5e, 0x27, 0x6b, 0x37, 0xef, 0xd5, 0x43, 0x35, 0x28, 0x40,
  0xd4, 0xba, 0x73, 0x53, 0x8d, 0x3b, 0x98, 0xce, 0xfa, 0x3f, 0x63, 0x19,
  0xe5, 0x67, 0x49, 0x44, 0x1c, 0x7a, 0xa2, 0xda, 0x1e, 0xc4, 0xd3, 0x78,
  0x85, 0xb5, 0x80, 0xe2, 0x47, 0x16, 0xfc, 0xb4, 0xef, 0x40, 0x55, 0x44,
  0xfa, 0x30, 0x58, 0x57, 0x6c, 0x5e, 0x52, 0xc5, 0x3f, 0x07, 0x2e, 0xa7,
  0xa8, 0x99, 0x73, 0xde, 0x92, 0x63, 0x2e, 0x05, 0x40, 0xff, 0x1c, 0x10,
  0xaf, 0x65, 0x24, 0x99, 0x01, 0x32, 0xc5, 0x84, 0x3f, 0x7c, 0x52, 0x6c,
  0x9e, 0xd6, 0x9f, 0xfa, 0x94, 0x8c, 0x13, 0x08, 0xf1, 0x28, 0xde, 0x8e,
  0xba, 0xa1, 0x8d, 0xbe, 0x9f, 0x9c, 0xb9, 0x4a, 0xd5, 0x64, 0xad, 0xe6,
  0x73, 0xc5, 0xf4, 0x83, 0xe2, 0xa4, 0xd5, 0x4d, 0x2e, 0x89, 0xba, 0xa8,
  0xe4, 0xe7, 0x1c, 0xa1, 0x6c, 0x07, 0x87, 0x87, 0x74, 0x9c, 0x21, 0xcf,
  0x27, 0x7b, 0x84, 0xca, 0xc2, 0x8b, 0x58, 0x63, 0x59, 0x41, 0x80, 0xef,
  0x47, 0x5e, 0x31, 0x22, 0x7f, 0x18, 0x6f, 0x4d, 0x4a, 0xf8, 0xe7, 0x8a,
  0x8a, 0xd1, 0x1d, 0x72, 0x2f, 0x73, 0xc4, 0x4d, 0x30, 0xdc, 0x7c, 0xfb,
  0xc6, 0x92, 0x49, 0x62, 0x7c, 0x31, 0x7d, 0xd8, 0xee, 0x56, 0xe0, 0x4f,
  0x39, 0x0f, 0xf1, 0x75, 0x91, 0xcc, 0x78, 0xb3, 0x44, 0xec, 0xd7, 0xa6,
  0x7d, 0x4b, 0x39, 0x52, 0xec, 0x13, 0xaf, 0x82, 0xd4, 0xde, 0x43, 0xba,
  0x08, 0xeb, 0x68, 0x93, 0x44, 0x4c, 0xe8, 0x5b, 0x97, 0xcf, 0xd9, 0x2a,
  0x9e, 0xc8, 0xb5, 0x80, 0x32, 0x58, 0xf1, 0x5e, 0x49, 0x14, 0x18, 0x3d,
  0xd5, 0x58, 0x70, 0xfa, 0x53, 0x8f, 0x1a, 0xac, 0xe1, 0x07, 0x5f, 0x49,
  0x09, 0x99, 0xe9, 0xce, 0x18, 0xd9, 0x2e, 0xb5, 0x6d, 0xec, 0x16, 0x86,
  0xc2, 0x64, 0x6d, 0x13, 0x8f, 0x61, 0xc6, 0xf7, 0x5e, 0xeb, 0xdb, 0x7e,
  0xf9, 0x59, 0xdf, 0xae, 0x61, 0x3a, 0x01, 0xfe, 0x35, 0x93, 0xe2, 0xcb,
  0x40, 0x47, 0xd1, 0xae, 0x98, 0xab, 0x5b, 0x1e, 0x85, 0xda, 0xce, 0x94,
  0xc9, 0x8b, 0x2e, 0xc2, 0x1e, 0x6a, 0x2d, 0x22, 0x45, 0x9b, 0x22, 0xd9,
  0xc3, 0x4c, 0x55, 0xec, 0xd0, 0xd7, 0x07, 0x31, 0x68, 0x29, 0xbe, 0x79,
  0x50, 0xdd, 0xa8, 0x90, 0x29, 0x37, 0x7b, 0x81, 0xd5, 0xe4, 0x40, 0x61,
  0xac, 0xe2, 0xd9, 0xb2, 0xaf, 0x72, 0x3e, 0x4f, 0x87, 0x95, 0x92, 0xdf,
  0xda, 0x2c, 0x65, 0x63, 0x00, 0x01, 0xff, 0xf4, 0x3f, 0x8c, 0xc9, 0xde,
  0x5d, 0xcc, 0x20, 0x4c, 0xe3, 0x5d, 0x46, 0xe3, 0x7f, 0xc6, 0xd2, 0x7c,
  0xec, 0x59, 0x4b, 0x71, 0x8a, 0xa3, 0xa4, 0xf8, 0x93, 0x3d, 0x21, 0x22,
  0xa3, 0x8e, 0xe9, 0xb2, 0x37, 0xc6, 0x8a, 0x0c, 0x92, 0x3d, 0x03, 0x29,
  0xeb, 0xaf, 0xc2, 0x50, 0x40, 0x07, 0xd7, 0xc6, 0x9e, 0x7f, 0x04, 0xf1,
  0x4b, 0xe2, 0x24, 0x8f, 0xd0, 0xe3, 0xa3, 0x03, 0xa1, 0x09, 0xbd, 0x5d,
  0xbc, 0x58, 0xf4, 0xdd, 0x56, 0xe7, 0xdd, 0x99, 0xd3, 0x04, 0xcf, 0xb4,
  0xdb, 0xf7, 0x1e, 0x7c, 0x22, 0xf3, 0x50, 0x05, 0x04, 0x09, 0xb1, 0xc1,
  0xa2, 0x66, 0x82, 0x9e, 0x22, 0xcf, 0xcd, 0x55, 0x40, 0xc0, 0x9f, 0x20,
  0x1d, 0x05, 0xef, 0xd2, 0xaf, 0x94, 0xff, 0xda, 0x3d, 0xaf, 0xa9, 0xc8,
  0x9c, 0xa9, 0x63, 0xde, 0x45, 0x52, 0x6f, 0x64, 0xb4, 0xe7, 0xee, 0x79,
  0x71, 0xf4, 0x69, 0xd3, 0x4c, 0xee, 0x91, 0x59, 0xc2, 0xdc, 0x3b, 0x22,
  0xd7, 0xc8, 0xc9, 0xd2, 0x20, 0x5d, 0x3e, 0x44, 0xb2, 0xcf, 0x8d, 0x16,
  0x88, 0xce, 0x4d, 0x98, 0xdb, 0xb7, 0xef, 0x1c, 0x0e, 0x14, 0xa2, 0x87,
  0xa3, 0x71, 0xde, 0x6c, 0xac, 0x7a, 0xb6, 0x50, 0xb8, 0xd1, 0xf0, 0x19,
  0x71, 0x70, 0x88, 0xee, 0x55, 0x89, 0x43, 0xc9, 0x07, 0xbc, 0xb0, 0x5e,
  0xac, 0xd2, 0x2f, 0x7a, 0xde, 0x0a, 0x17, 0xf4, 0x71, 0x21, 0x66, 0x98,
  0x7b, 0xcf, 0xd8, 0x1f, 0x85, 0x16, 0x6f, 0x77, 0xf9, 0x9a, 0x58, 0xd8,
  0xba, 0x14, 0x85, 0xe5, 0x19, 0x56, 0x63, 0xf1, 0xf0, 0x53, 0x41, 0xe3,
  0xb9, 0x4e, 0x64, 0x27, 0x8c, 0xcf, 0xed, 0x01, 0xdd, 0x82, 0xcf, 0xba,
  0x29, 0x0b, 0x44, 0xf5, 0x20, 0x2d, 0xe3, 0x35, 0x66, 0x8d, 0x98, 0x5d,
  0xe8, 0xc0, 0xb5, 0x7f, 0xe7, 0xb3, 0xae, 0xbb, 0x02, 0x1b, 0xf8, 0xd8,
  0xad, 0xb0, 0x24, 0xcb, 0xc0, 0x70, 0x4e, 0xe5, 0x85, 0x61, 0x1f, 0xd3,
  0x19, 0x28, 0x7f, 0x4f, 0xf1, 0x55, 0xaa, 0xc3, 0xf7, 0x34, 0x74, 0x94,
  0x66, 0x1b, 0x0d, 0x80, 0x0c, 0x21, 0xe2, 0x89, 0x33, 0x54, 0xfe, 0x9b,
  0x33, 0x1c, 0x48, 0xa1, 0x33, 0x82, 0x74, 0x58, 0x9b, 0xf4, 0x07, 0xda,
  0xa3, 0xd6, 0xda, 0x7d, 0xd0, 0x66, 0xdc, 0x1d, 0x25, 0xfe, 0xf9, 0x06,
  0xde, 0x36, 0xc1, 0xa6, 0x79, 0x59, 0x70, 0xab, 0xbd, 0x8d, 0xf5, 0x88,
  0xbb, 0x41, 0xf3, 0x15, 0x95, 0xa6, 0xf0, 0x52, 0x5a, 0x3e, 0xc8, 0x92,
  0x50, 0x06, 0x09, 0x72, 0xc1, 0x4d, 0xcb, 0xad, 0x5b, 0x77, 0x28, 0x36,
  0x2f, 0xf0, 0xf4, 0x40, 0x10, 0x2c, 0x8e, 0x34, 0x61, 0x8f, 0xa3, 0x51,
  0x5a, 0x27, 0x27, 0xc4, 0x2f, 0xc6, 0x11, 0xad, 0xc1, 0x57, 0xd3, 0x25,
  0x8e, 0x16, 0x29, 0x6d, 0x92, 0x92, 0x14, 0x59, 0xfd, 0x17, 0xda, 0x10,
  0x1f, 0xdd, 0x49, 0x75, 0x03, 0x4f, 0x88, 0xd1, 0xb8, 0xed, 0x13, 0x5b,
  0xb7, 0x60, 0x10, 0x56, 0xe1, 0x61, 0xee, 0xa2, 0x08, 0x4e, 0xc0, 0x55,
  0x02, 0x7a, 0x07, 0x76, 0xd4, 0x61, 0x41, 0x5f, 0xdf, 0xf2, 0xbb, 0xd3,
  0x47, 0x51, 0x4b
};
unsigned int __1023_bin_len = 1023;
unsigned char __1023_cbc[] = {
  0x53, 0xd0, 0x5e, 0xc1, 0x38, 0xdc, 0xab, 0x60, 0xab, 0x0e, 0x19, 0x9f,
  0x79, 0x72, 0x50, 0xd1, 0xe9, 0xd1, 0x12, 0xf3, 0xbd, 0x64, 0xae, 0x5d,
  0xc1, 0xb7, 0x33, 0xc1, 0xc5, 0xd5, 0x39, 0x71, 0x75, 0x94, 0xb9, 0x4a,
  0x26, 0x4d, 0xef, 0xc5, 0x8e, 0xe8, 0x44, 0xa7, 0x53, 0xa3, 0x24, 0x4e,
  0x35, 0xff, 0x97, 0x1a, 0x5c, 0xe1, 0xbf, 0xe2, 0x94, 0x15, 0xfc, 0xb2,
  0x53, 0x6e, 0xe5, 0x15, 0x70, 0xf9, 0x7a, 0xe3, 0x96, 0x16, 0xfc, 0x20,
  0x64, 0x1e, 0xbd, 0x85, 0x4f, 0x6b, 0xa1, 0xdb, 0x51, 0xea, 0x51, 0x02,
  0x7c, 0xf1, 0xc5, 0x14, 0x87, 0x61, 0x93, 0x8b, 0xd6, 0x78, 0x21, 0x5d,
  0x86, 0xc9, 0x8d, 0xdf, 0x67, 0xf7, 0x9b, 0x5b, 0x61, 0x30, 0xd8, 0xcd,
  0x0a, 0xb5, 0x06, 0x84, 0x98, 0x04, 0xd8, 0x8f, 0x86, 0x5b, 0x52, 0xb8,
  0x9f, 0xee, 0x23, 0xb4, 0x3c, 0x9d, 0xe9, 0xab, 0x25, 0x98, 0x7c, 0x70,
  0xe3, 0x6b, 0x6d, 0xb3, 0x36, 0xf3, 0xd9, 0x94, 0x20, 0x7f, 0x62, 0x03,
  0x1e, 0x82, 0x49, 0x8d, 0x90, 0x39, 0x98, 0xd4, 0x32, 0xde, 0x49, 0x09,
  0xda, 0xb9, 0x60, 0xe6, 0x61, 0x00, 0xd4, 0x39, 0x17, 0x3f, 0x9e, 0xf8,
  0x47, 0xf5, 0xf3, 0x20, 0x41, 0x25, 0xab, 0x66, 0xfe, 0xf7, 0x07, 0xab,
  0x75, 0x0e, 0xc3, 0xd9, 0x48, 0x94, 0x80, 0xc3, 0x90, 0xbf, 0x0a, 0xd7,
  0xbf, 0xf6, 0xa1, 0x9c, 0x8b, 0xc7, 0x5d, 0xda, 0x25, 0x9b, 0x91, 0xdb,
  0x25, 0x86, 0x97, 0x07, 0x07, 0x00, 0xdb, 0x41, 0xe1, 0x1f, 0x64, 0x4b,
  0x06, 0x4f, 0xdf, 0x5f, 0xe6, 0xaa, 0x4d, 0x62, 0xc3, 0x03, 0x22, 0xe7,
  0x2a, 0xe1, 0x13, 0x6f, 0xfe, 0x2a, 0x97, 0x0e, 0xb5, 0xa1, 0x61, 0x97,
  0x28, 0x8d, 0xc0, 0x75, 0xf5, 0xb4, 0x34, 0xb5, 0x33, 0xac, 0x43, 0x60,
  0x95, 0x54, 0x94, 0x73, 0x19, 0xb0, 0x5a, 0x46, 0x0d, 0x7b, 0x32, 0x16,
  0x2f, 0x5a, 0x5d, 0x95, 0x9a, 0x2f, 0xa5, 0x2f, 0xe2, 0x98, 0x08, 0x64,
  0x32, 0x40, 0x28, 0xe8, 0x2d, 0xdc, 0xf9, 0x4c, 0x96, 0x25, 0x4b, 0x8d,
  0x17, 0xe5, 0x93, 0x90, 0xf2, 0x80, 0x85, 0x51, 0xc7, 0xd2, 0x8d, 0x6f,
  0xbc, 0x45, 0x77, 0x91, 0xa0, 0x82, 0xee, 0x7b, 0x88, 0xd1, 0x19, 0x25,
  0x78, 0x0e, 0x1f, 0x43, 0x04, 0x36, 0xd5, 0x78, 0x57, 0xef, 0x1c, 0x40,
  0xc5, 0x9e, 0xcd, 0x64, 0xfa, 0x22, 0x17, 0x1a, 0xa5, 0x9b, 0x00, 0xcb,
  0xea, 0x4b, 0x7d, 0x56, 0x3e, 0x5c, 0x54, 0x58, 0xd6, 0x8b, 0x72, 0xc8,
  0xba, 0x45, 0x26, 0x4a, 0xc9, 0x14, 0x89, 0x05, 0x81, 0xc6, 0x98, 0x49,
  0xf4, 0xf7, 0x72, 0x7f, 0x57, 0xae, 0x29, 0xab, 0xc8, 0x06, 0x60, 0x94,
  0x3d, 0x23, 0x6e, 0x7e, 0xe4, 0x4d, 0x03, 0x2f, 0x73, 0x57, 0xb9, 0x40,
  0x15, 0xa4, 0xa6, 0x3b, 0x8e, 0xf7, 0x9e, 0x54, 0xae, 0xea, 0x0c, 0xfe,
  0xa6, 0x99, 0xef, 0xcd, 0x7d, 0xe6, 0x5d, 0xef, 0x6f, 0xa7, 0x67, 0xb5,
  0xa3, 0x7c, 0x26, 0x2a, 0x19, 0x61, 0xb0, 0x13, 0x50, 0x5c, 0xf8, 0x0a,
  0x63, 0x65, 0x51, 0x31, 0xc1, 0xed, 0x5f, 0x96, 0x6f, 0xee, 0x78, 0xd5,
  0x90, 0xb5, 0x40, 0xe8, 0x99, 0x09, 0x77, 0x9e, 0x61, 0x3e, 0xc9, 0xce,
  0xbe, 0xac, 0x59, 0x31, 0x0b, 0xf2, 0xfe, 0x5c, 0x74, 0x22, 0xae, 0x2f,
  0xad, 0x7f, 0x0c, 0x3a, 0xf6, 0xf5, 0x46, 0x54, 0x48, 0x9a, 0xa4, 0x69,
  0xa5, 0xc3, 0xda, 0x6a, 0xd4, 0x39, 0xc4, 0x82, 0x73, 0xd7, 0xd7, 0xe4,
  0xde, 0xc1, 0xea, 0xa4, 0x94, 0xd1, 0xeb, 0xe9, 0xdb, 0xd6, 0xf1, 0xfe,
  0xd9, 0xfc, 0x23, 0x70, 0x2a, 0x29, 0xa7, 0x6c, 0xeb, 0xc6, 0x4a, 0x69,
  0x55, 0xbf, 0x36, 0x8e, 0x7c, 0x00, 0x22, 0x94, 0x9e, 0x3c, 0x5e, 0x14,
  0x56, 0x70, 0xcb, 0x2b, 0x68, 0x6d, 0x86, 0xd0, 0xa3, 0x7b, 0xe6, 0xc1,
  0xa1, 0x3c, 0xc9, 0x53, 0xb7, 0x11, 0x53, 0xe4, 0x5c, 0x68, 0x55, 0x0d,
  0x4b, 0x32, 0x92, 0xdf, 0xc3, 0x70, 0x10, 0x6f, 0x4d, 0xec, 0xb4, 0x89,
  0x50, 0x5d, 0x67, 0xb7, 0xac, 0x9b, 0x73, 0xc0, 0xba, 0x55, 0x8a, 0xcc,
  0xce, 0x93, 0x1f, 0x00, 0x02, 0x24, 0xe3, 0xa2, 0x6d, 0x23, 0xce, 0xc7,
  0x38, 0x51, 0xce, 0x46, 0x18, 0xf8, 0x64, 0x61, 0xdc, 0xd3, 0x23, 0x5c,
  0x6a, 0x51, 0x69, 0xe5, 0x0d, 0x92, 0xae, 0x9f, 0xbd, 0x4d, 0xb2, 0xc9,
  0x74, 0x70, 0xe4, 0xb9, 0xed, 0xbd, 0x27, 0xdd, 0x81, 0x61, 0x29, 0x92,
  0x15, 0x2a, 0x47, 0x15, 0xe0, 0x20, 0x24, 0xf6, 0x86, 0xf7, 0x01, 0xd5,
  0x8a, 0x37, 0xad, 0xab, 0x9b, 0x89, 0x43, 0xd1, 0xa5, 0x4d, 0x10, 0x7d,
  0xe1, 0xf7, 0xa8, 0xed, 0xc0, 0xed, 0x11, 0x2a, 0xee, 0x47, 0xc5, 0x3b,
  0x16, 0xbd, 0x7c, 0xaf, 0x23, 0x4b, 0x85, 0x6d, 0x88, 0x87, 0x6b, 0xac,
  0xdf, 0x01, 0x8f, 0x34, 0x6b, 0xc1, 0x8b, 0x34, 0x76, 0x38, 0x39, 0xae,
  0x2c, 0x01, 0x4f, 0xae, 0xf2, 0xd9, 0x95, 0x1e, 0x68, 0xfe, 0x6e, 0x93,
  0x43, 0x22, 0x84, 0xa5, 0x90, 0xb3, 0x1c, 0x17, 0x00, 0xfa, 0x2c, 0x18,
  0x16, 0xd4, 0x03, 0xe8, 0xc4, 0xc1, 0xc3, 0xd3, 0xa9, 0x46, 0x85, 0xca,
  0x0e, 0xdf, 0x21, 0xf2, 0xf6, 0xc4, 0x0a, 0x8a, 0xb1, 0xb9, 0x03, 0xb3,
  0x12, 0xcd, 0x30, 0x93, 0xc0, 0x8c, 0xa3, 0x3e, 0x4d, 0x89, 0x8d, 0x33,
  0x04, 0x7d, 0x8d, 0x7d, 0x9e, 0xc7, 0xbc, 0x26, 0x22, 0x9a, 0x8a, 0x69,
  0x10, 0xf7, 0x0a, 0x86, 0x07, 0x10, 0xc5, 0xba, 0x83, 0x53, 0x0b, 0xcf,
  0x92, 0xa7, 0x20, 0x6d, 0x66, 0xde, 0xe8, 0x51, 0x51, 0xb0, 0xa4, 0x1d,
  0x1e, 0xee, 0x95, 0x94, 0x34, 0xe4, 0x1c, 0x5a, 0x40, 0x6d, 0x96, 0xc0,
  0xd6, 0x35, 0xc8, 0x4c, 0x1c, 0x84, 0x7b, 0x32, 0xb9, 0x7a, 0x7e, 0xea,
  0xf4, 0xc2, 0xbb, 0x2d, 0x49, 0xe7, 0x7e, 0x1e, 0xef, 0x6a, 0x25, 0xf7,
  0xbb, 0x91, 0x9c, 0x81, 0xa5, 0x53, 0x0f, 0xc3, 0xc5, 0xa4, 0xf1, 0x2b,
  0x39, 0x5c, 0x5a, 0x4c, 0x63, 0x58, 0xc0, 0x3e, 0x11, 0x7d, 0x5c, 0x33,
  0x68, 0x2f, 0xd2, 0x37, 0xe9, 0x77, 0x4a, 0x80, 0x1c, 0x6c, 0x38, 0x7c,
  0x51, 0x30, 0x07, 0xf5, 0x92, 0x4d, 0xb7, 0xf6, 0x93, 0x81, 0x0c, 0xaa,
  0x91, 0x14, 0xc5, 0xe8, 0x91, 0xb6, 0x91, 0x36, 0xfe, 0x41, 0x84, 0x89,
  0x0a, 0xe9, 0x0e, 0x45, 0x05, 0xae, 0xdc, 0x08, 0x35, 0x3f, 0x67, 0x8c,
  0x90, 0x25, 0xa5, 0x69, 0x0c, 0xdc, 0xba, 0xb5, 0x3d, 0x0c, 0xa8, 0xa5,
  0x93, 0x9d, 0x74, 0x7c, 0x1a, 0x98, 0xcb, 0xc6, 0xaf, 0x0a, 0xfb, 0xdc,
  0xfb, 0x45, 0x82, 0x0f, 0x29, 0xd3, 0xf3, 0x50, 0x31, 0xe8, 0xa4, 0xd5,
  0x0f, 0x7a, 0xb3, 0x97, 0x81, 0xb5, 0x34, 0x59, 0x98, 0x19, 0xf1, 0x46,
  0x62, 0xd2, 0xf5, 0x7a, 0x55, 0xe3, 0x34, 0x59, 0x53, 0x4b, 0x57, 0xeb,
  0x76, 0x4f, 0x83, 0x64, 0x4a, 0x06, 0x76, 0x19, 0x70, 0xbf, 0x74, 0x22,
  0xc5, 0x51, 0x75, 0xb6, 0xef, 0x78, 0xfa, 0x48, 0xa4, 0xcf, 0xd3, 0x70,
  0xb1, 0xc4, 0xc4, 0x08, 0x5c, 0x0c, 0x11, 0x50, 0xef, 0x9a, 0x76, 0x0e,
  0xe0, 0x50, 0x99, 0x87, 0xf7, 0xb8, 0x93, 0x69, 0xed, 0x4f, 0xd0, 0xfc,
  0x4d, 0x48, 0x63, 0x0e, 0xea, 0x38, 0x15, 0x5f, 0x1c, 0x22, 0xa6, 0xe2,
  0x13, 0x64, 0xa3, 0x46, 0x0d, 0x26, 0x3c, 0x31, 0x0f, 0x61, 0x08, 0xa4,
  0xe9, 0x65, 0x54, 0x78, 0x50, 0xc7, 0xf6, 0xe9, 0x4f, 0xab, 0xac, 0xb4,
  0x91, 0x27, 0xef, 0xd2
};
unsigned int __1023_cbc_len = 1024;
unsigned char __1024_bin[] = {
  0x43, 0x4d, 0xd0, 0x95, 0xcb, 0x3e, 0x7d, 0xed, 0xbd, 0x8c, 0x6f, 0x47,
  0x2e, 0xdb, 0x08, 0x09, 0x94, 0x98, 0xf4, 0xcb, 0x48, 0xcd, 0x51, 0xf5,
  0x72, 0xf1, 0xf6, 0x89, 0x7d, 0x19, 0x66, 0x4a, 0x38, 0x3c, 0x0e, 0x0e,
  0x4a, 0xee, 0x94, 0xaa, 0xd1, 0x86, 0xd1, 0xfb, 0xc5, 0x34, 0x7f, 0x2f,
  0x0a, 0x60, 0xc6, 0xa9, 0x42, 0xf8, 0x76, 0x2e, 0x74, 0x27, 0x6f, 0x5f,
  0x39, 0xa1, 0x7f, 0xd6, 0xb8, 0x52, 0x22, 0x81, 0x6f, 0x99, 0xa8, 0x51,
  0xcb, 0x1e, 0xc1, 0xe6, 0xe6, 0xee, 0x3e, 0xbe, 0xb7, 0xb5, 0x00, 0x68,
  0xd7, 0x1a, 0x4d, 0xd4, 0x9a, 0x27, 0xeb, 0x55, 0xe0, 0xad, 0x93, 0xf3,
  0x28, 0x32, 0xa7, 0x2e, 0x02, 0x93, 0xa7, 0xb5, 0xe8, 0x79, 0xf2, 0x0c,
  0xb4, 0x27, 0x62, 0x18, 0xb3, 0xe3, 0xe8, 0x7c, 0xa0, 0xc0, 0x5b, 0xc1,
  0x50, 0x26, 0xa8, 0xcf, 0xd5, 0x3b, 0xec, 0x9e, 0x8e, 0xd5, 0x6d, 0x80,
  0xde, 0x88, 0x50, 0x67, 0x62, 0xf2, 0x36, 0xeb, 0x26, 0x8a, 0xdf, 0x48,
  0x0e, 0x38, 0x1e, 0x5f, 0x1a, 0x73, 0x0e, 0x2d, 0x92, 0xb3, 0x1c, 0x94,
  0x16, 0x02, 0x87, 0x03, 0xd3, 0xaf, 0x23, 0xf3, 0x26, 0x0a, 0x41, 0x6e,
  0x2c, 0x67, 0x5f, 0xb7, 0x9e, 0xe3, 0x6e, 0x8a, 0x8f, 0x69, 0xc9, 0x7f,
  0x33, 0xae, 0xc8, 0x2b, 0x22, 0xc8, 0xd7, 0x49, 0x68, 0xd0, 0xf5, 0x82,
  0x1d, 0xb0, 0x2e, 0x77, 0x8c, 0xf5, 0x6e, 0x90, 0x72, 0x88, 0x89, 0x68,
  0xf8, 0x49, 0x60, 0xf9, 0xd4, 0xce, 0xdb, 0xf8, 0x74, 0x2b, 0x93, 0x68,
  0x2a, 0x5e, 0x71, 0xeb, 0x1d, 0x9f, 0xb8, 0x02, 0x7a, 0x0d, 0x83, 0xab,
  0x16, 0x0c, 0xd3, 0xf3, 0x3f, 0x47, 0xc7, 0x4e, 0xc1, 0xc8, 0x8d, 0xed,
  0xcc, 0xdf, 0xc7, 0xf8, 0x10, 0x3d, 0x23, 0x13, 0xd2, 0x6b, 0xe4, 0x58,
  0x78, 0xd6, 0x74, 0x57, 0xb3, 0xfa, 0x9c, 0x7c, 0x55, 0x97, 0xe3, 0x44,
  0x59, 0xec, 0x22, 0xdd, 0x58, 0xdf, 0xec, 0x4d, 0x06, 0xd0, 0x57, 0xd6,
  0x25, 0x6c, 0x3d, 0x05, 0x1c, 0x9c, 0x26, 0x0b, 0xfc, 0x0f, 0xdb, 0xb6,
  0x40, 0x7d, 0xdf, 0xe5, 0x69, 0x08, 0xc0, 0x91, 0xcd, 0xe5, 0x41, 0xff,
  0xde, 0x03, 0xf2, 0x1c, 0xd9, 0x66, 0x77, 0xdb, 0x25, 0xbf, 0xdf, 0xf2,
  0x23, 0x1e, 0x59, 0xa2, 0x7d, 0xbb, 0x15, 0xf9, 0x1f, 0x9a, 0x13, 0xda,
  0x1c, 0x72, 0x74, 0xfe, 0xc5, 0x4d, 0x21, 0x2e, 0x86, 0x37, 0xbb, 0xd6,
  0x80, 0xbf, 0x9e, 0x43, 0x14, 0x53, 0xa5, 0xe8, 0xc9, 0xa5, 0xb6, 0xc9,
  0x7a, 0xd6, 0x5e, 0x0e, 0x8f, 0x41, 0x4e, 0xc8, 0x00, 0xcb, 0x7d, 0xb7,
  0xb9, 0x78, 0x57, 0x7c, 0x4b, 0x6e, 0x66, 0x8f, 0x5c, 0xd3, 0xc1, 0x76,
  0xbd, 0x6d, 0x71, 0xa3, 0x43, 0x9f, 0x1b, 0x99, 0xd2, 0xe3, 0x32, 0x06,
  0x7f, 0xff, 0xa8, 0x22, 0x95, 0x31, 0x65, 0xa8, 0x65, 0x7f, 0x94, 0x08,
  0xd0, 0x0c, 0x81, 0xaa, 0x51, 0x5b, 0x04, 0x09, 0x4d, 0x7f, 0xc2, 0xc6,
  0x18, 0x3f, 0x7d, 0x78, 0xd0, 0x9f, 0xd9, 0x98, 0xc5, 0xa4, 0xe4, 0xe3,
  0xc8, 0x76, 0xc8, 0x43, 0xe8, 0xef, 0xe5, 0xb6, 0xa5, 0x58, 0x1b, 0x72,
  0x45, 0x1a, 0xef, 0x67, 0xaa, 0xc6, 0xb5, 0x7f, 0x84, 0x32, 0x7b, 0x0d,
  0x82, 0x6f, 0x6a, 0x2f, 0x6f, 0x92, 0x97, 0xb5, 0x9e, 0x08, 0x0e, 0x55,
  0x71, 0xa5, 0x76, 0xdb, 0xb1, 0x5d, 0x52, 0x2e, 0x94, 0x2e, 0xea, 0x2f,
  0x6e, 0x71, 0xe2, 0x6c, 0x38, 0x58, 0x4d, 0xba, 0x9f, 0x0a, 0x91, 0x73,
  0x9f, 0xf3, 0x2e, 0xf1, 0xe9, 0x0a, 0xd0, 0x99, 0xd3, 0xce, 0x45, 0xbb,
  0x6c, 0x1d, 0xa7, 0x69, 0xe6, 0x68, 0xb0, 0x60, 0xd7, 0xe6, 0x99, 0x74,
  0x93, 0x07, 0x27, 0xa9, 0xe1, 0x62, 0x4d, 0xb9, 0xcd, 0x2e, 0x06, 0xde,
  0xeb, 0x1c, 0xaa, 0x49, 0xd0, 0x32, 0xd0, 0xfe, 0x99, 0xf0, 0x52, 0x98,
  0xbc, 0xaa, 0x71, 0xd5, 0x50, 0x83, 0x6c, 0x0e, 0xa0, 0x06, 0xc6, 0xf2,
  0xaf, 0x33, 0x16, 0xd0, 0x00, 0x5b, 0xa8, 0xa8, 0x75, 0x29, 0x11, 0xb1,
  0x73, 0x63, 0xf8, 0x24, 0x19, 0x6c, 0x5d, 0x5c, 0xd7, 0x92, 0x6a, 0x23,
  0x1c, 0xd6, 0x81, 0xb3, 0x88, 0xa5, 0x7b, 0x63, 0x63, 0xa3, 0x6d, 0x02,
  0xb1, 0x81, 0x13, 0x67, 0xc8, 0x60, 0x8e, 0x54, 0x00, 0xa5, 0xf1, 0xb7,
  0xf3, 0xaf, 0xc7, 0x1a, 0x27, 0x89, 0x5f, 0x26, 0xdb, 0x24, 0xd6, 0xeb,
  0x50, 0x2f, 0xb8, 0xe4, 0x5b, 0x1a, 0x5c, 0xd3, 0x91, 0x58, 0x2d, 0xac,
  0xf4, 0xb4, 0x2a, 0x02, 0xab, 0xb7, 0xe4, 0x70, 0x00, 0x12, 0x29, 0x97,
  0xf0, 0x01, 0x52, 0xb9, 0x4a, 0xc4, 0x12, 0x91, 0xe1, 0xa2, 0x0b, 0x89,
  0xe2, 0xa4, 0xfa, 0xc3, 0x94, 0xd1, 0x3f, 0x7a, 0x3b, 0x7c, 0xe2, 0x51,
  0x64, 0xdc, 0x6c, 0xbc, 0x39, 0x3d, 0x01, 0xbc, 0x46, 0x02, 0x22, 0x86,
  0xbb, 0xbf, 0x1a, 0xae, 0x67, 0x4d, 0xe2, 0xc2, 0x36, 0xe8, 0x15, 0xe6,
  0x2f, 0xce, 0xf2, 0x2e, 0xda, 0x94, 0x6f, 0x3e, 0x8b, 0x8b, 0x05, 0x0d,
  0x43, 0xe3, 0x9b, 0xb1, 0x01, 0x34, 0x78, 0x4a, 0x92, 0x77, 0x77, 0x13,
  0x92, 0x12, 0x2c, 0x15, 0x9b, 0xa7, 0x4a, 0x26, 0x07, 0x85, 0x99, 0x9f,
  0x95, 0xd6, 0x85, 0xb4, 0xcc, 0x7d, 0x00, 0x16, 0x73, 0xbd, 0x83, 0x1e,
  0xb7, 0xc4, 0xcd, 0x75, 0x0f, 0x95, 0xf6, 0x9a, 0x44, 0x14, 0x1d, 0xd5,
  0x20, 0x00, 0xe2, 0xa9, 0x7a, 0x82, 0xc1, 0x55, 0xb6, 0xe7, 0xd3, 0x56,
  0xf2, 0x64, 0x44, 0x3e, 0x07, 0xb0, 0xdf, 0xdd, 0x91, 0xac, 0x6a, 0x07,
  0x4f, 0x4c, 0xe1, 0x45, 0x12, 0x22, 0xdf, 0x6d, 0x47, 0x2c, 0x1c, 0x39,
  0x34, 0x9d, 0x05, 0x5f, 0x97, 0x1a, 0x2a, 0x7c, 0x57, 0x88, 0x7d, 0x6c,
  0x3d, 0x73, 0x4b, 0xd5, 0x7f, 0x8f, 0x55, 0x2c, 0x5b, 0xdc, 0x4c, 0x1f,
  0xa0, 0x1c, 0xb7, 0xf7, 0xa7, 0x03, 0x1f, 0x75, 0xe7, 0x0a, 0x58, 0xa6,
  0xc8, 0x60, 0x60, 0xc3, 0x95, 0x5e, 0xf3, 0xfb, 0x97, 0x88, 0x00, 0xb0,
  0x07, 0xdf, 0xb9, 0xda, 0xec, 0x66, 0x5b, 0xd6, 0x84, 0x21, 0xfd, 0xef,
  0xd7, 0x5d, 0x1d, 0xc6, 0xaf, 0xf6, 0xbf, 0x8d, 0xc6, 0x80, 0x94, 0xde,
  0x45, 0xd0, 0x5f, 0xf8, 0xee, 0x28, 0xe6, 0xa3, 0xce, 0x80, 0xd2, 0xa3,
  0x63, 0x4a, 0x54, 0x60, 0x30, 0x67, 0xd4, 0x42, 0xdc, 0x6e, 0x28, 0x44,
  0x3c, 0x10, 0x88, 0x24, 0x3b, 0xe7, 0x8d, 0x5a, 0x44, 0xa3, 0xd4, 0x37,
  0x87, 0xa0, 0x54, 0x92, 0x7f, 0x5a, 0xe5, 0xeb, 0x53, 0xbf, 0x64, 0xfe,
  0x8b, 0x16, 0x19, 0x04, 0x32, 0x20, 0x91, 0xe7, 0x24, 0x4b, 0x97, 0x03,
  0xa0, 0xbd, 0xc8, 0x52, 0xc3, 0x8f, 0x47, 0x26, 0x68, 0x0c, 0x64, 0xb3,
  0x98, 0x4e, 0x44, 0xc9, 0xdb, 0x18, 0xab, 0x42, 0xfa, 0xb2, 0xe6, 0x34,
  0x8e, 0x71, 0xb6, 0x68, 0xb1, 0x02, 0x08, 0x6a, 0x80, 0xcc, 0x26, 0x44,
  0x0c, 0xe3, 0x9d, 0x36, 0x73, 0xdc, 0x73, 0x64, 0xbc, 0xb1, 0xef, 0x68,
  0xa8, 0xd4, 0x95, 0xd0, 0x71, 0x84, 0x6f, 0x95, 0xb2, 0x74, 0x5d, 0x7e,
  0xf5, 0xaa, 0x3b, 0xa9, 0x1b, 0x10, 0x67, 0x51, 0xd2, 0x86, 0x48, 0x0d,
  0x25, 0x94, 0x5a, 0x42, 0x83, 0x58, 0x08, 0xdc, 0x82, 0x8a, 0xd0, 0x2d,
  0xd1, 0x7d, 0x2b, 0x0a, 0x25, 0x70, 0x01, 0x6f, 0x70, 0x06, 0x20, 0xf4,
  0x66, 0xf8, 0x75, 0xf8, 0xc5, 0x14, 0x85, 0x97, 0x5a, 0x35, 0x04, 0x00,
  0xe2, 0x8f, 0x29, 0x1f, 0x2d, 0x10, 0x1f, 0x0b, 0x5f, 0xf5, 0x10, 0xf1,
  0x11, 0x9a, 0x9b, 0x4f
};
unsigned int __1024_bin_len = 1024;
unsigned char __1024_cbc[] = {
  0x5f, 0x10, 0xa7, 0x07, 0x9e, 0x8b, 0x85, 0x2a, 0x69, 0xa1, 0x49, 0x50,
  0xfd, 0x89, 0x3a, 0x98, 0xd0, 0x2d, 0x46, 0x6c, 0x88, 0xf5, 0x3e, 0xba,
  0x2e, 0xbc, 0x58, 0x19, 0x7d, 0xf0, 0xcf, 0x8b, 0xd2, 0x97, 0xf7, 0x02,
  0x25, 0x82, 0x7f, 0xeb, 0x97, 0xf6, 0xf0, 0x05, 0x98, 0x6c, 0x29, 0xd6,
  0x13, 0x62, 0x6e, 0x11, 0xe2, 0xe5, 0x3b, 0xe1, 0xf3, 0x86, 0x13, 0x95,
  0x77, 0xdd, 0x3a, 0x75, 0x12, 0xa1, 0xa6, 0x18, 0x51, 0xe2, 0xb4, 0x5e,
  0xef, 0xb6, 0xc0, 0x8e, 0xda, 0x45, 0xf6, 0xd6, 0x87, 0x3f, 0x8a, 0x69,
  0xdb, 0x26, 0xaa, 0x88, 0x68, 0x80, 0x8d, 0xed, 0xc2, 0x78, 0x1b, 0x55,
  0x34, 0x6e, 0x83, 0x83, 0x12, 0xe1, 0xc8, 0x08, 0x35, 0x29, 0x46, 0x51,
  0x31, 0xdf, 0x4e, 0x00, 0xd6, 0x27, 0x51, 0xcc, 0x54, 0xf2, 0x12, 0x55,
  0x28, 0x9f, 0xe0, 0xe5, 0x86, 0xed, 0x80, 0x65, 0xa1, 0xdb, 0xa5, 0x5a,
  0xee, 0xf0, 0x5a, 0x87, 0x02, 0x2b, 0x89, 0x41, 0xd5, 0x62, 0x40, 0x3d,
  0xa3, 0x88, 0xad, 0x4c, 0x33, 0xfd, 0xa7, 0xb4, 0x96, 0xda, 0x15, 0xb8,
  0x6d, 0xc1, 0x34, 0xf5, 0xb1, 0x58, 0x27, 0x4f, 0xc3, 0x41, 0x12, 0xcc,
  0x4d, 0x94, 0xb1, 0x4f, 0x33, 0x31, 0x34, 0xcd, 0x63, 0xca, 0xb3, 0x72,
  0x14, 0xe3, 0x3e, 0xc5, 0x73, 0xe1, 0x86, 0x77, 0x54, 0xcf, 0xf7, 0x16,
  0xc9, 0xd8, 0x0c, 0xe0, 0x5b, 0xbb, 0xdc, 0xcf, 0xaa, 0x4a, 0xe2, 0xdc,
  0xf2, 0x95, 0x63, 0x07, 0xb4, 0x90, 0x3b, 0x47, 0xcb, 0x1d, 0xac, 0x8c,
  0x31, 0xd6, 0xcc, 0x10, 0xf0, 0x16, 0xee, 0x6c, 0x26, 0x8f, 0x7c, 0xa2,
  0x77, 0xba, 0x0a, 0x70, 0x1a, 0x37, 0x25, 0x6f, 0xac, 0xdc, 0xa9, 0x4f,
  0x1e, 0x67, 0xad, 0xc7, 0xc8, 0x3b, 0xbb, 0x17, 0x94, 0x36, 0xab, 0x40,
  0x3c, 0x55, 0x23, 0x63, 0x30, 0x6f, 0x0f, 0xa9, 0x47, 0xe5, 0x35, 0x4b,
  0xe8, 0x2e, 0xe8, 0x9b, 0xf4, 0x3b, 0x75, 0x7e, 0x69, 0x7d, 0x1d, 0x6c,
  0x4b, 0xcd, 0x37, 0x9e, 0x99, 0xe3, 0xd4, 0xda, 0xf0, 0xe8, 0x4d, 0x93,
  0x00, 0x61, 0x13, 0x04, 0xa3, 0xd9, 0x77, 0xd6, 0x96, 0xae, 0xc8, 0x86,
  0x22, 0xe9, 0x50, 0xe6, 0x0f, 0xf1, 0x51, 0x4b, 0x6a, 0xf9, 0xf0, 0x2e,
  0x6e, 0x22, 0xbc, 0x94, 0x30, 0x1c, 0x37, 0x19, 0xd1, 0x4c, 0x88, 0xe8,
  0x17, 0xb7, 0x66, 0x5a, 0x2e, 0x2f, 0xee, 0x09, 0x83, 0x1f, 0x19, 0xf4,
  0xc5, 0xea, 0x6f, 0x3a, 0xeb, 0xdd, 0x70, 0xb5, 0xf4, 0x9c, 0x1c, 0xf2,
  0x1c, 0x2e, 0x03, 0x9a, 0xc8, 0x24, 0xf1, 0x51, 0xd1, 0x93, 0xf7, 0xd2,
  0xf5, 0x8a, 0x87, 0xb4, 0x4b, 0xf2, 0x59, 0x80, 0xf5, 0x2b, 0x3c, 0x1d,
  0x2f, 0xf3, 0xb9, 0x99, 0xa1, 0xc9, 0x5f, 0xe7, 0x9d, 0x46, 0xed, 0xbc,
  0x7e, 0x0a, 0x98, 0x57, 0xcc, 0x81, 0x14, 0x05, 0x0d, 0xbe, 0x5f, 0xf9,
  0x9f, 0x14, 0x80, 0x10, 0x57, 0x99, 0x17, 0x87, 0x7c, 0x1d, 0x65, 0x24,
  0x05, 0xca, 0x73, 0x15, 0xa1, 0xf0, 0x45, 0x29, 0x47, 0x45, 0x8b, 0x8e,
  0x5a, 0x65, 0x79, 0xb4, 0xdb, 0xab, 0x7a, 0xdd, 0x9a, 0x1a, 0x7c, 0xcc,
  0x0f, 0xd3, 0xf4, 0x1c, 0xe9, 0x2b, 0x46, 0xd9, 0x1b, 0xb6, 0x05, 0xc1,
  0x06, 0xe4, 0xfa, 0x65, 0xe4, 0x7c, 0xcc, 0x09, 0x25, 0x52, 0x5e, 0xd5,
  0x1e, 0xf4, 0x31, 0x75, 0xe4, 0xf6, 0xb6, 0x3b, 0x53, 0xc4, 0xec, 0xcc,
  0xa5, 0x62, 0xf7, 0x0a, 0x17, 0x44, 0x9a, 0xbf, 0xfe, 0x27, 0xe3, 0x49,
  0x6b, 0x46, 0x53, 0xf3, 0x76, 0x10, 0xb1, 0xc6, 0x30, 0x52, 0x84, 0xd0,
  0x00, 0xcb, 0xca, 0xca, 0x71, 0x89, 0x3f, 0x11, 0x7b, 0x51, 0xf5, 0x14,
  0x5f, 0x60, 0x2b, 0x18, 0x36, 0x45, 0x99, 0x66, 0x12, 0xa6, 0xaf, 0xfe,
  0x1f, 0xd0, 0x1c, 0x35, 0xe3, 0x1f, 0xcf, 0x4c, 0x7d, 0x5f, 0xb9, 0x16,
  0xdc, 0xb5, 0xa6, 0xf2, 0x6d, 0xc7, 0xe5, 0x8f, 0x00, 0xa8, 0x66, 0x9f,
  0x3c, 0x26, 0xd5, 0x15, 0xda, 0xae, 0x6e, 0xc7, 0x59, 0x98, 0xab, 0x6e,
  0x48, 0xff, 0xda, 0xeb, 0x69, 0x32, 0x87, 0x2a, 0x00, 0x81, 0xb0, 0x9b,
  0xab, 0x9f, 0x59, 0xf8, 0xf9, 0x76, 0x37, 0xfb, 0x2a, 0x5c, 0xff, 0xc8,
  0x10, 0xf0, 0xa3, 0x14, 0x2e, 0xdd, 0x1b, 0x43, 0x8b, 0xc6, 0x23, 0xf1,
  0x76, 0xb2, 0xaf, 0x1f, 0x0e, 0xe6, 0x7f, 0xf4, 0x4a, 0xc4, 0xbf, 0x34,
  0xe4, 0x19, 0xe9, 0x47, 0x39, 0x57, 0x31, 0x19, 0x41, 0x70, 0xb0, 0x8c,
  0x3c, 0xf4, 0x3e, 0x03, 0x2d, 0x26, 0xe2, 0xc5, 0x0c, 0xe9, 0x29, 0x96,
  0x27, 0xb9, 0x13, 0x03, 0x77, 0x09, 0x70, 0x76, 0xce, 0xd8, 0x72, 0x2a,
  0x83, 0x90, 0xb7, 0xd4, 0x47, 0x0b, 0xc9, 0x86, 0x1f, 0x0e, 0x23, 0xe4,
  0xe0, 0xfa, 0x94, 0x9d, 0xcf, 0x7a, 0x4a, 0x79, 0x35, 0xfd, 0x36, 0x54,
  0xc6, 0x19, 0x49, 0x25, 0xae, 0x18, 0xf4, 0x76, 0x5f, 0xd1, 0x4f, 0x88,
  0xdc, 0x25, 0x2f, 0x30, 0xcf, 0xf8, 0xf1, 0x60, 0x5f, 0x4a, 0x12, 0xdb,
  0xa9, 0x1c, 0x1b, 0xea, 0xfa, 0xa6, 0xc0, 0x53, 0xf1, 0x9f, 0x32, 0x0b,
  0xf8, 0x03, 0xdb, 0x0e, 0x69, 0x83, 0xd8, 0xfe, 0x1b, 0x60, 0xd7, 0x42,
  0x37, 0xfc, 0x9f, 0xa2, 0x96, 0x5a, 0x7c, 0x69, 0x0f, 0x18, 0xcd, 0xfa,
  0xb3, 0xad, 0xbc, 0x30, 0x44, 0xf3, 0x9c, 0x93, 0x24, 0x9b, 0x63, 0xd0,
  0xb8, 0x53, 0xa9, 0xdf, 0x50, 0x51, 0x4b, 0x93, 0x1a, 0x67, 0xf4, 0xb7,
  0x05, 0x14, 0x38, 0xe5, 0x21, 0xca, 0xf4, 0xaf, 0x88, 0x0d, 0x04, 0x4f,
  0x9f, 0x68, 0xe5, 0x2a, 0x1f, 0x87, 0xc1, 0x2e, 0xa7, 0xf4, 0x4d, 0xe7,
  0x9e, 0x73, 0x2b, 0x67, 0x75, 0x25, 0xf8, 0xb9, 0xba, 0x64, 0x23, 0x57,
  0x66, 0x05, 0x49, 0x84, 0x41, 0x20, 0xda, 0x64, 0xc0, 0xa3, 0xc3, 0xf3,
  0xa8, 0x5f, 0x36, 0x72, 0xc8, 0x5e, 0xb3, 0xac, 0x4c, 0x1b, 0x2c, 0x19,
  0x59, 0x5a, 0xc0, 0x61, 0x13, 0x3a, 0x0c, 0x64, 0xa3, 0xb7, 0x8f, 0x46,
  0x34, 0x7e, 0x68, 0xac, 0x3a, 0x3a, 0xc5, 0xa4, 0x4e, 0x45, 0x8f, 0x82,
  0x34, 0x07, 0x46, 0x2f, 0xd1, 0xe1, 0xbf, 0x08, 0x1b, 0xba, 0x1e, 0xd4,
  0xca, 0x70, 0xaa, 0x30, 0xbf, 0x59, 0xa4, 0x6d, 0x2d, 0x92, 0x33, 0xc3,
  0x3b, 0xa2, 0x5c, 0x0a, 0xd5, 0xaa, 0xd8, 0xb3, 0xd5, 0x0c, 0xcb, 0x92,
  0x0f, 0x6a, 0x9a, 0x9e, 0x55, 0x83, 0xa5, 0x85, 0x6b, 0x3a, 0xbe, 0x64,
  0x51, 0xd6, 0x91, 0x23, 0x5d, 0x73, 0x04, 0xca, 0xb8, 0xfe, 0x4c, 0xe3,
  0x3d, 0xaf, 0x8b, 0xad, 0xcd, 0x06, 0x8f, 0x10, 0x30, 0x80, 0xc1, 0x68,
  0xd4, 0x3e, 0x97, 0x99, 0xd5, 0x5c, 0x7b, 0x8d, 0xe0, 0x38, 0xa5, 0x9f,
  0x18, 0xe0, 0x8d, 0xb8, 0xd3, 0x95, 0x6e, 0x42, 0xf8, 0x4f, 0x16, 0x2a,
  0xa7, 0xca, 0x2c, 0x42, 0x82, 0xc2, 0xd0, 0x9e, 0x65, 0xbd, 0x8a, 0x62,
  0x0c, 0x76, 0x9e, 0xba, 0xc8, 0x68, 0xd0, 0x31, 0xe2, 0x75, 0xee, 0x8f,
  0xc9, 0x8b, 0x2a, 0xf2, 0x44, 0x52, 0xd4, 0x5e, 0xdd, 0xe1, 0xab, 0x74,
  0xaf, 0xc2, 0xbc, 0x8c, 0x1e, 0x41, 0x3e, 0x0e, 0x2d, 0x61, 0xd1, 0xbc,
  0x42, 0x7a, 0xca, 0x88, 0x92, 0x09, 0x97, 0xb6, 0x7c, 0x6b, 0x13, 0xe3,
  0xfd, 0x73, 0xa5, 0x9d, 0x7e, 0xde, 0xf5, 0xa3, 0x44, 0x91, 0x72, 0x63,
  0xd7, 0xed, 0x3d, 0xa1, 0x0f, 0xa0, 0x65, 0x27, 0x28, 0x02, 0x35, 0xb5,
  0x1c, 0x60, 0x28, 0x09, 0xc9, 0x27, 0x6d, 0x04, 0x03, 0x67, 0xe7, 0xcf,
  0xb6, 0x42, 0xc7, 0x5a, 0xe6, 0x87, 0x43, 0x57, 0x53, 0xb1, 0x95, 0xa8,
  0x31, 0x0b, 0x35, 0xa4, 0x19, 0xf2, 0x06, 0xd3
};
unsigned int __1024_cbc_len = 1040;
unsigned char __1025_bin[] = {
  0xaa, 0x34, 0xd0, 0xbd, 0x90, 0xa5, 0x0a, 0xdf, 0x69, 0xc1, 0x47, 0xde,
  0xf7, 0x3c, 0x86, 0xa3, 0x5b, 0x9b, 0xa7, 0x38, 0x44, 0xc4, 0x3d, 0x3a,
  0x52, 0xdc, 0xb6, 0x39, 0x97, 0x39, 0xca, 0xb3, 0x1d, 0xec, 0xc4, 0xfe,
  0x0f, 0xf9, 0x9e, 0xdb, 0xa1, 0x32, 0xa0, 0xa6, 0xfb, 0x97, 0x1e, 0x0d,
  0x2a, 0xb2, 0x7a, 0x67, 0xdf, 0xe2, 0xf5, 0x7d, 0xa5, 0xb0, 0x2d, 0x84,
  0x86, 0x8b, 0x71, 0xb2, 0xc1, 0xc9, 0xcc, 0x5f, 0x99, 0xf4, 0x91, 0xa6,
  0x66, 0x6f, 0x6b, 0xd7, 0x3d, 0xd1, 0x1e, 0xcc, 0x00, 0x4c, 0xe8, 0xf6,
  0xa7, 0x2e, 0x7d, 0x10, 0x08, 0x47, 0x58, 0xce, 0xe5, 0x16, 0xee, 0xc1,
  0x7d, 0xa6, 0x08, 0xbd, 0x5d, 0x1c, 0x7d, 0x5a, 0x65, 0x5a, 0xca, 0xfd,
  0xad, 0xe6, 0x0a, 0x74, 0x05, 0x1e, 0x0e, 0xa1, 0xb9, 0x85, 0xba, 0x0d,
  0xb7, 0x5b, 0x8d, 0x30, 0x41, 0x50, 0xe4, 0x29, 0xe0, 0xcf, 0x3a, 0xc8,
  0xcb, 0x8e, 0xa8, 0xad, 0xa0, 0x02, 0xd2, 0x90, 0xbf, 0xc8, 0xaa, 0x72,
  0x07, 0x61, 0x1a, 0x38, 0x75, 0xcd, 0x78, 0x30, 0x33, 0xce, 0xb1, 0xa4,
  0x09, 0x5e, 0xd0, 0x1c, 0xc9, 0xaf, 0xef, 0xc0, 0x24, 0xd6, 0x45, 0x0d,
  0xd0, 0xd8, 0x39, 0xf9, 0xe5, 0xd2, 0xbf, 0x20, 0xf9, 0x3d, 0x25, 0xd8,
  0x78, 0xc6, 0x63, 0x2a, 0xe2, 0xef, 0x5e, 0x83, 0xe0, 0x14, 0x1e, 0x65,
  0x7c, 0x6d, 0x71, 0xd1, 0x4d, 0xa3, 0xe8, 0x1c, 0x4a, 0x82, 0x25, 0x40,
  0x62, 0x82, 0xd5, 0x9a, 0x0c, 0x04, 0x91, 0x9c, 0x0d, 0xd6, 0xb0, 0xb2,
  0x57, 0x05, 0x57, 0xf4, 0xd7, 0xa6, 0x7f, 0x88, 0x47, 0x36, 0x07, 0x5a,
  0xf8, 0xc6, 0x85, 0xd6, 0xfa, 0xb5, 0xcc, 0xca, 0x19, 0x48, 0x61, 0x70,
  0x32, 0xaa, 0xaf, 0x20, 0xef, 0xc7, 0xb0, 0x6f, 0x99, 0xac, 0x8d, 0x9b,
  0x11, 0x32, 0xa0, 0xc5, 0xef, 0xb0, 0xb2, 0x8b, 0xd6, 0xa1, 0x53, 0x40,
  0x74, 0x8c, 0xea, 0xf8, 0x0d, 0x7f, 0x08, 0x75, 0x8f, 0xff, 0xc2, 0x82,
  0xfe, 0xf7, 0xa1, 0x79, 0x38, 0x80, 0x1d, 0x3e, 0xfd, 0x52, 0xd0, 0xdb,
  0x16, 0xb6, 0xcf, 0xfb, 0xfe, 0xa3, 0xba, 0xb4, 0x46, 0x09, 0x7b, 0xc0,
  0x9b, 0xad, 0x9a, 0x45, 0x3e, 0xcd, 0x58, 0xa8, 0x75, 0x1c, 0xc1, 0x0d,
  0x90, 0x3d, 0xb2, 0xe1, 0xe7, 0x9c, 0x3e, 0xed, 0xb0, 0x6a, 0xb2, 0x4b,
  0x2b, 0xb3, 0x92, 0xa5, 0xf2, 0x64, 0xe4, 0x7b, 0xd5, 0xda, 0x88, 0xfe,
  0x02, 0xbe, 0xf7, 0xef, 0xd3, 0x41, 0xb3, 0xb6, 0x1b, 0xf2, 0x00, 0x70,
  0x39, 0xfe, 0xe8, 0xb1, 0x6b, 0x09, 0x4d, 0x82, 0xa7, 0xbc, 0x7b, 0x56,
  0x37, 0x9a, 0x98, 0x8c, 0xc3, 0x47, 0x83, 0x0e, 0xd3, 0x41, 0x15, 0xe9,
  0xa4, 0xe5, 0x83, 0x59, 0x16, 0x66, 0xca, 0xe1, 0x9a, 0x28, 0x3b, 0x74,
  0x5a, 0xd4, 0x89, 0xed, 0xda, 0xce, 0x46, 0x1f, 0x9b, 0x45, 0xaa, 0x6f,
  0x93, 0x12, 0x65, 0x2d, 0x20, 0xce, 0x0c, 0xe3, 0x84, 0x71, 0xb9, 0x27,
  0x88, 0x8e, 0x75, 0x0f, 0x78, 0xd9, 0xa9, 0xba, 0xbd, 0xb9, 0xd3, 0xbe,
  0x83, 0x2c, 0xb8, 0x12, 0x26, 0x4e, 0x9d, 0xa4, 0xd3, 0x79, 0x22, 0x9b,
  0x6d, 0x37, 0xea, 0xb4, 0xb1, 0x3a, 0x45, 0x27, 0x7b, 0x87, 0x13, 0x77,
  0xc3, 0x71, 0xdf, 0x9c, 0x6a, 0x1d, 0xb2, 0xae, 0xf0, 0xa3, 0x14, 0x32,
  0x0e, 0x63, 0xdd, 0xa6, 0xd3, 0xc9, 0xd7, 0x3a, 0x46, 0x18, 0xa3, 0x64,
  0x9c, 0x0d, 0x8c, 0x46, 0x6b, 0x82, 0xcd, 0x0c, 0xf6, 0x07, 0x8f, 0x93,
  0xd0, 0x64, 0xaa, 0x6b, 0xeb, 0x3d, 0x4a, 0xfd, 0xa3, 0xd0, 0x08, 0x2c,
  0x1d, 0x01, 0x4b, 0x71, 0x97, 0xad, 0x22, 0x99, 0x76, 0x86, 0x43, 0x18,
  0x18, 0x87, 0x0d, 0x91, 0x61, 0x03, 0xeb, 0x76, 0xd6, 0xde, 0x71, 0xbd,
  0x81, 0xca, 0x4f, 0x6d, 0x4c, 0xf0, 0x71, 0xef, 0x2f, 0xbb, 0xaf, 0xfa,
  0xb0, 0xae, 0xda, 0x99, 0x49, 0xfb, 0xc5, 0xc9, 0x1d, 0x63, 0x17, 0x4f,
  0xe1, 0x05, 0x80, 0xa3, 0x14, 0x92, 0x28, 0x82, 0x3a, 0x3c, 0x11, 0x54,
  0x2f, 0x55, 0xbe, 0x64, 0x98, 0xf9, 0x10, 0x2e, 0xf6, 0x6f, 0x78, 0x73,
  0xf5, 0x58, 0x22, 0x10, 0xc7, 0x1e, 0x0d, 0x8e, 0x0a, 0x89, 0xbe, 0x06,
  0xcf, 0x7c, 0x0b, 0xba, 0x58, 0xed, 0x24, 0x79, 0x01, 0xd9, 0xb9, 0xda,
  0x68, 0x81, 0x7b, 0x54, 0x9a, 0xf6, 0xe4, 0x04, 0x49, 0x13, 0xd1, 0x8c,
  0x1b, 0x72, 0xbf, 0xf0, 0x39, 0x54, 0xc0, 0x57, 0xe7, 0xd1, 0x4f, 0xd2,
  0x5b, 0x52, 0x04, 0x4a, 0xfb, 0x1d, 0xd8, 0x84, 0x0e, 0xe7, 0x54, 0xea,
  0x27, 0xb4, 0x4d, 0xf1, 0xfa, 0xbd, 0x32, 0x02, 0xc9, 0x36, 0x02, 0x97,
  0xa3, 0xfd, 0xfc, 0xde, 0x2a, 0xe8, 0x4e, 0x09, 0xfa, 0x00, 0xcb, 0x78,
  0xd3, 0xac, 0xe4, 0x52, 0x1e, 0x4e, 0xe8, 0xd4, 0xd7, 0xd1, 0xdc, 0xf8,
  0x3e, 0x2c, 0x8b, 0xd9, 0x4e, 0xb1, 0x7e, 0x55, 0x02, 0xf0, 0x8b, 0xdc,
  0xb0, 0xb0, 0xf8, 0x28, 0xf1, 0x9f, 0x79, 0xb9, 0xeb, 0x41, 0x70, 0x5a,
  0x2d, 0xcd, 0xe5, 0x9f, 0xec, 0xad, 0xde, 0xf0, 0xff, 0xdd, 0x05, 0xa8,
  0xfa, 0xf5, 0xaa, 0xd9, 0x10, 0xbc, 0x96, 0x57, 0x8d, 0xb1, 0x58, 0x15,
  0xa6, 0x02, 0xfb, 0x50, 0xc8, 0xcf, 0x8b, 0x2e, 0x1d, 0x15, 0x9d, 0xdd,
  0x66, 0x71, 0x40, 0xd6, 0x5b, 0x15, 0xc4, 0x5f, 0x5b, 0x59, 0x6f, 0x99,
  0xda, 0xfc, 0xfc, 0x93, 0x30, 0x03, 0x66, 0xd5, 0x7e, 0x00, 0xc9, 0x77,
  0x5b, 0xf2, 0x24, 0x00, 0x0c, 0xce, 0xa6, 0xa6, 0x10, 0x78, 0xbc, 0x56,
  0x66, 0x51, 0x6c, 0xd8, 0xd3, 0x2e, 0x7f, 0xb4, 0xce, 0xbe, 0xe7, 0xc8,
  0xec, 0x58, 0x10, 0xc3, 0xd0, 0x12, 0x5c, 0x52, 0xa0, 0xeb, 0x0e, 0x60,
  0x22, 0x3e, 0xbe, 0xee, 0x6d, 0x6b, 0x8a, 0x0d, 0x13, 0xde, 0xa2, 0xd2,
  0x59, 0x7e, 0x68, 0x96, 0x19, 0xc4, 0x68, 0x3c, 0xe2, 0x6f, 0xd7, 0xb1,
  0x92, 0xa5, 0x31, 0x9f, 0xf3, 0x5f, 0x1c, 0xbd, 0x56, 0x9f, 0xe6, 0x78,
  0x65, 0xbc, 0xb9, 0xc5, 0x1c, 0x8a, 0x77, 0xda, 0xcb, 0xa3, 0xb8, 0x34,
  0xe5, 0xc1, 0x58, 0x8a, 0xd1, 0x48, 0x37, 0xa0, 0x15, 0x63, 0x5d, 0x27,
  0xd8, 0x02, 0x22, 0xed, 0x5a, 0x4f, 0x57, 0x06, 0x3a, 0x11, 0x48, 0xde,
  0x84, 0x75, 0xcc, 0x2a, 0xac, 0xc2, 0xb7, 0xcc, 0xad, 0x9c, 0x23, 0xf2,
  0x92, 0xab, 0xa9, 0x81, 0x36, 0x5c, 0x44, 0xd8, 0x56, 0x28, 0x87, 0x27,
  0x1c, 0x4a, 0x1d, 0xe3, 0xaf, 0x0f, 0x71, 0x6e, 0x14, 0x39, 0x42, 0xf2,
  0x56, 0xe5, 0x3d, 0xe2, 0xec, 0x65, 0x54, 0xa9, 0xad, 0x6e, 0x88, 0x63,
  0xef, 0x74, 0xcf, 0x36, 0xab, 0xe8, 0xe8, 0x35, 0x7f, 0xa8, 0x24, 0x1c,
  0x8f, 0xd1, 0x3f, 0xb7, 0xb1, 0x78, 0x43, 0xe6, 0xf6, 0xab, 0xb3, 0xf7,
  0x6d, 0x09, 0xe0, 0x2f, 0x31, 0x66, 0x2e, 0xd3, 0x9f, 0x2d, 0x52, 0xde,
  0xa0, 0x99, 0x20, 0xdb, 0x77, 0x6f, 0x98, 0x4d, 0xee, 0xa6, 0x97, 0x2f,
  0x21, 0x6e, 0xe5, 0x52, 0x8b, 0x51, 0xb7, 0xdb, 0x4c, 0xa7, 0x3a, 0x16,
  0x9a, 0xaf, 0x3a, 0x2b, 0xb2, 0x10, 0x76, 0x17, 0x9f, 0x4e, 0x49, 0x3e,
  0xdd, 0x3d, 0xdc, 0x00, 0x62, 0x94, 0x20, 0xe8, 0xb1, 0x5e, 0x7a, 0x04,
  0xee, 0xc0, 0xbf, 0xbc, 0x9e, 0xdd, 0x53, 0x2c, 0x87, 0xc1, 0x31, 0x94,
  0xbc, 0xea, 0x09, 0x54, 0x2b, 0xff, 0xf1, 0x9e, 0x8c, 0xa0, 0xd1, 0x50,
  0x07, 0xa4, 0x16, 0xf9, 0xc2, 0xe3, 0x7b, 0x8a, 0x1e, 0x4b, 0x18, 0xbe,
  0x83, 0x49, 0xa5, 0x11, 0x51
};
unsigned int __1025_bin_len = 1025;
unsigned char __1025_cbc[] = {
  0x66, 0x60, 0x54, 0xf2, 0x9e, 0xf8, 0x06, 0xff, 0x6c, 0x91, 0x0c, 0x14,
  0x4d, 0xc3, 0x45, 0x09, 0xca, 0xa4, 0x7f, 0x54, 0x58, 0x46, 0xbb, 0x6f,
  0x15, 0x05, 0x68, 0x2e, 0x90, 0xae, 0xed, 0xbc, 0x43, 0x63, 0x67, 0x40,
  0x77, 0x83, 0xed, 0x25, 0xf6, 0x2e, 0xae, 0x70, 0x31, 0x64, 0x09, 0xfc,
  0x7f, 0x3b, 0x8d, 0x44, 0x67, 0xde, 0x61, 0xea, 0x43, 0x18, 0xcf, 0x80,
  0xc9, 0x2c, 0x96, 0x3f, 0xea, 0x1e, 0x48, 0x5e, 0x4b, 0xaa, 0x14, 0xa3,
  0x6c, 0xa8, 0xe4, 0xc4, 0x6f, 0x92, 0xbc, 0xb8, 0x03, 0x07, 0x3e, 0xfb,
  0x03, 0xe3, 0x89, 0x58, 0x94, 0x75, 0x0a, 0x5b, 0xf0, 0xa0, 0xd2, 0x92,
  0xe4, 0x8f, 0x2d, 0xba, 0x93, 0xec, 0xce, 0x05, 0x2e, 0xcc, 0x7a, 0x79,
  0xed, 0x22, 0xb0, 0x7d, 0x75, 0x27, 0xdb, 0x40, 0x4d, 0x76, 0xb9, 0x6b,
  0x6a, 0x70, 0xa5, 0x86, 0x3f, 0xd5, 0xaa, 0x4a, 0x88, 0x84, 0x86, 0x5f,
  0x6b, 0x1f, 0xc6, 0xcc, 0xd7, 0x4e, 0x80, 0xd1, 0x41, 0xcd, 0x20, 0x73,
  0x68, 0x75, 0xed, 0xc6, 0x39, 0x23, 0xba, 0x5f, 0x84, 0xa5, 0xe8, 0x68,
  0xe6, 0x9b, 0xdf, 0xec, 0xb2, 0xe2, 0x4b, 0x62, 0x88, 0xc3, 0x37, 0x7f,
  0xfd, 0x65, 0xd1, 0x39, 0xbf, 0x1c, 0x43, 0xc8, 0x3c, 0x1c, 0x46, 0xd9,
  0x94, 0x82, 0x47, 0x50, 0xf7, 0x56, 0xd1, 0xf0, 0xec, 0x4f, 0xdf, 0x65,
  0x7e, 0x37, 0x16, 0x98, 0xc1, 0xe8, 0x47, 0x1e, 0x84, 0xcb, 0xfb, 0x8a,
  0xc1, 0x8b, 0x6b, 0x66, 0x4b, 0xe4, 0x45, 0x9a, 0xd6, 0x91, 0x78, 0x9c,
  0x39, 0x69, 0x45, 0x39, 0xec, 0x09, 0x64, 0x09, 0xe0, 0x11, 0xec, 0x47,
  0xea, 0xf2, 0x69, 0x80, 0x60, 0xd0, 0xa0, 0x83, 0x7e, 0x69, 0x08, 0xad,
  0x82, 0x51, 0xec, 0x69, 0x54, 0xcf, 0xca, 0xd6, 0x33, 0x69, 0x99, 0x04,
  0x5e, 0x11, 0x96, 0x05, 0xea, 0xa3, 0xf0, 0x27, 0x90, 0x77, 0x9e, 0xba,
  0x13, 0xf1, 0xe1, 0x78, 0xfa, 0xe5, 0x25, 0x3d, 0x44, 0x36, 0x5c, 0x81,
  0x4d, 0x87, 0x08, 0xb7, 0x02, 0x6a, 0x64, 0x99, 0x89, 0xc9, 0xcf, 0x32,
  0x81, 0x71, 0x16, 0xbf, 0x3c, 0x6b, 0x18, 0xa0, 0xca, 0xb3, 0xc5, 0xc8,
  0x59, 0xba, 0x32, 0xf6, 0xda, 0xd3, 0x98, 0xeb, 0x73, 0x5b, 0xf3, 0x66,
  0x7e, 0xa1, 0x1d, 0x3d, 0xf7, 0x30, 0xd2, 0xbc, 0xda, 0xe6, 0x7f, 0x5f,
  0x9f, 0x2e, 0x74, 0x95, 0x45, 0xcb, 0xc3, 0x5b, 0x7f, 0xfd, 0x2b, 0x78,
  0x33, 0x04, 0x09, 0x75, 0xde, 0x3b, 0x8e, 0x2e, 0x7d, 0x8c, 0x59, 0xfe,
  0x58, 0x52, 0xd3, 0x27, 0xad, 0x27, 0x75, 0x5a, 0xad, 0xf5, 0x37, 0x7c,
  0x07, 0x99, 0xaf, 0xfc, 0x61, 0xf3, 0xe8, 0x19, 0x2d, 0xdf, 0xad, 0x21,
  0x7d, 0x83, 0x04, 0xa7, 0x27, 0x2c, 0xe3, 0x2b, 0x6e, 0x83, 0x71, 0xcf,
  0x9a, 0xdd, 0xb0, 0x6a, 0xbc, 0xe9, 0xff, 0xbc, 0x53, 0x93, 0x03, 0xe4,
  0xdb, 0xc3, 0x7b, 0xd0, 0x08, 0x35, 0x9c, 0x3c, 0xdd, 0x07, 0x2c, 0x4a,
  0x5e, 0x86, 0x47, 0x4a, 0x77, 0x51, 0x18, 0x3b, 0x8b, 0x47, 0x01, 0xdf,
  0x31, 0x00, 0x1b, 0x0f, 0x73, 0x6c, 0x35, 0xe6, 0x1b, 0x24, 0x97, 0x62,
  0xe5, 0x7c, 0xa4, 0x68, 0x21, 0xe8, 0xca, 0x35, 0x1d, 0xa8, 0xe5, 0xb4,
  0x49, 0x7a, 0xe2, 0x73, 0xe2, 0x91, 0xfb, 0xbb, 0xd8, 0x5d, 0x01, 0x1d,
  0xe1, 0x2c, 0x59, 0x55, 0x2a, 0x48, 0x36, 0xa4, 0x39, 0x49, 0xb6, 0x28,
  0xd4, 0x16, 0xe0, 0xf7, 0x66, 0x42, 0x5a, 0x28, 0xc0, 0x56, 0xcb, 0x4b,
  0x79, 0xf4, 0x02, 0x42, 0x99, 0xbb, 0xc9, 0x9f, 0xc1, 0x88, 0x41, 0x7e,
  0xad, 0x2c, 0x91, 0x2f, 0xc4, 0xbe, 0x48, 0x8e, 0x3b, 0x48, 0x11, 0x0b,
  0xc1, 0x93, 0x98, 0x1f, 0xb3, 0x0a, 0xf5, 0xff, 0xc0, 0xe9, 0x5b, 0xbb,
  0xb4, 0x13, 0x34, 0x69, 0x15, 0x31, 0x39, 0xde, 0x00, 0x0a, 0x28, 0xc1,
  0xfc, 0x2a, 0xbe, 0xa1, 0x44, 0x17, 0x4b, 0x75, 0xcb, 0x94, 0x2a, 0x14,
  0xb3, 0x66, 0x3d, 0xfe, 0x19, 0xb3, 0xb7, 0x92, 0x2a, 0x1f, 0x13, 0x1b,
  0x7a, 0xc1, 0x46, 0x9c, 0x3d, 0xb2, 0xc4, 0xb4, 0x7d, 0x12, 0x15, 0xf1,
  0xa9, 0x7b, 0xb8, 0x81, 0x2e, 0x39, 0xe8, 0x9e, 0x18, 0xc7, 0xec, 0x9e,
  0xb3, 0x00, 0x52, 0xad, 0xcf, 0xba, 0xc6, 0x73, 0x06, 0x35, 0x8f, 0x77,
  0x70, 0x9d, 0xb9, 0xf6, 0xb9, 0x9b, 0x61, 0xb5, 0xf2, 0x7c, 0xf0, 0xf3,
  0x8d, 0xbd, 0xc3, 0xd4, 0x36, 0x7e, 0xd1, 0xb5, 0xc2, 0x55, 0xff, 0x8e,
  0xdb, 0x89, 0x46, 0x36, 0xf4, 0x04, 0x4a, 0x11, 0xb0, 0xa4, 0x96, 0x0b,
  0x3a, 0x7f, 0x4b, 0x82, 0x73, 0xd4, 0x5a, 0x70, 0x4c, 0x75, 0x61, 0x82,
  0xc0, 0x9d, 0x53, 0x62, 0xad, 0x2e, 0xd5, 0x70, 0xb3, 0x9d, 0xf3, 0x15,
  0x66, 0xa9, 0x46, 0x0b, 0xc5, 0x9f, 0xc6, 0x80, 0xbe, 0x0a, 0x7a, 0x28,
  0x35, 0x2f, 0x59, 0x53, 0x7d, 0xc0, 0xe1, 0x01, 0x56, 0xe9, 0x66, 0x62,
  0x21, 0xc5, 0x0d, 0x00, 0xa3, 0x07, 0x76, 0x97, 0x32, 0x6b, 0xaf, 0x80,
  0x40, 0xbc, 0xdc, 0xe0, 0x88, 0x6b, 0xe8, 0x5a, 0x3c, 0x19, 0xe5, 0x04,
  0x20, 0x41, 0x17, 0x8b, 0x50, 0xdd, 0x5a, 0x3c, 0xf4, 0x11, 0xf7, 0x95,
  0x1a, 0x4b, 0x79, 0x7c, 0x93, 0x5a, 0xa5, 0xde, 0x69, 0xa8, 0x5c, 0x70,
  0x9d, 0xf1, 0x57, 0xa2, 0xe7, 0xa9, 0x54, 0x77, 0xd0, 0x11, 0x2f, 0xf4,
  0x9e, 0xef, 0xc1, 0xc3, 0x03, 0x95, 0xda, 0x59, 0x2a, 0x1c, 0x6b, 0x97,
  0xde, 0xa9, 0xc9, 0x04, 0xbf, 0x2b, 0x20, 0x75, 0x9e, 0x8b, 0xc3, 0xa9,
  0xc1, 0x87, 0x89, 0x63, 0x89, 0x99, 0xc2, 0x90, 0xe6, 0xa6, 0xf5, 0x04,
  0xd3, 0x54, 0x5c, 0x79, 0xcf, 0xef, 0x7d, 0x44, 0xa2, 0x9f, 0x05, 0x8a,
  0xf1, 0x21, 0x86, 0x1c, 0xac, 0x23, 0x29, 0xfa, 0xc5, 0x8f, 0xe8, 0xcc,
  0xcc, 0xa4, 0x89, 0x66, 0xfa, 0x28, 0x5c, 0xd2, 0xc4, 0x97, 0x2a, 0x61,
  0x83, 0x84, 0xf0, 0x15, 0x87, 0x9f, 0x2c, 0x6c, 0xdb, 0x1e, 0x24, 0xc3,
  0x1c, 0xa8, 0xae, 0x8b, 0xfc, 0x1d, 0x10, 0x85, 0x77, 0xc1, 0xbe, 0xa6,
  0xc7, 0xd0, 0xf1, 0x7b, 0xff, 0x1b, 0x2d, 0x89, 0x4b, 0x38, 0xb9, 0x39,
  0x8e, 0xf1, 0x50, 0x7a, 0xd0, 0x8f, 0xb4, 0x94, 0x43, 0xb2, 0xba, 0xf7,
  0x7a, 0x13, 0x71, 0x85, 0x5c, 0xc1, 0xec, 0x2d, 0xb7, 0xfe, 0x7d, 0x83,
  0x55, 0xe0, 0x60, 0x48, 0x43, 0xb1, 0x36, 0x96, 0x5a, 0x77, 0xe8, 0x0e,
  0xfd, 0x9e, 0xc6, 0x76, 0xb7, 0xa2, 0x01, 0x90, 0x37, 0x0d, 0x86, 0x89,
  0x1f, 0x47, 0x51, 0xb5, 0xb4, 0x4e, 0xa6, 0x7e, 0x5d, 0xaa, 0x59, 0x6e,
  0x07, 0xa8, 0x3c, 0x48, 0x28, 0x26, 0x68, 0x83, 0xaf, 0x7e, 0x2a, 0xcb,
  0xf9, 0x20, 0xe6, 0x1e, 0xa3, 0xce, 0x5b, 0x22, 0x5b, 0x68, 0x45, 0xd9,
  0x67, 0x79, 0xb2, 0x39, 0x3b, 0xa8, 0x7a, 0xca, 0x7f, 0x27, 0x05, 0xc3,
  0x32, 0xb8, 0x56, 0x98, 0x92, 0xb2, 0xe6, 0x62, 0x8e, 0xc4, 0xeb, 0x54,
  0x41, 0x03, 0xc7, 0xd1, 0x6d, 0x81, 0x50, 0x97, 0x9f, 0x97, 0x9f, 0xd9,
  0xb4, 0x41, 0x31, 0xaf, 0xd2, 0x39, 0x33, 0x00, 0xd1, 0xf5, 0xb4, 0x21,
  0x54, 0xce, 0x3b, 0x98, 0x44, 0x1c, 0x31, 0xc4, 0x14, 0xfa, 0x76, 0x17,
  0x8c, 0x01, 0xb4, 0x80, 0x22, 0x93, 0x6e, 0x0b, 0x70, 0xdc, 0x2b, 0x5f,
  0x44, 0xf8, 0x50, 0x22, 0x2b, 0xda, 0x5b, 0xe9, 0x90, 0x9d, 0x66, 0x3a,
  0xd1, 0x12, 0xe7, 0x0a, 0x14, 0xaa, 0x5e, 0x6d, 0x8a, 0xb1, 0x44, 0x37,
  0x29, 0x27, 0xef, 0xce, 0x0d, 0x05, 0x2e, 0x40, 0x23, 0x20, 0x08, 0x7d,
  0x32, 0x7f, 0x07, 0x40, 0x96, 0x4f, 0x6b, 0xda
};
unsigned int __1025_cbc_len = 1040;

unsigned char __1023_oma_bin[] = {
  0x76, 0x03, 0x0b, 0x76, 0x94, 0x7a, 0x51, 0x79, 0xa8, 0x81, 0x73, 0x14,
  0xbf, 0x66, 0xdb, 0x34, 0xe0, 0xb1, 0x96, 0x44, 0xee, 0xec, 0xb2, 0x32,
  0x62, 0x15, 0x23, 0x70, 0xd1, 0xa9, 0x0f, 0x5d, 0xb7, 0x9e, 0x5e, 0xe3,
  0x57, 0x69, 0xe5, 0x86, 0x2f, 0x82, 0x2d, 0x86, 0xc6, 0xe8, 0x75, 0xad,
  0x47, 0xdd, 0xd5, 0x3d, 0x04, 0x29, 0x66, 0x3c, 0x1d, 0x44, 0xbe, 0xcf,
  0x11, 0x0d, 0x27, 0xd1, 0x0f, 0xd9, 0x01, 0x23, 0xbf, 0xc9, 0xf4, 0x77,
  0x80, 0x42, 0x9f, 0xb0, 0xc2, 0xe1, 0x6c, 0xbc, 0xf8, 0xaa, 0xba, 0xe6,
  0xa5, 0xcf, 0xe4, 0x94, 0x6f, 0x0e, 0x21, 0xe3, 0x8d, 0xee, 0x21, 0x1f,
  0x44, 0xa3, 0x22, 0x8d, 0x68, 0xd6, 0xb6, 0xb4, 0xb8, 0xd3, 0xe6, 0x2d,
  0xb8, 0xa9, 0xee, 0xf9, 0x06, 0x47, 0xec, 0x9a, 0xde, 0x92, 0xff, 0x4b,
  0x8e, 0x32, 0x67, 0xce, 0x60, 0x3e, 0xdb, 0xb9, 0xba, 0xfb, 0xec, 0x62,
  0xb3, 0xa6, 0xad, 0xf5, 0x0a, 0xd7, 0xb9, 0x18, 0x4b, 0x6e, 0x15, 0xa9,
  0x80, 0x95, 0xfa, 0x80, 0x9f, 0x81, 0x41, 0x19, 0x7b, 0x3c, 0xf2, 0x83,
  0x0b, 0x9b, 0xb5, 0xae, 0x48, 0x27, 0xb1, 0x0f, 0x1a, 0x34, 0x0d, 0x47,
  0xd1, 0x58, 0x1d, 0x0b, 0x53, 0x8c, 0xc8, 0xa0, 0x52, 0x9f, 0xee, 0xcf,
  0x9b, 0xc5, 0xf1, 0x07, 0x38, 0xed, 0x25, 0xeb, 0x0a, 0xbe, 0x32, 0xb4,
  0xb1, 0x63, 0x5b, 0x7b, 0xb8, 0xa2, 0x46, 0xd3, 0xe6, 0xfa, 0xf6, 0xe8,
  0xe6, 0xa3, 0x32, 0x26, 0xa2, 0xcc, 0x85, 0x81, 0x67, 0x2a, 0xf2, 0xac,
  0x10, 0x98, 0x2d, 0x88, 0xe0, 0x50, 0x5c, 0x77, 0xc0, 0x92, 0xbd, 0x2a,
  0xc7, 0xbe, 0x94, 0x2a, 0x4b, 0xcd, 0x18, 0xc4, 0xd1, 0xeb, 0xb1, 0x07,
  0x27, 0xc3, 0x2d, 0xb6, 0xbb, 0xdd, 0x80, 0x7e, 0x1e, 0xc2, 0x27, 0x0e,
  0x92, 0x89, 0x5e, 0x27, 0x6b, 0x37, 0xef, 0xd5, 0x43, 0x35, 0x28, 0x40,
  0xd4, 0xba, 0x73, 0x53, 0x8d, 0x3b, 0x98, 0xce, 0xfa, 0x3f, 0x63, 0x19,
  0xe5, 0x67, 0x49, 0x44, 0x1c, 0x7a, 0xa2, 0xda, 0x1e, 0xc4, 0xd3, 0x78,
  0x85, 0xb5, 0x80, 0xe2, 0x47, 0x16, 0xfc, 0xb4, 0xef, 0x40, 0x55, 0x44,
  0xfa, 0x30, 0x58, 0x57, 0x6c, 0x5e, 0x52, 0xc5, 0x3f, 0x07, 0x2e, 0xa7,
  0xa8, 0x99, 0x73, 0xde, 0x92, 0x63, 0x2e, 0x05, 0x40, 0xff, 0x1c, 0x10,
  0xaf, 0x65, 0x24, 0x99, 0x01, 0x32, 0xc5, 0x84, 0x3f, 0x7c, 0x52, 0x6c,
  0x9e, 0xd6, 0x9f, 0xfa, 0x94, 0x8c, 0x13, 0x08, 0xf1, 0x28, 0xde, 0x8e,
  0xba, 0xa1, 0x8d, 0xbe, 0x9f, 0x9c, 0xb9, 0x4a, 0xd5, 0x64, 0xad, 0xe6,
  0x73, 0xc5, 0xf4, 0x83, 0xe2, 0xa4, 0xd5, 0x4d, 0x2e, 0x89, 0xba, 0xa8,
  0xe4, 0xe7, 0x1c, 0xa1, 0x6c, 0x07, 0x87, 0x87, 0x74, 0x9c, 0x21, 0xcf,
  0x27, 0x7b, 0x84, 0xca, 0xc2, 0x8b, 0x58, 0x63, 0x59, 0x41, 0x80, 0xef,
  0x47, 0x5e, 0x31, 0x22, 0x7f, 0x18, 0x6f, 0x4d, 0x4a, 0xf8, 0xe7, 0x8a,
  0x8a, 0xd1, 0x1d, 0x72, 0x2f, 0x73, 0xc4, 0x4d, 0x30, 0xdc, 0x7c, 0xfb,
  0xc6, 0x92, 0x49, 0x62, 0x7c, 0x31, 0x7d, 0xd8, 0xee, 0x56, 0xe0, 0x4f,
  0x39, 0x0f, 0xf1, 0x75, 0x91, 0xcc, 0x78, 0xb3, 0x44, 0xec, 0xd7, 0xa6,
  0x7d, 0x4b, 0x39, 0x52, 0xec, 0x13, 0xaf, 0x82, 0xd4, 0xde, 0x43, 0xba,
  0x08, 0xeb, 0x68, 0x93, 0x44, 0x4c, 0xe8, 0x5b, 0x97, 0xcf, 0xd9, 0x2a,
  0x9e, 0xc8, 0xb5, 0x80, 0x32, 0x58, 0xf1, 0x5e, 0x49, 0x14, 0x18, 0x3d,
  0xd5, 0x58, 0x70, 0xfa, 0x53, 0x8f, 0x1a, 0xac, 0xe1, 0x07, 0x5f, 0x49,
  0x09, 0x99, 0xe9, 0xce, 0x18, 0xd9, 0x2e, 0xb5, 0x6d, 0xec, 0x16, 0x86,
  0xc2, 0x64, 0x6d, 0x13, 0x8f, 0x61, 0xc6, 0xf7, 0x5e, 0xeb, 0xdb, 0x7e,
  0xf9, 0x59, 0xdf, 0xae, 0x61, 0x3a, 0x01, 0xfe, 0x35, 0x93, 0xe2, 0xcb,
  0x40, 0x47, 0xd1, 0xae, 0x98, 0xab, 0x5b, 0x1e, 0x85, 0xda, 0xce, 0x94,
  0xc9, 0x8b, 0x2e, 0xc2, 0x1e, 0x6a, 0x2d, 0x22, 0x45, 0x9b, 0x22, 0xd9,
  0xc3, 0x4c, 0x55, 0xec, 0xd0, 0xd7, 0x07, 0x31, 0x68, 0x29, 0xbe, 0x79,
  0x50, 0xdd, 0xa8, 0x90, 0x29, 0x37, 0x7b, 0x81, 0xd5, 0xe4, 0x40, 0x61,
  0xac, 0xe2, 0xd9, 0xb2, 0xaf, 0x72, 0x3e, 0x4f, 0x87, 0x95, 0x92, 0xdf,
  0xda, 0x2c, 0x65, 0x63, 0x00, 0x01, 0xff, 0xf4, 0x3f, 0x8c, 0xc9, 0xde,
  0x5d, 0xcc, 0x20, 0x4c, 0xe3, 0x5d, 0x46, 0xe3, 0x7f, 0xc6, 0xd2, 0x7c,
  0xec, 0x59, 0x4b, 0x71, 0x8a, 0xa3, 0xa4, 0xf8, 0x93, 0x3d, 0x21, 0x22,
  0xa3, 0x8e, 0xe9, 0xb2, 0x37, 0xc6, 0x8a, 0x0c, 0x92, 0x3d, 0x03, 0x29,
  0xeb, 0xaf, 0xc2, 0x50, 0x40, 0x07, 0xd7, 0xc6, 0x9e, 0x7f, 0x04, 0xf1,
  0x4b, 0xe2, 0x24, 0x8f, 0xd0, 0xe3, 0xa3, 0x03, 0xa1, 0x09, 0xbd, 0x5d,
  0xbc, 0x58, 0xf4, 0xdd, 0x56, 0xe7, 0xdd, 0x99, 0xd3, 0x04, 0xcf, 0xb4,
  0xdb, 0xf7, 0x1e, 0x7c, 0x22, 0xf3, 0x50, 0x05, 0x04, 0x09, 0xb1, 0xc1,
  0xa2, 0x66, 0x82, 0x9e, 0x22, 0xcf, 0xcd, 0x55, 0x40, 0xc0, 0x9f, 0x20,
  0x1d, 0x05, 0xef, 0xd2, 0xaf, 0x94, 0xff, 0xda, 0x3d, 0xaf, 0xa9, 0xc8,
  0x9c, 0xa9, 0x63, 0xde, 0x45, 0x52, 0x6f, 0x64, 0xb4, 0xe7, 0xee, 0x79,
  0x71, 0xf4, 0x69, 0xd3, 0x4c, 0xee, 0x91, 0x59, 0xc2, 0xdc, 0x3b, 0x22,
  0xd7, 0xc8, 0xc9, 0xd2, 0x20, 0x5d, 0x3e, 0x44, 0xb2, 0xcf, 0x8d, 0x16,
  0x88, 0xce, 0x4d, 0x98, 0xdb, 0xb7, 0xef, 0x1c, 0x0e, 0x14, 0xa2, 0x87,
  0xa3, 0x71, 0xde, 0x6c, 0xac, 0x7a, 0xb6, 0x50, 0xb8, 0xd1, 0xf0, 0x19,
  0x71, 0x70, 0x88, 0xee, 0x55, 0x89, 0x43, 0xc9, 0x07, 0xbc, 0xb0, 0x5e,
  0xac, 0xd2, 0x2f, 0x7a, 0xde, 0x0a, 0x17, 0xf4, 0x71, 0x21, 0x66, 0x98,
  0x7b, 0xcf, 0xd8, 0x1f, 0x85, 0x16, 0x6f, 0x77, 0xf9, 0x9a, 0x58, 0xd8,
  0xba, 0x14, 0x85, 0xe5, 0x19, 0x56, 0x63, 0xf1, 0xf0, 0x53, 0x41, 0xe3,
  0xb9, 0x4e, 0x64, 0x27, 0x8c, 0xcf, 0xed, 0x01, 0xdd, 0x82, 0xcf, 0xba,
  0x29, 0x0b, 0x44, 0xf5, 0x20, 0x2d, 0xe3, 0x35, 0x66, 0x8d, 0x98, 0x5d,
  0xe8, 0xc0, 0xb5, 0x7f, 0xe7, 0xb3, 0xae, 0xbb, 0x02, 0x1b, 0xf8, 0xd8,
  0xad, 0xb0, 0x24, 0xcb, 0xc0, 0x70, 0x4e, 0xe5, 0x85, 0x61, 0x1f, 0xd3,
  0x19, 0x28, 0x7f, 0x4f, 0xf1, 0x55, 0xaa, 0xc3, 0xf7, 0x34, 0x74, 0x94,
  0x66, 0x1b, 0x0d, 0x80, 0x0c, 0x21, 0xe2, 0x89, 0x33, 0x54, 0xfe, 0x9b,
  0x33, 0x1c, 0x48, 0xa1, 0x33, 0x82, 0x74, 0x58, 0x9b, 0xf4, 0x07, 0xda,
  0xa3, 0xd6, 0xda, 0x7d, 0xd0, 0x66, 0xdc, 0x1d, 0x25, 0xfe, 0xf9, 0x06,
  0xde, 0x36, 0xc1, 0xa6, 0x79, 0x59, 0x70, 0xab, 0xbd, 0x8d, 0xf5, 0x88,
  0xbb, 0x41, 0xf3, 0x15, 0x95, 0xa6, 0xf0, 0x52, 0x5a, 0x3e, 0xc8, 0x92,
  0x50, 0x06, 0x09, 0x72, 0xc1, 0x4d, 0xcb, 0xad, 0x5b, 0x77, 0x28, 0x36,
  0x2f, 0xf0, 0xf4, 0x40, 0x10, 0x2c, 0x8e, 0x34, 0x61, 0x8f, 0xa3, 0x51,
  0x5a, 0x27, 0x27, 0xc4, 0x2f, 0xc6, 0x11, 0xad, 0xc1, 0x57, 0xd3, 0x25,
  0x8e, 0x16, 0x29, 0x6d, 0x92, 0x92, 0x14, 0x59, 0xfd, 0x17, 0xda, 0x10,
  0x1f, 0xdd, 0x49, 0x75, 0x03, 0x4f, 0x88, 0xd1, 0xb8, 0xed, 0x13, 0x5b,
  0xb7, 0x60, 0x10, 0x56, 0xe1, 0x61, 0xee, 0xa2, 0x08, 0x4e, 0xc0, 0x55,
  0x02, 0x7a, 0x07, 0x76, 0xd4, 0x61, 0x41, 0x5f, 0xdf, 0xf2, 0xbb, 0xd3,
  0x47, 0x51, 0x4b
};
unsigned int __1023_oma_bin_len = 1023+16;
unsigned char __1023_oma_cbc[] = {
  0x53, 0xd0, 0x5e, 0xc1, 0x38, 0xdc, 0xab, 0x60, 0xab, 0x0e, 0x19, 0x9f,
  0x79, 0x72, 0x50, 0xd1, 0xe9, 0xd1, 0x12, 0xf3, 0xbd, 0x64, 0xae, 0x5d,
  0xc1, 0xb7, 0x33, 0xc1, 0xc5, 0xd5, 0x39, 0x71, 0x75, 0x94, 0xb9, 0x4a,
  0x26, 0x4d, 0xef, 0xc5, 0x8e, 0xe8, 0x44, 0xa7, 0x53, 0xa3, 0x24, 0x4e,
  0x35, 0xff, 0x97, 0x1a, 0x5c, 0xe1, 0xbf, 0xe2, 0x94, 0x15, 0xfc, 0xb2,
  0x53, 0x6e, 0xe5, 0x15, 0x70, 0xf9, 0x7a, 0xe3, 0x96, 0x16, 0xfc, 0x20,
  0x64, 0x1e, 0xbd, 0x85, 0x4f, 0x6b, 0xa1, 0xdb, 0x51, 0xea, 0x51, 0x02,
  0x7c, 0xf1, 0xc5, 0x14, 0x87, 0x61, 0x93, 0x8b, 0xd6, 0x78, 0x21, 0x5d,
  0x86, 0xc9, 0x8d, 0xdf, 0x67, 0xf7, 0x9b, 0x5b, 0x61, 0x30, 0xd8, 0xcd,
  0x0a, 0xb5, 0x06, 0x84, 0x98, 0x04, 0xd8, 0x8f, 0x86, 0x5b, 0x52, 0xb8,
  0x9f, 0xee, 0x23, 0xb4, 0x3c, 0x9d, 0xe9, 0xab, 0x25, 0x98, 0x7c, 0x70,
  0xe3, 0x6b, 0x6d, 0xb3, 0x36, 0xf3, 0xd9, 0x94, 0x20, 0x7f, 0x62, 0x03,
  0x1e, 0x82, 0x49, 0x8d, 0x90, 0x39, 0x98, 0xd4, 0x32, 0xde, 0x49, 0x09,
  0xda, 0xb9, 0x60, 0xe6, 0x61, 0x00, 0xd4, 0x39, 0x17, 0x3f, 0x9e, 0xf8,
  0x47, 0xf5, 0xf3, 0x20, 0x41, 0x25, 0xab, 0x66, 0xfe, 0xf7, 0x07, 0xab,
  0x75, 0x0e, 0xc3, 0xd9, 0x48, 0x94, 0x80, 0xc3, 0x90, 0xbf, 0x0a, 0xd7,
  0xbf, 0xf6, 0xa1, 0x9c, 0x8b, 0xc7, 0x5d, 0xda, 0x25, 0x9b, 0x91, 0xdb,
  0x25, 0x86, 0x97, 0x07, 0x07, 0x00, 0xdb, 0x41, 0xe1, 0x1f, 0x64, 0x4b,
  0x06, 0x4f, 0xdf, 0x5f, 0xe6, 0xaa, 0x4d, 0x62, 0xc3, 0x03, 0x22, 0xe7,
  0x2a, 0xe1, 0x13, 0x6f, 0xfe, 0x2a, 0x97, 0x0e, 0xb5, 0xa1, 0x61, 0x97,
  0x28, 0x8d, 0xc0, 0x75, 0xf5, 0xb4, 0x34, 0xb5, 0x33, 0xac, 0x43, 0x60,
  0x95, 0x54, 0x94, 0x73, 0x19, 0xb0, 0x5a, 0x46, 0x0d, 0x7b, 0x32, 0x16,
  0x2f, 0x5a, 0x5d, 0x95, 0x9a, 0x2f, 0xa5, 0x2f, 0xe2, 0x98, 0x08, 0x64,
  0x32, 0x40, 0x28, 0xe8, 0x2d, 0xdc, 0xf9, 0x4c, 0x96, 0x25, 0x4b, 0x8d,
  0x17, 0xe5, 0x93, 0x90, 0xf2, 0x80, 0x85, 0x51, 0xc7, 0xd2, 0x8d, 0x6f,
  0xbc, 0x45, 0x77, 0x91, 0xa0, 0x82, 0xee, 0x7b, 0x88, 0xd1, 0x19, 0x25,
  0x78, 0x0e, 0x1f, 0x43, 0x04, 0x36, 0xd5, 0x78, 0x57, 0xef, 0x1c, 0x40,
  0xc5, 0x9e, 0xcd, 0x64, 0xfa, 0x22, 0x17, 0x1a, 0xa5, 0x9b, 0x00, 0xcb,
  0xea, 0x4b, 0x7d, 0x56, 0x3e, 0x5c, 0x54, 0x58, 0xd6, 0x8b, 0x72, 0xc8,
  0xba, 0x45, 0x26, 0x4a, 0xc9, 0x14, 0x89, 0x05, 0x81, 0xc6, 0x98, 0x49,
  0xf4, 0xf7, 0x72, 0x7f, 0x57, 0xae, 0x29, 0xab, 0xc8, 0x06, 0x60, 0x94,
  0x3d, 0x23, 0x6e, 0x7e, 0xe4, 0x4d, 0x03, 0x2f, 0x73, 0x57, 0xb9, 0x40,
  0x15, 0xa4, 0xa6, 0x3b, 0x8e, 0xf7, 0x9e, 0x54, 0xae, 0xea, 0x0c, 0xfe,
  0xa6, 0x99, 0xef, 0xcd, 0x7d, 0xe6, 0x5d, 0xef, 0x6f, 0xa7, 0x67, 0xb5,
  0xa3, 0x7c, 0x26, 0x2a, 0x19, 0x61, 0xb0, 0x13, 0x50, 0x5c, 0xf8, 0x0a,
  0x63, 0x65, 0x51, 0x31, 0xc1, 0xed, 0x5f, 0x96, 0x6f, 0xee, 0x78, 0xd5,
  0x90, 0xb5, 0x40, 0xe8, 0x99, 0x09, 0x77, 0x9e, 0x61, 0x3e, 0xc9, 0xce,
  0xbe, 0xac, 0x59, 0x31, 0x0b, 0xf2, 0xfe, 0x5c, 0x74, 0x22, 0xae, 0x2f,
  0xad, 0x7f, 0x0c, 0x3a, 0xf6, 0xf5, 0x46, 0x54, 0x48, 0x9a, 0xa4, 0x69,
  0xa5, 0xc3, 0xda, 0x6a, 0xd4, 0x39, 0xc4, 0x82, 0x73, 0xd7, 0xd7, 0xe4,
  0xde, 0xc1, 0xea, 0xa4, 0x94, 0xd1, 0xeb, 0xe9, 0xdb, 0xd6, 0xf1, 0xfe,
  0xd9, 0xfc, 0x23, 0x70, 0x2a, 0x29, 0xa7, 0x6c, 0xeb, 0xc6, 0x4a, 0x69,
  0x55, 0xbf, 0x36, 0x8e, 0x7c, 0x00, 0x22, 0x94, 0x9e, 0x3c, 0x5e, 0x14,
  0x56, 0x70, 0xcb, 0x2b, 0x68, 0x6d, 0x86, 0xd0, 0xa3, 0x7b, 0xe6, 0xc1,
  0xa1, 0x3c, 0xc9, 0x53, 0xb7, 0x11, 0x53, 0xe4, 0x5c, 0x68, 0x55, 0x0d,
  0x4b, 0x32, 0x92, 0xdf, 0xc3, 0x70, 0x10, 0x6f, 0x4d, 0xec, 0xb4, 0x89,
  0x50, 0x5d, 0x67, 0xb7, 0xac, 0x9b, 0x73, 0xc0, 0xba, 0x55, 0x8a, 0xcc,
  0xce, 0x93, 0x1f, 0x00, 0x02, 0x24, 0xe3, 0xa2, 0x6d, 0x23, 0xce, 0xc7,
  0x38, 0x51, 0xce, 0x46, 0x18, 0xf8, 0x64, 0x61, 0xdc, 0xd3, 0x23, 0x5c,
  0x6a, 0x51, 0x69, 0xe5, 0x0d, 0x92, 0xae, 0x9f, 0xbd, 0x4d, 0xb2, 0xc9,
  0x74, 0x70, 0xe4, 0xb9, 0xed, 0xbd, 0x27, 0xdd, 0x81, 0x61, 0x29, 0x92,
  0x15, 0x2a, 0x47, 0x15, 0xe0, 0x20, 0x24, 0xf6, 0x86, 0xf7, 0x01, 0xd5,
  0x8a, 0x37, 0xad, 0xab, 0x9b, 0x89, 0x43, 0xd1, 0xa5, 0x4d, 0x10, 0x7d,
  0xe1, 0xf7, 0xa8, 0xed, 0xc0, 0xed, 0x11, 0x2a, 0xee, 0x47, 0xc5, 0x3b,
  0x16, 0xbd, 0x7c, 0xaf, 0x23, 0x4b, 0x85, 0x6d, 0x88, 0x87, 0x6b, 0xac,
  0xdf, 0x01, 0x8f, 0x34, 0x6b, 0xc1, 0x8b, 0x34, 0x76, 0x38, 0x39, 0xae,
  0x2c, 0x01, 0x4f, 0xae, 0xf2, 0xd9, 0x95, 0x1e, 0x68, 0xfe, 0x6e, 0x93,
  0x43, 0x22, 0x84, 0xa5, 0x90, 0xb3, 0x1c, 0x17, 0x00, 0xfa, 0x2c, 0x18,
  0x16, 0xd4, 0x03, 0xe8, 0xc4, 0xc1, 0xc3, 0xd3, 0xa9, 0x46, 0x85, 0xca,
  0x0e, 0xdf, 0x21, 0xf2, 0xf6, 0xc4, 0x0a, 0x8a, 0xb1, 0xb9, 0x03, 0xb3,
  0x12, 0xcd, 0x30, 0x93, 0xc0, 0x8c, 0xa3, 0x3e, 0x4d, 0x89, 0x8d, 0x33,
  0x04, 0x7d, 0x8d, 0x7d, 0x9e, 0xc7, 0xbc, 0x26, 0x22, 0x9a, 0x8a, 0x69,
  0x10, 0xf7, 0x0a, 0x86, 0x07, 0x10, 0xc5, 0xba, 0x83, 0x53, 0x0b, 0xcf,
  0x92, 0xa7, 0x20, 0x6d, 0x66, 0xde, 0xe8, 0x51, 0x51, 0xb0, 0xa4, 0x1d,
  0x1e, 0xee, 0x95, 0x94, 0x34, 0xe4, 0x1c, 0x5a, 0x40, 0x6d, 0x96, 0xc0,
  0xd6, 0x35, 0xc8, 0x4c, 0x1c, 0x84, 0x7b, 0x32, 0xb9, 0x7a, 0x7e, 0xea,
  0xf4, 0xc2, 0xbb, 0x2d, 0x49, 0xe7, 0x7e, 0x1e, 0xef, 0x6a, 0x25, 0xf7,
  0xbb, 0x91, 0x9c, 0x81, 0xa5, 0x53, 0x0f, 0xc3, 0xc5, 0xa4, 0xf1, 0x2b,
  0x39, 0x5c, 0x5a, 0x4c, 0x63, 0x58, 0xc0, 0x3e, 0x11, 0x7d, 0x5c, 0x33,
  0x68, 0x2f, 0xd2, 0x37, 0xe9, 0x77, 0x4a, 0x80, 0x1c, 0x6c, 0x38, 0x7c,
  0x51, 0x30, 0x07, 0xf5, 0x92, 0x4d, 0xb7, 0xf6, 0x93, 0x81, 0x0c, 0xaa,
  0x91, 0x14, 0xc5, 0xe8, 0x91, 0xb6, 0x91, 0x36, 0xfe, 0x41, 0x84, 0x89,
  0x0a, 0xe9, 0x0e, 0x45, 0x05, 0xae, 0xdc, 0x08, 0x35, 0x3f, 0x67, 0x8c,
  0x90, 0x25, 0xa5, 0x69, 0x0c, 0xdc, 0xba, 0xb5, 0x3d, 0x0c, 0xa8, 0xa5,
  0x93, 0x9d, 0x74, 0x7c, 0x1a, 0x98, 0xcb, 0xc6, 0xaf, 0x0a, 0xfb, 0xdc,
  0xfb, 0x45, 0x82, 0x0f, 0x29, 0xd3, 0xf3, 0x50, 0x31, 0xe8, 0xa4, 0xd5,
  0x0f, 0x7a, 0xb3, 0x97, 0x81, 0xb5, 0x34, 0x59, 0x98, 0x19, 0xf1, 0x46,
  0x62, 0xd2, 0xf5, 0x7a, 0x55, 0xe3, 0x34, 0x59, 0x53, 0x4b, 0x57, 0xeb,
  0x76, 0x4f, 0x83, 0x64, 0x4a, 0x06, 0x76, 0x19, 0x70, 0xbf, 0x74, 0x22,
  0xc5, 0x51, 0x75, 0xb6, 0xef, 0x78, 0xfa, 0x48, 0xa4, 0xcf, 0xd3, 0x70,
  0xb1, 0xc4, 0xc4, 0x08, 0x5c, 0x0c, 0x11, 0x50, 0xef, 0x9a, 0x76, 0x0e,
  0xe0, 0x50, 0x99, 0x87, 0xf7, 0xb8, 0x93, 0x69, 0xed, 0x4f, 0xd0, 0xfc,
  0x4d, 0x48, 0x63, 0x0e, 0xea, 0x38, 0x15, 0x5f, 0x1c, 0x22, 0xa6, 0xe2,
  0x13, 0x64, 0xa3, 0x46, 0x0d, 0x26, 0x3c, 0x31, 0x0f, 0x61, 0x08, 0xa4,
  0xe9, 0x65, 0x54, 0x78, 0x50, 0xc7, 0xf6, 0xe9, 0x4f, 0xab, 0xac, 0xb4,
  0x91, 0x27, 0xef, 0xd2
};
unsigned int __1023_oma_cbc_len = 1024+16;
unsigned char __1024_oma_bin[] = {
  0x43, 0x4d, 0xd0, 0x95, 0xcb, 0x3e, 0x7d, 0xed, 0xbd, 0x8c, 0x6f, 0x47,
  0x2e, 0xdb, 0x08, 0x09, 0x94, 0x98, 0xf4, 0xcb, 0x48, 0xcd, 0x51, 0xf5,
  0x72, 0xf1, 0xf6, 0x89, 0x7d, 0x19, 0x66, 0x4a, 0x38, 0x3c, 0x0e, 0x0e,
  0x4a, 0xee, 0x94, 0xaa, 0xd1, 0x86, 0xd1, 0xfb, 0xc5, 0x34, 0x7f, 0x2f,
  0x0a, 0x60, 0xc6, 0xa9, 0x42, 0xf8, 0x76, 0x2e, 0x74, 0x27, 0x6f, 0x5f,
  0x39, 0xa1, 0x7f, 0xd6, 0xb8, 0x52, 0x22, 0x81, 0x6f, 0x99, 0xa8, 0x51,
  0xcb, 0x1e, 0xc1, 0xe6, 0xe6, 0xee, 0x3e, 0xbe, 0xb7, 0xb5, 0x00, 0x68,
  0xd7, 0x1a, 0x4d, 0xd4, 0x9a, 0x27, 0xeb, 0x55, 0xe0, 0xad, 0x93, 0xf3,
  0x28, 0x32, 0xa7, 0x2e, 0x02, 0x93, 0xa7, 0xb5, 0xe8, 0x79, 0xf2, 0x0c,
  0xb4, 0x27, 0x62, 0x18, 0xb3, 0xe3, 0xe8, 0x7c, 0xa0, 0xc0, 0x5b, 0xc1,
  0x50, 0x26, 0xa8, 0xcf, 0xd5, 0x3b, 0xec, 0x9e, 0x8e, 0xd5, 0x6d, 0x80,
  0xde, 0x88, 0x50, 0x67, 0x62, 0xf2, 0x36, 0xeb, 0x26, 0x8a, 0xdf, 0x48,
  0x0e, 0x38, 0x1e, 0x5f, 0x1a, 0x73, 0x0e, 0x2d, 0x92, 0xb3, 0x1c, 0x94,
  0x16, 0x02, 0x87, 0x03, 0xd3, 0xaf, 0x23, 0xf3, 0x26, 0x0a, 0x41, 0x6e,
  0x2c, 0x67, 0x5f, 0xb7, 0x9e, 0xe3, 0x6e, 0x8a, 0x8f, 0x69, 0xc9, 0x7f,
  0x33, 0xae, 0xc8, 0x2b, 0x22, 0xc8, 0xd7, 0x49, 0x68, 0xd0, 0xf5, 0x82,
  0x1d, 0xb0, 0x2e, 0x77, 0x8c, 0xf5, 0x6e, 0x90, 0x72, 0x88, 0x89, 0x68,
  0xf8, 0x49, 0x60, 0xf9, 0xd4, 0xce, 0xdb, 0xf8, 0x74, 0x2b, 0x93, 0x68,
  0x2a, 0x5e, 0x71, 0xeb, 0x1d, 0x9f, 0xb8, 0x02, 0x7a, 0x0d, 0x83, 0xab,
  0x16, 0x0c, 0xd3, 0xf3, 0x3f, 0x47, 0xc7, 0x4e, 0xc1, 0xc8, 0x8d, 0xed,
  0xcc, 0xdf, 0xc7, 0xf8, 0x10, 0x3d, 0x23, 0x13, 0xd2, 0x6b, 0xe4, 0x58,
  0x78, 0xd6, 0x74, 0x57, 0xb3, 0xfa, 0x9c, 0x7c, 0x55, 0x97, 0xe3, 0x44,
  0x59, 0xec, 0x22, 0xdd, 0x58, 0xdf, 0xec, 0x4d, 0x06, 0xd0, 0x57, 0xd6,
  0x25, 0x6c, 0x3d, 0x05, 0x1c, 0x9c, 0x26, 0x0b, 0xfc, 0x0f, 0xdb, 0xb6,
  0x40, 0x7d, 0xdf, 0xe5, 0x69, 0x08, 0xc0, 0x91, 0xcd, 0xe5, 0x41, 0xff,
  0xde, 0x03, 0xf2, 0x1c, 0xd9, 0x66, 0x77, 0xdb, 0x25, 0xbf, 0xdf, 0xf2,
  0x23, 0x1e, 0x59, 0xa2, 0x7d, 0xbb, 0x15, 0xf9, 0x1f, 0x9a, 0x13, 0xda,
  0x1c, 0x72, 0x74, 0xfe, 0xc5, 0x4d, 0x21, 0x2e, 0x86, 0x37, 0xbb, 0xd6,
  0x80, 0xbf, 0x9e, 0x43, 0x14, 0x53, 0xa5, 0xe8, 0xc9, 0xa5, 0xb6, 0xc9,
  0x7a, 0xd6, 0x5e, 0x0e, 0x8f, 0x41, 0x4e, 0xc8, 0x00, 0xcb, 0x7d, 0xb7,
  0xb9, 0x78, 0x57, 0x7c, 0x4b, 0x6e, 0x66, 0x8f, 0x5c, 0xd3, 0xc1, 0x76,
  0xbd, 0x6d, 0x71, 0xa3, 0x43, 0x9f, 0x1b, 0x99, 0xd2, 0xe3, 0x32, 0x06,
  0x7f, 0xff, 0xa8, 0x22, 0x95, 0x31, 0x65, 0xa8, 0x65, 0x7f, 0x94, 0x08,
  0xd0, 0x0c, 0x81, 0xaa, 0x51, 0x5b, 0x04, 0x09, 0x4d, 0x7f, 0xc2, 0xc6,
  0x18, 0x3f, 0x7d, 0x78, 0xd0, 0x9f, 0xd9, 0x98, 0xc5, 0xa4, 0xe4, 0xe3,
  0xc8, 0x76, 0xc8, 0x43, 0xe8, 0xef, 0xe5, 0xb6, 0xa5, 0x58, 0x1b, 0x72,
  0x45, 0x1a, 0xef, 0x67, 0xaa, 0xc6, 0xb5, 0x7f, 0x84, 0x32, 0x7b, 0x0d,
  0x82, 0x6f, 0x6a, 0x2f, 0x6f, 0x92, 0x97, 0xb5, 0x9e, 0x08, 0x0e, 0x55,
  0x71, 0xa5, 0x76, 0xdb, 0xb1, 0x5d, 0x52, 0x2e, 0x94, 0x2e, 0xea, 0x2f,
  0x6e, 0x71, 0xe2, 0x6c, 0x38, 0x58, 0x4d, 0xba, 0x9f, 0x0a, 0x91, 0x73,
  0x9f, 0xf3, 0x2e, 0xf1, 0xe9, 0x0a, 0xd0, 0x99, 0xd3, 0xce, 0x45, 0xbb,
  0x6c, 0x1d, 0xa7, 0x69, 0xe6, 0x68, 0xb0, 0x60, 0xd7, 0xe6, 0x99, 0x74,
  0x93, 0x07, 0x27, 0xa9, 0xe1, 0x62, 0x4d, 0xb9, 0xcd, 0x2e, 0x06, 0xde,
  0xeb, 0x1c, 0xaa, 0x49, 0xd0, 0x32, 0xd0, 0xfe, 0x99, 0xf0, 0x52, 0x98,
  0xbc, 0xaa, 0x71, 0xd5, 0x50, 0x83, 0x6c, 0x0e, 0xa0, 0x06, 0xc6, 0xf2,
  0xaf, 0x33, 0x16, 0xd0, 0x00, 0x5b, 0xa8, 0xa8, 0x75, 0x29, 0x11, 0xb1,
  0x73, 0x63, 0xf8, 0x24, 0x19, 0x6c, 0x5d, 0x5c, 0xd7, 0x92, 0x6a, 0x23,
  0x1c, 0xd6, 0x81, 0xb3, 0x88, 0xa5, 0x7b, 0x63, 0x63, 0xa3, 0x6d, 0x02,
  0xb1, 0x81, 0x13, 0x67, 0xc8, 0x60, 0x8e, 0x54, 0x00, 0xa5, 0xf1, 0xb7,
  0xf3, 0xaf, 0xc7, 0x1a, 0x27, 0x89, 0x5f, 0x26, 0xdb, 0x24, 0xd6, 0xeb,
  0x50, 0x2f, 0xb8, 0xe4, 0x5b, 0x1a, 0x5c, 0xd3, 0x91, 0x58, 0x2d, 0xac,
  0xf4, 0xb4, 0x2a, 0x02, 0xab, 0xb7, 0xe4, 0x70, 0x00, 0x12, 0x29, 0x97,
  0xf0, 0x01, 0x52, 0xb9, 0x4a, 0xc4, 0x12, 0x91, 0xe1, 0xa2, 0x0b, 0x89,
  0xe2, 0xa4, 0xfa, 0xc3, 0x94, 0xd1, 0x3f, 0x7a, 0x3b, 0x7c, 0xe2, 0x51,
  0x64, 0xdc, 0x6c, 0xbc, 0x39, 0x3d, 0x01, 0xbc, 0x46, 0x02, 0x22, 0x86,
  0xbb, 0xbf, 0x1a, 0xae, 0x67, 0x4d, 0xe2, 0xc2, 0x36, 0xe8, 0x15, 0xe6,
  0x2f, 0xce, 0xf2, 0x2e, 0xda, 0x94, 0x6f, 0x3e, 0x8b, 0x8b, 0x05, 0x0d,
  0x43, 0xe3, 0x9b, 0xb1, 0x01, 0x34, 0x78, 0x4a, 0x92, 0x77, 0x77, 0x13,
  0x92, 0x12, 0x2c, 0x15, 0x9b, 0xa7, 0x4a, 0x26, 0x07, 0x85, 0x99, 0x9f,
  0x95, 0xd6, 0x85, 0xb4, 0xcc, 0x7d, 0x00, 0x16, 0x73, 0xbd, 0x83, 0x1e,
  0xb7, 0xc4, 0xcd, 0x75, 0x0f, 0x95, 0xf6, 0x9a, 0x44, 0x14, 0x1d, 0xd5,
  0x20, 0x00, 0xe2, 0xa9, 0x7a, 0x82, 0xc1, 0x55, 0xb6, 0xe7, 0xd3, 0x56,
  0xf2, 0x64, 0x44, 0x3e, 0x07, 0xb0, 0xdf, 0xdd, 0x91, 0xac, 0x6a, 0x07,
  0x4f, 0x4c, 0xe1, 0x45, 0x12, 0x22, 0xdf, 0x6d, 0x47, 0x2c, 0x1c, 0x39,
  0x34, 0x9d, 0x05, 0x5f, 0x97, 0x1a, 0x2a, 0x7c, 0x57, 0x88, 0x7d, 0x6c,
  0x3d, 0x73, 0x4b, 0xd5, 0x7f, 0x8f, 0x55, 0x2c, 0x5b, 0xdc, 0x4c, 0x1f,
  0xa0, 0x1c, 0xb7, 0xf7, 0xa7, 0x03, 0x1f, 0x75, 0xe7, 0x0a, 0x58, 0xa6,
  0xc8, 0x60, 0x60, 0xc3, 0x95, 0x5e, 0xf3, 0xfb, 0x97, 0x88, 0x00, 0xb0,
  0x07, 0xdf, 0xb9, 0xda, 0xec, 0x66, 0x5b, 0xd6, 0x84, 0x21, 0xfd, 0xef,
  0xd7, 0x5d, 0x1d, 0xc6, 0xaf, 0xf6, 0xbf, 0x8d, 0xc6, 0x80, 0x94, 0xde,
  0x45, 0xd0, 0x5f, 0xf8, 0xee, 0x28, 0xe6, 0xa3, 0xce, 0x80, 0xd2, 0xa3,
  0x63, 0x4a, 0x54, 0x60, 0x30, 0x67, 0xd4, 0x42, 0xdc, 0x6e, 0x28, 0x44,
  0x3c, 0x10, 0x88, 0x24, 0x3b, 0xe7, 0x8d, 0x5a, 0x44, 0xa3, 0xd4, 0x37,
  0x87, 0xa0, 0x54, 0x92, 0x7f, 0x5a, 0xe5, 0xeb, 0x53, 0xbf, 0x64, 0xfe,
  0x8b, 0x16, 0x19, 0x04, 0x32, 0x20, 0x91, 0xe7, 0x24, 0x4b, 0x97, 0x03,
  0xa0, 0xbd, 0xc8, 0x52, 0xc3, 0x8f, 0x47, 0x26, 0x68, 0x0c, 0x64, 0xb3,
  0x98, 0x4e, 0x44, 0xc9, 0xdb, 0x18, 0xab, 0x42, 0xfa, 0xb2, 0xe6, 0x34,
  0x8e, 0x71, 0xb6, 0x68, 0xb1, 0x02, 0x08, 0x6a, 0x80, 0xcc, 0x26, 0x44,
  0x0c, 0xe3, 0x9d, 0x36, 0x73, 0xdc, 0x73, 0x64, 0xbc, 0xb1, 0xef, 0x68,
  0xa8, 0xd4, 0x95, 0xd0, 0x71, 0x84, 0x6f, 0x95, 0xb2, 0x74, 0x5d, 0x7e,
  0xf5, 0xaa, 0x3b, 0xa9, 0x1b, 0x10, 0x67, 0x51, 0xd2, 0x86, 0x48, 0x0d,
  0x25, 0x94, 0x5a, 0x42, 0x83, 0x58, 0x08, 0xdc, 0x82, 0x8a, 0xd0, 0x2d,
  0xd1, 0x7d, 0x2b, 0x0a, 0x25, 0x70, 0x01, 0x6f, 0x70, 0x06, 0x20, 0xf4,
  0x66, 0xf8, 0x75, 0xf8, 0xc5, 0x14, 0x85, 0x97, 0x5a, 0x35, 0x04, 0x00,
  0xe2, 0x8f, 0x29, 0x1f, 0x2d, 0x10, 0x1f, 0x0b, 0x5f, 0xf5, 0x10, 0xf1,
  0x11, 0x9a, 0x9b, 0x4f
};
unsigned int __1024_oma_bin_len = 1024+16;
unsigned char __1024_oma_cbc[] = {
  0x5f, 0x10, 0xa7, 0x07, 0x9e, 0x8b, 0x85, 0x2a, 0x69, 0xa1, 0x49, 0x50,
  0xfd, 0x89, 0x3a, 0x98, 0xd0, 0x2d, 0x46, 0x6c, 0x88, 0xf5, 0x3e, 0xba,
  0x2e, 0xbc, 0x58, 0x19, 0x7d, 0xf0, 0xcf, 0x8b, 0xd2, 0x97, 0xf7, 0x02,
  0x25, 0x82, 0x7f, 0xeb, 0x97, 0xf6, 0xf0, 0x05, 0x98, 0x6c, 0x29, 0xd6,
  0x13, 0x62, 0x6e, 0x11, 0xe2, 0xe5, 0x3b, 0xe1, 0xf3, 0x86, 0x13, 0x95,
  0x77, 0xdd, 0x3a, 0x75, 0x12, 0xa1, 0xa6, 0x18, 0x51, 0xe2, 0xb4, 0x5e,
  0xef, 0xb6, 0xc0, 0x8e, 0xda, 0x45, 0xf6, 0xd6, 0x87, 0x3f, 0x8a, 0x69,
  0xdb, 0x26, 0xaa, 0x88, 0x68, 0x80, 0x8d, 0xed, 0xc2, 0x78, 0x1b, 0x55,
  0x34, 0x6e, 0x83, 0x83, 0x12, 0xe1, 0xc8, 0x08, 0x35, 0x29, 0x46, 0x51,
  0x31, 0xdf, 0x4e, 0x00, 0xd6, 0x27, 0x51, 0xcc, 0x54, 0xf2, 0x12, 0x55,
  0x28, 0x9f, 0xe0, 0xe5, 0x86, 0xed, 0x80, 0x65, 0xa1, 0xdb, 0xa5, 0x5a,
  0xee, 0xf0, 0x5a, 0x87, 0x02, 0x2b, 0x89, 0x41, 0xd5, 0x62, 0x40, 0x3d,
  0xa3, 0x88, 0xad, 0x4c, 0x33, 0xfd, 0xa7, 0xb4, 0x96, 0xda, 0x15, 0xb8,
  0x6d, 0xc1, 0x34, 0xf5, 0xb1, 0x58, 0x27, 0x4f, 0xc3, 0x41, 0x12, 0xcc,
  0x4d, 0x94, 0xb1, 0x4f, 0x33, 0x31, 0x34, 0xcd, 0x63, 0xca, 0xb3, 0x72,
  0x14, 0xe3, 0x3e, 0xc5, 0x73, 0xe1, 0x86, 0x77, 0x54, 0xcf, 0xf7, 0x16,
  0xc9, 0xd8, 0x0c, 0xe0, 0x5b, 0xbb, 0xdc, 0xcf, 0xaa, 0x4a, 0xe2, 0xdc,
  0xf2, 0x95, 0x63, 0x07, 0xb4, 0x90, 0x3b, 0x47, 0xcb, 0x1d, 0xac, 0x8c,
  0x31, 0xd6, 0xcc, 0x10, 0xf0, 0x16, 0xee, 0x6c, 0x26, 0x8f, 0x7c, 0xa2,
  0x77, 0xba, 0x0a, 0x70, 0x1a, 0x37, 0x25, 0x6f, 0xac, 0xdc, 0xa9, 0x4f,
  0x1e, 0x67, 0xad, 0xc7, 0xc8, 0x3b, 0xbb, 0x17, 0x94, 0x36, 0xab, 0x40,
  0x3c, 0x55, 0x23, 0x63, 0x30, 0x6f, 0x0f, 0xa9, 0x47, 0xe5, 0x35, 0x4b,
  0xe8, 0x2e, 0xe8, 0x9b, 0xf4, 0x3b, 0x75, 0x7e, 0x69, 0x7d, 0x1d, 0x6c,
  0x4b, 0xcd, 0x37, 0x9e, 0x99, 0xe3, 0xd4, 0xda, 0xf0, 0xe8, 0x4d, 0x93,
  0x00, 0x61, 0x13, 0x04, 0xa3, 0xd9, 0x77, 0xd6, 0x96, 0xae, 0xc8, 0x86,
  0x22, 0xe9, 0x50, 0xe6, 0x0f, 0xf1, 0x51, 0x4b, 0x6a, 0xf9, 0xf0, 0x2e,
  0x6e, 0x22, 0xbc, 0x94, 0x30, 0x1c, 0x37, 0x19, 0xd1, 0x4c, 0x88, 0xe8,
  0x17, 0xb7, 0x66, 0x5a, 0x2e, 0x2f, 0xee, 0x09, 0x83, 0x1f, 0x19, 0xf4,
  0xc5, 0xea, 0x6f, 0x3a, 0xeb, 0xdd, 0x70, 0xb5, 0xf4, 0x9c, 0x1c, 0xf2,
  0x1c, 0x2e, 0x03, 0x9a, 0xc8, 0x24, 0xf1, 0x51, 0xd1, 0x93, 0xf7, 0xd2,
  0xf5, 0x8a, 0x87, 0xb4, 0x4b, 0xf2, 0x59, 0x80, 0xf5, 0x2b, 0x3c, 0x1d,
  0x2f, 0xf3, 0xb9, 0x99, 0xa1, 0xc9, 0x5f, 0xe7, 0x9d, 0x46, 0xed, 0xbc,
  0x7e, 0x0a, 0x98, 0x57, 0xcc, 0x81, 0x14, 0x05, 0x0d, 0xbe, 0x5f, 0xf9,
  0x9f, 0x14, 0x80, 0x10, 0x57, 0x99, 0x17, 0x87, 0x7c, 0x1d, 0x65, 0x24,
  0x05, 0xca, 0x73, 0x15, 0xa1, 0xf0, 0x45, 0x29, 0x47, 0x45, 0x8b, 0x8e,
  0x5a, 0x65, 0x79, 0xb4, 0xdb, 0xab, 0x7a, 0xdd, 0x9a, 0x1a, 0x7c, 0xcc,
  0x0f, 0xd3, 0xf4, 0x1c, 0xe9, 0x2b, 0x46, 0xd9, 0x1b, 0xb6, 0x05, 0xc1,
  0x06, 0xe4, 0xfa, 0x65, 0xe4, 0x7c, 0xcc, 0x09, 0x25, 0x52, 0x5e, 0xd5,
  0x1e, 0xf4, 0x31, 0x75, 0xe4, 0xf6, 0xb6, 0x3b, 0x53, 0xc4, 0xec, 0xcc,
  0xa5, 0x62, 0xf7, 0x0a, 0x17, 0x44, 0x9a, 0xbf, 0xfe, 0x27, 0xe3, 0x49,
  0x6b, 0x46, 0x53, 0xf3, 0x76, 0x10, 0xb1, 0xc6, 0x30, 0x52, 0x84, 0xd0,
  0x00, 0xcb, 0xca, 0xca, 0x71, 0x89, 0x3f, 0x11, 0x7b, 0x51, 0xf5, 0x14,
  0x5f, 0x60, 0x2b, 0x18, 0x36, 0x45, 0x99, 0x66, 0x12, 0xa6, 0xaf, 0xfe,
  0x1f, 0xd0, 0x1c, 0x35, 0xe3, 0x1f, 0xcf, 0x4c, 0x7d, 0x5f, 0xb9, 0x16,
  0xdc, 0xb5, 0xa6, 0xf2, 0x6d, 0xc7, 0xe5, 0x8f, 0x00, 0xa8, 0x66, 0x9f,
  0x3c, 0x26, 0xd5, 0x15, 0xda, 0xae, 0x6e, 0xc7, 0x59, 0x98, 0xab, 0x6e,
  0x48, 0xff, 0xda, 0xeb, 0x69, 0x32, 0x87, 0x2a, 0x00, 0x81, 0xb0, 0x9b,
  0xab, 0x9f, 0x59, 0xf8, 0xf9, 0x76, 0x37, 0xfb, 0x2a, 0x5c, 0xff, 0xc8,
  0x10, 0xf0, 0xa3, 0x14, 0x2e, 0xdd, 0x1b, 0x43, 0x8b, 0xc6, 0x23, 0xf1,
  0x76, 0xb2, 0xaf, 0x1f, 0x0e, 0xe6, 0x7f, 0xf4, 0x4a, 0xc4, 0xbf, 0x34,
  0xe4, 0x19, 0xe9, 0x47, 0x39, 0x57, 0x31, 0x19, 0x41, 0x70, 0xb0, 0x8c,
  0x3c, 0xf4, 0x3e, 0x03, 0x2d, 0x26, 0xe2, 0xc5, 0x0c, 0xe9, 0x29, 0x96,
  0x27, 0xb9, 0x13, 0x03, 0x77, 0x09, 0x70, 0x76, 0xce, 0xd8, 0x72, 0x2a,
  0x83, 0x90, 0xb7, 0xd4, 0x47, 0x0b, 0xc9, 0x86, 0x1f, 0x0e, 0x23, 0xe4,
  0xe0, 0xfa, 0x94, 0x9d, 0xcf, 0x7a, 0x4a, 0x79, 0x35, 0xfd, 0x36, 0x54,
  0xc6, 0x19, 0x49, 0x25, 0xae, 0x18, 0xf4, 0x76, 0x5f, 0xd1, 0x4f, 0x88,
  0xdc, 0x25, 0x2f, 0x30, 0xcf, 0xf8, 0xf1, 0x60, 0x5f, 0x4a, 0x12, 0xdb,
  0xa9, 0x1c, 0x1b, 0xea, 0xfa, 0xa6, 0xc0, 0x53, 0xf1, 0x9f, 0x32, 0x0b,
  0xf8, 0x03, 0xdb, 0x0e, 0x69, 0x83, 0xd8, 0xfe, 0x1b, 0x60, 0xd7, 0x42,
  0x37, 0xfc, 0x9f, 0xa2, 0x96, 0x5a, 0x7c, 0x69, 0x0f, 0x18, 0xcd, 0xfa,
  0xb3, 0xad, 0xbc, 0x30, 0x44, 0xf3, 0x9c, 0x93, 0x24, 0x9b, 0x63, 0xd0,
  0xb8, 0x53, 0xa9, 0xdf, 0x50, 0x51, 0x4b, 0x93, 0x1a, 0x67, 0xf4, 0xb7,
  0x05, 0x14, 0x38, 0xe5, 0x21, 0xca, 0xf4, 0xaf, 0x88, 0x0d, 0x04, 0x4f,
  0x9f, 0x68, 0xe5, 0x2a, 0x1f, 0x87, 0xc1, 0x2e, 0xa7, 0xf4, 0x4d, 0xe7,
  0x9e, 0x73, 0x2b, 0x67, 0x75, 0x25, 0xf8, 0xb9, 0xba, 0x64, 0x23, 0x57,
  0x66, 0x05, 0x49, 0x84, 0x41, 0x20, 0xda, 0x64, 0xc0, 0xa3, 0xc3, 0xf3,
  0xa8, 0x5f, 0x36, 0x72, 0xc8, 0x5e, 0xb3, 0xac, 0x4c, 0x1b, 0x2c, 0x19,
  0x59, 0x5a, 0xc0, 0x61, 0x13, 0x3a, 0x0c, 0x64, 0xa3, 0xb7, 0x8f, 0x46,
  0x34, 0x7e, 0x68, 0xac, 0x3a, 0x3a, 0xc5, 0xa4, 0x4e, 0x45, 0x8f, 0x82,
  0x34, 0x07, 0x46, 0x2f, 0xd1, 0xe1, 0xbf, 0x08, 0x1b, 0xba, 0x1e, 0xd4,
  0xca, 0x70, 0xaa, 0x30, 0xbf, 0x59, 0xa4, 0x6d, 0x2d, 0x92, 0x33, 0xc3,
  0x3b, 0xa2, 0x5c, 0x0a, 0xd5, 0xaa, 0xd8, 0xb3, 0xd5, 0x0c, 0xcb, 0x92,
  0x0f, 0x6a, 0x9a, 0x9e, 0x55, 0x83, 0xa5, 0x85, 0x6b, 0x3a, 0xbe, 0x64,
  0x51, 0xd6, 0x91, 0x23, 0x5d, 0x73, 0x04, 0xca, 0xb8, 0xfe, 0x4c, 0xe3,
  0x3d, 0xaf, 0x8b, 0xad, 0xcd, 0x06, 0x8f, 0x10, 0x30, 0x80, 0xc1, 0x68,
  0xd4, 0x3e, 0x97, 0x99, 0xd5, 0x5c, 0x7b, 0x8d, 0xe0, 0x38, 0xa5, 0x9f,
  0x18, 0xe0, 0x8d, 0xb8, 0xd3, 0x95, 0x6e, 0x42, 0xf8, 0x4f, 0x16, 0x2a,
  0xa7, 0xca, 0x2c, 0x42, 0x82, 0xc2, 0xd0, 0x9e, 0x65, 0xbd, 0x8a, 0x62,
  0x0c, 0x76, 0x9e, 0xba, 0xc8, 0x68, 0xd0, 0x31, 0xe2, 0x75, 0xee, 0x8f,
  0xc9, 0x8b, 0x2a, 0xf2, 0x44, 0x52, 0xd4, 0x5e, 0xdd, 0xe1, 0xab, 0x74,
  0xaf, 0xc2, 0xbc, 0x8c, 0x1e, 0x41, 0x3e, 0x0e, 0x2d, 0x61, 0xd1, 0xbc,
  0x42, 0x7a, 0xca, 0x88, 0x92, 0x09, 0x97, 0xb6, 0x7c, 0x6b, 0x13, 0xe3,
  0xfd, 0x73, 0xa5, 0x9d, 0x7e, 0xde, 0xf5, 0xa3, 0x44, 0x91, 0x72, 0x63,
  0xd7, 0xed, 0x3d, 0xa1, 0x0f, 0xa0, 0x65, 0x27, 0x28, 0x02, 0x35, 0xb5,
  0x1c, 0x60, 0x28, 0x09, 0xc9, 0x27, 0x6d, 0x04, 0x03, 0x67, 0xe7, 0xcf,
  0xb6, 0x42, 0xc7, 0x5a, 0xe6, 0x87, 0x43, 0x57, 0x53, 0xb1, 0x95, 0xa8,
  0x31, 0x0b, 0x35, 0xa4, 0x19, 0xf2, 0x06, 0xd3
};
unsigned int __1024_oma_cbc_len = 1040;
unsigned char __1025_oma_bin[] = {
  0xaa, 0x34, 0xd0, 0xbd, 0x90, 0xa5, 0x0a, 0xdf, 0x69, 0xc1, 0x47, 0xde,
  0xf7, 0x3c, 0x86, 0xa3, 0x5b, 0x9b, 0xa7, 0x38, 0x44, 0xc4, 0x3d, 0x3a,
  0x52, 0xdc, 0xb6, 0x39, 0x97, 0x39, 0xca, 0xb3, 0x1d, 0xec, 0xc4, 0xfe,
  0x0f, 0xf9, 0x9e, 0xdb, 0xa1, 0x32, 0xa0, 0xa6, 0xfb, 0x97, 0x1e, 0x0d,
  0x2a, 0xb2, 0x7a, 0x67, 0xdf, 0xe2, 0xf5, 0x7d, 0xa5, 0xb0, 0x2d, 0x84,
  0x86, 0x8b, 0x71, 0xb2, 0xc1, 0xc9, 0xcc, 0x5f, 0x99, 0xf4, 0x91, 0xa6,
  0x66, 0x6f, 0x6b, 0xd7, 0x3d, 0xd1, 0x1e, 0xcc, 0x00, 0x4c, 0xe8, 0xf6,
  0xa7, 0x2e, 0x7d, 0x10, 0x08, 0x47, 0x58, 0xce, 0xe5, 0x16, 0xee, 0xc1,
  0x7d, 0xa6, 0x08, 0xbd, 0x5d, 0x1c, 0x7d, 0x5a, 0x65, 0x5a, 0xca, 0xfd,
  0xad, 0xe6, 0x0a, 0x74, 0x05, 0x1e, 0x0e, 0xa1, 0xb9, 0x85, 0xba, 0x0d,
  0xb7, 0x5b, 0x8d, 0x30, 0x41, 0x50, 0xe4, 0x29, 0xe0, 0xcf, 0x3a, 0xc8,
  0xcb, 0x8e, 0xa8, 0xad, 0xa0, 0x02, 0xd2, 0x90, 0xbf, 0xc8, 0xaa, 0x72,
  0x07, 0x61, 0x1a, 0x38, 0x75, 0xcd, 0x78, 0x30, 0x33, 0xce, 0xb1, 0xa4,
  0x09, 0x5e, 0xd0, 0x1c, 0xc9, 0xaf, 0xef, 0xc0, 0x24, 0xd6, 0x45, 0x0d,
  0xd0, 0xd8, 0x39, 0xf9, 0xe5, 0xd2, 0xbf, 0x20, 0xf9, 0x3d, 0x25, 0xd8,
  0x78, 0xc6, 0x63, 0x2a, 0xe2, 0xef, 0x5e, 0x83, 0xe0, 0x14, 0x1e, 0x65,
  0x7c, 0x6d, 0x71, 0xd1, 0x4d, 0xa3, 0xe8, 0x1c, 0x4a, 0x82, 0x25, 0x40,
  0x62, 0x82, 0xd5, 0x9a, 0x0c, 0x04, 0x91, 0x9c, 0x0d, 0xd6, 0xb0, 0xb2,
  0x57, 0x05, 0x57, 0xf4, 0xd7, 0xa6, 0x7f, 0x88, 0x47, 0x36, 0x07, 0x5a,
  0xf8, 0xc6, 0x85, 0xd6, 0xfa, 0xb5, 0xcc, 0xca, 0x19, 0x48, 0x61, 0x70,
  0x32, 0xaa, 0xaf, 0x20, 0xef, 0xc7, 0xb0, 0x6f, 0x99, 0xac, 0x8d, 0x9b,
  0x11, 0x32, 0xa0, 0xc5, 0xef, 0xb0, 0xb2, 0x8b, 0xd6, 0xa1, 0x53, 0x40,
  0x74, 0x8c, 0xea, 0xf8, 0x0d, 0x7f, 0x08, 0x75, 0x8f, 0xff, 0xc2, 0x82,
  0xfe, 0xf7, 0xa1, 0x79, 0x38, 0x80, 0x1d, 0x3e, 0xfd, 0x52, 0xd0, 0xdb,
  0x16, 0xb6, 0xcf, 0xfb, 0xfe, 0xa3, 0xba, 0xb4, 0x46, 0x09, 0x7b, 0xc0,
  0x9b, 0xad, 0x9a, 0x45, 0x3e, 0xcd, 0x58, 0xa8, 0x75, 0x1c, 0xc1, 0x0d,
  0x90, 0x3d, 0xb2, 0xe1, 0xe7, 0x9c, 0x3e, 0xed, 0xb0, 0x6a, 0xb2, 0x4b,
  0x2b, 0xb3, 0x92, 0xa5, 0xf2, 0x64, 0xe4, 0x7b, 0xd5, 0xda, 0x88, 0xfe,
  0x02, 0xbe, 0xf7, 0xef, 0xd3, 0x41, 0xb3, 0xb6, 0x1b, 0xf2, 0x00, 0x70,
  0x39, 0xfe, 0xe8, 0xb1, 0x6b, 0x09, 0x4d, 0x82, 0xa7, 0xbc, 0x7b, 0x56,
  0x37, 0x9a, 0x98, 0x8c, 0xc3, 0x47, 0x83, 0x0e, 0xd3, 0x41, 0x15, 0xe9,
  0xa4, 0xe5, 0x83, 0x59, 0x16, 0x66, 0xca, 0xe1, 0x9a, 0x28, 0x3b, 0x74,
  0x5a, 0xd4, 0x89, 0xed, 0xda, 0xce, 0x46, 0x1f, 0x9b, 0x45, 0xaa, 0x6f,
  0x93, 0x12, 0x65, 0x2d, 0x20, 0xce, 0x0c, 0xe3, 0x84, 0x71, 0xb9, 0x27,
  0x88, 0x8e, 0x75, 0x0f, 0x78, 0xd9, 0xa9, 0xba, 0xbd, 0xb9, 0xd3, 0xbe,
  0x83, 0x2c, 0xb8, 0x12, 0x26, 0x4e, 0x9d, 0xa4, 0xd3, 0x79, 0x22, 0x9b,
  0x6d, 0x37, 0xea, 0xb4, 0xb1, 0x3a, 0x45, 0x27, 0x7b, 0x87, 0x13, 0x77,
  0xc3, 0x71, 0xdf, 0x9c, 0x6a, 0x1d, 0xb2, 0xae, 0xf0, 0xa3, 0x14, 0x32,
  0x0e, 0x63, 0xdd, 0xa6, 0xd3, 0xc9, 0xd7, 0x3a, 0x46, 0x18, 0xa3, 0x64,
  0x9c, 0x0d, 0x8c, 0x46, 0x6b, 0x82, 0xcd, 0x0c, 0xf6, 0x07, 0x8f, 0x93,
  0xd0, 0x64, 0xaa, 0x6b, 0xeb, 0x3d, 0x4a, 0xfd, 0xa3, 0xd0, 0x08, 0x2c,
  0x1d, 0x01, 0x4b, 0x71, 0x97, 0xad, 0x22, 0x99, 0x76, 0x86, 0x43, 0x18,
  0x18, 0x87, 0x0d, 0x91, 0x61, 0x03, 0xeb, 0x76, 0xd6, 0xde, 0x71, 0xbd,
  0x81, 0xca, 0x4f, 0x6d, 0x4c, 0xf0, 0x71, 0xef, 0x2f, 0xbb, 0xaf, 0xfa,
  0xb0, 0xae, 0xda, 0x99, 0x49, 0xfb, 0xc5, 0xc9, 0x1d, 0x63, 0x17, 0x4f,
  0xe1, 0x05, 0x80, 0xa3, 0x14, 0x92, 0x28, 0x82, 0x3a, 0x3c, 0x11, 0x54,
  0x2f, 0x55, 0xbe, 0x64, 0x98, 0xf9, 0x10, 0x2e, 0xf6, 0x6f, 0x78, 0x73,
  0xf5, 0x58, 0x22, 0x10, 0xc7, 0x1e, 0x0d, 0x8e, 0x0a, 0x89, 0xbe, 0x06,
  0xcf, 0x7c, 0x0b, 0xba, 0x58, 0xed, 0x24, 0x79, 0x01, 0xd9, 0xb9, 0xda,
  0x68, 0x81, 0x7b, 0x54, 0x9a, 0xf6, 0xe4, 0x04, 0x49, 0x13, 0xd1, 0x8c,
  0x1b, 0x72, 0xbf, 0xf0, 0x39, 0x54, 0xc0, 0x57, 0xe7, 0xd1, 0x4f, 0xd2,
  0x5b, 0x52, 0x04, 0x4a, 0xfb, 0x1d, 0xd8, 0x84, 0x0e, 0xe7, 0x54, 0xea,
  0x27, 0xb4, 0x4d, 0xf1, 0xfa, 0xbd, 0x32, 0x02, 0xc9, 0x36, 0x02, 0x97,
  0xa3, 0xfd, 0xfc, 0xde, 0x2a, 0xe8, 0x4e, 0x09, 0xfa, 0x00, 0xcb, 0x78,
  0xd3, 0xac, 0xe4, 0x52, 0x1e, 0x4e, 0xe8, 0xd4, 0xd7, 0xd1, 0xdc, 0xf8,
  0x3e, 0x2c, 0x8b, 0xd9, 0x4e, 0xb1, 0x7e, 0x55, 0x02, 0xf0, 0x8b, 0xdc,
  0xb0, 0xb0, 0xf8, 0x28, 0xf1, 0x9f, 0x79, 0xb9, 0xeb, 0x41, 0x70, 0x5a,
  0x2d, 0xcd, 0xe5, 0x9f, 0xec, 0xad, 0xde, 0xf0, 0xff, 0xdd, 0x05, 0xa8,
  0xfa, 0xf5, 0xaa, 0xd9, 0x10, 0xbc, 0x96, 0x57, 0x8d, 0xb1, 0x58, 0x15,
  0xa6, 0x02, 0xfb, 0x50, 0xc8, 0xcf, 0x8b, 0x2e, 0x1d, 0x15, 0x9d, 0xdd,
  0x66, 0x71, 0x40, 0xd6, 0x5b, 0x15, 0xc4, 0x5f, 0x5b, 0x59, 0x6f, 0x99,
  0xda, 0xfc, 0xfc, 0x93, 0x30, 0x03, 0x66, 0xd5, 0x7e, 0x00, 0xc9, 0x77,
  0x5b, 0xf2, 0x24, 0x00, 0x0c, 0xce, 0xa6, 0xa6, 0x10, 0x78, 0xbc, 0x56,
  0x66, 0x51, 0x6c, 0xd8, 0xd3, 0x2e, 0x7f, 0xb4, 0xce, 0xbe, 0xe7, 0xc8,
  0xec, 0x58, 0x10, 0xc3, 0xd0, 0x12, 0x5c, 0x52, 0xa0, 0xeb, 0x0e, 0x60,
  0x22, 0x3e, 0xbe, 0xee, 0x6d, 0x6b, 0x8a, 0x0d, 0x13, 0xde, 0xa2, 0xd2,
  0x59, 0x7e, 0x68, 0x96, 0x19, 0xc4, 0x68, 0x3c, 0xe2, 0x6f, 0xd7, 0xb1,
  0x92, 0xa5, 0x31, 0x9f, 0xf3, 0x5f, 0x1c, 0xbd, 0x56, 0x9f, 0xe6, 0x78,
  0x65, 0xbc, 0xb9, 0xc5, 0x1c, 0x8a, 0x77, 0xda, 0xcb, 0xa3, 0xb8, 0x34,
  0xe5, 0xc1, 0x58, 0x8a, 0xd1, 0x48, 0x37, 0xa0, 0x15, 0x63, 0x5d, 0x27,
  0xd8, 0x02, 0x22, 0xed, 0x5a, 0x4f, 0x57, 0x06, 0x3a, 0x11, 0x48, 0xde,
  0x84, 0x75, 0xcc, 0x2a, 0xac, 0xc2, 0xb7, 0xcc, 0xad, 0x9c, 0x23, 0xf2,
  0x92, 0xab, 0xa9, 0x81, 0x36, 0x5c, 0x44, 0xd8, 0x56, 0x28, 0x87, 0x27,
  0x1c, 0x4a, 0x1d, 0xe3, 0xaf, 0x0f, 0x71, 0x6e, 0x14, 0x39, 0x42, 0xf2,
  0x56, 0xe5, 0x3d, 0xe2, 0xec, 0x65, 0x54, 0xa9, 0xad, 0x6e, 0x88, 0x63,
  0xef, 0x74, 0xcf, 0x36, 0xab, 0xe8, 0xe8, 0x35, 0x7f, 0xa8, 0x24, 0x1c,
  0x8f, 0xd1, 0x3f, 0xb7, 0xb1, 0x78, 0x43, 0xe6, 0xf6, 0xab, 0xb3, 0xf7,
  0x6d, 0x09, 0xe0, 0x2f, 0x31, 0x66, 0x2e, 0xd3, 0x9f, 0x2d, 0x52, 0xde,
  0xa0, 0x99, 0x20, 0xdb, 0x77, 0x6f, 0x98, 0x4d, 0xee, 0xa6, 0x97, 0x2f,
  0x21, 0x6e, 0xe5, 0x52, 0x8b, 0x51, 0xb7, 0xdb, 0x4c, 0xa7, 0x3a, 0x16,
  0x9a, 0xaf, 0x3a, 0x2b, 0xb2, 0x10, 0x76, 0x17, 0x9f, 0x4e, 0x49, 0x3e,
  0xdd, 0x3d, 0xdc, 0x00, 0x62, 0x94, 0x20, 0xe8, 0xb1, 0x5e, 0x7a, 0x04,
  0xee, 0xc0, 0xbf, 0xbc, 0x9e, 0xdd, 0x53, 0x2c, 0x87, 0xc1, 0x31, 0x94,
  0xbc, 0xea, 0x09, 0x54, 0x2b, 0xff, 0xf1, 0x9e, 0x8c, 0xa0, 0xd1, 0x50,
  0x07, 0xa4, 0x16, 0xf9, 0xc2, 0xe3, 0x7b, 0x8a, 0x1e, 0x4b, 0x18, 0xbe,
  0x83, 0x49, 0xa5, 0x11, 0x51
};
unsigned int __1025_oma_bin_len = 1025;
unsigned char __1025_oma_cbc[] = {
  0x66, 0x60, 0x54, 0xf2, 0x9e, 0xf8, 0x06, 0xff, 0x6c, 0x91, 0x0c, 0x14,
  0x4d, 0xc3, 0x45, 0x09, 0xca, 0xa4, 0x7f, 0x54, 0x58, 0x46, 0xbb, 0x6f,
  0x15, 0x05, 0x68, 0x2e, 0x90, 0xae, 0xed, 0xbc, 0x43, 0x63, 0x67, 0x40,
  0x77, 0x83, 0xed, 0x25, 0xf6, 0x2e, 0xae, 0x70, 0x31, 0x64, 0x09, 0xfc,
  0x7f, 0x3b, 0x8d, 0x44, 0x67, 0xde, 0x61, 0xea, 0x43, 0x18, 0xcf, 0x80,
  0xc9, 0x2c, 0x96, 0x3f, 0xea, 0x1e, 0x48, 0x5e, 0x4b, 0xaa, 0x14, 0xa3,
  0x6c, 0xa8, 0xe4, 0xc4, 0x6f, 0x92, 0xbc, 0xb8, 0x03, 0x07, 0x3e, 0xfb,
  0x03, 0xe3, 0x89, 0x58, 0x94, 0x75, 0x0a, 0x5b, 0xf0, 0xa0, 0xd2, 0x92,
  0xe4, 0x8f, 0x2d, 0xba, 0x93, 0xec, 0xce, 0x05, 0x2e, 0xcc, 0x7a, 0x79,
  0xed, 0x22, 0xb0, 0x7d, 0x75, 0x27, 0xdb, 0x40, 0x4d, 0x76, 0xb9, 0x6b,
  0x6a, 0x70, 0xa5, 0x86, 0x3f, 0xd5, 0xaa, 0x4a, 0x88, 0x84, 0x86, 0x5f,
  0x6b, 0x1f, 0xc6, 0xcc, 0xd7, 0x4e, 0x80, 0xd1, 0x41, 0xcd, 0x20, 0x73,
  0x68, 0x75, 0xed, 0xc6, 0x39, 0x23, 0xba, 0x5f, 0x84, 0xa5, 0xe8, 0x68,
  0xe6, 0x9b, 0xdf, 0xec, 0xb2, 0xe2, 0x4b, 0x62, 0x88, 0xc3, 0x37, 0x7f,
  0xfd, 0x65, 0xd1, 0x39, 0xbf, 0x1c, 0x43, 0xc8, 0x3c, 0x1c, 0x46, 0xd9,
  0x94, 0x82, 0x47, 0x50, 0xf7, 0x56, 0xd1, 0xf0, 0xec, 0x4f, 0xdf, 0x65,
  0x7e, 0x37, 0x16, 0x98, 0xc1, 0xe8, 0x47, 0x1e, 0x84, 0xcb, 0xfb, 0x8a,
  0xc1, 0x8b, 0x6b, 0x66, 0x4b, 0xe4, 0x45, 0x9a, 0xd6, 0x91, 0x78, 0x9c,
  0x39, 0x69, 0x45, 0x39, 0xec, 0x09, 0x64, 0x09, 0xe0, 0x11, 0xec, 0x47,
  0xea, 0xf2, 0x69, 0x80, 0x60, 0xd0, 0xa0, 0x83, 0x7e, 0x69, 0x08, 0xad,
  0x82, 0x51, 0xec, 0x69, 0x54, 0xcf, 0xca, 0xd6, 0x33, 0x69, 0x99, 0x04,
  0x5e, 0x11, 0x96, 0x05, 0xea, 0xa3, 0xf0, 0x27, 0x90, 0x77, 0x9e, 0xba,
  0x13, 0xf1, 0xe1, 0x78, 0xfa, 0xe5, 0x25, 0x3d, 0x44, 0x36, 0x5c, 0x81,
  0x4d, 0x87, 0x08, 0xb7, 0x02, 0x6a, 0x64, 0x99, 0x89, 0xc9, 0xcf, 0x32,
  0x81, 0x71, 0x16, 0xbf, 0x3c, 0x6b, 0x18, 0xa0, 0xca, 0xb3, 0xc5, 0xc8,
  0x59, 0xba, 0x32, 0xf6, 0xda, 0xd3, 0x98, 0xeb, 0x73, 0x5b, 0xf3, 0x66,
  0x7e, 0xa1, 0x1d, 0x3d, 0xf7, 0x30, 0xd2, 0xbc, 0xda, 0xe6, 0x7f, 0x5f,
  0x9f, 0x2e, 0x74, 0x95, 0x45, 0xcb, 0xc3, 0x5b, 0x7f, 0xfd, 0x2b, 0x78,
  0x33, 0x04, 0x09, 0x75, 0xde, 0x3b, 0x8e, 0x2e, 0x7d, 0x8c, 0x59, 0xfe,
  0x58, 0x52, 0xd3, 0x27, 0xad, 0x27, 0x75, 0x5a, 0xad, 0xf5, 0x37, 0x7c,
  0x07, 0x99, 0xaf, 0xfc, 0x61, 0xf3, 0xe8, 0x19, 0x2d, 0xdf, 0xad, 0x21,
  0x7d, 0x83, 0x04, 0xa7, 0x27, 0x2c, 0xe3, 0x2b, 0x6e, 0x83, 0x71, 0xcf,
  0x9a, 0xdd, 0xb0, 0x6a, 0xbc, 0xe9, 0xff, 0xbc, 0x53, 0x93, 0x03, 0xe4,
  0xdb, 0xc3, 0x7b, 0xd0, 0x08, 0x35, 0x9c, 0x3c, 0xdd, 0x07, 0x2c, 0x4a,
  0x5e, 0x86, 0x47, 0x4a, 0x77, 0x51, 0x18, 0x3b, 0x8b, 0x47, 0x01, 0xdf,
  0x31, 0x00, 0x1b, 0x0f, 0x73, 0x6c, 0x35, 0xe6, 0x1b, 0x24, 0x97, 0x62,
  0xe5, 0x7c, 0xa4, 0x68, 0x21, 0xe8, 0xca, 0x35, 0x1d, 0xa8, 0xe5, 0xb4,
  0x49, 0x7a, 0xe2, 0x73, 0xe2, 0x91, 0xfb, 0xbb, 0xd8, 0x5d, 0x01, 0x1d,
  0xe1, 0x2c, 0x59, 0x55, 0x2a, 0x48, 0x36, 0xa4, 0x39, 0x49, 0xb6, 0x28,
  0xd4, 0x16, 0xe0, 0xf7, 0x66, 0x42, 0x5a, 0x28, 0xc0, 0x56, 0xcb, 0x4b,
  0x79, 0xf4, 0x02, 0x42, 0x99, 0xbb, 0xc9, 0x9f, 0xc1, 0x88, 0x41, 0x7e,
  0xad, 0x2c, 0x91, 0x2f, 0xc4, 0xbe, 0x48, 0x8e, 0x3b, 0x48, 0x11, 0x0b,
  0xc1, 0x93, 0x98, 0x1f, 0xb3, 0x0a, 0xf5, 0xff, 0xc0, 0xe9, 0x5b, 0xbb,
  0xb4, 0x13, 0x34, 0x69, 0x15, 0x31, 0x39, 0xde, 0x00, 0x0a, 0x28, 0xc1,
  0xfc, 0x2a, 0xbe, 0xa1, 0x44, 0x17, 0x4b, 0x75, 0xcb, 0x94, 0x2a, 0x14,
  0xb3, 0x66, 0x3d, 0xfe, 0x19, 0xb3, 0xb7, 0x92, 0x2a, 0x1f, 0x13, 0x1b,
  0x7a, 0xc1, 0x46, 0x9c, 0x3d, 0xb2, 0xc4, 0xb4, 0x7d, 0x12, 0x15, 0xf1,
  0xa9, 0x7b, 0xb8, 0x81, 0x2e, 0x39, 0xe8, 0x9e, 0x18, 0xc7, 0xec, 0x9e,
  0xb3, 0x00, 0x52, 0xad, 0xcf, 0xba, 0xc6, 0x73, 0x06, 0x35, 0x8f, 0x77,
  0x70, 0x9d, 0xb9, 0xf6, 0xb9, 0x9b, 0x61, 0xb5, 0xf2, 0x7c, 0xf0, 0xf3,
  0x8d, 0xbd, 0xc3, 0xd4, 0x36, 0x7e, 0xd1, 0xb5, 0xc2, 0x55, 0xff, 0x8e,
  0xdb, 0x89, 0x46, 0x36, 0xf4, 0x04, 0x4a, 0x11, 0xb0, 0xa4, 0x96, 0x0b,
  0x3a, 0x7f, 0x4b, 0x82, 0x73, 0xd4, 0x5a, 0x70, 0x4c, 0x75, 0x61, 0x82,
  0xc0, 0x9d, 0x53, 0x62, 0xad, 0x2e, 0xd5, 0x70, 0xb3, 0x9d, 0xf3, 0x15,
  0x66, 0xa9, 0x46, 0x0b, 0xc5, 0x9f, 0xc6, 0x80, 0xbe, 0x0a, 0x7a, 0x28,
  0x35, 0x2f, 0x59, 0x53, 0x7d, 0xc0, 0xe1, 0x01, 0x56, 0xe9, 0x66, 0x62,
  0x21, 0xc5, 0x0d, 0x00, 0xa3, 0x07, 0x76, 0x97, 0x32, 0x6b, 0xaf, 0x80,
  0x40, 0xbc, 0xdc, 0xe0, 0x88, 0x6b, 0xe8, 0x5a, 0x3c, 0x19, 0xe5, 0x04,
  0x20, 0x41, 0x17, 0x8b, 0x50, 0xdd, 0x5a, 0x3c, 0xf4, 0x11, 0xf7, 0x95,
  0x1a, 0x4b, 0x79, 0x7c, 0x93, 0x5a, 0xa5, 0xde, 0x69, 0xa8, 0x5c, 0x70,
  0x9d, 0xf1, 0x57, 0xa2, 0xe7, 0xa9, 0x54, 0x77, 0xd0, 0x11, 0x2f, 0xf4,
  0x9e, 0xef, 0xc1, 0xc3, 0x03, 0x95, 0xda, 0x59, 0x2a, 0x1c, 0x6b, 0x97,
  0xde, 0xa9, 0xc9, 0x04, 0xbf, 0x2b, 0x20, 0x75, 0x9e, 0x8b, 0xc3, 0xa9,
  0xc1, 0x87, 0x89, 0x63, 0x89, 0x99, 0xc2, 0x90, 0xe6, 0xa6, 0xf5, 0x04,
  0xd3, 0x54, 0x5c, 0x79, 0xcf, 0xef, 0x7d, 0x44, 0xa2, 0x9f, 0x05, 0x8a,
  0xf1, 0x21, 0x86, 0x1c, 0xac, 0x23, 0x29, 0xfa, 0xc5, 0x8f, 0xe8, 0xcc,
  0xcc, 0xa4, 0x89, 0x66, 0xfa, 0x28, 0x5c, 0xd2, 0xc4, 0x97, 0x2a, 0x61,
  0x83, 0x84, 0xf0, 0x15, 0x87, 0x9f, 0x2c, 0x6c, 0xdb, 0x1e, 0x24, 0xc3,
  0x1c, 0xa8, 0xae, 0x8b, 0xfc, 0x1d, 0x10, 0x85, 0x77, 0xc1, 0xbe, 0xa6,
  0xc7, 0xd0, 0xf1, 0x7b, 0xff, 0x1b, 0x2d, 0x89, 0x4b, 0x38, 0xb9, 0x39,
  0x8e, 0xf1, 0x50, 0x7a, 0xd0, 0x8f, 0xb4, 0x94, 0x43, 0xb2, 0xba, 0xf7,
  0x7a, 0x13, 0x71, 0x85, 0x5c, 0xc1, 0xec, 0x2d, 0xb7, 0xfe, 0x7d, 0x83,
  0x55, 0xe0, 0x60, 0x48, 0x43, 0xb1, 0x36, 0x96, 0x5a, 0x77, 0xe8, 0x0e,
  0xfd, 0x9e, 0xc6, 0x76, 0xb7, 0xa2, 0x01, 0x90, 0x37, 0x0d, 0x86, 0x89,
  0x1f, 0x47, 0x51, 0xb5, 0xb4, 0x4e, 0xa6, 0x7e, 0x5d, 0xaa, 0x59, 0x6e,
  0x07, 0xa8, 0x3c, 0x48, 0x28, 0x26, 0x68, 0x83, 0xaf, 0x7e, 0x2a, 0xcb,
  0xf9, 0x20, 0xe6, 0x1e, 0xa3, 0xce, 0x5b, 0x22, 0x5b, 0x68, 0x45, 0xd9,
  0x67, 0x79, 0xb2, 0x39, 0x3b, 0xa8, 0x7a, 0xca, 0x7f, 0x27, 0x05, 0xc3,
  0x32, 0xb8, 0x56, 0x98, 0x92, 0xb2, 0xe6, 0x62, 0x8e, 0xc4, 0xeb, 0x54,
  0x41, 0x03, 0xc7, 0xd1, 0x6d, 0x81, 0x50, 0x97, 0x9f, 0x97, 0x9f, 0xd9,
  0xb4, 0x41, 0x31, 0xaf, 0xd2, 0x39, 0x33, 0x00, 0xd1, 0xf5, 0xb4, 0x21,
  0x54, 0xce, 0x3b, 0x98, 0x44, 0x1c, 0x31, 0xc4, 0x14, 0xfa, 0x76, 0x17,
  0x8c, 0x01, 0xb4, 0x80, 0x22, 0x93, 0x6e, 0x0b, 0x70, 0xdc, 0x2b, 0x5f,
  0x44, 0xf8, 0x50, 0x22, 0x2b, 0xda, 0x5b, 0xe9, 0x90, 0x9d, 0x66, 0x3a,
  0xd1, 0x12, 0xe7, 0x0a, 0x14, 0xaa, 0x5e, 0x6d, 0x8a, 0xb1, 0x44, 0x37,
  0x29, 0x27, 0xef, 0xce, 0x0d, 0x05, 0x2e, 0x40, 0x23, 0x20, 0x08, 0x7d,
  0x32, 0x7f, 0x07, 0x40, 0x96, 0x4f, 0x6b, 0xda
};
unsigned int __1025_oma_cbc_len = 1040;

static struct {
    AP4_UI08* clear;
    AP4_Size  clear_length;
    AP4_UI08* enc;
    AP4_Size  enc_length;
} TestVectors[] = 
{
    {__1_bin, __1_bin_len, __1_cbc, __1_cbc_len },
    {__2_bin, __2_bin_len, __2_cbc, __2_cbc_len },
    {__3_bin, __3_bin_len, __3_cbc, __3_cbc_len },
    {__4_bin, __4_bin_len, __4_cbc, __4_cbc_len },
    {__5_bin, __5_bin_len, __5_cbc, __5_cbc_len },
    {__6_bin, __6_bin_len, __6_cbc, __6_cbc_len },
    {__7_bin, __7_bin_len, __7_cbc, __7_cbc_len },
    {__8_bin, __8_bin_len, __8_cbc, __8_cbc_len },
    {__9_bin, __9_bin_len, __9_cbc, __9_cbc_len },
    {__10_bin, __10_bin_len, __10_cbc, __10_cbc_len },
    {__11_bin, __11_bin_len, __11_cbc, __11_cbc_len },
    {__12_bin, __12_bin_len, __12_cbc, __12_cbc_len },
    {__13_bin, __13_bin_len, __13_cbc, __13_cbc_len },
    {__14_bin, __14_bin_len, __14_cbc, __14_cbc_len },
    {__15_bin, __15_bin_len, __15_cbc, __15_cbc_len },
    {__16_bin, __16_bin_len, __16_cbc, __16_cbc_len },
    {__17_bin, __17_bin_len, __17_cbc, __17_cbc_len }
};

typedef struct {
    unsigned char* clear;
    unsigned int   clear_length;
    unsigned char* enc;
    unsigned int   enc_length;
} TestVector;

static TestVector
TestVectors2[] = 
{
    {__1023_bin, __1023_bin_len, __1023_cbc, __1023_cbc_len },
    {__1024_bin, __1024_bin_len, __1024_cbc, __1024_cbc_len },
    {__1025_bin, __1025_bin_len, __1025_cbc, __1025_cbc_len }
};

typedef struct {
    unsigned char* input;
    unsigned int   input_length;
    unsigned char* key;
    unsigned int   key_length;
    unsigned char* output;
} HmacVector;

static unsigned char __hmac_input_1[] = {'h', 'e', 'l', 'l', 'o'};
static unsigned int  __hmac_input_1_len = 5;
static unsigned char __hmac_key_1[] = {'b','l','a'};
static unsigned int  __hmac_key_1_len = 3;
static unsigned char __hmac_output_1[] = 
{
    0x5d, 0xd6, 0x34, 0xe2, 0xa6, 0x8a, 0x1c, 0xfe, 
    0x1e, 0x0a, 0x26, 0x1f, 0x6b, 0xe2, 0xa2, 0x54, 
    0x9a, 0x33, 0x88, 0xa0, 0x0d, 0x5e, 0x72, 0xcf, 
    0x7f, 0xc1, 0xb6, 0x2b, 0xcc, 0xca, 0x2a, 0x76
};

static HmacVector
HmacVectors[] = {
    {__hmac_input_1, __hmac_input_1_len, __hmac_key_1, __hmac_key_1_len, __hmac_output_1}
};

/*----------------------------------------------------------------------
|   BuffersEqual
+---------------------------------------------------------------------*/
static bool
BuffersEqual(const unsigned char* a, 
             const unsigned char* b,
             AP4_Size             size)
{
    for (unsigned int i=0; i<size; i++) {
        if (a[i]!=b[i]) {
            fprintf(stderr, "mismatch at %d of %d\n", i, (int)size);
            return false;
        }
    }
    return true;
}

/*----------------------------------------------------------------------
|   CHECK
+---------------------------------------------------------------------*/
#define CHECK(x) if (!(x)) { fprintf(stderr, "ERROR line %d\n", __LINE__); DebugHook(); return -1; }

/*----------------------------------------------------------------------
|   DebugHook
+---------------------------------------------------------------------*/
static void
DebugHook()
{
    // put a breakpoint here
    fprintf(stderr, "Debug Hook\n");
}

/*----------------------------------------------------------------------
|   TestHmac
+---------------------------------------------------------------------*/
static int
TestHmac()
{
    for (unsigned int i=0; i<sizeof(HmacVectors)/sizeof(HmacVectors[0]); i++) {
        AP4_Hmac* hmac = NULL;
    
        AP4_Result result = AP4_Hmac::Create(AP4_Hmac::SHA256, 
                                             HmacVectors[i].key, 
                                             HmacVectors[i].key_length, 
                                             hmac);
        CHECK(result == AP4_SUCCESS);
        AP4_DataBuffer mac;
        result = hmac->Update(HmacVectors[i].input, HmacVectors[i].input_length);
        CHECK(result == AP4_SUCCESS);
        result = hmac->Final(mac);
        CHECK(result == AP4_SUCCESS);
        CHECK(BuffersEqual(mac.GetData(), HmacVectors[i].output, mac.GetDataSize()));
        delete hmac;
    }
    
    return 0;
}

/*----------------------------------------------------------------------
|   TestKeyWrap
+---------------------------------------------------------------------*/
static int
TestKeyWrap()
{
    AP4_UI08 kek[]  = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 
                       0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F};
    AP4_UI08 data[] = {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 
                       0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF};
    AP4_UI08 out[]  = {0x1F, 0xA6, 0x8B, 0x0A, 0x81, 0x12, 0xB4, 0x47, 
                       0xAE, 0xF3, 0x4B, 0xD8, 0xFB, 0x5A, 0x7B, 0x82, 
                       0x9D, 0x3E, 0x86, 0x23, 0x71, 0xD2, 0xCF, 0xE5};
    
    AP4_DataBuffer wrapped;
    AP4_Result result = AP4_AesKeyWrap(kek, data, 16, wrapped);
    CHECK(result == AP4_SUCCESS);
    CHECK(wrapped.GetDataSize() == 24);
    CHECK(BuffersEqual(wrapped.GetData(), out, 24));
    
    AP4_DataBuffer unwrapped;
    result = AP4_AesKeyUnwrap(kek, wrapped.GetData(), wrapped.GetDataSize(), unwrapped);
    CHECK(result == AP4_SUCCESS);
    CHECK(unwrapped.GetDataSize() == 16);
    CHECK(BuffersEqual(data, unwrapped.GetData(), 16));
    
    return 0;
}

/*----------------------------------------------------------------------
|   TestCiphers
+---------------------------------------------------------------------*/
static int
TestCiphers()
{
    unsigned char key[] = {
      0xc4, 0x56, 0x09, 0xfb, 0xe6, 0xa5, 0xde, 0xfd, 0xb0, 0x23, 0x10, 0x06,
      0x08, 0xbf, 0x3e, 0xbd
    };
    unsigned char iv[] = {
      0xf1, 0xcb, 0xfa, 0x4f, 0x2d, 0x9e, 0xfa, 0x69, 0xa9, 0x78, 0x2b, 0xd5,
      0x90, 0x6e, 0x20, 0x7b
    };

    AP4_BlockCipher* e_block_cipher;
    AP4_DefaultBlockCipherFactory::Instance.Create(AP4_BlockCipher::AES_128, AP4_BlockCipher::ENCRYPT, key, 16, e_block_cipher);
    AP4_CbcStreamCipher e_cipher(e_block_cipher, AP4_CbcStreamCipher::ENCRYPT);

    AP4_BlockCipher* d_block_cipher;
    AP4_DefaultBlockCipherFactory::Instance.Create(AP4_BlockCipher::AES_128, AP4_BlockCipher::DECRYPT, key, 16, d_block_cipher);
    AP4_CbcStreamCipher d_cipher(d_block_cipher, AP4_CbcStreamCipher::DECRYPT);

    unsigned char buffer[128];
    AP4_Size      size;
    AP4_Result    result;

    for (unsigned int i=0; i<sizeof(TestVectors)/sizeof(TestVectors[0]); i++) {
        printf("Test Vector %d\n", i);

        e_cipher.SetIV(iv);
        d_cipher.SetIV(iv);

        size = 32;
        result = e_cipher.ProcessBuffer(TestVectors[i].clear, 
                                        TestVectors[i].clear_length, 
                                        buffer, &size, true);
        CHECK(result == AP4_SUCCESS);
        CHECK(size == TestVectors[i].enc_length);
        CHECK(BuffersEqual(TestVectors[i].enc, buffer, size));

        size = 32;
        result = d_cipher.ProcessBuffer(TestVectors[i].enc, 
                                        TestVectors[i].enc_length, 
                                        buffer, &size, true);
        CHECK(result == AP4_SUCCESS);
        CHECK(size == TestVectors[i].clear_length);
        CHECK(BuffersEqual(TestVectors[i].clear, buffer, size));
    }

    for (int run=0; run<1000; run++) {
        for (unsigned int i=0; i<sizeof(TestVectors2)/sizeof(TestVectors2[0]); i++) {
            printf("Encrypt Test Vector2 %d\n", i);

            e_cipher.SetIV(iv);

            unsigned int total = TestVectors2[i].clear_length;
            unsigned int todo = total;
            AP4_UI08 out_buffer[2048];
            AP4_UI08* out = out_buffer;
            unsigned int x = 0;
            bool last = false;
            while (todo || !last) {
                unsigned int chunk = rand()%37;
                if (chunk > todo) {
                    chunk = todo;
                    last = true;
                }
                size = sizeof(buffer);
                result = e_cipher.ProcessBuffer(TestVectors2[i].clear+x,
                                                chunk,
                                                out,
                                                &size,
                                                last);
                CHECK(result == AP4_SUCCESS);
                todo -= chunk;
                out += size;
                x += chunk;
            }
            CHECK((unsigned int )(out-out_buffer) == TestVectors2[i].enc_length);
            CHECK(BuffersEqual(TestVectors2[i].enc, out_buffer, TestVectors2[i].enc_length));
        }

        for (unsigned int i=0; i<sizeof(TestVectors2)/sizeof(TestVectors2[0]); i++) {
            printf("Decrypt Test Vector2 %d\n", i);

            d_cipher.SetIV(iv);

            unsigned int total = TestVectors2[i].enc_length;
            unsigned int todo = total;
            AP4_UI08 out_buffer[2048];
            AP4_UI08* out = out_buffer;
            unsigned int x = 0;
            bool last = false;
            while (todo || !last) {
                unsigned int chunk = rand()%37;
                if (chunk > todo) {
                    chunk = todo;
                    last = true;
                }
                size = sizeof(buffer);
                result = d_cipher.ProcessBuffer(TestVectors2[i].enc+x,
                                                chunk,
                                                out,
                                                &size,
                                                last);
                CHECK(result == AP4_SUCCESS);
                todo -= chunk;
                out += size;
                x += chunk;
            }
            CHECK((unsigned int)(out-out_buffer) == TestVectors2[i].clear_length);
            CHECK(BuffersEqual(TestVectors2[i].clear, out_buffer, TestVectors2[i].clear_length));
        }

        for (unsigned int i=0; i<sizeof(TestVectors2)/sizeof(TestVectors2[0]); i++) {
            AP4_UI08 out_buffer[128+16];
            AP4_Size out_size;
            
            printf("Decrypt Test Vector2 + Seek %d\n", i);

            d_cipher.SetIV(iv);
            AP4_Cardinal preroll = 0;
            CHECK(d_cipher.SetStreamOffset(0, &preroll) == AP4_SUCCESS);
            CHECK(preroll == 0);
            CHECK(d_cipher.SetStreamOffset(TestVectors2[i].enc_length+1, &preroll) == AP4_SUCCESS);
            CHECK(d_cipher.SetStreamOffset(TestVectors2[i].enc_length, &preroll) == AP4_SUCCESS);
            
            TestVector& vector = TestVectors2[i];
            for (unsigned int j=0; j<10000; j++) {
                unsigned int position = rand()%vector.clear_length;
                const AP4_UI08* in = vector.enc+position;
                result = d_cipher.SetStreamOffset(position, &preroll);
                CHECK(result == AP4_SUCCESS);
                CHECK(preroll <= position);
                unsigned int chunk = rand()%(sizeof(out_buffer)-16);
                if (position+chunk > vector.enc_length) {
                    chunk = vector.enc_length-position;
                }
                bool is_last = (position+chunk == vector.enc_length);
                out_size = sizeof(out_buffer);
                result = d_cipher.ProcessBuffer(in-preroll, chunk+preroll, out_buffer, &out_size, is_last);
                CHECK(result == AP4_SUCCESS);
                CHECK(BuffersEqual(vector.clear+position, out_buffer, out_size));
            }            
        }
        
        for (unsigned int i=0; i<sizeof(TestVectors2)/sizeof(TestVectors2[0]); i++) {
            printf("Encrypt Test Vector2 + Stream %d\n", i);

            AP4_Result result;
            TestVector& vector = TestVectors2[i];
            AP4_ByteStream* cleartext_stream = new AP4_MemoryByteStream(vector.clear, vector.clear_length);
            
            AP4_ByteStream* encrypting_stream = NULL;
            result = AP4_EncryptingStream::Create(AP4_EncryptingStream::CIPHER_MODE_CBC,
                                                  *cleartext_stream,
                                                  iv,
                                                  16,
                                                  key,
                                                  16,
                                                  false,
                                                  &AP4_DefaultBlockCipherFactory::Instance,
                                                  encrypting_stream);
            CHECK(result == AP4_SUCCESS);
            
            // read the whole stream by chunks
            AP4_UI08 out_buffer[128+16];
            AP4_Size out_size;
            AP4_Size total_read = 0;
            do {
                unsigned int chunk = rand()%128;
                result = encrypting_stream->ReadPartial(out_buffer, chunk, out_size);
                if (out_size) CHECK(BuffersEqual(vector.enc+total_read, out_buffer, out_size));
                total_read += out_size;
            } while (result == AP4_SUCCESS);
            CHECK(result == AP4_ERROR_EOS);
            CHECK(total_read == vector.enc_length);
            
            encrypting_stream->Release();
            cleartext_stream->Release();
        }

        for (unsigned int i=0; i<sizeof(TestVectors2)/sizeof(TestVectors2[0]); i++) {
            printf("Decrypt Test Vector2 + Stream %d\n", i);

            AP4_Result result;
            TestVector& vector = TestVectors2[i];
            AP4_ByteStream* encrypted_stream = new AP4_MemoryByteStream(vector.enc, vector.enc_length);
            
            AP4_ByteStream* decrypting_stream = NULL;
            result = AP4_DecryptingStream::Create(AP4_DecryptingStream::CIPHER_MODE_CBC,
                                                  *encrypted_stream,
                                                  vector.clear_length,
                                                  iv,
                                                  16,
                                                  key,
                                                  16,
                                                  &AP4_DefaultBlockCipherFactory::Instance,
                                                  decrypting_stream);
            CHECK(result == AP4_SUCCESS);
            
            // read the whole stream by chunks
            AP4_UI08 out_buffer[128+16];
            AP4_Size out_size;
            AP4_Size total_read = 0;
            do {
                unsigned int chunk = rand()%128;
                result = decrypting_stream->ReadPartial(out_buffer, chunk, out_size);
                if (out_size) CHECK(BuffersEqual(vector.clear+total_read, out_buffer, out_size));
                total_read += out_size;
            } while (result == AP4_SUCCESS);
            CHECK(result == AP4_ERROR_EOS);
            CHECK(total_read == vector.clear_length);
            
            for (unsigned int j=0; j<10000; j++) {
                unsigned int position = rand()%vector.clear_length;
                result = decrypting_stream->Seek(position);
                CHECK(result == AP4_SUCCESS);
                unsigned int chunk = rand()%(sizeof(out_buffer)-16);
                if (position+chunk > vector.enc_length) {
                    chunk = vector.enc_length-position;
                }
                result = decrypting_stream->ReadPartial(out_buffer, chunk, out_size);
                CHECK(result == AP4_SUCCESS);
                CHECK(BuffersEqual(vector.clear+position, out_buffer, out_size));
            }            

            decrypting_stream->Release();
            encrypted_stream->Release();
        }
    }

    return 0;
}

int
main(int /*argc*/, char** /*argv*/)
{
    int result;
    
    result = TestHmac();
    if (result) return result;

    result = TestKeyWrap();
    if (result) return result;
    
    result = TestCiphers();
    if (result) return result;
    
    return 0;
}

