#! /usr/bin/python

#############################################################
# This tool is used to generate the BlueTune version info file #
#############################################################
import sys
import os

# ensure that BLUETUNE_HOME has been set and exists
if not os.environ.has_key('BLUETUNE_HOME'):
    print 'ERROR: BLUETUNE_HOME not set'
    sys.exit(1)
BLUETUNE_HOME = os.environ['BLUETUNE_HOME']
    
# get the SVN repo version
version = os.popen('svnversion -n').readlines()[0]
print 'current VERSION =',version
if version.endswith('M'):
     version = version[0:-1]
    
try:
    version_int = int(version)+1 ## add one, because when we check it in, the rev will be incremented by one
except:
    print 'ERROR: you cannot run this on a modified working copy'
    sys.exit(1)
    

output = open(BLUETUNE_HOME+'/Source/BlueTune/BltSvnVersion.h', 'w+')
output.write('/* DO NOT EDIT. This file was automatically generated by GenSvnVersionHeader.py */\n')
output.write('#define BLT_SVN_VERSION '+str(version_int)+'\n')
output.write('#define BLT_SVN_VERSION_STRING "'+str(version_int)+'"\n')
output.close()
print 'upon check-in, version will be', str(version_int)
