/*****************************************************************
|
|    Copyright 2004-2006 Axiomatic Systems LLC
|
|    This file is part of Melo (Melo AAC Decoder).
|
|    Unless you have obtained Melo under a difference license,
|    this version of Melo is Melo|GPL.
|    Melo|GPL is free software; you can redistribute it and/or modify
|    it under the terms of the GNU General Public License as published by
|    the Free Software Foundation; either version 2, or (at your option)
|    any later version.
|
|    Melo|GPL is distributed in the hope that it will be useful,
|    but WITHOUT ANY WARRANTY; without even the implied warranty of
|    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|    GNU General Public License for more details.
|
|    You should have received a copy of the GNU General Public License
|    along with Melo|GPL; see the file COPYING.  If not, write to the
|    Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
|    02111-1307, USA.
|
 ****************************************************************/

/*----------------------------------------------------------------------
|       Includes
+---------------------------------------------------------------------*/
#include "MloConfig.h"
#include "MloDebug.h"
#include "MloFloat.h"
#include "MloIndivChnStream.h"
#include "MloInvQuant.h"
#include "MloTypes.h"
#include "MloUtils.h"

/*----------------------------------------------------------------------
|       Function prototypes
+---------------------------------------------------------------------*/
static void MLO_InvQuant_DoInverseQuantisation (MLO_Float coef_arr [], const MLO_Int16 data_arr [], long len);
static inline MLO_Float MLO_InvQuant_ComputePow43 (int quant);

/*----------------------------------------------------------------------
|       Data
+---------------------------------------------------------------------*/
#if defined(MLO_CONFIG_FULL_POW_4_3_TABLE)
/* use a complete table */
static const MLO_Float MLO_InvQuant_table_pow43 [8192] =
{
    MLO_FLOAT_C(0.0),
    MLO_FLOAT_C(1.0),
    MLO_FLOAT_C(2.51984209979),
    MLO_FLOAT_C(4.32674871092),
    MLO_FLOAT_C(6.34960420787),
    MLO_FLOAT_C(8.54987973338),
    MLO_FLOAT_C(10.902723557),
    MLO_FLOAT_C(13.3905182794),
    MLO_FLOAT_C(16.0),
    MLO_FLOAT_C(18.7207544075),
    MLO_FLOAT_C(21.5443469003),
    MLO_FLOAT_C(24.4637809963),
    MLO_FLOAT_C(27.4731418213),
    MLO_FLOAT_C(30.5673509404),
    MLO_FLOAT_C(33.7419916985),
    MLO_FLOAT_C(36.993181115),
    MLO_FLOAT_C(40.3174735966),
    MLO_FLOAT_C(43.7117870412),
    MLO_FLOAT_C(47.1733450958),
    MLO_FLOAT_C(50.6996313257),
    MLO_FLOAT_C(54.2883523319),
    MLO_FLOAT_C(57.937407704),
    MLO_FLOAT_C(61.6448652744),
    MLO_FLOAT_C(65.4089405366),
    MLO_FLOAT_C(69.2279793748),
    MLO_FLOAT_C(73.1004434553),
    MLO_FLOAT_C(77.0248977786),
    MLO_FLOAT_C(81.0),
    MLO_FLOAT_C(85.0244912125),
    MLO_FLOAT_C(89.0971879449),
    MLO_FLOAT_C(93.2169751786),
    MLO_FLOAT_C(97.3828002241),
    MLO_FLOAT_C(101.593667326),
    MLO_FLOAT_C(105.84863289),
    MLO_FLOAT_C(110.146801243),
    MLO_FLOAT_C(114.487320857),
    MLO_FLOAT_C(118.86938096),
    MLO_FLOAT_C(123.292208511),
    MLO_FLOAT_C(127.755065458),
    MLO_FLOAT_C(132.257246278),
    MLO_FLOAT_C(136.798075734),
    MLO_FLOAT_C(141.376906856),
    MLO_FLOAT_C(145.993119085),
    MLO_FLOAT_C(150.646116597),
    MLO_FLOAT_C(155.335326754),
    MLO_FLOAT_C(160.060198702),
    MLO_FLOAT_C(164.820202067),
    MLO_FLOAT_C(169.614825767),
    MLO_FLOAT_C(174.443576912),
    MLO_FLOAT_C(179.305979791),
    MLO_FLOAT_C(184.201574932),
    MLO_FLOAT_C(189.129918233),
    MLO_FLOAT_C(194.090580154),
    MLO_FLOAT_C(199.083144974),
    MLO_FLOAT_C(204.107210083),
    MLO_FLOAT_C(209.162385342),
    MLO_FLOAT_C(214.248292471),
    MLO_FLOAT_C(219.364564483),
    MLO_FLOAT_C(224.510845156),
    MLO_FLOAT_C(229.686788537),
    MLO_FLOAT_C(234.89205847),
    MLO_FLOAT_C(240.126328169),
    MLO_FLOAT_C(245.3892798),
    MLO_FLOAT_C(250.680604097),
    MLO_FLOAT_C(256.0),
    MLO_FLOAT_C(261.347174308),
    MLO_FLOAT_C(266.721841361),
    MLO_FLOAT_C(272.12372273),
    MLO_FLOAT_C(277.55254693),
    MLO_FLOAT_C(283.008049149),
    MLO_FLOAT_C(288.489970987),
    MLO_FLOAT_C(293.998060209),
    MLO_FLOAT_C(299.532070519),
    MLO_FLOAT_C(305.091761336),
    MLO_FLOAT_C(310.676897582),
    MLO_FLOAT_C(316.287249488),
    MLO_FLOAT_C(321.922592403),
    MLO_FLOAT_C(327.582706614),
    MLO_FLOAT_C(333.267377172),
    MLO_FLOAT_C(338.976393735),
    MLO_FLOAT_C(344.709550405),
    MLO_FLOAT_C(350.466645585),
    MLO_FLOAT_C(356.247481833),
    MLO_FLOAT_C(362.051865731),
    MLO_FLOAT_C(367.879607751),
    MLO_FLOAT_C(373.730522133),
    MLO_FLOAT_C(379.60442677),
    MLO_FLOAT_C(385.501143087),
    MLO_FLOAT_C(391.42049594),
    MLO_FLOAT_C(397.362313507),
    MLO_FLOAT_C(403.32642719),
    MLO_FLOAT_C(409.31267152),
    MLO_FLOAT_C(415.320884064),
    MLO_FLOAT_C(421.350905336),
    MLO_FLOAT_C(427.402578715),
    MLO_FLOAT_C(433.475750362),
    MLO_FLOAT_C(439.57026914),
    MLO_FLOAT_C(445.685986544),
    MLO_FLOAT_C(451.822756622),
    MLO_FLOAT_C(457.980435909),
    MLO_FLOAT_C(464.158883361),
    MLO_FLOAT_C(470.357960288),
    MLO_FLOAT_C(476.577530292),
    MLO_FLOAT_C(482.817459208),
    MLO_FLOAT_C(489.077615046),
    MLO_FLOAT_C(495.357867933),
    MLO_FLOAT_C(501.658090063),
    MLO_FLOAT_C(507.978155642),
    MLO_FLOAT_C(514.317940838),
    MLO_FLOAT_C(520.677323733),
    MLO_FLOAT_C(527.056184277),
    MLO_FLOAT_C(533.454404241),
    MLO_FLOAT_C(539.871867175),
    MLO_FLOAT_C(546.308458364),
    MLO_FLOAT_C(552.764064786),
    MLO_FLOAT_C(559.238575076),
    MLO_FLOAT_C(565.731879485),
    MLO_FLOAT_C(572.243869842),
    MLO_FLOAT_C(578.77443952),
    MLO_FLOAT_C(585.323483401),
    MLO_FLOAT_C(591.890897839),
    MLO_FLOAT_C(598.476580633),
    MLO_FLOAT_C(605.080430989),
    MLO_FLOAT_C(611.702349492),
    MLO_FLOAT_C(618.342238078),
    MLO_FLOAT_C(625.0),
    MLO_FLOAT_C(631.675539806),
    MLO_FLOAT_C(638.368763305),
    MLO_FLOAT_C(645.079577546),
    MLO_FLOAT_C(651.80789079),
    MLO_FLOAT_C(658.553612483),
    MLO_FLOAT_C(665.316653235),
    MLO_FLOAT_C(672.096924795),
    MLO_FLOAT_C(678.894340026),
    MLO_FLOAT_C(685.708812886),
    MLO_FLOAT_C(692.540258404),
    MLO_FLOAT_C(699.388592659),
    MLO_FLOAT_C(706.25373276),
    MLO_FLOAT_C(713.135596826),
    MLO_FLOAT_C(720.034103966),
    MLO_FLOAT_C(726.949174259),
    MLO_FLOAT_C(733.880728739),
    MLO_FLOAT_C(740.828689371),
    MLO_FLOAT_C(747.792979041),
    MLO_FLOAT_C(754.773521532),
    MLO_FLOAT_C(761.770241511),
    MLO_FLOAT_C(768.783064513),
    MLO_FLOAT_C(775.811916922),
    MLO_FLOAT_C(782.856725959),
    MLO_FLOAT_C(789.917419665),
    MLO_FLOAT_C(796.993926887),
    MLO_FLOAT_C(804.086177264),
    MLO_FLOAT_C(811.194101211),
    MLO_FLOAT_C(818.31762991),
    MLO_FLOAT_C(825.456695289),
    MLO_FLOAT_C(832.611230016),
    MLO_FLOAT_C(839.781167486),
    MLO_FLOAT_C(846.966441801),
    MLO_FLOAT_C(854.166987769),
    MLO_FLOAT_C(861.382740881),
    MLO_FLOAT_C(868.61363731),
    MLO_FLOAT_C(875.859613892),
    MLO_FLOAT_C(883.120608116),
    MLO_FLOAT_C(890.396558119),
    MLO_FLOAT_C(897.687402667),
    MLO_FLOAT_C(904.993081151),
    MLO_FLOAT_C(912.313533576),
    MLO_FLOAT_C(919.648700547),
    MLO_FLOAT_C(926.998523264),
    MLO_FLOAT_C(934.362943512),
    MLO_FLOAT_C(941.741903648),
    MLO_FLOAT_C(949.135346598),
    MLO_FLOAT_C(956.543215842),
    MLO_FLOAT_C(963.965455409),
    MLO_FLOAT_C(971.402009869),
    MLO_FLOAT_C(978.852824321),
    MLO_FLOAT_C(986.317844391),
    MLO_FLOAT_C(993.797016216),
    MLO_FLOAT_C(1001.29028644),
    MLO_FLOAT_C(1008.79760222),
    MLO_FLOAT_C(1016.31891119),
    MLO_FLOAT_C(1023.85416147),
    MLO_FLOAT_C(1031.40330167),
    MLO_FLOAT_C(1038.96628086),
    MLO_FLOAT_C(1046.54304859),
    MLO_FLOAT_C(1054.13355483),
    MLO_FLOAT_C(1061.73775005),
    MLO_FLOAT_C(1069.35558513),
    MLO_FLOAT_C(1076.9870114),
    MLO_FLOAT_C(1084.63198063),
    MLO_FLOAT_C(1092.290445),
    MLO_FLOAT_C(1099.96235711),
    MLO_FLOAT_C(1107.64767),
    MLO_FLOAT_C(1115.34633707),
    MLO_FLOAT_C(1123.05831218),
    MLO_FLOAT_C(1130.78354954),
    MLO_FLOAT_C(1138.52200378),
    MLO_FLOAT_C(1146.2736299),
    MLO_FLOAT_C(1154.03838328),
    MLO_FLOAT_C(1161.8162197),
    MLO_FLOAT_C(1169.60709529),
    MLO_FLOAT_C(1177.41096653),
    MLO_FLOAT_C(1185.22779031),
    MLO_FLOAT_C(1193.05752382),
    MLO_FLOAT_C(1200.90012464),
    MLO_FLOAT_C(1208.75555069),
    MLO_FLOAT_C(1216.62376023),
    MLO_FLOAT_C(1224.50471184),
    MLO_FLOAT_C(1232.39836446),
    MLO_FLOAT_C(1240.30467734),
    MLO_FLOAT_C(1248.22361008),
    MLO_FLOAT_C(1256.15512257),
    MLO_FLOAT_C(1264.09917504),
    MLO_FLOAT_C(1272.05572802),
    MLO_FLOAT_C(1280.02474236),
    MLO_FLOAT_C(1288.0061792),
    MLO_FLOAT_C(1296.0),
    MLO_FLOAT_C(1304.0061665),
    MLO_FLOAT_C(1312.02464075),
    MLO_FLOAT_C(1320.05538507),
    MLO_FLOAT_C(1328.0983621),
    MLO_FLOAT_C(1336.15353472),
    MLO_FLOAT_C(1344.22086613),
    MLO_FLOAT_C(1352.30031978),
    MLO_FLOAT_C(1360.3918594),
    MLO_FLOAT_C(1368.495449),
    MLO_FLOAT_C(1376.61105286),
    MLO_FLOAT_C(1384.73863549),
    MLO_FLOAT_C(1392.8781617),
    MLO_FLOAT_C(1401.02959653),
    MLO_FLOAT_C(1409.1929053),
    MLO_FLOAT_C(1417.36805356),
    MLO_FLOAT_C(1425.55500712),
    MLO_FLOAT_C(1433.75373202),
    MLO_FLOAT_C(1441.96419457),
    MLO_FLOAT_C(1450.1863613),
    MLO_FLOAT_C(1458.42019898),
    MLO_FLOAT_C(1466.66567463),
    MLO_FLOAT_C(1474.92275547),
    MLO_FLOAT_C(1483.19140898),
    MLO_FLOAT_C(1491.47160286),
    MLO_FLOAT_C(1499.76330502),
    MLO_FLOAT_C(1508.06648362),
    MLO_FLOAT_C(1516.381107),
    MLO_FLOAT_C(1524.70714376),
    MLO_FLOAT_C(1533.04456269),
    MLO_FLOAT_C(1541.39333279),
    MLO_FLOAT_C(1549.75342328),
    MLO_FLOAT_C(1558.12480359),
    MLO_FLOAT_C(1566.50744334),
    MLO_FLOAT_C(1574.90131237),
    MLO_FLOAT_C(1583.30638071),
    MLO_FLOAT_C(1591.72261861),
    MLO_FLOAT_C(1600.14999648),
    MLO_FLOAT_C(1608.58848497),
    MLO_FLOAT_C(1617.03805487),
    MLO_FLOAT_C(1625.49867722),
    MLO_FLOAT_C(1633.97032319),
    MLO_FLOAT_C(1642.45296419),
    MLO_FLOAT_C(1650.94657177),
    MLO_FLOAT_C(1659.4511177),
    MLO_FLOAT_C(1667.96657391),
    MLO_FLOAT_C(1676.49291251),
    MLO_FLOAT_C(1685.0301058),
    MLO_FLOAT_C(1693.57812624),
    MLO_FLOAT_C(1702.13694647),
    MLO_FLOAT_C(1710.70653931),
    MLO_FLOAT_C(1719.28687774),
    MLO_FLOAT_C(1727.87793491),
    MLO_FLOAT_C(1736.47968414),
    MLO_FLOAT_C(1745.09209893),
    MLO_FLOAT_C(1753.71515291),
    MLO_FLOAT_C(1762.34881989),
    MLO_FLOAT_C(1770.99307386),
    MLO_FLOAT_C(1779.64788894),
    MLO_FLOAT_C(1788.31323942),
    MLO_FLOAT_C(1796.98909974),
    MLO_FLOAT_C(1805.6754445),
    MLO_FLOAT_C(1814.37224846),
    MLO_FLOAT_C(1823.07948651),
    MLO_FLOAT_C(1831.79713371),
    MLO_FLOAT_C(1840.52516525),
    MLO_FLOAT_C(1849.2635565),
    MLO_FLOAT_C(1858.01228294),
    MLO_FLOAT_C(1866.77132021),
    MLO_FLOAT_C(1875.54064409),
    MLO_FLOAT_C(1884.32023051),
    MLO_FLOAT_C(1893.11005554),
    MLO_FLOAT_C(1901.91009536),
    MLO_FLOAT_C(1910.72032633),
    MLO_FLOAT_C(1919.54072493),
    MLO_FLOAT_C(1928.37126776),
    MLO_FLOAT_C(1937.21193157),
    MLO_FLOAT_C(1946.06269324),
    MLO_FLOAT_C(1954.92352978),
    MLO_FLOAT_C(1963.79441833),
    MLO_FLOAT_C(1972.67533617),
    MLO_FLOAT_C(1981.5662607),
    MLO_FLOAT_C(1990.46716943),
    MLO_FLOAT_C(1999.37804002),
    MLO_FLOAT_C(2008.29885025),
    MLO_FLOAT_C(2017.22957801),
    MLO_FLOAT_C(2026.17020133),
    MLO_FLOAT_C(2035.12069835),
    MLO_FLOAT_C(2044.08104733),
    MLO_FLOAT_C(2053.05122667),
    MLO_FLOAT_C(2062.03121485),
    MLO_FLOAT_C(2071.02099049),
    MLO_FLOAT_C(2080.02053234),
    MLO_FLOAT_C(2089.02981924),
    MLO_FLOAT_C(2098.04883015),
    MLO_FLOAT_C(2107.07754416),
    MLO_FLOAT_C(2116.11594044),
    MLO_FLOAT_C(2125.1639983),
    MLO_FLOAT_C(2134.22169716),
    MLO_FLOAT_C(2143.28901653),
    MLO_FLOAT_C(2152.36593603),
    MLO_FLOAT_C(2161.45243541),
    MLO_FLOAT_C(2170.54849451),
    MLO_FLOAT_C(2179.65409327),
    MLO_FLOAT_C(2188.76921175),
    MLO_FLOAT_C(2197.8938301),
    MLO_FLOAT_C(2207.02792859),
    MLO_FLOAT_C(2216.17148758),
    MLO_FLOAT_C(2225.32448752),
    MLO_FLOAT_C(2234.486909),
    MLO_FLOAT_C(2243.65873266),
    MLO_FLOAT_C(2252.83993927),
    MLO_FLOAT_C(2262.03050969),
    MLO_FLOAT_C(2271.23042488),
    MLO_FLOAT_C(2280.4396659),
    MLO_FLOAT_C(2289.6582139),
    MLO_FLOAT_C(2298.88605011),
    MLO_FLOAT_C(2308.12315589),
    MLO_FLOAT_C(2317.36951265),
    MLO_FLOAT_C(2326.62510194),
    MLO_FLOAT_C(2335.88990536),
    MLO_FLOAT_C(2345.16390463),
    MLO_FLOAT_C(2354.44708154),
    MLO_FLOAT_C(2363.73941799),
    MLO_FLOAT_C(2373.04089595),
    MLO_FLOAT_C(2382.35149749),
    MLO_FLOAT_C(2391.67120476),
    MLO_FLOAT_C(2401.0),
    MLO_FLOAT_C(2410.33786555),
    MLO_FLOAT_C(2419.68478381),
    MLO_FLOAT_C(2429.04073728),
    MLO_FLOAT_C(2438.40570855),
    MLO_FLOAT_C(2447.77968029),
    MLO_FLOAT_C(2457.16263523),
    MLO_FLOAT_C(2466.55455622),
    MLO_FLOAT_C(2475.95542617),
    MLO_FLOAT_C(2485.36522807),
    MLO_FLOAT_C(2494.783945),
    MLO_FLOAT_C(2504.21156011),
    MLO_FLOAT_C(2513.64805664),
    MLO_FLOAT_C(2523.09341789),
    MLO_FLOAT_C(2532.54762728),
    MLO_FLOAT_C(2542.01066825),
    MLO_FLOAT_C(2551.48252436),
    MLO_FLOAT_C(2560.96317923),
    MLO_FLOAT_C(2570.45261656),
    MLO_FLOAT_C(2579.95082013),
    MLO_FLOAT_C(2589.45777377),
    MLO_FLOAT_C(2598.97346142),
    MLO_FLOAT_C(2608.49786707),
    MLO_FLOAT_C(2618.03097478),
    MLO_FLOAT_C(2627.57276871),
    MLO_FLOAT_C(2637.12323307),
    MLO_FLOAT_C(2646.68235213),
    MLO_FLOAT_C(2656.25011027),
    MLO_FLOAT_C(2665.82649189),
    MLO_FLOAT_C(2675.41148151),
    MLO_FLOAT_C(2685.00506369),
    MLO_FLOAT_C(2694.60722306),
    MLO_FLOAT_C(2704.21794433),
    MLO_FLOAT_C(2713.83721226),
    MLO_FLOAT_C(2723.46501171),
    MLO_FLOAT_C(2733.10132757),
    MLO_FLOAT_C(2742.74614483),
    MLO_FLOAT_C(2752.39944851),
    MLO_FLOAT_C(2762.06122372),
    MLO_FLOAT_C(2771.73145564),
    MLO_FLOAT_C(2781.4101295),
    MLO_FLOAT_C(2791.09723059),
    MLO_FLOAT_C(2800.79274428),
    MLO_FLOAT_C(2810.49665601),
    MLO_FLOAT_C(2820.20895124),
    MLO_FLOAT_C(2829.92961555),
    MLO_FLOAT_C(2839.65863454),
    MLO_FLOAT_C(2849.39599388),
    MLO_FLOAT_C(2859.14167933),
    MLO_FLOAT_C(2868.89567666),
    MLO_FLOAT_C(2878.65797174),
    MLO_FLOAT_C(2888.42855049),
    MLO_FLOAT_C(2898.20739889),
    MLO_FLOAT_C(2907.99450297),
    MLO_FLOAT_C(2917.78984883),
    MLO_FLOAT_C(2927.59342262),
    MLO_FLOAT_C(2937.40521056),
    MLO_FLOAT_C(2947.22519891),
    MLO_FLOAT_C(2957.05337401),
    MLO_FLOAT_C(2966.88972222),
    MLO_FLOAT_C(2976.73423001),
    MLO_FLOAT_C(2986.58688385),
    MLO_FLOAT_C(2996.44767031),
    MLO_FLOAT_C(3006.31657599),
    MLO_FLOAT_C(3016.19358756),
    MLO_FLOAT_C(3026.07869172),
    MLO_FLOAT_C(3035.97187526),
    MLO_FLOAT_C(3045.87312499),
    MLO_FLOAT_C(3055.7824278),
    MLO_FLOAT_C(3065.69977062),
    MLO_FLOAT_C(3075.62514044),
    MLO_FLOAT_C(3085.55852428),
    MLO_FLOAT_C(3095.49990925),
    MLO_FLOAT_C(3105.44928247),
    MLO_FLOAT_C(3115.40663115),
    MLO_FLOAT_C(3125.37194254),
    MLO_FLOAT_C(3135.34520391),
    MLO_FLOAT_C(3145.32640263),
    MLO_FLOAT_C(3155.31552609),
    MLO_FLOAT_C(3165.31256172),
    MLO_FLOAT_C(3175.31749704),
    MLO_FLOAT_C(3185.33031958),
    MLO_FLOAT_C(3195.35101694),
    MLO_FLOAT_C(3205.37957675),
    MLO_FLOAT_C(3215.41598672),
    MLO_FLOAT_C(3225.46023457),
    MLO_FLOAT_C(3235.5123081),
    MLO_FLOAT_C(3245.57219514),
    MLO_FLOAT_C(3255.63988358),
    MLO_FLOAT_C(3265.71536133),
    MLO_FLOAT_C(3275.79861637),
    MLO_FLOAT_C(3285.88963673),
    MLO_FLOAT_C(3295.98841048),
    MLO_FLOAT_C(3306.09492572),
    MLO_FLOAT_C(3316.20917061),
    MLO_FLOAT_C(3326.33113336),
    MLO_FLOAT_C(3336.46080222),
    MLO_FLOAT_C(3346.59816547),
    MLO_FLOAT_C(3356.74321146),
    MLO_FLOAT_C(3366.89592857),
    MLO_FLOAT_C(3377.05630522),
    MLO_FLOAT_C(3387.22432988),
    MLO_FLOAT_C(3397.39999106),
    MLO_FLOAT_C(3407.58327733),
    MLO_FLOAT_C(3417.77417727),
    MLO_FLOAT_C(3427.97267953),
    MLO_FLOAT_C(3438.17877279),
    MLO_FLOAT_C(3448.39244577),
    MLO_FLOAT_C(3458.61368725),
    MLO_FLOAT_C(3468.84248602),
    MLO_FLOAT_C(3479.07883095),
    MLO_FLOAT_C(3489.32271091),
    MLO_FLOAT_C(3499.57411485),
    MLO_FLOAT_C(3509.83303172),
    MLO_FLOAT_C(3520.09945056),
    MLO_FLOAT_C(3530.3733604),
    MLO_FLOAT_C(3540.65475034),
    MLO_FLOAT_C(3550.94360951),
    MLO_FLOAT_C(3561.23992708),
    MLO_FLOAT_C(3571.54369226),
    MLO_FLOAT_C(3581.85489431),
    MLO_FLOAT_C(3592.1735225),
    MLO_FLOAT_C(3602.49956617),
    MLO_FLOAT_C(3612.83301468),
    MLO_FLOAT_C(3623.17385744),
    MLO_FLOAT_C(3633.52208388),
    MLO_FLOAT_C(3643.87768347),
    MLO_FLOAT_C(3654.24064575),
    MLO_FLOAT_C(3664.61096026),
    MLO_FLOAT_C(3674.98861658),
    MLO_FLOAT_C(3685.37360436),
    MLO_FLOAT_C(3695.76591324),
    MLO_FLOAT_C(3706.16553293),
    MLO_FLOAT_C(3716.57245317),
    MLO_FLOAT_C(3726.98666372),
    MLO_FLOAT_C(3737.40815439),
    MLO_FLOAT_C(3747.83691504),
    MLO_FLOAT_C(3758.27293552),
    MLO_FLOAT_C(3768.71620577),
    MLO_FLOAT_C(3779.16671572),
    MLO_FLOAT_C(3789.62445536),
    MLO_FLOAT_C(3800.0894147),
    MLO_FLOAT_C(3810.56158381),
    MLO_FLOAT_C(3821.04095276),
    MLO_FLOAT_C(3831.52751167),
    MLO_FLOAT_C(3842.02125071),
    MLO_FLOAT_C(3852.52216005),
    MLO_FLOAT_C(3863.03022992),
    MLO_FLOAT_C(3873.54545058),
    MLO_FLOAT_C(3884.0678123),
    MLO_FLOAT_C(3894.59730542),
    MLO_FLOAT_C(3905.13392028),
    MLO_FLOAT_C(3915.67764727),
    MLO_FLOAT_C(3926.2284768),
    MLO_FLOAT_C(3936.78639934),
    MLO_FLOAT_C(3947.35140536),
    MLO_FLOAT_C(3957.92348537),
    MLO_FLOAT_C(3968.50262992),
    MLO_FLOAT_C(3979.08882959),
    MLO_FLOAT_C(3989.68207499),
    MLO_FLOAT_C(4000.28235676),
    MLO_FLOAT_C(4010.88966556),
    MLO_FLOAT_C(4021.5039921),
    MLO_FLOAT_C(4032.12532712),
    MLO_FLOAT_C(4042.75366137),
    MLO_FLOAT_C(4053.38898565),
    MLO_FLOAT_C(4064.03129079),
    MLO_FLOAT_C(4074.68056763),
    MLO_FLOAT_C(4085.33680706),
    MLO_FLOAT_C(4096.0),
    MLO_FLOAT_C(4106.67013738),
    MLO_FLOAT_C(4117.34721019),
    MLO_FLOAT_C(4128.03120941),
    MLO_FLOAT_C(4138.72212608),
    MLO_FLOAT_C(4149.41995127),
    MLO_FLOAT_C(4160.12467606),
    MLO_FLOAT_C(4170.83629156),
    MLO_FLOAT_C(4181.55478893),
    MLO_FLOAT_C(4192.28015934),
    MLO_FLOAT_C(4203.01239399),
    MLO_FLOAT_C(4213.7514841),
    MLO_FLOAT_C(4224.49742095),
    MLO_FLOAT_C(4235.25019581),
    MLO_FLOAT_C(4246.00980001),
    MLO_FLOAT_C(4256.77622487),
    MLO_FLOAT_C(4267.54946178),
    MLO_FLOAT_C(4278.32950212),
    MLO_FLOAT_C(4289.11633732),
    MLO_FLOAT_C(4299.90995883),
    MLO_FLOAT_C(4310.71035813),
    MLO_FLOAT_C(4321.51752672),
    MLO_FLOAT_C(4332.33145613),
    MLO_FLOAT_C(4343.15213793),
    MLO_FLOAT_C(4353.97956368),
    MLO_FLOAT_C(4364.813725),
    MLO_FLOAT_C(4375.65461353),
    MLO_FLOAT_C(4386.50222093),
    MLO_FLOAT_C(4397.35653888),
    MLO_FLOAT_C(4408.2175591),
    MLO_FLOAT_C(4419.08527333),
    MLO_FLOAT_C(4429.95967333),
    MLO_FLOAT_C(4440.84075089),
    MLO_FLOAT_C(4451.72849782),
    MLO_FLOAT_C(4462.62290596),
    MLO_FLOAT_C(4473.52396718),
    MLO_FLOAT_C(4484.43167336),
    MLO_FLOAT_C(4495.34601642),
    MLO_FLOAT_C(4506.2669883),
    MLO_FLOAT_C(4517.19458096),
    MLO_FLOAT_C(4528.12878639),
    MLO_FLOAT_C(4539.0695966),
    MLO_FLOAT_C(4550.01700362),
    MLO_FLOAT_C(4560.97099951),
    MLO_FLOAT_C(4571.93157635),
    MLO_FLOAT_C(4582.89872626),
    MLO_FLOAT_C(4593.87244136),
    MLO_FLOAT_C(4604.85271381),
    MLO_FLOAT_C(4615.83953579),
    MLO_FLOAT_C(4626.83289948),
    MLO_FLOAT_C(4637.83279713),
    MLO_FLOAT_C(4648.83922097),
    MLO_FLOAT_C(4659.85216328),
    MLO_FLOAT_C(4670.87161634),
    MLO_FLOAT_C(4681.89757248),
    MLO_FLOAT_C(4692.93002402),
    MLO_FLOAT_C(4703.96896334),
    MLO_FLOAT_C(4715.01438282),
    MLO_FLOAT_C(4726.06627485),
    MLO_FLOAT_C(4737.12463188),
    MLO_FLOAT_C(4748.18944634),
    MLO_FLOAT_C(4759.26071071),
    MLO_FLOAT_C(4770.33841748),
    MLO_FLOAT_C(4781.42255917),
    MLO_FLOAT_C(4792.51312831),
    MLO_FLOAT_C(4803.61011747),
    MLO_FLOAT_C(4814.71351922),
    MLO_FLOAT_C(4825.82332617),
    MLO_FLOAT_C(4836.93953093),
    MLO_FLOAT_C(4848.06212616),
    MLO_FLOAT_C(4859.19110452),
    MLO_FLOAT_C(4870.32645868),
    MLO_FLOAT_C(4881.46818137),
    MLO_FLOAT_C(4892.61626531),
    MLO_FLOAT_C(4903.77070325),
    MLO_FLOAT_C(4914.93148795),
    MLO_FLOAT_C(4926.09861221),
    MLO_FLOAT_C(4937.27206883),
    MLO_FLOAT_C(4948.45185065),
    MLO_FLOAT_C(4959.63795052),
    MLO_FLOAT_C(4970.83036131),
    MLO_FLOAT_C(4982.02907591),
    MLO_FLOAT_C(4993.23408723),
    MLO_FLOAT_C(5004.4453882),
    MLO_FLOAT_C(5015.66297178),
    MLO_FLOAT_C(5026.88683092),
    MLO_FLOAT_C(5038.11695864),
    MLO_FLOAT_C(5049.35334792),
    MLO_FLOAT_C(5060.59599181),
    MLO_FLOAT_C(5071.84488335),
    MLO_FLOAT_C(5083.10001561),
    MLO_FLOAT_C(5094.36138167),
    MLO_FLOAT_C(5105.62897465),
    MLO_FLOAT_C(5116.90278766),
    MLO_FLOAT_C(5128.18281385),
    MLO_FLOAT_C(5139.46904639),
    MLO_FLOAT_C(5150.76147845),
    MLO_FLOAT_C(5162.06010324),
    MLO_FLOAT_C(5173.36491398),
    MLO_FLOAT_C(5184.67590389),
    MLO_FLOAT_C(5195.99306625),
    MLO_FLOAT_C(5207.31639432),
    MLO_FLOAT_C(5218.64588139),
    MLO_FLOAT_C(5229.98152079),
    MLO_FLOAT_C(5241.32330582),
    MLO_FLOAT_C(5252.67122985),
    MLO_FLOAT_C(5264.02528624),
    MLO_FLOAT_C(5275.38546837),
    MLO_FLOAT_C(5286.75176963),
    MLO_FLOAT_C(5298.12418346),
    MLO_FLOAT_C(5309.50270329),
    MLO_FLOAT_C(5320.88732256),
    MLO_FLOAT_C(5332.27803476),
    MLO_FLOAT_C(5343.67483336),
    MLO_FLOAT_C(5355.07771189),
    MLO_FLOAT_C(5366.48666385),
    MLO_FLOAT_C(5377.90168279),
    MLO_FLOAT_C(5389.32276227),
    MLO_FLOAT_C(5400.74989586),
    MLO_FLOAT_C(5412.18307715),
    MLO_FLOAT_C(5423.62229976),
    MLO_FLOAT_C(5435.06755731),
    MLO_FLOAT_C(5446.51884344),
    MLO_FLOAT_C(5457.9761518),
    MLO_FLOAT_C(5469.43947609),
    MLO_FLOAT_C(5480.90880998),
    MLO_FLOAT_C(5492.38414719),
    MLO_FLOAT_C(5503.86548144),
    MLO_FLOAT_C(5515.35280648),
    MLO_FLOAT_C(5526.84611606),
    MLO_FLOAT_C(5538.34540396),
    MLO_FLOAT_C(5549.85066396),
    MLO_FLOAT_C(5561.36188987),
    MLO_FLOAT_C(5572.87907552),
    MLO_FLOAT_C(5584.40221475),
    MLO_FLOAT_C(5595.9313014),
    MLO_FLOAT_C(5607.46632936),
    MLO_FLOAT_C(5619.00729249),
    MLO_FLOAT_C(5630.55418472),
    MLO_FLOAT_C(5642.10699994),
    MLO_FLOAT_C(5653.66573211),
    MLO_FLOAT_C(5665.23037516),
    MLO_FLOAT_C(5676.80092305),
    MLO_FLOAT_C(5688.37736978),
    MLO_FLOAT_C(5699.95970933),
    MLO_FLOAT_C(5711.54793571),
    MLO_FLOAT_C(5723.14204295),
    MLO_FLOAT_C(5734.74202509),
    MLO_FLOAT_C(5746.34787617),
    MLO_FLOAT_C(5757.95959029),
    MLO_FLOAT_C(5769.57716151),
    MLO_FLOAT_C(5781.20058394),
    MLO_FLOAT_C(5792.82985169),
    MLO_FLOAT_C(5804.4649589),
    MLO_FLOAT_C(5816.1058997),
    MLO_FLOAT_C(5827.75266826),
    MLO_FLOAT_C(5839.40525876),
    MLO_FLOAT_C(5851.06366537),
    MLO_FLOAT_C(5862.7278823),
    MLO_FLOAT_C(5874.39790377),
    MLO_FLOAT_C(5886.07372401),
    MLO_FLOAT_C(5897.75533727),
    MLO_FLOAT_C(5909.4427378),
    MLO_FLOAT_C(5921.13591988),
    MLO_FLOAT_C(5932.8348778),
    MLO_FLOAT_C(5944.53960587),
    MLO_FLOAT_C(5956.25009839),
    MLO_FLOAT_C(5967.96634969),
    MLO_FLOAT_C(5979.68835414),
    MLO_FLOAT_C(5991.41610607),
    MLO_FLOAT_C(6003.14959986),
    MLO_FLOAT_C(6014.88882991),
    MLO_FLOAT_C(6026.6337906),
    MLO_FLOAT_C(6038.38447635),
    MLO_FLOAT_C(6050.1408816),
    MLO_FLOAT_C(6061.90300077),
    MLO_FLOAT_C(6073.67082832),
    MLO_FLOAT_C(6085.44435872),
    MLO_FLOAT_C(6097.22358646),
    MLO_FLOAT_C(6109.00850602),
    MLO_FLOAT_C(6120.79911191),
    MLO_FLOAT_C(6132.59539865),
    MLO_FLOAT_C(6144.39736078),
    MLO_FLOAT_C(6156.20499284),
    MLO_FLOAT_C(6168.0182894),
    MLO_FLOAT_C(6179.83724502),
    MLO_FLOAT_C(6191.66185429),
    MLO_FLOAT_C(6203.49211181),
    MLO_FLOAT_C(6215.3280122),
    MLO_FLOAT_C(6227.16955007),
    MLO_FLOAT_C(6239.01672007),
    MLO_FLOAT_C(6250.86951684),
    MLO_FLOAT_C(6262.72793504),
    MLO_FLOAT_C(6274.59196936),
    MLO_FLOAT_C(6286.46161448),
    MLO_FLOAT_C(6298.3368651),
    MLO_FLOAT_C(6310.21771594),
    MLO_FLOAT_C(6322.10416171),
    MLO_FLOAT_C(6333.99619716),
    MLO_FLOAT_C(6345.89381704),
    MLO_FLOAT_C(6357.79701611),
    MLO_FLOAT_C(6369.70578915),
    MLO_FLOAT_C(6381.62013093),
    MLO_FLOAT_C(6393.54003627),
    MLO_FLOAT_C(6405.46549997),
    MLO_FLOAT_C(6417.39651686),
    MLO_FLOAT_C(6429.33308176),
    MLO_FLOAT_C(6441.27518954),
    MLO_FLOAT_C(6453.22283504),
    MLO_FLOAT_C(6465.17601315),
    MLO_FLOAT_C(6477.13471873),
    MLO_FLOAT_C(6489.0989467),
    MLO_FLOAT_C(6501.06869194),
    MLO_FLOAT_C(6513.04394939),
    MLO_FLOAT_C(6525.02471398),
    MLO_FLOAT_C(6537.01098063),
    MLO_FLOAT_C(6549.00274432),
    MLO_FLOAT_C(6561.0),
    MLO_FLOAT_C(6573.00274265),
    MLO_FLOAT_C(6585.01096725),
    MLO_FLOAT_C(6597.02466882),
    MLO_FLOAT_C(6609.04384235),
    MLO_FLOAT_C(6621.06848287),
    MLO_FLOAT_C(6633.09858541),
    MLO_FLOAT_C(6645.13414502),
    MLO_FLOAT_C(6657.17515675),
    MLO_FLOAT_C(6669.22161567),
    MLO_FLOAT_C(6681.27351687),
    MLO_FLOAT_C(6693.33085542),
    MLO_FLOAT_C(6705.39362643),
    MLO_FLOAT_C(6717.46182501),
    MLO_FLOAT_C(6729.53544628),
    MLO_FLOAT_C(6741.61448537),
    MLO_FLOAT_C(6753.69893744),
    MLO_FLOAT_C(6765.78879763),
    MLO_FLOAT_C(6777.88406111),
    MLO_FLOAT_C(6789.98472306),
    MLO_FLOAT_C(6802.09077866),
    MLO_FLOAT_C(6814.20222312),
    MLO_FLOAT_C(6826.31905164),
    MLO_FLOAT_C(6838.44125944),
    MLO_FLOAT_C(6850.56884175),
    MLO_FLOAT_C(6862.70179382),
    MLO_FLOAT_C(6874.84011088),
    MLO_FLOAT_C(6886.98378821),
    MLO_FLOAT_C(6899.13282108),
    MLO_FLOAT_C(6911.28720477),
    MLO_FLOAT_C(6923.44693457),
    MLO_FLOAT_C(6935.61200579),
    MLO_FLOAT_C(6947.78241373),
    MLO_FLOAT_C(6959.95815373),
    MLO_FLOAT_C(6972.13922112),
    MLO_FLOAT_C(6984.32561123),
    MLO_FLOAT_C(6996.51731943),
    MLO_FLOAT_C(7008.71434109),
    MLO_FLOAT_C(7020.91667156),
    MLO_FLOAT_C(7033.12430625),
    MLO_FLOAT_C(7045.33724054),
    MLO_FLOAT_C(7057.55546983),
    MLO_FLOAT_C(7069.77898955),
    MLO_FLOAT_C(7082.00779512),
    MLO_FLOAT_C(7094.24188197),
    MLO_FLOAT_C(7106.48124555),
    MLO_FLOAT_C(7118.72588131),
    MLO_FLOAT_C(7130.97578471),
    MLO_FLOAT_C(7143.23095122),
    MLO_FLOAT_C(7155.49137634),
    MLO_FLOAT_C(7167.75705555),
    MLO_FLOAT_C(7180.02798436),
    MLO_FLOAT_C(7192.30415828),
    MLO_FLOAT_C(7204.58557283),
    MLO_FLOAT_C(7216.87222354),
    MLO_FLOAT_C(7229.16410595),
    MLO_FLOAT_C(7241.46121561),
    MLO_FLOAT_C(7253.76354809),
    MLO_FLOAT_C(7266.07109895),
    MLO_FLOAT_C(7278.38386377),
    MLO_FLOAT_C(7290.70183813),
    MLO_FLOAT_C(7303.02501765),
    MLO_FLOAT_C(7315.35339791),
    MLO_FLOAT_C(7327.68697455),
    MLO_FLOAT_C(7340.02574317),
    MLO_FLOAT_C(7352.36969942),
    MLO_FLOAT_C(7364.71883895),
    MLO_FLOAT_C(7377.07315739),
    MLO_FLOAT_C(7389.43265043),
    MLO_FLOAT_C(7401.79731371),
    MLO_FLOAT_C(7414.16714293),
    MLO_FLOAT_C(7426.54213378),
    MLO_FLOAT_C(7438.92228195),
    MLO_FLOAT_C(7451.30758314),
    MLO_FLOAT_C(7463.69803308),
    MLO_FLOAT_C(7476.09362749),
    MLO_FLOAT_C(7488.4943621),
    MLO_FLOAT_C(7500.90023266),
    MLO_FLOAT_C(7513.31123491),
    MLO_FLOAT_C(7525.72736461),
    MLO_FLOAT_C(7538.14861754),
    MLO_FLOAT_C(7550.57498947),
    MLO_FLOAT_C(7563.00647618),
    MLO_FLOAT_C(7575.44307348),
    MLO_FLOAT_C(7587.88477716),
    MLO_FLOAT_C(7600.33158304),
    MLO_FLOAT_C(7612.78348693),
    MLO_FLOAT_C(7625.24048468),
    MLO_FLOAT_C(7637.7025721),
    MLO_FLOAT_C(7650.16974505),
    MLO_FLOAT_C(7662.64199939),
    MLO_FLOAT_C(7675.11933098),
    MLO_FLOAT_C(7687.60173568),
    MLO_FLOAT_C(7700.08920938),
    MLO_FLOAT_C(7712.58174796),
    MLO_FLOAT_C(7725.07934733),
    MLO_FLOAT_C(7737.58200339),
    MLO_FLOAT_C(7750.08971204),
    MLO_FLOAT_C(7762.60246922),
    MLO_FLOAT_C(7775.12027085),
    MLO_FLOAT_C(7787.64311286),
    MLO_FLOAT_C(7800.17099121),
    MLO_FLOAT_C(7812.70390185),
    MLO_FLOAT_C(7825.24184073),
    MLO_FLOAT_C(7837.78480384),
    MLO_FLOAT_C(7850.33278715),
    MLO_FLOAT_C(7862.88578664),
    MLO_FLOAT_C(7875.44379831),
    MLO_FLOAT_C(7888.00681815),
    MLO_FLOAT_C(7900.5748422),
    MLO_FLOAT_C(7913.14786645),
    MLO_FLOAT_C(7925.72588693),
    MLO_FLOAT_C(7938.30889969),
    MLO_FLOAT_C(7950.89690075),
    MLO_FLOAT_C(7963.48988618),
    MLO_FLOAT_C(7976.08785203),
    MLO_FLOAT_C(7988.69079436),
    MLO_FLOAT_C(8001.29870924),
    MLO_FLOAT_C(8013.91159276),
    MLO_FLOAT_C(8026.52944101),
    MLO_FLOAT_C(8039.15225008),
    MLO_FLOAT_C(8051.78001608),
    MLO_FLOAT_C(8064.41273511),
    MLO_FLOAT_C(8077.0504033),
    MLO_FLOAT_C(8089.69301678),
    MLO_FLOAT_C(8102.34057167),
    MLO_FLOAT_C(8114.99306412),
    MLO_FLOAT_C(8127.65049027),
    MLO_FLOAT_C(8140.31284629),
    MLO_FLOAT_C(8152.98012835),
    MLO_FLOAT_C(8165.6523326),
    MLO_FLOAT_C(8178.32945523),
    MLO_FLOAT_C(8191.01149243),
    MLO_FLOAT_C(8203.69844039),
    MLO_FLOAT_C(8216.39029531),
    MLO_FLOAT_C(8229.0870534),
    MLO_FLOAT_C(8241.78871088),
    MLO_FLOAT_C(8254.49526397),
    MLO_FLOAT_C(8267.2067089),
    MLO_FLOAT_C(8279.92304191),
    MLO_FLOAT_C(8292.64425924),
    MLO_FLOAT_C(8305.37035714),
    MLO_FLOAT_C(8318.10133188),
    MLO_FLOAT_C(8330.83717973),
    MLO_FLOAT_C(8343.57789694),
    MLO_FLOAT_C(8356.32347981),
    MLO_FLOAT_C(8369.07392463),
    MLO_FLOAT_C(8381.82922768),
    MLO_FLOAT_C(8394.58938528),
    MLO_FLOAT_C(8407.35439372),
    MLO_FLOAT_C(8420.12424933),
    MLO_FLOAT_C(8432.89894843),
    MLO_FLOAT_C(8445.67848735),
    MLO_FLOAT_C(8458.46286242),
    MLO_FLOAT_C(8471.25206999),
    MLO_FLOAT_C(8484.04610641),
    MLO_FLOAT_C(8496.84496804),
    MLO_FLOAT_C(8509.64865125),
    MLO_FLOAT_C(8522.45715239),
    MLO_FLOAT_C(8535.27046786),
    MLO_FLOAT_C(8548.08859404),
    MLO_FLOAT_C(8560.91152731),
    MLO_FLOAT_C(8573.73926408),
    MLO_FLOAT_C(8586.57180075),
    MLO_FLOAT_C(8599.40913374),
    MLO_FLOAT_C(8612.25125946),
    MLO_FLOAT_C(8625.09817434),
    MLO_FLOAT_C(8637.9498748),
    MLO_FLOAT_C(8650.8063573),
    MLO_FLOAT_C(8663.66761827),
    MLO_FLOAT_C(8676.53365417),
    MLO_FLOAT_C(8689.40446145),
    MLO_FLOAT_C(8702.28003658),
    MLO_FLOAT_C(8715.16037603),
    MLO_FLOAT_C(8728.04547628),
    MLO_FLOAT_C(8740.93533382),
    MLO_FLOAT_C(8753.82994513),
    MLO_FLOAT_C(8766.72930671),
    MLO_FLOAT_C(8779.63341506),
    MLO_FLOAT_C(8792.54226671),
    MLO_FLOAT_C(8805.45585815),
    MLO_FLOAT_C(8818.37418592),
    MLO_FLOAT_C(8831.29724655),
    MLO_FLOAT_C(8844.22503657),
    MLO_FLOAT_C(8857.15755253),
    MLO_FLOAT_C(8870.09479096),
    MLO_FLOAT_C(8883.03674843),
    MLO_FLOAT_C(8895.98342151),
    MLO_FLOAT_C(8908.93480674),
    MLO_FLOAT_C(8921.89090072),
    MLO_FLOAT_C(8934.85170001),
    MLO_FLOAT_C(8947.81720121),
    MLO_FLOAT_C(8960.78740091),
    MLO_FLOAT_C(8973.7622957),
    MLO_FLOAT_C(8986.7418822),
    MLO_FLOAT_C(8999.726157),
    MLO_FLOAT_C(9012.71511673),
    MLO_FLOAT_C(9025.70875801),
    MLO_FLOAT_C(9038.70707748),
    MLO_FLOAT_C(9051.71007175),
    MLO_FLOAT_C(9064.71773748),
    MLO_FLOAT_C(9077.73007132),
    MLO_FLOAT_C(9090.74706991),
    MLO_FLOAT_C(9103.76872991),
    MLO_FLOAT_C(9116.79504799),
    MLO_FLOAT_C(9129.82602083),
    MLO_FLOAT_C(9142.86164509),
    MLO_FLOAT_C(9155.90191746),
    MLO_FLOAT_C(9168.94683464),
    MLO_FLOAT_C(9181.9963933),
    MLO_FLOAT_C(9195.05059016),
    MLO_FLOAT_C(9208.10942193),
    MLO_FLOAT_C(9221.1728853),
    MLO_FLOAT_C(9234.24097701),
    MLO_FLOAT_C(9247.31369377),
    MLO_FLOAT_C(9260.39103232),
    MLO_FLOAT_C(9273.47298938),
    MLO_FLOAT_C(9286.55956171),
    MLO_FLOAT_C(9299.65074605),
    MLO_FLOAT_C(9312.74653915),
    MLO_FLOAT_C(9325.84693777),
    MLO_FLOAT_C(9338.95193867),
    MLO_FLOAT_C(9352.06153863),
    MLO_FLOAT_C(9365.17573441),
    MLO_FLOAT_C(9378.2945228),
    MLO_FLOAT_C(9391.41790059),
    MLO_FLOAT_C(9404.54586457),
    MLO_FLOAT_C(9417.67841154),
    MLO_FLOAT_C(9430.8155383),
    MLO_FLOAT_C(9443.95724165),
    MLO_FLOAT_C(9457.10351842),
    MLO_FLOAT_C(9470.25436543),
    MLO_FLOAT_C(9483.40977949),
    MLO_FLOAT_C(9496.56975745),
    MLO_FLOAT_C(9509.73429613),
    MLO_FLOAT_C(9522.90339239),
    MLO_FLOAT_C(9536.07704306),
    MLO_FLOAT_C(9549.255245),
    MLO_FLOAT_C(9562.43799507),
    MLO_FLOAT_C(9575.62529013),
    MLO_FLOAT_C(9588.81712705),
    MLO_FLOAT_C(9602.01350272),
    MLO_FLOAT_C(9615.214414),
    MLO_FLOAT_C(9628.41985778),
    MLO_FLOAT_C(9641.62983095),
    MLO_FLOAT_C(9654.84433041),
    MLO_FLOAT_C(9668.06335307),
    MLO_FLOAT_C(9681.28689582),
    MLO_FLOAT_C(9694.51495558),
    MLO_FLOAT_C(9707.74752927),
    MLO_FLOAT_C(9720.9846138),
    MLO_FLOAT_C(9734.22620612),
    MLO_FLOAT_C(9747.47230314),
    MLO_FLOAT_C(9760.72290181),
    MLO_FLOAT_C(9773.97799907),
    MLO_FLOAT_C(9787.23759187),
    MLO_FLOAT_C(9800.50167717),
    MLO_FLOAT_C(9813.77025191),
    MLO_FLOAT_C(9827.04331308),
    MLO_FLOAT_C(9840.32085763),
    MLO_FLOAT_C(9853.60288254),
    MLO_FLOAT_C(9866.88938478),
    MLO_FLOAT_C(9880.18036136),
    MLO_FLOAT_C(9893.47580924),
    MLO_FLOAT_C(9906.77572543),
    MLO_FLOAT_C(9920.08010693),
    MLO_FLOAT_C(9933.38895075),
    MLO_FLOAT_C(9946.70225388),
    MLO_FLOAT_C(9960.02001335),
    MLO_FLOAT_C(9973.34222618),
    MLO_FLOAT_C(9986.66888938),
    MLO_FLOAT_C(10000.0),
    MLO_FLOAT_C(10013.3355551),
    MLO_FLOAT_C(10026.6755516),
    MLO_FLOAT_C(10040.0199867),
    MLO_FLOAT_C(10053.3688573),
    MLO_FLOAT_C(10066.7221606),
    MLO_FLOAT_C(10080.0798936),
    MLO_FLOAT_C(10093.4420533),
    MLO_FLOAT_C(10106.8086369),
    MLO_FLOAT_C(10120.1796413),
    MLO_FLOAT_C(10133.5550638),
    MLO_FLOAT_C(10146.9349013),
    MLO_FLOAT_C(10160.3191509),
    MLO_FLOAT_C(10173.7078098),
    MLO_FLOAT_C(10187.100875),
    MLO_FLOAT_C(10200.4983437),
    MLO_FLOAT_C(10213.9002129),
    MLO_FLOAT_C(10227.3064797),
    MLO_FLOAT_C(10240.7171414),
    MLO_FLOAT_C(10254.1321949),
    MLO_FLOAT_C(10267.5516375),
    MLO_FLOAT_C(10280.9754662),
    MLO_FLOAT_C(10294.4036783),
    MLO_FLOAT_C(10307.8362707),
    MLO_FLOAT_C(10321.2732407),
    MLO_FLOAT_C(10334.7145855),
    MLO_FLOAT_C(10348.1603021),
    MLO_FLOAT_C(10361.6103878),
    MLO_FLOAT_C(10375.0648397),
    MLO_FLOAT_C(10388.5236549),
    MLO_FLOAT_C(10401.9868307),
    MLO_FLOAT_C(10415.4543642),
    MLO_FLOAT_C(10428.9262526),
    MLO_FLOAT_C(10442.4024931),
    MLO_FLOAT_C(10455.8830829),
    MLO_FLOAT_C(10469.3680192),
    MLO_FLOAT_C(10482.8572991),
    MLO_FLOAT_C(10496.3509199),
    MLO_FLOAT_C(10509.8488788),
    MLO_FLOAT_C(10523.351173),
    MLO_FLOAT_C(10536.8577997),
    MLO_FLOAT_C(10550.3687562),
    MLO_FLOAT_C(10563.8840396),
    MLO_FLOAT_C(10577.4036472),
    MLO_FLOAT_C(10590.9275763),
    MLO_FLOAT_C(10604.455824),
    MLO_FLOAT_C(10617.9883877),
    MLO_FLOAT_C(10631.5252645),
    MLO_FLOAT_C(10645.0664518),
    MLO_FLOAT_C(10658.6119467),
    MLO_FLOAT_C(10672.1617466),
    MLO_FLOAT_C(10685.7158486),
    MLO_FLOAT_C(10699.2742502),
    MLO_FLOAT_C(10712.8369485),
    MLO_FLOAT_C(10726.4039408),
    MLO_FLOAT_C(10739.9752245),
    MLO_FLOAT_C(10753.5507967),
    MLO_FLOAT_C(10767.1306549),
    MLO_FLOAT_C(10780.7147962),
    MLO_FLOAT_C(10794.303218),
    MLO_FLOAT_C(10807.8959177),
    MLO_FLOAT_C(10821.4928924),
    MLO_FLOAT_C(10835.0941396),
    MLO_FLOAT_C(10848.6996565),
    MLO_FLOAT_C(10862.3094404),
    MLO_FLOAT_C(10875.9234888),
    MLO_FLOAT_C(10889.5417988),
    MLO_FLOAT_C(10903.1643679),
    MLO_FLOAT_C(10916.7911934),
    MLO_FLOAT_C(10930.4222726),
    MLO_FLOAT_C(10944.0576029),
    MLO_FLOAT_C(10957.6971817),
    MLO_FLOAT_C(10971.3410062),
    MLO_FLOAT_C(10984.9890738),
    MLO_FLOAT_C(10998.641382),
    MLO_FLOAT_C(11012.297928),
    MLO_FLOAT_C(11025.9587093),
    MLO_FLOAT_C(11039.6237232),
    MLO_FLOAT_C(11053.2929671),
    MLO_FLOAT_C(11066.9664384),
    MLO_FLOAT_C(11080.6441345),
    MLO_FLOAT_C(11094.3260527),
    MLO_FLOAT_C(11108.0121905),
    MLO_FLOAT_C(11121.7025452),
    MLO_FLOAT_C(11135.3971143),
    MLO_FLOAT_C(11149.0958952),
    MLO_FLOAT_C(11162.7988852),
    MLO_FLOAT_C(11176.5060819),
    MLO_FLOAT_C(11190.2174825),
    MLO_FLOAT_C(11203.9330847),
    MLO_FLOAT_C(11217.6528856),
    MLO_FLOAT_C(11231.3768829),
    MLO_FLOAT_C(11245.1050739),
    MLO_FLOAT_C(11258.8374561),
    MLO_FLOAT_C(11272.5740269),
    MLO_FLOAT_C(11286.3147838),
    MLO_FLOAT_C(11300.0597242),
    MLO_FLOAT_C(11313.8088455),
    MLO_FLOAT_C(11327.5621453),
    MLO_FLOAT_C(11341.319621),
    MLO_FLOAT_C(11355.08127),
    MLO_FLOAT_C(11368.8470899),
    MLO_FLOAT_C(11382.6170781),
    MLO_FLOAT_C(11396.391232),
    MLO_FLOAT_C(11410.1695492),
    MLO_FLOAT_C(11423.9520272),
    MLO_FLOAT_C(11437.7386634),
    MLO_FLOAT_C(11451.5294553),
    MLO_FLOAT_C(11465.3244005),
    MLO_FLOAT_C(11479.1234964),
    MLO_FLOAT_C(11492.9267405),
    MLO_FLOAT_C(11506.7341303),
    MLO_FLOAT_C(11520.5456635),
    MLO_FLOAT_C(11534.3613373),
    MLO_FLOAT_C(11548.1811495),
    MLO_FLOAT_C(11562.0050975),
    MLO_FLOAT_C(11575.8331788),
    MLO_FLOAT_C(11589.665391),
    MLO_FLOAT_C(11603.5017316),
    MLO_FLOAT_C(11617.3421981),
    MLO_FLOAT_C(11631.1867881),
    MLO_FLOAT_C(11645.0354992),
    MLO_FLOAT_C(11658.8883288),
    MLO_FLOAT_C(11672.7452746),
    MLO_FLOAT_C(11686.606334),
    MLO_FLOAT_C(11700.4715047),
    MLO_FLOAT_C(11714.3407842),
    MLO_FLOAT_C(11728.21417),
    MLO_FLOAT_C(11742.0916598),
    MLO_FLOAT_C(11755.9732511),
    MLO_FLOAT_C(11769.8589416),
    MLO_FLOAT_C(11783.7487287),
    MLO_FLOAT_C(11797.64261),
    MLO_FLOAT_C(11811.5405832),
    MLO_FLOAT_C(11825.4426459),
    MLO_FLOAT_C(11839.3487956),
    MLO_FLOAT_C(11853.2590299),
    MLO_FLOAT_C(11867.1733465),
    MLO_FLOAT_C(11881.0917429),
    MLO_FLOAT_C(11895.0142168),
    MLO_FLOAT_C(11908.9407658),
    MLO_FLOAT_C(11922.8713874),
    MLO_FLOAT_C(11936.8060794),
    MLO_FLOAT_C(11950.7448392),
    MLO_FLOAT_C(11964.6876647),
    MLO_FLOAT_C(11978.6345533),
    MLO_FLOAT_C(11992.5855027),
    MLO_FLOAT_C(12006.5405106),
    MLO_FLOAT_C(12020.4995746),
    MLO_FLOAT_C(12034.4626923),
    MLO_FLOAT_C(12048.4298615),
    MLO_FLOAT_C(12062.4010796),
    MLO_FLOAT_C(12076.3763445),
    MLO_FLOAT_C(12090.3556537),
    MLO_FLOAT_C(12104.339005),
    MLO_FLOAT_C(12118.3263959),
    MLO_FLOAT_C(12132.3178242),
    MLO_FLOAT_C(12146.3132874),
    MLO_FLOAT_C(12160.3127834),
    MLO_FLOAT_C(12174.3163098),
    MLO_FLOAT_C(12188.3238642),
    MLO_FLOAT_C(12202.3354443),
    MLO_FLOAT_C(12216.3510479),
    MLO_FLOAT_C(12230.3706726),
    MLO_FLOAT_C(12244.3943161),
    MLO_FLOAT_C(12258.4219761),
    MLO_FLOAT_C(12272.4536503),
    MLO_FLOAT_C(12286.4893364),
    MLO_FLOAT_C(12300.5290322),
    MLO_FLOAT_C(12314.5727353),
    MLO_FLOAT_C(12328.6204434),
    MLO_FLOAT_C(12342.6721544),
    MLO_FLOAT_C(12356.7278658),
    MLO_FLOAT_C(12370.7875754),
    MLO_FLOAT_C(12384.8512809),
    MLO_FLOAT_C(12398.9189801),
    MLO_FLOAT_C(12412.9906708),
    MLO_FLOAT_C(12427.0663505),
    MLO_FLOAT_C(12441.1460172),
    MLO_FLOAT_C(12455.2296684),
    MLO_FLOAT_C(12469.3173021),
    MLO_FLOAT_C(12483.4089158),
    MLO_FLOAT_C(12497.5045074),
    MLO_FLOAT_C(12511.6040747),
    MLO_FLOAT_C(12525.7076153),
    MLO_FLOAT_C(12539.8151271),
    MLO_FLOAT_C(12553.9266078),
    MLO_FLOAT_C(12568.0420552),
    MLO_FLOAT_C(12582.1614671),
    MLO_FLOAT_C(12596.2848412),
    MLO_FLOAT_C(12610.4121753),
    MLO_FLOAT_C(12624.5434672),
    MLO_FLOAT_C(12638.6787146),
    MLO_FLOAT_C(12652.8179155),
    MLO_FLOAT_C(12666.9610674),
    MLO_FLOAT_C(12681.1081684),
    MLO_FLOAT_C(12695.259216),
    MLO_FLOAT_C(12709.4142082),
    MLO_FLOAT_C(12723.5731428),
    MLO_FLOAT_C(12737.7360175),
    MLO_FLOAT_C(12751.9028302),
    MLO_FLOAT_C(12766.0735786),
    MLO_FLOAT_C(12780.2482607),
    MLO_FLOAT_C(12794.4268741),
    MLO_FLOAT_C(12808.6094168),
    MLO_FLOAT_C(12822.7958865),
    MLO_FLOAT_C(12836.9862811),
    MLO_FLOAT_C(12851.1805984),
    MLO_FLOAT_C(12865.3788362),
    MLO_FLOAT_C(12879.5809924),
    MLO_FLOAT_C(12893.7870649),
    MLO_FLOAT_C(12907.9970514),
    MLO_FLOAT_C(12922.2109498),
    MLO_FLOAT_C(12936.4287579),
    MLO_FLOAT_C(12950.6504737),
    MLO_FLOAT_C(12964.8760949),
    MLO_FLOAT_C(12979.1056194),
    MLO_FLOAT_C(12993.3390451),
    MLO_FLOAT_C(13007.5763698),
    MLO_FLOAT_C(13021.8175914),
    MLO_FLOAT_C(13036.0627078),
    MLO_FLOAT_C(13050.3117169),
    MLO_FLOAT_C(13064.5646164),
    MLO_FLOAT_C(13078.8214043),
    MLO_FLOAT_C(13093.0820786),
    MLO_FLOAT_C(13107.3466369),
    MLO_FLOAT_C(13121.6150773),
    MLO_FLOAT_C(13135.8873977),
    MLO_FLOAT_C(13150.1635958),
    MLO_FLOAT_C(13164.4436697),
    MLO_FLOAT_C(13178.7276172),
    MLO_FLOAT_C(13193.0154362),
    MLO_FLOAT_C(13207.3071246),
    MLO_FLOAT_C(13221.6026804),
    MLO_FLOAT_C(13235.9021013),
    MLO_FLOAT_C(13250.2053854),
    MLO_FLOAT_C(13264.5125306),
    MLO_FLOAT_C(13278.8235348),
    MLO_FLOAT_C(13293.1383958),
    MLO_FLOAT_C(13307.4571117),
    MLO_FLOAT_C(13321.7796803),
    MLO_FLOAT_C(13336.1060995),
    MLO_FLOAT_C(13350.4363674),
    MLO_FLOAT_C(13364.7704818),
    MLO_FLOAT_C(13379.1084407),
    MLO_FLOAT_C(13393.450242),
    MLO_FLOAT_C(13407.7958836),
    MLO_FLOAT_C(13422.1453636),
    MLO_FLOAT_C(13436.4986798),
    MLO_FLOAT_C(13450.8558302),
    MLO_FLOAT_C(13465.2168127),
    MLO_FLOAT_C(13479.5816253),
    MLO_FLOAT_C(13493.9502661),
    MLO_FLOAT_C(13508.3227328),
    MLO_FLOAT_C(13522.6990235),
    MLO_FLOAT_C(13537.0791362),
    MLO_FLOAT_C(13551.4630688),
    MLO_FLOAT_C(13565.8508193),
    MLO_FLOAT_C(13580.2423857),
    MLO_FLOAT_C(13594.6377659),
    MLO_FLOAT_C(13609.036958),
    MLO_FLOAT_C(13623.4399599),
    MLO_FLOAT_C(13637.8467696),
    MLO_FLOAT_C(13652.257385),
    MLO_FLOAT_C(13666.6718043),
    MLO_FLOAT_C(13681.0900253),
    MLO_FLOAT_C(13695.5120461),
    MLO_FLOAT_C(13709.9378647),
    MLO_FLOAT_C(13724.367479),
    MLO_FLOAT_C(13738.8008871),
    MLO_FLOAT_C(13753.238087),
    MLO_FLOAT_C(13767.6790766),
    MLO_FLOAT_C(13782.1238541),
    MLO_FLOAT_C(13796.5724174),
    MLO_FLOAT_C(13811.0247645),
    MLO_FLOAT_C(13825.4808935),
    MLO_FLOAT_C(13839.9408023),
    MLO_FLOAT_C(13854.4044891),
    MLO_FLOAT_C(13868.8719517),
    MLO_FLOAT_C(13883.3431884),
    MLO_FLOAT_C(13897.818197),
    MLO_FLOAT_C(13912.2969756),
    MLO_FLOAT_C(13926.7795223),
    MLO_FLOAT_C(13941.2658351),
    MLO_FLOAT_C(13955.7559121),
    MLO_FLOAT_C(13970.2497512),
    MLO_FLOAT_C(13984.7473506),
    MLO_FLOAT_C(13999.2487083),
    MLO_FLOAT_C(14013.7538223),
    MLO_FLOAT_C(14028.2626907),
    MLO_FLOAT_C(14042.7753115),
    MLO_FLOAT_C(14057.2916829),
    MLO_FLOAT_C(14071.8118029),
    MLO_FLOAT_C(14086.3356695),
    MLO_FLOAT_C(14100.8632808),
    MLO_FLOAT_C(14115.3946349),
    MLO_FLOAT_C(14129.9297299),
    MLO_FLOAT_C(14144.4685638),
    MLO_FLOAT_C(14159.0111346),
    MLO_FLOAT_C(14173.5574406),
    MLO_FLOAT_C(14188.1074798),
    MLO_FLOAT_C(14202.6612502),
    MLO_FLOAT_C(14217.21875),
    MLO_FLOAT_C(14231.7799772),
    MLO_FLOAT_C(14246.3449299),
    MLO_FLOAT_C(14260.9136063),
    MLO_FLOAT_C(14275.4860043),
    MLO_FLOAT_C(14290.0621222),
    MLO_FLOAT_C(14304.641958),
    MLO_FLOAT_C(14319.2255099),
    MLO_FLOAT_C(14333.8127759),
    MLO_FLOAT_C(14348.4037541),
    MLO_FLOAT_C(14362.9984427),
    MLO_FLOAT_C(14377.5968397),
    MLO_FLOAT_C(14392.1989434),
    MLO_FLOAT_C(14406.8047517),
    MLO_FLOAT_C(14421.4142629),
    MLO_FLOAT_C(14436.027475),
    MLO_FLOAT_C(14450.6443862),
    MLO_FLOAT_C(14465.2649947),
    MLO_FLOAT_C(14479.8892984),
    MLO_FLOAT_C(14494.5172957),
    MLO_FLOAT_C(14509.1489845),
    MLO_FLOAT_C(14523.7843631),
    MLO_FLOAT_C(14538.4234296),
    MLO_FLOAT_C(14553.0661821),
    MLO_FLOAT_C(14567.7126187),
    MLO_FLOAT_C(14582.3627377),
    MLO_FLOAT_C(14597.0165372),
    MLO_FLOAT_C(14611.6740153),
    MLO_FLOAT_C(14626.3351702),
    MLO_FLOAT_C(14641.0),
    MLO_FLOAT_C(14655.6685029),
    MLO_FLOAT_C(14670.3406771),
    MLO_FLOAT_C(14685.0165207),
    MLO_FLOAT_C(14699.6960318),
    MLO_FLOAT_C(14714.3792087),
    MLO_FLOAT_C(14729.0660496),
    MLO_FLOAT_C(14743.7565525),
    MLO_FLOAT_C(14758.4507158),
    MLO_FLOAT_C(14773.1485374),
    MLO_FLOAT_C(14787.8500157),
    MLO_FLOAT_C(14802.5551488),
    MLO_FLOAT_C(14817.2639349),
    MLO_FLOAT_C(14831.9763722),
    MLO_FLOAT_C(14846.6924589),
    MLO_FLOAT_C(14861.4121931),
    MLO_FLOAT_C(14876.1355731),
    MLO_FLOAT_C(14890.862597),
    MLO_FLOAT_C(14905.5932631),
    MLO_FLOAT_C(14920.3275695),
    MLO_FLOAT_C(14935.0655145),
    MLO_FLOAT_C(14949.8070962),
    MLO_FLOAT_C(14964.5523129),
    MLO_FLOAT_C(14979.3011627),
    MLO_FLOAT_C(14994.053644),
    MLO_FLOAT_C(15008.8097548),
    MLO_FLOAT_C(15023.5694934),
    MLO_FLOAT_C(15038.3328581),
    MLO_FLOAT_C(15053.099847),
    MLO_FLOAT_C(15067.8704584),
    MLO_FLOAT_C(15082.6446904),
    MLO_FLOAT_C(15097.4225414),
    MLO_FLOAT_C(15112.2040096),
    MLO_FLOAT_C(15126.9890931),
    MLO_FLOAT_C(15141.7777902),
    MLO_FLOAT_C(15156.5700992),
    MLO_FLOAT_C(15171.3660182),
    MLO_FLOAT_C(15186.1655456),
    MLO_FLOAT_C(15200.9686795),
    MLO_FLOAT_C(15215.7754182),
    MLO_FLOAT_C(15230.58576),
    MLO_FLOAT_C(15245.3997031),
    MLO_FLOAT_C(15260.2172457),
    MLO_FLOAT_C(15275.0383862),
    MLO_FLOAT_C(15289.8631227),
    MLO_FLOAT_C(15304.6914535),
    MLO_FLOAT_C(15319.5233768),
    MLO_FLOAT_C(15334.358891),
    MLO_FLOAT_C(15349.1979943),
    MLO_FLOAT_C(15364.040685),
    MLO_FLOAT_C(15378.8869613),
    MLO_FLOAT_C(15393.7368214),
    MLO_FLOAT_C(15408.5902638),
    MLO_FLOAT_C(15423.4472865),
    MLO_FLOAT_C(15438.307888),
    MLO_FLOAT_C(15453.1720665),
    MLO_FLOAT_C(15468.0398202),
    MLO_FLOAT_C(15482.9111475),
    MLO_FLOAT_C(15497.7860467),
    MLO_FLOAT_C(15512.6645159),
    MLO_FLOAT_C(15527.5465536),
    MLO_FLOAT_C(15542.4321579),
    MLO_FLOAT_C(15557.3213272),
    MLO_FLOAT_C(15572.2140598),
    MLO_FLOAT_C(15587.110354),
    MLO_FLOAT_C(15602.0102081),
    MLO_FLOAT_C(15616.9136203),
    MLO_FLOAT_C(15631.8205891),
    MLO_FLOAT_C(15646.7311126),
    MLO_FLOAT_C(15661.6451891),
    MLO_FLOAT_C(15676.5628171),
    MLO_FLOAT_C(15691.4839948),
    MLO_FLOAT_C(15706.4087205),
    MLO_FLOAT_C(15721.3369925),
    MLO_FLOAT_C(15736.2688092),
    MLO_FLOAT_C(15751.2041688),
    MLO_FLOAT_C(15766.1430697),
    MLO_FLOAT_C(15781.0855103),
    MLO_FLOAT_C(15796.0314887),
    MLO_FLOAT_C(15810.9810034),
    MLO_FLOAT_C(15825.9340527),
    MLO_FLOAT_C(15840.8906349),
    MLO_FLOAT_C(15855.8507483),
    MLO_FLOAT_C(15870.8143913),
    MLO_FLOAT_C(15885.7815623),
    MLO_FLOAT_C(15900.7522595),
    MLO_FLOAT_C(15915.7264812),
    MLO_FLOAT_C(15930.7042259),
    MLO_FLOAT_C(15945.6854919),
    MLO_FLOAT_C(15960.6702775),
    MLO_FLOAT_C(15975.6585811),
    MLO_FLOAT_C(15990.650401),
    MLO_FLOAT_C(16005.6457355),
    MLO_FLOAT_C(16020.6445831),
    MLO_FLOAT_C(16035.6469421),
    MLO_FLOAT_C(16050.6528108),
    MLO_FLOAT_C(16065.6621876),
    MLO_FLOAT_C(16080.6750708),
    MLO_FLOAT_C(16095.6914588),
    MLO_FLOAT_C(16110.7113501),
    MLO_FLOAT_C(16125.7347429),
    MLO_FLOAT_C(16140.7616356),
    MLO_FLOAT_C(16155.7920266),
    MLO_FLOAT_C(16170.8259142),
    MLO_FLOAT_C(16185.8632969),
    MLO_FLOAT_C(16200.904173),
    MLO_FLOAT_C(16215.9485409),
    MLO_FLOAT_C(16230.9963989),
    MLO_FLOAT_C(16246.0477455),
    MLO_FLOAT_C(16261.1025791),
    MLO_FLOAT_C(16276.1608979),
    MLO_FLOAT_C(16291.2227005),
    MLO_FLOAT_C(16306.2879851),
    MLO_FLOAT_C(16321.3567503),
    MLO_FLOAT_C(16336.4289943),
    MLO_FLOAT_C(16351.5047156),
    MLO_FLOAT_C(16366.5839125),
    MLO_FLOAT_C(16381.6665836),
    MLO_FLOAT_C(16396.7527271),
    MLO_FLOAT_C(16411.8423415),
    MLO_FLOAT_C(16426.9354251),
    MLO_FLOAT_C(16442.0319764),
    MLO_FLOAT_C(16457.1319939),
    MLO_FLOAT_C(16472.2354758),
    MLO_FLOAT_C(16487.3424206),
    MLO_FLOAT_C(16502.4528268),
    MLO_FLOAT_C(16517.5666927),
    MLO_FLOAT_C(16532.6840167),
    MLO_FLOAT_C(16547.8047973),
    MLO_FLOAT_C(16562.929033),
    MLO_FLOAT_C(16578.056722),
    MLO_FLOAT_C(16593.1878629),
    MLO_FLOAT_C(16608.322454),
    MLO_FLOAT_C(16623.4604938),
    MLO_FLOAT_C(16638.6019808),
    MLO_FLOAT_C(16653.7469133),
    MLO_FLOAT_C(16668.8952898),
    MLO_FLOAT_C(16684.0471087),
    MLO_FLOAT_C(16699.2023685),
    MLO_FLOAT_C(16714.3610676),
    MLO_FLOAT_C(16729.5232044),
    MLO_FLOAT_C(16744.6887774),
    MLO_FLOAT_C(16759.857785),
    MLO_FLOAT_C(16775.0302257),
    MLO_FLOAT_C(16790.2060978),
    MLO_FLOAT_C(16805.3854),
    MLO_FLOAT_C(16820.5681306),
    MLO_FLOAT_C(16835.754288),
    MLO_FLOAT_C(16850.9438708),
    MLO_FLOAT_C(16866.1368773),
    MLO_FLOAT_C(16881.3333061),
    MLO_FLOAT_C(16896.5331555),
    MLO_FLOAT_C(16911.7364241),
    MLO_FLOAT_C(16926.9431104),
    MLO_FLOAT_C(16942.1532127),
    MLO_FLOAT_C(16957.3667296),
    MLO_FLOAT_C(16972.5836594),
    MLO_FLOAT_C(16987.8040008),
    MLO_FLOAT_C(17003.0277521),
    MLO_FLOAT_C(17018.2549119),
    MLO_FLOAT_C(17033.4854785),
    MLO_FLOAT_C(17048.7194506),
    MLO_FLOAT_C(17063.9568264),
    MLO_FLOAT_C(17079.1976047),
    MLO_FLOAT_C(17094.4417837),
    MLO_FLOAT_C(17109.6893621),
    MLO_FLOAT_C(17124.9403382),
    MLO_FLOAT_C(17140.1947107),
    MLO_FLOAT_C(17155.4524779),
    MLO_FLOAT_C(17170.7136383),
    MLO_FLOAT_C(17185.9781905),
    MLO_FLOAT_C(17201.2461329),
    MLO_FLOAT_C(17216.5174641),
    MLO_FLOAT_C(17231.7921825),
    MLO_FLOAT_C(17247.0702866),
    MLO_FLOAT_C(17262.351775),
    MLO_FLOAT_C(17277.636646),
    MLO_FLOAT_C(17292.9248984),
    MLO_FLOAT_C(17308.2165304),
    MLO_FLOAT_C(17323.5115407),
    MLO_FLOAT_C(17338.8099278),
    MLO_FLOAT_C(17354.1116901),
    MLO_FLOAT_C(17369.4168262),
    MLO_FLOAT_C(17384.7253346),
    MLO_FLOAT_C(17400.0372138),
    MLO_FLOAT_C(17415.3524623),
    MLO_FLOAT_C(17430.6710787),
    MLO_FLOAT_C(17445.9930614),
    MLO_FLOAT_C(17461.318409),
    MLO_FLOAT_C(17476.64712),
    MLO_FLOAT_C(17491.9791929),
    MLO_FLOAT_C(17507.3146263),
    MLO_FLOAT_C(17522.6534187),
    MLO_FLOAT_C(17537.9955685),
    MLO_FLOAT_C(17553.3410745),
    MLO_FLOAT_C(17568.689935),
    MLO_FLOAT_C(17584.0421486),
    MLO_FLOAT_C(17599.3977138),
    MLO_FLOAT_C(17614.7566293),
    MLO_FLOAT_C(17630.1188934),
    MLO_FLOAT_C(17645.4845048),
    MLO_FLOAT_C(17660.8534621),
    MLO_FLOAT_C(17676.2257636),
    MLO_FLOAT_C(17691.6014081),
    MLO_FLOAT_C(17706.980394),
    MLO_FLOAT_C(17722.3627199),
    MLO_FLOAT_C(17737.7483844),
    MLO_FLOAT_C(17753.1373859),
    MLO_FLOAT_C(17768.5297231),
    MLO_FLOAT_C(17783.9253945),
    MLO_FLOAT_C(17799.3243986),
    MLO_FLOAT_C(17814.7267341),
    MLO_FLOAT_C(17830.1323994),
    MLO_FLOAT_C(17845.5413932),
    MLO_FLOAT_C(17860.953714),
    MLO_FLOAT_C(17876.3693603),
    MLO_FLOAT_C(17891.7883307),
    MLO_FLOAT_C(17907.2106239),
    MLO_FLOAT_C(17922.6362383),
    MLO_FLOAT_C(17938.0651726),
    MLO_FLOAT_C(17953.4974252),
    MLO_FLOAT_C(17968.9329949),
    MLO_FLOAT_C(17984.3718801),
    MLO_FLOAT_C(17999.8140794),
    MLO_FLOAT_C(18015.2595915),
    MLO_FLOAT_C(18030.7084148),
    MLO_FLOAT_C(18046.160548),
    MLO_FLOAT_C(18061.6159896),
    MLO_FLOAT_C(18077.0747383),
    MLO_FLOAT_C(18092.5367927),
    MLO_FLOAT_C(18108.0021512),
    MLO_FLOAT_C(18123.4708125),
    MLO_FLOAT_C(18138.9427752),
    MLO_FLOAT_C(18154.4180379),
    MLO_FLOAT_C(18169.8965992),
    MLO_FLOAT_C(18185.3784577),
    MLO_FLOAT_C(18200.8636119),
    MLO_FLOAT_C(18216.3520605),
    MLO_FLOAT_C(18231.843802),
    MLO_FLOAT_C(18247.3388351),
    MLO_FLOAT_C(18262.8371584),
    MLO_FLOAT_C(18278.3387704),
    MLO_FLOAT_C(18293.8436698),
    MLO_FLOAT_C(18309.3518552),
    MLO_FLOAT_C(18324.8633252),
    MLO_FLOAT_C(18340.3780784),
    MLO_FLOAT_C(18355.8961133),
    MLO_FLOAT_C(18371.4174287),
    MLO_FLOAT_C(18386.9420232),
    MLO_FLOAT_C(18402.4698953),
    MLO_FLOAT_C(18418.0010436),
    MLO_FLOAT_C(18433.5354669),
    MLO_FLOAT_C(18449.0731637),
    MLO_FLOAT_C(18464.6141325),
    MLO_FLOAT_C(18480.1583722),
    MLO_FLOAT_C(18495.7058812),
    MLO_FLOAT_C(18511.2566582),
    MLO_FLOAT_C(18526.8107018),
    MLO_FLOAT_C(18542.3680107),
    MLO_FLOAT_C(18557.9285835),
    MLO_FLOAT_C(18573.4924188),
    MLO_FLOAT_C(18589.0595152),
    MLO_FLOAT_C(18604.6298715),
    MLO_FLOAT_C(18620.2034861),
    MLO_FLOAT_C(18635.7803578),
    MLO_FLOAT_C(18651.3604852),
    MLO_FLOAT_C(18666.9438669),
    MLO_FLOAT_C(18682.5305016),
    MLO_FLOAT_C(18698.120388),
    MLO_FLOAT_C(18713.7135246),
    MLO_FLOAT_C(18729.3099101),
    MLO_FLOAT_C(18744.9095431),
    MLO_FLOAT_C(18760.5124224),
    MLO_FLOAT_C(18776.1185465),
    MLO_FLOAT_C(18791.7279141),
    MLO_FLOAT_C(18807.3405239),
    MLO_FLOAT_C(18822.9563745),
    MLO_FLOAT_C(18838.5754645),
    MLO_FLOAT_C(18854.1977927),
    MLO_FLOAT_C(18869.8233577),
    MLO_FLOAT_C(18885.4521581),
    MLO_FLOAT_C(18901.0841926),
    MLO_FLOAT_C(18916.7194598),
    MLO_FLOAT_C(18932.3579585),
    MLO_FLOAT_C(18947.9996873),
    MLO_FLOAT_C(18963.6446449),
    MLO_FLOAT_C(18979.2928299),
    MLO_FLOAT_C(18994.9442409),
    MLO_FLOAT_C(19010.5988768),
    MLO_FLOAT_C(19026.2567361),
    MLO_FLOAT_C(19041.9178175),
    MLO_FLOAT_C(19057.5821197),
    MLO_FLOAT_C(19073.2496413),
    MLO_FLOAT_C(19088.9203811),
    MLO_FLOAT_C(19104.5943377),
    MLO_FLOAT_C(19120.2715098),
    MLO_FLOAT_C(19135.9518961),
    MLO_FLOAT_C(19151.6354953),
    MLO_FLOAT_C(19167.322306),
    MLO_FLOAT_C(19183.012327),
    MLO_FLOAT_C(19198.7055568),
    MLO_FLOAT_C(19214.4019943),
    MLO_FLOAT_C(19230.1016381),
    MLO_FLOAT_C(19245.8044869),
    MLO_FLOAT_C(19261.5105393),
    MLO_FLOAT_C(19277.2197941),
    MLO_FLOAT_C(19292.93225),
    MLO_FLOAT_C(19308.6479057),
    MLO_FLOAT_C(19324.3667598),
    MLO_FLOAT_C(19340.0888111),
    MLO_FLOAT_C(19355.8140583),
    MLO_FLOAT_C(19371.5425),
    MLO_FLOAT_C(19387.274135),
    MLO_FLOAT_C(19403.0089619),
    MLO_FLOAT_C(19418.7469796),
    MLO_FLOAT_C(19434.4881866),
    MLO_FLOAT_C(19450.2325817),
    MLO_FLOAT_C(19465.9801636),
    MLO_FLOAT_C(19481.7309311),
    MLO_FLOAT_C(19497.4848827),
    MLO_FLOAT_C(19513.2420173),
    MLO_FLOAT_C(19529.0023336),
    MLO_FLOAT_C(19544.7658302),
    MLO_FLOAT_C(19560.5325059),
    MLO_FLOAT_C(19576.3023594),
    MLO_FLOAT_C(19592.0753894),
    MLO_FLOAT_C(19607.8515947),
    MLO_FLOAT_C(19623.6309739),
    MLO_FLOAT_C(19639.4135259),
    MLO_FLOAT_C(19655.1992492),
    MLO_FLOAT_C(19670.9881427),
    MLO_FLOAT_C(19686.7802051),
    MLO_FLOAT_C(19702.575435),
    MLO_FLOAT_C(19718.3738313),
    MLO_FLOAT_C(19734.1753927),
    MLO_FLOAT_C(19749.9801178),
    MLO_FLOAT_C(19765.7880055),
    MLO_FLOAT_C(19781.5990544),
    MLO_FLOAT_C(19797.4132633),
    MLO_FLOAT_C(19813.230631),
    MLO_FLOAT_C(19829.0511561),
    MLO_FLOAT_C(19844.8748375),
    MLO_FLOAT_C(19860.7016738),
    MLO_FLOAT_C(19876.5316638),
    MLO_FLOAT_C(19892.3648063),
    MLO_FLOAT_C(19908.2010999),
    MLO_FLOAT_C(19924.0405435),
    MLO_FLOAT_C(19939.8831357),
    MLO_FLOAT_C(19955.7288754),
    MLO_FLOAT_C(19971.5777613),
    MLO_FLOAT_C(19987.4297921),
    MLO_FLOAT_C(20003.2849666),
    MLO_FLOAT_C(20019.1432835),
    MLO_FLOAT_C(20035.0047416),
    MLO_FLOAT_C(20050.8693397),
    MLO_FLOAT_C(20066.7370764),
    MLO_FLOAT_C(20082.6079507),
    MLO_FLOAT_C(20098.4819612),
    MLO_FLOAT_C(20114.3591066),
    MLO_FLOAT_C(20130.2393858),
    MLO_FLOAT_C(20146.1227975),
    MLO_FLOAT_C(20162.0093405),
    MLO_FLOAT_C(20177.8990136),
    MLO_FLOAT_C(20193.7918154),
    MLO_FLOAT_C(20209.6877449),
    MLO_FLOAT_C(20225.5868007),
    MLO_FLOAT_C(20241.4889816),
    MLO_FLOAT_C(20257.3942864),
    MLO_FLOAT_C(20273.3027139),
    MLO_FLOAT_C(20289.2142628),
    MLO_FLOAT_C(20305.1289319),
    MLO_FLOAT_C(20321.04672),
    MLO_FLOAT_C(20336.9676259),
    MLO_FLOAT_C(20352.8916484),
    MLO_FLOAT_C(20368.8187862),
    MLO_FLOAT_C(20384.749038),
    MLO_FLOAT_C(20400.6824028),
    MLO_FLOAT_C(20416.6188793),
    MLO_FLOAT_C(20432.5584663),
    MLO_FLOAT_C(20448.5011625),
    MLO_FLOAT_C(20464.4469667),
    MLO_FLOAT_C(20480.3958778),
    MLO_FLOAT_C(20496.3478945),
    MLO_FLOAT_C(20512.3030156),
    MLO_FLOAT_C(20528.2612399),
    MLO_FLOAT_C(20544.2225662),
    MLO_FLOAT_C(20560.1869932),
    MLO_FLOAT_C(20576.1545199),
    MLO_FLOAT_C(20592.125145),
    MLO_FLOAT_C(20608.0988672),
    MLO_FLOAT_C(20624.0756855),
    MLO_FLOAT_C(20640.0555985),
    MLO_FLOAT_C(20656.0386051),
    MLO_FLOAT_C(20672.0247041),
    MLO_FLOAT_C(20688.0138943),
    MLO_FLOAT_C(20704.0061744),
    MLO_FLOAT_C(20720.0015434),
    MLO_FLOAT_C(20736.0),
    MLO_FLOAT_C(20752.001543),
    MLO_FLOAT_C(20768.0061713),
    MLO_FLOAT_C(20784.0138835),
    MLO_FLOAT_C(20800.0246787),
    MLO_FLOAT_C(20816.0385555),
    MLO_FLOAT_C(20832.0555128),
    MLO_FLOAT_C(20848.0755493),
    MLO_FLOAT_C(20864.098664),
    MLO_FLOAT_C(20880.1248556),
    MLO_FLOAT_C(20896.154123),
    MLO_FLOAT_C(20912.1864649),
    MLO_FLOAT_C(20928.2218803),
    MLO_FLOAT_C(20944.2603678),
    MLO_FLOAT_C(20960.3019264),
    MLO_FLOAT_C(20976.3465548),
    MLO_FLOAT_C(20992.394252),
    MLO_FLOAT_C(21008.4450166),
    MLO_FLOAT_C(21024.4988476),
    MLO_FLOAT_C(21040.5557437),
    MLO_FLOAT_C(21056.6157039),
    MLO_FLOAT_C(21072.6787269),
    MLO_FLOAT_C(21088.7448115),
    MLO_FLOAT_C(21104.8139567),
    MLO_FLOAT_C(21120.8861612),
    MLO_FLOAT_C(21136.9614238),
    MLO_FLOAT_C(21153.0397435),
    MLO_FLOAT_C(21169.121119),
    MLO_FLOAT_C(21185.2055492),
    MLO_FLOAT_C(21201.2930329),
    MLO_FLOAT_C(21217.3835689),
    MLO_FLOAT_C(21233.4771562),
    MLO_FLOAT_C(21249.5737935),
    MLO_FLOAT_C(21265.6734797),
    MLO_FLOAT_C(21281.7762137),
    MLO_FLOAT_C(21297.8819943),
    MLO_FLOAT_C(21313.9908202),
    MLO_FLOAT_C(21330.1026905),
    MLO_FLOAT_C(21346.2176039),
    MLO_FLOAT_C(21362.3355593),
    MLO_FLOAT_C(21378.4565555),
    MLO_FLOAT_C(21394.5805914),
    MLO_FLOAT_C(21410.7076659),
    MLO_FLOAT_C(21426.8377777),
    MLO_FLOAT_C(21442.9709258),
    MLO_FLOAT_C(21459.1071091),
    MLO_FLOAT_C(21475.2463263),
    MLO_FLOAT_C(21491.3885763),
    MLO_FLOAT_C(21507.533858),
    MLO_FLOAT_C(21523.6821703),
    MLO_FLOAT_C(21539.833512),
    MLO_FLOAT_C(21555.987882),
    MLO_FLOAT_C(21572.1452791),
    MLO_FLOAT_C(21588.3057022),
    MLO_FLOAT_C(21604.4691502),
    MLO_FLOAT_C(21620.635622),
    MLO_FLOAT_C(21636.8051164),
    MLO_FLOAT_C(21652.9776323),
    MLO_FLOAT_C(21669.1531685),
    MLO_FLOAT_C(21685.331724),
    MLO_FLOAT_C(21701.5132975),
    MLO_FLOAT_C(21717.6978881),
    MLO_FLOAT_C(21733.8854945),
    MLO_FLOAT_C(21750.0761157),
    MLO_FLOAT_C(21766.2697504),
    MLO_FLOAT_C(21782.4663976),
    MLO_FLOAT_C(21798.6660563),
    MLO_FLOAT_C(21814.8687251),
    MLO_FLOAT_C(21831.0744031),
    MLO_FLOAT_C(21847.2830891),
    MLO_FLOAT_C(21863.494782),
    MLO_FLOAT_C(21879.7094807),
    MLO_FLOAT_C(21895.9271841),
    MLO_FLOAT_C(21912.147891),
    MLO_FLOAT_C(21928.3716003),
    MLO_FLOAT_C(21944.598311),
    MLO_FLOAT_C(21960.8280219),
    MLO_FLOAT_C(21977.060732),
    MLO_FLOAT_C(21993.29644),
    MLO_FLOAT_C(22009.535145),
    MLO_FLOAT_C(22025.7768457),
    MLO_FLOAT_C(22042.0215411),
    MLO_FLOAT_C(22058.2692301),
    MLO_FLOAT_C(22074.5199116),
    MLO_FLOAT_C(22090.7735845),
    MLO_FLOAT_C(22107.0302477),
    MLO_FLOAT_C(22123.2899),
    MLO_FLOAT_C(22139.5525404),
    MLO_FLOAT_C(22155.8181678),
    MLO_FLOAT_C(22172.0867811),
    MLO_FLOAT_C(22188.3583792),
    MLO_FLOAT_C(22204.632961),
    MLO_FLOAT_C(22220.9105254),
    MLO_FLOAT_C(22237.1910713),
    MLO_FLOAT_C(22253.4745976),
    MLO_FLOAT_C(22269.7611033),
    MLO_FLOAT_C(22286.0505872),
    MLO_FLOAT_C(22302.3430482),
    MLO_FLOAT_C(22318.6384853),
    MLO_FLOAT_C(22334.9368974),
    MLO_FLOAT_C(22351.2382834),
    MLO_FLOAT_C(22367.5426422),
    MLO_FLOAT_C(22383.8499727),
    MLO_FLOAT_C(22400.1602738),
    MLO_FLOAT_C(22416.4735445),
    MLO_FLOAT_C(22432.7897837),
    MLO_FLOAT_C(22449.1089903),
    MLO_FLOAT_C(22465.4311632),
    MLO_FLOAT_C(22481.7563014),
    MLO_FLOAT_C(22498.0844037),
    MLO_FLOAT_C(22514.4154691),
    MLO_FLOAT_C(22530.7494965),
    MLO_FLOAT_C(22547.0864848),
    MLO_FLOAT_C(22563.4264331),
    MLO_FLOAT_C(22579.7693401),
    MLO_FLOAT_C(22596.1152048),
    MLO_FLOAT_C(22612.4640262),
    MLO_FLOAT_C(22628.8158032),
    MLO_FLOAT_C(22645.1705347),
    MLO_FLOAT_C(22661.5282197),
    MLO_FLOAT_C(22677.888857),
    MLO_FLOAT_C(22694.2524456),
    MLO_FLOAT_C(22710.6189846),
    MLO_FLOAT_C(22726.9884727),
    MLO_FLOAT_C(22743.3609089),
    MLO_FLOAT_C(22759.7362922),
    MLO_FLOAT_C(22776.1146215),
    MLO_FLOAT_C(22792.4958957),
    MLO_FLOAT_C(22808.8801139),
    MLO_FLOAT_C(22825.2672749),
    MLO_FLOAT_C(22841.6573776),
    MLO_FLOAT_C(22858.0504211),
    MLO_FLOAT_C(22874.4464042),
    MLO_FLOAT_C(22890.845326),
    MLO_FLOAT_C(22907.2471853),
    MLO_FLOAT_C(22923.6519811),
    MLO_FLOAT_C(22940.0597124),
    MLO_FLOAT_C(22956.4703781),
    MLO_FLOAT_C(22972.8839771),
    MLO_FLOAT_C(22989.3005084),
    MLO_FLOAT_C(23005.719971),
    MLO_FLOAT_C(23022.1423639),
    MLO_FLOAT_C(23038.5676859),
    MLO_FLOAT_C(23054.995936),
    MLO_FLOAT_C(23071.4271132),
    MLO_FLOAT_C(23087.8612164),
    MLO_FLOAT_C(23104.2982447),
    MLO_FLOAT_C(23120.7381968),
    MLO_FLOAT_C(23137.181072),
    MLO_FLOAT_C(23153.626869),
    MLO_FLOAT_C(23170.0755868),
    MLO_FLOAT_C(23186.5272244),
    MLO_FLOAT_C(23202.9817808),
    MLO_FLOAT_C(23219.439255),
    MLO_FLOAT_C(23235.8996458),
    MLO_FLOAT_C(23252.3629523),
    MLO_FLOAT_C(23268.8291735),
    MLO_FLOAT_C(23285.2983082),
    MLO_FLOAT_C(23301.7703555),
    MLO_FLOAT_C(23318.2453144),
    MLO_FLOAT_C(23334.7231837),
    MLO_FLOAT_C(23351.2039626),
    MLO_FLOAT_C(23367.6876499),
    MLO_FLOAT_C(23384.1742447),
    MLO_FLOAT_C(23400.6637458),
    MLO_FLOAT_C(23417.1561523),
    MLO_FLOAT_C(23433.6514632),
    MLO_FLOAT_C(23450.1496775),
    MLO_FLOAT_C(23466.650794),
    MLO_FLOAT_C(23483.1548119),
    MLO_FLOAT_C(23499.66173),
    MLO_FLOAT_C(23516.1715474),
    MLO_FLOAT_C(23532.684263),
    MLO_FLOAT_C(23549.1998758),
    MLO_FLOAT_C(23565.7183849),
    MLO_FLOAT_C(23582.2397891),
    MLO_FLOAT_C(23598.7640875),
    MLO_FLOAT_C(23615.2912791),
    MLO_FLOAT_C(23631.8213628),
    MLO_FLOAT_C(23648.3543376),
    MLO_FLOAT_C(23664.8902026),
    MLO_FLOAT_C(23681.4289567),
    MLO_FLOAT_C(23697.970599),
    MLO_FLOAT_C(23714.5151283),
    MLO_FLOAT_C(23731.0625437),
    MLO_FLOAT_C(23747.6128442),
    MLO_FLOAT_C(23764.1660288),
    MLO_FLOAT_C(23780.7220964),
    MLO_FLOAT_C(23797.2810461),
    MLO_FLOAT_C(23813.8428769),
    MLO_FLOAT_C(23830.4075878),
    MLO_FLOAT_C(23846.9751777),
    MLO_FLOAT_C(23863.5456457),
    MLO_FLOAT_C(23880.1189908),
    MLO_FLOAT_C(23896.6952119),
    MLO_FLOAT_C(23913.2743081),
    MLO_FLOAT_C(23929.8562784),
    MLO_FLOAT_C(23946.4411218),
    MLO_FLOAT_C(23963.0288372),
    MLO_FLOAT_C(23979.6194237),
    MLO_FLOAT_C(23996.2128804),
    MLO_FLOAT_C(24012.8092061),
    MLO_FLOAT_C(24029.4083999),
    MLO_FLOAT_C(24046.0104609),
    MLO_FLOAT_C(24062.615388),
    MLO_FLOAT_C(24079.2231802),
    MLO_FLOAT_C(24095.8338366),
    MLO_FLOAT_C(24112.4473561),
    MLO_FLOAT_C(24129.0637379),
    MLO_FLOAT_C(24145.6829808),
    MLO_FLOAT_C(24162.3050839),
    MLO_FLOAT_C(24178.9300463),
    MLO_FLOAT_C(24195.5578669),
    MLO_FLOAT_C(24212.1885448),
    MLO_FLOAT_C(24228.8220789),
    MLO_FLOAT_C(24245.4584683),
    MLO_FLOAT_C(24262.0977121),
    MLO_FLOAT_C(24278.7398092),
    MLO_FLOAT_C(24295.3847586),
    MLO_FLOAT_C(24312.0325595),
    MLO_FLOAT_C(24328.6832107),
    MLO_FLOAT_C(24345.3367114),
    MLO_FLOAT_C(24361.9930605),
    MLO_FLOAT_C(24378.6522571),
    MLO_FLOAT_C(24395.3143002),
    MLO_FLOAT_C(24411.9791889),
    MLO_FLOAT_C(24428.6469221),
    MLO_FLOAT_C(24445.3174989),
    MLO_FLOAT_C(24461.9909184),
    MLO_FLOAT_C(24478.6671795),
    MLO_FLOAT_C(24495.3462813),
    MLO_FLOAT_C(24512.0282228),
    MLO_FLOAT_C(24528.713003),
    MLO_FLOAT_C(24545.4006211),
    MLO_FLOAT_C(24562.091076),
    MLO_FLOAT_C(24578.7843667),
    MLO_FLOAT_C(24595.4804924),
    MLO_FLOAT_C(24612.1794519),
    MLO_FLOAT_C(24628.8812445),
    MLO_FLOAT_C(24645.585869),
    MLO_FLOAT_C(24662.2933246),
    MLO_FLOAT_C(24679.0036103),
    MLO_FLOAT_C(24695.7167252),
    MLO_FLOAT_C(24712.4326682),
    MLO_FLOAT_C(24729.1514384),
    MLO_FLOAT_C(24745.8730349),
    MLO_FLOAT_C(24762.5974568),
    MLO_FLOAT_C(24779.3247029),
    MLO_FLOAT_C(24796.0547725),
    MLO_FLOAT_C(24812.7876645),
    MLO_FLOAT_C(24829.523378),
    MLO_FLOAT_C(24846.2619121),
    MLO_FLOAT_C(24863.0032657),
    MLO_FLOAT_C(24879.7474381),
    MLO_FLOAT_C(24896.4944281),
    MLO_FLOAT_C(24913.2442348),
    MLO_FLOAT_C(24929.9968574),
    MLO_FLOAT_C(24946.7522948),
    MLO_FLOAT_C(24963.5105461),
    MLO_FLOAT_C(24980.2716104),
    MLO_FLOAT_C(24997.0354867),
    MLO_FLOAT_C(25013.8021741),
    MLO_FLOAT_C(25030.5716717),
    MLO_FLOAT_C(25047.3439784),
    MLO_FLOAT_C(25064.1190934),
    MLO_FLOAT_C(25080.8970157),
    MLO_FLOAT_C(25097.6777444),
    MLO_FLOAT_C(25114.4612785),
    MLO_FLOAT_C(25131.2476171),
    MLO_FLOAT_C(25148.0367593),
    MLO_FLOAT_C(25164.8287041),
    MLO_FLOAT_C(25181.6234506),
    MLO_FLOAT_C(25198.4209979),
    MLO_FLOAT_C(25215.221345),
    MLO_FLOAT_C(25232.024491),
    MLO_FLOAT_C(25248.8304349),
    MLO_FLOAT_C(25265.6391759),
    MLO_FLOAT_C(25282.4507129),
    MLO_FLOAT_C(25299.2650452),
    MLO_FLOAT_C(25316.0821716),
    MLO_FLOAT_C(25332.9020914),
    MLO_FLOAT_C(25349.7248036),
    MLO_FLOAT_C(25366.5503072),
    MLO_FLOAT_C(25383.3786014),
    MLO_FLOAT_C(25400.2096851),
    MLO_FLOAT_C(25417.0435576),
    MLO_FLOAT_C(25433.8802178),
    MLO_FLOAT_C(25450.7196648),
    MLO_FLOAT_C(25467.5618978),
    MLO_FLOAT_C(25484.4069157),
    MLO_FLOAT_C(25501.2547177),
    MLO_FLOAT_C(25518.1053028),
    MLO_FLOAT_C(25534.9586702),
    MLO_FLOAT_C(25551.8148189),
    MLO_FLOAT_C(25568.673748),
    MLO_FLOAT_C(25585.5354566),
    MLO_FLOAT_C(25602.3999438),
    MLO_FLOAT_C(25619.2672085),
    MLO_FLOAT_C(25636.1372501),
    MLO_FLOAT_C(25653.0100674),
    MLO_FLOAT_C(25669.8856596),
    MLO_FLOAT_C(25686.7640259),
    MLO_FLOAT_C(25703.6451652),
    MLO_FLOAT_C(25720.5290767),
    MLO_FLOAT_C(25737.4157595),
    MLO_FLOAT_C(25754.3052126),
    MLO_FLOAT_C(25771.1974351),
    MLO_FLOAT_C(25788.0924262),
    MLO_FLOAT_C(25804.9901849),
    MLO_FLOAT_C(25821.8907104),
    MLO_FLOAT_C(25838.7940016),
    MLO_FLOAT_C(25855.7000578),
    MLO_FLOAT_C(25872.608878),
    MLO_FLOAT_C(25889.5204613),
    MLO_FLOAT_C(25906.4348067),
    MLO_FLOAT_C(25923.3519135),
    MLO_FLOAT_C(25940.2717807),
    MLO_FLOAT_C(25957.1944074),
    MLO_FLOAT_C(25974.1197927),
    MLO_FLOAT_C(25991.0479357),
    MLO_FLOAT_C(26007.9788354),
    MLO_FLOAT_C(26024.9124911),
    MLO_FLOAT_C(26041.8489018),
    MLO_FLOAT_C(26058.7880666),
    MLO_FLOAT_C(26075.7299847),
    MLO_FLOAT_C(26092.674655),
    MLO_FLOAT_C(26109.6220768),
    MLO_FLOAT_C(26126.5722491),
    MLO_FLOAT_C(26143.5251711),
    MLO_FLOAT_C(26160.4808418),
    MLO_FLOAT_C(26177.4392603),
    MLO_FLOAT_C(26194.4004259),
    MLO_FLOAT_C(26211.3643375),
    MLO_FLOAT_C(26228.3309943),
    MLO_FLOAT_C(26245.3003954),
    MLO_FLOAT_C(26262.2725399),
    MLO_FLOAT_C(26279.247427),
    MLO_FLOAT_C(26296.2250557),
    MLO_FLOAT_C(26313.2054252),
    MLO_FLOAT_C(26330.1885345),
    MLO_FLOAT_C(26347.1743828),
    MLO_FLOAT_C(26364.1629693),
    MLO_FLOAT_C(26381.1542929),
    MLO_FLOAT_C(26398.1483529),
    MLO_FLOAT_C(26415.1451484),
    MLO_FLOAT_C(26432.1446784),
    MLO_FLOAT_C(26449.1469422),
    MLO_FLOAT_C(26466.1519387),
    MLO_FLOAT_C(26483.1596673),
    MLO_FLOAT_C(26500.1701268),
    MLO_FLOAT_C(26517.1833166),
    MLO_FLOAT_C(26534.1992357),
    MLO_FLOAT_C(26551.2178833),
    MLO_FLOAT_C(26568.2392584),
    MLO_FLOAT_C(26585.2633602),
    MLO_FLOAT_C(26602.2901878),
    MLO_FLOAT_C(26619.3197403),
    MLO_FLOAT_C(26636.352017),
    MLO_FLOAT_C(26653.3870168),
    MLO_FLOAT_C(26670.424739),
    MLO_FLOAT_C(26687.4651826),
    MLO_FLOAT_C(26704.5083468),
    MLO_FLOAT_C(26721.5542308),
    MLO_FLOAT_C(26738.6028336),
    MLO_FLOAT_C(26755.6541544),
    MLO_FLOAT_C(26772.7081923),
    MLO_FLOAT_C(26789.7649465),
    MLO_FLOAT_C(26806.8244161),
    MLO_FLOAT_C(26823.8866002),
    MLO_FLOAT_C(26840.951498),
    MLO_FLOAT_C(26858.0191086),
    MLO_FLOAT_C(26875.0894311),
    MLO_FLOAT_C(26892.1624647),
    MLO_FLOAT_C(26909.2382086),
    MLO_FLOAT_C(26926.3166618),
    MLO_FLOAT_C(26943.3978235),
    MLO_FLOAT_C(26960.4816928),
    MLO_FLOAT_C(26977.5682689),
    MLO_FLOAT_C(26994.657551),
    MLO_FLOAT_C(27011.7495381),
    MLO_FLOAT_C(27028.8442294),
    MLO_FLOAT_C(27045.9416241),
    MLO_FLOAT_C(27063.0417213),
    MLO_FLOAT_C(27080.1445202),
    MLO_FLOAT_C(27097.2500198),
    MLO_FLOAT_C(27114.3582194),
    MLO_FLOAT_C(27131.4691181),
    MLO_FLOAT_C(27148.582715),
    MLO_FLOAT_C(27165.6990093),
    MLO_FLOAT_C(27182.8180002),
    MLO_FLOAT_C(27199.9396867),
    MLO_FLOAT_C(27217.0640681),
    MLO_FLOAT_C(27234.1911435),
    MLO_FLOAT_C(27251.320912),
    MLO_FLOAT_C(27268.4533729),
    MLO_FLOAT_C(27285.5885252),
    MLO_FLOAT_C(27302.7263681),
    MLO_FLOAT_C(27319.8669007),
    MLO_FLOAT_C(27337.0101223),
    MLO_FLOAT_C(27354.156032),
    MLO_FLOAT_C(27371.3046289),
    MLO_FLOAT_C(27388.4559122),
    MLO_FLOAT_C(27405.6098811),
    MLO_FLOAT_C(27422.7665346),
    MLO_FLOAT_C(27439.9258721),
    MLO_FLOAT_C(27457.0878925),
    MLO_FLOAT_C(27474.2525952),
    MLO_FLOAT_C(27491.4199792),
    MLO_FLOAT_C(27508.5900438),
    MLO_FLOAT_C(27525.762788),
    MLO_FLOAT_C(27542.9382111),
    MLO_FLOAT_C(27560.1163121),
    MLO_FLOAT_C(27577.2970904),
    MLO_FLOAT_C(27594.480545),
    MLO_FLOAT_C(27611.6666751),
    MLO_FLOAT_C(27628.8554799),
    MLO_FLOAT_C(27646.0469585),
    MLO_FLOAT_C(27663.2411102),
    MLO_FLOAT_C(27680.437934),
    MLO_FLOAT_C(27697.6374292),
    MLO_FLOAT_C(27714.8395949),
    MLO_FLOAT_C(27732.0444302),
    MLO_FLOAT_C(27749.2519345),
    MLO_FLOAT_C(27766.4621068),
    MLO_FLOAT_C(27783.6749463),
    MLO_FLOAT_C(27800.8904522),
    MLO_FLOAT_C(27818.1086236),
    MLO_FLOAT_C(27835.3294598),
    MLO_FLOAT_C(27852.5529599),
    MLO_FLOAT_C(27869.779123),
    MLO_FLOAT_C(27887.0079485),
    MLO_FLOAT_C(27904.2394353),
    MLO_FLOAT_C(27921.4735828),
    MLO_FLOAT_C(27938.7103901),
    MLO_FLOAT_C(27955.9498564),
    MLO_FLOAT_C(27973.1919808),
    MLO_FLOAT_C(27990.4367625),
    MLO_FLOAT_C(28007.6842008),
    MLO_FLOAT_C(28024.9342947),
    MLO_FLOAT_C(28042.1870436),
    MLO_FLOAT_C(28059.4424465),
    MLO_FLOAT_C(28076.7005027),
    MLO_FLOAT_C(28093.9612113),
    MLO_FLOAT_C(28111.2245715),
    MLO_FLOAT_C(28128.4905825),
    MLO_FLOAT_C(28145.7592435),
    MLO_FLOAT_C(28163.0305537),
    MLO_FLOAT_C(28180.3045122),
    MLO_FLOAT_C(28197.5811183),
    MLO_FLOAT_C(28214.8603712),
    MLO_FLOAT_C(28232.1422699),
    MLO_FLOAT_C(28249.4268138),
    MLO_FLOAT_C(28266.714002),
    MLO_FLOAT_C(28284.0038337),
    MLO_FLOAT_C(28301.2963082),
    MLO_FLOAT_C(28318.5914244),
    MLO_FLOAT_C(28335.8891818),
    MLO_FLOAT_C(28353.1895795),
    MLO_FLOAT_C(28370.4926166),
    MLO_FLOAT_C(28387.7982924),
    MLO_FLOAT_C(28405.106606),
    MLO_FLOAT_C(28422.4175567),
    MLO_FLOAT_C(28439.7311436),
    MLO_FLOAT_C(28457.047366),
    MLO_FLOAT_C(28474.3662231),
    MLO_FLOAT_C(28491.687714),
    MLO_FLOAT_C(28509.0118379),
    MLO_FLOAT_C(28526.3385941),
    MLO_FLOAT_C(28543.6679817),
    MLO_FLOAT_C(28561.0),
    MLO_FLOAT_C(28578.3346481),
    MLO_FLOAT_C(28595.6719253),
    MLO_FLOAT_C(28613.0118307),
    MLO_FLOAT_C(28630.3543636),
    MLO_FLOAT_C(28647.6995232),
    MLO_FLOAT_C(28665.0473086),
    MLO_FLOAT_C(28682.3977191),
    MLO_FLOAT_C(28699.7507538),
    MLO_FLOAT_C(28717.1064121),
    MLO_FLOAT_C(28734.464693),
    MLO_FLOAT_C(28751.8255959),
    MLO_FLOAT_C(28769.1891198),
    MLO_FLOAT_C(28786.5552641),
    MLO_FLOAT_C(28803.9240279),
    MLO_FLOAT_C(28821.2954104),
    MLO_FLOAT_C(28838.6694108),
    MLO_FLOAT_C(28856.0460285),
    MLO_FLOAT_C(28873.4252625),
    MLO_FLOAT_C(28890.8071121),
    MLO_FLOAT_C(28908.1915764),
    MLO_FLOAT_C(28925.5786548),
    MLO_FLOAT_C(28942.9683464),
    MLO_FLOAT_C(28960.3606505),
    MLO_FLOAT_C(28977.7555662),
    MLO_FLOAT_C(28995.1530927),
    MLO_FLOAT_C(29012.5532294),
    MLO_FLOAT_C(29029.9559753),
    MLO_FLOAT_C(29047.3613298),
    MLO_FLOAT_C(29064.769292),
    MLO_FLOAT_C(29082.1798612),
    MLO_FLOAT_C(29099.5930365),
    MLO_FLOAT_C(29117.0088173),
    MLO_FLOAT_C(29134.4272026),
    MLO_FLOAT_C(29151.8481919),
    MLO_FLOAT_C(29169.2717841),
    MLO_FLOAT_C(29186.6979787),
    MLO_FLOAT_C(29204.1267747),
    MLO_FLOAT_C(29221.5581715),
    MLO_FLOAT_C(29238.9921683),
    MLO_FLOAT_C(29256.4287642),
    MLO_FLOAT_C(29273.8679585),
    MLO_FLOAT_C(29291.3097505),
    MLO_FLOAT_C(29308.7541393),
    MLO_FLOAT_C(29326.2011242),
    MLO_FLOAT_C(29343.6507044),
    MLO_FLOAT_C(29361.1028792),
    MLO_FLOAT_C(29378.5576477),
    MLO_FLOAT_C(29396.0150092),
    MLO_FLOAT_C(29413.474963),
    MLO_FLOAT_C(29430.9375082),
    MLO_FLOAT_C(29448.4026441),
    MLO_FLOAT_C(29465.8703699),
    MLO_FLOAT_C(29483.3406849),
    MLO_FLOAT_C(29500.8135882),
    MLO_FLOAT_C(29518.2890792),
    MLO_FLOAT_C(29535.767157),
    MLO_FLOAT_C(29553.2478209),
    MLO_FLOAT_C(29570.7310702),
    MLO_FLOAT_C(29588.216904),
    MLO_FLOAT_C(29605.7053216),
    MLO_FLOAT_C(29623.1963222),
    MLO_FLOAT_C(29640.6899051),
    MLO_FLOAT_C(29658.1860695),
    MLO_FLOAT_C(29675.6848147),
    MLO_FLOAT_C(29693.1861398),
    MLO_FLOAT_C(29710.6900442),
    MLO_FLOAT_C(29728.196527),
    MLO_FLOAT_C(29745.7055876),
    MLO_FLOAT_C(29763.217225),
    MLO_FLOAT_C(29780.7314387),
    MLO_FLOAT_C(29798.2482278),
    MLO_FLOAT_C(29815.7675916),
    MLO_FLOAT_C(29833.2895293),
    MLO_FLOAT_C(29850.8140401),
    MLO_FLOAT_C(29868.3411234),
    MLO_FLOAT_C(29885.8707783),
    MLO_FLOAT_C(29903.4030041),
    MLO_FLOAT_C(29920.9378),
    MLO_FLOAT_C(29938.4751653),
    MLO_FLOAT_C(29956.0150993),
    MLO_FLOAT_C(29973.5576011),
    MLO_FLOAT_C(29991.1026701),
    MLO_FLOAT_C(30008.6503055),
    MLO_FLOAT_C(30026.2005065),
    MLO_FLOAT_C(30043.7532724),
    MLO_FLOAT_C(30061.3086024),
    MLO_FLOAT_C(30078.8664958),
    MLO_FLOAT_C(30096.4269518),
    MLO_FLOAT_C(30113.9899697),
    MLO_FLOAT_C(30131.5555488),
    MLO_FLOAT_C(30149.1236882),
    MLO_FLOAT_C(30166.6943873),
    MLO_FLOAT_C(30184.2676453),
    MLO_FLOAT_C(30201.8434615),
    MLO_FLOAT_C(30219.4218351),
    MLO_FLOAT_C(30237.0027653),
    MLO_FLOAT_C(30254.5862515),
    MLO_FLOAT_C(30272.1722928),
    MLO_FLOAT_C(30289.7608886),
    MLO_FLOAT_C(30307.3520381),
    MLO_FLOAT_C(30324.9457405),
    MLO_FLOAT_C(30342.5419952),
    MLO_FLOAT_C(30360.1408013),
    MLO_FLOAT_C(30377.7421582),
    MLO_FLOAT_C(30395.346065),
    MLO_FLOAT_C(30412.9525212),
    MLO_FLOAT_C(30430.5615258),
    MLO_FLOAT_C(30448.1730782),
    MLO_FLOAT_C(30465.7871777),
    MLO_FLOAT_C(30483.4038235),
    MLO_FLOAT_C(30501.0230149),
    MLO_FLOAT_C(30518.6447511),
    MLO_FLOAT_C(30536.2690314),
    MLO_FLOAT_C(30553.895855),
    MLO_FLOAT_C(30571.5252213),
    MLO_FLOAT_C(30589.1571296),
    MLO_FLOAT_C(30606.7915789),
    MLO_FLOAT_C(30624.4285688),
    MLO_FLOAT_C(30642.0680983),
    MLO_FLOAT_C(30659.7101668),
    MLO_FLOAT_C(30677.3547735),
    MLO_FLOAT_C(30695.0019178),
    MLO_FLOAT_C(30712.6515988),
    MLO_FLOAT_C(30730.3038159),
    MLO_FLOAT_C(30747.9585684),
    MLO_FLOAT_C(30765.6158554),
    MLO_FLOAT_C(30783.2756763),
    MLO_FLOAT_C(30800.9380303),
    MLO_FLOAT_C(30818.6029168),
    MLO_FLOAT_C(30836.270335),
    MLO_FLOAT_C(30853.9402841),
    MLO_FLOAT_C(30871.6127635),
    MLO_FLOAT_C(30889.2877723),
    MLO_FLOAT_C(30906.96531),
    MLO_FLOAT_C(30924.6453758),
    MLO_FLOAT_C(30942.3279689),
    MLO_FLOAT_C(30960.0130886),
    MLO_FLOAT_C(30977.7007342),
    MLO_FLOAT_C(30995.390905),
    MLO_FLOAT_C(31013.0836003),
    MLO_FLOAT_C(31030.7788193),
    MLO_FLOAT_C(31048.4765614),
    MLO_FLOAT_C(31066.1768257),
    MLO_FLOAT_C(31083.8796117),
    MLO_FLOAT_C(31101.5849185),
    MLO_FLOAT_C(31119.2927454),
    MLO_FLOAT_C(31137.0030918),
    MLO_FLOAT_C(31154.7159569),
    MLO_FLOAT_C(31172.43134),
    MLO_FLOAT_C(31190.1492403),
    MLO_FLOAT_C(31207.8696573),
    MLO_FLOAT_C(31225.5925901),
    MLO_FLOAT_C(31243.318038),
    MLO_FLOAT_C(31261.0460004),
    MLO_FLOAT_C(31278.7764765),
    MLO_FLOAT_C(31296.5094655),
    MLO_FLOAT_C(31314.2449669),
    MLO_FLOAT_C(31331.9829798),
    MLO_FLOAT_C(31349.7235037),
    MLO_FLOAT_C(31367.4665376),
    MLO_FLOAT_C(31385.212081),
    MLO_FLOAT_C(31402.9601332),
    MLO_FLOAT_C(31420.7106933),
    MLO_FLOAT_C(31438.4637608),
    MLO_FLOAT_C(31456.2193349),
    MLO_FLOAT_C(31473.9774149),
    MLO_FLOAT_C(31491.7380002),
    MLO_FLOAT_C(31509.5010898),
    MLO_FLOAT_C(31527.2666833),
    MLO_FLOAT_C(31545.0347799),
    MLO_FLOAT_C(31562.8053788),
    MLO_FLOAT_C(31580.5784794),
    MLO_FLOAT_C(31598.3540809),
    MLO_FLOAT_C(31616.1321828),
    MLO_FLOAT_C(31633.9127841),
    MLO_FLOAT_C(31651.6958844),
    MLO_FLOAT_C(31669.4814827),
    MLO_FLOAT_C(31687.2695786),
    MLO_FLOAT_C(31705.0601712),
    MLO_FLOAT_C(31722.8532598),
    MLO_FLOAT_C(31740.6488438),
    MLO_FLOAT_C(31758.4469224),
    MLO_FLOAT_C(31776.247495),
    MLO_FLOAT_C(31794.0505608),
    MLO_FLOAT_C(31811.8561192),
    MLO_FLOAT_C(31829.6641695),
    MLO_FLOAT_C(31847.4747109),
    MLO_FLOAT_C(31865.2877427),
    MLO_FLOAT_C(31883.1032644),
    MLO_FLOAT_C(31900.9212751),
    MLO_FLOAT_C(31918.7417741),
    MLO_FLOAT_C(31936.5647609),
    MLO_FLOAT_C(31954.3902346),
    MLO_FLOAT_C(31972.2181947),
    MLO_FLOAT_C(31990.0486403),
    MLO_FLOAT_C(32007.8815709),
    MLO_FLOAT_C(32025.7169856),
    MLO_FLOAT_C(32043.5548839),
    MLO_FLOAT_C(32061.395265),
    MLO_FLOAT_C(32079.2381283),
    MLO_FLOAT_C(32097.083473),
    MLO_FLOAT_C(32114.9312984),
    MLO_FLOAT_C(32132.7816039),
    MLO_FLOAT_C(32150.6343889),
    MLO_FLOAT_C(32168.4896525),
    MLO_FLOAT_C(32186.3473941),
    MLO_FLOAT_C(32204.207613),
    MLO_FLOAT_C(32222.0703086),
    MLO_FLOAT_C(32239.9354801),
    MLO_FLOAT_C(32257.8031268),
    MLO_FLOAT_C(32275.6732481),
    MLO_FLOAT_C(32293.5458434),
    MLO_FLOAT_C(32311.4209118),
    MLO_FLOAT_C(32329.2984527),
    MLO_FLOAT_C(32347.1784655),
    MLO_FLOAT_C(32365.0609494),
    MLO_FLOAT_C(32382.9459038),
    MLO_FLOAT_C(32400.833328),
    MLO_FLOAT_C(32418.7232213),
    MLO_FLOAT_C(32436.615583),
    MLO_FLOAT_C(32454.5104124),
    MLO_FLOAT_C(32472.4077089),
    MLO_FLOAT_C(32490.3074718),
    MLO_FLOAT_C(32508.2097004),
    MLO_FLOAT_C(32526.114394),
    MLO_FLOAT_C(32544.021552),
    MLO_FLOAT_C(32561.9311736),
    MLO_FLOAT_C(32579.8432582),
    MLO_FLOAT_C(32597.7578051),
    MLO_FLOAT_C(32615.6748137),
    MLO_FLOAT_C(32633.5942832),
    MLO_FLOAT_C(32651.516213),
    MLO_FLOAT_C(32669.4406024),
    MLO_FLOAT_C(32687.3674507),
    MLO_FLOAT_C(32705.2967573),
    MLO_FLOAT_C(32723.2285215),
    MLO_FLOAT_C(32741.1627426),
    MLO_FLOAT_C(32759.0994199),
    MLO_FLOAT_C(32777.0385528),
    MLO_FLOAT_C(32794.9801406),
    MLO_FLOAT_C(32812.9241826),
    MLO_FLOAT_C(32830.8706782),
    MLO_FLOAT_C(32848.8196267),
    MLO_FLOAT_C(32866.7710273),
    MLO_FLOAT_C(32884.7248795),
    MLO_FLOAT_C(32902.6811826),
    MLO_FLOAT_C(32920.6399358),
    MLO_FLOAT_C(32938.6011386),
    MLO_FLOAT_C(32956.5647903),
    MLO_FLOAT_C(32974.5308902),
    MLO_FLOAT_C(32992.4994375),
    MLO_FLOAT_C(33010.4704318),
    MLO_FLOAT_C(33028.4438723),
    MLO_FLOAT_C(33046.4197582),
    MLO_FLOAT_C(33064.3980891),
    MLO_FLOAT_C(33082.3788642),
    MLO_FLOAT_C(33100.3620827),
    MLO_FLOAT_C(33118.3477442),
    MLO_FLOAT_C(33136.3358479),
    MLO_FLOAT_C(33154.3263931),
    MLO_FLOAT_C(33172.3193792),
    MLO_FLOAT_C(33190.3148056),
    MLO_FLOAT_C(33208.3126715),
    MLO_FLOAT_C(33226.3129763),
    MLO_FLOAT_C(33244.3157193),
    MLO_FLOAT_C(33262.3208999),
    MLO_FLOAT_C(33280.3285175),
    MLO_FLOAT_C(33298.3385713),
    MLO_FLOAT_C(33316.3510607),
    MLO_FLOAT_C(33334.365985),
    MLO_FLOAT_C(33352.3833436),
    MLO_FLOAT_C(33370.4031359),
    MLO_FLOAT_C(33388.4253611),
    MLO_FLOAT_C(33406.4500187),
    MLO_FLOAT_C(33424.4771078),
    MLO_FLOAT_C(33442.506628),
    MLO_FLOAT_C(33460.5385786),
    MLO_FLOAT_C(33478.5729588),
    MLO_FLOAT_C(33496.6097681),
    MLO_FLOAT_C(33514.6490057),
    MLO_FLOAT_C(33532.6906711),
    MLO_FLOAT_C(33550.7347636),
    MLO_FLOAT_C(33568.7812825),
    MLO_FLOAT_C(33586.8302271),
    MLO_FLOAT_C(33604.8815969),
    MLO_FLOAT_C(33622.9353911),
    MLO_FLOAT_C(33640.9916092),
    MLO_FLOAT_C(33659.0502504),
    MLO_FLOAT_C(33677.1113141),
    MLO_FLOAT_C(33695.1747997),
    MLO_FLOAT_C(33713.2407065),
    MLO_FLOAT_C(33731.3090339),
    MLO_FLOAT_C(33749.3797812),
    MLO_FLOAT_C(33767.4529478),
    MLO_FLOAT_C(33785.528533),
    MLO_FLOAT_C(33803.6065361),
    MLO_FLOAT_C(33821.6869566),
    MLO_FLOAT_C(33839.7697938),
    MLO_FLOAT_C(33857.8550471),
    MLO_FLOAT_C(33875.9427157),
    MLO_FLOAT_C(33894.032799),
    MLO_FLOAT_C(33912.1252965),
    MLO_FLOAT_C(33930.2202074),
    MLO_FLOAT_C(33948.3175312),
    MLO_FLOAT_C(33966.4172671),
    MLO_FLOAT_C(33984.5194145),
    MLO_FLOAT_C(34002.6239729),
    MLO_FLOAT_C(34020.7309415),
    MLO_FLOAT_C(34038.8403196),
    MLO_FLOAT_C(34056.9521068),
    MLO_FLOAT_C(34075.0663023),
    MLO_FLOAT_C(34093.1829054),
    MLO_FLOAT_C(34111.3019156),
    MLO_FLOAT_C(34129.4233322),
    MLO_FLOAT_C(34147.5471546),
    MLO_FLOAT_C(34165.673382),
    MLO_FLOAT_C(34183.802014),
    MLO_FLOAT_C(34201.9330498),
    MLO_FLOAT_C(34220.0664889),
    MLO_FLOAT_C(34238.2023305),
    MLO_FLOAT_C(34256.340574),
    MLO_FLOAT_C(34274.4812189),
    MLO_FLOAT_C(34292.6242644),
    MLO_FLOAT_C(34310.76971),
    MLO_FLOAT_C(34328.9175549),
    MLO_FLOAT_C(34347.0677986),
    MLO_FLOAT_C(34365.2204405),
    MLO_FLOAT_C(34383.3754798),
    MLO_FLOAT_C(34401.532916),
    MLO_FLOAT_C(34419.6927484),
    MLO_FLOAT_C(34437.8549765),
    MLO_FLOAT_C(34456.0195995),
    MLO_FLOAT_C(34474.1866168),
    MLO_FLOAT_C(34492.3560278),
    MLO_FLOAT_C(34510.527832),
    MLO_FLOAT_C(34528.7020285),
    MLO_FLOAT_C(34546.8786169),
    MLO_FLOAT_C(34565.0575964),
    MLO_FLOAT_C(34583.2389665),
    MLO_FLOAT_C(34601.4227266),
    MLO_FLOAT_C(34619.6088759),
    MLO_FLOAT_C(34637.7974139),
    MLO_FLOAT_C(34655.98834),
    MLO_FLOAT_C(34674.1816534),
    MLO_FLOAT_C(34692.3773537),
    MLO_FLOAT_C(34710.5754401),
    MLO_FLOAT_C(34728.7759121),
    MLO_FLOAT_C(34746.978769),
    MLO_FLOAT_C(34765.1840101),
    MLO_FLOAT_C(34783.391635),
    MLO_FLOAT_C(34801.6016428),
    MLO_FLOAT_C(34819.8140331),
    MLO_FLOAT_C(34838.0288052),
    MLO_FLOAT_C(34856.2459585),
    MLO_FLOAT_C(34874.4654923),
    MLO_FLOAT_C(34892.687406),
    MLO_FLOAT_C(34910.911699),
    MLO_FLOAT_C(34929.1383708),
    MLO_FLOAT_C(34947.3674205),
    MLO_FLOAT_C(34965.5988478),
    MLO_FLOAT_C(34983.8326518),
    MLO_FLOAT_C(35002.0688321),
    MLO_FLOAT_C(35020.3073879),
    MLO_FLOAT_C(35038.5483188),
    MLO_FLOAT_C(35056.7916239),
    MLO_FLOAT_C(35075.0373028),
    MLO_FLOAT_C(35093.2853548),
    MLO_FLOAT_C(35111.5357793),
    MLO_FLOAT_C(35129.7885757),
    MLO_FLOAT_C(35148.0437433),
    MLO_FLOAT_C(35166.3012816),
    MLO_FLOAT_C(35184.5611899),
    MLO_FLOAT_C(35202.8234677),
    MLO_FLOAT_C(35221.0881142),
    MLO_FLOAT_C(35239.3551289),
    MLO_FLOAT_C(35257.6245112),
    MLO_FLOAT_C(35275.8962605),
    MLO_FLOAT_C(35294.1703761),
    MLO_FLOAT_C(35312.4468574),
    MLO_FLOAT_C(35330.7257039),
    MLO_FLOAT_C(35349.0069149),
    MLO_FLOAT_C(35367.2904898),
    MLO_FLOAT_C(35385.5764279),
    MLO_FLOAT_C(35403.8647288),
    MLO_FLOAT_C(35422.1553917),
    MLO_FLOAT_C(35440.448416),
    MLO_FLOAT_C(35458.7438012),
    MLO_FLOAT_C(35477.0415467),
    MLO_FLOAT_C(35495.3416517),
    MLO_FLOAT_C(35513.6441158),
    MLO_FLOAT_C(35531.9489384),
    MLO_FLOAT_C(35550.2561187),
    MLO_FLOAT_C(35568.5656562),
    MLO_FLOAT_C(35586.8775503),
    MLO_FLOAT_C(35605.1918004),
    MLO_FLOAT_C(35623.5084058),
    MLO_FLOAT_C(35641.8273661),
    MLO_FLOAT_C(35660.1486805),
    MLO_FLOAT_C(35678.4723485),
    MLO_FLOAT_C(35696.7983694),
    MLO_FLOAT_C(35715.1267427),
    MLO_FLOAT_C(35733.4574677),
    MLO_FLOAT_C(35751.7905439),
    MLO_FLOAT_C(35770.1259707),
    MLO_FLOAT_C(35788.4637473),
    MLO_FLOAT_C(35806.8038734),
    MLO_FLOAT_C(35825.1463481),
    MLO_FLOAT_C(35843.491171),
    MLO_FLOAT_C(35861.8383414),
    MLO_FLOAT_C(35880.1878588),
    MLO_FLOAT_C(35898.5397225),
    MLO_FLOAT_C(35916.8939319),
    MLO_FLOAT_C(35935.2504865),
    MLO_FLOAT_C(35953.6093856),
    MLO_FLOAT_C(35971.9706287),
    MLO_FLOAT_C(35990.334215),
    MLO_FLOAT_C(36008.7001442),
    MLO_FLOAT_C(36027.0684155),
    MLO_FLOAT_C(36045.4390283),
    MLO_FLOAT_C(36063.8119821),
    MLO_FLOAT_C(36082.1872762),
    MLO_FLOAT_C(36100.5649101),
    MLO_FLOAT_C(36118.9448831),
    MLO_FLOAT_C(36137.3271947),
    MLO_FLOAT_C(36155.7118443),
    MLO_FLOAT_C(36174.0988313),
    MLO_FLOAT_C(36192.4881551),
    MLO_FLOAT_C(36210.879815),
    MLO_FLOAT_C(36229.2738105),
    MLO_FLOAT_C(36247.6701411),
    MLO_FLOAT_C(36266.068806),
    MLO_FLOAT_C(36284.4698048),
    MLO_FLOAT_C(36302.8731368),
    MLO_FLOAT_C(36321.2788015),
    MLO_FLOAT_C(36339.6867982),
    MLO_FLOAT_C(36358.0971263),
    MLO_FLOAT_C(36376.5097853),
    MLO_FLOAT_C(36394.9247746),
    MLO_FLOAT_C(36413.3420935),
    MLO_FLOAT_C(36431.7617416),
    MLO_FLOAT_C(36450.1837182),
    MLO_FLOAT_C(36468.6080226),
    MLO_FLOAT_C(36487.0346545),
    MLO_FLOAT_C(36505.463613),
    MLO_FLOAT_C(36523.8948977),
    MLO_FLOAT_C(36542.328508),
    MLO_FLOAT_C(36560.7644433),
    MLO_FLOAT_C(36579.2027029),
    MLO_FLOAT_C(36597.6432864),
    MLO_FLOAT_C(36616.086193),
    MLO_FLOAT_C(36634.5314224),
    MLO_FLOAT_C(36652.9789737),
    MLO_FLOAT_C(36671.4288466),
    MLO_FLOAT_C(36689.8810403),
    MLO_FLOAT_C(36708.3355543),
    MLO_FLOAT_C(36726.7923881),
    MLO_FLOAT_C(36745.251541),
    MLO_FLOAT_C(36763.7130124),
    MLO_FLOAT_C(36782.1768018),
    MLO_FLOAT_C(36800.6429086),
    MLO_FLOAT_C(36819.1113322),
    MLO_FLOAT_C(36837.582072),
    MLO_FLOAT_C(36856.0551275),
    MLO_FLOAT_C(36874.530498),
    MLO_FLOAT_C(36893.008183),
    MLO_FLOAT_C(36911.4881819),
    MLO_FLOAT_C(36929.9704942),
    MLO_FLOAT_C(36948.4551192),
    MLO_FLOAT_C(36966.9420563),
    MLO_FLOAT_C(36985.4313051),
    MLO_FLOAT_C(37003.9228649),
    MLO_FLOAT_C(37022.416735),
    MLO_FLOAT_C(37040.9129151),
    MLO_FLOAT_C(37059.4114044),
    MLO_FLOAT_C(37077.9122025),
    MLO_FLOAT_C(37096.4153086),
    MLO_FLOAT_C(37114.9207224),
    MLO_FLOAT_C(37133.428443),
    MLO_FLOAT_C(37151.9384701),
    MLO_FLOAT_C(37170.4508031),
    MLO_FLOAT_C(37188.9654412),
    MLO_FLOAT_C(37207.4823841),
    MLO_FLOAT_C(37226.0016311),
    MLO_FLOAT_C(37244.5231815),
    MLO_FLOAT_C(37263.047035),
    MLO_FLOAT_C(37281.5731908),
    MLO_FLOAT_C(37300.1016485),
    MLO_FLOAT_C(37318.6324074),
    MLO_FLOAT_C(37337.165467),
    MLO_FLOAT_C(37355.7008266),
    MLO_FLOAT_C(37374.2384858),
    MLO_FLOAT_C(37392.778444),
    MLO_FLOAT_C(37411.3207005),
    MLO_FLOAT_C(37429.8652549),
    MLO_FLOAT_C(37448.4121065),
    MLO_FLOAT_C(37466.9612548),
    MLO_FLOAT_C(37485.5126992),
    MLO_FLOAT_C(37504.0664392),
    MLO_FLOAT_C(37522.6224741),
    MLO_FLOAT_C(37541.1808034),
    MLO_FLOAT_C(37559.7414266),
    MLO_FLOAT_C(37578.3043431),
    MLO_FLOAT_C(37596.8695523),
    MLO_FLOAT_C(37615.4370536),
    MLO_FLOAT_C(37634.0068465),
    MLO_FLOAT_C(37652.5789304),
    MLO_FLOAT_C(37671.1533047),
    MLO_FLOAT_C(37689.7299689),
    MLO_FLOAT_C(37708.3089225),
    MLO_FLOAT_C(37726.8901648),
    MLO_FLOAT_C(37745.4736953),
    MLO_FLOAT_C(37764.0595134),
    MLO_FLOAT_C(37782.6476186),
    MLO_FLOAT_C(37801.2380102),
    MLO_FLOAT_C(37819.8306879),
    MLO_FLOAT_C(37838.4256508),
    MLO_FLOAT_C(37857.0228986),
    MLO_FLOAT_C(37875.6224307),
    MLO_FLOAT_C(37894.2242465),
    MLO_FLOAT_C(37912.8283453),
    MLO_FLOAT_C(37931.4347268),
    MLO_FLOAT_C(37950.0433903),
    MLO_FLOAT_C(37968.6543352),
    MLO_FLOAT_C(37987.267561),
    MLO_FLOAT_C(38005.8830671),
    MLO_FLOAT_C(38024.5008531),
    MLO_FLOAT_C(38043.1209182),
    MLO_FLOAT_C(38061.743262),
    MLO_FLOAT_C(38080.3678839),
    MLO_FLOAT_C(38098.9947833),
    MLO_FLOAT_C(38117.6239598),
    MLO_FLOAT_C(38136.2554126),
    MLO_FLOAT_C(38154.8891414),
    MLO_FLOAT_C(38173.5251454),
    MLO_FLOAT_C(38192.1634243),
    MLO_FLOAT_C(38210.8039773),
    MLO_FLOAT_C(38229.446804),
    MLO_FLOAT_C(38248.0919038),
    MLO_FLOAT_C(38266.7392761),
    MLO_FLOAT_C(38285.3889204),
    MLO_FLOAT_C(38304.0408362),
    MLO_FLOAT_C(38322.6950228),
    MLO_FLOAT_C(38341.3514798),
    MLO_FLOAT_C(38360.0102066),
    MLO_FLOAT_C(38378.6712025),
    MLO_FLOAT_C(38397.3344672),
    MLO_FLOAT_C(38416.0),
    MLO_FLOAT_C(38434.6678004),
    MLO_FLOAT_C(38453.3378677),
    MLO_FLOAT_C(38472.0102016),
    MLO_FLOAT_C(38490.6848014),
    MLO_FLOAT_C(38509.3616665),
    MLO_FLOAT_C(38528.0407965),
    MLO_FLOAT_C(38546.7221908),
    MLO_FLOAT_C(38565.4058487),
    MLO_FLOAT_C(38584.0917699),
    MLO_FLOAT_C(38602.7799537),
    MLO_FLOAT_C(38621.4703995),
    MLO_FLOAT_C(38640.1631069),
    MLO_FLOAT_C(38658.8580753),
    MLO_FLOAT_C(38677.5553041),
    MLO_FLOAT_C(38696.2547929),
    MLO_FLOAT_C(38714.9565409),
    MLO_FLOAT_C(38733.6605478),
    MLO_FLOAT_C(38752.3668129),
    MLO_FLOAT_C(38771.0753357),
    MLO_FLOAT_C(38789.7861157),
    MLO_FLOAT_C(38808.4991524),
    MLO_FLOAT_C(38827.2144451),
    MLO_FLOAT_C(38845.9319933),
    MLO_FLOAT_C(38864.6517965),
    MLO_FLOAT_C(38883.3738542),
    MLO_FLOAT_C(38902.0981658),
    MLO_FLOAT_C(38920.8247307),
    MLO_FLOAT_C(38939.5535485),
    MLO_FLOAT_C(38958.2846185),
    MLO_FLOAT_C(38977.0179403),
    MLO_FLOAT_C(38995.7535132),
    MLO_FLOAT_C(39014.4913369),
    MLO_FLOAT_C(39033.2314106),
    MLO_FLOAT_C(39051.9737339),
    MLO_FLOAT_C(39070.7183062),
    MLO_FLOAT_C(39089.4651271),
    MLO_FLOAT_C(39108.2141959),
    MLO_FLOAT_C(39126.9655121),
    MLO_FLOAT_C(39145.7190752),
    MLO_FLOAT_C(39164.4748846),
    MLO_FLOAT_C(39183.2329398),
    MLO_FLOAT_C(39201.9932403),
    MLO_FLOAT_C(39220.7557855),
    MLO_FLOAT_C(39239.5205749),
    MLO_FLOAT_C(39258.287608),
    MLO_FLOAT_C(39277.0568842),
    MLO_FLOAT_C(39295.8284029),
    MLO_FLOAT_C(39314.6021637),
    MLO_FLOAT_C(39333.378166),
    MLO_FLOAT_C(39352.1564093),
    MLO_FLOAT_C(39370.936893),
    MLO_FLOAT_C(39389.7196167),
    MLO_FLOAT_C(39408.5045797),
    MLO_FLOAT_C(39427.2917815),
    MLO_FLOAT_C(39446.0812217),
    MLO_FLOAT_C(39464.8728996),
    MLO_FLOAT_C(39483.6668147),
    MLO_FLOAT_C(39502.4629666),
    MLO_FLOAT_C(39521.2613546),
    MLO_FLOAT_C(39540.0619783),
    MLO_FLOAT_C(39558.864837),
    MLO_FLOAT_C(39577.6699304),
    MLO_FLOAT_C(39596.4772578),
    MLO_FLOAT_C(39615.2868187),
    MLO_FLOAT_C(39634.0986126),
    MLO_FLOAT_C(39652.912639),
    MLO_FLOAT_C(39671.7288973),
    MLO_FLOAT_C(39690.547387),
    MLO_FLOAT_C(39709.3681075),
    MLO_FLOAT_C(39728.1910584),
    MLO_FLOAT_C(39747.0162391),
    MLO_FLOAT_C(39765.8436491),
    MLO_FLOAT_C(39784.6732879),
    MLO_FLOAT_C(39803.5051548),
    MLO_FLOAT_C(39822.3392495),
    MLO_FLOAT_C(39841.1755714),
    MLO_FLOAT_C(39860.0141198),
    MLO_FLOAT_C(39878.8548945),
    MLO_FLOAT_C(39897.6978947),
    MLO_FLOAT_C(39916.5431199),
    MLO_FLOAT_C(39935.3905698),
    MLO_FLOAT_C(39954.2402436),
    MLO_FLOAT_C(39973.092141),
    MLO_FLOAT_C(39991.9462613),
    MLO_FLOAT_C(40010.802604),
    MLO_FLOAT_C(40029.6611687),
    MLO_FLOAT_C(40048.5219548),
    MLO_FLOAT_C(40067.3849617),
    MLO_FLOAT_C(40086.250189),
    MLO_FLOAT_C(40105.1176362),
    MLO_FLOAT_C(40123.9873026),
    MLO_FLOAT_C(40142.8591878),
    MLO_FLOAT_C(40161.7332913),
    MLO_FLOAT_C(40180.6096125),
    MLO_FLOAT_C(40199.488151),
    MLO_FLOAT_C(40218.3689062),
    MLO_FLOAT_C(40237.2518775),
    MLO_FLOAT_C(40256.1370645),
    MLO_FLOAT_C(40275.0244666),
    MLO_FLOAT_C(40293.9140834),
    MLO_FLOAT_C(40312.8059143),
    MLO_FLOAT_C(40331.6999587),
    MLO_FLOAT_C(40350.5962162),
    MLO_FLOAT_C(40369.4946863),
    MLO_FLOAT_C(40388.3953684),
    MLO_FLOAT_C(40407.298262),
    MLO_FLOAT_C(40426.2033666),
    MLO_FLOAT_C(40445.1106817),
    MLO_FLOAT_C(40464.0202067),
    MLO_FLOAT_C(40482.9319412),
    MLO_FLOAT_C(40501.8458846),
    MLO_FLOAT_C(40520.7620364),
    MLO_FLOAT_C(40539.6803961),
    MLO_FLOAT_C(40558.6009632),
    MLO_FLOAT_C(40577.5237372),
    MLO_FLOAT_C(40596.4487175),
    MLO_FLOAT_C(40615.3759037),
    MLO_FLOAT_C(40634.3052951),
    MLO_FLOAT_C(40653.2368914),
    MLO_FLOAT_C(40672.170692),
    MLO_FLOAT_C(40691.1066964),
    MLO_FLOAT_C(40710.044904),
    MLO_FLOAT_C(40728.9853144),
    MLO_FLOAT_C(40747.927927),
    MLO_FLOAT_C(40766.8727414),
    MLO_FLOAT_C(40785.819757),
    MLO_FLOAT_C(40804.7689733),
    MLO_FLOAT_C(40823.7203898),
    MLO_FLOAT_C(40842.674006),
    MLO_FLOAT_C(40861.6298213),
    MLO_FLOAT_C(40880.5878354),
    MLO_FLOAT_C(40899.5480476),
    MLO_FLOAT_C(40918.5104574),
    MLO_FLOAT_C(40937.4750644),
    MLO_FLOAT_C(40956.441868),
    MLO_FLOAT_C(40975.4108677),
    MLO_FLOAT_C(40994.3820631),
    MLO_FLOAT_C(41013.3554535),
    MLO_FLOAT_C(41032.3310386),
    MLO_FLOAT_C(41051.3088177),
    MLO_FLOAT_C(41070.2887904),
    MLO_FLOAT_C(41089.2709562),
    MLO_FLOAT_C(41108.2553146),
    MLO_FLOAT_C(41127.241865),
    MLO_FLOAT_C(41146.230607),
    MLO_FLOAT_C(41165.22154),
    MLO_FLOAT_C(41184.2146636),
    MLO_FLOAT_C(41203.2099772),
    MLO_FLOAT_C(41222.2074804),
    MLO_FLOAT_C(41241.2071726),
    MLO_FLOAT_C(41260.2090533),
    MLO_FLOAT_C(41279.213122),
    MLO_FLOAT_C(41298.2193783),
    MLO_FLOAT_C(41317.2278216),
    MLO_FLOAT_C(41336.2384513),
    MLO_FLOAT_C(41355.2512671),
    MLO_FLOAT_C(41374.2662684),
    MLO_FLOAT_C(41393.2834547),
    MLO_FLOAT_C(41412.3028255),
    MLO_FLOAT_C(41431.3243803),
    MLO_FLOAT_C(41450.3481186),
    MLO_FLOAT_C(41469.37404),
    MLO_FLOAT_C(41488.4021438),
    MLO_FLOAT_C(41507.4324296),
    MLO_FLOAT_C(41526.4648968),
    MLO_FLOAT_C(41545.4995451),
    MLO_FLOAT_C(41564.5363739),
    MLO_FLOAT_C(41583.5753827),
    MLO_FLOAT_C(41602.616571),
    MLO_FLOAT_C(41621.6599383),
    MLO_FLOAT_C(41640.7054841),
    MLO_FLOAT_C(41659.7532079),
    MLO_FLOAT_C(41678.8031091),
    MLO_FLOAT_C(41697.8551874),
    MLO_FLOAT_C(41716.9094423),
    MLO_FLOAT_C(41735.9658731),
    MLO_FLOAT_C(41755.0244794),
    MLO_FLOAT_C(41774.0852608),
    MLO_FLOAT_C(41793.1482167),
    MLO_FLOAT_C(41812.2133466),
    MLO_FLOAT_C(41831.28065),
    MLO_FLOAT_C(41850.3501265),
    MLO_FLOAT_C(41869.4217755),
    MLO_FLOAT_C(41888.4955966),
    MLO_FLOAT_C(41907.5715892),
    MLO_FLOAT_C(41926.6497528),
    MLO_FLOAT_C(41945.7300871),
    MLO_FLOAT_C(41964.8125914),
    MLO_FLOAT_C(41983.8972653),
    MLO_FLOAT_C(42002.9841082),
    MLO_FLOAT_C(42022.0731198),
    MLO_FLOAT_C(42041.1642994),
    MLO_FLOAT_C(42060.2576467),
    MLO_FLOAT_C(42079.353161),
    MLO_FLOAT_C(42098.450842),
    MLO_FLOAT_C(42117.5506891),
    MLO_FLOAT_C(42136.6527019),
    MLO_FLOAT_C(42155.7568798),
    MLO_FLOAT_C(42174.8632224),
    MLO_FLOAT_C(42193.9717291),
    MLO_FLOAT_C(42213.0823995),
    MLO_FLOAT_C(42232.1952331),
    MLO_FLOAT_C(42251.3102294),
    MLO_FLOAT_C(42270.4273879),
    MLO_FLOAT_C(42289.5467081),
    MLO_FLOAT_C(42308.6681895),
    MLO_FLOAT_C(42327.7918317),
    MLO_FLOAT_C(42346.9176341),
    MLO_FLOAT_C(42366.0455963),
    MLO_FLOAT_C(42385.1757178),
    MLO_FLOAT_C(42404.3079981),
    MLO_FLOAT_C(42423.4424366),
    MLO_FLOAT_C(42442.579033),
    MLO_FLOAT_C(42461.7177868),
    MLO_FLOAT_C(42480.8586973),
    MLO_FLOAT_C(42500.0017642),
    MLO_FLOAT_C(42519.146987),
    MLO_FLOAT_C(42538.2943652),
    MLO_FLOAT_C(42557.4438983),
    MLO_FLOAT_C(42576.5955858),
    MLO_FLOAT_C(42595.7494272),
    MLO_FLOAT_C(42614.9054221),
    MLO_FLOAT_C(42634.06357),
    MLO_FLOAT_C(42653.2238703),
    MLO_FLOAT_C(42672.3863226),
    MLO_FLOAT_C(42691.5509264),
    MLO_FLOAT_C(42710.7176813),
    MLO_FLOAT_C(42729.8865867),
    MLO_FLOAT_C(42749.0576422),
    MLO_FLOAT_C(42768.2308472),
    MLO_FLOAT_C(42787.4062014),
    MLO_FLOAT_C(42806.5837042),
    MLO_FLOAT_C(42825.7633551),
    MLO_FLOAT_C(42844.9451537),
    MLO_FLOAT_C(42864.1290994),
    MLO_FLOAT_C(42883.3151919),
    MLO_FLOAT_C(42902.5034305),
    MLO_FLOAT_C(42921.6938149),
    MLO_FLOAT_C(42940.8863446),
    MLO_FLOAT_C(42960.081019),
    MLO_FLOAT_C(42979.2778377),
    MLO_FLOAT_C(42998.4768003),
    MLO_FLOAT_C(43017.6779062),
    MLO_FLOAT_C(43036.8811549),
    MLO_FLOAT_C(43056.086546),
    MLO_FLOAT_C(43075.2940791),
    MLO_FLOAT_C(43094.5037535),
    MLO_FLOAT_C(43113.7155689),
    MLO_FLOAT_C(43132.9295248),
    MLO_FLOAT_C(43152.1456207),
    MLO_FLOAT_C(43171.3638561),
    MLO_FLOAT_C(43190.5842305),
    MLO_FLOAT_C(43209.8067435),
    MLO_FLOAT_C(43229.0313946),
    MLO_FLOAT_C(43248.2581834),
    MLO_FLOAT_C(43267.4871092),
    MLO_FLOAT_C(43286.7181717),
    MLO_FLOAT_C(43305.9513705),
    MLO_FLOAT_C(43325.1867049),
    MLO_FLOAT_C(43344.4241746),
    MLO_FLOAT_C(43363.663779),
    MLO_FLOAT_C(43382.9055178),
    MLO_FLOAT_C(43402.1493903),
    MLO_FLOAT_C(43421.3953962),
    MLO_FLOAT_C(43440.643535),
    MLO_FLOAT_C(43459.8938062),
    MLO_FLOAT_C(43479.1462093),
    MLO_FLOAT_C(43498.4007439),
    MLO_FLOAT_C(43517.6574095),
    MLO_FLOAT_C(43536.9162056),
    MLO_FLOAT_C(43556.1771317),
    MLO_FLOAT_C(43575.4401874),
    MLO_FLOAT_C(43594.7053722),
    MLO_FLOAT_C(43613.9726856),
    MLO_FLOAT_C(43633.2421272),
    MLO_FLOAT_C(43652.5136965),
    MLO_FLOAT_C(43671.787393),
    MLO_FLOAT_C(43691.0632163),
    MLO_FLOAT_C(43710.3411658),
    MLO_FLOAT_C(43729.6212412),
    MLO_FLOAT_C(43748.9034419),
    MLO_FLOAT_C(43768.1877675),
    MLO_FLOAT_C(43787.4742175),
    MLO_FLOAT_C(43806.7627914),
    MLO_FLOAT_C(43826.0534888),
    MLO_FLOAT_C(43845.3463092),
    MLO_FLOAT_C(43864.6412522),
    MLO_FLOAT_C(43883.9383172),
    MLO_FLOAT_C(43903.2375039),
    MLO_FLOAT_C(43922.5388116),
    MLO_FLOAT_C(43941.8422401),
    MLO_FLOAT_C(43961.1477887),
    MLO_FLOAT_C(43980.4554571),
    MLO_FLOAT_C(43999.7652448),
    MLO_FLOAT_C(44019.0771513),
    MLO_FLOAT_C(44038.3911761),
    MLO_FLOAT_C(44057.7073188),
    MLO_FLOAT_C(44077.025579),
    MLO_FLOAT_C(44096.3459561),
    MLO_FLOAT_C(44115.6684496),
    MLO_FLOAT_C(44134.9930592),
    MLO_FLOAT_C(44154.3197844),
    MLO_FLOAT_C(44173.6486247),
    MLO_FLOAT_C(44192.9795796),
    MLO_FLOAT_C(44212.3126486),
    MLO_FLOAT_C(44231.6478314),
    MLO_FLOAT_C(44250.9851275),
    MLO_FLOAT_C(44270.3245363),
    MLO_FLOAT_C(44289.6660574),
    MLO_FLOAT_C(44309.0096904),
    MLO_FLOAT_C(44328.3554349),
    MLO_FLOAT_C(44347.7032902),
    MLO_FLOAT_C(44367.0532561),
    MLO_FLOAT_C(44386.405332),
    MLO_FLOAT_C(44405.7595174),
    MLO_FLOAT_C(44425.1158119),
    MLO_FLOAT_C(44444.4742151),
    MLO_FLOAT_C(44463.8347265),
    MLO_FLOAT_C(44483.1973456),
    MLO_FLOAT_C(44502.5620719),
    MLO_FLOAT_C(44521.9289051),
    MLO_FLOAT_C(44541.2978446),
    MLO_FLOAT_C(44560.66889),
    MLO_FLOAT_C(44580.0420409),
    MLO_FLOAT_C(44599.4172967),
    MLO_FLOAT_C(44618.794657),
    MLO_FLOAT_C(44638.1741214),
    MLO_FLOAT_C(44657.5556894),
    MLO_FLOAT_C(44676.9393606),
    MLO_FLOAT_C(44696.3251344),
    MLO_FLOAT_C(44715.7130105),
    MLO_FLOAT_C(44735.1029884),
    MLO_FLOAT_C(44754.4950676),
    MLO_FLOAT_C(44773.8892476),
    MLO_FLOAT_C(44793.2855281),
    MLO_FLOAT_C(44812.6839086),
    MLO_FLOAT_C(44832.0843885),
    MLO_FLOAT_C(44851.4869675),
    MLO_FLOAT_C(44870.8916451),
    MLO_FLOAT_C(44890.2984208),
    MLO_FLOAT_C(44909.7072942),
    MLO_FLOAT_C(44929.1182649),
    MLO_FLOAT_C(44948.5313323),
    MLO_FLOAT_C(44967.9464961),
    MLO_FLOAT_C(44987.3637557),
    MLO_FLOAT_C(45006.7831108),
    MLO_FLOAT_C(45026.2045609),
    MLO_FLOAT_C(45045.6281054),
    MLO_FLOAT_C(45065.0537441),
    MLO_FLOAT_C(45084.4814763),
    MLO_FLOAT_C(45103.9113018),
    MLO_FLOAT_C(45123.3432199),
    MLO_FLOAT_C(45142.7772303),
    MLO_FLOAT_C(45162.2133325),
    MLO_FLOAT_C(45181.6515261),
    MLO_FLOAT_C(45201.0918106),
    MLO_FLOAT_C(45220.5341856),
    MLO_FLOAT_C(45239.9786506),
    MLO_FLOAT_C(45259.4252051),
    MLO_FLOAT_C(45278.8738488),
    MLO_FLOAT_C(45298.3245811),
    MLO_FLOAT_C(45317.7774017),
    MLO_FLOAT_C(45337.23231),
    MLO_FLOAT_C(45356.6893057),
    MLO_FLOAT_C(45376.1483882),
    MLO_FLOAT_C(45395.6095572),
    MLO_FLOAT_C(45415.0728121),
    MLO_FLOAT_C(45434.5381526),
    MLO_FLOAT_C(45454.0055782),
    MLO_FLOAT_C(45473.4750884),
    MLO_FLOAT_C(45492.9466828),
    MLO_FLOAT_C(45512.420361),
    MLO_FLOAT_C(45531.8961224),
    MLO_FLOAT_C(45551.3739667),
    MLO_FLOAT_C(45570.8538935),
    MLO_FLOAT_C(45590.3359022),
    MLO_FLOAT_C(45609.8199924),
    MLO_FLOAT_C(45629.3061637),
    MLO_FLOAT_C(45648.7944156),
    MLO_FLOAT_C(45668.2847477),
    MLO_FLOAT_C(45687.7771596),
    MLO_FLOAT_C(45707.2716507),
    MLO_FLOAT_C(45726.7682208),
    MLO_FLOAT_C(45746.2668692),
    MLO_FLOAT_C(45765.7675956),
    MLO_FLOAT_C(45785.2703996),
    MLO_FLOAT_C(45804.7752806),
    MLO_FLOAT_C(45824.2822382),
    MLO_FLOAT_C(45843.7912721),
    MLO_FLOAT_C(45863.3023817),
    MLO_FLOAT_C(45882.8155667),
    MLO_FLOAT_C(45902.3308265),
    MLO_FLOAT_C(45921.8481608),
    MLO_FLOAT_C(45941.3675691),
    MLO_FLOAT_C(45960.8890509),
    MLO_FLOAT_C(45980.4126058),
    MLO_FLOAT_C(45999.9382334),
    MLO_FLOAT_C(46019.4659332),
    MLO_FLOAT_C(46038.9957049),
    MLO_FLOAT_C(46058.5275479),
    MLO_FLOAT_C(46078.0614618),
    MLO_FLOAT_C(46097.5974461),
    MLO_FLOAT_C(46117.1355006),
    MLO_FLOAT_C(46136.6756246),
    MLO_FLOAT_C(46156.2178178),
    MLO_FLOAT_C(46175.7620797),
    MLO_FLOAT_C(46195.3084099),
    MLO_FLOAT_C(46214.8568079),
    MLO_FLOAT_C(46234.4072733),
    MLO_FLOAT_C(46253.9598058),
    MLO_FLOAT_C(46273.5144047),
    MLO_FLOAT_C(46293.0710698),
    MLO_FLOAT_C(46312.6298005),
    MLO_FLOAT_C(46332.1905964),
    MLO_FLOAT_C(46351.7534572),
    MLO_FLOAT_C(46371.3183823),
    MLO_FLOAT_C(46390.8853713),
    MLO_FLOAT_C(46410.4544238),
    MLO_FLOAT_C(46430.0255393),
    MLO_FLOAT_C(46449.5987175),
    MLO_FLOAT_C(46469.1739578),
    MLO_FLOAT_C(46488.7512599),
    MLO_FLOAT_C(46508.3306233),
    MLO_FLOAT_C(46527.9120475),
    MLO_FLOAT_C(46547.4955323),
    MLO_FLOAT_C(46567.081077),
    MLO_FLOAT_C(46586.6686813),
    MLO_FLOAT_C(46606.2583447),
    MLO_FLOAT_C(46625.8500669),
    MLO_FLOAT_C(46645.4438473),
    MLO_FLOAT_C(46665.0396856),
    MLO_FLOAT_C(46684.6375813),
    MLO_FLOAT_C(46704.237534),
    MLO_FLOAT_C(46723.8395432),
    MLO_FLOAT_C(46743.4436086),
    MLO_FLOAT_C(46763.0497296),
    MLO_FLOAT_C(46782.6579059),
    MLO_FLOAT_C(46802.268137),
    MLO_FLOAT_C(46821.8804225),
    MLO_FLOAT_C(46841.494762),
    MLO_FLOAT_C(46861.111155),
    MLO_FLOAT_C(46880.7296011),
    MLO_FLOAT_C(46900.3500999),
    MLO_FLOAT_C(46919.9726509),
    MLO_FLOAT_C(46939.5972538),
    MLO_FLOAT_C(46959.223908),
    MLO_FLOAT_C(46978.8526132),
    MLO_FLOAT_C(46998.483369),
    MLO_FLOAT_C(47018.1161748),
    MLO_FLOAT_C(47037.7510303),
    MLO_FLOAT_C(47057.3879351),
    MLO_FLOAT_C(47077.0268886),
    MLO_FLOAT_C(47096.6678906),
    MLO_FLOAT_C(47116.3109405),
    MLO_FLOAT_C(47135.956038),
    MLO_FLOAT_C(47155.6031826),
    MLO_FLOAT_C(47175.2523739),
    MLO_FLOAT_C(47194.9036114),
    MLO_FLOAT_C(47214.5568947),
    MLO_FLOAT_C(47234.2122235),
    MLO_FLOAT_C(47253.8695972),
    MLO_FLOAT_C(47273.5290155),
    MLO_FLOAT_C(47293.190478),
    MLO_FLOAT_C(47312.8539841),
    MLO_FLOAT_C(47332.5195335),
    MLO_FLOAT_C(47352.1871258),
    MLO_FLOAT_C(47371.8567605),
    MLO_FLOAT_C(47391.5284372),
    MLO_FLOAT_C(47411.2021554),
    MLO_FLOAT_C(47430.8779149),
    MLO_FLOAT_C(47450.5557151),
    MLO_FLOAT_C(47470.2355556),
    MLO_FLOAT_C(47489.917436),
    MLO_FLOAT_C(47509.6013558),
    MLO_FLOAT_C(47529.2873147),
    MLO_FLOAT_C(47548.9753122),
    MLO_FLOAT_C(47568.665348),
    MLO_FLOAT_C(47588.3574215),
    MLO_FLOAT_C(47608.0515323),
    MLO_FLOAT_C(47627.7476801),
    MLO_FLOAT_C(47647.4458644),
    MLO_FLOAT_C(47667.1460848),
    MLO_FLOAT_C(47686.8483409),
    MLO_FLOAT_C(47706.5526322),
    MLO_FLOAT_C(47726.2589584),
    MLO_FLOAT_C(47745.9673189),
    MLO_FLOAT_C(47765.6777135),
    MLO_FLOAT_C(47785.3901416),
    MLO_FLOAT_C(47805.1046029),
    MLO_FLOAT_C(47824.8210969),
    MLO_FLOAT_C(47844.5396233),
    MLO_FLOAT_C(47864.2601815),
    MLO_FLOAT_C(47883.9827712),
    MLO_FLOAT_C(47903.707392),
    MLO_FLOAT_C(47923.4340434),
    MLO_FLOAT_C(47943.162725),
    MLO_FLOAT_C(47962.8934364),
    MLO_FLOAT_C(47982.6261772),
    MLO_FLOAT_C(48002.360947),
    MLO_FLOAT_C(48022.0977453),
    MLO_FLOAT_C(48041.8365718),
    MLO_FLOAT_C(48061.577426),
    MLO_FLOAT_C(48081.3203075),
    MLO_FLOAT_C(48101.0652159),
    MLO_FLOAT_C(48120.8121507),
    MLO_FLOAT_C(48140.5611116),
    MLO_FLOAT_C(48160.3120982),
    MLO_FLOAT_C(48180.0651099),
    MLO_FLOAT_C(48199.8201465),
    MLO_FLOAT_C(48219.5772075),
    MLO_FLOAT_C(48239.3362924),
    MLO_FLOAT_C(48259.0974009),
    MLO_FLOAT_C(48278.8605326),
    MLO_FLOAT_C(48298.6256869),
    MLO_FLOAT_C(48318.3928636),
    MLO_FLOAT_C(48338.1620623),
    MLO_FLOAT_C(48357.9332824),
    MLO_FLOAT_C(48377.7065236),
    MLO_FLOAT_C(48397.4817854),
    MLO_FLOAT_C(48417.2590675),
    MLO_FLOAT_C(48437.0383695),
    MLO_FLOAT_C(48456.8196909),
    MLO_FLOAT_C(48476.6030313),
    MLO_FLOAT_C(48496.3883903),
    MLO_FLOAT_C(48516.1757675),
    MLO_FLOAT_C(48535.9651625),
    MLO_FLOAT_C(48555.7565748),
    MLO_FLOAT_C(48575.5500041),
    MLO_FLOAT_C(48595.34545),
    MLO_FLOAT_C(48615.142912),
    MLO_FLOAT_C(48634.9423897),
    MLO_FLOAT_C(48654.7438828),
    MLO_FLOAT_C(48674.5473907),
    MLO_FLOAT_C(48694.3529132),
    MLO_FLOAT_C(48714.1604497),
    MLO_FLOAT_C(48733.9699999),
    MLO_FLOAT_C(48753.7815634),
    MLO_FLOAT_C(48773.5951397),
    MLO_FLOAT_C(48793.4107285),
    MLO_FLOAT_C(48813.2283293),
    MLO_FLOAT_C(48833.0479418),
    MLO_FLOAT_C(48852.8695655),
    MLO_FLOAT_C(48872.6932),
    MLO_FLOAT_C(48892.5188449),
    MLO_FLOAT_C(48912.3464998),
    MLO_FLOAT_C(48932.1761643),
    MLO_FLOAT_C(48952.007838),
    MLO_FLOAT_C(48971.8415204),
    MLO_FLOAT_C(48991.6772113),
    MLO_FLOAT_C(49011.5149101),
    MLO_FLOAT_C(49031.3546165),
    MLO_FLOAT_C(49051.19633),
    MLO_FLOAT_C(49071.0400502),
    MLO_FLOAT_C(49090.8857769),
    MLO_FLOAT_C(49110.7335094),
    MLO_FLOAT_C(49130.5832475),
    MLO_FLOAT_C(49150.4349907),
    MLO_FLOAT_C(49170.2887386),
    MLO_FLOAT_C(49190.1444908),
    MLO_FLOAT_C(49210.002247),
    MLO_FLOAT_C(49229.8620066),
    MLO_FLOAT_C(49249.7237694),
    MLO_FLOAT_C(49269.5875349),
    MLO_FLOAT_C(49289.4533026),
    MLO_FLOAT_C(49309.3210722),
    MLO_FLOAT_C(49329.1908434),
    MLO_FLOAT_C(49349.0626156),
    MLO_FLOAT_C(49368.9363885),
    MLO_FLOAT_C(49388.8121617),
    MLO_FLOAT_C(49408.6899347),
    MLO_FLOAT_C(49428.5697072),
    MLO_FLOAT_C(49448.4514788),
    MLO_FLOAT_C(49468.3352491),
    MLO_FLOAT_C(49488.2210176),
    MLO_FLOAT_C(49508.1087841),
    MLO_FLOAT_C(49527.9985479),
    MLO_FLOAT_C(49547.8903089),
    MLO_FLOAT_C(49567.7840665),
    MLO_FLOAT_C(49587.6798203),
    MLO_FLOAT_C(49607.57757),
    MLO_FLOAT_C(49627.4773152),
    MLO_FLOAT_C(49647.3790555),
    MLO_FLOAT_C(49667.2827904),
    MLO_FLOAT_C(49687.1885196),
    MLO_FLOAT_C(49707.0962426),
    MLO_FLOAT_C(49727.0059591),
    MLO_FLOAT_C(49746.9176686),
    MLO_FLOAT_C(49766.8313709),
    MLO_FLOAT_C(49786.7470654),
    MLO_FLOAT_C(49806.6647517),
    MLO_FLOAT_C(49826.5844296),
    MLO_FLOAT_C(49846.5060985),
    MLO_FLOAT_C(49866.429758),
    MLO_FLOAT_C(49886.3554079),
    MLO_FLOAT_C(49906.2830476),
    MLO_FLOAT_C(49926.2126769),
    MLO_FLOAT_C(49946.1442951),
    MLO_FLOAT_C(49966.0779021),
    MLO_FLOAT_C(49986.0134974),
    MLO_FLOAT_C(50005.9510806),
    MLO_FLOAT_C(50025.8906513),
    MLO_FLOAT_C(50045.832209),
    MLO_FLOAT_C(50065.7757535),
    MLO_FLOAT_C(50085.7212843),
    MLO_FLOAT_C(50105.668801),
    MLO_FLOAT_C(50125.6183032),
    MLO_FLOAT_C(50145.5697905),
    MLO_FLOAT_C(50165.5232626),
    MLO_FLOAT_C(50185.478719),
    MLO_FLOAT_C(50205.4361594),
    MLO_FLOAT_C(50225.3955833),
    MLO_FLOAT_C(50245.3569903),
    MLO_FLOAT_C(50265.3203801),
    MLO_FLOAT_C(50285.2857523),
    MLO_FLOAT_C(50305.2531064),
    MLO_FLOAT_C(50325.2224421),
    MLO_FLOAT_C(50345.193759),
    MLO_FLOAT_C(50365.1670567),
    MLO_FLOAT_C(50385.1423348),
    MLO_FLOAT_C(50405.1195928),
    MLO_FLOAT_C(50425.0988305),
    MLO_FLOAT_C(50445.0800475),
    MLO_FLOAT_C(50465.0632432),
    MLO_FLOAT_C(50485.0484174),
    MLO_FLOAT_C(50505.0355696),
    MLO_FLOAT_C(50525.0246995),
    MLO_FLOAT_C(50545.0158066),
    MLO_FLOAT_C(50565.0088906),
    MLO_FLOAT_C(50585.0039511),
    MLO_FLOAT_C(50605.0009877),
    MLO_FLOAT_C(50625.0),
    MLO_FLOAT_C(50645.0009876),
    MLO_FLOAT_C(50665.0039501),
    MLO_FLOAT_C(50685.0088871),
    MLO_FLOAT_C(50705.0157983),
    MLO_FLOAT_C(50725.0246832),
    MLO_FLOAT_C(50745.0355415),
    MLO_FLOAT_C(50765.0483728),
    MLO_FLOAT_C(50785.0631766),
    MLO_FLOAT_C(50805.0799526),
    MLO_FLOAT_C(50825.0987005),
    MLO_FLOAT_C(50845.1194197),
    MLO_FLOAT_C(50865.14211),
    MLO_FLOAT_C(50885.1667709),
    MLO_FLOAT_C(50905.1934021),
    MLO_FLOAT_C(50925.2220031),
    MLO_FLOAT_C(50945.2525737),
    MLO_FLOAT_C(50965.2851133),
    MLO_FLOAT_C(50985.3196216),
    MLO_FLOAT_C(51005.3560982),
    MLO_FLOAT_C(51025.3945428),
    MLO_FLOAT_C(51045.4349549),
    MLO_FLOAT_C(51065.4773341),
    MLO_FLOAT_C(51085.5216801),
    MLO_FLOAT_C(51105.5679926),
    MLO_FLOAT_C(51125.616271),
    MLO_FLOAT_C(51145.666515),
    MLO_FLOAT_C(51165.7187242),
    MLO_FLOAT_C(51185.7728983),
    MLO_FLOAT_C(51205.8290369),
    MLO_FLOAT_C(51225.8871395),
    MLO_FLOAT_C(51245.9472059),
    MLO_FLOAT_C(51266.0092355),
    MLO_FLOAT_C(51286.073228),
    MLO_FLOAT_C(51306.1391831),
    MLO_FLOAT_C(51326.2071003),
    MLO_FLOAT_C(51346.2769793),
    MLO_FLOAT_C(51366.3488197),
    MLO_FLOAT_C(51386.4226211),
    MLO_FLOAT_C(51406.4983831),
    MLO_FLOAT_C(51426.5761054),
    MLO_FLOAT_C(51446.6557875),
    MLO_FLOAT_C(51466.737429),
    MLO_FLOAT_C(51486.8210297),
    MLO_FLOAT_C(51506.9065891),
    MLO_FLOAT_C(51526.9941068),
    MLO_FLOAT_C(51547.0835824),
    MLO_FLOAT_C(51567.1750156),
    MLO_FLOAT_C(51587.268406),
    MLO_FLOAT_C(51607.3637532),
    MLO_FLOAT_C(51627.4610567),
    MLO_FLOAT_C(51647.5603164),
    MLO_FLOAT_C(51667.6615317),
    MLO_FLOAT_C(51687.7647022),
    MLO_FLOAT_C(51707.8698277),
    MLO_FLOAT_C(51727.9769077),
    MLO_FLOAT_C(51748.0859418),
    MLO_FLOAT_C(51768.1969296),
    MLO_FLOAT_C(51788.3098709),
    MLO_FLOAT_C(51808.4247651),
    MLO_FLOAT_C(51828.541612),
    MLO_FLOAT_C(51848.6604111),
    MLO_FLOAT_C(51868.781162),
    MLO_FLOAT_C(51888.9038645),
    MLO_FLOAT_C(51909.028518),
    MLO_FLOAT_C(51929.1551223),
    MLO_FLOAT_C(51949.2836769),
    MLO_FLOAT_C(51969.4141815),
    MLO_FLOAT_C(51989.5466357),
    MLO_FLOAT_C(52009.6810391),
    MLO_FLOAT_C(52029.8173913),
    MLO_FLOAT_C(52049.955692),
    MLO_FLOAT_C(52070.0959407),
    MLO_FLOAT_C(52090.2381372),
    MLO_FLOAT_C(52110.382281),
    MLO_FLOAT_C(52130.5283718),
    MLO_FLOAT_C(52150.6764091),
    MLO_FLOAT_C(52170.8263926),
    MLO_FLOAT_C(52190.978322),
    MLO_FLOAT_C(52211.1321968),
    MLO_FLOAT_C(52231.2880167),
    MLO_FLOAT_C(52251.4457812),
    MLO_FLOAT_C(52271.6054901),
    MLO_FLOAT_C(52291.767143),
    MLO_FLOAT_C(52311.9307394),
    MLO_FLOAT_C(52332.096279),
    MLO_FLOAT_C(52352.2637615),
    MLO_FLOAT_C(52372.4331863),
    MLO_FLOAT_C(52392.6045533),
    MLO_FLOAT_C(52412.777862),
    MLO_FLOAT_C(52432.953112),
    MLO_FLOAT_C(52453.1303029),
    MLO_FLOAT_C(52473.3094344),
    MLO_FLOAT_C(52493.4905062),
    MLO_FLOAT_C(52513.6735178),
    MLO_FLOAT_C(52533.8584688),
    MLO_FLOAT_C(52554.0453589),
    MLO_FLOAT_C(52574.2341878),
    MLO_FLOAT_C(52594.4249549),
    MLO_FLOAT_C(52614.6176601),
    MLO_FLOAT_C(52634.8123029),
    MLO_FLOAT_C(52655.0088828),
    MLO_FLOAT_C(52675.2073997),
    MLO_FLOAT_C(52695.407853),
    MLO_FLOAT_C(52715.6102425),
    MLO_FLOAT_C(52735.8145677),
    MLO_FLOAT_C(52756.0208282),
    MLO_FLOAT_C(52776.2290238),
    MLO_FLOAT_C(52796.439154),
    MLO_FLOAT_C(52816.6512184),
    MLO_FLOAT_C(52836.8652168),
    MLO_FLOAT_C(52857.0811487),
    MLO_FLOAT_C(52877.2990137),
    MLO_FLOAT_C(52897.5188115),
    MLO_FLOAT_C(52917.7405417),
    MLO_FLOAT_C(52937.964204),
    MLO_FLOAT_C(52958.1897979),
    MLO_FLOAT_C(52978.4173231),
    MLO_FLOAT_C(52998.6467793),
    MLO_FLOAT_C(53018.8781661),
    MLO_FLOAT_C(53039.111483),
    MLO_FLOAT_C(53059.3467298),
    MLO_FLOAT_C(53079.583906),
    MLO_FLOAT_C(53099.8230113),
    MLO_FLOAT_C(53120.0640454),
    MLO_FLOAT_C(53140.3070078),
    MLO_FLOAT_C(53160.5518982),
    MLO_FLOAT_C(53180.7987163),
    MLO_FLOAT_C(53201.0474616),
    MLO_FLOAT_C(53221.2981338),
    MLO_FLOAT_C(53241.5507325),
    MLO_FLOAT_C(53261.8052574),
    MLO_FLOAT_C(53282.061708),
    MLO_FLOAT_C(53302.3200841),
    MLO_FLOAT_C(53322.5803853),
    MLO_FLOAT_C(53342.8426111),
    MLO_FLOAT_C(53363.1067613),
    MLO_FLOAT_C(53383.3728355),
    MLO_FLOAT_C(53403.6408332),
    MLO_FLOAT_C(53423.9107542),
    MLO_FLOAT_C(53444.182598),
    MLO_FLOAT_C(53464.4563644),
    MLO_FLOAT_C(53484.7320529),
    MLO_FLOAT_C(53505.0096631),
    MLO_FLOAT_C(53525.2891948),
    MLO_FLOAT_C(53545.5706475),
    MLO_FLOAT_C(53565.8540209),
    MLO_FLOAT_C(53586.1393146),
    MLO_FLOAT_C(53606.4265283),
    MLO_FLOAT_C(53626.7156616),
    MLO_FLOAT_C(53647.0067141),
    MLO_FLOAT_C(53667.2996855),
    MLO_FLOAT_C(53687.5945753),
    MLO_FLOAT_C(53707.8913834),
    MLO_FLOAT_C(53728.1901092),
    MLO_FLOAT_C(53748.4907524),
    MLO_FLOAT_C(53768.7933126),
    MLO_FLOAT_C(53789.0977896),
    MLO_FLOAT_C(53809.4041829),
    MLO_FLOAT_C(53829.7124921),
    MLO_FLOAT_C(53850.022717),
    MLO_FLOAT_C(53870.3348571),
    MLO_FLOAT_C(53890.6489121),
    MLO_FLOAT_C(53910.9648816),
    MLO_FLOAT_C(53931.2827653),
    MLO_FLOAT_C(53951.6025627),
    MLO_FLOAT_C(53971.9242737),
    MLO_FLOAT_C(53992.2478977),
    MLO_FLOAT_C(54012.5734344),
    MLO_FLOAT_C(54032.9008835),
    MLO_FLOAT_C(54053.2302446),
    MLO_FLOAT_C(54073.5615173),
    MLO_FLOAT_C(54093.8947013),
    MLO_FLOAT_C(54114.2297962),
    MLO_FLOAT_C(54134.5668018),
    MLO_FLOAT_C(54154.9057175),
    MLO_FLOAT_C(54175.246543),
    MLO_FLOAT_C(54195.5892781),
    MLO_FLOAT_C(54215.9339222),
    MLO_FLOAT_C(54236.2804752),
    MLO_FLOAT_C(54256.6289365),
    MLO_FLOAT_C(54276.979306),
    MLO_FLOAT_C(54297.3315831),
    MLO_FLOAT_C(54317.6857675),
    MLO_FLOAT_C(54338.041859),
    MLO_FLOAT_C(54358.399857),
    MLO_FLOAT_C(54378.7597614),
    MLO_FLOAT_C(54399.1215716),
    MLO_FLOAT_C(54419.4852874),
    MLO_FLOAT_C(54439.8509084),
    MLO_FLOAT_C(54460.2184342),
    MLO_FLOAT_C(54480.5878646),
    MLO_FLOAT_C(54500.959199),
    MLO_FLOAT_C(54521.3324373),
    MLO_FLOAT_C(54541.7075789),
    MLO_FLOAT_C(54562.0846236),
    MLO_FLOAT_C(54582.463571),
    MLO_FLOAT_C(54602.8444208),
    MLO_FLOAT_C(54623.2271726),
    MLO_FLOAT_C(54643.611826),
    MLO_FLOAT_C(54663.9983807),
    MLO_FLOAT_C(54684.3868363),
    MLO_FLOAT_C(54704.7771925),
    MLO_FLOAT_C(54725.169449),
    MLO_FLOAT_C(54745.5636053),
    MLO_FLOAT_C(54765.9596611),
    MLO_FLOAT_C(54786.3576161),
    MLO_FLOAT_C(54806.7574699),
    MLO_FLOAT_C(54827.1592221),
    MLO_FLOAT_C(54847.5628724),
    MLO_FLOAT_C(54867.9684205),
    MLO_FLOAT_C(54888.375866),
    MLO_FLOAT_C(54908.7852086),
    MLO_FLOAT_C(54929.1964478),
    MLO_FLOAT_C(54949.6095834),
    MLO_FLOAT_C(54970.0246149),
    MLO_FLOAT_C(54990.4415421),
    MLO_FLOAT_C(55010.8603646),
    MLO_FLOAT_C(55031.281082),
    MLO_FLOAT_C(55051.703694),
    MLO_FLOAT_C(55072.1282002),
    MLO_FLOAT_C(55092.5546003),
    MLO_FLOAT_C(55112.9828939),
    MLO_FLOAT_C(55133.4130807),
    MLO_FLOAT_C(55153.8451603),
    MLO_FLOAT_C(55174.2791323),
    MLO_FLOAT_C(55194.7149965),
    MLO_FLOAT_C(55215.1527525),
    MLO_FLOAT_C(55235.5923999),
    MLO_FLOAT_C(55256.0339384),
    MLO_FLOAT_C(55276.4773676),
    MLO_FLOAT_C(55296.9226871),
    MLO_FLOAT_C(55317.3698967),
    MLO_FLOAT_C(55337.8189959),
    MLO_FLOAT_C(55358.2699845),
    MLO_FLOAT_C(55378.7228621),
    MLO_FLOAT_C(55399.1776283),
    MLO_FLOAT_C(55419.6342827),
    MLO_FLOAT_C(55440.0928251),
    MLO_FLOAT_C(55460.5532551),
    MLO_FLOAT_C(55481.0155723),
    MLO_FLOAT_C(55501.4797764),
    MLO_FLOAT_C(55521.945867),
    MLO_FLOAT_C(55542.4138438),
    MLO_FLOAT_C(55562.8837064),
    MLO_FLOAT_C(55583.3554546),
    MLO_FLOAT_C(55603.8290879),
    MLO_FLOAT_C(55624.304606),
    MLO_FLOAT_C(55644.7820085),
    MLO_FLOAT_C(55665.2612951),
    MLO_FLOAT_C(55685.7424656),
    MLO_FLOAT_C(55706.2255194),
    MLO_FLOAT_C(55726.7104563),
    MLO_FLOAT_C(55747.1972759),
    MLO_FLOAT_C(55767.6859778),
    MLO_FLOAT_C(55788.1765619),
    MLO_FLOAT_C(55808.6690275),
    MLO_FLOAT_C(55829.1633746),
    MLO_FLOAT_C(55849.6596026),
    MLO_FLOAT_C(55870.1577113),
    MLO_FLOAT_C(55890.6577002),
    MLO_FLOAT_C(55911.1595692),
    MLO_FLOAT_C(55931.6633177),
    MLO_FLOAT_C(55952.1689455),
    MLO_FLOAT_C(55972.6764522),
    MLO_FLOAT_C(55993.1858375),
    MLO_FLOAT_C(56013.6971011),
    MLO_FLOAT_C(56034.2102425),
    MLO_FLOAT_C(56054.7252615),
    MLO_FLOAT_C(56075.2421577),
    MLO_FLOAT_C(56095.7609307),
    MLO_FLOAT_C(56116.2815803),
    MLO_FLOAT_C(56136.804106),
    MLO_FLOAT_C(56157.3285076),
    MLO_FLOAT_C(56177.8547846),
    MLO_FLOAT_C(56198.3829368),
    MLO_FLOAT_C(56218.9129638),
    MLO_FLOAT_C(56239.4448653),
    MLO_FLOAT_C(56259.9786409),
    MLO_FLOAT_C(56280.5142902),
    MLO_FLOAT_C(56301.051813),
    MLO_FLOAT_C(56321.5912089),
    MLO_FLOAT_C(56342.1324776),
    MLO_FLOAT_C(56362.6756186),
    MLO_FLOAT_C(56383.2206317),
    MLO_FLOAT_C(56403.7675165),
    MLO_FLOAT_C(56424.3162728),
    MLO_FLOAT_C(56444.8669),
    MLO_FLOAT_C(56465.419398),
    MLO_FLOAT_C(56485.9737664),
    MLO_FLOAT_C(56506.5300047),
    MLO_FLOAT_C(56527.0881128),
    MLO_FLOAT_C(56547.6480902),
    MLO_FLOAT_C(56568.2099366),
    MLO_FLOAT_C(56588.7736516),
    MLO_FLOAT_C(56609.339235),
    MLO_FLOAT_C(56629.9066864),
    MLO_FLOAT_C(56650.4760054),
    MLO_FLOAT_C(56671.0471917),
    MLO_FLOAT_C(56691.620245),
    MLO_FLOAT_C(56712.1951649),
    MLO_FLOAT_C(56732.7719511),
    MLO_FLOAT_C(56753.3506033),
    MLO_FLOAT_C(56773.9311211),
    MLO_FLOAT_C(56794.5135041),
    MLO_FLOAT_C(56815.0977521),
    MLO_FLOAT_C(56835.6838647),
    MLO_FLOAT_C(56856.2718415),
    MLO_FLOAT_C(56876.8616823),
    MLO_FLOAT_C(56897.4533867),
    MLO_FLOAT_C(56918.0469543),
    MLO_FLOAT_C(56938.6423848),
    MLO_FLOAT_C(56959.2396779),
    MLO_FLOAT_C(56979.8388333),
    MLO_FLOAT_C(57000.4398505),
    MLO_FLOAT_C(57021.0427293),
    MLO_FLOAT_C(57041.6474693),
    MLO_FLOAT_C(57062.2540703),
    MLO_FLOAT_C(57082.8625318),
    MLO_FLOAT_C(57103.4728535),
    MLO_FLOAT_C(57124.0850351),
    MLO_FLOAT_C(57144.6990762),
    MLO_FLOAT_C(57165.3149766),
    MLO_FLOAT_C(57185.9327358),
    MLO_FLOAT_C(57206.5523536),
    MLO_FLOAT_C(57227.1738296),
    MLO_FLOAT_C(57247.7971634),
    MLO_FLOAT_C(57268.4223548),
    MLO_FLOAT_C(57289.0494034),
    MLO_FLOAT_C(57309.6783089),
    MLO_FLOAT_C(57330.3090709),
    MLO_FLOAT_C(57350.9416892),
    MLO_FLOAT_C(57371.5761632),
    MLO_FLOAT_C(57392.2124929),
    MLO_FLOAT_C(57412.8506777),
    MLO_FLOAT_C(57433.4907174),
    MLO_FLOAT_C(57454.1326116),
    MLO_FLOAT_C(57474.77636),
    MLO_FLOAT_C(57495.4219623),
    MLO_FLOAT_C(57516.0694182),
    MLO_FLOAT_C(57536.7187272),
    MLO_FLOAT_C(57557.3698891),
    MLO_FLOAT_C(57578.0229035),
    MLO_FLOAT_C(57598.6777702),
    MLO_FLOAT_C(57619.3344887),
    MLO_FLOAT_C(57639.9930588),
    MLO_FLOAT_C(57660.65348),
    MLO_FLOAT_C(57681.3157522),
    MLO_FLOAT_C(57701.9798749),
    MLO_FLOAT_C(57722.6458478),
    MLO_FLOAT_C(57743.3136706),
    MLO_FLOAT_C(57763.9833429),
    MLO_FLOAT_C(57784.6548645),
    MLO_FLOAT_C(57805.3282349),
    MLO_FLOAT_C(57826.003454),
    MLO_FLOAT_C(57846.6805212),
    MLO_FLOAT_C(57867.3594363),
    MLO_FLOAT_C(57888.0401991),
    MLO_FLOAT_C(57908.722809),
    MLO_FLOAT_C(57929.4072659),
    MLO_FLOAT_C(57950.0935693),
    MLO_FLOAT_C(57970.781719),
    MLO_FLOAT_C(57991.4717146),
    MLO_FLOAT_C(58012.1635558),
    MLO_FLOAT_C(58032.8572423),
    MLO_FLOAT_C(58053.5527737),
    MLO_FLOAT_C(58074.2501497),
    MLO_FLOAT_C(58094.9493699),
    MLO_FLOAT_C(58115.6504342),
    MLO_FLOAT_C(58136.353342),
    MLO_FLOAT_C(58157.0580931),
    MLO_FLOAT_C(58177.7646872),
    MLO_FLOAT_C(58198.4731239),
    MLO_FLOAT_C(58219.183403),
    MLO_FLOAT_C(58239.895524),
    MLO_FLOAT_C(58260.6094866),
    MLO_FLOAT_C(58281.3252906),
    MLO_FLOAT_C(58302.0429356),
    MLO_FLOAT_C(58322.7624212),
    MLO_FLOAT_C(58343.4837472),
    MLO_FLOAT_C(58364.2069132),
    MLO_FLOAT_C(58384.9319189),
    MLO_FLOAT_C(58405.658764),
    MLO_FLOAT_C(58426.387448),
    MLO_FLOAT_C(58447.1179708),
    MLO_FLOAT_C(58467.850332),
    MLO_FLOAT_C(58488.5845312),
    MLO_FLOAT_C(58509.3205682),
    MLO_FLOAT_C(58530.0584426),
    MLO_FLOAT_C(58550.798154),
    MLO_FLOAT_C(58571.5397022),
    MLO_FLOAT_C(58592.2830869),
    MLO_FLOAT_C(58613.0283076),
    MLO_FLOAT_C(58633.7753641),
    MLO_FLOAT_C(58654.5242561),
    MLO_FLOAT_C(58675.2749832),
    MLO_FLOAT_C(58696.0275451),
    MLO_FLOAT_C(58716.7819415),
    MLO_FLOAT_C(58737.538172),
    MLO_FLOAT_C(58758.2962364),
    MLO_FLOAT_C(58779.0561343),
    MLO_FLOAT_C(58799.8178653),
    MLO_FLOAT_C(58820.5814293),
    MLO_FLOAT_C(58841.3468257),
    MLO_FLOAT_C(58862.1140544),
    MLO_FLOAT_C(58882.883115),
    MLO_FLOAT_C(58903.6540071),
    MLO_FLOAT_C(58924.4267305),
    MLO_FLOAT_C(58945.2012848),
    MLO_FLOAT_C(58965.9776697),
    MLO_FLOAT_C(58986.7558849),
    MLO_FLOAT_C(59007.53593),
    MLO_FLOAT_C(59028.3178048),
    MLO_FLOAT_C(59049.1015089),
    MLO_FLOAT_C(59069.8870419),
    MLO_FLOAT_C(59090.6744037),
    MLO_FLOAT_C(59111.4635937),
    MLO_FLOAT_C(59132.2546118),
    MLO_FLOAT_C(59153.0474576),
    MLO_FLOAT_C(59173.8421308),
    MLO_FLOAT_C(59194.6386311),
    MLO_FLOAT_C(59215.436958),
    MLO_FLOAT_C(59236.2371114),
    MLO_FLOAT_C(59257.0390909),
    MLO_FLOAT_C(59277.8428962),
    MLO_FLOAT_C(59298.6485269),
    MLO_FLOAT_C(59319.4559828),
    MLO_FLOAT_C(59340.2652634),
    MLO_FLOAT_C(59361.0763686),
    MLO_FLOAT_C(59381.8892979),
    MLO_FLOAT_C(59402.7040511),
    MLO_FLOAT_C(59423.5206279),
    MLO_FLOAT_C(59444.3390278),
    MLO_FLOAT_C(59465.1592507),
    MLO_FLOAT_C(59485.9812961),
    MLO_FLOAT_C(59506.8051638),
    MLO_FLOAT_C(59527.6308534),
    MLO_FLOAT_C(59548.4583647),
    MLO_FLOAT_C(59569.2876972),
    MLO_FLOAT_C(59590.1188508),
    MLO_FLOAT_C(59610.951825),
    MLO_FLOAT_C(59631.7866195),
    MLO_FLOAT_C(59652.6232341),
    MLO_FLOAT_C(59673.4616684),
    MLO_FLOAT_C(59694.3019221),
    MLO_FLOAT_C(59715.1439948),
    MLO_FLOAT_C(59735.9878864),
    MLO_FLOAT_C(59756.8335963),
    MLO_FLOAT_C(59777.6811244),
    MLO_FLOAT_C(59798.5304703),
    MLO_FLOAT_C(59819.3816337),
    MLO_FLOAT_C(59840.2346143),
    MLO_FLOAT_C(59861.0894117),
    MLO_FLOAT_C(59881.9460256),
    MLO_FLOAT_C(59902.8044558),
    MLO_FLOAT_C(59923.6647019),
    MLO_FLOAT_C(59944.5267636),
    MLO_FLOAT_C(59965.3906406),
    MLO_FLOAT_C(59986.2563325),
    MLO_FLOAT_C(60007.1238391),
    MLO_FLOAT_C(60027.99316),
    MLO_FLOAT_C(60048.8642949),
    MLO_FLOAT_C(60069.7372435),
    MLO_FLOAT_C(60090.6120055),
    MLO_FLOAT_C(60111.4885805),
    MLO_FLOAT_C(60132.3669684),
    MLO_FLOAT_C(60153.2471686),
    MLO_FLOAT_C(60174.129181),
    MLO_FLOAT_C(60195.0130052),
    MLO_FLOAT_C(60215.8986409),
    MLO_FLOAT_C(60236.7860877),
    MLO_FLOAT_C(60257.6753454),
    MLO_FLOAT_C(60278.5664137),
    MLO_FLOAT_C(60299.4592923),
    MLO_FLOAT_C(60320.3539807),
    MLO_FLOAT_C(60341.2504788),
    MLO_FLOAT_C(60362.1487861),
    MLO_FLOAT_C(60383.0489025),
    MLO_FLOAT_C(60403.9508275),
    MLO_FLOAT_C(60424.8545609),
    MLO_FLOAT_C(60445.7601023),
    MLO_FLOAT_C(60466.6674515),
    MLO_FLOAT_C(60487.576608),
    MLO_FLOAT_C(60508.4875717),
    MLO_FLOAT_C(60529.4003422),
    MLO_FLOAT_C(60550.3149192),
    MLO_FLOAT_C(60571.2313023),
    MLO_FLOAT_C(60592.1494913),
    MLO_FLOAT_C(60613.0694859),
    MLO_FLOAT_C(60633.9912857),
    MLO_FLOAT_C(60654.9148904),
    MLO_FLOAT_C(60675.8402997),
    MLO_FLOAT_C(60696.7675134),
    MLO_FLOAT_C(60717.696531),
    MLO_FLOAT_C(60738.6273523),
    MLO_FLOAT_C(60759.559977),
    MLO_FLOAT_C(60780.4944047),
    MLO_FLOAT_C(60801.4306352),
    MLO_FLOAT_C(60822.3686681),
    MLO_FLOAT_C(60843.3085032),
    MLO_FLOAT_C(60864.2501401),
    MLO_FLOAT_C(60885.1935785),
    MLO_FLOAT_C(60906.1388181),
    MLO_FLOAT_C(60927.0858585),
    MLO_FLOAT_C(60948.0346996),
    MLO_FLOAT_C(60968.9853409),
    MLO_FLOAT_C(60989.9377822),
    MLO_FLOAT_C(61010.8920231),
    MLO_FLOAT_C(61031.8480634),
    MLO_FLOAT_C(61052.8059027),
    MLO_FLOAT_C(61073.7655407),
    MLO_FLOAT_C(61094.7269772),
    MLO_FLOAT_C(61115.6902117),
    MLO_FLOAT_C(61136.6552441),
    MLO_FLOAT_C(61157.622074),
    MLO_FLOAT_C(61178.590701),
    MLO_FLOAT_C(61199.5611249),
    MLO_FLOAT_C(61220.5333454),
    MLO_FLOAT_C(61241.5073621),
    MLO_FLOAT_C(61262.4831748),
    MLO_FLOAT_C(61283.4607831),
    MLO_FLOAT_C(61304.4401868),
    MLO_FLOAT_C(61325.4213854),
    MLO_FLOAT_C(61346.4043789),
    MLO_FLOAT_C(61367.3891667),
    MLO_FLOAT_C(61388.3757486),
    MLO_FLOAT_C(61409.3641244),
    MLO_FLOAT_C(61430.3542936),
    MLO_FLOAT_C(61451.346256),
    MLO_FLOAT_C(61472.3400113),
    MLO_FLOAT_C(61493.3355592),
    MLO_FLOAT_C(61514.3328994),
    MLO_FLOAT_C(61535.3320315),
    MLO_FLOAT_C(61556.3329552),
    MLO_FLOAT_C(61577.3356704),
    MLO_FLOAT_C(61598.3401765),
    MLO_FLOAT_C(61619.3464735),
    MLO_FLOAT_C(61640.3545608),
    MLO_FLOAT_C(61661.3644383),
    MLO_FLOAT_C(61682.3761056),
    MLO_FLOAT_C(61703.3895624),
    MLO_FLOAT_C(61724.4048085),
    MLO_FLOAT_C(61745.4218434),
    MLO_FLOAT_C(61766.440667),
    MLO_FLOAT_C(61787.4612789),
    MLO_FLOAT_C(61808.4836787),
    MLO_FLOAT_C(61829.5078663),
    MLO_FLOAT_C(61850.5338413),
    MLO_FLOAT_C(61871.5616033),
    MLO_FLOAT_C(61892.5911521),
    MLO_FLOAT_C(61913.6224874),
    MLO_FLOAT_C(61934.6556089),
    MLO_FLOAT_C(61955.6905163),
    MLO_FLOAT_C(61976.7272092),
    MLO_FLOAT_C(61997.7656874),
    MLO_FLOAT_C(62018.8059506),
    MLO_FLOAT_C(62039.8479984),
    MLO_FLOAT_C(62060.8918306),
    MLO_FLOAT_C(62081.9374468),
    MLO_FLOAT_C(62102.9848468),
    MLO_FLOAT_C(62124.0340302),
    MLO_FLOAT_C(62145.0849968),
    MLO_FLOAT_C(62166.1377462),
    MLO_FLOAT_C(62187.1922782),
    MLO_FLOAT_C(62208.2485924),
    MLO_FLOAT_C(62229.3066886),
    MLO_FLOAT_C(62250.3665664),
    MLO_FLOAT_C(62271.4282256),
    MLO_FLOAT_C(62292.4916657),
    MLO_FLOAT_C(62313.5568867),
    MLO_FLOAT_C(62334.623888),
    MLO_FLOAT_C(62355.6926695),
    MLO_FLOAT_C(62376.7632308),
    MLO_FLOAT_C(62397.8355717),
    MLO_FLOAT_C(62418.9096918),
    MLO_FLOAT_C(62439.9855908),
    MLO_FLOAT_C(62461.0632684),
    MLO_FLOAT_C(62482.1427244),
    MLO_FLOAT_C(62503.2239584),
    MLO_FLOAT_C(62524.3069702),
    MLO_FLOAT_C(62545.3917594),
    MLO_FLOAT_C(62566.4783257),
    MLO_FLOAT_C(62587.5666688),
    MLO_FLOAT_C(62608.6567885),
    MLO_FLOAT_C(62629.7486844),
    MLO_FLOAT_C(62650.8423562),
    MLO_FLOAT_C(62671.9378037),
    MLO_FLOAT_C(62693.0350266),
    MLO_FLOAT_C(62714.1340244),
    MLO_FLOAT_C(62735.234797),
    MLO_FLOAT_C(62756.3373441),
    MLO_FLOAT_C(62777.4416652),
    MLO_FLOAT_C(62798.5477603),
    MLO_FLOAT_C(62819.6556288),
    MLO_FLOAT_C(62840.7652707),
    MLO_FLOAT_C(62861.8766855),
    MLO_FLOAT_C(62882.9898729),
    MLO_FLOAT_C(62904.1048327),
    MLO_FLOAT_C(62925.2215645),
    MLO_FLOAT_C(62946.3400681),
    MLO_FLOAT_C(62967.4603432),
    MLO_FLOAT_C(62988.5823894),
    MLO_FLOAT_C(63009.7062065),
    MLO_FLOAT_C(63030.8317942),
    MLO_FLOAT_C(63051.9591522),
    MLO_FLOAT_C(63073.0882801),
    MLO_FLOAT_C(63094.2191777),
    MLO_FLOAT_C(63115.3518447),
    MLO_FLOAT_C(63136.4862808),
    MLO_FLOAT_C(63157.6224857),
    MLO_FLOAT_C(63178.7604591),
    MLO_FLOAT_C(63199.9002007),
    MLO_FLOAT_C(63221.0417102),
    MLO_FLOAT_C(63242.1849873),
    MLO_FLOAT_C(63263.3300317),
    MLO_FLOAT_C(63284.4768431),
    MLO_FLOAT_C(63305.6254213),
    MLO_FLOAT_C(63326.7757659),
    MLO_FLOAT_C(63347.9278766),
    MLO_FLOAT_C(63369.0817532),
    MLO_FLOAT_C(63390.2373953),
    MLO_FLOAT_C(63411.3948027),
    MLO_FLOAT_C(63432.553975),
    MLO_FLOAT_C(63453.714912),
    MLO_FLOAT_C(63474.8776133),
    MLO_FLOAT_C(63496.0420787),
    MLO_FLOAT_C(63517.2083079),
    MLO_FLOAT_C(63538.3763006),
    MLO_FLOAT_C(63559.5460565),
    MLO_FLOAT_C(63580.7175753),
    MLO_FLOAT_C(63601.8908566),
    MLO_FLOAT_C(63623.0659003),
    MLO_FLOAT_C(63644.242706),
    MLO_FLOAT_C(63665.4212735),
    MLO_FLOAT_C(63686.6016023),
    MLO_FLOAT_C(63707.7836923),
    MLO_FLOAT_C(63728.9675432),
    MLO_FLOAT_C(63750.1531546),
    MLO_FLOAT_C(63771.3405262),
    MLO_FLOAT_C(63792.5296579),
    MLO_FLOAT_C(63813.7205492),
    MLO_FLOAT_C(63834.9131998),
    MLO_FLOAT_C(63856.1076096),
    MLO_FLOAT_C(63877.3037782),
    MLO_FLOAT_C(63898.5017053),
    MLO_FLOAT_C(63919.7013906),
    MLO_FLOAT_C(63940.9028338),
    MLO_FLOAT_C(63962.1060346),
    MLO_FLOAT_C(63983.3109928),
    MLO_FLOAT_C(64004.5177081),
    MLO_FLOAT_C(64025.7261801),
    MLO_FLOAT_C(64046.9364086),
    MLO_FLOAT_C(64068.1483932),
    MLO_FLOAT_C(64089.3621338),
    MLO_FLOAT_C(64110.5776299),
    MLO_FLOAT_C(64131.7948813),
    MLO_FLOAT_C(64153.0138878),
    MLO_FLOAT_C(64174.234649),
    MLO_FLOAT_C(64195.4571646),
    MLO_FLOAT_C(64216.6814343),
    MLO_FLOAT_C(64237.9074579),
    MLO_FLOAT_C(64259.1352351),
    MLO_FLOAT_C(64280.3647656),
    MLO_FLOAT_C(64301.596049),
    MLO_FLOAT_C(64322.8290851),
    MLO_FLOAT_C(64344.0638737),
    MLO_FLOAT_C(64365.3004143),
    MLO_FLOAT_C(64386.5387068),
    MLO_FLOAT_C(64407.7787508),
    MLO_FLOAT_C(64429.0205461),
    MLO_FLOAT_C(64450.2640923),
    MLO_FLOAT_C(64471.5093892),
    MLO_FLOAT_C(64492.7564365),
    MLO_FLOAT_C(64514.0052339),
    MLO_FLOAT_C(64535.2557811),
    MLO_FLOAT_C(64556.5080778),
    MLO_FLOAT_C(64577.7621238),
    MLO_FLOAT_C(64599.0179187),
    MLO_FLOAT_C(64620.2754622),
    MLO_FLOAT_C(64641.5347542),
    MLO_FLOAT_C(64662.7957942),
    MLO_FLOAT_C(64684.058582),
    MLO_FLOAT_C(64705.3231173),
    MLO_FLOAT_C(64726.5893998),
    MLO_FLOAT_C(64747.8574292),
    MLO_FLOAT_C(64769.1272054),
    MLO_FLOAT_C(64790.3987278),
    MLO_FLOAT_C(64811.6719963),
    MLO_FLOAT_C(64832.9470107),
    MLO_FLOAT_C(64854.2237705),
    MLO_FLOAT_C(64875.5022755),
    MLO_FLOAT_C(64896.7825255),
    MLO_FLOAT_C(64918.0645201),
    MLO_FLOAT_C(64939.348259),
    MLO_FLOAT_C(64960.633742),
    MLO_FLOAT_C(64981.9209688),
    MLO_FLOAT_C(65003.2099391),
    MLO_FLOAT_C(65024.5006526),
    MLO_FLOAT_C(65045.7931091),
    MLO_FLOAT_C(65067.0873081),
    MLO_FLOAT_C(65088.3832496),
    MLO_FLOAT_C(65109.6809331),
    MLO_FLOAT_C(65130.9803584),
    MLO_FLOAT_C(65152.2815252),
    MLO_FLOAT_C(65173.5844332),
    MLO_FLOAT_C(65194.8890821),
    MLO_FLOAT_C(65216.1954717),
    MLO_FLOAT_C(65237.5036016),
    MLO_FLOAT_C(65258.8134717),
    MLO_FLOAT_C(65280.1250815),
    MLO_FLOAT_C(65301.4384308),
    MLO_FLOAT_C(65322.7535194),
    MLO_FLOAT_C(65344.0703469),
    MLO_FLOAT_C(65365.388913),
    MLO_FLOAT_C(65386.7092176),
    MLO_FLOAT_C(65408.0312602),
    MLO_FLOAT_C(65429.3550406),
    MLO_FLOAT_C(65450.6805586),
    MLO_FLOAT_C(65472.0078138),
    MLO_FLOAT_C(65493.3368059),
    MLO_FLOAT_C(65514.6675348),
    MLO_FLOAT_C(65536.0),
    MLO_FLOAT_C(65557.3342013),
    MLO_FLOAT_C(65578.6701385),
    MLO_FLOAT_C(65600.0078112),
    MLO_FLOAT_C(65621.3472192),
    MLO_FLOAT_C(65642.6883622),
    MLO_FLOAT_C(65664.0312398),
    MLO_FLOAT_C(65685.3758519),
    MLO_FLOAT_C(65706.7221981),
    MLO_FLOAT_C(65728.0702782),
    MLO_FLOAT_C(65749.4200918),
    MLO_FLOAT_C(65770.7716388),
    MLO_FLOAT_C(65792.1249187),
    MLO_FLOAT_C(65813.4799314),
    MLO_FLOAT_C(65834.8366765),
    MLO_FLOAT_C(65856.1951538),
    MLO_FLOAT_C(65877.555363),
    MLO_FLOAT_C(65898.9173037),
    MLO_FLOAT_C(65920.2809758),
    MLO_FLOAT_C(65941.646379),
    MLO_FLOAT_C(65963.0135129),
    MLO_FLOAT_C(65984.3823773),
    MLO_FLOAT_C(66005.7529719),
    MLO_FLOAT_C(66027.1252964),
    MLO_FLOAT_C(66048.4993505),
    MLO_FLOAT_C(66069.8751341),
    MLO_FLOAT_C(66091.2526467),
    MLO_FLOAT_C(66112.6318881),
    MLO_FLOAT_C(66134.012858),
    MLO_FLOAT_C(66155.3955562),
    MLO_FLOAT_C(66176.7799823),
    MLO_FLOAT_C(66198.1661361),
    MLO_FLOAT_C(66219.5540173),
    MLO_FLOAT_C(66240.9436257),
    MLO_FLOAT_C(66262.3349609),
    MLO_FLOAT_C(66283.7280227),
    MLO_FLOAT_C(66305.1228107),
    MLO_FLOAT_C(66326.5193248),
    MLO_FLOAT_C(66347.9175646),
    MLO_FLOAT_C(66369.3175299),
    MLO_FLOAT_C(66390.7192203),
    MLO_FLOAT_C(66412.1226357),
    MLO_FLOAT_C(66433.5277756),
    MLO_FLOAT_C(66454.93464),
    MLO_FLOAT_C(66476.3432283),
    MLO_FLOAT_C(66497.7535405),
    MLO_FLOAT_C(66519.1655762),
    MLO_FLOAT_C(66540.5793351),
    MLO_FLOAT_C(66561.9948169),
    MLO_FLOAT_C(66583.4120215),
    MLO_FLOAT_C(66604.8309484),
    MLO_FLOAT_C(66626.2515975),
    MLO_FLOAT_C(66647.6739684),
    MLO_FLOAT_C(66669.0980609),
    MLO_FLOAT_C(66690.5238747),
    MLO_FLOAT_C(66711.9514095),
    MLO_FLOAT_C(66733.380665),
    MLO_FLOAT_C(66754.811641),
    MLO_FLOAT_C(66776.2443372),
    MLO_FLOAT_C(66797.6787533),
    MLO_FLOAT_C(66819.1148891),
    MLO_FLOAT_C(66840.5527442),
    MLO_FLOAT_C(66861.9923184),
    MLO_FLOAT_C(66883.4336114),
    MLO_FLOAT_C(66904.8766229),
    MLO_FLOAT_C(66926.3213527),
    MLO_FLOAT_C(66947.7678005),
    MLO_FLOAT_C(66969.215966),
    MLO_FLOAT_C(66990.6658489),
    MLO_FLOAT_C(67012.117449),
    MLO_FLOAT_C(67033.5707659),
    MLO_FLOAT_C(67055.0257995),
    MLO_FLOAT_C(67076.4825494),
    MLO_FLOAT_C(67097.9410154),
    MLO_FLOAT_C(67119.4011971),
    MLO_FLOAT_C(67140.8630944),
    MLO_FLOAT_C(67162.3267069),
    MLO_FLOAT_C(67183.7920344),
    MLO_FLOAT_C(67205.2590765),
    MLO_FLOAT_C(67226.7278331),
    MLO_FLOAT_C(67248.1983038),
    MLO_FLOAT_C(67269.6704883),
    MLO_FLOAT_C(67291.1443865),
    MLO_FLOAT_C(67312.619998),
    MLO_FLOAT_C(67334.0973225),
    MLO_FLOAT_C(67355.5763598),
    MLO_FLOAT_C(67377.0571096),
    MLO_FLOAT_C(67398.5395717),
    MLO_FLOAT_C(67420.0237457),
    MLO_FLOAT_C(67441.5096313),
    MLO_FLOAT_C(67462.9972284),
    MLO_FLOAT_C(67484.4865366),
    MLO_FLOAT_C(67505.9775557),
    MLO_FLOAT_C(67527.4702854),
    MLO_FLOAT_C(67548.9647254),
    MLO_FLOAT_C(67570.4608754),
    MLO_FLOAT_C(67591.9587352),
    MLO_FLOAT_C(67613.4583045),
    MLO_FLOAT_C(67634.9595831),
    MLO_FLOAT_C(67656.4625706),
    MLO_FLOAT_C(67677.9672668),
    MLO_FLOAT_C(67699.4736714),
    MLO_FLOAT_C(67720.9817842),
    MLO_FLOAT_C(67742.4916048),
    MLO_FLOAT_C(67764.003133),
    MLO_FLOAT_C(67785.5163686),
    MLO_FLOAT_C(67807.0313112),
    MLO_FLOAT_C(67828.5479606),
    MLO_FLOAT_C(67850.0663166),
    MLO_FLOAT_C(67871.5863788),
    MLO_FLOAT_C(67893.1081469),
    MLO_FLOAT_C(67914.6316208),
    MLO_FLOAT_C(67936.1568001),
    MLO_FLOAT_C(67957.6836846),
    MLO_FLOAT_C(67979.212274),
    MLO_FLOAT_C(68000.742568),
    MLO_FLOAT_C(68022.2745663),
    MLO_FLOAT_C(68043.8082688),
    MLO_FLOAT_C(68065.343675),
    MLO_FLOAT_C(68086.8807849),
    MLO_FLOAT_C(68108.419598),
    MLO_FLOAT_C(68129.9601141),
    MLO_FLOAT_C(68151.5023329),
    MLO_FLOAT_C(68173.0462542),
    MLO_FLOAT_C(68194.5918777),
    MLO_FLOAT_C(68216.1392032),
    MLO_FLOAT_C(68237.6882303),
    MLO_FLOAT_C(68259.2389588),
    MLO_FLOAT_C(68280.7913884),
    MLO_FLOAT_C(68302.3455189),
    MLO_FLOAT_C(68323.90135),
    MLO_FLOAT_C(68345.4588814),
    MLO_FLOAT_C(68367.0181129),
    MLO_FLOAT_C(68388.5790441),
    MLO_FLOAT_C(68410.1416749),
    MLO_FLOAT_C(68431.7060049),
    MLO_FLOAT_C(68453.2720339),
    MLO_FLOAT_C(68474.8397616),
    MLO_FLOAT_C(68496.4091878),
    MLO_FLOAT_C(68517.9803121),
    MLO_FLOAT_C(68539.5531344),
    MLO_FLOAT_C(68561.1276542),
    MLO_FLOAT_C(68582.7038715),
    MLO_FLOAT_C(68604.2817859),
    MLO_FLOAT_C(68625.8613971),
    MLO_FLOAT_C(68647.4427049),
    MLO_FLOAT_C(68669.025709),
    MLO_FLOAT_C(68690.6104092),
    MLO_FLOAT_C(68712.1968051),
    MLO_FLOAT_C(68733.7848966),
    MLO_FLOAT_C(68755.3746833),
    MLO_FLOAT_C(68776.9661649),
    MLO_FLOAT_C(68798.5593413),
    MLO_FLOAT_C(68820.1542121),
    MLO_FLOAT_C(68841.7507771),
    MLO_FLOAT_C(68863.3490361),
    MLO_FLOAT_C(68884.9489886),
    MLO_FLOAT_C(68906.5506346),
    MLO_FLOAT_C(68928.1539737),
    MLO_FLOAT_C(68949.7590056),
    MLO_FLOAT_C(68971.3657301),
    MLO_FLOAT_C(68992.9741469),
    MLO_FLOAT_C(69014.5842558),
    MLO_FLOAT_C(69036.1960565),
    MLO_FLOAT_C(69057.8095487),
    MLO_FLOAT_C(69079.4247322),
    MLO_FLOAT_C(69101.0416067),
    MLO_FLOAT_C(69122.6601719),
    MLO_FLOAT_C(69144.2804276),
    MLO_FLOAT_C(69165.9023734),
    MLO_FLOAT_C(69187.5260093),
    MLO_FLOAT_C(69209.1513347),
    MLO_FLOAT_C(69230.7783497),
    MLO_FLOAT_C(69252.4070537),
    MLO_FLOAT_C(69274.0374467),
    MLO_FLOAT_C(69295.6695282),
    MLO_FLOAT_C(69317.3032981),
    MLO_FLOAT_C(69338.9387562),
    MLO_FLOAT_C(69360.575902),
    MLO_FLOAT_C(69382.2147354),
    MLO_FLOAT_C(69403.8552561),
    MLO_FLOAT_C(69425.4974639),
    MLO_FLOAT_C(69447.1413584),
    MLO_FLOAT_C(69468.7869395),
    MLO_FLOAT_C(69490.4342068),
    MLO_FLOAT_C(69512.0831601),
    MLO_FLOAT_C(69533.7337991),
    MLO_FLOAT_C(69555.3861236),
    MLO_FLOAT_C(69577.0401333),
    MLO_FLOAT_C(69598.6958279),
    MLO_FLOAT_C(69620.3532072),
    MLO_FLOAT_C(69642.012271),
    MLO_FLOAT_C(69663.6730188),
    MLO_FLOAT_C(69685.3354506),
    MLO_FLOAT_C(69706.999566),
    MLO_FLOAT_C(69728.6653648),
    MLO_FLOAT_C(69750.3328467),
    MLO_FLOAT_C(69772.0020114),
    MLO_FLOAT_C(69793.6728587),
    MLO_FLOAT_C(69815.3453883),
    MLO_FLOAT_C(69837.0196),
    MLO_FLOAT_C(69858.6954935),
    MLO_FLOAT_C(69880.3730686),
    MLO_FLOAT_C(69902.0523249),
    MLO_FLOAT_C(69923.7332622),
    MLO_FLOAT_C(69945.4158803),
    MLO_FLOAT_C(69967.1001789),
    MLO_FLOAT_C(69988.7861577),
    MLO_FLOAT_C(70010.4738165),
    MLO_FLOAT_C(70032.163155),
    MLO_FLOAT_C(70053.854173),
    MLO_FLOAT_C(70075.5468702),
    MLO_FLOAT_C(70097.2412463),
    MLO_FLOAT_C(70118.9373011),
    MLO_FLOAT_C(70140.6350343),
    MLO_FLOAT_C(70162.3344456),
    MLO_FLOAT_C(70184.0355349),
    MLO_FLOAT_C(70205.7383018),
    MLO_FLOAT_C(70227.4427461),
    MLO_FLOAT_C(70249.1488674),
    MLO_FLOAT_C(70270.8566657),
    MLO_FLOAT_C(70292.5661406),
    MLO_FLOAT_C(70314.2772918),
    MLO_FLOAT_C(70335.990119),
    MLO_FLOAT_C(70357.7046221),
    MLO_FLOAT_C(70379.4208008),
    MLO_FLOAT_C(70401.1386548),
    MLO_FLOAT_C(70422.8581838),
    MLO_FLOAT_C(70444.5793876),
    MLO_FLOAT_C(70466.302266),
    MLO_FLOAT_C(70488.0268186),
    MLO_FLOAT_C(70509.7530453),
    MLO_FLOAT_C(70531.4809457),
    MLO_FLOAT_C(70553.2105196),
    MLO_FLOAT_C(70574.9417667),
    MLO_FLOAT_C(70596.6746869),
    MLO_FLOAT_C(70618.4092797),
    MLO_FLOAT_C(70640.1455451),
    MLO_FLOAT_C(70661.8834826),
    MLO_FLOAT_C(70683.6230921),
    MLO_FLOAT_C(70705.3643733),
    MLO_FLOAT_C(70727.107326),
    MLO_FLOAT_C(70748.8519498),
    MLO_FLOAT_C(70770.5982445),
    MLO_FLOAT_C(70792.34621),
    MLO_FLOAT_C(70814.0958458),
    MLO_FLOAT_C(70835.8471518),
    MLO_FLOAT_C(70857.6001277),
    MLO_FLOAT_C(70879.3547733),
    MLO_FLOAT_C(70901.1110882),
    MLO_FLOAT_C(70922.8690723),
    MLO_FLOAT_C(70944.6287252),
    MLO_FLOAT_C(70966.3900468),
    MLO_FLOAT_C(70988.1530367),
    MLO_FLOAT_C(71009.9176948),
    MLO_FLOAT_C(71031.6840207),
    MLO_FLOAT_C(71053.4520142),
    MLO_FLOAT_C(71075.221675),
    MLO_FLOAT_C(71096.9930029),
    MLO_FLOAT_C(71118.7659977),
    MLO_FLOAT_C(71140.540659),
    MLO_FLOAT_C(71162.3169867),
    MLO_FLOAT_C(71184.0949804),
    MLO_FLOAT_C(71205.87464),
    MLO_FLOAT_C(71227.655965),
    MLO_FLOAT_C(71249.4389554),
    MLO_FLOAT_C(71271.2236109),
    MLO_FLOAT_C(71293.0099311),
    MLO_FLOAT_C(71314.7979159),
    MLO_FLOAT_C(71336.587565),
    MLO_FLOAT_C(71358.3788781),
    MLO_FLOAT_C(71380.1718549),
    MLO_FLOAT_C(71401.9664953),
    MLO_FLOAT_C(71423.762799),
    MLO_FLOAT_C(71445.5607657),
    MLO_FLOAT_C(71467.3603951),
    MLO_FLOAT_C(71489.161687),
    MLO_FLOAT_C(71510.9646412),
    MLO_FLOAT_C(71532.7692574),
    MLO_FLOAT_C(71554.5755354),
    MLO_FLOAT_C(71576.3834748),
    MLO_FLOAT_C(71598.1930755),
    MLO_FLOAT_C(71620.0043372),
    MLO_FLOAT_C(71641.8172596),
    MLO_FLOAT_C(71663.6318425),
    MLO_FLOAT_C(71685.4480856),
    MLO_FLOAT_C(71707.2659887),
    MLO_FLOAT_C(71729.0855515),
    MLO_FLOAT_C(71750.9067738),
    MLO_FLOAT_C(71772.7296553),
    MLO_FLOAT_C(71794.5541957),
    MLO_FLOAT_C(71816.3803949),
    MLO_FLOAT_C(71838.2082526),
    MLO_FLOAT_C(71860.0377684),
    MLO_FLOAT_C(71881.8689423),
    MLO_FLOAT_C(71903.7017738),
    MLO_FLOAT_C(71925.5362628),
    MLO_FLOAT_C(71947.372409),
    MLO_FLOAT_C(71969.2102121),
    MLO_FLOAT_C(71991.0496719),
    MLO_FLOAT_C(72012.8907882),
    MLO_FLOAT_C(72034.7335607),
    MLO_FLOAT_C(72056.5779891),
    MLO_FLOAT_C(72078.4240733),
    MLO_FLOAT_C(72100.2718129),
    MLO_FLOAT_C(72122.1212076),
    MLO_FLOAT_C(72143.9722573),
    MLO_FLOAT_C(72165.8249618),
    MLO_FLOAT_C(72187.6793206),
    MLO_FLOAT_C(72209.5353336),
    MLO_FLOAT_C(72231.3930006),
    MLO_FLOAT_C(72253.2523213),
    MLO_FLOAT_C(72275.1132954),
    MLO_FLOAT_C(72296.9759227),
    MLO_FLOAT_C(72318.840203),
    MLO_FLOAT_C(72340.7061359),
    MLO_FLOAT_C(72362.5737213),
    MLO_FLOAT_C(72384.4429589),
    MLO_FLOAT_C(72406.3138484),
    MLO_FLOAT_C(72428.1863896),
    MLO_FLOAT_C(72450.0605823),
    MLO_FLOAT_C(72471.9364261),
    MLO_FLOAT_C(72493.8139209),
    MLO_FLOAT_C(72515.6930664),
    MLO_FLOAT_C(72537.5738623),
    MLO_FLOAT_C(72559.4563085),
    MLO_FLOAT_C(72581.3404045),
    MLO_FLOAT_C(72603.2261503),
    MLO_FLOAT_C(72625.1135455),
    MLO_FLOAT_C(72647.00259),
    MLO_FLOAT_C(72668.8932834),
    MLO_FLOAT_C(72690.7856255),
    MLO_FLOAT_C(72712.679616),
    MLO_FLOAT_C(72734.5752548),
    MLO_FLOAT_C(72756.4725415),
    MLO_FLOAT_C(72778.3714759),
    MLO_FLOAT_C(72800.2720578),
    MLO_FLOAT_C(72822.174287),
    MLO_FLOAT_C(72844.0781631),
    MLO_FLOAT_C(72865.9836859),
    MLO_FLOAT_C(72887.8908552),
    MLO_FLOAT_C(72909.7996707),
    MLO_FLOAT_C(72931.7101322),
    MLO_FLOAT_C(72953.6222394),
    MLO_FLOAT_C(72975.5359921),
    MLO_FLOAT_C(72997.4513901),
    MLO_FLOAT_C(73019.368433),
    MLO_FLOAT_C(73041.2871207),
    MLO_FLOAT_C(73063.2074529),
    MLO_FLOAT_C(73085.1294293),
    MLO_FLOAT_C(73107.0530497),
    MLO_FLOAT_C(73128.9783139),
    MLO_FLOAT_C(73150.9052217),
    MLO_FLOAT_C(73172.8337726),
    MLO_FLOAT_C(73194.7639666),
    MLO_FLOAT_C(73216.6958034),
    MLO_FLOAT_C(73238.6292827),
    MLO_FLOAT_C(73260.5644043),
    MLO_FLOAT_C(73282.5011679),
    MLO_FLOAT_C(73304.4395733),
    MLO_FLOAT_C(73326.3796202),
    MLO_FLOAT_C(73348.3213084),
    MLO_FLOAT_C(73370.2646377),
    MLO_FLOAT_C(73392.2096078),
    MLO_FLOAT_C(73414.1562185),
    MLO_FLOAT_C(73436.1044695),
    MLO_FLOAT_C(73458.0543605),
    MLO_FLOAT_C(73480.0058914),
    MLO_FLOAT_C(73501.9590618),
    MLO_FLOAT_C(73523.9138716),
    MLO_FLOAT_C(73545.8703205),
    MLO_FLOAT_C(73567.8284082),
    MLO_FLOAT_C(73589.7881346),
    MLO_FLOAT_C(73611.7494992),
    MLO_FLOAT_C(73633.712502),
    MLO_FLOAT_C(73655.6771427),
    MLO_FLOAT_C(73677.643421),
    MLO_FLOAT_C(73699.6113367),
    MLO_FLOAT_C(73721.5808895),
    MLO_FLOAT_C(73743.5520792),
    MLO_FLOAT_C(73765.5249055),
    MLO_FLOAT_C(73787.4993683),
    MLO_FLOAT_C(73809.4754672),
    MLO_FLOAT_C(73831.4532021),
    MLO_FLOAT_C(73853.4325726),
    MLO_FLOAT_C(73875.4135785),
    MLO_FLOAT_C(73897.3962196),
    MLO_FLOAT_C(73919.3804957),
    MLO_FLOAT_C(73941.3664065),
    MLO_FLOAT_C(73963.3539517),
    MLO_FLOAT_C(73985.3431312),
    MLO_FLOAT_C(74007.3339446),
    MLO_FLOAT_C(74029.3263917),
    MLO_FLOAT_C(74051.3204724),
    MLO_FLOAT_C(74073.3161862),
    MLO_FLOAT_C(74095.3135331),
    MLO_FLOAT_C(74117.3125128),
    MLO_FLOAT_C(74139.3131249),
    MLO_FLOAT_C(74161.3153693),
    MLO_FLOAT_C(74183.3192458),
    MLO_FLOAT_C(74205.3247541),
    MLO_FLOAT_C(74227.3318939),
    MLO_FLOAT_C(74249.340665),
    MLO_FLOAT_C(74271.3510671),
    MLO_FLOAT_C(74293.3631001),
    MLO_FLOAT_C(74315.3767637),
    MLO_FLOAT_C(74337.3920576),
    MLO_FLOAT_C(74359.4089816),
    MLO_FLOAT_C(74381.4275355),
    MLO_FLOAT_C(74403.447719),
    MLO_FLOAT_C(74425.4695319),
    MLO_FLOAT_C(74447.4929739),
    MLO_FLOAT_C(74469.5180447),
    MLO_FLOAT_C(74491.5447443),
    MLO_FLOAT_C(74513.5730722),
    MLO_FLOAT_C(74535.6030284),
    MLO_FLOAT_C(74557.6346124),
    MLO_FLOAT_C(74579.6678241),
    MLO_FLOAT_C(74601.7026633),
    MLO_FLOAT_C(74623.7391297),
    MLO_FLOAT_C(74645.7772231),
    MLO_FLOAT_C(74667.8169432),
    MLO_FLOAT_C(74689.8582898),
    MLO_FLOAT_C(74711.9012626),
    MLO_FLOAT_C(74733.9458614),
    MLO_FLOAT_C(74755.992086),
    MLO_FLOAT_C(74778.0399362),
    MLO_FLOAT_C(74800.0894116),
    MLO_FLOAT_C(74822.140512),
    MLO_FLOAT_C(74844.1932373),
    MLO_FLOAT_C(74866.2475872),
    MLO_FLOAT_C(74888.3035613),
    MLO_FLOAT_C(74910.3611596),
    MLO_FLOAT_C(74932.4203817),
    MLO_FLOAT_C(74954.4812275),
    MLO_FLOAT_C(74976.5436966),
    MLO_FLOAT_C(74998.6077888),
    MLO_FLOAT_C(75020.673504),
    MLO_FLOAT_C(75042.7408418),
    MLO_FLOAT_C(75064.809802),
    MLO_FLOAT_C(75086.8803844),
    MLO_FLOAT_C(75108.9525887),
    MLO_FLOAT_C(75131.0264148),
    MLO_FLOAT_C(75153.1018623),
    MLO_FLOAT_C(75175.178931),
    MLO_FLOAT_C(75197.2576208),
    MLO_FLOAT_C(75219.3379312),
    MLO_FLOAT_C(75241.4198622),
    MLO_FLOAT_C(75263.5034135),
    MLO_FLOAT_C(75285.5885848),
    MLO_FLOAT_C(75307.6753759),
    MLO_FLOAT_C(75329.7637866),
    MLO_FLOAT_C(75351.8538166),
    MLO_FLOAT_C(75373.9454657),
    MLO_FLOAT_C(75396.0387336),
    MLO_FLOAT_C(75418.1336202),
    MLO_FLOAT_C(75440.2301251),
    MLO_FLOAT_C(75462.3282482),
    MLO_FLOAT_C(75484.4279891),
    MLO_FLOAT_C(75506.5293478),
    MLO_FLOAT_C(75528.6323238),
    MLO_FLOAT_C(75550.7369171),
    MLO_FLOAT_C(75572.8431273),
    MLO_FLOAT_C(75594.9509543),
    MLO_FLOAT_C(75617.0603977),
    MLO_FLOAT_C(75639.1714573),
    MLO_FLOAT_C(75661.284133),
    MLO_FLOAT_C(75683.3984245),
    MLO_FLOAT_C(75705.5143314),
    MLO_FLOAT_C(75727.6318537),
    MLO_FLOAT_C(75749.7509911),
    MLO_FLOAT_C(75771.8717433),
    MLO_FLOAT_C(75793.99411),
    MLO_FLOAT_C(75816.1180912),
    MLO_FLOAT_C(75838.2436864),
    MLO_FLOAT_C(75860.3708956),
    MLO_FLOAT_C(75882.4997184),
    MLO_FLOAT_C(75904.6301546),
    MLO_FLOAT_C(75926.762204),
    MLO_FLOAT_C(75948.8958663),
    MLO_FLOAT_C(75971.0311414),
    MLO_FLOAT_C(75993.1680289),
    MLO_FLOAT_C(76015.3065287),
    MLO_FLOAT_C(76037.4466405),
    MLO_FLOAT_C(76059.588364),
    MLO_FLOAT_C(76081.7316991),
    MLO_FLOAT_C(76103.8766455),
    MLO_FLOAT_C(76126.023203),
    MLO_FLOAT_C(76148.1713713),
    MLO_FLOAT_C(76170.3211502),
    MLO_FLOAT_C(76192.4725395),
    MLO_FLOAT_C(76214.6255389),
    MLO_FLOAT_C(76236.7801482),
    MLO_FLOAT_C(76258.9363671),
    MLO_FLOAT_C(76281.0941955),
    MLO_FLOAT_C(76303.2536331),
    MLO_FLOAT_C(76325.4146796),
    MLO_FLOAT_C(76347.5773349),
    MLO_FLOAT_C(76369.7415987),
    MLO_FLOAT_C(76391.9074707),
    MLO_FLOAT_C(76414.0749508),
    MLO_FLOAT_C(76436.2440387),
    MLO_FLOAT_C(76458.4147341),
    MLO_FLOAT_C(76480.5870368),
    MLO_FLOAT_C(76502.7609467),
    MLO_FLOAT_C(76524.9364634),
    MLO_FLOAT_C(76547.1135867),
    MLO_FLOAT_C(76569.2923165),
    MLO_FLOAT_C(76591.4726524),
    MLO_FLOAT_C(76613.6545942),
    MLO_FLOAT_C(76635.8381417),
    MLO_FLOAT_C(76658.0232947),
    MLO_FLOAT_C(76680.210053),
    MLO_FLOAT_C(76702.3984162),
    MLO_FLOAT_C(76724.5883842),
    MLO_FLOAT_C(76746.7799568),
    MLO_FLOAT_C(76768.9731336),
    MLO_FLOAT_C(76791.1679146),
    MLO_FLOAT_C(76813.3642994),
    MLO_FLOAT_C(76835.5622877),
    MLO_FLOAT_C(76857.7618795),
    MLO_FLOAT_C(76879.9630744),
    MLO_FLOAT_C(76902.1658723),
    MLO_FLOAT_C(76924.3702728),
    MLO_FLOAT_C(76946.5762757),
    MLO_FLOAT_C(76968.7838809),
    MLO_FLOAT_C(76990.9930881),
    MLO_FLOAT_C(77013.2038971),
    MLO_FLOAT_C(77035.4163075),
    MLO_FLOAT_C(77057.6303193),
    MLO_FLOAT_C(77079.8459322),
    MLO_FLOAT_C(77102.0631458),
    MLO_FLOAT_C(77124.2819601),
    MLO_FLOAT_C(77146.5023748),
    MLO_FLOAT_C(77168.7243896),
    MLO_FLOAT_C(77190.9480043),
    MLO_FLOAT_C(77213.1732187),
    MLO_FLOAT_C(77235.4000325),
    MLO_FLOAT_C(77257.6284456),
    MLO_FLOAT_C(77279.8584577),
    MLO_FLOAT_C(77302.0900685),
    MLO_FLOAT_C(77324.3232779),
    MLO_FLOAT_C(77346.5580856),
    MLO_FLOAT_C(77368.7944913),
    MLO_FLOAT_C(77391.0324949),
    MLO_FLOAT_C(77413.2720961),
    MLO_FLOAT_C(77435.5132947),
    MLO_FLOAT_C(77457.7560905),
    MLO_FLOAT_C(77480.0004832),
    MLO_FLOAT_C(77502.2464726),
    MLO_FLOAT_C(77524.4940584),
    MLO_FLOAT_C(77546.7432405),
    MLO_FLOAT_C(77568.9940186),
    MLO_FLOAT_C(77591.2463925),
    MLO_FLOAT_C(77613.5003619),
    MLO_FLOAT_C(77635.7559266),
    MLO_FLOAT_C(77658.0130865),
    MLO_FLOAT_C(77680.2718412),
    MLO_FLOAT_C(77702.5321905),
    MLO_FLOAT_C(77724.7941343),
    MLO_FLOAT_C(77747.0576723),
    MLO_FLOAT_C(77769.3228041),
    MLO_FLOAT_C(77791.5895298),
    MLO_FLOAT_C(77813.8578489),
    MLO_FLOAT_C(77836.1277613),
    MLO_FLOAT_C(77858.3992667),
    MLO_FLOAT_C(77880.6723649),
    MLO_FLOAT_C(77902.9470558),
    MLO_FLOAT_C(77925.2233389),
    MLO_FLOAT_C(77947.5012143),
    MLO_FLOAT_C(77969.7806815),
    MLO_FLOAT_C(77992.0617404),
    MLO_FLOAT_C(78014.3443907),
    MLO_FLOAT_C(78036.6286323),
    MLO_FLOAT_C(78058.9144648),
    MLO_FLOAT_C(78081.2018881),
    MLO_FLOAT_C(78103.490902),
    MLO_FLOAT_C(78125.7815061),
    MLO_FLOAT_C(78148.0737004),
    MLO_FLOAT_C(78170.3674845),
    MLO_FLOAT_C(78192.6628582),
    MLO_FLOAT_C(78214.9598214),
    MLO_FLOAT_C(78237.2583737),
    MLO_FLOAT_C(78259.558515),
    MLO_FLOAT_C(78281.860245),
    MLO_FLOAT_C(78304.1635635),
    MLO_FLOAT_C(78326.4684702),
    MLO_FLOAT_C(78348.7749651),
    MLO_FLOAT_C(78371.0830477),
    MLO_FLOAT_C(78393.3927179),
    MLO_FLOAT_C(78415.7039755),
    MLO_FLOAT_C(78438.0168203),
    MLO_FLOAT_C(78460.3312519),
    MLO_FLOAT_C(78482.6472703),
    MLO_FLOAT_C(78504.9648751),
    MLO_FLOAT_C(78527.2840662),
    MLO_FLOAT_C(78549.6048432),
    MLO_FLOAT_C(78571.9272061),
    MLO_FLOAT_C(78594.2511545),
    MLO_FLOAT_C(78616.5766883),
    MLO_FLOAT_C(78638.9038072),
    MLO_FLOAT_C(78661.2325109),
    MLO_FLOAT_C(78683.5627994),
    MLO_FLOAT_C(78705.8946722),
    MLO_FLOAT_C(78728.2281293),
    MLO_FLOAT_C(78750.5631704),
    MLO_FLOAT_C(78772.8997952),
    MLO_FLOAT_C(78795.2380036),
    MLO_FLOAT_C(78817.5777953),
    MLO_FLOAT_C(78839.9191701),
    MLO_FLOAT_C(78862.2621277),
    MLO_FLOAT_C(78884.606668),
    MLO_FLOAT_C(78906.9527907),
    MLO_FLOAT_C(78929.3004956),
    MLO_FLOAT_C(78951.6497825),
    MLO_FLOAT_C(78974.0006511),
    MLO_FLOAT_C(78996.3531013),
    MLO_FLOAT_C(79018.7071327),
    MLO_FLOAT_C(79041.0627452),
    MLO_FLOAT_C(79063.4199386),
    MLO_FLOAT_C(79085.7787126),
    MLO_FLOAT_C(79108.139067),
    MLO_FLOAT_C(79130.5010016),
    MLO_FLOAT_C(79152.8645161),
    MLO_FLOAT_C(79175.2296104),
    MLO_FLOAT_C(79197.5962842),
    MLO_FLOAT_C(79219.9645373),
    MLO_FLOAT_C(79242.3343694),
    MLO_FLOAT_C(79264.7057804),
    MLO_FLOAT_C(79287.07877),
    MLO_FLOAT_C(79309.453338),
    MLO_FLOAT_C(79331.8294842),
    MLO_FLOAT_C(79354.2072083),
    MLO_FLOAT_C(79376.5865102),
    MLO_FLOAT_C(79398.9673896),
    MLO_FLOAT_C(79421.3498462),
    MLO_FLOAT_C(79443.7338799),
    MLO_FLOAT_C(79466.1194905),
    MLO_FLOAT_C(79488.5066776),
    MLO_FLOAT_C(79510.8954412),
    MLO_FLOAT_C(79533.2857809),
    MLO_FLOAT_C(79555.6776966),
    MLO_FLOAT_C(79578.0711881),
    MLO_FLOAT_C(79600.466255),
    MLO_FLOAT_C(79622.8628972),
    MLO_FLOAT_C(79645.2611145),
    MLO_FLOAT_C(79667.6609066),
    MLO_FLOAT_C(79690.0622734),
    MLO_FLOAT_C(79712.4652145),
    MLO_FLOAT_C(79734.8697299),
    MLO_FLOAT_C(79757.2758191),
    MLO_FLOAT_C(79779.6834822),
    MLO_FLOAT_C(79802.0927187),
    MLO_FLOAT_C(79824.5035286),
    MLO_FLOAT_C(79846.9159115),
    MLO_FLOAT_C(79869.3298672),
    MLO_FLOAT_C(79891.7453956),
    MLO_FLOAT_C(79914.1624965),
    MLO_FLOAT_C(79936.5811695),
    MLO_FLOAT_C(79959.0014144),
    MLO_FLOAT_C(79981.4232312),
    MLO_FLOAT_C(80003.8466194),
    MLO_FLOAT_C(80026.271579),
    MLO_FLOAT_C(80048.6981097),
    MLO_FLOAT_C(80071.1262112),
    MLO_FLOAT_C(80093.5558834),
    MLO_FLOAT_C(80115.987126),
    MLO_FLOAT_C(80138.4199388),
    MLO_FLOAT_C(80160.8543216),
    MLO_FLOAT_C(80183.2902742),
    MLO_FLOAT_C(80205.7277964),
    MLO_FLOAT_C(80228.1668878),
    MLO_FLOAT_C(80250.6075484),
    MLO_FLOAT_C(80273.0497779),
    MLO_FLOAT_C(80295.493576),
    MLO_FLOAT_C(80317.9389426),
    MLO_FLOAT_C(80340.3858775),
    MLO_FLOAT_C(80362.8343803),
    MLO_FLOAT_C(80385.284451),
    MLO_FLOAT_C(80407.7360892),
    MLO_FLOAT_C(80430.1892948),
    MLO_FLOAT_C(80452.6440675),
    MLO_FLOAT_C(80475.1004072),
    MLO_FLOAT_C(80497.5583135),
    MLO_FLOAT_C(80520.0177864),
    MLO_FLOAT_C(80542.4788255),
    MLO_FLOAT_C(80564.9414306),
    MLO_FLOAT_C(80587.4056016),
    MLO_FLOAT_C(80609.8713382),
    MLO_FLOAT_C(80632.3386402),
    MLO_FLOAT_C(80654.8075073),
    MLO_FLOAT_C(80677.2779394),
    MLO_FLOAT_C(80699.7499363),
    MLO_FLOAT_C(80722.2234977),
    MLO_FLOAT_C(80744.6986234),
    MLO_FLOAT_C(80767.1753131),
    MLO_FLOAT_C(80789.6535668),
    MLO_FLOAT_C(80812.133384),
    MLO_FLOAT_C(80834.6147648),
    MLO_FLOAT_C(80857.0977087),
    MLO_FLOAT_C(80879.5822156),
    MLO_FLOAT_C(80902.0682853),
    MLO_FLOAT_C(80924.5559176),
    MLO_FLOAT_C(80947.0451122),
    MLO_FLOAT_C(80969.535869),
    MLO_FLOAT_C(80992.0281876),
    MLO_FLOAT_C(81014.522068),
    MLO_FLOAT_C(81037.0175098),
    MLO_FLOAT_C(81059.5145129),
    MLO_FLOAT_C(81082.0130771),
    MLO_FLOAT_C(81104.513202),
    MLO_FLOAT_C(81127.0148876),
    MLO_FLOAT_C(81149.5181336),
    MLO_FLOAT_C(81172.0229398),
    MLO_FLOAT_C(81194.5293059),
    MLO_FLOAT_C(81217.0372317),
    MLO_FLOAT_C(81239.5467171),
    MLO_FLOAT_C(81262.0577619),
    MLO_FLOAT_C(81284.5703657),
    MLO_FLOAT_C(81307.0845284),
    MLO_FLOAT_C(81329.6002497),
    MLO_FLOAT_C(81352.1175295),
    MLO_FLOAT_C(81374.6363676),
    MLO_FLOAT_C(81397.1567637),
    MLO_FLOAT_C(81419.6787175),
    MLO_FLOAT_C(81442.202229),
    MLO_FLOAT_C(81464.7272978),
    MLO_FLOAT_C(81487.2539238),
    MLO_FLOAT_C(81509.7821067),
    MLO_FLOAT_C(81532.3118464),
    MLO_FLOAT_C(81554.8431426),
    MLO_FLOAT_C(81577.3759951),
    MLO_FLOAT_C(81599.9104036),
    MLO_FLOAT_C(81622.446368),
    MLO_FLOAT_C(81644.9838881),
    MLO_FLOAT_C(81667.5229636),
    MLO_FLOAT_C(81690.0635944),
    MLO_FLOAT_C(81712.6057801),
    MLO_FLOAT_C(81735.1495206),
    MLO_FLOAT_C(81757.6948158),
    MLO_FLOAT_C(81780.2416652),
    MLO_FLOAT_C(81802.7900689),
    MLO_FLOAT_C(81825.3400265),
    MLO_FLOAT_C(81847.8915377),
    MLO_FLOAT_C(81870.4446026),
    MLO_FLOAT_C(81892.9992207),
    MLO_FLOAT_C(81915.5553918),
    MLO_FLOAT_C(81938.1131159),
    MLO_FLOAT_C(81960.6723926),
    MLO_FLOAT_C(81983.2332217),
    MLO_FLOAT_C(82005.7956031),
    MLO_FLOAT_C(82028.3595365),
    MLO_FLOAT_C(82050.9250216),
    MLO_FLOAT_C(82073.4920584),
    MLO_FLOAT_C(82096.0606466),
    MLO_FLOAT_C(82118.6307858),
    MLO_FLOAT_C(82141.2024761),
    MLO_FLOAT_C(82163.7757171),
    MLO_FLOAT_C(82186.3505086),
    MLO_FLOAT_C(82208.9268504),
    MLO_FLOAT_C(82231.5047423),
    MLO_FLOAT_C(82254.084184),
    MLO_FLOAT_C(82276.6651755),
    MLO_FLOAT_C(82299.2477164),
    MLO_FLOAT_C(82321.8318065),
    MLO_FLOAT_C(82344.4174457),
    MLO_FLOAT_C(82367.0046337),
    MLO_FLOAT_C(82389.5933703),
    MLO_FLOAT_C(82412.1836553),
    MLO_FLOAT_C(82434.7754884),
    MLO_FLOAT_C(82457.3688696),
    MLO_FLOAT_C(82479.9637985),
    MLO_FLOAT_C(82502.5602749),
    MLO_FLOAT_C(82525.1582987),
    MLO_FLOAT_C(82547.7578696),
    MLO_FLOAT_C(82570.3589874),
    MLO_FLOAT_C(82592.9616519),
    MLO_FLOAT_C(82615.5658629),
    MLO_FLOAT_C(82638.1716201),
    MLO_FLOAT_C(82660.7789235),
    MLO_FLOAT_C(82683.3877726),
    MLO_FLOAT_C(82705.9981675),
    MLO_FLOAT_C(82728.6101077),
    MLO_FLOAT_C(82751.2235932),
    MLO_FLOAT_C(82773.8386236),
    MLO_FLOAT_C(82796.4551989),
    MLO_FLOAT_C(82819.0733188),
    MLO_FLOAT_C(82841.692983),
    MLO_FLOAT_C(82864.3141914),
    MLO_FLOAT_C(82886.9369437),
    MLO_FLOAT_C(82909.5612398),
    MLO_FLOAT_C(82932.1870794),
    MLO_FLOAT_C(82954.8144623),
    MLO_FLOAT_C(82977.4433884),
    MLO_FLOAT_C(83000.0738573),
    MLO_FLOAT_C(83022.7058689),
    MLO_FLOAT_C(83045.339423),
    MLO_FLOAT_C(83067.9745194),
    MLO_FLOAT_C(83090.6111578),
    MLO_FLOAT_C(83113.2493381),
    MLO_FLOAT_C(83135.88906),
    MLO_FLOAT_C(83158.5303234),
    MLO_FLOAT_C(83181.1731279),
    MLO_FLOAT_C(83203.8174735),
    MLO_FLOAT_C(83226.4633598),
    MLO_FLOAT_C(83249.1107868),
    MLO_FLOAT_C(83271.7597541),
    MLO_FLOAT_C(83294.4102616),
    MLO_FLOAT_C(83317.0623091),
    MLO_FLOAT_C(83339.7158963),
    MLO_FLOAT_C(83362.3710231),
    MLO_FLOAT_C(83385.0276892),
    MLO_FLOAT_C(83407.6858944),
    MLO_FLOAT_C(83430.3456385),
    MLO_FLOAT_C(83453.0069214),
    MLO_FLOAT_C(83475.6697427),
    MLO_FLOAT_C(83498.3341023),
    MLO_FLOAT_C(83521.0),
    MLO_FLOAT_C(83543.6674356),
    MLO_FLOAT_C(83566.3364088),
    MLO_FLOAT_C(83589.0069195),
    MLO_FLOAT_C(83611.6789674),
    MLO_FLOAT_C(83634.3525524),
    MLO_FLOAT_C(83657.0276742),
    MLO_FLOAT_C(83679.7043326),
    MLO_FLOAT_C(83702.3825274),
    MLO_FLOAT_C(83725.0622584),
    MLO_FLOAT_C(83747.7435254),
    MLO_FLOAT_C(83770.4263282),
    MLO_FLOAT_C(83793.1106666),
    MLO_FLOAT_C(83815.7965404),
    MLO_FLOAT_C(83838.4839493),
    MLO_FLOAT_C(83861.1728931),
    MLO_FLOAT_C(83883.8633718),
    MLO_FLOAT_C(83906.5553849),
    MLO_FLOAT_C(83929.2489324),
    MLO_FLOAT_C(83951.944014),
    MLO_FLOAT_C(83974.6406296),
    MLO_FLOAT_C(83997.3387788),
    MLO_FLOAT_C(84020.0384616),
    MLO_FLOAT_C(84042.7396776),
    MLO_FLOAT_C(84065.4424268),
    MLO_FLOAT_C(84088.1467088),
    MLO_FLOAT_C(84110.8525235),
    MLO_FLOAT_C(84133.5598706),
    MLO_FLOAT_C(84156.26875),
    MLO_FLOAT_C(84178.9791615),
    MLO_FLOAT_C(84201.6911048),
    MLO_FLOAT_C(84224.4045798),
    MLO_FLOAT_C(84247.1195862),
    MLO_FLOAT_C(84269.8361238),
    MLO_FLOAT_C(84292.5541925),
    MLO_FLOAT_C(84315.273792),
    MLO_FLOAT_C(84337.994922),
    MLO_FLOAT_C(84360.7175825),
    MLO_FLOAT_C(84383.4417732),
    MLO_FLOAT_C(84406.1674938),
    MLO_FLOAT_C(84428.8947443),
    MLO_FLOAT_C(84451.6235243),
    MLO_FLOAT_C(84474.3538337),
    MLO_FLOAT_C(84497.0856723),
    MLO_FLOAT_C(84519.8190398),
    MLO_FLOAT_C(84542.5539361),
    MLO_FLOAT_C(84565.290361),
    MLO_FLOAT_C(84588.0283142),
    MLO_FLOAT_C(84610.7677955),
    MLO_FLOAT_C(84633.5088047),
    MLO_FLOAT_C(84656.2513417),
    MLO_FLOAT_C(84678.9954062),
    MLO_FLOAT_C(84701.7409981),
    MLO_FLOAT_C(84724.488117),
    MLO_FLOAT_C(84747.2367629),
    MLO_FLOAT_C(84769.9869354),
    MLO_FLOAT_C(84792.7386345),
    MLO_FLOAT_C(84815.4918598),
    MLO_FLOAT_C(84838.2466113),
    MLO_FLOAT_C(84861.0028886),
    MLO_FLOAT_C(84883.7606916),
    MLO_FLOAT_C(84906.5200201),
    MLO_FLOAT_C(84929.2808738),
    MLO_FLOAT_C(84952.0432526),
    MLO_FLOAT_C(84974.8071563),
    MLO_FLOAT_C(84997.5725846),
    MLO_FLOAT_C(85020.3395374),
    MLO_FLOAT_C(85043.1080144),
    MLO_FLOAT_C(85065.8780155),
    MLO_FLOAT_C(85088.6495405),
    MLO_FLOAT_C(85111.422589),
    MLO_FLOAT_C(85134.197161),
    MLO_FLOAT_C(85156.9732562),
    MLO_FLOAT_C(85179.7508745),
    MLO_FLOAT_C(85202.5300156),
    MLO_FLOAT_C(85225.3106793),
    MLO_FLOAT_C(85248.0928654),
    MLO_FLOAT_C(85270.8765737),
    MLO_FLOAT_C(85293.661804),
    MLO_FLOAT_C(85316.4485561),
    MLO_FLOAT_C(85339.2368299),
    MLO_FLOAT_C(85362.026625),
    MLO_FLOAT_C(85384.8179413),
    MLO_FLOAT_C(85407.6107787),
    MLO_FLOAT_C(85430.4051368),
    MLO_FLOAT_C(85453.2010155),
    MLO_FLOAT_C(85475.9984146),
    MLO_FLOAT_C(85498.7973338),
    MLO_FLOAT_C(85521.5977731),
    MLO_FLOAT_C(85544.3997321),
    MLO_FLOAT_C(85567.2032107),
    MLO_FLOAT_C(85590.0082087),
    MLO_FLOAT_C(85612.8147258),
    MLO_FLOAT_C(85635.6227619),
    MLO_FLOAT_C(85658.4323168),
    MLO_FLOAT_C(85681.2433902),
    MLO_FLOAT_C(85704.055982),
    MLO_FLOAT_C(85726.8700919),
    MLO_FLOAT_C(85749.6857198),
    MLO_FLOAT_C(85772.5028655),
    MLO_FLOAT_C(85795.3215287),
    MLO_FLOAT_C(85818.1417092),
    MLO_FLOAT_C(85840.9634069),
    MLO_FLOAT_C(85863.7866216),
    MLO_FLOAT_C(85886.6113529),
    MLO_FLOAT_C(85909.4376009),
    MLO_FLOAT_C(85932.2653652),
    MLO_FLOAT_C(85955.0946456),
    MLO_FLOAT_C(85977.9254419),
    MLO_FLOAT_C(86000.757754),
    MLO_FLOAT_C(86023.5915816),
    MLO_FLOAT_C(86046.4269246),
    MLO_FLOAT_C(86069.2637827),
    MLO_FLOAT_C(86092.1021557),
    MLO_FLOAT_C(86114.9420435),
    MLO_FLOAT_C(86137.7834458),
    MLO_FLOAT_C(86160.6263624),
    MLO_FLOAT_C(86183.4707932),
    MLO_FLOAT_C(86206.3167379),
    MLO_FLOAT_C(86229.1641963),
    MLO_FLOAT_C(86252.0131682),
    MLO_FLOAT_C(86274.8636535),
    MLO_FLOAT_C(86297.7156519),
    MLO_FLOAT_C(86320.5691632),
    MLO_FLOAT_C(86343.4241872),
    MLO_FLOAT_C(86366.2807238),
    MLO_FLOAT_C(86389.1387727),
    MLO_FLOAT_C(86411.9983337),
    MLO_FLOAT_C(86434.8594067),
    MLO_FLOAT_C(86457.7219913),
    MLO_FLOAT_C(86480.5860875),
    MLO_FLOAT_C(86503.4516951),
    MLO_FLOAT_C(86526.3188137),
    MLO_FLOAT_C(86549.1874433),
    MLO_FLOAT_C(86572.0575836),
    MLO_FLOAT_C(86594.9292344),
    MLO_FLOAT_C(86617.8023956),
    MLO_FLOAT_C(86640.6770669),
    MLO_FLOAT_C(86663.5532481),
    MLO_FLOAT_C(86686.4309391),
    MLO_FLOAT_C(86709.3101395),
    MLO_FLOAT_C(86732.1908494),
    MLO_FLOAT_C(86755.0730683),
    MLO_FLOAT_C(86777.9567962),
    MLO_FLOAT_C(86800.8420328),
    MLO_FLOAT_C(86823.7287779),
    MLO_FLOAT_C(86846.6170314),
    MLO_FLOAT_C(86869.506793),
    MLO_FLOAT_C(86892.3980626),
    MLO_FLOAT_C(86915.2908399),
    MLO_FLOAT_C(86938.1851247),
    MLO_FLOAT_C(86961.0809169),
    MLO_FLOAT_C(86983.9782163),
    MLO_FLOAT_C(87006.8770225),
    MLO_FLOAT_C(87029.7773356),
    MLO_FLOAT_C(87052.6791551),
    MLO_FLOAT_C(87075.5824811),
    MLO_FLOAT_C(87098.4873132),
    MLO_FLOAT_C(87121.3936512),
    MLO_FLOAT_C(87144.301495),
    MLO_FLOAT_C(87167.2108443),
    MLO_FLOAT_C(87190.1216991),
    MLO_FLOAT_C(87213.0340589),
    MLO_FLOAT_C(87235.9479238),
    MLO_FLOAT_C(87258.8632934),
    MLO_FLOAT_C(87281.7801676),
    MLO_FLOAT_C(87304.6985461),
    MLO_FLOAT_C(87327.6184289),
    MLO_FLOAT_C(87350.5398156),
    MLO_FLOAT_C(87373.4627061),
    MLO_FLOAT_C(87396.3871002),
    MLO_FLOAT_C(87419.3129976),
    MLO_FLOAT_C(87442.2403983),
    MLO_FLOAT_C(87465.1693019),
    MLO_FLOAT_C(87488.0997084),
    MLO_FLOAT_C(87511.0316174),
    MLO_FLOAT_C(87533.9650289),
    MLO_FLOAT_C(87556.8999425),
    MLO_FLOAT_C(87579.8363582),
    MLO_FLOAT_C(87602.7742757),
    MLO_FLOAT_C(87625.7136947),
    MLO_FLOAT_C(87648.6546152),
    MLO_FLOAT_C(87671.597037),
    MLO_FLOAT_C(87694.5409597),
    MLO_FLOAT_C(87717.4863833),
    MLO_FLOAT_C(87740.4333075),
    MLO_FLOAT_C(87763.3817322),
    MLO_FLOAT_C(87786.331657),
    MLO_FLOAT_C(87809.283082),
    MLO_FLOAT_C(87832.2360068),
    MLO_FLOAT_C(87855.1904312),
    MLO_FLOAT_C(87878.1463551),
    MLO_FLOAT_C(87901.1037782),
    MLO_FLOAT_C(87924.0627004),
    MLO_FLOAT_C(87947.0231215),
    MLO_FLOAT_C(87969.9850413),
    MLO_FLOAT_C(87992.9484595),
    MLO_FLOAT_C(88015.913376),
    MLO_FLOAT_C(88038.8797906),
    MLO_FLOAT_C(88061.8477031),
    MLO_FLOAT_C(88084.8171133),
    MLO_FLOAT_C(88107.788021),
    MLO_FLOAT_C(88130.760426),
    MLO_FLOAT_C(88153.7343281),
    MLO_FLOAT_C(88176.7097271),
    MLO_FLOAT_C(88199.6866228),
    MLO_FLOAT_C(88222.6650151),
    MLO_FLOAT_C(88245.6449037),
    MLO_FLOAT_C(88268.6262884),
    MLO_FLOAT_C(88291.6091691),
    MLO_FLOAT_C(88314.5935455),
    MLO_FLOAT_C(88337.5794175),
    MLO_FLOAT_C(88360.5667848),
    MLO_FLOAT_C(88383.5556473),
    MLO_FLOAT_C(88406.5460047),
    MLO_FLOAT_C(88429.537857),
    MLO_FLOAT_C(88452.5312038),
    MLO_FLOAT_C(88475.526045),
    MLO_FLOAT_C(88498.5223803),
    MLO_FLOAT_C(88521.5202097),
    MLO_FLOAT_C(88544.5195329),
    MLO_FLOAT_C(88567.5203497),
    MLO_FLOAT_C(88590.5226599),
    MLO_FLOAT_C(88613.5264633),
    MLO_FLOAT_C(88636.5317597),
    MLO_FLOAT_C(88659.538549),
    MLO_FLOAT_C(88682.5468309),
    MLO_FLOAT_C(88705.5566053),
    MLO_FLOAT_C(88728.5678719),
    MLO_FLOAT_C(88751.5806306),
    MLO_FLOAT_C(88774.5948811),
    MLO_FLOAT_C(88797.6106233),
    MLO_FLOAT_C(88820.627857),
    MLO_FLOAT_C(88843.646582),
    MLO_FLOAT_C(88866.666798),
    MLO_FLOAT_C(88889.688505),
    MLO_FLOAT_C(88912.7117027),
    MLO_FLOAT_C(88935.7363908),
    MLO_FLOAT_C(88958.7625693),
    MLO_FLOAT_C(88981.790238),
    MLO_FLOAT_C(89004.8193965),
    MLO_FLOAT_C(89027.8500448),
    MLO_FLOAT_C(89050.8821827),
    MLO_FLOAT_C(89073.9158099),
    MLO_FLOAT_C(89096.9509262),
    MLO_FLOAT_C(89119.9875316),
    MLO_FLOAT_C(89143.0256257),
    MLO_FLOAT_C(89166.0652084),
    MLO_FLOAT_C(89189.1062795),
    MLO_FLOAT_C(89212.1488388),
    MLO_FLOAT_C(89235.1928861),
    MLO_FLOAT_C(89258.2384212),
    MLO_FLOAT_C(89281.2854439),
    MLO_FLOAT_C(89304.3339541),
    MLO_FLOAT_C(89327.3839515),
    MLO_FLOAT_C(89350.435436),
    MLO_FLOAT_C(89373.4884073),
    MLO_FLOAT_C(89396.5428653),
    MLO_FLOAT_C(89419.5988098),
    MLO_FLOAT_C(89442.6562405),
    MLO_FLOAT_C(89465.7151573),
    MLO_FLOAT_C(89488.7755601),
    MLO_FLOAT_C(89511.8374485),
    MLO_FLOAT_C(89534.9008224),
    MLO_FLOAT_C(89557.9656817),
    MLO_FLOAT_C(89581.0320261),
    MLO_FLOAT_C(89604.0998555),
    MLO_FLOAT_C(89627.1691696),
    MLO_FLOAT_C(89650.2399682),
    MLO_FLOAT_C(89673.3122513),
    MLO_FLOAT_C(89696.3860185),
    MLO_FLOAT_C(89719.4612697),
    MLO_FLOAT_C(89742.5380047),
    MLO_FLOAT_C(89765.6162233),
    MLO_FLOAT_C(89788.6959253),
    MLO_FLOAT_C(89811.7771105),
    MLO_FLOAT_C(89834.8597788),
    MLO_FLOAT_C(89857.9439299),
    MLO_FLOAT_C(89881.0295637),
    MLO_FLOAT_C(89904.1166799),
    MLO_FLOAT_C(89927.2052784),
    MLO_FLOAT_C(89950.2953589),
    MLO_FLOAT_C(89973.3869214),
    MLO_FLOAT_C(89996.4799656),
    MLO_FLOAT_C(90019.5744913),
    MLO_FLOAT_C(90042.6704983),
    MLO_FLOAT_C(90065.7679864),
    MLO_FLOAT_C(90088.8669555),
    MLO_FLOAT_C(90111.9674053),
    MLO_FLOAT_C(90135.0693357),
    MLO_FLOAT_C(90158.1727464),
    MLO_FLOAT_C(90181.2776373),
    MLO_FLOAT_C(90204.3840083),
    MLO_FLOAT_C(90227.491859),
    MLO_FLOAT_C(90250.6011893),
    MLO_FLOAT_C(90273.7119991),
    MLO_FLOAT_C(90296.8242881),
    MLO_FLOAT_C(90319.9380561),
    MLO_FLOAT_C(90343.053303),
    MLO_FLOAT_C(90366.1700286),
    MLO_FLOAT_C(90389.2882326),
    MLO_FLOAT_C(90412.407915),
    MLO_FLOAT_C(90435.5290754),
    MLO_FLOAT_C(90458.6517137),
    MLO_FLOAT_C(90481.7758298),
    MLO_FLOAT_C(90504.9014234),
    MLO_FLOAT_C(90528.0284943),
    MLO_FLOAT_C(90551.1570424),
    MLO_FLOAT_C(90574.2870674),
    MLO_FLOAT_C(90597.4185693),
    MLO_FLOAT_C(90620.5515477),
    MLO_FLOAT_C(90643.6860025),
    MLO_FLOAT_C(90666.8219335),
    MLO_FLOAT_C(90689.9593406),
    MLO_FLOAT_C(90713.0982235),
    MLO_FLOAT_C(90736.238582),
    MLO_FLOAT_C(90759.380416),
    MLO_FLOAT_C(90782.5237253),
    MLO_FLOAT_C(90805.6685096),
    MLO_FLOAT_C(90828.8147689),
    MLO_FLOAT_C(90851.9625028),
    MLO_FLOAT_C(90875.1117113),
    MLO_FLOAT_C(90898.2623941),
    MLO_FLOAT_C(90921.414551),
    MLO_FLOAT_C(90944.5681819),
    MLO_FLOAT_C(90967.7232866),
    MLO_FLOAT_C(90990.8798648),
    MLO_FLOAT_C(91014.0379165),
    MLO_FLOAT_C(91037.1974413),
    MLO_FLOAT_C(91060.3584392),
    MLO_FLOAT_C(91083.5209099),
    MLO_FLOAT_C(91106.6848532),
    MLO_FLOAT_C(91129.850269),
    MLO_FLOAT_C(91153.0171571),
    MLO_FLOAT_C(91176.1855172),
    MLO_FLOAT_C(91199.3553493),
    MLO_FLOAT_C(91222.526653),
    MLO_FLOAT_C(91245.6994283),
    MLO_FLOAT_C(91268.8736749),
    MLO_FLOAT_C(91292.0493926),
    MLO_FLOAT_C(91315.2265813),
    MLO_FLOAT_C(91338.4052408),
    MLO_FLOAT_C(91361.5853709),
    MLO_FLOAT_C(91384.7669714),
    MLO_FLOAT_C(91407.950042),
    MLO_FLOAT_C(91431.1345828),
    MLO_FLOAT_C(91454.3205933),
    MLO_FLOAT_C(91477.5080735),
    MLO_FLOAT_C(91500.6970232),
    MLO_FLOAT_C(91523.8874422),
    MLO_FLOAT_C(91547.0793302),
    MLO_FLOAT_C(91570.2726872),
    MLO_FLOAT_C(91593.4675129),
    MLO_FLOAT_C(91616.6638071),
    MLO_FLOAT_C(91639.8615697),
    MLO_FLOAT_C(91663.0608004),
    MLO_FLOAT_C(91686.2614992),
    MLO_FLOAT_C(91709.4636657),
    MLO_FLOAT_C(91732.6672998),
    MLO_FLOAT_C(91755.8724014),
    MLO_FLOAT_C(91779.0789702),
    MLO_FLOAT_C(91802.287006),
    MLO_FLOAT_C(91825.4965087),
    MLO_FLOAT_C(91848.7074781),
    MLO_FLOAT_C(91871.919914),
    MLO_FLOAT_C(91895.1338162),
    MLO_FLOAT_C(91918.3491845),
    MLO_FLOAT_C(91941.5660188),
    MLO_FLOAT_C(91964.7843188),
    MLO_FLOAT_C(91988.0040844),
    MLO_FLOAT_C(92011.2253154),
    MLO_FLOAT_C(92034.4480116),
    MLO_FLOAT_C(92057.6721728),
    MLO_FLOAT_C(92080.8977988),
    MLO_FLOAT_C(92104.1248895),
    MLO_FLOAT_C(92127.3534446),
    MLO_FLOAT_C(92150.583464),
    MLO_FLOAT_C(92173.8149475),
    MLO_FLOAT_C(92197.0478949),
    MLO_FLOAT_C(92220.2823061),
    MLO_FLOAT_C(92243.5181807),
    MLO_FLOAT_C(92266.7555188),
    MLO_FLOAT_C(92289.99432),
    MLO_FLOAT_C(92313.2345841),
    MLO_FLOAT_C(92336.4763111),
    MLO_FLOAT_C(92359.7195007),
    MLO_FLOAT_C(92382.9641528),
    MLO_FLOAT_C(92406.2102671),
    MLO_FLOAT_C(92429.4578434),
    MLO_FLOAT_C(92452.7068816),
    MLO_FLOAT_C(92475.9573816),
    MLO_FLOAT_C(92499.209343),
    MLO_FLOAT_C(92522.4627658),
    MLO_FLOAT_C(92545.7176497),
    MLO_FLOAT_C(92568.9739946),
    MLO_FLOAT_C(92592.2318003),
    MLO_FLOAT_C(92615.4910665),
    MLO_FLOAT_C(92638.7517932),
    MLO_FLOAT_C(92662.0139801),
    MLO_FLOAT_C(92685.2776271),
    MLO_FLOAT_C(92708.5427339),
    MLO_FLOAT_C(92731.8093004),
    MLO_FLOAT_C(92755.0773264),
    MLO_FLOAT_C(92778.3468117),
    MLO_FLOAT_C(92801.6177561),
    MLO_FLOAT_C(92824.8901595),
    MLO_FLOAT_C(92848.1640216),
    MLO_FLOAT_C(92871.4393424),
    MLO_FLOAT_C(92894.7161215),
    MLO_FLOAT_C(92917.9943589),
    MLO_FLOAT_C(92941.2740542),
    MLO_FLOAT_C(92964.5552075),
    MLO_FLOAT_C(92987.8378184),
    MLO_FLOAT_C(93011.1218868),
    MLO_FLOAT_C(93034.4074124),
    MLO_FLOAT_C(93057.6943952),
    MLO_FLOAT_C(93080.982835),
    MLO_FLOAT_C(93104.2727315),
    MLO_FLOAT_C(93127.5640846),
    MLO_FLOAT_C(93150.8568941),
    MLO_FLOAT_C(93174.1511597),
    MLO_FLOAT_C(93197.4468815),
    MLO_FLOAT_C(93220.744059),
    MLO_FLOAT_C(93244.0426922),
    MLO_FLOAT_C(93267.3427809),
    MLO_FLOAT_C(93290.6443249),
    MLO_FLOAT_C(93313.9473241),
    MLO_FLOAT_C(93337.2517781),
    MLO_FLOAT_C(93360.5576869),
    MLO_FLOAT_C(93383.8650503),
    MLO_FLOAT_C(93407.1738681),
    MLO_FLOAT_C(93430.4841401),
    MLO_FLOAT_C(93453.7958661),
    MLO_FLOAT_C(93477.109046),
    MLO_FLOAT_C(93500.4236795),
    MLO_FLOAT_C(93523.7397665),
    MLO_FLOAT_C(93547.0573069),
    MLO_FLOAT_C(93570.3763003),
    MLO_FLOAT_C(93593.6967467),
    MLO_FLOAT_C(93617.0186459),
    MLO_FLOAT_C(93640.3419976),
    MLO_FLOAT_C(93663.6668017),
    MLO_FLOAT_C(93686.9930581),
    MLO_FLOAT_C(93710.3207665),
    MLO_FLOAT_C(93733.6499267),
    MLO_FLOAT_C(93756.9805386),
    MLO_FLOAT_C(93780.312602),
    MLO_FLOAT_C(93803.6461168),
    MLO_FLOAT_C(93826.9810826),
    MLO_FLOAT_C(93850.3174995),
    MLO_FLOAT_C(93873.655367),
    MLO_FLOAT_C(93896.9946852),
    MLO_FLOAT_C(93920.3354538),
    MLO_FLOAT_C(93943.6776727),
    MLO_FLOAT_C(93967.0213415),
    MLO_FLOAT_C(93990.3664603),
    MLO_FLOAT_C(94013.7130287),
    MLO_FLOAT_C(94037.0610467),
    MLO_FLOAT_C(94060.410514),
    MLO_FLOAT_C(94083.7614304),
    MLO_FLOAT_C(94107.1137959),
    MLO_FLOAT_C(94130.4676101),
    MLO_FLOAT_C(94153.8228729),
    MLO_FLOAT_C(94177.1795841),
    MLO_FLOAT_C(94200.5377437),
    MLO_FLOAT_C(94223.8973512),
    MLO_FLOAT_C(94247.2584067),
    MLO_FLOAT_C(94270.6209099),
    MLO_FLOAT_C(94293.9848606),
    MLO_FLOAT_C(94317.3502587),
    MLO_FLOAT_C(94340.717104),
    MLO_FLOAT_C(94364.0853963),
    MLO_FLOAT_C(94387.4551353),
    MLO_FLOAT_C(94410.8263211),
    MLO_FLOAT_C(94434.1989532),
    MLO_FLOAT_C(94457.5730317),
    MLO_FLOAT_C(94480.9485563),
    MLO_FLOAT_C(94504.3255267),
    MLO_FLOAT_C(94527.703943),
    MLO_FLOAT_C(94551.0838048),
    MLO_FLOAT_C(94574.465112),
    MLO_FLOAT_C(94597.8478644),
    MLO_FLOAT_C(94621.2320618),
    MLO_FLOAT_C(94644.6177041),
    MLO_FLOAT_C(94668.004791),
    MLO_FLOAT_C(94691.3933224),
    MLO_FLOAT_C(94714.7832982),
    MLO_FLOAT_C(94738.1747181),
    MLO_FLOAT_C(94761.567582),
    MLO_FLOAT_C(94784.9618896),
    MLO_FLOAT_C(94808.3576408),
    MLO_FLOAT_C(94831.7548355),
    MLO_FLOAT_C(94855.1534734),
    MLO_FLOAT_C(94878.5535544),
    MLO_FLOAT_C(94901.9550783),
    MLO_FLOAT_C(94925.3580448),
    MLO_FLOAT_C(94948.762454),
    MLO_FLOAT_C(94972.1683054),
    MLO_FLOAT_C(94995.5755991),
    MLO_FLOAT_C(95018.9843347),
    MLO_FLOAT_C(95042.3945122),
    MLO_FLOAT_C(95065.8061314),
    MLO_FLOAT_C(95089.219192),
    MLO_FLOAT_C(95112.6336938),
    MLO_FLOAT_C(95136.0496368),
    MLO_FLOAT_C(95159.4670208),
    MLO_FLOAT_C(95182.8858455),
    MLO_FLOAT_C(95206.3061108),
    MLO_FLOAT_C(95229.7278164),
    MLO_FLOAT_C(95253.1509624),
    MLO_FLOAT_C(95276.5755483),
    MLO_FLOAT_C(95300.0015742),
    MLO_FLOAT_C(95323.4290397),
    MLO_FLOAT_C(95346.8579448),
    MLO_FLOAT_C(95370.2882892),
    MLO_FLOAT_C(95393.7200727),
    MLO_FLOAT_C(95417.1532953),
    MLO_FLOAT_C(95440.5879566),
    MLO_FLOAT_C(95464.0240566),
    MLO_FLOAT_C(95487.4615951),
    MLO_FLOAT_C(95510.9005718),
    MLO_FLOAT_C(95534.3409867),
    MLO_FLOAT_C(95557.7828395),
    MLO_FLOAT_C(95581.22613),
    MLO_FLOAT_C(95604.6708581),
    MLO_FLOAT_C(95628.1170236),
    MLO_FLOAT_C(95651.5646264),
    MLO_FLOAT_C(95675.0136662),
    MLO_FLOAT_C(95698.4641428),
    MLO_FLOAT_C(95721.9160562),
    MLO_FLOAT_C(95745.3694061),
    MLO_FLOAT_C(95768.8241923),
    MLO_FLOAT_C(95792.2804147),
    MLO_FLOAT_C(95815.738073),
    MLO_FLOAT_C(95839.1971672),
    MLO_FLOAT_C(95862.6576971),
    MLO_FLOAT_C(95886.1196624),
    MLO_FLOAT_C(95909.583063),
    MLO_FLOAT_C(95933.0478987),
    MLO_FLOAT_C(95956.5141693),
    MLO_FLOAT_C(95979.9818747),
    MLO_FLOAT_C(96003.4510147),
    MLO_FLOAT_C(96026.9215891),
    MLO_FLOAT_C(96050.3935978),
    MLO_FLOAT_C(96073.8670405),
    MLO_FLOAT_C(96097.3419171),
    MLO_FLOAT_C(96120.8182274),
    MLO_FLOAT_C(96144.2959713),
    MLO_FLOAT_C(96167.7751485),
    MLO_FLOAT_C(96191.2557589),
    MLO_FLOAT_C(96214.7378023),
    MLO_FLOAT_C(96238.2212785),
    MLO_FLOAT_C(96261.7061874),
    MLO_FLOAT_C(96285.1925288),
    MLO_FLOAT_C(96308.6803025),
    MLO_FLOAT_C(96332.1695083),
    MLO_FLOAT_C(96355.6601461),
    MLO_FLOAT_C(96379.1522157),
    MLO_FLOAT_C(96402.6457169),
    MLO_FLOAT_C(96426.1406496),
    MLO_FLOAT_C(96449.6370135),
    MLO_FLOAT_C(96473.1348085),
    MLO_FLOAT_C(96496.6340344),
    MLO_FLOAT_C(96520.1346911),
    MLO_FLOAT_C(96543.6367783),
    MLO_FLOAT_C(96567.1402959),
    MLO_FLOAT_C(96590.6452438),
    MLO_FLOAT_C(96614.1516216),
    MLO_FLOAT_C(96637.6594294),
    MLO_FLOAT_C(96661.1686669),
    MLO_FLOAT_C(96684.6793338),
    MLO_FLOAT_C(96708.1914302),
    MLO_FLOAT_C(96731.7049557),
    MLO_FLOAT_C(96755.2199102),
    MLO_FLOAT_C(96778.7362935),
    MLO_FLOAT_C(96802.2541055),
    MLO_FLOAT_C(96825.773346),
    MLO_FLOAT_C(96849.2940148),
    MLO_FLOAT_C(96872.8161117),
    MLO_FLOAT_C(96896.3396366),
    MLO_FLOAT_C(96919.8645893),
    MLO_FLOAT_C(96943.3909695),
    MLO_FLOAT_C(96966.9187773),
    MLO_FLOAT_C(96990.4480123),
    MLO_FLOAT_C(97013.9786744),
    MLO_FLOAT_C(97037.5107634),
    MLO_FLOAT_C(97061.0442791),
    MLO_FLOAT_C(97084.5792215),
    MLO_FLOAT_C(97108.1155902),
    MLO_FLOAT_C(97131.6533852),
    MLO_FLOAT_C(97155.1926062),
    MLO_FLOAT_C(97178.7332531),
    MLO_FLOAT_C(97202.2753258),
    MLO_FLOAT_C(97225.8188239),
    MLO_FLOAT_C(97249.3637475),
    MLO_FLOAT_C(97272.9100962),
    MLO_FLOAT_C(97296.4578699),
    MLO_FLOAT_C(97320.0070685),
    MLO_FLOAT_C(97343.5576918),
    MLO_FLOAT_C(97367.1097396),
    MLO_FLOAT_C(97390.6632117),
    MLO_FLOAT_C(97414.218108),
    MLO_FLOAT_C(97437.7744282),
    MLO_FLOAT_C(97461.3321723),
    MLO_FLOAT_C(97484.89134),
    MLO_FLOAT_C(97508.4519312),
    MLO_FLOAT_C(97532.0139457),
    MLO_FLOAT_C(97555.5773833),
    MLO_FLOAT_C(97579.1422439),
    MLO_FLOAT_C(97602.7085273),
    MLO_FLOAT_C(97626.2762332),
    MLO_FLOAT_C(97649.8453617),
    MLO_FLOAT_C(97673.4159123),
    MLO_FLOAT_C(97696.9878851),
    MLO_FLOAT_C(97720.5612798),
    MLO_FLOAT_C(97744.1360963),
    MLO_FLOAT_C(97767.7123343),
    MLO_FLOAT_C(97791.2899938),
    MLO_FLOAT_C(97814.8690745),
    MLO_FLOAT_C(97838.4495762),
    MLO_FLOAT_C(97862.0314989),
    MLO_FLOAT_C(97885.6148423),
    MLO_FLOAT_C(97909.1996062),
    MLO_FLOAT_C(97932.7857905),
    MLO_FLOAT_C(97956.3733951),
    MLO_FLOAT_C(97979.9624196),
    MLO_FLOAT_C(98003.5528641),
    MLO_FLOAT_C(98027.1447282),
    MLO_FLOAT_C(98050.7380119),
    MLO_FLOAT_C(98074.332715),
    MLO_FLOAT_C(98097.9288372),
    MLO_FLOAT_C(98121.5263784),
    MLO_FLOAT_C(98145.1253385),
    MLO_FLOAT_C(98168.7257173),
    MLO_FLOAT_C(98192.3275145),
    MLO_FLOAT_C(98215.9307301),
    MLO_FLOAT_C(98239.5353639),
    MLO_FLOAT_C(98263.1414157),
    MLO_FLOAT_C(98286.7488853),
    MLO_FLOAT_C(98310.3577725),
    MLO_FLOAT_C(98333.9680772),
    MLO_FLOAT_C(98357.5797992),
    MLO_FLOAT_C(98381.1929384),
    MLO_FLOAT_C(98404.8074946),
    MLO_FLOAT_C(98428.4234675),
    MLO_FLOAT_C(98452.0408571),
    MLO_FLOAT_C(98475.6596631),
    MLO_FLOAT_C(98499.2798855),
    MLO_FLOAT_C(98522.9015239),
    MLO_FLOAT_C(98546.5245784),
    MLO_FLOAT_C(98570.1490486),
    MLO_FLOAT_C(98593.7749344),
    MLO_FLOAT_C(98617.4022356),
    MLO_FLOAT_C(98641.0309522),
    MLO_FLOAT_C(98664.6610838),
    MLO_FLOAT_C(98688.2926304),
    MLO_FLOAT_C(98711.9255917),
    MLO_FLOAT_C(98735.5599676),
    MLO_FLOAT_C(98759.195758),
    MLO_FLOAT_C(98782.8329626),
    MLO_FLOAT_C(98806.4715813),
    MLO_FLOAT_C(98830.111614),
    MLO_FLOAT_C(98853.7530603),
    MLO_FLOAT_C(98877.3959203),
    MLO_FLOAT_C(98901.0401937),
    MLO_FLOAT_C(98924.6858803),
    MLO_FLOAT_C(98948.33298),
    MLO_FLOAT_C(98971.9814926),
    MLO_FLOAT_C(98995.6314179),
    MLO_FLOAT_C(99019.2827558),
    MLO_FLOAT_C(99042.9355061),
    MLO_FLOAT_C(99066.5896686),
    MLO_FLOAT_C(99090.2452432),
    MLO_FLOAT_C(99113.9022297),
    MLO_FLOAT_C(99137.5606279),
    MLO_FLOAT_C(99161.2204377),
    MLO_FLOAT_C(99184.8816589),
    MLO_FLOAT_C(99208.5442913),
    MLO_FLOAT_C(99232.2083347),
    MLO_FLOAT_C(99255.873789),
    MLO_FLOAT_C(99279.540654),
    MLO_FLOAT_C(99303.2089296),
    MLO_FLOAT_C(99326.8786156),
    MLO_FLOAT_C(99350.5497117),
    MLO_FLOAT_C(99374.222218),
    MLO_FLOAT_C(99397.896134),
    MLO_FLOAT_C(99421.5714598),
    MLO_FLOAT_C(99445.2481952),
    MLO_FLOAT_C(99468.9263399),
    MLO_FLOAT_C(99492.6058938),
    MLO_FLOAT_C(99516.2868567),
    MLO_FLOAT_C(99539.9692285),
    MLO_FLOAT_C(99563.6530091),
    MLO_FLOAT_C(99587.3381981),
    MLO_FLOAT_C(99611.0247955),
    MLO_FLOAT_C(99634.7128011),
    MLO_FLOAT_C(99658.4022148),
    MLO_FLOAT_C(99682.0930363),
    MLO_FLOAT_C(99705.7852655),
    MLO_FLOAT_C(99729.4789022),
    MLO_FLOAT_C(99753.1739463),
    MLO_FLOAT_C(99776.8703976),
    MLO_FLOAT_C(99800.5682559),
    MLO_FLOAT_C(99824.2675211),
    MLO_FLOAT_C(99847.9681929),
    MLO_FLOAT_C(99871.6702713),
    MLO_FLOAT_C(99895.3737561),
    MLO_FLOAT_C(99919.078647),
    MLO_FLOAT_C(99942.784944),
    MLO_FLOAT_C(99966.4926468),
    MLO_FLOAT_C(99990.2017553),
    MLO_FLOAT_C(100013.912269),
    MLO_FLOAT_C(100037.624189),
    MLO_FLOAT_C(100061.337513),
    MLO_FLOAT_C(100085.052243),
    MLO_FLOAT_C(100108.768377),
    MLO_FLOAT_C(100132.485917),
    MLO_FLOAT_C(100156.20486),
    MLO_FLOAT_C(100179.925208),
    MLO_FLOAT_C(100203.646961),
    MLO_FLOAT_C(100227.370117),
    MLO_FLOAT_C(100251.094677),
    MLO_FLOAT_C(100274.820641),
    MLO_FLOAT_C(100298.548008),
    MLO_FLOAT_C(100322.276779),
    MLO_FLOAT_C(100346.006953),
    MLO_FLOAT_C(100369.73853),
    MLO_FLOAT_C(100393.47151),
    MLO_FLOAT_C(100417.205892),
    MLO_FLOAT_C(100440.941677),
    MLO_FLOAT_C(100464.678865),
    MLO_FLOAT_C(100488.417454),
    MLO_FLOAT_C(100512.157446),
    MLO_FLOAT_C(100535.89884),
    MLO_FLOAT_C(100559.641635),
    MLO_FLOAT_C(100583.385832),
    MLO_FLOAT_C(100607.13143),
    MLO_FLOAT_C(100630.878429),
    MLO_FLOAT_C(100654.62683),
    MLO_FLOAT_C(100678.376631),
    MLO_FLOAT_C(100702.127833),
    MLO_FLOAT_C(100725.880436),
    MLO_FLOAT_C(100749.634438),
    MLO_FLOAT_C(100773.389842),
    MLO_FLOAT_C(100797.146645),
    MLO_FLOAT_C(100820.904848),
    MLO_FLOAT_C(100844.664451),
    MLO_FLOAT_C(100868.425453),
    MLO_FLOAT_C(100892.187855),
    MLO_FLOAT_C(100915.951656),
    MLO_FLOAT_C(100939.716856),
    MLO_FLOAT_C(100963.483455),
    MLO_FLOAT_C(100987.251453),
    MLO_FLOAT_C(101011.020849),
    MLO_FLOAT_C(101034.791644),
    MLO_FLOAT_C(101058.563837),
    MLO_FLOAT_C(101082.337428),
    MLO_FLOAT_C(101106.112417),
    MLO_FLOAT_C(101129.888803),
    MLO_FLOAT_C(101153.666587),
    MLO_FLOAT_C(101177.445769),
    MLO_FLOAT_C(101201.226348),
    MLO_FLOAT_C(101225.008324),
    MLO_FLOAT_C(101248.791697),
    MLO_FLOAT_C(101272.576467),
    MLO_FLOAT_C(101296.362633),
    MLO_FLOAT_C(101320.150196),
    MLO_FLOAT_C(101343.939155),
    MLO_FLOAT_C(101367.72951),
    MLO_FLOAT_C(101391.521261),
    MLO_FLOAT_C(101415.314408),
    MLO_FLOAT_C(101439.10895),
    MLO_FLOAT_C(101462.904888),
    MLO_FLOAT_C(101486.702221),
    MLO_FLOAT_C(101510.500949),
    MLO_FLOAT_C(101534.301073),
    MLO_FLOAT_C(101558.102591),
    MLO_FLOAT_C(101581.905503),
    MLO_FLOAT_C(101605.709811),
    MLO_FLOAT_C(101629.515512),
    MLO_FLOAT_C(101653.322608),
    MLO_FLOAT_C(101677.131097),
    MLO_FLOAT_C(101700.940981),
    MLO_FLOAT_C(101724.752258),
    MLO_FLOAT_C(101748.564928),
    MLO_FLOAT_C(101772.378992),
    MLO_FLOAT_C(101796.194449),
    MLO_FLOAT_C(101820.011299),
    MLO_FLOAT_C(101843.829542),
    MLO_FLOAT_C(101867.649178),
    MLO_FLOAT_C(101891.470206),
    MLO_FLOAT_C(101915.292626),
    MLO_FLOAT_C(101939.116439),
    MLO_FLOAT_C(101962.941644),
    MLO_FLOAT_C(101986.76824),
    MLO_FLOAT_C(102010.596228),
    MLO_FLOAT_C(102034.425608),
    MLO_FLOAT_C(102058.256379),
    MLO_FLOAT_C(102082.088542),
    MLO_FLOAT_C(102105.922095),
    MLO_FLOAT_C(102129.757039),
    MLO_FLOAT_C(102153.593374),
    MLO_FLOAT_C(102177.4311),
    MLO_FLOAT_C(102201.270216),
    MLO_FLOAT_C(102225.110722),
    MLO_FLOAT_C(102248.952618),
    MLO_FLOAT_C(102272.795904),
    MLO_FLOAT_C(102296.64058),
    MLO_FLOAT_C(102320.486646),
    MLO_FLOAT_C(102344.334101),
    MLO_FLOAT_C(102368.182945),
    MLO_FLOAT_C(102392.033178),
    MLO_FLOAT_C(102415.884801),
    MLO_FLOAT_C(102439.737812),
    MLO_FLOAT_C(102463.592211),
    MLO_FLOAT_C(102487.448),
    MLO_FLOAT_C(102511.305176),
    MLO_FLOAT_C(102535.163741),
    MLO_FLOAT_C(102559.023693),
    MLO_FLOAT_C(102582.885033),
    MLO_FLOAT_C(102606.747761),
    MLO_FLOAT_C(102630.611877),
    MLO_FLOAT_C(102654.47738),
    MLO_FLOAT_C(102678.34427),
    MLO_FLOAT_C(102702.212547),
    MLO_FLOAT_C(102726.082211),
    MLO_FLOAT_C(102749.953261),
    MLO_FLOAT_C(102773.825698),
    MLO_FLOAT_C(102797.699521),
    MLO_FLOAT_C(102821.574731),
    MLO_FLOAT_C(102845.451327),
    MLO_FLOAT_C(102869.329308),
    MLO_FLOAT_C(102893.208675),
    MLO_FLOAT_C(102917.089428),
    MLO_FLOAT_C(102940.971566),
    MLO_FLOAT_C(102964.85509),
    MLO_FLOAT_C(102988.739998),
    MLO_FLOAT_C(103012.626292),
    MLO_FLOAT_C(103036.51397),
    MLO_FLOAT_C(103060.403033),
    MLO_FLOAT_C(103084.29348),
    MLO_FLOAT_C(103108.185311),
    MLO_FLOAT_C(103132.078527),
    MLO_FLOAT_C(103155.973126),
    MLO_FLOAT_C(103179.86911),
    MLO_FLOAT_C(103203.766477),
    MLO_FLOAT_C(103227.665227),
    MLO_FLOAT_C(103251.565361),
    MLO_FLOAT_C(103275.466878),
    MLO_FLOAT_C(103299.369777),
    MLO_FLOAT_C(103323.27406),
    MLO_FLOAT_C(103347.179725),
    MLO_FLOAT_C(103371.086773),
    MLO_FLOAT_C(103394.995203),
    MLO_FLOAT_C(103418.905016),
    MLO_FLOAT_C(103442.81621),
    MLO_FLOAT_C(103466.728787),
    MLO_FLOAT_C(103490.642745),
    MLO_FLOAT_C(103514.558084),
    MLO_FLOAT_C(103538.474805),
    MLO_FLOAT_C(103562.392907),
    MLO_FLOAT_C(103586.312391),
    MLO_FLOAT_C(103610.233255),
    MLO_FLOAT_C(103634.1555),
    MLO_FLOAT_C(103658.079125),
    MLO_FLOAT_C(103682.004131),
    MLO_FLOAT_C(103705.930517),
    MLO_FLOAT_C(103729.858284),
    MLO_FLOAT_C(103753.78743),
    MLO_FLOAT_C(103777.717956),
    MLO_FLOAT_C(103801.649862),
    MLO_FLOAT_C(103825.583147),
    MLO_FLOAT_C(103849.517812),
    MLO_FLOAT_C(103873.453855),
    MLO_FLOAT_C(103897.391278),
    MLO_FLOAT_C(103921.33008),
    MLO_FLOAT_C(103945.27026),
    MLO_FLOAT_C(103969.211819),
    MLO_FLOAT_C(103993.154756),
    MLO_FLOAT_C(104017.099071),
    MLO_FLOAT_C(104041.044764),
    MLO_FLOAT_C(104064.991836),
    MLO_FLOAT_C(104088.940285),
    MLO_FLOAT_C(104112.890111),
    MLO_FLOAT_C(104136.841315),
    MLO_FLOAT_C(104160.793897),
    MLO_FLOAT_C(104184.747855),
    MLO_FLOAT_C(104208.70319),
    MLO_FLOAT_C(104232.659902),
    MLO_FLOAT_C(104256.617991),
    MLO_FLOAT_C(104280.577456),
    MLO_FLOAT_C(104304.538298),
    MLO_FLOAT_C(104328.500515),
    MLO_FLOAT_C(104352.464109),
    MLO_FLOAT_C(104376.429078),
    MLO_FLOAT_C(104400.395424),
    MLO_FLOAT_C(104424.363144),
    MLO_FLOAT_C(104448.33224),
    MLO_FLOAT_C(104472.302712),
    MLO_FLOAT_C(104496.274558),
    MLO_FLOAT_C(104520.247779),
    MLO_FLOAT_C(104544.222375),
    MLO_FLOAT_C(104568.198345),
    MLO_FLOAT_C(104592.17569),
    MLO_FLOAT_C(104616.154409),
    MLO_FLOAT_C(104640.134503),
    MLO_FLOAT_C(104664.11597),
    MLO_FLOAT_C(104688.098811),
    MLO_FLOAT_C(104712.083025),
    MLO_FLOAT_C(104736.068613),
    MLO_FLOAT_C(104760.055575),
    MLO_FLOAT_C(104784.043909),
    MLO_FLOAT_C(104808.033617),
    MLO_FLOAT_C(104832.024697),
    MLO_FLOAT_C(104856.01715),
    MLO_FLOAT_C(104880.010976),
    MLO_FLOAT_C(104904.006174),
    MLO_FLOAT_C(104928.002744),
    MLO_FLOAT_C(104952.000686),
    MLO_FLOAT_C(104976.0),
    MLO_FLOAT_C(105000.000686),
    MLO_FLOAT_C(105024.002743),
    MLO_FLOAT_C(105048.006172),
    MLO_FLOAT_C(105072.010972),
    MLO_FLOAT_C(105096.017144),
    MLO_FLOAT_C(105120.024686),
    MLO_FLOAT_C(105144.033599),
    MLO_FLOAT_C(105168.043882),
    MLO_FLOAT_C(105192.055537),
    MLO_FLOAT_C(105216.068561),
    MLO_FLOAT_C(105240.082956),
    MLO_FLOAT_C(105264.09872),
    MLO_FLOAT_C(105288.115855),
    MLO_FLOAT_C(105312.134359),
    MLO_FLOAT_C(105336.154233),
    MLO_FLOAT_C(105360.175476),
    MLO_FLOAT_C(105384.198088),
    MLO_FLOAT_C(105408.22207),
    MLO_FLOAT_C(105432.24742),
    MLO_FLOAT_C(105456.27414),
    MLO_FLOAT_C(105480.302227),
    MLO_FLOAT_C(105504.331684),
    MLO_FLOAT_C(105528.362508),
    MLO_FLOAT_C(105552.394701),
    MLO_FLOAT_C(105576.428262),
    MLO_FLOAT_C(105600.46319),
    MLO_FLOAT_C(105624.499487),
    MLO_FLOAT_C(105648.53715),
    MLO_FLOAT_C(105672.576181),
    MLO_FLOAT_C(105696.61658),
    MLO_FLOAT_C(105720.658345),
    MLO_FLOAT_C(105744.701478),
    MLO_FLOAT_C(105768.745977),
    MLO_FLOAT_C(105792.791842),
    MLO_FLOAT_C(105816.839074),
    MLO_FLOAT_C(105840.887673),
    MLO_FLOAT_C(105864.937637),
    MLO_FLOAT_C(105888.988968),
    MLO_FLOAT_C(105913.041664),
    MLO_FLOAT_C(105937.095726),
    MLO_FLOAT_C(105961.151153),
    MLO_FLOAT_C(105985.207946),
    MLO_FLOAT_C(106009.266104),
    MLO_FLOAT_C(106033.325627),
    MLO_FLOAT_C(106057.386515),
    MLO_FLOAT_C(106081.448768),
    MLO_FLOAT_C(106105.512385),
    MLO_FLOAT_C(106129.577367),
    MLO_FLOAT_C(106153.643712),
    MLO_FLOAT_C(106177.711422),
    MLO_FLOAT_C(106201.780496),
    MLO_FLOAT_C(106225.850934),
    MLO_FLOAT_C(106249.922736),
    MLO_FLOAT_C(106273.995901),
    MLO_FLOAT_C(106298.070429),
    MLO_FLOAT_C(106322.14632),
    MLO_FLOAT_C(106346.223575),
    MLO_FLOAT_C(106370.302192),
    MLO_FLOAT_C(106394.382172),
    MLO_FLOAT_C(106418.463515),
    MLO_FLOAT_C(106442.54622),
    MLO_FLOAT_C(106466.630287),
    MLO_FLOAT_C(106490.715717),
    MLO_FLOAT_C(106514.802508),
    MLO_FLOAT_C(106538.890661),
    MLO_FLOAT_C(106562.980176),
    MLO_FLOAT_C(106587.071052),
    MLO_FLOAT_C(106611.16329),
    MLO_FLOAT_C(106635.256889),
    MLO_FLOAT_C(106659.351849),
    MLO_FLOAT_C(106683.448169),
    MLO_FLOAT_C(106707.545851),
    MLO_FLOAT_C(106731.644893),
    MLO_FLOAT_C(106755.745295),
    MLO_FLOAT_C(106779.847058),
    MLO_FLOAT_C(106803.950181),
    MLO_FLOAT_C(106828.054663),
    MLO_FLOAT_C(106852.160506),
    MLO_FLOAT_C(106876.267708),
    MLO_FLOAT_C(106900.37627),
    MLO_FLOAT_C(106924.486191),
    MLO_FLOAT_C(106948.597471),
    MLO_FLOAT_C(106972.71011),
    MLO_FLOAT_C(106996.824108),
    MLO_FLOAT_C(107020.939465),
    MLO_FLOAT_C(107045.056181),
    MLO_FLOAT_C(107069.174255),
    MLO_FLOAT_C(107093.293687),
    MLO_FLOAT_C(107117.414477),
    MLO_FLOAT_C(107141.536625),
    MLO_FLOAT_C(107165.660131),
    MLO_FLOAT_C(107189.784995),
    MLO_FLOAT_C(107213.911216),
    MLO_FLOAT_C(107238.038794),
    MLO_FLOAT_C(107262.16773),
    MLO_FLOAT_C(107286.298023),
    MLO_FLOAT_C(107310.429672),
    MLO_FLOAT_C(107334.562679),
    MLO_FLOAT_C(107358.697042),
    MLO_FLOAT_C(107382.832761),
    MLO_FLOAT_C(107406.969837),
    MLO_FLOAT_C(107431.108269),
    MLO_FLOAT_C(107455.248056),
    MLO_FLOAT_C(107479.3892),
    MLO_FLOAT_C(107503.531699),
    MLO_FLOAT_C(107527.675554),
    MLO_FLOAT_C(107551.820764),
    MLO_FLOAT_C(107575.96733),
    MLO_FLOAT_C(107600.11525),
    MLO_FLOAT_C(107624.264526),
    MLO_FLOAT_C(107648.415156),
    MLO_FLOAT_C(107672.56714),
    MLO_FLOAT_C(107696.72048),
    MLO_FLOAT_C(107720.875173),
    MLO_FLOAT_C(107745.031221),
    MLO_FLOAT_C(107769.188622),
    MLO_FLOAT_C(107793.347378),
    MLO_FLOAT_C(107817.507487),
    MLO_FLOAT_C(107841.66895),
    MLO_FLOAT_C(107865.831766),
    MLO_FLOAT_C(107889.995935),
    MLO_FLOAT_C(107914.161458),
    MLO_FLOAT_C(107938.328333),
    MLO_FLOAT_C(107962.496561),
    MLO_FLOAT_C(107986.666142),
    MLO_FLOAT_C(108010.837076),
    MLO_FLOAT_C(108035.009361),
    MLO_FLOAT_C(108059.182999),
    MLO_FLOAT_C(108083.357989),
    MLO_FLOAT_C(108107.534331),
    MLO_FLOAT_C(108131.712024),
    MLO_FLOAT_C(108155.891069),
    MLO_FLOAT_C(108180.071466),
    MLO_FLOAT_C(108204.253213),
    MLO_FLOAT_C(108228.436312),
    MLO_FLOAT_C(108252.620762),
    MLO_FLOAT_C(108276.806563),
    MLO_FLOAT_C(108300.993714),
    MLO_FLOAT_C(108325.182216),
    MLO_FLOAT_C(108349.372068),
    MLO_FLOAT_C(108373.563271),
    MLO_FLOAT_C(108397.755823),
    MLO_FLOAT_C(108421.949726),
    MLO_FLOAT_C(108446.144978),
    MLO_FLOAT_C(108470.34158),
    MLO_FLOAT_C(108494.539531),
    MLO_FLOAT_C(108518.738831),
    MLO_FLOAT_C(108542.939481),
    MLO_FLOAT_C(108567.14148),
    MLO_FLOAT_C(108591.344828),
    MLO_FLOAT_C(108615.549524),
    MLO_FLOAT_C(108639.755569),
    MLO_FLOAT_C(108663.962962),
    MLO_FLOAT_C(108688.171704),
    MLO_FLOAT_C(108712.381794),
    MLO_FLOAT_C(108736.593231),
    MLO_FLOAT_C(108760.806017),
    MLO_FLOAT_C(108785.02015),
    MLO_FLOAT_C(108809.235631),
    MLO_FLOAT_C(108833.452459),
    MLO_FLOAT_C(108857.670634),
    MLO_FLOAT_C(108881.890156),
    MLO_FLOAT_C(108906.111025),
    MLO_FLOAT_C(108930.333241),
    MLO_FLOAT_C(108954.556804),
    MLO_FLOAT_C(108978.781713),
    MLO_FLOAT_C(109003.007968),
    MLO_FLOAT_C(109027.23557),
    MLO_FLOAT_C(109051.464517),
    MLO_FLOAT_C(109075.694811),
    MLO_FLOAT_C(109099.92645),
    MLO_FLOAT_C(109124.159435),
    MLO_FLOAT_C(109148.393765),
    MLO_FLOAT_C(109172.62944),
    MLO_FLOAT_C(109196.866461),
    MLO_FLOAT_C(109221.104826),
    MLO_FLOAT_C(109245.344537),
    MLO_FLOAT_C(109269.585591),
    MLO_FLOAT_C(109293.827991),
    MLO_FLOAT_C(109318.071735),
    MLO_FLOAT_C(109342.316823),
    MLO_FLOAT_C(109366.563255),
    MLO_FLOAT_C(109390.811031),
    MLO_FLOAT_C(109415.060151),
    MLO_FLOAT_C(109439.310615),
    MLO_FLOAT_C(109463.562421),
    MLO_FLOAT_C(109487.815572),
    MLO_FLOAT_C(109512.070065),
    MLO_FLOAT_C(109536.325902),
    MLO_FLOAT_C(109560.583081),
    MLO_FLOAT_C(109584.841603),
    MLO_FLOAT_C(109609.101468),
    MLO_FLOAT_C(109633.362675),
    MLO_FLOAT_C(109657.625225),
    MLO_FLOAT_C(109681.889116),
    MLO_FLOAT_C(109706.15435),
    MLO_FLOAT_C(109730.420925),
    MLO_FLOAT_C(109754.688842),
    MLO_FLOAT_C(109778.958101),
    MLO_FLOAT_C(109803.228701),
    MLO_FLOAT_C(109827.500642),
    MLO_FLOAT_C(109851.773925),
    MLO_FLOAT_C(109876.048548),
    MLO_FLOAT_C(109900.324512),
    MLO_FLOAT_C(109924.601817),
    MLO_FLOAT_C(109948.880462),
    MLO_FLOAT_C(109973.160448),
    MLO_FLOAT_C(109997.441774),
    MLO_FLOAT_C(110021.72444),
    MLO_FLOAT_C(110046.008446),
    MLO_FLOAT_C(110070.293792),
    MLO_FLOAT_C(110094.580477),
    MLO_FLOAT_C(110118.868502),
    MLO_FLOAT_C(110143.157866),
    MLO_FLOAT_C(110167.448569),
    MLO_FLOAT_C(110191.740611),
    MLO_FLOAT_C(110216.033993),
    MLO_FLOAT_C(110240.328713),
    MLO_FLOAT_C(110264.624771),
    MLO_FLOAT_C(110288.922168),
    MLO_FLOAT_C(110313.220903),
    MLO_FLOAT_C(110337.520977),
    MLO_FLOAT_C(110361.822388),
    MLO_FLOAT_C(110386.125137),
    MLO_FLOAT_C(110410.429224),
    MLO_FLOAT_C(110434.734649),
    MLO_FLOAT_C(110459.041411),
    MLO_FLOAT_C(110483.34951),
    MLO_FLOAT_C(110507.658946),
    MLO_FLOAT_C(110531.969719),
    MLO_FLOAT_C(110556.28183),
    MLO_FLOAT_C(110580.595276),
    MLO_FLOAT_C(110604.91006),
    MLO_FLOAT_C(110629.226179),
    MLO_FLOAT_C(110653.543635),
    MLO_FLOAT_C(110677.862427),
    MLO_FLOAT_C(110702.182555),
    MLO_FLOAT_C(110726.504019),
    MLO_FLOAT_C(110750.826818),
    MLO_FLOAT_C(110775.150953),
    MLO_FLOAT_C(110799.476423),
    MLO_FLOAT_C(110823.803229),
    MLO_FLOAT_C(110848.131369),
    MLO_FLOAT_C(110872.460845),
    MLO_FLOAT_C(110896.791655),
    MLO_FLOAT_C(110921.1238),
    MLO_FLOAT_C(110945.457279),
    MLO_FLOAT_C(110969.792093),
    MLO_FLOAT_C(110994.12824),
    MLO_FLOAT_C(111018.465722),
    MLO_FLOAT_C(111042.804538),
    MLO_FLOAT_C(111067.144687),
    MLO_FLOAT_C(111091.48617),
    MLO_FLOAT_C(111115.828987),
    MLO_FLOAT_C(111140.173137),
    MLO_FLOAT_C(111164.51862),
    MLO_FLOAT_C(111188.865436),
    MLO_FLOAT_C(111213.213585),
    MLO_FLOAT_C(111237.563066),
    MLO_FLOAT_C(111261.91388),
    MLO_FLOAT_C(111286.266027),
    MLO_FLOAT_C(111310.619506),
    MLO_FLOAT_C(111334.974317),
    MLO_FLOAT_C(111359.33046),
    MLO_FLOAT_C(111383.687935),
    MLO_FLOAT_C(111408.046741),
    MLO_FLOAT_C(111432.406879),
    MLO_FLOAT_C(111456.768349),
    MLO_FLOAT_C(111481.131149),
    MLO_FLOAT_C(111505.495281),
    MLO_FLOAT_C(111529.860744),
    MLO_FLOAT_C(111554.227538),
    MLO_FLOAT_C(111578.595662),
    MLO_FLOAT_C(111602.965117),
    MLO_FLOAT_C(111627.335902),
    MLO_FLOAT_C(111651.708018),
    MLO_FLOAT_C(111676.081464),
    MLO_FLOAT_C(111700.456239),
    MLO_FLOAT_C(111724.832345),
    MLO_FLOAT_C(111749.20978),
    MLO_FLOAT_C(111773.588544),
    MLO_FLOAT_C(111797.968638),
    MLO_FLOAT_C(111822.350062),
    MLO_FLOAT_C(111846.732814),
    MLO_FLOAT_C(111871.116895),
    MLO_FLOAT_C(111895.502305),
    MLO_FLOAT_C(111919.889044),
    MLO_FLOAT_C(111944.277111),
    MLO_FLOAT_C(111968.666507),
    MLO_FLOAT_C(111993.05723),
    MLO_FLOAT_C(112017.449282),
    MLO_FLOAT_C(112041.842662),
    MLO_FLOAT_C(112066.237369),
    MLO_FLOAT_C(112090.633405),
    MLO_FLOAT_C(112115.030767),
    MLO_FLOAT_C(112139.429457),
    MLO_FLOAT_C(112163.829475),
    MLO_FLOAT_C(112188.230819),
    MLO_FLOAT_C(112212.63349),
    MLO_FLOAT_C(112237.037488),
    MLO_FLOAT_C(112261.442813),
    MLO_FLOAT_C(112285.849464),
    MLO_FLOAT_C(112310.257441),
    MLO_FLOAT_C(112334.666745),
    MLO_FLOAT_C(112359.077375),
    MLO_FLOAT_C(112383.48933),
    MLO_FLOAT_C(112407.902612),
    MLO_FLOAT_C(112432.317219),
    MLO_FLOAT_C(112456.733151),
    MLO_FLOAT_C(112481.150409),
    MLO_FLOAT_C(112505.568992),
    MLO_FLOAT_C(112529.9889),
    MLO_FLOAT_C(112554.410133),
    MLO_FLOAT_C(112578.832691),
    MLO_FLOAT_C(112603.256573),
    MLO_FLOAT_C(112627.68178),
    MLO_FLOAT_C(112652.108311),
    MLO_FLOAT_C(112676.536166),
    MLO_FLOAT_C(112700.965345),
    MLO_FLOAT_C(112725.395849),
    MLO_FLOAT_C(112749.827676),
    MLO_FLOAT_C(112774.260826),
    MLO_FLOAT_C(112798.6953),
    MLO_FLOAT_C(112823.131098),
    MLO_FLOAT_C(112847.568218),
    MLO_FLOAT_C(112872.006662),
    MLO_FLOAT_C(112896.446428),
    MLO_FLOAT_C(112920.887517),
    MLO_FLOAT_C(112945.329929),
    MLO_FLOAT_C(112969.773663),
    MLO_FLOAT_C(112994.21872),
    MLO_FLOAT_C(113018.665099),
    MLO_FLOAT_C(113043.1128),
    MLO_FLOAT_C(113067.561822),
    MLO_FLOAT_C(113092.012167),
    MLO_FLOAT_C(113116.463833),
    MLO_FLOAT_C(113140.91682),
    MLO_FLOAT_C(113165.371129),
    MLO_FLOAT_C(113189.826759),
    MLO_FLOAT_C(113214.28371),
    MLO_FLOAT_C(113238.741982),
    MLO_FLOAT_C(113263.201575),
    MLO_FLOAT_C(113287.662488),
    MLO_FLOAT_C(113312.124722),
    MLO_FLOAT_C(113336.588276),
    MLO_FLOAT_C(113361.05315),
    MLO_FLOAT_C(113385.519345),
    MLO_FLOAT_C(113409.986859),
    MLO_FLOAT_C(113434.455693),
    MLO_FLOAT_C(113458.925846),
    MLO_FLOAT_C(113483.397319),
    MLO_FLOAT_C(113507.870112),
    MLO_FLOAT_C(113532.344223),
    MLO_FLOAT_C(113556.819654),
    MLO_FLOAT_C(113581.296403),
    MLO_FLOAT_C(113605.774471),
    MLO_FLOAT_C(113630.253858),
    MLO_FLOAT_C(113654.734563),
    MLO_FLOAT_C(113679.216587),
    MLO_FLOAT_C(113703.699929),
    MLO_FLOAT_C(113728.184589),
    MLO_FLOAT_C(113752.670566),
    MLO_FLOAT_C(113777.157862),
    MLO_FLOAT_C(113801.646475),
    MLO_FLOAT_C(113826.136406),
    MLO_FLOAT_C(113850.627654),
    MLO_FLOAT_C(113875.120219),
    MLO_FLOAT_C(113899.614101),
    MLO_FLOAT_C(113924.1093),
    MLO_FLOAT_C(113948.605816),
    MLO_FLOAT_C(113973.103648),
    MLO_FLOAT_C(113997.602797),
    MLO_FLOAT_C(114022.103263),
    MLO_FLOAT_C(114046.605044),
    MLO_FLOAT_C(114071.108142),
    MLO_FLOAT_C(114095.612555),
    MLO_FLOAT_C(114120.118285),
    MLO_FLOAT_C(114144.62533),
    MLO_FLOAT_C(114169.13369),
    MLO_FLOAT_C(114193.643366),
    MLO_FLOAT_C(114218.154357),
    MLO_FLOAT_C(114242.666663),
    MLO_FLOAT_C(114267.180284),
    MLO_FLOAT_C(114291.69522),
    MLO_FLOAT_C(114316.21147),
    MLO_FLOAT_C(114340.729035),
    MLO_FLOAT_C(114365.247914),
    MLO_FLOAT_C(114389.768108),
    MLO_FLOAT_C(114414.289615),
    MLO_FLOAT_C(114438.812437),
    MLO_FLOAT_C(114463.336572),
    MLO_FLOAT_C(114487.862021),
    MLO_FLOAT_C(114512.388784),
    MLO_FLOAT_C(114536.91686),
    MLO_FLOAT_C(114561.446249),
    MLO_FLOAT_C(114585.976951),
    MLO_FLOAT_C(114610.508967),
    MLO_FLOAT_C(114635.042295),
    MLO_FLOAT_C(114659.576936),
    MLO_FLOAT_C(114684.112889),
    MLO_FLOAT_C(114708.650155),
    MLO_FLOAT_C(114733.188733),
    MLO_FLOAT_C(114757.728623),
    MLO_FLOAT_C(114782.269825),
    MLO_FLOAT_C(114806.812339),
    MLO_FLOAT_C(114831.356164),
    MLO_FLOAT_C(114855.901301),
    MLO_FLOAT_C(114880.44775),
    MLO_FLOAT_C(114904.99551),
    MLO_FLOAT_C(114929.544581),
    MLO_FLOAT_C(114954.094963),
    MLO_FLOAT_C(114978.646655),
    MLO_FLOAT_C(115003.199659),
    MLO_FLOAT_C(115027.753973),
    MLO_FLOAT_C(115052.309598),
    MLO_FLOAT_C(115076.866532),
    MLO_FLOAT_C(115101.424777),
    MLO_FLOAT_C(115125.984333),
    MLO_FLOAT_C(115150.545197),
    MLO_FLOAT_C(115175.107372),
    MLO_FLOAT_C(115199.670856),
    MLO_FLOAT_C(115224.23565),
    MLO_FLOAT_C(115248.801753),
    MLO_FLOAT_C(115273.369165),
    MLO_FLOAT_C(115297.937886),
    MLO_FLOAT_C(115322.507917),
    MLO_FLOAT_C(115347.079256),
    MLO_FLOAT_C(115371.651903),
    MLO_FLOAT_C(115396.225859),
    MLO_FLOAT_C(115420.801123),
    MLO_FLOAT_C(115445.377696),
    MLO_FLOAT_C(115469.955577),
    MLO_FLOAT_C(115494.534765),
    MLO_FLOAT_C(115519.115261),
    MLO_FLOAT_C(115543.697065),
    MLO_FLOAT_C(115568.280177),
    MLO_FLOAT_C(115592.864596),
    MLO_FLOAT_C(115617.450322),
    MLO_FLOAT_C(115642.037355),
    MLO_FLOAT_C(115666.625695),
    MLO_FLOAT_C(115691.215342),
    MLO_FLOAT_C(115715.806296),
    MLO_FLOAT_C(115740.398556),
    MLO_FLOAT_C(115764.992122),
    MLO_FLOAT_C(115789.586995),
    MLO_FLOAT_C(115814.183174),
    MLO_FLOAT_C(115838.780659),
    MLO_FLOAT_C(115863.37945),
    MLO_FLOAT_C(115887.979546),
    MLO_FLOAT_C(115912.580948),
    MLO_FLOAT_C(115937.183656),
    MLO_FLOAT_C(115961.787668),
    MLO_FLOAT_C(115986.392986),
    MLO_FLOAT_C(116010.999609),
    MLO_FLOAT_C(116035.607537),
    MLO_FLOAT_C(116060.216769),
    MLO_FLOAT_C(116084.827307),
    MLO_FLOAT_C(116109.439148),
    MLO_FLOAT_C(116134.052294),
    MLO_FLOAT_C(116158.666744),
    MLO_FLOAT_C(116183.282498),
    MLO_FLOAT_C(116207.899556),
    MLO_FLOAT_C(116232.517918),
    MLO_FLOAT_C(116257.137583),
    MLO_FLOAT_C(116281.758552),
    MLO_FLOAT_C(116306.380824),
    MLO_FLOAT_C(116331.0044),
    MLO_FLOAT_C(116355.629278),
    MLO_FLOAT_C(116380.25546),
    MLO_FLOAT_C(116404.882944),
    MLO_FLOAT_C(116429.511731),
    MLO_FLOAT_C(116454.14182),
    MLO_FLOAT_C(116478.773212),
    MLO_FLOAT_C(116503.405906),
    MLO_FLOAT_C(116528.039902),
    MLO_FLOAT_C(116552.675201),
    MLO_FLOAT_C(116577.311801),
    MLO_FLOAT_C(116601.949702),
    MLO_FLOAT_C(116626.588905),
    MLO_FLOAT_C(116651.22941),
    MLO_FLOAT_C(116675.871216),
    MLO_FLOAT_C(116700.514323),
    MLO_FLOAT_C(116725.158731),
    MLO_FLOAT_C(116749.80444),
    MLO_FLOAT_C(116774.45145),
    MLO_FLOAT_C(116799.09976),
    MLO_FLOAT_C(116823.749371),
    MLO_FLOAT_C(116848.400282),
    MLO_FLOAT_C(116873.052494),
    MLO_FLOAT_C(116897.706005),
    MLO_FLOAT_C(116922.360816),
    MLO_FLOAT_C(116947.016927),
    MLO_FLOAT_C(116971.674338),
    MLO_FLOAT_C(116996.333048),
    MLO_FLOAT_C(117020.993058),
    MLO_FLOAT_C(117045.654367),
    MLO_FLOAT_C(117070.316974),
    MLO_FLOAT_C(117094.980881),
    MLO_FLOAT_C(117119.646087),
    MLO_FLOAT_C(117144.312591),
    MLO_FLOAT_C(117168.980394),
    MLO_FLOAT_C(117193.649495),
    MLO_FLOAT_C(117218.319895),
    MLO_FLOAT_C(117242.991593),
    MLO_FLOAT_C(117267.664588),
    MLO_FLOAT_C(117292.338882),
    MLO_FLOAT_C(117317.014473),
    MLO_FLOAT_C(117341.691362),
    MLO_FLOAT_C(117366.369548),
    MLO_FLOAT_C(117391.049032),
    MLO_FLOAT_C(117415.729813),
    MLO_FLOAT_C(117440.411891),
    MLO_FLOAT_C(117465.095266),
    MLO_FLOAT_C(117489.779937),
    MLO_FLOAT_C(117514.465905),
    MLO_FLOAT_C(117539.15317),
    MLO_FLOAT_C(117563.841731),
    MLO_FLOAT_C(117588.531588),
    MLO_FLOAT_C(117613.222741),
    MLO_FLOAT_C(117637.915191),
    MLO_FLOAT_C(117662.608936),
    MLO_FLOAT_C(117687.303977),
    MLO_FLOAT_C(117712.000313),
    MLO_FLOAT_C(117736.697945),
    MLO_FLOAT_C(117761.396872),
    MLO_FLOAT_C(117786.097094),
    MLO_FLOAT_C(117810.798611),
    MLO_FLOAT_C(117835.501423),
    MLO_FLOAT_C(117860.20553),
    MLO_FLOAT_C(117884.910931),
    MLO_FLOAT_C(117909.617627),
    MLO_FLOAT_C(117934.325617),
    MLO_FLOAT_C(117959.034902),
    MLO_FLOAT_C(117983.74548),
    MLO_FLOAT_C(118008.457352),
    MLO_FLOAT_C(118033.170518),
    MLO_FLOAT_C(118057.884978),
    MLO_FLOAT_C(118082.600731),
    MLO_FLOAT_C(118107.317778),
    MLO_FLOAT_C(118132.036118),
    MLO_FLOAT_C(118156.755751),
    MLO_FLOAT_C(118181.476677),
    MLO_FLOAT_C(118206.198895),
    MLO_FLOAT_C(118230.922407),
    MLO_FLOAT_C(118255.647211),
    MLO_FLOAT_C(118280.373307),
    MLO_FLOAT_C(118305.100696),
    MLO_FLOAT_C(118329.829377),
    MLO_FLOAT_C(118354.55935),
    MLO_FLOAT_C(118379.290615),
    MLO_FLOAT_C(118404.023171),
    MLO_FLOAT_C(118428.757019),
    MLO_FLOAT_C(118453.492159),
    MLO_FLOAT_C(118478.22859),
    MLO_FLOAT_C(118502.966312),
    MLO_FLOAT_C(118527.705326),
    MLO_FLOAT_C(118552.44563),
    MLO_FLOAT_C(118577.187225),
    MLO_FLOAT_C(118601.930111),
    MLO_FLOAT_C(118626.674287),
    MLO_FLOAT_C(118651.419754),
    MLO_FLOAT_C(118676.166511),
    MLO_FLOAT_C(118700.914558),
    MLO_FLOAT_C(118725.663895),
    MLO_FLOAT_C(118750.414522),
    MLO_FLOAT_C(118775.166438),
    MLO_FLOAT_C(118799.919645),
    MLO_FLOAT_C(118824.67414),
    MLO_FLOAT_C(118849.429926),
    MLO_FLOAT_C(118874.187),
    MLO_FLOAT_C(118898.945363),
    MLO_FLOAT_C(118923.705015),
    MLO_FLOAT_C(118948.465957),
    MLO_FLOAT_C(118973.228186),
    MLO_FLOAT_C(118997.991705),
    MLO_FLOAT_C(119022.756511),
    MLO_FLOAT_C(119047.522606),
    MLO_FLOAT_C(119072.289989),
    MLO_FLOAT_C(119097.05866),
    MLO_FLOAT_C(119121.828619),
    MLO_FLOAT_C(119146.599866),
    MLO_FLOAT_C(119171.3724),
    MLO_FLOAT_C(119196.146221),
    MLO_FLOAT_C(119220.92133),
    MLO_FLOAT_C(119245.697726),
    MLO_FLOAT_C(119270.47541),
    MLO_FLOAT_C(119295.25438),
    MLO_FLOAT_C(119320.034637),
    MLO_FLOAT_C(119344.81618),
    MLO_FLOAT_C(119369.59901),
    MLO_FLOAT_C(119394.383127),
    MLO_FLOAT_C(119419.168529),
    MLO_FLOAT_C(119443.955218),
    MLO_FLOAT_C(119468.743193),
    MLO_FLOAT_C(119493.532454),
    MLO_FLOAT_C(119518.323),
    MLO_FLOAT_C(119543.114832),
    MLO_FLOAT_C(119567.907949),
    MLO_FLOAT_C(119592.702352),
    MLO_FLOAT_C(119617.49804),
    MLO_FLOAT_C(119642.295013),
    MLO_FLOAT_C(119667.093271),
    MLO_FLOAT_C(119691.892813),
    MLO_FLOAT_C(119716.693641),
    MLO_FLOAT_C(119741.495752),
    MLO_FLOAT_C(119766.299149),
    MLO_FLOAT_C(119791.103829),
    MLO_FLOAT_C(119815.909794),
    MLO_FLOAT_C(119840.717042),
    MLO_FLOAT_C(119865.525575),
    MLO_FLOAT_C(119890.335391),
    MLO_FLOAT_C(119915.14649),
    MLO_FLOAT_C(119939.958874),
    MLO_FLOAT_C(119964.77254),
    MLO_FLOAT_C(119989.58749),
    MLO_FLOAT_C(120014.403723),
    MLO_FLOAT_C(120039.221238),
    MLO_FLOAT_C(120064.040037),
    MLO_FLOAT_C(120088.860118),
    MLO_FLOAT_C(120113.681481),
    MLO_FLOAT_C(120138.504127),
    MLO_FLOAT_C(120163.328056),
    MLO_FLOAT_C(120188.153266),
    MLO_FLOAT_C(120212.979759),
    MLO_FLOAT_C(120237.807533),
    MLO_FLOAT_C(120262.636589),
    MLO_FLOAT_C(120287.466926),
    MLO_FLOAT_C(120312.298545),
    MLO_FLOAT_C(120337.131446),
    MLO_FLOAT_C(120361.965627),
    MLO_FLOAT_C(120386.80109),
    MLO_FLOAT_C(120411.637834),
    MLO_FLOAT_C(120436.475858),
    MLO_FLOAT_C(120461.315163),
    MLO_FLOAT_C(120486.155749),
    MLO_FLOAT_C(120510.997615),
    MLO_FLOAT_C(120535.840761),
    MLO_FLOAT_C(120560.685188),
    MLO_FLOAT_C(120585.530894),
    MLO_FLOAT_C(120610.377881),
    MLO_FLOAT_C(120635.226147),
    MLO_FLOAT_C(120660.075692),
    MLO_FLOAT_C(120684.926518),
    MLO_FLOAT_C(120709.778622),
    MLO_FLOAT_C(120734.632006),
    MLO_FLOAT_C(120759.486669),
    MLO_FLOAT_C(120784.342611),
    MLO_FLOAT_C(120809.199831),
    MLO_FLOAT_C(120834.058331),
    MLO_FLOAT_C(120858.918109),
    MLO_FLOAT_C(120883.779165),
    MLO_FLOAT_C(120908.6415),
    MLO_FLOAT_C(120933.505113),
    MLO_FLOAT_C(120958.370004),
    MLO_FLOAT_C(120983.236172),
    MLO_FLOAT_C(121008.103619),
    MLO_FLOAT_C(121032.972343),
    MLO_FLOAT_C(121057.842345),
    MLO_FLOAT_C(121082.713624),
    MLO_FLOAT_C(121107.58618),
    MLO_FLOAT_C(121132.460014),
    MLO_FLOAT_C(121157.335124),
    MLO_FLOAT_C(121182.211512),
    MLO_FLOAT_C(121207.089176),
    MLO_FLOAT_C(121231.968116),
    MLO_FLOAT_C(121256.848333),
    MLO_FLOAT_C(121281.729827),
    MLO_FLOAT_C(121306.612597),
    MLO_FLOAT_C(121331.496642),
    MLO_FLOAT_C(121356.381964),
    MLO_FLOAT_C(121381.268561),
    MLO_FLOAT_C(121406.156435),
    MLO_FLOAT_C(121431.045583),
    MLO_FLOAT_C(121455.936007),
    MLO_FLOAT_C(121480.827707),
    MLO_FLOAT_C(121505.720681),
    MLO_FLOAT_C(121530.614931),
    MLO_FLOAT_C(121555.510455),
    MLO_FLOAT_C(121580.407255),
    MLO_FLOAT_C(121605.305329),
    MLO_FLOAT_C(121630.204677),
    MLO_FLOAT_C(121655.1053),
    MLO_FLOAT_C(121680.007197),
    MLO_FLOAT_C(121704.910368),
    MLO_FLOAT_C(121729.814813),
    MLO_FLOAT_C(121754.720532),
    MLO_FLOAT_C(121779.627525),
    MLO_FLOAT_C(121804.535791),
    MLO_FLOAT_C(121829.445331),
    MLO_FLOAT_C(121854.356144),
    MLO_FLOAT_C(121879.26823),
    MLO_FLOAT_C(121904.181589),
    MLO_FLOAT_C(121929.096222),
    MLO_FLOAT_C(121954.012127),
    MLO_FLOAT_C(121978.929304),
    MLO_FLOAT_C(122003.847755),
    MLO_FLOAT_C(122028.767478),
    MLO_FLOAT_C(122053.688473),
    MLO_FLOAT_C(122078.61074),
    MLO_FLOAT_C(122103.534279),
    MLO_FLOAT_C(122128.45909),
    MLO_FLOAT_C(122153.385173),
    MLO_FLOAT_C(122178.312528),
    MLO_FLOAT_C(122203.241154),
    MLO_FLOAT_C(122228.171051),
    MLO_FLOAT_C(122253.10222),
    MLO_FLOAT_C(122278.03466),
    MLO_FLOAT_C(122302.96837),
    MLO_FLOAT_C(122327.903352),
    MLO_FLOAT_C(122352.839604),
    MLO_FLOAT_C(122377.777127),
    MLO_FLOAT_C(122402.715921),
    MLO_FLOAT_C(122427.655985),
    MLO_FLOAT_C(122452.597319),
    MLO_FLOAT_C(122477.539923),
    MLO_FLOAT_C(122502.483797),
    MLO_FLOAT_C(122527.428941),
    MLO_FLOAT_C(122552.375354),
    MLO_FLOAT_C(122577.323038),
    MLO_FLOAT_C(122602.27199),
    MLO_FLOAT_C(122627.222212),
    MLO_FLOAT_C(122652.173703),
    MLO_FLOAT_C(122677.126463),
    MLO_FLOAT_C(122702.080493),
    MLO_FLOAT_C(122727.03579),
    MLO_FLOAT_C(122751.992357),
    MLO_FLOAT_C(122776.950192),
    MLO_FLOAT_C(122801.909296),
    MLO_FLOAT_C(122826.869667),
    MLO_FLOAT_C(122851.831307),
    MLO_FLOAT_C(122876.794215),
    MLO_FLOAT_C(122901.758391),
    MLO_FLOAT_C(122926.723835),
    MLO_FLOAT_C(122951.690546),
    MLO_FLOAT_C(122976.658525),
    MLO_FLOAT_C(123001.627771),
    MLO_FLOAT_C(123026.598284),
    MLO_FLOAT_C(123051.570065),
    MLO_FLOAT_C(123076.543112),
    MLO_FLOAT_C(123101.517427),
    MLO_FLOAT_C(123126.493008),
    MLO_FLOAT_C(123151.469855),
    MLO_FLOAT_C(123176.44797),
    MLO_FLOAT_C(123201.42735),
    MLO_FLOAT_C(123226.407997),
    MLO_FLOAT_C(123251.38991),
    MLO_FLOAT_C(123276.373088),
    MLO_FLOAT_C(123301.357533),
    MLO_FLOAT_C(123326.343243),
    MLO_FLOAT_C(123351.330219),
    MLO_FLOAT_C(123376.318461),
    MLO_FLOAT_C(123401.307967),
    MLO_FLOAT_C(123426.298739),
    MLO_FLOAT_C(123451.290776),
    MLO_FLOAT_C(123476.284078),
    MLO_FLOAT_C(123501.278645),
    MLO_FLOAT_C(123526.274476),
    MLO_FLOAT_C(123551.271572),
    MLO_FLOAT_C(123576.269933),
    MLO_FLOAT_C(123601.269557),
    MLO_FLOAT_C(123626.270446),
    MLO_FLOAT_C(123651.272599),
    MLO_FLOAT_C(123676.276016),
    MLO_FLOAT_C(123701.280696),
    MLO_FLOAT_C(123726.286641),
    MLO_FLOAT_C(123751.293849),
    MLO_FLOAT_C(123776.30232),
    MLO_FLOAT_C(123801.312054),
    MLO_FLOAT_C(123826.323052),
    MLO_FLOAT_C(123851.335312),
    MLO_FLOAT_C(123876.348836),
    MLO_FLOAT_C(123901.363622),
    MLO_FLOAT_C(123926.379671),
    MLO_FLOAT_C(123951.396983),
    MLO_FLOAT_C(123976.415557),
    MLO_FLOAT_C(124001.435393),
    MLO_FLOAT_C(124026.456491),
    MLO_FLOAT_C(124051.478851),
    MLO_FLOAT_C(124076.502473),
    MLO_FLOAT_C(124101.527357),
    MLO_FLOAT_C(124126.553503),
    MLO_FLOAT_C(124151.58091),
    MLO_FLOAT_C(124176.609578),
    MLO_FLOAT_C(124201.639508),
    MLO_FLOAT_C(124226.670698),
    MLO_FLOAT_C(124251.70315),
    MLO_FLOAT_C(124276.736862),
    MLO_FLOAT_C(124301.771836),
    MLO_FLOAT_C(124326.80807),
    MLO_FLOAT_C(124351.845564),
    MLO_FLOAT_C(124376.884319),
    MLO_FLOAT_C(124401.924334),
    MLO_FLOAT_C(124426.965609),
    MLO_FLOAT_C(124452.008144),
    MLO_FLOAT_C(124477.051938),
    MLO_FLOAT_C(124502.096993),
    MLO_FLOAT_C(124527.143307),
    MLO_FLOAT_C(124552.190881),
    MLO_FLOAT_C(124577.239714),
    MLO_FLOAT_C(124602.289806),
    MLO_FLOAT_C(124627.341157),
    MLO_FLOAT_C(124652.393767),
    MLO_FLOAT_C(124677.447636),
    MLO_FLOAT_C(124702.502764),
    MLO_FLOAT_C(124727.55915),
    MLO_FLOAT_C(124752.616795),
    MLO_FLOAT_C(124777.675698),
    MLO_FLOAT_C(124802.735859),
    MLO_FLOAT_C(124827.797279),
    MLO_FLOAT_C(124852.859956),
    MLO_FLOAT_C(124877.923891),
    MLO_FLOAT_C(124902.989084),
    MLO_FLOAT_C(124928.055534),
    MLO_FLOAT_C(124953.123242),
    MLO_FLOAT_C(124978.192207),
    MLO_FLOAT_C(125003.26243),
    MLO_FLOAT_C(125028.333909),
    MLO_FLOAT_C(125053.406645),
    MLO_FLOAT_C(125078.480638),
    MLO_FLOAT_C(125103.555888),
    MLO_FLOAT_C(125128.632395),
    MLO_FLOAT_C(125153.710157),
    MLO_FLOAT_C(125178.789176),
    MLO_FLOAT_C(125203.869452),
    MLO_FLOAT_C(125228.950983),
    MLO_FLOAT_C(125254.03377),
    MLO_FLOAT_C(125279.117813),
    MLO_FLOAT_C(125304.203112),
    MLO_FLOAT_C(125329.289666),
    MLO_FLOAT_C(125354.377476),
    MLO_FLOAT_C(125379.466541),
    MLO_FLOAT_C(125404.556861),
    MLO_FLOAT_C(125429.648437),
    MLO_FLOAT_C(125454.741267),
    MLO_FLOAT_C(125479.835352),
    MLO_FLOAT_C(125504.930692),
    MLO_FLOAT_C(125530.027286),
    MLO_FLOAT_C(125555.125134),
    MLO_FLOAT_C(125580.224237),
    MLO_FLOAT_C(125605.324594),
    MLO_FLOAT_C(125630.426205),
    MLO_FLOAT_C(125655.529071),
    MLO_FLOAT_C(125680.633189),
    MLO_FLOAT_C(125705.738562),
    MLO_FLOAT_C(125730.845188),
    MLO_FLOAT_C(125755.953067),
    MLO_FLOAT_C(125781.0622),
    MLO_FLOAT_C(125806.172586),
    MLO_FLOAT_C(125831.284225),
    MLO_FLOAT_C(125856.397117),
    MLO_FLOAT_C(125881.511262),
    MLO_FLOAT_C(125906.626659),
    MLO_FLOAT_C(125931.743309),
    MLO_FLOAT_C(125956.861211),
    MLO_FLOAT_C(125981.980366),
    MLO_FLOAT_C(126007.100773),
    MLO_FLOAT_C(126032.222432),
    MLO_FLOAT_C(126057.345343),
    MLO_FLOAT_C(126082.469505),
    MLO_FLOAT_C(126107.594919),
    MLO_FLOAT_C(126132.721585),
    MLO_FLOAT_C(126157.849502),
    MLO_FLOAT_C(126182.978671),
    MLO_FLOAT_C(126208.10909),
    MLO_FLOAT_C(126233.240761),
    MLO_FLOAT_C(126258.373683),
    MLO_FLOAT_C(126283.507855),
    MLO_FLOAT_C(126308.643278),
    MLO_FLOAT_C(126333.779952),
    MLO_FLOAT_C(126358.917876),
    MLO_FLOAT_C(126384.057051),
    MLO_FLOAT_C(126409.197475),
    MLO_FLOAT_C(126434.33915),
    MLO_FLOAT_C(126459.482074),
    MLO_FLOAT_C(126484.626249),
    MLO_FLOAT_C(126509.771673),
    MLO_FLOAT_C(126534.918346),
    MLO_FLOAT_C(126560.066269),
    MLO_FLOAT_C(126585.215442),
    MLO_FLOAT_C(126610.365863),
    MLO_FLOAT_C(126635.517534),
    MLO_FLOAT_C(126660.670453),
    MLO_FLOAT_C(126685.824622),
    MLO_FLOAT_C(126710.980039),
    MLO_FLOAT_C(126736.136704),
    MLO_FLOAT_C(126761.294618),
    MLO_FLOAT_C(126786.45378),
    MLO_FLOAT_C(126811.614191),
    MLO_FLOAT_C(126836.775849),
    MLO_FLOAT_C(126861.938756),
    MLO_FLOAT_C(126887.10291),
    MLO_FLOAT_C(126912.268312),
    MLO_FLOAT_C(126937.434962),
    MLO_FLOAT_C(126962.602859),
    MLO_FLOAT_C(126987.772003),
    MLO_FLOAT_C(127012.942395),
    MLO_FLOAT_C(127038.114034),
    MLO_FLOAT_C(127063.286919),
    MLO_FLOAT_C(127088.461052),
    MLO_FLOAT_C(127113.636431),
    MLO_FLOAT_C(127138.813057),
    MLO_FLOAT_C(127163.990929),
    MLO_FLOAT_C(127189.170047),
    MLO_FLOAT_C(127214.350412),
    MLO_FLOAT_C(127239.532023),
    MLO_FLOAT_C(127264.71488),
    MLO_FLOAT_C(127289.898982),
    MLO_FLOAT_C(127315.084331),
    MLO_FLOAT_C(127340.270925),
    MLO_FLOAT_C(127365.458764),
    MLO_FLOAT_C(127390.647849),
    MLO_FLOAT_C(127415.838179),
    MLO_FLOAT_C(127441.029754),
    MLO_FLOAT_C(127466.222574),
    MLO_FLOAT_C(127491.416639),
    MLO_FLOAT_C(127516.611949),
    MLO_FLOAT_C(127541.808503),
    MLO_FLOAT_C(127567.006302),
    MLO_FLOAT_C(127592.205345),
    MLO_FLOAT_C(127617.405632),
    MLO_FLOAT_C(127642.607164),
    MLO_FLOAT_C(127667.809939),
    MLO_FLOAT_C(127693.013959),
    MLO_FLOAT_C(127718.219222),
    MLO_FLOAT_C(127743.425729),
    MLO_FLOAT_C(127768.633479),
    MLO_FLOAT_C(127793.842473),
    MLO_FLOAT_C(127819.05271),
    MLO_FLOAT_C(127844.26419),
    MLO_FLOAT_C(127869.476913),
    MLO_FLOAT_C(127894.690879),
    MLO_FLOAT_C(127919.906088),
    MLO_FLOAT_C(127945.122539),
    MLO_FLOAT_C(127970.340233),
    MLO_FLOAT_C(127995.559169),
    MLO_FLOAT_C(128020.779348),
    MLO_FLOAT_C(128046.000769),
    MLO_FLOAT_C(128071.223431),
    MLO_FLOAT_C(128096.447336),
    MLO_FLOAT_C(128121.672483),
    MLO_FLOAT_C(128146.898871),
    MLO_FLOAT_C(128172.126501),
    MLO_FLOAT_C(128197.355372),
    MLO_FLOAT_C(128222.585484),
    MLO_FLOAT_C(128247.816838),
    MLO_FLOAT_C(128273.049433),
    MLO_FLOAT_C(128298.283268),
    MLO_FLOAT_C(128323.518345),
    MLO_FLOAT_C(128348.754662),
    MLO_FLOAT_C(128373.99222),
    MLO_FLOAT_C(128399.231018),
    MLO_FLOAT_C(128424.471056),
    MLO_FLOAT_C(128449.712335),
    MLO_FLOAT_C(128474.954854),
    MLO_FLOAT_C(128500.198612),
    MLO_FLOAT_C(128525.443611),
    MLO_FLOAT_C(128550.689849),
    MLO_FLOAT_C(128575.937327),
    MLO_FLOAT_C(128601.186045),
    MLO_FLOAT_C(128626.436001),
    MLO_FLOAT_C(128651.687197),
    MLO_FLOAT_C(128676.939632),
    MLO_FLOAT_C(128702.193306),
    MLO_FLOAT_C(128727.448219),
    MLO_FLOAT_C(128752.704371),
    MLO_FLOAT_C(128777.961761),
    MLO_FLOAT_C(128803.22039),
    MLO_FLOAT_C(128828.480257),
    MLO_FLOAT_C(128853.741363),
    MLO_FLOAT_C(128879.003706),
    MLO_FLOAT_C(128904.267288),
    MLO_FLOAT_C(128929.532107),
    MLO_FLOAT_C(128954.798165),
    MLO_FLOAT_C(128980.06546),
    MLO_FLOAT_C(129005.333992),
    MLO_FLOAT_C(129030.603762),
    MLO_FLOAT_C(129055.874769),
    MLO_FLOAT_C(129081.147013),
    MLO_FLOAT_C(129106.420495),
    MLO_FLOAT_C(129131.695213),
    MLO_FLOAT_C(129156.971168),
    MLO_FLOAT_C(129182.24836),
    MLO_FLOAT_C(129207.526788),
    MLO_FLOAT_C(129232.806453),
    MLO_FLOAT_C(129258.087354),
    MLO_FLOAT_C(129283.369491),
    MLO_FLOAT_C(129308.652865),
    MLO_FLOAT_C(129333.937474),
    MLO_FLOAT_C(129359.223319),
    MLO_FLOAT_C(129384.5104),
    MLO_FLOAT_C(129409.798716),
    MLO_FLOAT_C(129435.088268),
    MLO_FLOAT_C(129460.379056),
    MLO_FLOAT_C(129485.671078),
    MLO_FLOAT_C(129510.964336),
    MLO_FLOAT_C(129536.258829),
    MLO_FLOAT_C(129561.554556),
    MLO_FLOAT_C(129586.851518),
    MLO_FLOAT_C(129612.149715),
    MLO_FLOAT_C(129637.449147),
    MLO_FLOAT_C(129662.749812),
    MLO_FLOAT_C(129688.051713),
    MLO_FLOAT_C(129713.354847),
    MLO_FLOAT_C(129738.659215),
    MLO_FLOAT_C(129763.964817),
    MLO_FLOAT_C(129789.271653),
    MLO_FLOAT_C(129814.579723),
    MLO_FLOAT_C(129839.889026),
    MLO_FLOAT_C(129865.199562),
    MLO_FLOAT_C(129890.511332),
    MLO_FLOAT_C(129915.824335),
    MLO_FLOAT_C(129941.138572),
    MLO_FLOAT_C(129966.454041),
    MLO_FLOAT_C(129991.770743),
    MLO_FLOAT_C(130017.088677),
    MLO_FLOAT_C(130042.407844),
    MLO_FLOAT_C(130067.728244),
    MLO_FLOAT_C(130093.049876),
    MLO_FLOAT_C(130118.37274),
    MLO_FLOAT_C(130143.696837),
    MLO_FLOAT_C(130169.022165),
    MLO_FLOAT_C(130194.348725),
    MLO_FLOAT_C(130219.676517),
    MLO_FLOAT_C(130245.005541),
    MLO_FLOAT_C(130270.335796),
    MLO_FLOAT_C(130295.667282),
    MLO_FLOAT_C(130321.0),
    MLO_FLOAT_C(130346.333949),
    MLO_FLOAT_C(130371.669129),
    MLO_FLOAT_C(130397.00554),
    MLO_FLOAT_C(130422.343181),
    MLO_FLOAT_C(130447.682054),
    MLO_FLOAT_C(130473.022156),
    MLO_FLOAT_C(130498.36349),
    MLO_FLOAT_C(130523.706053),
    MLO_FLOAT_C(130549.049847),
    MLO_FLOAT_C(130574.394871),
    MLO_FLOAT_C(130599.741125),
    MLO_FLOAT_C(130625.088608),
    MLO_FLOAT_C(130650.437322),
    MLO_FLOAT_C(130675.787264),
    MLO_FLOAT_C(130701.138437),
    MLO_FLOAT_C(130726.490839),
    MLO_FLOAT_C(130751.84447),
    MLO_FLOAT_C(130777.19933),
    MLO_FLOAT_C(130802.555419),
    MLO_FLOAT_C(130827.912737),
    MLO_FLOAT_C(130853.271284),
    MLO_FLOAT_C(130878.631059),
    MLO_FLOAT_C(130903.992063),
    MLO_FLOAT_C(130929.354295),
    MLO_FLOAT_C(130954.717756),
    MLO_FLOAT_C(130980.082445),
    MLO_FLOAT_C(131005.448362),
    MLO_FLOAT_C(131030.815506),
    MLO_FLOAT_C(131056.183879),
    MLO_FLOAT_C(131081.553479),
    MLO_FLOAT_C(131106.924307),
    MLO_FLOAT_C(131132.296362),
    MLO_FLOAT_C(131157.669645),
    MLO_FLOAT_C(131183.044155),
    MLO_FLOAT_C(131208.419892),
    MLO_FLOAT_C(131233.796855),
    MLO_FLOAT_C(131259.175046),
    MLO_FLOAT_C(131284.554464),
    MLO_FLOAT_C(131309.935108),
    MLO_FLOAT_C(131335.316978),
    MLO_FLOAT_C(131360.700075),
    MLO_FLOAT_C(131386.084399),
    MLO_FLOAT_C(131411.469948),
    MLO_FLOAT_C(131436.856724),
    MLO_FLOAT_C(131462.244725),
    MLO_FLOAT_C(131487.633952),
    MLO_FLOAT_C(131513.024405),
    MLO_FLOAT_C(131538.416083),
    MLO_FLOAT_C(131563.808987),
    MLO_FLOAT_C(131589.203116),
    MLO_FLOAT_C(131614.598471),
    MLO_FLOAT_C(131639.99505),
    MLO_FLOAT_C(131665.392854),
    MLO_FLOAT_C(131690.791884),
    MLO_FLOAT_C(131716.192138),
    MLO_FLOAT_C(131741.593616),
    MLO_FLOAT_C(131766.996319),
    MLO_FLOAT_C(131792.400247),
    MLO_FLOAT_C(131817.805398),
    MLO_FLOAT_C(131843.211774),
    MLO_FLOAT_C(131868.619374),
    MLO_FLOAT_C(131894.028198),
    MLO_FLOAT_C(131919.438245),
    MLO_FLOAT_C(131944.849517),
    MLO_FLOAT_C(131970.262011),
    MLO_FLOAT_C(131995.67573),
    MLO_FLOAT_C(132021.090671),
    MLO_FLOAT_C(132046.506836),
    MLO_FLOAT_C(132071.924224),
    MLO_FLOAT_C(132097.342834),
    MLO_FLOAT_C(132122.762668),
    MLO_FLOAT_C(132148.183724),
    MLO_FLOAT_C(132173.606003),
    MLO_FLOAT_C(132199.029504),
    MLO_FLOAT_C(132224.454228),
    MLO_FLOAT_C(132249.880174),
    MLO_FLOAT_C(132275.307342),
    MLO_FLOAT_C(132300.735733),
    MLO_FLOAT_C(132326.165345),
    MLO_FLOAT_C(132351.596179),
    MLO_FLOAT_C(132377.028234),
    MLO_FLOAT_C(132402.461511),
    MLO_FLOAT_C(132427.89601),
    MLO_FLOAT_C(132453.331729),
    MLO_FLOAT_C(132478.768671),
    MLO_FLOAT_C(132504.206833),
    MLO_FLOAT_C(132529.646216),
    MLO_FLOAT_C(132555.08682),
    MLO_FLOAT_C(132580.528644),
    MLO_FLOAT_C(132605.97169),
    MLO_FLOAT_C(132631.415955),
    MLO_FLOAT_C(132656.861441),
    MLO_FLOAT_C(132682.308148),
    MLO_FLOAT_C(132707.756074),
    MLO_FLOAT_C(132733.205221),
    MLO_FLOAT_C(132758.655587),
    MLO_FLOAT_C(132784.107174),
    MLO_FLOAT_C(132809.55998),
    MLO_FLOAT_C(132835.014005),
    MLO_FLOAT_C(132860.46925),
    MLO_FLOAT_C(132885.925714),
    MLO_FLOAT_C(132911.383398),
    MLO_FLOAT_C(132936.8423),
    MLO_FLOAT_C(132962.302422),
    MLO_FLOAT_C(132987.763762),
    MLO_FLOAT_C(133013.226321),
    MLO_FLOAT_C(133038.690099),
    MLO_FLOAT_C(133064.155095),
    MLO_FLOAT_C(133089.62131),
    MLO_FLOAT_C(133115.088743),
    MLO_FLOAT_C(133140.557394),
    MLO_FLOAT_C(133166.027263),
    MLO_FLOAT_C(133191.49835),
    MLO_FLOAT_C(133216.970655),
    MLO_FLOAT_C(133242.444178),
    MLO_FLOAT_C(133267.918918),
    MLO_FLOAT_C(133293.394876),
    MLO_FLOAT_C(133318.872051),
    MLO_FLOAT_C(133344.350443),
    MLO_FLOAT_C(133369.830052),
    MLO_FLOAT_C(133395.310878),
    MLO_FLOAT_C(133420.792921),
    MLO_FLOAT_C(133446.276181),
    MLO_FLOAT_C(133471.760658),
    MLO_FLOAT_C(133497.246351),
    MLO_FLOAT_C(133522.733261),
    MLO_FLOAT_C(133548.221386),
    MLO_FLOAT_C(133573.710728),
    MLO_FLOAT_C(133599.201286),
    MLO_FLOAT_C(133624.69306),
    MLO_FLOAT_C(133650.18605),
    MLO_FLOAT_C(133675.680256),
    MLO_FLOAT_C(133701.175677),
    MLO_FLOAT_C(133726.672314),
    MLO_FLOAT_C(133752.170166),
    MLO_FLOAT_C(133777.669233),
    MLO_FLOAT_C(133803.169515),
    MLO_FLOAT_C(133828.671013),
    MLO_FLOAT_C(133854.173725),
    MLO_FLOAT_C(133879.677652),
    MLO_FLOAT_C(133905.182794),
    MLO_FLOAT_C(133930.68915),
    MLO_FLOAT_C(133956.196721),
    MLO_FLOAT_C(133981.705506),
    MLO_FLOAT_C(134007.215506),
    MLO_FLOAT_C(134032.726719),
    MLO_FLOAT_C(134058.239147),
    MLO_FLOAT_C(134083.752788),
    MLO_FLOAT_C(134109.267643),
    MLO_FLOAT_C(134134.783712),
    MLO_FLOAT_C(134160.300994),
    MLO_FLOAT_C(134185.819489),
    MLO_FLOAT_C(134211.339198),
    MLO_FLOAT_C(134236.86012),
    MLO_FLOAT_C(134262.382255),
    MLO_FLOAT_C(134287.905604),
    MLO_FLOAT_C(134313.430164),
    MLO_FLOAT_C(134338.955938),
    MLO_FLOAT_C(134364.482924),
    MLO_FLOAT_C(134390.011123),
    MLO_FLOAT_C(134415.540534),
    MLO_FLOAT_C(134441.071157),
    MLO_FLOAT_C(134466.602993),
    MLO_FLOAT_C(134492.13604),
    MLO_FLOAT_C(134517.6703),
    MLO_FLOAT_C(134543.205771),
    MLO_FLOAT_C(134568.742454),
    MLO_FLOAT_C(134594.280348),
    MLO_FLOAT_C(134619.819454),
    MLO_FLOAT_C(134645.359771),
    MLO_FLOAT_C(134670.901299),
    MLO_FLOAT_C(134696.444039),
    MLO_FLOAT_C(134721.987989),
    MLO_FLOAT_C(134747.533151),
    MLO_FLOAT_C(134773.079523),
    MLO_FLOAT_C(134798.627106),
    MLO_FLOAT_C(134824.175899),
    MLO_FLOAT_C(134849.725902),
    MLO_FLOAT_C(134875.277116),
    MLO_FLOAT_C(134900.829541),
    MLO_FLOAT_C(134926.383175),
    MLO_FLOAT_C(134951.938019),
    MLO_FLOAT_C(134977.494073),
    MLO_FLOAT_C(135003.051337),
    MLO_FLOAT_C(135028.60981),
    MLO_FLOAT_C(135054.169493),
    MLO_FLOAT_C(135079.730385),
    MLO_FLOAT_C(135105.292487),
    MLO_FLOAT_C(135130.855798),
    MLO_FLOAT_C(135156.420317),
    MLO_FLOAT_C(135181.986046),
    MLO_FLOAT_C(135207.552983),
    MLO_FLOAT_C(135233.121129),
    MLO_FLOAT_C(135258.690484),
    MLO_FLOAT_C(135284.261047),
    MLO_FLOAT_C(135309.832819),
    MLO_FLOAT_C(135335.405799),
    MLO_FLOAT_C(135360.979987),
    MLO_FLOAT_C(135386.555383),
    MLO_FLOAT_C(135412.131986),
    MLO_FLOAT_C(135437.709798),
    MLO_FLOAT_C(135463.288817),
    MLO_FLOAT_C(135488.869044),
    MLO_FLOAT_C(135514.450478),
    MLO_FLOAT_C(135540.03312),
    MLO_FLOAT_C(135565.616969),
    MLO_FLOAT_C(135591.202025),
    MLO_FLOAT_C(135616.788287),
    MLO_FLOAT_C(135642.375757),
    MLO_FLOAT_C(135667.964434),
    MLO_FLOAT_C(135693.554317),
    MLO_FLOAT_C(135719.145407),
    MLO_FLOAT_C(135744.737703),
    MLO_FLOAT_C(135770.331205),
    MLO_FLOAT_C(135795.925914),
    MLO_FLOAT_C(135821.521828),
    MLO_FLOAT_C(135847.118949),
    MLO_FLOAT_C(135872.717275),
    MLO_FLOAT_C(135898.316808),
    MLO_FLOAT_C(135923.917545),
    MLO_FLOAT_C(135949.519489),
    MLO_FLOAT_C(135975.122637),
    MLO_FLOAT_C(136000.726991),
    MLO_FLOAT_C(136026.332551),
    MLO_FLOAT_C(136051.939315),
    MLO_FLOAT_C(136077.547284),
    MLO_FLOAT_C(136103.156458),
    MLO_FLOAT_C(136128.766837),
    MLO_FLOAT_C(136154.37842),
    MLO_FLOAT_C(136179.991208),
    MLO_FLOAT_C(136205.6052),
    MLO_FLOAT_C(136231.220396),
    MLO_FLOAT_C(136256.836797),
    MLO_FLOAT_C(136282.454401),
    MLO_FLOAT_C(136308.07321),
    MLO_FLOAT_C(136333.693222),
    MLO_FLOAT_C(136359.314438),
    MLO_FLOAT_C(136384.936858),
    MLO_FLOAT_C(136410.560481),
    MLO_FLOAT_C(136436.185307),
    MLO_FLOAT_C(136461.811337),
    MLO_FLOAT_C(136487.43857),
    MLO_FLOAT_C(136513.067006),
    MLO_FLOAT_C(136538.696644),
    MLO_FLOAT_C(136564.327486),
    MLO_FLOAT_C(136589.95953),
    MLO_FLOAT_C(136615.592777),
    MLO_FLOAT_C(136641.227226),
    MLO_FLOAT_C(136666.862877),
    MLO_FLOAT_C(136692.499731),
    MLO_FLOAT_C(136718.137787),
    MLO_FLOAT_C(136743.777045),
    MLO_FLOAT_C(136769.417505),
    MLO_FLOAT_C(136795.059166),
    MLO_FLOAT_C(136820.702029),
    MLO_FLOAT_C(136846.346094),
    MLO_FLOAT_C(136871.99136),
    MLO_FLOAT_C(136897.637828),
    MLO_FLOAT_C(136923.285496),
    MLO_FLOAT_C(136948.934366),
    MLO_FLOAT_C(136974.584437),
    MLO_FLOAT_C(137000.235709),
    MLO_FLOAT_C(137025.888181),
    MLO_FLOAT_C(137051.541854),
    MLO_FLOAT_C(137077.196728),
    MLO_FLOAT_C(137102.852802),
    MLO_FLOAT_C(137128.510076),
    MLO_FLOAT_C(137154.168551),
    MLO_FLOAT_C(137179.828225),
    MLO_FLOAT_C(137205.4891),
    MLO_FLOAT_C(137231.151174),
    MLO_FLOAT_C(137256.814449),
    MLO_FLOAT_C(137282.478922),
    MLO_FLOAT_C(137308.144596),
    MLO_FLOAT_C(137333.811469),
    MLO_FLOAT_C(137359.479541),
    MLO_FLOAT_C(137385.148812),
    MLO_FLOAT_C(137410.819282),
    MLO_FLOAT_C(137436.490952),
    MLO_FLOAT_C(137462.16382),
    MLO_FLOAT_C(137487.837887),
    MLO_FLOAT_C(137513.513152),
    MLO_FLOAT_C(137539.189617),
    MLO_FLOAT_C(137564.867279),
    MLO_FLOAT_C(137590.54614),
    MLO_FLOAT_C(137616.226199),
    MLO_FLOAT_C(137641.907456),
    MLO_FLOAT_C(137667.589911),
    MLO_FLOAT_C(137693.273564),
    MLO_FLOAT_C(137718.958414),
    MLO_FLOAT_C(137744.644462),
    MLO_FLOAT_C(137770.331708),
    MLO_FLOAT_C(137796.020151),
    MLO_FLOAT_C(137821.709792),
    MLO_FLOAT_C(137847.400629),
    MLO_FLOAT_C(137873.092664),
    MLO_FLOAT_C(137898.785896),
    MLO_FLOAT_C(137924.480324),
    MLO_FLOAT_C(137950.175949),
    MLO_FLOAT_C(137975.872771),
    MLO_FLOAT_C(138001.570789),
    MLO_FLOAT_C(138027.270004),
    MLO_FLOAT_C(138052.970415),
    MLO_FLOAT_C(138078.672022),
    MLO_FLOAT_C(138104.374826),
    MLO_FLOAT_C(138130.078825),
    MLO_FLOAT_C(138155.78402),
    MLO_FLOAT_C(138181.49041),
    MLO_FLOAT_C(138207.197997),
    MLO_FLOAT_C(138232.906779),
    MLO_FLOAT_C(138258.616756),
    MLO_FLOAT_C(138284.327929),
    MLO_FLOAT_C(138310.040296),
    MLO_FLOAT_C(138335.753859),
    MLO_FLOAT_C(138361.468617),
    MLO_FLOAT_C(138387.184569),
    MLO_FLOAT_C(138412.901717),
    MLO_FLOAT_C(138438.620059),
    MLO_FLOAT_C(138464.339595),
    MLO_FLOAT_C(138490.060326),
    MLO_FLOAT_C(138515.782251),
    MLO_FLOAT_C(138541.50537),
    MLO_FLOAT_C(138567.229684),
    MLO_FLOAT_C(138592.955191),
    MLO_FLOAT_C(138618.681892),
    MLO_FLOAT_C(138644.409787),
    MLO_FLOAT_C(138670.138876),
    MLO_FLOAT_C(138695.869158),
    MLO_FLOAT_C(138721.600633),
    MLO_FLOAT_C(138747.333302),
    MLO_FLOAT_C(138773.067164),
    MLO_FLOAT_C(138798.802219),
    MLO_FLOAT_C(138824.538467),
    MLO_FLOAT_C(138850.275907),
    MLO_FLOAT_C(138876.014541),
    MLO_FLOAT_C(138901.754367),
    MLO_FLOAT_C(138927.495386),
    MLO_FLOAT_C(138953.237597),
    MLO_FLOAT_C(138978.981),
    MLO_FLOAT_C(139004.725596),
    MLO_FLOAT_C(139030.471383),
    MLO_FLOAT_C(139056.218363),
    MLO_FLOAT_C(139081.966534),
    MLO_FLOAT_C(139107.715897),
    MLO_FLOAT_C(139133.466452),
    MLO_FLOAT_C(139159.218198),
    MLO_FLOAT_C(139184.971136),
    MLO_FLOAT_C(139210.725265),
    MLO_FLOAT_C(139236.480585),
    MLO_FLOAT_C(139262.237097),
    MLO_FLOAT_C(139287.994799),
    MLO_FLOAT_C(139313.753692),
    MLO_FLOAT_C(139339.513776),
    MLO_FLOAT_C(139365.27505),
    MLO_FLOAT_C(139391.037515),
    MLO_FLOAT_C(139416.801171),
    MLO_FLOAT_C(139442.566017),
    MLO_FLOAT_C(139468.332052),
    MLO_FLOAT_C(139494.099279),
    MLO_FLOAT_C(139519.867695),
    MLO_FLOAT_C(139545.6373),
    MLO_FLOAT_C(139571.408096),
    MLO_FLOAT_C(139597.180081),
    MLO_FLOAT_C(139622.953256),
    MLO_FLOAT_C(139648.727621),
    MLO_FLOAT_C(139674.503174),
    MLO_FLOAT_C(139700.279917),
    MLO_FLOAT_C(139726.057849),
    MLO_FLOAT_C(139751.83697),
    MLO_FLOAT_C(139777.61728),
    MLO_FLOAT_C(139803.398778),
    MLO_FLOAT_C(139829.181465),
    MLO_FLOAT_C(139854.965341),
    MLO_FLOAT_C(139880.750405),
    MLO_FLOAT_C(139906.536658),
    MLO_FLOAT_C(139932.324099),
    MLO_FLOAT_C(139958.112728),
    MLO_FLOAT_C(139983.902544),
    MLO_FLOAT_C(140009.693549),
    MLO_FLOAT_C(140035.485742),
    MLO_FLOAT_C(140061.279122),
    MLO_FLOAT_C(140087.07369),
    MLO_FLOAT_C(140112.869445),
    MLO_FLOAT_C(140138.666388),
    MLO_FLOAT_C(140164.464518),
    MLO_FLOAT_C(140190.263835),
    MLO_FLOAT_C(140216.064339),
    MLO_FLOAT_C(140241.86603),
    MLO_FLOAT_C(140267.668907),
    MLO_FLOAT_C(140293.472972),
    MLO_FLOAT_C(140319.278223),
    MLO_FLOAT_C(140345.08466),
    MLO_FLOAT_C(140370.892284),
    MLO_FLOAT_C(140396.701094),
    MLO_FLOAT_C(140422.51109),
    MLO_FLOAT_C(140448.322273),
    MLO_FLOAT_C(140474.134641),
    MLO_FLOAT_C(140499.948195),
    MLO_FLOAT_C(140525.762935),
    MLO_FLOAT_C(140551.57886),
    MLO_FLOAT_C(140577.395971),
    MLO_FLOAT_C(140603.214267),
    MLO_FLOAT_C(140629.033749),
    MLO_FLOAT_C(140654.854416),
    MLO_FLOAT_C(140680.676267),
    MLO_FLOAT_C(140706.499304),
    MLO_FLOAT_C(140732.323526),
    MLO_FLOAT_C(140758.148932),
    MLO_FLOAT_C(140783.975523),
    MLO_FLOAT_C(140809.803298),
    MLO_FLOAT_C(140835.632258),
    MLO_FLOAT_C(140861.462402),
    MLO_FLOAT_C(140887.29373),
    MLO_FLOAT_C(140913.126243),
    MLO_FLOAT_C(140938.959939),
    MLO_FLOAT_C(140964.794819),
    MLO_FLOAT_C(140990.630883),
    MLO_FLOAT_C(141016.468131),
    MLO_FLOAT_C(141042.306562),
    MLO_FLOAT_C(141068.146177),
    MLO_FLOAT_C(141093.986975),
    MLO_FLOAT_C(141119.828956),
    MLO_FLOAT_C(141145.67212),
    MLO_FLOAT_C(141171.516467),
    MLO_FLOAT_C(141197.361998),
    MLO_FLOAT_C(141223.20871),
    MLO_FLOAT_C(141249.056606),
    MLO_FLOAT_C(141274.905684),
    MLO_FLOAT_C(141300.755945),
    MLO_FLOAT_C(141326.607388),
    MLO_FLOAT_C(141352.460013),
    MLO_FLOAT_C(141378.31382),
    MLO_FLOAT_C(141404.16881),
    MLO_FLOAT_C(141430.024981),
    MLO_FLOAT_C(141455.882334),
    MLO_FLOAT_C(141481.740869),
    MLO_FLOAT_C(141507.600585),
    MLO_FLOAT_C(141533.461483),
    MLO_FLOAT_C(141559.323562),
    MLO_FLOAT_C(141585.186823),
    MLO_FLOAT_C(141611.051264),
    MLO_FLOAT_C(141636.916887),
    MLO_FLOAT_C(141662.783691),
    MLO_FLOAT_C(141688.651675),
    MLO_FLOAT_C(141714.52084),
    MLO_FLOAT_C(141740.391186),
    MLO_FLOAT_C(141766.262713),
    MLO_FLOAT_C(141792.135419),
    MLO_FLOAT_C(141818.009306),
    MLO_FLOAT_C(141843.884374),
    MLO_FLOAT_C(141869.760621),
    MLO_FLOAT_C(141895.638048),
    MLO_FLOAT_C(141921.516655),
    MLO_FLOAT_C(141947.396442),
    MLO_FLOAT_C(141973.277409),
    MLO_FLOAT_C(141999.159555),
    MLO_FLOAT_C(142025.042881),
    MLO_FLOAT_C(142050.927385),
    MLO_FLOAT_C(142076.81307),
    MLO_FLOAT_C(142102.699933),
    MLO_FLOAT_C(142128.587975),
    MLO_FLOAT_C(142154.477196),
    MLO_FLOAT_C(142180.367596),
    MLO_FLOAT_C(142206.259175),
    MLO_FLOAT_C(142232.151932),
    MLO_FLOAT_C(142258.045867),
    MLO_FLOAT_C(142283.940981),
    MLO_FLOAT_C(142309.837274),
    MLO_FLOAT_C(142335.734744),
    MLO_FLOAT_C(142361.633393),
    MLO_FLOAT_C(142387.533219),
    MLO_FLOAT_C(142413.434223),
    MLO_FLOAT_C(142439.336405),
    MLO_FLOAT_C(142465.239765),
    MLO_FLOAT_C(142491.144302),
    MLO_FLOAT_C(142517.050016),
    MLO_FLOAT_C(142542.956908),
    MLO_FLOAT_C(142568.864977),
    MLO_FLOAT_C(142594.774223),
    MLO_FLOAT_C(142620.684646),
    MLO_FLOAT_C(142646.596246),
    MLO_FLOAT_C(142672.509022),
    MLO_FLOAT_C(142698.422975),
    MLO_FLOAT_C(142724.338105),
    MLO_FLOAT_C(142750.254411),
    MLO_FLOAT_C(142776.171894),
    MLO_FLOAT_C(142802.090553),
    MLO_FLOAT_C(142828.010388),
    MLO_FLOAT_C(142853.931399),
    MLO_FLOAT_C(142879.853585),
    MLO_FLOAT_C(142905.776948),
    MLO_FLOAT_C(142931.701486),
    MLO_FLOAT_C(142957.6272),
    MLO_FLOAT_C(142983.55409),
    MLO_FLOAT_C(143009.482154),
    MLO_FLOAT_C(143035.411394),
    MLO_FLOAT_C(143061.341809),
    MLO_FLOAT_C(143087.2734),
    MLO_FLOAT_C(143113.206165),
    MLO_FLOAT_C(143139.140105),
    MLO_FLOAT_C(143165.075219),
    MLO_FLOAT_C(143191.011509),
    MLO_FLOAT_C(143216.948973),
    MLO_FLOAT_C(143242.887611),
    MLO_FLOAT_C(143268.827423),
    MLO_FLOAT_C(143294.76841),
    MLO_FLOAT_C(143320.710571),
    MLO_FLOAT_C(143346.653906),
    MLO_FLOAT_C(143372.598415),
    MLO_FLOAT_C(143398.544097),
    MLO_FLOAT_C(143424.490953),
    MLO_FLOAT_C(143450.438983),
    MLO_FLOAT_C(143476.388186),
    MLO_FLOAT_C(143502.338563),
    MLO_FLOAT_C(143528.290112),
    MLO_FLOAT_C(143554.242835),
    MLO_FLOAT_C(143580.196731),
    MLO_FLOAT_C(143606.1518),
    MLO_FLOAT_C(143632.108042),
    MLO_FLOAT_C(143658.065456),
    MLO_FLOAT_C(143684.024043),
    MLO_FLOAT_C(143709.983803),
    MLO_FLOAT_C(143735.944735),
    MLO_FLOAT_C(143761.906839),
    MLO_FLOAT_C(143787.870115),
    MLO_FLOAT_C(143813.834564),
    MLO_FLOAT_C(143839.800184),
    MLO_FLOAT_C(143865.766976),
    MLO_FLOAT_C(143891.73494),
    MLO_FLOAT_C(143917.704076),
    MLO_FLOAT_C(143943.674383),
    MLO_FLOAT_C(143969.645862),
    MLO_FLOAT_C(143995.618512),
    MLO_FLOAT_C(144021.592333),
    MLO_FLOAT_C(144047.567326),
    MLO_FLOAT_C(144073.543489),
    MLO_FLOAT_C(144099.520823),
    MLO_FLOAT_C(144125.499329),
    MLO_FLOAT_C(144151.479004),
    MLO_FLOAT_C(144177.459851),
    MLO_FLOAT_C(144203.441868),
    MLO_FLOAT_C(144229.425055),
    MLO_FLOAT_C(144255.409413),
    MLO_FLOAT_C(144281.39494),
    MLO_FLOAT_C(144307.381638),
    MLO_FLOAT_C(144333.369506),
    MLO_FLOAT_C(144359.358544),
    MLO_FLOAT_C(144385.348751),
    MLO_FLOAT_C(144411.340128),
    MLO_FLOAT_C(144437.332675),
    MLO_FLOAT_C(144463.326391),
    MLO_FLOAT_C(144489.321276),
    MLO_FLOAT_C(144515.317331),
    MLO_FLOAT_C(144541.314555),
    MLO_FLOAT_C(144567.312947),
    MLO_FLOAT_C(144593.312509),
    MLO_FLOAT_C(144619.31324),
    MLO_FLOAT_C(144645.315139),
    MLO_FLOAT_C(144671.318207),
    MLO_FLOAT_C(144697.322443),
    MLO_FLOAT_C(144723.327848),
    MLO_FLOAT_C(144749.334421),
    MLO_FLOAT_C(144775.342162),
    MLO_FLOAT_C(144801.351071),
    MLO_FLOAT_C(144827.361148),
    MLO_FLOAT_C(144853.372393),
    MLO_FLOAT_C(144879.384806),
    MLO_FLOAT_C(144905.398386),
    MLO_FLOAT_C(144931.413134),
    MLO_FLOAT_C(144957.42905),
    MLO_FLOAT_C(144983.446133),
    MLO_FLOAT_C(145009.464383),
    MLO_FLOAT_C(145035.4838),
    MLO_FLOAT_C(145061.504384),
    MLO_FLOAT_C(145087.526135),
    MLO_FLOAT_C(145113.549053),
    MLO_FLOAT_C(145139.573138),
    MLO_FLOAT_C(145165.598389),
    MLO_FLOAT_C(145191.624807),
    MLO_FLOAT_C(145217.652391),
    MLO_FLOAT_C(145243.681141),
    MLO_FLOAT_C(145269.711058),
    MLO_FLOAT_C(145295.74214),
    MLO_FLOAT_C(145321.774389),
    MLO_FLOAT_C(145347.807804),
    MLO_FLOAT_C(145373.842384),
    MLO_FLOAT_C(145399.87813),
    MLO_FLOAT_C(145425.915041),
    MLO_FLOAT_C(145451.953119),
    MLO_FLOAT_C(145477.992361),
    MLO_FLOAT_C(145504.032768),
    MLO_FLOAT_C(145530.074341),
    MLO_FLOAT_C(145556.117079),
    MLO_FLOAT_C(145582.160982),
    MLO_FLOAT_C(145608.206049),
    MLO_FLOAT_C(145634.252282),
    MLO_FLOAT_C(145660.299679),
    MLO_FLOAT_C(145686.34824),
    MLO_FLOAT_C(145712.397966),
    MLO_FLOAT_C(145738.448856),
    MLO_FLOAT_C(145764.50091),
    MLO_FLOAT_C(145790.554129),
    MLO_FLOAT_C(145816.608511),
    MLO_FLOAT_C(145842.664058),
    MLO_FLOAT_C(145868.720768),
    MLO_FLOAT_C(145894.778642),
    MLO_FLOAT_C(145920.837679),
    MLO_FLOAT_C(145946.89788),
    MLO_FLOAT_C(145972.959244),
    MLO_FLOAT_C(145999.021772),
    MLO_FLOAT_C(146025.085463),
    MLO_FLOAT_C(146051.150317),
    MLO_FLOAT_C(146077.216333),
    MLO_FLOAT_C(146103.283513),
    MLO_FLOAT_C(146129.351855),
    MLO_FLOAT_C(146155.42136),
    MLO_FLOAT_C(146181.492028),
    MLO_FLOAT_C(146207.563858),
    MLO_FLOAT_C(146233.63685),
    MLO_FLOAT_C(146259.711005),
    MLO_FLOAT_C(146285.786321),
    MLO_FLOAT_C(146311.8628),
    MLO_FLOAT_C(146337.940441),
    MLO_FLOAT_C(146364.019243),
    MLO_FLOAT_C(146390.099208),
    MLO_FLOAT_C(146416.180333),
    MLO_FLOAT_C(146442.262621),
    MLO_FLOAT_C(146468.346069),
    MLO_FLOAT_C(146494.430679),
    MLO_FLOAT_C(146520.516451),
    MLO_FLOAT_C(146546.603383),
    MLO_FLOAT_C(146572.691476),
    MLO_FLOAT_C(146598.780731),
    MLO_FLOAT_C(146624.871146),
    MLO_FLOAT_C(146650.962721),
    MLO_FLOAT_C(146677.055457),
    MLO_FLOAT_C(146703.149354),
    MLO_FLOAT_C(146729.244411),
    MLO_FLOAT_C(146755.340629),
    MLO_FLOAT_C(146781.438006),
    MLO_FLOAT_C(146807.536544),
    MLO_FLOAT_C(146833.636241),
    MLO_FLOAT_C(146859.737099),
    MLO_FLOAT_C(146885.839116),
    MLO_FLOAT_C(146911.942293),
    MLO_FLOAT_C(146938.046629),
    MLO_FLOAT_C(146964.152125),
    MLO_FLOAT_C(146990.25878),
    MLO_FLOAT_C(147016.366595),
    MLO_FLOAT_C(147042.475568),
    MLO_FLOAT_C(147068.585701),
    MLO_FLOAT_C(147094.696992),
    MLO_FLOAT_C(147120.809443),
    MLO_FLOAT_C(147146.923052),
    MLO_FLOAT_C(147173.037819),
    MLO_FLOAT_C(147199.153746),
    MLO_FLOAT_C(147225.27083),
    MLO_FLOAT_C(147251.389073),
    MLO_FLOAT_C(147277.508474),
    MLO_FLOAT_C(147303.629034),
    MLO_FLOAT_C(147329.750751),
    MLO_FLOAT_C(147355.873626),
    MLO_FLOAT_C(147381.997659),
    MLO_FLOAT_C(147408.12285),
    MLO_FLOAT_C(147434.249198),
    MLO_FLOAT_C(147460.376704),
    MLO_FLOAT_C(147486.505367),
    MLO_FLOAT_C(147512.635187),
    MLO_FLOAT_C(147538.766165),
    MLO_FLOAT_C(147564.8983),
    MLO_FLOAT_C(147591.031591),
    MLO_FLOAT_C(147617.16604),
    MLO_FLOAT_C(147643.301645),
    MLO_FLOAT_C(147669.438407),
    MLO_FLOAT_C(147695.576326),
    MLO_FLOAT_C(147721.715401),
    MLO_FLOAT_C(147747.855632),
    MLO_FLOAT_C(147773.99702),
    MLO_FLOAT_C(147800.139564),
    MLO_FLOAT_C(147826.283264),
    MLO_FLOAT_C(147852.428119),
    MLO_FLOAT_C(147878.574131),
    MLO_FLOAT_C(147904.721299),
    MLO_FLOAT_C(147930.869622),
    MLO_FLOAT_C(147957.0191),
    MLO_FLOAT_C(147983.169734),
    MLO_FLOAT_C(148009.321524),
    MLO_FLOAT_C(148035.474469),
    MLO_FLOAT_C(148061.628568),
    MLO_FLOAT_C(148087.783823),
    MLO_FLOAT_C(148113.940233),
    MLO_FLOAT_C(148140.097798),
    MLO_FLOAT_C(148166.256517),
    MLO_FLOAT_C(148192.416391),
    MLO_FLOAT_C(148218.57742),
    MLO_FLOAT_C(148244.739603),
    MLO_FLOAT_C(148270.90294),
    MLO_FLOAT_C(148297.067431),
    MLO_FLOAT_C(148323.233077),
    MLO_FLOAT_C(148349.399877),
    MLO_FLOAT_C(148375.56783),
    MLO_FLOAT_C(148401.736938),
    MLO_FLOAT_C(148427.907199),
    MLO_FLOAT_C(148454.078613),
    MLO_FLOAT_C(148480.251182),
    MLO_FLOAT_C(148506.424903),
    MLO_FLOAT_C(148532.599778),
    MLO_FLOAT_C(148558.775806),
    MLO_FLOAT_C(148584.952987),
    MLO_FLOAT_C(148611.131322),
    MLO_FLOAT_C(148637.310809),
    MLO_FLOAT_C(148663.491449),
    MLO_FLOAT_C(148689.673241),
    MLO_FLOAT_C(148715.856187),
    MLO_FLOAT_C(148742.040284),
    MLO_FLOAT_C(148768.225534),
    MLO_FLOAT_C(148794.411937),
    MLO_FLOAT_C(148820.599491),
    MLO_FLOAT_C(148846.788198),
    MLO_FLOAT_C(148872.978057),
    MLO_FLOAT_C(148899.169067),
    MLO_FLOAT_C(148925.36123),
    MLO_FLOAT_C(148951.554544),
    MLO_FLOAT_C(148977.749009),
    MLO_FLOAT_C(149003.944626),
    MLO_FLOAT_C(149030.141395),
    MLO_FLOAT_C(149056.339315),
    MLO_FLOAT_C(149082.538386),
    MLO_FLOAT_C(149108.738608),
    MLO_FLOAT_C(149134.939981),
    MLO_FLOAT_C(149161.142504),
    MLO_FLOAT_C(149187.346179),
    MLO_FLOAT_C(149213.551004),
    MLO_FLOAT_C(149239.75698),
    MLO_FLOAT_C(149265.964106),
    MLO_FLOAT_C(149292.172383),
    MLO_FLOAT_C(149318.38181),
    MLO_FLOAT_C(149344.592387),
    MLO_FLOAT_C(149370.804115),
    MLO_FLOAT_C(149397.016992),
    MLO_FLOAT_C(149423.231019),
    MLO_FLOAT_C(149449.446196),
    MLO_FLOAT_C(149475.662522),
    MLO_FLOAT_C(149501.879998),
    MLO_FLOAT_C(149528.098623),
    MLO_FLOAT_C(149554.318398),
    MLO_FLOAT_C(149580.539322),
    MLO_FLOAT_C(149606.761396),
    MLO_FLOAT_C(149632.984618),
    MLO_FLOAT_C(149659.208989),
    MLO_FLOAT_C(149685.434509),
    MLO_FLOAT_C(149711.661178),
    MLO_FLOAT_C(149737.888996),
    MLO_FLOAT_C(149764.117962),
    MLO_FLOAT_C(149790.348076),
    MLO_FLOAT_C(149816.579339),
    MLO_FLOAT_C(149842.811751),
    MLO_FLOAT_C(149869.04531),
    MLO_FLOAT_C(149895.280017),
    MLO_FLOAT_C(149921.515873),
    MLO_FLOAT_C(149947.752876),
    MLO_FLOAT_C(149973.991027),
    MLO_FLOAT_C(150000.230325),
    MLO_FLOAT_C(150026.470771),
    MLO_FLOAT_C(150052.712365),
    MLO_FLOAT_C(150078.955106),
    MLO_FLOAT_C(150105.198994),
    MLO_FLOAT_C(150131.444029),
    MLO_FLOAT_C(150157.690212),
    MLO_FLOAT_C(150183.937541),
    MLO_FLOAT_C(150210.186017),
    MLO_FLOAT_C(150236.43564),
    MLO_FLOAT_C(150262.68641),
    MLO_FLOAT_C(150288.938326),
    MLO_FLOAT_C(150315.191388),
    MLO_FLOAT_C(150341.445597),
    MLO_FLOAT_C(150367.700952),
    MLO_FLOAT_C(150393.957453),
    MLO_FLOAT_C(150420.215101),
    MLO_FLOAT_C(150446.473894),
    MLO_FLOAT_C(150472.733833),
    MLO_FLOAT_C(150498.994918),
    MLO_FLOAT_C(150525.257149),
    MLO_FLOAT_C(150551.520525),
    MLO_FLOAT_C(150577.785046),
    MLO_FLOAT_C(150604.050713),
    MLO_FLOAT_C(150630.317525),
    MLO_FLOAT_C(150656.585482),
    MLO_FLOAT_C(150682.854585),
    MLO_FLOAT_C(150709.124832),
    MLO_FLOAT_C(150735.396224),
    MLO_FLOAT_C(150761.668761),
    MLO_FLOAT_C(150787.942442),
    MLO_FLOAT_C(150814.217268),
    MLO_FLOAT_C(150840.493239),
    MLO_FLOAT_C(150866.770354),
    MLO_FLOAT_C(150893.048613),
    MLO_FLOAT_C(150919.328016),
    MLO_FLOAT_C(150945.608563),
    MLO_FLOAT_C(150971.890255),
    MLO_FLOAT_C(150998.17309),
    MLO_FLOAT_C(151024.457068),
    MLO_FLOAT_C(151050.742191),
    MLO_FLOAT_C(151077.028457),
    MLO_FLOAT_C(151103.315866),
    MLO_FLOAT_C(151129.604419),
    MLO_FLOAT_C(151155.894115),
    MLO_FLOAT_C(151182.184955),
    MLO_FLOAT_C(151208.476937),
    MLO_FLOAT_C(151234.770062),
    MLO_FLOAT_C(151261.06433),
    MLO_FLOAT_C(151287.359741),
    MLO_FLOAT_C(151313.656295),
    MLO_FLOAT_C(151339.953991),
    MLO_FLOAT_C(151366.252829),
    MLO_FLOAT_C(151392.55281),
    MLO_FLOAT_C(151418.853934),
    MLO_FLOAT_C(151445.156199),
    MLO_FLOAT_C(151471.459606),
    MLO_FLOAT_C(151497.764156),
    MLO_FLOAT_C(151524.069847),
    MLO_FLOAT_C(151550.37668),
    MLO_FLOAT_C(151576.684655),
    MLO_FLOAT_C(151602.993771),
    MLO_FLOAT_C(151629.304028),
    MLO_FLOAT_C(151655.615427),
    MLO_FLOAT_C(151681.927968),
    MLO_FLOAT_C(151708.241649),
    MLO_FLOAT_C(151734.556472),
    MLO_FLOAT_C(151760.872435),
    MLO_FLOAT_C(151787.18954),
    MLO_FLOAT_C(151813.507785),
    MLO_FLOAT_C(151839.827171),
    MLO_FLOAT_C(151866.147697),
    MLO_FLOAT_C(151892.469364),
    MLO_FLOAT_C(151918.792172),
    MLO_FLOAT_C(151945.116119),
    MLO_FLOAT_C(151971.441207),
    MLO_FLOAT_C(151997.767435),
    MLO_FLOAT_C(152024.094803),
    MLO_FLOAT_C(152050.42331),
    MLO_FLOAT_C(152076.752958),
    MLO_FLOAT_C(152103.083745),
    MLO_FLOAT_C(152129.415672),
    MLO_FLOAT_C(152155.748738),
    MLO_FLOAT_C(152182.082944),
    MLO_FLOAT_C(152208.418289),
    MLO_FLOAT_C(152234.754773),
    MLO_FLOAT_C(152261.092396),
    MLO_FLOAT_C(152287.431158),
    MLO_FLOAT_C(152313.77106),
    MLO_FLOAT_C(152340.1121),
    MLO_FLOAT_C(152366.454278),
    MLO_FLOAT_C(152392.797595),
    MLO_FLOAT_C(152419.142051),
    MLO_FLOAT_C(152445.487645),
    MLO_FLOAT_C(152471.834378),
    MLO_FLOAT_C(152498.182249),
    MLO_FLOAT_C(152524.531257),
    MLO_FLOAT_C(152550.881404),
    MLO_FLOAT_C(152577.232689),
    MLO_FLOAT_C(152603.585111),
    MLO_FLOAT_C(152629.938672),
    MLO_FLOAT_C(152656.29337),
    MLO_FLOAT_C(152682.649205),
    MLO_FLOAT_C(152709.006178),
    MLO_FLOAT_C(152735.364288),
    MLO_FLOAT_C(152761.723535),
    MLO_FLOAT_C(152788.08392),
    MLO_FLOAT_C(152814.445442),
    MLO_FLOAT_C(152840.8081),
    MLO_FLOAT_C(152867.171895),
    MLO_FLOAT_C(152893.536827),
    MLO_FLOAT_C(152919.902896),
    MLO_FLOAT_C(152946.270101),
    MLO_FLOAT_C(152972.638443),
    MLO_FLOAT_C(152999.007921),
    MLO_FLOAT_C(153025.378535),
    MLO_FLOAT_C(153051.750286),
    MLO_FLOAT_C(153078.123172),
    MLO_FLOAT_C(153104.497195),
    MLO_FLOAT_C(153130.872353),
    MLO_FLOAT_C(153157.248647),
    MLO_FLOAT_C(153183.626077),
    MLO_FLOAT_C(153210.004642),
    MLO_FLOAT_C(153236.384343),
    MLO_FLOAT_C(153262.765179),
    MLO_FLOAT_C(153289.14715),
    MLO_FLOAT_C(153315.530257),
    MLO_FLOAT_C(153341.914499),
    MLO_FLOAT_C(153368.299875),
    MLO_FLOAT_C(153394.686387),
    MLO_FLOAT_C(153421.074033),
    MLO_FLOAT_C(153447.462814),
    MLO_FLOAT_C(153473.852729),
    MLO_FLOAT_C(153500.243779),
    MLO_FLOAT_C(153526.635964),
    MLO_FLOAT_C(153553.029283),
    MLO_FLOAT_C(153579.423735),
    MLO_FLOAT_C(153605.819322),
    MLO_FLOAT_C(153632.216043),
    MLO_FLOAT_C(153658.613898),
    MLO_FLOAT_C(153685.012887),
    MLO_FLOAT_C(153711.41301),
    MLO_FLOAT_C(153737.814266),
    MLO_FLOAT_C(153764.216655),
    MLO_FLOAT_C(153790.620178),
    MLO_FLOAT_C(153817.024834),
    MLO_FLOAT_C(153843.430624),
    MLO_FLOAT_C(153869.837547),
    MLO_FLOAT_C(153896.245602),
    MLO_FLOAT_C(153922.654791),
    MLO_FLOAT_C(153949.065112),
    MLO_FLOAT_C(153975.476566),
    MLO_FLOAT_C(154001.889153),
    MLO_FLOAT_C(154028.302873),
    MLO_FLOAT_C(154054.717724),
    MLO_FLOAT_C(154081.133709),
    MLO_FLOAT_C(154107.550825),
    MLO_FLOAT_C(154133.969074),
    MLO_FLOAT_C(154160.388454),
    MLO_FLOAT_C(154186.808967),
    MLO_FLOAT_C(154213.230611),
    MLO_FLOAT_C(154239.653387),
    MLO_FLOAT_C(154266.077295),
    MLO_FLOAT_C(154292.502335),
    MLO_FLOAT_C(154318.928506),
    MLO_FLOAT_C(154345.355808),
    MLO_FLOAT_C(154371.784241),
    MLO_FLOAT_C(154398.213806),
    MLO_FLOAT_C(154424.644502),
    MLO_FLOAT_C(154451.076329),
    MLO_FLOAT_C(154477.509287),
    MLO_FLOAT_C(154503.943375),
    MLO_FLOAT_C(154530.378594),
    MLO_FLOAT_C(154556.814944),
    MLO_FLOAT_C(154583.252425),
    MLO_FLOAT_C(154609.691035),
    MLO_FLOAT_C(154636.130776),
    MLO_FLOAT_C(154662.571648),
    MLO_FLOAT_C(154689.013649),
    MLO_FLOAT_C(154715.456781),
    MLO_FLOAT_C(154741.901042),
    MLO_FLOAT_C(154768.346433),
    MLO_FLOAT_C(154794.792954),
    MLO_FLOAT_C(154821.240605),
    MLO_FLOAT_C(154847.689385),
    MLO_FLOAT_C(154874.139294),
    MLO_FLOAT_C(154900.590333),
    MLO_FLOAT_C(154927.042501),
    MLO_FLOAT_C(154953.495799),
    MLO_FLOAT_C(154979.950225),
    MLO_FLOAT_C(155006.40578),
    MLO_FLOAT_C(155032.862464),
    MLO_FLOAT_C(155059.320277),
    MLO_FLOAT_C(155085.779219),
    MLO_FLOAT_C(155112.239289),
    MLO_FLOAT_C(155138.700488),
    MLO_FLOAT_C(155165.162815),
    MLO_FLOAT_C(155191.62627),
    MLO_FLOAT_C(155218.090854),
    MLO_FLOAT_C(155244.556566),
    MLO_FLOAT_C(155271.023405),
    MLO_FLOAT_C(155297.491373),
    MLO_FLOAT_C(155323.960468),
    MLO_FLOAT_C(155350.430691),
    MLO_FLOAT_C(155376.902042),
    MLO_FLOAT_C(155403.37452),
    MLO_FLOAT_C(155429.848126),
    MLO_FLOAT_C(155456.322859),
    MLO_FLOAT_C(155482.798719),
    MLO_FLOAT_C(155509.275706),
    MLO_FLOAT_C(155535.753821),
    MLO_FLOAT_C(155562.233062),
    MLO_FLOAT_C(155588.71343),
    MLO_FLOAT_C(155615.194925),
    MLO_FLOAT_C(155641.677547),
    MLO_FLOAT_C(155668.161295),
    MLO_FLOAT_C(155694.64617),
    MLO_FLOAT_C(155721.132171),
    MLO_FLOAT_C(155747.619298),
    MLO_FLOAT_C(155774.107551),
    MLO_FLOAT_C(155800.596931),
    MLO_FLOAT_C(155827.087436),
    MLO_FLOAT_C(155853.579068),
    MLO_FLOAT_C(155880.071825),
    MLO_FLOAT_C(155906.565708),
    MLO_FLOAT_C(155933.060716),
    MLO_FLOAT_C(155959.55685),
    MLO_FLOAT_C(155986.05411),
    MLO_FLOAT_C(156012.552494),
    MLO_FLOAT_C(156039.052004),
    MLO_FLOAT_C(156065.552639),
    MLO_FLOAT_C(156092.054399),
    MLO_FLOAT_C(156118.557284),
    MLO_FLOAT_C(156145.061294),
    MLO_FLOAT_C(156171.566429),
    MLO_FLOAT_C(156198.072688),
    MLO_FLOAT_C(156224.580072),
    MLO_FLOAT_C(156251.08858),
    MLO_FLOAT_C(156277.598213),
    MLO_FLOAT_C(156304.10897),
    MLO_FLOAT_C(156330.620851),
    MLO_FLOAT_C(156357.133856),
    MLO_FLOAT_C(156383.647985),
    MLO_FLOAT_C(156410.163238),
    MLO_FLOAT_C(156436.679615),
    MLO_FLOAT_C(156463.197115),
    MLO_FLOAT_C(156489.71574),
    MLO_FLOAT_C(156516.235487),
    MLO_FLOAT_C(156542.756358),
    MLO_FLOAT_C(156569.278352),
    MLO_FLOAT_C(156595.80147),
    MLO_FLOAT_C(156622.325711),
    MLO_FLOAT_C(156648.851074),
    MLO_FLOAT_C(156675.377561),
    MLO_FLOAT_C(156701.90517),
    MLO_FLOAT_C(156728.433903),
    MLO_FLOAT_C(156754.963757),
    MLO_FLOAT_C(156781.494735),
    MLO_FLOAT_C(156808.026835),
    MLO_FLOAT_C(156834.560057),
    MLO_FLOAT_C(156861.094401),
    MLO_FLOAT_C(156887.629868),
    MLO_FLOAT_C(156914.166457),
    MLO_FLOAT_C(156940.704168),
    MLO_FLOAT_C(156967.243),
    MLO_FLOAT_C(156993.782955),
    MLO_FLOAT_C(157020.324031),
    MLO_FLOAT_C(157046.866228),
    MLO_FLOAT_C(157073.409548),
    MLO_FLOAT_C(157099.953988),
    MLO_FLOAT_C(157126.49955),
    MLO_FLOAT_C(157153.046233),
    MLO_FLOAT_C(157179.594038),
    MLO_FLOAT_C(157206.142963),
    MLO_FLOAT_C(157232.693009),
    MLO_FLOAT_C(157259.244176),
    MLO_FLOAT_C(157285.796464),
    MLO_FLOAT_C(157312.349873),
    MLO_FLOAT_C(157338.904402),
    MLO_FLOAT_C(157365.460051),
    MLO_FLOAT_C(157392.016821),
    MLO_FLOAT_C(157418.574712),
    MLO_FLOAT_C(157445.133722),
    MLO_FLOAT_C(157471.693853),
    MLO_FLOAT_C(157498.255103),
    MLO_FLOAT_C(157524.817473),
    MLO_FLOAT_C(157551.380964),
    MLO_FLOAT_C(157577.945574),
    MLO_FLOAT_C(157604.511303),
    MLO_FLOAT_C(157631.078152),
    MLO_FLOAT_C(157657.646121),
    MLO_FLOAT_C(157684.215208),
    MLO_FLOAT_C(157710.785415),
    MLO_FLOAT_C(157737.356742),
    MLO_FLOAT_C(157763.929187),
    MLO_FLOAT_C(157790.502751),
    MLO_FLOAT_C(157817.077434),
    MLO_FLOAT_C(157843.653236),
    MLO_FLOAT_C(157870.230157),
    MLO_FLOAT_C(157896.808196),
    MLO_FLOAT_C(157923.387353),
    MLO_FLOAT_C(157949.967629),
    MLO_FLOAT_C(157976.549023),
    MLO_FLOAT_C(158003.131536),
    MLO_FLOAT_C(158029.715167),
    MLO_FLOAT_C(158056.299915),
    MLO_FLOAT_C(158082.885782),
    MLO_FLOAT_C(158109.472766),
    MLO_FLOAT_C(158136.060868),
    MLO_FLOAT_C(158162.650088),
    MLO_FLOAT_C(158189.240425),
    MLO_FLOAT_C(158215.83188),
    MLO_FLOAT_C(158242.424452),
    MLO_FLOAT_C(158269.018141),
    MLO_FLOAT_C(158295.612948),
    MLO_FLOAT_C(158322.208871),
    MLO_FLOAT_C(158348.805912),
    MLO_FLOAT_C(158375.40407),
    MLO_FLOAT_C(158402.003344),
    MLO_FLOAT_C(158428.603735),
    MLO_FLOAT_C(158455.205242),
    MLO_FLOAT_C(158481.807866),
    MLO_FLOAT_C(158508.411607),
    MLO_FLOAT_C(158535.016464),
    MLO_FLOAT_C(158561.622437),
    MLO_FLOAT_C(158588.229526),
    MLO_FLOAT_C(158614.837731),
    MLO_FLOAT_C(158641.447053),
    MLO_FLOAT_C(158668.05749),
    MLO_FLOAT_C(158694.669042),
    MLO_FLOAT_C(158721.281711),
    MLO_FLOAT_C(158747.895495),
    MLO_FLOAT_C(158774.510395),
    MLO_FLOAT_C(158801.12641),
    MLO_FLOAT_C(158827.74354),
    MLO_FLOAT_C(158854.361785),
    MLO_FLOAT_C(158880.981146),
    MLO_FLOAT_C(158907.601621),
    MLO_FLOAT_C(158934.223212),
    MLO_FLOAT_C(158960.845917),
    MLO_FLOAT_C(158987.469737),
    MLO_FLOAT_C(159014.094672),
    MLO_FLOAT_C(159040.720721),
    MLO_FLOAT_C(159067.347885),
    MLO_FLOAT_C(159093.976163),
    MLO_FLOAT_C(159120.605556),
    MLO_FLOAT_C(159147.236062),
    MLO_FLOAT_C(159173.867683),
    MLO_FLOAT_C(159200.500417),
    MLO_FLOAT_C(159227.134266),
    MLO_FLOAT_C(159253.769228),
    MLO_FLOAT_C(159280.405304),
    MLO_FLOAT_C(159307.042494),
    MLO_FLOAT_C(159333.680797),
    MLO_FLOAT_C(159360.320214),
    MLO_FLOAT_C(159386.960744),
    MLO_FLOAT_C(159413.602387),
    MLO_FLOAT_C(159440.245143),
    MLO_FLOAT_C(159466.889012),
    MLO_FLOAT_C(159493.533995),
    MLO_FLOAT_C(159520.18009),
    MLO_FLOAT_C(159546.827298),
    MLO_FLOAT_C(159573.475619),
    MLO_FLOAT_C(159600.125052),
    MLO_FLOAT_C(159626.775598),
    MLO_FLOAT_C(159653.427256),
    MLO_FLOAT_C(159680.080027),
    MLO_FLOAT_C(159706.733909),
    MLO_FLOAT_C(159733.388904),
    MLO_FLOAT_C(159760.045011),
    MLO_FLOAT_C(159786.70223),
    MLO_FLOAT_C(159813.360561),
    MLO_FLOAT_C(159840.020003),
    MLO_FLOAT_C(159866.680557),
    MLO_FLOAT_C(159893.342223),
    MLO_FLOAT_C(159920.005),
    MLO_FLOAT_C(159946.668889),
    MLO_FLOAT_C(159973.333889),
    MLO_FLOAT_C(160000.0),
    MLO_FLOAT_C(160026.667222),
    MLO_FLOAT_C(160053.335555),
    MLO_FLOAT_C(160080.005),
    MLO_FLOAT_C(160106.675555),
    MLO_FLOAT_C(160133.34722),
    MLO_FLOAT_C(160160.019997),
    MLO_FLOAT_C(160186.693884),
    MLO_FLOAT_C(160213.368881),
    MLO_FLOAT_C(160240.044989),
    MLO_FLOAT_C(160266.722207),
    MLO_FLOAT_C(160293.400535),
    MLO_FLOAT_C(160320.079973),
    MLO_FLOAT_C(160346.760522),
    MLO_FLOAT_C(160373.44218),
    MLO_FLOAT_C(160400.124948),
    MLO_FLOAT_C(160426.808826),
    MLO_FLOAT_C(160453.493813),
    MLO_FLOAT_C(160480.17991),
    MLO_FLOAT_C(160506.867116),
    MLO_FLOAT_C(160533.555432),
    MLO_FLOAT_C(160560.244857),
    MLO_FLOAT_C(160586.935391),
    MLO_FLOAT_C(160613.627035),
    MLO_FLOAT_C(160640.319787),
    MLO_FLOAT_C(160667.013648),
    MLO_FLOAT_C(160693.708618),
    MLO_FLOAT_C(160720.404697),
    MLO_FLOAT_C(160747.101884),
    MLO_FLOAT_C(160773.80018),
    MLO_FLOAT_C(160800.499584),
    MLO_FLOAT_C(160827.200097),
    MLO_FLOAT_C(160853.901717),
    MLO_FLOAT_C(160880.604446),
    MLO_FLOAT_C(160907.308283),
    MLO_FLOAT_C(160934.013228),
    MLO_FLOAT_C(160960.719281),
    MLO_FLOAT_C(160987.426442),
    MLO_FLOAT_C(161014.13471),
    MLO_FLOAT_C(161040.844086),
    MLO_FLOAT_C(161067.55457),
    MLO_FLOAT_C(161094.266161),
    MLO_FLOAT_C(161120.978859),
    MLO_FLOAT_C(161147.692665),
    MLO_FLOAT_C(161174.407577),
    MLO_FLOAT_C(161201.123597),
    MLO_FLOAT_C(161227.840724),
    MLO_FLOAT_C(161254.558957),
    MLO_FLOAT_C(161281.278298),
    MLO_FLOAT_C(161307.998745),
    MLO_FLOAT_C(161334.720298),
    MLO_FLOAT_C(161361.442958),
    MLO_FLOAT_C(161388.166725),
    MLO_FLOAT_C(161414.891598),
    MLO_FLOAT_C(161441.617577),
    MLO_FLOAT_C(161468.344662),
    MLO_FLOAT_C(161495.072853),
    MLO_FLOAT_C(161521.802151),
    MLO_FLOAT_C(161548.532554),
    MLO_FLOAT_C(161575.264062),
    MLO_FLOAT_C(161601.996677),
    MLO_FLOAT_C(161628.730397),
    MLO_FLOAT_C(161655.465223),
    MLO_FLOAT_C(161682.201154),
    MLO_FLOAT_C(161708.93819),
    MLO_FLOAT_C(161735.676332),
    MLO_FLOAT_C(161762.415579),
    MLO_FLOAT_C(161789.15593),
    MLO_FLOAT_C(161815.897387),
    MLO_FLOAT_C(161842.639949),
    MLO_FLOAT_C(161869.383615),
    MLO_FLOAT_C(161896.128386),
    MLO_FLOAT_C(161922.874261),
    MLO_FLOAT_C(161949.621242),
    MLO_FLOAT_C(161976.369326),
    MLO_FLOAT_C(162003.118515),
    MLO_FLOAT_C(162029.868808),
    MLO_FLOAT_C(162056.620205),
    MLO_FLOAT_C(162083.372706),
    MLO_FLOAT_C(162110.126311),
    MLO_FLOAT_C(162136.88102),
    MLO_FLOAT_C(162163.636833),
    MLO_FLOAT_C(162190.39375),
    MLO_FLOAT_C(162217.15177),
    MLO_FLOAT_C(162243.910893),
    MLO_FLOAT_C(162270.67112),
    MLO_FLOAT_C(162297.43245),
    MLO_FLOAT_C(162324.194884),
    MLO_FLOAT_C(162350.95842),
    MLO_FLOAT_C(162377.72306),
    MLO_FLOAT_C(162404.488802),
    MLO_FLOAT_C(162431.255648),
    MLO_FLOAT_C(162458.023596),
    MLO_FLOAT_C(162484.792647),
    MLO_FLOAT_C(162511.5628),
    MLO_FLOAT_C(162538.334056),
    MLO_FLOAT_C(162565.106414),
    MLO_FLOAT_C(162591.879875),
    MLO_FLOAT_C(162618.654438),
    MLO_FLOAT_C(162645.430103),
    MLO_FLOAT_C(162672.20687),
    MLO_FLOAT_C(162698.984739),
    MLO_FLOAT_C(162725.76371),
    MLO_FLOAT_C(162752.543782),
    MLO_FLOAT_C(162779.324957),
    MLO_FLOAT_C(162806.107232),
    MLO_FLOAT_C(162832.89061),
    MLO_FLOAT_C(162859.675089),
    MLO_FLOAT_C(162886.460669),
    MLO_FLOAT_C(162913.24735),
    MLO_FLOAT_C(162940.035132),
    MLO_FLOAT_C(162966.824016),
    MLO_FLOAT_C(162993.614),
    MLO_FLOAT_C(163020.405085),
    MLO_FLOAT_C(163047.197271),
    MLO_FLOAT_C(163073.990558),
    MLO_FLOAT_C(163100.784945),
    MLO_FLOAT_C(163127.580433),
    MLO_FLOAT_C(163154.377021),
    MLO_FLOAT_C(163181.17471),
    MLO_FLOAT_C(163207.973499),
    MLO_FLOAT_C(163234.773388),
    MLO_FLOAT_C(163261.574377),
    MLO_FLOAT_C(163288.376465),
    MLO_FLOAT_C(163315.179654),
    MLO_FLOAT_C(163341.983943),
    MLO_FLOAT_C(163368.789331),
    MLO_FLOAT_C(163395.595819),
    MLO_FLOAT_C(163422.403406),
    MLO_FLOAT_C(163449.212093),
    MLO_FLOAT_C(163476.021879),
    MLO_FLOAT_C(163502.832764),
    MLO_FLOAT_C(163529.644749),
    MLO_FLOAT_C(163556.457832),
    MLO_FLOAT_C(163583.272015),
    MLO_FLOAT_C(163610.087296),
    MLO_FLOAT_C(163636.903676),
    MLO_FLOAT_C(163663.721155),
    MLO_FLOAT_C(163690.539732),
    MLO_FLOAT_C(163717.359408),
    MLO_FLOAT_C(163744.180182),
    MLO_FLOAT_C(163771.002055),
    MLO_FLOAT_C(163797.825026),
    MLO_FLOAT_C(163824.649095),
    MLO_FLOAT_C(163851.474262),
    MLO_FLOAT_C(163878.300527),
    MLO_FLOAT_C(163905.12789),
    MLO_FLOAT_C(163931.956351),
    MLO_FLOAT_C(163958.78591),
    MLO_FLOAT_C(163985.616566),
    MLO_FLOAT_C(164012.44832),
    MLO_FLOAT_C(164039.281171),
    MLO_FLOAT_C(164066.115119),
    MLO_FLOAT_C(164092.950165),
    MLO_FLOAT_C(164119.786308),
    MLO_FLOAT_C(164146.623548),
    MLO_FLOAT_C(164173.461884),
    MLO_FLOAT_C(164200.301318),
    MLO_FLOAT_C(164227.141849),
    MLO_FLOAT_C(164253.983476),
    MLO_FLOAT_C(164280.8262),
    MLO_FLOAT_C(164307.670021),
    MLO_FLOAT_C(164334.514938),
    MLO_FLOAT_C(164361.360951),
    MLO_FLOAT_C(164388.208061),
    MLO_FLOAT_C(164415.056266),
    MLO_FLOAT_C(164441.905568),
    MLO_FLOAT_C(164468.755966),
    MLO_FLOAT_C(164495.60746),
    MLO_FLOAT_C(164522.460049),
    MLO_FLOAT_C(164549.313735),
    MLO_FLOAT_C(164576.168516),
    MLO_FLOAT_C(164603.024392),
    MLO_FLOAT_C(164629.881364),
    MLO_FLOAT_C(164656.739432),
    MLO_FLOAT_C(164683.598594),
    MLO_FLOAT_C(164710.458852),
    MLO_FLOAT_C(164737.320205),
    MLO_FLOAT_C(164764.182653),
    MLO_FLOAT_C(164791.046196),
    MLO_FLOAT_C(164817.910834),
    MLO_FLOAT_C(164844.776566),
    MLO_FLOAT_C(164871.643393),
    MLO_FLOAT_C(164898.511315),
    MLO_FLOAT_C(164925.380331),
    MLO_FLOAT_C(164952.250442),
    MLO_FLOAT_C(164979.121647),
    MLO_FLOAT_C(165005.993946),
    MLO_FLOAT_C(165032.867339),
    MLO_FLOAT_C(165059.741827),
    MLO_FLOAT_C(165086.617408),
    MLO_FLOAT_C(165113.494083)
};
#else
/* use a small table with linear interpolation */
static const MLO_Float MLO_InvQuant_table_pow43 [8192 / 8] =
{
   MLO_FLOAT_C (0),
   MLO_FLOAT_C (16),
   MLO_FLOAT_C (40.3174736),
   MLO_FLOAT_C (69.2279794),
   MLO_FLOAT_C (101.593667),
   MLO_FLOAT_C (136.798076),
   MLO_FLOAT_C (174.443577),
   MLO_FLOAT_C (214.248292),
   MLO_FLOAT_C (256),
   MLO_FLOAT_C (299.532071),
   MLO_FLOAT_C (344.70955),
   MLO_FLOAT_C (391.420496),
   MLO_FLOAT_C (439.570269),
   MLO_FLOAT_C (489.077615),
   MLO_FLOAT_C (539.871867),
   MLO_FLOAT_C (591.890898),
   MLO_FLOAT_C (645.079578),
   MLO_FLOAT_C (699.388593),
   MLO_FLOAT_C (754.773522),
   MLO_FLOAT_C (811.194101),
   MLO_FLOAT_C (868.613637),
   MLO_FLOAT_C (926.998523),
   MLO_FLOAT_C (986.317844),
   MLO_FLOAT_C (1046.54305),
   MLO_FLOAT_C (1107.64767),
   MLO_FLOAT_C (1169.6071),
   MLO_FLOAT_C (1232.39836),
   MLO_FLOAT_C (1296),
   MLO_FLOAT_C (1360.39186),
   MLO_FLOAT_C (1425.55501),
   MLO_FLOAT_C (1491.4716),
   MLO_FLOAT_C (1558.1248),
   MLO_FLOAT_C (1625.49868),
   MLO_FLOAT_C (1693.57813),
   MLO_FLOAT_C (1762.34882),
   MLO_FLOAT_C (1831.79713),
   MLO_FLOAT_C (1901.9101),
   MLO_FLOAT_C (1972.67534),
   MLO_FLOAT_C (2044.08105),
   MLO_FLOAT_C (2116.11594),
   MLO_FLOAT_C (2188.76921),
   MLO_FLOAT_C (2262.03051),
   MLO_FLOAT_C (2335.88991),
   MLO_FLOAT_C (2410.33787),
   MLO_FLOAT_C (2485.36523),
   MLO_FLOAT_C (2560.96318),
   MLO_FLOAT_C (2637.12323),
   MLO_FLOAT_C (2713.83721),
   MLO_FLOAT_C (2791.09723),
   MLO_FLOAT_C (2868.89568),
   MLO_FLOAT_C (2947.2252),
   MLO_FLOAT_C (3026.07869),
   MLO_FLOAT_C (3105.44928),
   MLO_FLOAT_C (3185.33032),
   MLO_FLOAT_C (3265.71536),
   MLO_FLOAT_C (3346.59817),
   MLO_FLOAT_C (3427.97268),
   MLO_FLOAT_C (3509.83303),
   MLO_FLOAT_C (3592.17352),
   MLO_FLOAT_C (3674.98862),
   MLO_FLOAT_C (3758.27294),
   MLO_FLOAT_C (3842.02125),
   MLO_FLOAT_C (3926.22848),
   MLO_FLOAT_C (4010.88967),
   MLO_FLOAT_C (4096),
   MLO_FLOAT_C (4181.55479),
   MLO_FLOAT_C (4267.54946),
   MLO_FLOAT_C (4353.97956),
   MLO_FLOAT_C (4440.84075),
   MLO_FLOAT_C (4528.12879),
   MLO_FLOAT_C (4615.83954),
   MLO_FLOAT_C (4703.96896),
   MLO_FLOAT_C (4792.51313),
   MLO_FLOAT_C (4881.46818),
   MLO_FLOAT_C (4970.83036),
   MLO_FLOAT_C (5060.59599),
   MLO_FLOAT_C (5150.76148),
   MLO_FLOAT_C (5241.32331),
   MLO_FLOAT_C (5332.27803),
   MLO_FLOAT_C (5423.6223),
   MLO_FLOAT_C (5515.35281),
   MLO_FLOAT_C (5607.46633),
   MLO_FLOAT_C (5699.95971),
   MLO_FLOAT_C (5792.82985),
   MLO_FLOAT_C (5886.07372),
   MLO_FLOAT_C (5979.68835),
   MLO_FLOAT_C (6073.67083),
   MLO_FLOAT_C (6168.01829),
   MLO_FLOAT_C (6262.72794),
   MLO_FLOAT_C (6357.79702),
   MLO_FLOAT_C (6453.22284),
   MLO_FLOAT_C (6549.00274),
   MLO_FLOAT_C (6645.13415),
   MLO_FLOAT_C (6741.61449),
   MLO_FLOAT_C (6838.44126),
   MLO_FLOAT_C (6935.61201),
   MLO_FLOAT_C (7033.12431),
   MLO_FLOAT_C (7130.97578),
   MLO_FLOAT_C (7229.16411),
   MLO_FLOAT_C (7327.68697),
   MLO_FLOAT_C (7426.54213),
   MLO_FLOAT_C (7525.72736),
   MLO_FLOAT_C (7625.24048),
   MLO_FLOAT_C (7725.07935),
   MLO_FLOAT_C (7825.24184),
   MLO_FLOAT_C (7925.72589),
   MLO_FLOAT_C (8026.52944),
   MLO_FLOAT_C (8127.65049),
   MLO_FLOAT_C (8229.08705),
   MLO_FLOAT_C (8330.83718),
   MLO_FLOAT_C (8432.89895),
   MLO_FLOAT_C (8535.27047),
   MLO_FLOAT_C (8637.94987),
   MLO_FLOAT_C (8740.93533),
   MLO_FLOAT_C (8844.22504),
   MLO_FLOAT_C (8947.8172),
   MLO_FLOAT_C (9051.71007),
   MLO_FLOAT_C (9155.90192),
   MLO_FLOAT_C (9260.39103),
   MLO_FLOAT_C (9365.17573),
   MLO_FLOAT_C (9470.25437),
   MLO_FLOAT_C (9575.62529),
   MLO_FLOAT_C (9681.2869),
   MLO_FLOAT_C (9787.23759),
   MLO_FLOAT_C (9893.47581),
   MLO_FLOAT_C (10000),
   MLO_FLOAT_C (10106.8086),
   MLO_FLOAT_C (10213.9002),
   MLO_FLOAT_C (10321.2732),
   MLO_FLOAT_C (10428.9263),
   MLO_FLOAT_C (10536.8578),
   MLO_FLOAT_C (10645.0665),
   MLO_FLOAT_C (10753.5508),
   MLO_FLOAT_C (10862.3094),
   MLO_FLOAT_C (10971.341),
   MLO_FLOAT_C (11080.6441),
   MLO_FLOAT_C (11190.2175),
   MLO_FLOAT_C (11300.0597),
   MLO_FLOAT_C (11410.1695),
   MLO_FLOAT_C (11520.5457),
   MLO_FLOAT_C (11631.1868),
   MLO_FLOAT_C (11742.0917),
   MLO_FLOAT_C (11853.259),
   MLO_FLOAT_C (11964.6877),
   MLO_FLOAT_C (12076.3763),
   MLO_FLOAT_C (12188.3239),
   MLO_FLOAT_C (12300.529),
   MLO_FLOAT_C (12412.9907),
   MLO_FLOAT_C (12525.7076),
   MLO_FLOAT_C (12638.6787),
   MLO_FLOAT_C (12751.9028),
   MLO_FLOAT_C (12865.3788),
   MLO_FLOAT_C (12979.1056),
   MLO_FLOAT_C (13093.0821),
   MLO_FLOAT_C (13207.3071),
   MLO_FLOAT_C (13321.7797),
   MLO_FLOAT_C (13436.4987),
   MLO_FLOAT_C (13551.4631),
   MLO_FLOAT_C (13666.6718),
   MLO_FLOAT_C (13782.1239),
   MLO_FLOAT_C (13897.8182),
   MLO_FLOAT_C (14013.7538),
   MLO_FLOAT_C (14129.9297),
   MLO_FLOAT_C (14246.3449),
   MLO_FLOAT_C (14362.9984),
   MLO_FLOAT_C (14479.8893),
   MLO_FLOAT_C (14597.0165),
   MLO_FLOAT_C (14714.3792),
   MLO_FLOAT_C (14831.9764),
   MLO_FLOAT_C (14949.8071),
   MLO_FLOAT_C (15067.8705),
   MLO_FLOAT_C (15186.1655),
   MLO_FLOAT_C (15304.6915),
   MLO_FLOAT_C (15423.4473),
   MLO_FLOAT_C (15542.4322),
   MLO_FLOAT_C (15661.6452),
   MLO_FLOAT_C (15781.0855),
   MLO_FLOAT_C (15900.7523),
   MLO_FLOAT_C (16020.6446),
   MLO_FLOAT_C (16140.7616),
   MLO_FLOAT_C (16261.1026),
   MLO_FLOAT_C (16381.6666),
   MLO_FLOAT_C (16502.4528),
   MLO_FLOAT_C (16623.4605),
   MLO_FLOAT_C (16744.6888),
   MLO_FLOAT_C (16866.1369),
   MLO_FLOAT_C (16987.804),
   MLO_FLOAT_C (17109.6894),
   MLO_FLOAT_C (17231.7922),
   MLO_FLOAT_C (17354.1117),
   MLO_FLOAT_C (17476.6471),
   MLO_FLOAT_C (17599.3977),
   MLO_FLOAT_C (17722.3627),
   MLO_FLOAT_C (17845.5414),
   MLO_FLOAT_C (17968.933),
   MLO_FLOAT_C (18092.5368),
   MLO_FLOAT_C (18216.3521),
   MLO_FLOAT_C (18340.3781),
   MLO_FLOAT_C (18464.6141),
   MLO_FLOAT_C (18589.0595),
   MLO_FLOAT_C (18713.7135),
   MLO_FLOAT_C (18838.5755),
   MLO_FLOAT_C (18963.6446),
   MLO_FLOAT_C (19088.9204),
   MLO_FLOAT_C (19214.402),
   MLO_FLOAT_C (19340.0888),
   MLO_FLOAT_C (19465.9802),
   MLO_FLOAT_C (19592.0754),
   MLO_FLOAT_C (19718.3738),
   MLO_FLOAT_C (19844.8748),
   MLO_FLOAT_C (19971.5778),
   MLO_FLOAT_C (20098.482),
   MLO_FLOAT_C (20225.5868),
   MLO_FLOAT_C (20352.8916),
   MLO_FLOAT_C (20480.3959),
   MLO_FLOAT_C (20608.0989),
   MLO_FLOAT_C (20736),
   MLO_FLOAT_C (20864.0987),
   MLO_FLOAT_C (20992.3943),
   MLO_FLOAT_C (21120.8862),
   MLO_FLOAT_C (21249.5738),
   MLO_FLOAT_C (21378.4566),
   MLO_FLOAT_C (21507.5339),
   MLO_FLOAT_C (21636.8051),
   MLO_FLOAT_C (21766.2698),
   MLO_FLOAT_C (21895.9272),
   MLO_FLOAT_C (22025.7768),
   MLO_FLOAT_C (22155.8182),
   MLO_FLOAT_C (22286.0506),
   MLO_FLOAT_C (22416.4735),
   MLO_FLOAT_C (22547.0865),
   MLO_FLOAT_C (22677.8889),
   MLO_FLOAT_C (22808.8801),
   MLO_FLOAT_C (22940.0597),
   MLO_FLOAT_C (23071.4271),
   MLO_FLOAT_C (23202.9818),
   MLO_FLOAT_C (23334.7232),
   MLO_FLOAT_C (23466.6508),
   MLO_FLOAT_C (23598.7641),
   MLO_FLOAT_C (23731.0625),
   MLO_FLOAT_C (23863.5456),
   MLO_FLOAT_C (23996.2129),
   MLO_FLOAT_C (24129.0637),
   MLO_FLOAT_C (24262.0977),
   MLO_FLOAT_C (24395.3143),
   MLO_FLOAT_C (24528.713),
   MLO_FLOAT_C (24662.2933),
   MLO_FLOAT_C (24796.0548),
   MLO_FLOAT_C (24929.9969),
   MLO_FLOAT_C (25064.1191),
   MLO_FLOAT_C (25198.421),
   MLO_FLOAT_C (25332.9021),
   MLO_FLOAT_C (25467.5619),
   MLO_FLOAT_C (25602.3999),
   MLO_FLOAT_C (25737.4158),
   MLO_FLOAT_C (25872.6089),
   MLO_FLOAT_C (26007.9788),
   MLO_FLOAT_C (26143.5252),
   MLO_FLOAT_C (26279.2474),
   MLO_FLOAT_C (26415.1451),
   MLO_FLOAT_C (26551.2179),
   MLO_FLOAT_C (26687.4652),
   MLO_FLOAT_C (26823.8866),
   MLO_FLOAT_C (26960.4817),
   MLO_FLOAT_C (27097.25),
   MLO_FLOAT_C (27234.1911),
   MLO_FLOAT_C (27371.3046),
   MLO_FLOAT_C (27508.59),
   MLO_FLOAT_C (27646.047),
   MLO_FLOAT_C (27783.6749),
   MLO_FLOAT_C (27921.4736),
   MLO_FLOAT_C (28059.4424),
   MLO_FLOAT_C (28197.5811),
   MLO_FLOAT_C (28335.8892),
   MLO_FLOAT_C (28474.3662),
   MLO_FLOAT_C (28613.0118),
   MLO_FLOAT_C (28751.8256),
   MLO_FLOAT_C (28890.8071),
   MLO_FLOAT_C (29029.956),
   MLO_FLOAT_C (29169.2718),
   MLO_FLOAT_C (29308.7541),
   MLO_FLOAT_C (29448.4026),
   MLO_FLOAT_C (29588.2169),
   MLO_FLOAT_C (29728.1965),
   MLO_FLOAT_C (29868.3411),
   MLO_FLOAT_C (30008.6503),
   MLO_FLOAT_C (30149.1237),
   MLO_FLOAT_C (30289.7609),
   MLO_FLOAT_C (30430.5615),
   MLO_FLOAT_C (30571.5252),
   MLO_FLOAT_C (30712.6516),
   MLO_FLOAT_C (30853.9403),
   MLO_FLOAT_C (30995.3909),
   MLO_FLOAT_C (31137.0031),
   MLO_FLOAT_C (31278.7765),
   MLO_FLOAT_C (31420.7107),
   MLO_FLOAT_C (31562.8054),
   MLO_FLOAT_C (31705.0602),
   MLO_FLOAT_C (31847.4747),
   MLO_FLOAT_C (31990.0486),
   MLO_FLOAT_C (32132.7816),
   MLO_FLOAT_C (32275.6732),
   MLO_FLOAT_C (32418.7232),
   MLO_FLOAT_C (32561.9312),
   MLO_FLOAT_C (32705.2968),
   MLO_FLOAT_C (32848.8196),
   MLO_FLOAT_C (32992.4994),
   MLO_FLOAT_C (33136.3358),
   MLO_FLOAT_C (33280.3285),
   MLO_FLOAT_C (33424.4771),
   MLO_FLOAT_C (33568.7813),
   MLO_FLOAT_C (33713.2407),
   MLO_FLOAT_C (33857.855),
   MLO_FLOAT_C (34002.624),
   MLO_FLOAT_C (34147.5472),
   MLO_FLOAT_C (34292.6243),
   MLO_FLOAT_C (34437.855),
   MLO_FLOAT_C (34583.239),
   MLO_FLOAT_C (34728.7759),
   MLO_FLOAT_C (34874.4655),
   MLO_FLOAT_C (35020.3074),
   MLO_FLOAT_C (35166.3013),
   MLO_FLOAT_C (35312.4469),
   MLO_FLOAT_C (35458.7438),
   MLO_FLOAT_C (35605.1918),
   MLO_FLOAT_C (35751.7905),
   MLO_FLOAT_C (35898.5397),
   MLO_FLOAT_C (36045.439),
   MLO_FLOAT_C (36192.4882),
   MLO_FLOAT_C (36339.6868),
   MLO_FLOAT_C (36487.0347),
   MLO_FLOAT_C (36634.5314),
   MLO_FLOAT_C (36782.1768),
   MLO_FLOAT_C (36929.9705),
   MLO_FLOAT_C (37077.9122),
   MLO_FLOAT_C (37226.0016),
   MLO_FLOAT_C (37374.2385),
   MLO_FLOAT_C (37522.6225),
   MLO_FLOAT_C (37671.1533),
   MLO_FLOAT_C (37819.8307),
   MLO_FLOAT_C (37968.6543),
   MLO_FLOAT_C (38117.624),
   MLO_FLOAT_C (38266.7393),
   MLO_FLOAT_C (38416),
   MLO_FLOAT_C (38565.4058),
   MLO_FLOAT_C (38714.9565),
   MLO_FLOAT_C (38864.6518),
   MLO_FLOAT_C (39014.4913),
   MLO_FLOAT_C (39164.4749),
   MLO_FLOAT_C (39314.6022),
   MLO_FLOAT_C (39464.8729),
   MLO_FLOAT_C (39615.2868),
   MLO_FLOAT_C (39765.8436),
   MLO_FLOAT_C (39916.5431),
   MLO_FLOAT_C (40067.385),
   MLO_FLOAT_C (40218.3689),
   MLO_FLOAT_C (40369.4947),
   MLO_FLOAT_C (40520.762),
   MLO_FLOAT_C (40672.1707),
   MLO_FLOAT_C (40823.7204),
   MLO_FLOAT_C (40975.4109),
   MLO_FLOAT_C (41127.2419),
   MLO_FLOAT_C (41279.2131),
   MLO_FLOAT_C (41431.3244),
   MLO_FLOAT_C (41583.5754),
   MLO_FLOAT_C (41735.9659),
   MLO_FLOAT_C (41888.4956),
   MLO_FLOAT_C (42041.1643),
   MLO_FLOAT_C (42193.9717),
   MLO_FLOAT_C (42346.9176),
   MLO_FLOAT_C (42500.0018),
   MLO_FLOAT_C (42653.2239),
   MLO_FLOAT_C (42806.5837),
   MLO_FLOAT_C (42960.081),
   MLO_FLOAT_C (43113.7156),
   MLO_FLOAT_C (43267.4871),
   MLO_FLOAT_C (43421.3954),
   MLO_FLOAT_C (43575.4402),
   MLO_FLOAT_C (43729.6212),
   MLO_FLOAT_C (43883.9383),
   MLO_FLOAT_C (44038.3912),
   MLO_FLOAT_C (44192.9796),
   MLO_FLOAT_C (44347.7033),
   MLO_FLOAT_C (44502.5621),
   MLO_FLOAT_C (44657.5557),
   MLO_FLOAT_C (44812.6839),
   MLO_FLOAT_C (44967.9465),
   MLO_FLOAT_C (45123.3432),
   MLO_FLOAT_C (45278.8738),
   MLO_FLOAT_C (45434.5382),
   MLO_FLOAT_C (45590.3359),
   MLO_FLOAT_C (45746.2669),
   MLO_FLOAT_C (45902.3308),
   MLO_FLOAT_C (46058.5275),
   MLO_FLOAT_C (46214.8568),
   MLO_FLOAT_C (46371.3184),
   MLO_FLOAT_C (46527.912),
   MLO_FLOAT_C (46684.6376),
   MLO_FLOAT_C (46841.4948),
   MLO_FLOAT_C (46998.4834),
   MLO_FLOAT_C (47155.6032),
   MLO_FLOAT_C (47312.854),
   MLO_FLOAT_C (47470.2356),
   MLO_FLOAT_C (47627.7477),
   MLO_FLOAT_C (47785.3901),
   MLO_FLOAT_C (47943.1627),
   MLO_FLOAT_C (48101.0652),
   MLO_FLOAT_C (48259.0974),
   MLO_FLOAT_C (48417.2591),
   MLO_FLOAT_C (48575.55),
   MLO_FLOAT_C (48733.97),
   MLO_FLOAT_C (48892.5188),
   MLO_FLOAT_C (49051.1963),
   MLO_FLOAT_C (49210.0022),
   MLO_FLOAT_C (49368.9364),
   MLO_FLOAT_C (49527.9985),
   MLO_FLOAT_C (49687.1885),
   MLO_FLOAT_C (49846.5061),
   MLO_FLOAT_C (50005.9511),
   MLO_FLOAT_C (50165.5233),
   MLO_FLOAT_C (50325.2224),
   MLO_FLOAT_C (50485.0484),
   MLO_FLOAT_C (50645.001),
   MLO_FLOAT_C (50805.08),
   MLO_FLOAT_C (50965.2851),
   MLO_FLOAT_C (51125.6163),
   MLO_FLOAT_C (51286.0732),
   MLO_FLOAT_C (51446.6558),
   MLO_FLOAT_C (51607.3638),
   MLO_FLOAT_C (51768.1969),
   MLO_FLOAT_C (51929.1551),
   MLO_FLOAT_C (52090.2381),
   MLO_FLOAT_C (52251.4458),
   MLO_FLOAT_C (52412.7779),
   MLO_FLOAT_C (52574.2342),
   MLO_FLOAT_C (52735.8146),
   MLO_FLOAT_C (52897.5188),
   MLO_FLOAT_C (53059.3467),
   MLO_FLOAT_C (53221.2981),
   MLO_FLOAT_C (53383.3728),
   MLO_FLOAT_C (53545.5706),
   MLO_FLOAT_C (53707.8914),
   MLO_FLOAT_C (53870.3349),
   MLO_FLOAT_C (54032.9009),
   MLO_FLOAT_C (54195.5893),
   MLO_FLOAT_C (54358.3999),
   MLO_FLOAT_C (54521.3324),
   MLO_FLOAT_C (54684.3868),
   MLO_FLOAT_C (54847.5629),
   MLO_FLOAT_C (55010.8604),
   MLO_FLOAT_C (55174.2791),
   MLO_FLOAT_C (55337.819),
   MLO_FLOAT_C (55501.4798),
   MLO_FLOAT_C (55665.2613),
   MLO_FLOAT_C (55829.1634),
   MLO_FLOAT_C (55993.1858),
   MLO_FLOAT_C (56157.3285),
   MLO_FLOAT_C (56321.5912),
   MLO_FLOAT_C (56485.9738),
   MLO_FLOAT_C (56650.476),
   MLO_FLOAT_C (56815.0978),
   MLO_FLOAT_C (56979.8388),
   MLO_FLOAT_C (57144.6991),
   MLO_FLOAT_C (57309.6783),
   MLO_FLOAT_C (57474.7764),
   MLO_FLOAT_C (57639.9931),
   MLO_FLOAT_C (57805.3282),
   MLO_FLOAT_C (57970.7817),
   MLO_FLOAT_C (58136.3533),
   MLO_FLOAT_C (58302.0429),
   MLO_FLOAT_C (58467.8503),
   MLO_FLOAT_C (58633.7754),
   MLO_FLOAT_C (58799.8179),
   MLO_FLOAT_C (58965.9777),
   MLO_FLOAT_C (59132.2546),
   MLO_FLOAT_C (59298.6485),
   MLO_FLOAT_C (59465.1593),
   MLO_FLOAT_C (59631.7866),
   MLO_FLOAT_C (59798.5305),
   MLO_FLOAT_C (59965.3906),
   MLO_FLOAT_C (60132.367),
   MLO_FLOAT_C (60299.4593),
   MLO_FLOAT_C (60466.6675),
   MLO_FLOAT_C (60633.9913),
   MLO_FLOAT_C (60801.4306),
   MLO_FLOAT_C (60968.9853),
   MLO_FLOAT_C (61136.6552),
   MLO_FLOAT_C (61304.4402),
   MLO_FLOAT_C (61472.34),
   MLO_FLOAT_C (61640.3546),
   MLO_FLOAT_C (61808.4837),
   MLO_FLOAT_C (61976.7272),
   MLO_FLOAT_C (62145.085),
   MLO_FLOAT_C (62313.5569),
   MLO_FLOAT_C (62482.1427),
   MLO_FLOAT_C (62650.8424),
   MLO_FLOAT_C (62819.6556),
   MLO_FLOAT_C (62988.5824),
   MLO_FLOAT_C (63157.6225),
   MLO_FLOAT_C (63326.7758),
   MLO_FLOAT_C (63496.0421),
   MLO_FLOAT_C (63665.4213),
   MLO_FLOAT_C (63834.9132),
   MLO_FLOAT_C (64004.5177),
   MLO_FLOAT_C (64174.2346),
   MLO_FLOAT_C (64344.0639),
   MLO_FLOAT_C (64514.0052),
   MLO_FLOAT_C (64684.0586),
   MLO_FLOAT_C (64854.2238),
   MLO_FLOAT_C (65024.5007),
   MLO_FLOAT_C (65194.8891),
   MLO_FLOAT_C (65365.3889),
   MLO_FLOAT_C (65536),
   MLO_FLOAT_C (65706.7222),
   MLO_FLOAT_C (65877.5554),
   MLO_FLOAT_C (66048.4994),
   MLO_FLOAT_C (66219.554),
   MLO_FLOAT_C (66390.7192),
   MLO_FLOAT_C (66561.9948),
   MLO_FLOAT_C (66733.3807),
   MLO_FLOAT_C (66904.8766),
   MLO_FLOAT_C (67076.4825),
   MLO_FLOAT_C (67248.1983),
   MLO_FLOAT_C (67420.0237),
   MLO_FLOAT_C (67591.9587),
   MLO_FLOAT_C (67764.0031),
   MLO_FLOAT_C (67936.1568),
   MLO_FLOAT_C (68108.4196),
   MLO_FLOAT_C (68280.7914),
   MLO_FLOAT_C (68453.272),
   MLO_FLOAT_C (68625.8614),
   MLO_FLOAT_C (68798.5593),
   MLO_FLOAT_C (68971.3657),
   MLO_FLOAT_C (69144.2804),
   MLO_FLOAT_C (69317.3033),
   MLO_FLOAT_C (69490.4342),
   MLO_FLOAT_C (69663.673),
   MLO_FLOAT_C (69837.0196),
   MLO_FLOAT_C (70010.4738),
   MLO_FLOAT_C (70184.0355),
   MLO_FLOAT_C (70357.7046),
   MLO_FLOAT_C (70531.4809),
   MLO_FLOAT_C (70705.3644),
   MLO_FLOAT_C (70879.3548),
   MLO_FLOAT_C (71053.452),
   MLO_FLOAT_C (71227.656),
   MLO_FLOAT_C (71401.9665),
   MLO_FLOAT_C (71576.3835),
   MLO_FLOAT_C (71750.9068),
   MLO_FLOAT_C (71925.5363),
   MLO_FLOAT_C (72100.2718),
   MLO_FLOAT_C (72275.1133),
   MLO_FLOAT_C (72450.0606),
   MLO_FLOAT_C (72625.1135),
   MLO_FLOAT_C (72800.2721),
   MLO_FLOAT_C (72975.536),
   MLO_FLOAT_C (73150.9052),
   MLO_FLOAT_C (73326.3796),
   MLO_FLOAT_C (73501.9591),
   MLO_FLOAT_C (73677.6434),
   MLO_FLOAT_C (73853.4326),
   MLO_FLOAT_C (74029.3264),
   MLO_FLOAT_C (74205.3248),
   MLO_FLOAT_C (74381.4275),
   MLO_FLOAT_C (74557.6346),
   MLO_FLOAT_C (74733.9459),
   MLO_FLOAT_C (74910.3612),
   MLO_FLOAT_C (75086.8804),
   MLO_FLOAT_C (75263.5034),
   MLO_FLOAT_C (75440.2301),
   MLO_FLOAT_C (75617.0604),
   MLO_FLOAT_C (75793.9941),
   MLO_FLOAT_C (75971.0311),
   MLO_FLOAT_C (76148.1714),
   MLO_FLOAT_C (76325.4147),
   MLO_FLOAT_C (76502.7609),
   MLO_FLOAT_C (76680.2101),
   MLO_FLOAT_C (76857.7619),
   MLO_FLOAT_C (77035.4163),
   MLO_FLOAT_C (77213.1732),
   MLO_FLOAT_C (77391.0325),
   MLO_FLOAT_C (77568.994),
   MLO_FLOAT_C (77747.0577),
   MLO_FLOAT_C (77925.2233),
   MLO_FLOAT_C (78103.4909),
   MLO_FLOAT_C (78281.8602),
   MLO_FLOAT_C (78460.3313),
   MLO_FLOAT_C (78638.9038),
   MLO_FLOAT_C (78817.5778),
   MLO_FLOAT_C (78996.3531),
   MLO_FLOAT_C (79175.2296),
   MLO_FLOAT_C (79354.2072),
   MLO_FLOAT_C (79533.2858),
   MLO_FLOAT_C (79712.4652),
   MLO_FLOAT_C (79891.7454),
   MLO_FLOAT_C (80071.1262),
   MLO_FLOAT_C (80250.6075),
   MLO_FLOAT_C (80430.1893),
   MLO_FLOAT_C (80609.8713),
   MLO_FLOAT_C (80789.6536),
   MLO_FLOAT_C (80969.5359),
   MLO_FLOAT_C (81149.5181),
   MLO_FLOAT_C (81329.6002),
   MLO_FLOAT_C (81509.7821),
   MLO_FLOAT_C (81690.0636),
   MLO_FLOAT_C (81870.4446),
   MLO_FLOAT_C (82050.925),
   MLO_FLOAT_C (82231.5047),
   MLO_FLOAT_C (82412.1837),
   MLO_FLOAT_C (82592.9617),
   MLO_FLOAT_C (82773.8386),
   MLO_FLOAT_C (82954.8145),
   MLO_FLOAT_C (83135.8891),
   MLO_FLOAT_C (83317.0623),
   MLO_FLOAT_C (83498.3341),
   MLO_FLOAT_C (83679.7043),
   MLO_FLOAT_C (83861.1729),
   MLO_FLOAT_C (84042.7397),
   MLO_FLOAT_C (84224.4046),
   MLO_FLOAT_C (84406.1675),
   MLO_FLOAT_C (84588.0283),
   MLO_FLOAT_C (84769.9869),
   MLO_FLOAT_C (84952.0433),
   MLO_FLOAT_C (85134.1972),
   MLO_FLOAT_C (85316.4486),
   MLO_FLOAT_C (85498.7973),
   MLO_FLOAT_C (85681.2434),
   MLO_FLOAT_C (85863.7866),
   MLO_FLOAT_C (86046.4269),
   MLO_FLOAT_C (86229.1642),
   MLO_FLOAT_C (86411.9983),
   MLO_FLOAT_C (86594.9292),
   MLO_FLOAT_C (86777.9568),
   MLO_FLOAT_C (86961.0809),
   MLO_FLOAT_C (87144.3015),
   MLO_FLOAT_C (87327.6184),
   MLO_FLOAT_C (87511.0316),
   MLO_FLOAT_C (87694.541),
   MLO_FLOAT_C (87878.1464),
   MLO_FLOAT_C (88061.8477),
   MLO_FLOAT_C (88245.6449),
   MLO_FLOAT_C (88429.5379),
   MLO_FLOAT_C (88613.5265),
   MLO_FLOAT_C (88797.6106),
   MLO_FLOAT_C (88981.7902),
   MLO_FLOAT_C (89166.0652),
   MLO_FLOAT_C (89350.4354),
   MLO_FLOAT_C (89534.9008),
   MLO_FLOAT_C (89719.4613),
   MLO_FLOAT_C (89904.1167),
   MLO_FLOAT_C (90088.867),
   MLO_FLOAT_C (90273.712),
   MLO_FLOAT_C (90458.6517),
   MLO_FLOAT_C (90643.686),
   MLO_FLOAT_C (90828.8148),
   MLO_FLOAT_C (91014.0379),
   MLO_FLOAT_C (91199.3553),
   MLO_FLOAT_C (91384.767),
   MLO_FLOAT_C (91570.2727),
   MLO_FLOAT_C (91755.8724),
   MLO_FLOAT_C (91941.566),
   MLO_FLOAT_C (92127.3534),
   MLO_FLOAT_C (92313.2346),
   MLO_FLOAT_C (92499.2093),
   MLO_FLOAT_C (92685.2776),
   MLO_FLOAT_C (92871.4393),
   MLO_FLOAT_C (93057.6944),
   MLO_FLOAT_C (93244.0427),
   MLO_FLOAT_C (93430.4841),
   MLO_FLOAT_C (93617.0186),
   MLO_FLOAT_C (93803.6461),
   MLO_FLOAT_C (93990.3665),
   MLO_FLOAT_C (94177.1796),
   MLO_FLOAT_C (94364.0854),
   MLO_FLOAT_C (94551.0838),
   MLO_FLOAT_C (94738.1747),
   MLO_FLOAT_C (94925.358),
   MLO_FLOAT_C (95112.6337),
   MLO_FLOAT_C (95300.0016),
   MLO_FLOAT_C (95487.4616),
   MLO_FLOAT_C (95675.0137),
   MLO_FLOAT_C (95862.6577),
   MLO_FLOAT_C (96050.3936),
   MLO_FLOAT_C (96238.2213),
   MLO_FLOAT_C (96426.1406),
   MLO_FLOAT_C (96614.1516),
   MLO_FLOAT_C (96802.2541),
   MLO_FLOAT_C (96990.448),
   MLO_FLOAT_C (97178.7333),
   MLO_FLOAT_C (97367.1097),
   MLO_FLOAT_C (97555.5774),
   MLO_FLOAT_C (97744.1361),
   MLO_FLOAT_C (97932.7858),
   MLO_FLOAT_C (98121.5264),
   MLO_FLOAT_C (98310.3578),
   MLO_FLOAT_C (98499.2799),
   MLO_FLOAT_C (98688.2926),
   MLO_FLOAT_C (98877.3959),
   MLO_FLOAT_C (99066.5897),
   MLO_FLOAT_C (99255.8738),
   MLO_FLOAT_C (99445.2482),
   MLO_FLOAT_C (99634.7128),
   MLO_FLOAT_C (99824.2675),
   MLO_FLOAT_C (100013.912),
   MLO_FLOAT_C (100203.647),
   MLO_FLOAT_C (100393.472),
   MLO_FLOAT_C (100583.386),
   MLO_FLOAT_C (100773.39),
   MLO_FLOAT_C (100963.483),
   MLO_FLOAT_C (101153.667),
   MLO_FLOAT_C (101343.939),
   MLO_FLOAT_C (101534.301),
   MLO_FLOAT_C (101724.752),
   MLO_FLOAT_C (101915.293),
   MLO_FLOAT_C (102105.922),
   MLO_FLOAT_C (102296.641),
   MLO_FLOAT_C (102487.448),
   MLO_FLOAT_C (102678.344),
   MLO_FLOAT_C (102869.329),
   MLO_FLOAT_C (103060.403),
   MLO_FLOAT_C (103251.565),
   MLO_FLOAT_C (103442.816),
   MLO_FLOAT_C (103634.155),
   MLO_FLOAT_C (103825.583),
   MLO_FLOAT_C (104017.099),
   MLO_FLOAT_C (104208.703),
   MLO_FLOAT_C (104400.395),
   MLO_FLOAT_C (104592.176),
   MLO_FLOAT_C (104784.044),
   MLO_FLOAT_C (104976),
   MLO_FLOAT_C (105168.044),
   MLO_FLOAT_C (105360.175),
   MLO_FLOAT_C (105552.395),
   MLO_FLOAT_C (105744.701),
   MLO_FLOAT_C (105937.096),
   MLO_FLOAT_C (106129.577),
   MLO_FLOAT_C (106322.146),
   MLO_FLOAT_C (106514.803),
   MLO_FLOAT_C (106707.546),
   MLO_FLOAT_C (106900.376),
   MLO_FLOAT_C (107093.294),
   MLO_FLOAT_C (107286.298),
   MLO_FLOAT_C (107479.389),
   MLO_FLOAT_C (107672.567),
   MLO_FLOAT_C (107865.832),
   MLO_FLOAT_C (108059.183),
   MLO_FLOAT_C (108252.621),
   MLO_FLOAT_C (108446.145),
   MLO_FLOAT_C (108639.756),
   MLO_FLOAT_C (108833.452),
   MLO_FLOAT_C (109027.236),
   MLO_FLOAT_C (109221.105),
   MLO_FLOAT_C (109415.06),
   MLO_FLOAT_C (109609.101),
   MLO_FLOAT_C (109803.229),
   MLO_FLOAT_C (109997.442),
   MLO_FLOAT_C (110191.741),
   MLO_FLOAT_C (110386.125),
   MLO_FLOAT_C (110580.595),
   MLO_FLOAT_C (110775.151),
   MLO_FLOAT_C (110969.792),
   MLO_FLOAT_C (111164.519),
   MLO_FLOAT_C (111359.33),
   MLO_FLOAT_C (111554.228),
   MLO_FLOAT_C (111749.21),
   MLO_FLOAT_C (111944.277),
   MLO_FLOAT_C (112139.429),
   MLO_FLOAT_C (112334.667),
   MLO_FLOAT_C (112529.989),
   MLO_FLOAT_C (112725.396),
   MLO_FLOAT_C (112920.888),
   MLO_FLOAT_C (113116.464),
   MLO_FLOAT_C (113312.125),
   MLO_FLOAT_C (113507.87),
   MLO_FLOAT_C (113703.7),
   MLO_FLOAT_C (113899.614),
   MLO_FLOAT_C (114095.613),
   MLO_FLOAT_C (114291.695),
   MLO_FLOAT_C (114487.862),
   MLO_FLOAT_C (114684.113),
   MLO_FLOAT_C (114880.448),
   MLO_FLOAT_C (115076.867),
   MLO_FLOAT_C (115273.369),
   MLO_FLOAT_C (115469.956),
   MLO_FLOAT_C (115666.626),
   MLO_FLOAT_C (115863.379),
   MLO_FLOAT_C (116060.217),
   MLO_FLOAT_C (116257.138),
   MLO_FLOAT_C (116454.142),
   MLO_FLOAT_C (116651.229),
   MLO_FLOAT_C (116848.4),
   MLO_FLOAT_C (117045.654),
   MLO_FLOAT_C (117242.992),
   MLO_FLOAT_C (117440.412),
   MLO_FLOAT_C (117637.915),
   MLO_FLOAT_C (117835.501),
   MLO_FLOAT_C (118033.171),
   MLO_FLOAT_C (118230.922),
   MLO_FLOAT_C (118428.757),
   MLO_FLOAT_C (118626.674),
   MLO_FLOAT_C (118824.674),
   MLO_FLOAT_C (119022.757),
   MLO_FLOAT_C (119220.921),
   MLO_FLOAT_C (119419.169),
   MLO_FLOAT_C (119617.498),
   MLO_FLOAT_C (119815.91),
   MLO_FLOAT_C (120014.404),
   MLO_FLOAT_C (120212.98),
   MLO_FLOAT_C (120411.638),
   MLO_FLOAT_C (120610.378),
   MLO_FLOAT_C (120809.2),
   MLO_FLOAT_C (121008.104),
   MLO_FLOAT_C (121207.089),
   MLO_FLOAT_C (121406.156),
   MLO_FLOAT_C (121605.305),
   MLO_FLOAT_C (121804.536),
   MLO_FLOAT_C (122003.848),
   MLO_FLOAT_C (122203.241),
   MLO_FLOAT_C (122402.716),
   MLO_FLOAT_C (122602.272),
   MLO_FLOAT_C (122801.909),
   MLO_FLOAT_C (123001.628),
   MLO_FLOAT_C (123201.427),
   MLO_FLOAT_C (123401.308),
   MLO_FLOAT_C (123601.27),
   MLO_FLOAT_C (123801.312),
   MLO_FLOAT_C (124001.435),
   MLO_FLOAT_C (124201.64),
   MLO_FLOAT_C (124401.924),
   MLO_FLOAT_C (124602.29),
   MLO_FLOAT_C (124802.736),
   MLO_FLOAT_C (125003.262),
   MLO_FLOAT_C (125203.869),
   MLO_FLOAT_C (125404.557),
   MLO_FLOAT_C (125605.325),
   MLO_FLOAT_C (125806.173),
   MLO_FLOAT_C (126007.101),
   MLO_FLOAT_C (126208.109),
   MLO_FLOAT_C (126409.197),
   MLO_FLOAT_C (126610.366),
   MLO_FLOAT_C (126811.614),
   MLO_FLOAT_C (127012.942),
   MLO_FLOAT_C (127214.35),
   MLO_FLOAT_C (127415.838),
   MLO_FLOAT_C (127617.406),
   MLO_FLOAT_C (127819.053),
   MLO_FLOAT_C (128020.779),
   MLO_FLOAT_C (128222.585),
   MLO_FLOAT_C (128424.471),
   MLO_FLOAT_C (128626.436),
   MLO_FLOAT_C (128828.48),
   MLO_FLOAT_C (129030.604),
   MLO_FLOAT_C (129232.806),
   MLO_FLOAT_C (129435.088),
   MLO_FLOAT_C (129637.449),
   MLO_FLOAT_C (129839.889),
   MLO_FLOAT_C (130042.408),
   MLO_FLOAT_C (130245.006),
   MLO_FLOAT_C (130447.682),
   MLO_FLOAT_C (130650.437),
   MLO_FLOAT_C (130853.271),
   MLO_FLOAT_C (131056.184),
   MLO_FLOAT_C (131259.175),
   MLO_FLOAT_C (131462.245),
   MLO_FLOAT_C (131665.393),
   MLO_FLOAT_C (131868.619),
   MLO_FLOAT_C (132071.924),
   MLO_FLOAT_C (132275.307),
   MLO_FLOAT_C (132478.769),
   MLO_FLOAT_C (132682.308),
   MLO_FLOAT_C (132885.926),
   MLO_FLOAT_C (133089.621),
   MLO_FLOAT_C (133293.395),
   MLO_FLOAT_C (133497.246),
   MLO_FLOAT_C (133701.176),
   MLO_FLOAT_C (133905.183),
   MLO_FLOAT_C (134109.268),
   MLO_FLOAT_C (134313.43),
   MLO_FLOAT_C (134517.67),
   MLO_FLOAT_C (134721.988),
   MLO_FLOAT_C (134926.383),
   MLO_FLOAT_C (135130.856),
   MLO_FLOAT_C (135335.406),
   MLO_FLOAT_C (135540.033),
   MLO_FLOAT_C (135744.738),
   MLO_FLOAT_C (135949.519),
   MLO_FLOAT_C (136154.378),
   MLO_FLOAT_C (136359.314),
   MLO_FLOAT_C (136564.327),
   MLO_FLOAT_C (136769.418),
   MLO_FLOAT_C (136974.584),
   MLO_FLOAT_C (137179.828),
   MLO_FLOAT_C (137385.149),
   MLO_FLOAT_C (137590.546),
   MLO_FLOAT_C (137796.02),
   MLO_FLOAT_C (138001.571),
   MLO_FLOAT_C (138207.198),
   MLO_FLOAT_C (138412.902),
   MLO_FLOAT_C (138618.682),
   MLO_FLOAT_C (138824.538),
   MLO_FLOAT_C (139030.471),
   MLO_FLOAT_C (139236.481),
   MLO_FLOAT_C (139442.566),
   MLO_FLOAT_C (139648.728),
   MLO_FLOAT_C (139854.965),
   MLO_FLOAT_C (140061.279),
   MLO_FLOAT_C (140267.669),
   MLO_FLOAT_C (140474.135),
   MLO_FLOAT_C (140680.676),
   MLO_FLOAT_C (140887.294),
   MLO_FLOAT_C (141093.987),
   MLO_FLOAT_C (141300.756),
   MLO_FLOAT_C (141507.601),
   MLO_FLOAT_C (141714.521),
   MLO_FLOAT_C (141921.517),
   MLO_FLOAT_C (142128.588),
   MLO_FLOAT_C (142335.735),
   MLO_FLOAT_C (142542.957),
   MLO_FLOAT_C (142750.254),
   MLO_FLOAT_C (142957.627),
   MLO_FLOAT_C (143165.075),
   MLO_FLOAT_C (143372.598),
   MLO_FLOAT_C (143580.197),
   MLO_FLOAT_C (143787.87),
   MLO_FLOAT_C (143995.619),
   MLO_FLOAT_C (144203.442),
   MLO_FLOAT_C (144411.34),
   MLO_FLOAT_C (144619.313),
   MLO_FLOAT_C (144827.361),
   MLO_FLOAT_C (145035.484),
   MLO_FLOAT_C (145243.681),
   MLO_FLOAT_C (145451.953),
   MLO_FLOAT_C (145660.3),
   MLO_FLOAT_C (145868.721),
   MLO_FLOAT_C (146077.216),
   MLO_FLOAT_C (146285.786),
   MLO_FLOAT_C (146494.431),
   MLO_FLOAT_C (146703.149),
   MLO_FLOAT_C (146911.942),
   MLO_FLOAT_C (147120.809),
   MLO_FLOAT_C (147329.751),
   MLO_FLOAT_C (147538.766),
   MLO_FLOAT_C (147747.856),
   MLO_FLOAT_C (147957.019),
   MLO_FLOAT_C (148166.257),
   MLO_FLOAT_C (148375.568),
   MLO_FLOAT_C (148584.953),
   MLO_FLOAT_C (148794.412),
   MLO_FLOAT_C (149003.945),
   MLO_FLOAT_C (149213.551),
   MLO_FLOAT_C (149423.231),
   MLO_FLOAT_C (149632.985),
   MLO_FLOAT_C (149842.812),
   MLO_FLOAT_C (150052.712),
   MLO_FLOAT_C (150262.686),
   MLO_FLOAT_C (150472.734),
   MLO_FLOAT_C (150682.855),
   MLO_FLOAT_C (150893.049),
   MLO_FLOAT_C (151103.316),
   MLO_FLOAT_C (151313.656),
   MLO_FLOAT_C (151524.07),
   MLO_FLOAT_C (151734.556),
   MLO_FLOAT_C (151945.116),
   MLO_FLOAT_C (152155.749),
   MLO_FLOAT_C (152366.454),
   MLO_FLOAT_C (152577.233),
   MLO_FLOAT_C (152788.084),
   MLO_FLOAT_C (152999.008),
   MLO_FLOAT_C (153210.005),
   MLO_FLOAT_C (153421.074),
   MLO_FLOAT_C (153632.216),
   MLO_FLOAT_C (153843.431),
   MLO_FLOAT_C (154054.718),
   MLO_FLOAT_C (154266.077),
   MLO_FLOAT_C (154477.509),
   MLO_FLOAT_C (154689.014),
   MLO_FLOAT_C (154900.59),
   MLO_FLOAT_C (155112.239),
   MLO_FLOAT_C (155323.96),
   MLO_FLOAT_C (155535.754),
   MLO_FLOAT_C (155747.619),
   MLO_FLOAT_C (155959.557),
   MLO_FLOAT_C (156171.566),
   MLO_FLOAT_C (156383.648),
   MLO_FLOAT_C (156595.801),
   MLO_FLOAT_C (156808.027),
   MLO_FLOAT_C (157020.324),
   MLO_FLOAT_C (157232.693),
   MLO_FLOAT_C (157445.134),
   MLO_FLOAT_C (157657.646),
   MLO_FLOAT_C (157870.23),
   MLO_FLOAT_C (158082.886),
   MLO_FLOAT_C (158295.613),
   MLO_FLOAT_C (158508.412),
   MLO_FLOAT_C (158721.282),
   MLO_FLOAT_C (158934.223),
   MLO_FLOAT_C (159147.236),
   MLO_FLOAT_C (159360.32),
   MLO_FLOAT_C (159573.476),
   MLO_FLOAT_C (159786.702),
   MLO_FLOAT_C (160000),
   MLO_FLOAT_C (160213.369),
   MLO_FLOAT_C (160426.809),
   MLO_FLOAT_C (160640.32),
   MLO_FLOAT_C (160853.902),
   MLO_FLOAT_C (161067.555),
   MLO_FLOAT_C (161281.278),
   MLO_FLOAT_C (161495.073),
   MLO_FLOAT_C (161708.938),
   MLO_FLOAT_C (161922.874),
   MLO_FLOAT_C (162136.881),
   MLO_FLOAT_C (162350.958),
   MLO_FLOAT_C (162565.106),
   MLO_FLOAT_C (162779.325),
   MLO_FLOAT_C (162993.614),
   MLO_FLOAT_C (163207.973),
   MLO_FLOAT_C (163422.403),
   MLO_FLOAT_C (163636.904),
   MLO_FLOAT_C (163851.474),
   MLO_FLOAT_C (164066.115),
   MLO_FLOAT_C (164280.826),
   MLO_FLOAT_C (164495.607),
   MLO_FLOAT_C (164710.459),
   MLO_FLOAT_C (164925.38)
};
#endif

/*----------------------------------------------------------------------
|       Functions
+---------------------------------------------------------------------*/



/*
==============================================================================
Name: MLO_InvQuant_ProcessChannel
Description:
   Does the inverse quantisation of the spectral data.
   Computes the power table the first time it is called.
   Ref:
      4.6.1.3
Input/output parameters:
	- ics_ptr: Channel data to process. Coefficients are still interleaved.
==============================================================================
*/

void  MLO_InvQuant_ProcessChannel (MLO_IndivChnStream *ics_ptr)
{
   MLO_ASSERT (ics_ptr != NULL);

   MLO_InvQuant_DoInverseQuantisation (
      &ics_ptr->coef_arr [0],
      &ics_ptr->data [0],
      MLO_DEFS_FRAME_LEN_LONG
   );
}



void  MLO_InvQuant_DoInverseQuantisation (MLO_Float coef_arr [], const MLO_Int16 data_arr [], long len)
{
   int            pos;

   MLO_ASSERT (coef_arr != NULL);
   MLO_ASSERT (data_arr != NULL);
   MLO_ASSERT (len > 0);
   MLO_ASSERT (len <= MLO_DEFS_FRAME_LEN_LONG);

   for (pos = 0; pos < len; ++pos)
   {
      MLO_Float      invquant;
      const int      quant = data_arr [pos];

      if (quant < 0)
      {
         invquant = MLO_Float_Neg (MLO_InvQuant_ComputePow43 (-quant));
      }
      else
      {
         invquant = MLO_InvQuant_ComputePow43 (quant);
      }

      coef_arr [pos] = invquant;
   }
}



/*
==============================================================================
Name: MLO_InvQuant_ComputePow43
Description:
   Inverse-quantise the absolute value of the coefficient by raising it to
   the power 4/3.
   Uses a table and interpolate it linearly (for the largest values)
   Requires the table to be already built.
   Ref:
      4.6.1.3
Input parameters:
	- quant: absolute value of the quantised coefficient, range [0 ; 8191]
Returns: The absolute value of the original coefficient, range [0 ; 165113.49]
==============================================================================
*/

MLO_Float   MLO_InvQuant_ComputePow43 (int quant)
{
   MLO_Float      invquant;

   MLO_ASSERT (quant >= 0);
   MLO_ASSERT (quant <= 8191);

#if defined(MLO_CONFIG_FULL_POW_4_3_TABLE)
    invquant = MLO_InvQuant_table_pow43[quant];
#else

#if defined (MLO_CONFIG_FIXED)

	if (quant < (int)MLO_ARRAY_SIZE (MLO_InvQuant_table_pow43))
	{
      invquant = MLO_InvQuant_table_pow43 [quant] >> 4;
	}
	else
	{
		const int         t = quant & 7;
		const int         k = quant >> 3;
		const MLO_Float   r0 = MLO_InvQuant_table_pow43 [k    ];
		const MLO_Float   r1 = MLO_InvQuant_table_pow43 [k + 1];
		invquant = MLO_Float_Lerp (r0, r1, t, 3);

      MLO_ASSERT (k + 1 < (int)MLO_ARRAY_SIZE (MLO_InvQuant_table_pow43));
   }

#else

	if (quant < (int)MLO_ARRAY_SIZE (MLO_InvQuant_table_pow43))
	{
		invquant = MLO_Float_Mul (
         MLO_InvQuant_table_pow43 [quant],
         MLO_FLOAT_C (1.0f / 16)
      );
	}
	else
	{
		const MLO_Float   t = MLO_Float_MulInt (MLO_FLOAT_C (1.0 / 8), quant & 7);
		const int         k = quant >> 3;
		const MLO_Float   r0 = MLO_InvQuant_table_pow43 [k    ];
		const MLO_Float   r1 = MLO_InvQuant_table_pow43 [k + 1];
      const MLO_Float   diff = MLO_Float_Sub (r1, r0);
		invquant = MLO_Float_Add (r0, MLO_Float_Mul (diff, t));

      MLO_ASSERT (k + 1 < (int)MLO_ARRAY_SIZE (MLO_InvQuant_table_pow43));
   }
#endif

#endif

   MLO_ASSERT (invquant >= 0);

   return (invquant);
}
